import "pkl:test"

class Person {
  name: String
  age: Int
}

typealias Email = String

local renderer = new PcfRenderer {}

res1 = renderer.renderValue(123)
res2 = renderer.renderValue(1.23)
res3 = renderer.renderValue(false)
res4 = renderer.renderValue("pigeon")
res5 = renderer.renderValue(List("pigeon", "parrot"))
res6 = renderer.renderValue(Set("pigeon", "parrot"))
res7 = renderer.renderValue(Map("name", "pigeon", "age", 42))
res8 = renderer.renderValue(new Listing { "pigeon"; "parrot" })
res9 = renderer.renderValue(new Mapping { ["name"] = "pigeon"; ["age"] = 42 })
res10 = renderer.renderValue(new Dynamic { name = "pigeon"; age = 42 })
res11 = renderer.renderValue(new Person { name = "pigeon"; age = 42 })
res12 = renderer.renderValue(1.min)
res13 = renderer.renderValue(1.mb)
res14 = renderer.renderValue(null)
res15 = renderer.renderValue(Pair(1, 2))
res16 = renderer.renderValue(IntSeq(1, 4))
res17 = renderer.renderValue(IntSeq(1, 4).step(-2))
res18 = renderer.renderValue(Regex("a.*b"))

res19 = test.catch(() -> renderer.renderValue(Person))
res20 = test.catch(() -> renderer.renderValue(Email))
res21 = test.catch(() -> renderer.renderValue((x) -> x))
res22 = test.catch(() -> new PcfRenderer { converters { [Int] = (_) -> throw("ouch") } }.renderValue(42))
