/* Generated by re2c 0.13.6 on Mon May  4 14:07:41 2015 */
// 1 "scanner.re"

/*
  +------------------------------------------------------------------------+
  | Phalcon Framework                                                      |
  +------------------------------------------------------------------------+
  | Copyright (c) 2011-2014 Phalcon Team (http://www.phalconphp.com)       |
  +------------------------------------------------------------------------+
  | This source file is subject to the New BSD License that is bundled     |
  | with this package in the file docs/LICENSE.txt.                        |
  |                                                                        |
  | If you did not receive a copy of the license and are unable to         |
  | obtain it through the world-wide-web, please send an email             |
  | to license@phalconphp.com so we can send you a copy immediately.       |
  +------------------------------------------------------------------------+
  | Authors: Andres Gutierrez <andres@phalconphp.com>                      |
  |          Eduar Carvajal <eduar@phalconphp.com>                         |
  +------------------------------------------------------------------------+
*/

#include "php_phalcon.h"
#include "scanner.h"

#define VVCTYPE unsigned char
#define VVCURSOR (s->start)
#define VVLIMIT (s->end)
#define VVMARKER q

void phvolt_rtrim(phvolt_scanner_token *token) {

	char *cursor, *removed_str;
	int i;
	char ch;

	if (token->len > 0) {

		cursor = token->value;
		cursor += (token->len - 1);
		for (i = token->len; i > 0; i--) {
			ch = (*cursor);
			if (ch == '\t' || ch == '\n' || ch == '\r' || ch == ' ' || ch == '\v') {
				cursor--;
				continue;
			}
			break;
		}

        if (i >= 0) {
    		removed_str = emalloc(i + 1);
    		memcpy(removed_str, token->value, i);
    		removed_str[i] = '\0';

    		efree(token->value);
    		token->value = removed_str;
    		token->len = i;
        }
	}

}

void phvolt_ltrim(phvolt_scanner_token *token) {

	char *cursor, *removed_str;
	int i;

	if (token->len > 0) {

		cursor = token->value;
		for (i = 0; i < token->len; i++) {
			char ch = (*cursor);
			if (ch == '\t' || ch == '\n' || ch == '\r' || ch == ' ' || ch == '\v') {
				cursor++;
				continue;
			}
			break;
		}

        if (i >= 0) {
    		removed_str = emalloc(token->len - i + 1);
    		memcpy(removed_str, token->value + i, token->len - i);
    		removed_str[token->len - i] = '\0';

    		efree(token->value);
    		token->value = removed_str;
    		token->len = token->len - i;
        }
	}

}

int phvolt_get_token(phvolt_scanner_state *s, phvolt_scanner_token *token) {

	unsigned char next, double_next;
	char *q = VVCURSOR, *start = VVCURSOR;
	int status = PHVOLT_SCANNER_RETCODE_IMPOSSIBLE;

	while (PHVOLT_SCANNER_RETCODE_IMPOSSIBLE == status) {

		if (s->mode == PHVOLT_MODE_RAW || s->mode == PHVOLT_MODE_COMMENT) {

			next = '\0';
			double_next = '\0';

			if (*VVCURSOR == '\n') {
				s->active_line++;
			}

			if (*VVCURSOR != '\0') {
				next = *(VVCURSOR + 1);
				if (next != '\0') {
					double_next = *(VVCURSOR + 2);
				}
			}

			if (*VVCURSOR == '\0' || (*VVCURSOR == '{' && (next == '%' || next == '{' || next == '#'))) {

				if (next != '#') {

					s->mode = PHVOLT_MODE_CODE;

					if (s->raw_buffer_cursor > 0) {

						token->opcode = PHVOLT_T_RAW_FRAGMENT;
						token->value = emalloc(sizeof(char) * s->raw_buffer_cursor + 1);
						memcpy(token->value, s->raw_buffer, s->raw_buffer_cursor);
						token->value[s->raw_buffer_cursor] = 0;
						token->len = s->raw_buffer_cursor;

						if (s->whitespace_control == 1) {
							phvolt_ltrim(token);
							s->whitespace_control = 0;
						}

						if (double_next == '-') {
							phvolt_rtrim(token);
						}

						s->raw_buffer_cursor = 0;
						q = VVCURSOR;
					} else {
						token->opcode = PHVOLT_T_IGNORE;
					}

				} else {

					while ((next = *(++VVCURSOR))) {
						if (next == '#' && *(VVCURSOR + 1) == '}') {
							VVCURSOR+=2;
							token->opcode = PHVOLT_T_IGNORE;
							return 0;
						} else {
							if (next == '\n') {
								s->active_line++;
							}
						}
					}

					return PHVOLT_SCANNER_RETCODE_EOF;
				}

				return 0;

			} else {

				if (s->raw_buffer_cursor == s->raw_buffer_size) {
					s->raw_buffer_size += PHVOLT_RAW_BUFFER_SIZE;
					s->raw_buffer = erealloc(s->raw_buffer, s->raw_buffer_size);
				}

				memcpy(s->raw_buffer+s->raw_buffer_cursor, VVCURSOR, 1);
				s->raw_buffer_cursor++;

				++VVCURSOR;
			}

		} else {

		
// 181 "scanner.c"
		{
			VVCTYPE vvch;
			unsigned int vvaccept = 0;

			vvch = *VVCURSOR;
			switch (vvch) {
			case 0x00:	goto vv71;
			case '\t':
			case '\r':
			case ' ':	goto vv67;
			case '\n':	goto vv69;
			case '!':	goto vv59;
			case '"':	goto vv28;
			case '%':	goto vv22;
			case '\'':	goto vv30;
			case '(':	goto vv45;
			case ')':	goto vv47;
			case '*':	goto vv35;
			case '+':	goto vv33;
			case ',':	goto vv43;
			case '-':	goto vv24;
			case '.':	goto vv41;
			case '/':	goto vv37;
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':	goto vv2;
			case ':':	goto vv63;
			case '<':	goto vv53;
			case '=':	goto vv55;
			case '>':	goto vv57;
			case '?':	goto vv65;
			case 'A':
			case 'a':	goto vv12;
			case 'B':
			case 'b':	goto vv14;
			case 'C':
			case 'c':	goto vv16;
			case 'D':
			case 'd':	goto vv19;
			case 'E':
			case 'e':	goto vv7;
			case 'F':
			case 'f':	goto vv8;
			case 'G':
			case 'H':
			case 'J':
			case 'K':
			case 'L':
			case 'P':
			case 'Q':
			case 'U':
			case 'V':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'g':
			case 'h':
			case 'j':
			case 'k':
			case 'l':
			case 'p':
			case 'q':
			case 'u':
			case 'v':
			case 'x':
			case 'y':
			case 'z':	goto vv32;
			case 'I':	goto vv4;
			case 'M':
			case 'm':	goto vv15;
			case 'N':
			case 'n':	goto vv10;
			case 'O':
			case 'o':	goto vv13;
			case 'R':
			case 'r':	goto vv18;
			case 'S':
			case 's':	goto vv9;
			case 'T':
			case 't':	goto vv11;
			case 'W':
			case 'w':	goto vv17;
			case '[':	goto vv49;
			case '\\':	goto vv31;
			case ']':	goto vv51;
			case 'i':	goto vv6;
			case '{':	goto vv20;
			case '|':	goto vv61;
			case '}':	goto vv26;
			case '~':	goto vv39;
			default:	goto vv73;
			}
vv2:
			vvaccept = 0;
			vvch = *(VVMARKER = ++VVCURSOR);
			goto vv341;
vv3:
// 182 "scanner.re"
			{
			token->opcode = PHVOLT_T_INTEGER;
			token->value = estrndup(start, VVCURSOR - start);
			token->len = VVCURSOR - start;
			q = VVCURSOR;
			return 0;
		}
// 295 "scanner.c"
vv4:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case 'F':
			case 'f':	goto vv303;
			case 'N':
			case 'n':	goto vv305;
			case 'S':
			case 's':	goto vv307;
			case 'T':
			case 't':	goto vv309;
			default:	goto vv101;
			}
vv5:
// 495 "scanner.re"
			{
			token->opcode = PHVOLT_T_IDENTIFIER;
			token->value = estrndup(start, VVCURSOR - start);
			token->len = VVCURSOR - start;
			q = VVCURSOR;
			return 0;
		}
// 318 "scanner.c"
vv6:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'F':
			case 'f':	goto vv303;
			case 'N':
			case 'n':	goto vv305;
			case 'S':	goto vv307;
			case 'T':
			case 't':	goto vv309;
			case 's':	goto vv310;
			default:	goto vv101;
			}
vv7:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'L':
			case 'l':	goto vv235;
			case 'M':
			case 'm':	goto vv236;
			case 'N':
			case 'n':	goto vv237;
			case 'V':
			case 'v':	goto vv238;
			case 'X':
			case 'x':	goto vv239;
			default:	goto vv101;
			}
vv8:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'A':
			case 'a':	goto vv227;
			case 'O':
			case 'o':	goto vv228;
			default:	goto vv101;
			}
vv9:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'C':
			case 'c':	goto vv218;
			case 'E':
			case 'e':	goto vv219;
			default:	goto vv101;
			}
vv10:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'O':
			case 'o':	goto vv205;
			case 'U':
			case 'u':	goto vv206;
			default:	goto vv101;
			}
vv11:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'R':
			case 'r':	goto vv201;
			default:	goto vv101;
			}
vv12:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'N':
			case 'n':	goto vv188;
			case 'U':
			case 'u':	goto vv189;
			default:	goto vv101;
			}
vv13:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'D':
			case 'd':	goto vv183;
			case 'R':
			case 'r':	goto vv184;
			default:	goto vv101;
			}
vv14:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'L':
			case 'l':	goto vv173;
			case 'R':
			case 'r':	goto vv174;
			default:	goto vv101;
			}
vv15:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'A':
			case 'a':	goto vv168;
			default:	goto vv101;
			}
vv16:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'A':
			case 'a':	goto vv152;
			case 'O':
			case 'o':	goto vv153;
			default:	goto vv101;
			}
vv17:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'I':
			case 'i':	goto vv148;
			default:	goto vv101;
			}
vv18:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'E':
			case 'e':	goto vv142;
			default:	goto vv101;
			}
vv19:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'E':
			case 'e':	goto vv133;
			case 'O':
			case 'o':	goto vv134;
			default:	goto vv101;
			}
vv20:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '%':	goto vv127;
			case '{':	goto vv125;
			default:	goto vv21;
			}
vv21:
// 578 "scanner.re"
			{
			token->opcode = PHVOLT_T_CBRACKET_OPEN;
			return 0;
		}
// 460 "scanner.c"
vv22:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '}':	goto vv123;
			default:	goto vv23;
			}
vv23:
// 523 "scanner.re"
			{
			token->opcode = PHVOLT_T_MOD;
			return 0;
		}
// 473 "scanner.c"
vv24:
			vvaccept = 1;
			vvch = *(VVMARKER = ++VVCURSOR);
			switch (vvch) {
			case '%':	goto vv118;
			case '-':	goto vv115;
			case '=':	goto vv113;
			case '}':	goto vv117;
			default:	goto vv25;
			}
vv25:
// 508 "scanner.re"
			{
			token->opcode = PHVOLT_T_SUB;
			return 0;
		}
// 490 "scanner.c"
vv26:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '}':	goto vv111;
			default:	goto vv27;
			}
vv27:
// 583 "scanner.re"
			{
			token->opcode = PHVOLT_T_CBRACKET_CLOSE;
			return 0;
		}
// 503 "scanner.c"
vv28:
			vvaccept = 2;
			vvch = *(VVMARKER = ++VVCURSOR);
			if (vvch >= 0x01) goto vv109;
vv29:
// 694 "scanner.re"
			{
			status = PHVOLT_SCANNER_RETCODE_ERR;
			break;
		}
// 514 "scanner.c"
vv30:
			vvaccept = 2;
			vvch = *(VVMARKER = ++VVCURSOR);
			if (vvch <= 0x00) goto vv29;
			goto vv103;
vv31:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv29;
			}
vv32:
			vvch = *++VVCURSOR;
			goto vv101;
vv33:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '+':	goto vv98;
			case '=':	goto vv96;
			default:	goto vv34;
			}
vv34:
// 503 "scanner.re"
			{
			token->opcode = PHVOLT_T_ADD;
			return 0;
		}
// 594 "scanner.c"
vv35:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '=':	goto vv94;
			default:	goto vv36;
			}
vv36:
// 513 "scanner.re"
			{
			token->opcode = PHVOLT_T_MUL;
			return 0;
		}
// 607 "scanner.c"
vv37:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '=':	goto vv92;
			default:	goto vv38;
			}
vv38:
// 518 "scanner.re"
			{
			token->opcode = PHVOLT_T_DIV;
			return 0;
		}
// 620 "scanner.c"
vv39:
			++VVCURSOR;
// 538 "scanner.re"
			{
			token->opcode = PHVOLT_T_CONCAT;
			return 0;
		}
// 628 "scanner.c"
vv41:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '.':	goto vv90;
			default:	goto vv42;
			}
vv42:
// 548 "scanner.re"
			{
			token->opcode = PHVOLT_T_DOT;
			return 0;
		}
// 641 "scanner.c"
vv43:
			++VVCURSOR;
// 553 "scanner.re"
			{
			token->opcode = PHVOLT_T_COMMA;
			return 0;
		}
// 649 "scanner.c"
vv45:
			++VVCURSOR;
// 558 "scanner.re"
			{
			token->opcode = PHVOLT_T_PARENTHESES_OPEN;
			return 0;
		}
// 657 "scanner.c"
vv47:
			++VVCURSOR;
// 563 "scanner.re"
			{
			token->opcode = PHVOLT_T_PARENTHESES_CLOSE;
			return 0;
		}
// 665 "scanner.c"
vv49:
			++VVCURSOR;
// 568 "scanner.re"
			{
			token->opcode = PHVOLT_T_SBRACKET_OPEN;
			return 0;
		}
// 673 "scanner.c"
vv51:
			++VVCURSOR;
// 573 "scanner.re"
			{
			token->opcode = PHVOLT_T_SBRACKET_CLOSE;
			return 0;
		}
// 681 "scanner.c"
vv53:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '=':	goto vv88;
			case '>':	goto vv86;
			default:	goto vv54;
			}
vv54:
// 653 "scanner.re"
			{
			token->opcode = PHVOLT_T_LESS;
			return 0;
		}
// 695 "scanner.c"
vv55:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '=':	goto vv82;
			default:	goto vv56;
			}
vv56:
// 593 "scanner.re"
			{
			token->opcode = PHVOLT_T_ASSIGN;
			return 0;
		}
// 708 "scanner.c"
vv57:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '=':	goto vv80;
			default:	goto vv58;
			}
vv58:
// 658 "scanner.re"
			{
			token->opcode = PHVOLT_T_GREATER;
			return 0;
		}
// 721 "scanner.c"
vv59:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '=':	goto vv76;
			default:	goto vv60;
			}
vv60:
// 648 "scanner.re"
			{
			token->opcode = PHVOLT_T_NOT;
			return 0;
		}
// 734 "scanner.c"
vv61:
			++VVCURSOR;
// 663 "scanner.re"
			{
			token->opcode = PHVOLT_T_PIPE;
			return 0;
		}
// 742 "scanner.c"
vv63:
			++VVCURSOR;
// 668 "scanner.re"
			{
			token->opcode = PHVOLT_T_COLON;
			return 0;
		}
// 750 "scanner.c"
vv65:
			++VVCURSOR;
// 673 "scanner.re"
			{
			token->opcode = PHVOLT_T_QUESTION;
			return 0;
		}
// 758 "scanner.c"
vv67:
			++VVCURSOR;
			vvch = *VVCURSOR;
			goto vv75;
vv68:
// 678 "scanner.re"
			{
			token->opcode = PHVOLT_T_IGNORE;
			return 0;
		}
// 769 "scanner.c"
vv69:
			++VVCURSOR;
// 683 "scanner.re"
			{
			s->active_line++;
			token->opcode = PHVOLT_T_IGNORE;
			return 0;
		}
// 778 "scanner.c"
vv71:
			++VVCURSOR;
// 689 "scanner.re"
			{
			status = PHVOLT_SCANNER_RETCODE_EOF;
			break;
		}
// 786 "scanner.c"
vv73:
			vvch = *++VVCURSOR;
			goto vv29;
vv74:
			++VVCURSOR;
			vvch = *VVCURSOR;
vv75:
			switch (vvch) {
			case '\t':
			case '\r':
			case ' ':	goto vv74;
			default:	goto vv68;
			}
vv76:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '=':	goto vv78;
			default:	goto vv77;
			}
vv77:
// 628 "scanner.re"
			{
			token->opcode = PHVOLT_T_NOTEQUALS;
			return 0;
		}
// 812 "scanner.c"
vv78:
			++VVCURSOR;
// 643 "scanner.re"
			{
			token->opcode = PHVOLT_T_NOTIDENTICAL;
			return 0;
		}
// 820 "scanner.c"
vv80:
			++VVCURSOR;
// 618 "scanner.re"
			{
			token->opcode = PHVOLT_T_GREATEREQUAL;
			return 0;
		}
// 828 "scanner.c"
vv82:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '=':	goto vv84;
			default:	goto vv83;
			}
vv83:
// 623 "scanner.re"
			{
			token->opcode = PHVOLT_T_EQUALS;
			return 0;
		}
// 841 "scanner.c"
vv84:
			++VVCURSOR;
// 638 "scanner.re"
			{
			token->opcode = PHVOLT_T_IDENTICAL;
			return 0;
		}
// 849 "scanner.c"
vv86:
			++VVCURSOR;
// 633 "scanner.re"
			{
			token->opcode = PHVOLT_T_NOTEQUALS;
			return 0;
		}
// 857 "scanner.c"
vv88:
			++VVCURSOR;
// 588 "scanner.re"
			{
			token->opcode = PHVOLT_T_LESSEQUAL;
			return 0;
		}
// 865 "scanner.c"
vv90:
			++VVCURSOR;
// 543 "scanner.re"
			{
			token->opcode = PHVOLT_T_RANGE;
			return 0;
		}
// 873 "scanner.c"
vv92:
			++VVCURSOR;
// 613 "scanner.re"
			{
			token->opcode = PHVOLT_T_DIV_ASSIGN;
			return 0;
		}
// 881 "scanner.c"
vv94:
			++VVCURSOR;
// 608 "scanner.re"
			{
			token->opcode = PHVOLT_T_MUL_ASSIGN;
			return 0;
		}
// 889 "scanner.c"
vv96:
			++VVCURSOR;
// 598 "scanner.re"
			{
			token->opcode = PHVOLT_T_ADD_ASSIGN;
			return 0;
		}
// 897 "scanner.c"
vv98:
			++VVCURSOR;
// 528 "scanner.re"
			{
			token->opcode = PHVOLT_T_INCR;
			return 0;
		}
// 905 "scanner.c"
vv100:
			++VVCURSOR;
			vvch = *VVCURSOR;
vv101:
			switch (vvch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv5;
			}
vv102:
			++VVCURSOR;
			vvch = *VVCURSOR;
vv103:
			switch (vvch) {
			case 0x00:	goto vv104;
			case '\'':	goto vv106;
			case '\\':	goto vv105;
			default:	goto vv102;
			}
vv104:
			VVCURSOR = VVMARKER;
			switch (vvaccept) {
			case 0: 	goto vv3;
			case 1: 	goto vv25;
			case 2: 	goto vv29;
			default:	goto vv308;
			}
vv105:
			++VVCURSOR;
			vvch = *VVCURSOR;
			switch (vvch) {
			case '\n':	goto vv104;
			default:	goto vv102;
			}
vv106:
			++VVCURSOR;
// 486 "scanner.re"
			{
			token->opcode = PHVOLT_T_STRING;
			token->value = estrndup(q, VVCURSOR - q - 1);
			token->len = VVCURSOR - q - 1;
			q = VVCURSOR;
			return 0;
		}
// 1012 "scanner.c"
vv108:
			++VVCURSOR;
			vvch = *VVCURSOR;
vv109:
			switch (vvch) {
			case 0x00:	goto vv104;
			case '"':	goto vv106;
			case '\\':	goto vv110;
			default:	goto vv108;
			}
vv110:
			++VVCURSOR;
			vvch = *VVCURSOR;
			switch (vvch) {
			case '\n':	goto vv104;
			default:	goto vv108;
			}
vv111:
			++VVCURSOR;
// 465 "scanner.re"
			{
			s->mode = PHVOLT_MODE_RAW;
			token->opcode = PHVOLT_T_CLOSE_EDELIMITER;
			return 0;
		}
// 1038 "scanner.c"
vv113:
			++VVCURSOR;
// 603 "scanner.re"
			{
			token->opcode = PHVOLT_T_SUB_ASSIGN;
			return 0;
		}
// 1046 "scanner.c"
vv115:
			++VVCURSOR;
// 533 "scanner.re"
			{
			token->opcode = PHVOLT_T_DECR;
			return 0;
		}
// 1054 "scanner.c"
vv117:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '}':	goto vv121;
			default:	goto vv104;
			}
vv118:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '}':	goto vv119;
			default:	goto vv104;
			}
vv119:
			++VVCURSOR;
// 451 "scanner.re"
			{
			s->mode = PHVOLT_MODE_RAW;
			s->whitespace_control = 1;
			token->opcode = PHVOLT_T_CLOSE_DELIMITER;
			return 0;
		}
// 1076 "scanner.c"
vv121:
			++VVCURSOR;
// 478 "scanner.re"
			{
			s->mode = PHVOLT_MODE_RAW;
			s->whitespace_control = 1;
			token->opcode = PHVOLT_T_CLOSE_EDELIMITER;
			return 0;
		}
// 1086 "scanner.c"
vv123:
			++VVCURSOR;
// 439 "scanner.re"
			{
			s->mode = PHVOLT_MODE_RAW;
			token->opcode = PHVOLT_T_CLOSE_DELIMITER;
			return 0;
		}
// 1095 "scanner.c"
vv125:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '-':	goto vv131;
			default:	goto vv126;
			}
vv126:
// 458 "scanner.re"
			{
			s->whitespace_control = 0;
			s->statement_position++;
			token->opcode = PHVOLT_T_OPEN_EDELIMITER;
			return 0;
		}
// 1110 "scanner.c"
vv127:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '-':	goto vv129;
			default:	goto vv128;
			}
vv128:
// 433 "scanner.re"
			{
			s->whitespace_control = 0;
			token->opcode = PHVOLT_T_OPEN_DELIMITER;
			return 0;
		}
// 1124 "scanner.c"
vv129:
			++VVCURSOR;
// 445 "scanner.re"
			{
			s->whitespace_control = 0;
			token->opcode = PHVOLT_T_OPEN_DELIMITER;
			return 0;
		}
// 1133 "scanner.c"
vv131:
			++VVCURSOR;
// 471 "scanner.re"
			{
			s->whitespace_control = 0;
			s->statement_position++;
			token->opcode = PHVOLT_T_OPEN_EDELIMITER;
			return 0;
		}
// 1143 "scanner.c"
vv133:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'F':
			case 'f':	goto vv136;
			default:	goto vv101;
			}
vv134:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv135;
			}
vv135:
// 403 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_DO;
			return 0;
		}
// 1227 "scanner.c"
vv136:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'I':
			case 'i':	goto vv137;
			default:	goto vv101;
			}
vv137:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'N':
			case 'n':	goto vv138;
			default:	goto vv101;
			}
vv138:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'E':
			case 'e':	goto vv139;
			default:	goto vv101;
			}
vv139:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'D':
			case 'd':	goto vv140;
			default:	goto vv101;
			}
vv140:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv141;
			}
vv141:
// 344 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_DEFINED;
			return 0;
		}
// 1332 "scanner.c"
vv142:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'T':
			case 't':	goto vv143;
			default:	goto vv101;
			}
vv143:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'U':
			case 'u':	goto vv144;
			default:	goto vv101;
			}
vv144:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'R':
			case 'r':	goto vv145;
			default:	goto vv101;
			}
vv145:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'N':
			case 'n':	goto vv146;
			default:	goto vv101;
			}
vv146:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv147;
			}
vv147:
// 309 "scanner.re"
			{
			token->opcode = PHVOLT_T_RETURN;
			return 0;
		}
// 1436 "scanner.c"
vv148:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'T':
			case 't':	goto vv149;
			default:	goto vv101;
			}
vv149:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'H':
			case 'h':	goto vv150;
			default:	goto vv101;
			}
vv150:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv151;
			}
vv151:
// 304 "scanner.re"
			{
			token->opcode = PHVOLT_T_WITH;
			return 0;
		}
// 1526 "scanner.c"
vv152:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'C':
			case 'c':	goto vv162;
			case 'L':
			case 'l':	goto vv161;
			default:	goto vv101;
			}
vv153:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'N':
			case 'n':	goto vv154;
			default:	goto vv101;
			}
vv154:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'T':
			case 't':	goto vv155;
			default:	goto vv101;
			}
vv155:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'I':
			case 'i':	goto vv156;
			default:	goto vv101;
			}
vv156:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'N':
			case 'n':	goto vv157;
			default:	goto vv101;
			}
vv157:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'U':
			case 'u':	goto vv158;
			default:	goto vv101;
			}
vv158:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'E':
			case 'e':	goto vv159;
			default:	goto vv101;
			}
vv159:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv160;
			}
vv160:
// 421 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_CONTINUE;
			return 0;
		}
// 1654 "scanner.c"
vv161:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'L':
			case 'l':	goto vv166;
			default:	goto vv101;
			}
vv162:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'H':
			case 'h':	goto vv163;
			default:	goto vv101;
			}
vv163:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'E':
			case 'e':	goto vv164;
			default:	goto vv101;
			}
vv164:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv165;
			}
vv165:
// 392 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_CACHE;
			return 0;
		}
// 1752 "scanner.c"
vv166:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv167;
			}
vv167:
// 293 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_CALL;
			return 0;
		}
// 1829 "scanner.c"
vv168:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'C':
			case 'c':	goto vv169;
			default:	goto vv101;
			}
vv169:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'R':
			case 'r':	goto vv170;
			default:	goto vv101;
			}
vv170:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'O':
			case 'o':	goto vv171;
			default:	goto vv101;
			}
vv171:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv172;
			}
vv172:
// 282 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_MACRO;
			return 0;
		}
// 1927 "scanner.c"
vv173:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'O':
			case 'o':	goto vv179;
			default:	goto vv101;
			}
vv174:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'E':
			case 'e':	goto vv175;
			default:	goto vv101;
			}
vv175:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'A':
			case 'a':	goto vv176;
			default:	goto vv101;
			}
vv176:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'K':
			case 'k':	goto vv177;
			default:	goto vv101;
			}
vv177:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv178;
			}
vv178:
// 427 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_BREAK;
			return 0;
		}
// 2032 "scanner.c"
vv179:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'C':
			case 'c':	goto vv180;
			default:	goto vv101;
			}
vv180:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'K':
			case 'k':	goto vv181;
			default:	goto vv101;
			}
vv181:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv182;
			}
vv182:
// 271 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_BLOCK;
			return 0;
		}
// 2123 "scanner.c"
vv183:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'D':
			case 'd':	goto vv186;
			default:	goto vv101;
			}
vv184:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv185;
			}
vv185:
// 266 "scanner.re"
			{
			token->opcode = PHVOLT_T_OR;
			return 0;
		}
// 2206 "scanner.c"
vv186:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv187;
			}
vv187:
// 368 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_ODD;
			return 0;
		}
// 2283 "scanner.c"
vv188:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'D':
			case 'd':	goto vv199;
			default:	goto vv101;
			}
vv189:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'T':
			case 't':	goto vv190;
			default:	goto vv101;
			}
vv190:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'O':
			case 'o':	goto vv191;
			default:	goto vv101;
			}
vv191:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'E':
			case 'e':	goto vv192;
			default:	goto vv101;
			}
vv192:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'S':
			case 's':	goto vv193;
			default:	goto vv101;
			}
vv193:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'C':
			case 'c':	goto vv194;
			default:	goto vv101;
			}
vv194:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'A':
			case 'a':	goto vv195;
			default:	goto vv101;
			}
vv195:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'P':
			case 'p':	goto vv196;
			default:	goto vv101;
			}
vv196:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'E':
			case 'e':	goto vv197;
			default:	goto vv101;
			}
vv197:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv198;
			}
vv198:
// 409 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_AUTOESCAPE;
			return 0;
		}
// 2423 "scanner.c"
vv199:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv200;
			}
vv200:
// 261 "scanner.re"
			{
			token->opcode = PHVOLT_T_AND;
			return 0;
		}
// 2499 "scanner.c"
vv201:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'U':
			case 'u':	goto vv202;
			default:	goto vv101;
			}
vv202:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'E':
			case 'e':	goto vv203;
			default:	goto vv101;
			}
vv203:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv204;
			}
vv204:
// 256 "scanner.re"
			{
			token->opcode = PHVOLT_T_TRUE;
			return 0;
		}
// 2589 "scanner.c"
vv205:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'T':
			case 't':	goto vv216;
			default:	goto vv101;
			}
vv206:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'L':
			case 'l':	goto vv207;
			case 'M':
			case 'm':	goto vv208;
			default:	goto vv101;
			}
vv207:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'L':
			case 'l':	goto vv214;
			default:	goto vv101;
			}
vv208:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'E':
			case 'e':	goto vv209;
			default:	goto vv101;
			}
vv209:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'R':
			case 'r':	goto vv210;
			default:	goto vv101;
			}
vv210:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'I':
			case 'i':	goto vv211;
			default:	goto vv101;
			}
vv211:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'C':
			case 'c':	goto vv212;
			default:	goto vv101;
			}
vv212:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv213;
			}
vv213:
// 374 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_NUMERIC;
			return 0;
		}
// 2717 "scanner.c"
vv214:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv215;
			}
vv215:
// 246 "scanner.re"
			{
			token->opcode = PHVOLT_T_NULL;
			return 0;
		}
// 2793 "scanner.c"
vv216:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv217;
			}
vv217:
// 338 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_NOT;
			return 0;
		}
// 2870 "scanner.c"
vv218:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'A':
			case 'a':	goto vv222;
			default:	goto vv101;
			}
vv219:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'T':
			case 't':	goto vv220;
			default:	goto vv101;
			}
vv220:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv221;
			}
vv221:
// 241 "scanner.re"
			{
			token->opcode = PHVOLT_T_SET;
			return 0;
		}
// 2960 "scanner.c"
vv222:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'L':
			case 'l':	goto vv223;
			default:	goto vv101;
			}
vv223:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'A':
			case 'a':	goto vv224;
			default:	goto vv101;
			}
vv224:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'R':
			case 'r':	goto vv225;
			default:	goto vv101;
			}
vv225:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv226;
			}
vv226:
// 380 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_SCALAR;
			return 0;
		}
// 3058 "scanner.c"
vv227:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'L':
			case 'l':	goto vv231;
			default:	goto vv101;
			}
vv228:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'R':
			case 'r':	goto vv229;
			default:	goto vv101;
			}
vv229:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv230;
			}
vv230:
// 225 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_FOR;
			return 0;
		}
// 3149 "scanner.c"
vv231:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'S':
			case 's':	goto vv232;
			default:	goto vv101;
			}
vv232:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'E':
			case 'e':	goto vv233;
			default:	goto vv101;
			}
vv233:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv234;
			}
vv234:
// 251 "scanner.re"
			{
			token->opcode = PHVOLT_T_FALSE;
			return 0;
		}
// 3239 "scanner.c"
vv235:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'S':
			case 's':	goto vv293;
			default:	goto vv101;
			}
vv236:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'P':
			case 'p':	goto vv289;
			default:	goto vv101;
			}
vv237:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'D':
			case 'd':	goto vv249;
			default:	goto vv101;
			}
vv238:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'E':
			case 'e':	goto vv246;
			default:	goto vv101;
			}
vv239:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'T':
			case 't':	goto vv240;
			default:	goto vv101;
			}
vv240:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'E':
			case 'e':	goto vv241;
			default:	goto vv101;
			}
vv241:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'N':
			case 'n':	goto vv242;
			default:	goto vv101;
			}
vv242:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'D':
			case 'd':	goto vv243;
			default:	goto vv101;
			}
vv243:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'S':
			case 's':	goto vv244;
			default:	goto vv101;
			}
vv244:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv245;
			}
vv245:
// 314 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_EXTENDS;
			return 0;
		}
// 3379 "scanner.c"
vv246:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'N':
			case 'n':	goto vv247;
			default:	goto vv101;
			}
vv247:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv248;
			}
vv248:
// 362 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_EVEN;
			return 0;
		}
// 3463 "scanner.c"
vv249:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'A':
			case 'a':	goto vv250;
			case 'B':
			case 'b':	goto vv251;
			case 'C':
			case 'c':	goto vv252;
			case 'F':
			case 'f':	goto vv253;
			case 'I':
			case 'i':	goto vv254;
			case 'M':
			case 'm':	goto vv255;
			default:	goto vv101;
			}
vv250:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'U':
			case 'u':	goto vv279;
			default:	goto vv101;
			}
vv251:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'L':
			case 'l':	goto vv274;
			default:	goto vv101;
			}
vv252:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'A':
			case 'a':	goto vv266;
			default:	goto vv101;
			}
vv253:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'O':
			case 'o':	goto vv263;
			default:	goto vv101;
			}
vv254:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'F':
			case 'f':	goto vv261;
			default:	goto vv101;
			}
vv255:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'A':
			case 'a':	goto vv256;
			default:	goto vv101;
			}
vv256:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'C':
			case 'c':	goto vv257;
			default:	goto vv101;
			}
vv257:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'R':
			case 'r':	goto vv258;
			default:	goto vv101;
			}
vv258:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'O':
			case 'o':	goto vv259;
			default:	goto vv101;
			}
vv259:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv260;
			}
vv260:
// 288 "scanner.re"
			{
			token->opcode = PHVOLT_T_ENDMACRO;
			return 0;
		}
// 3619 "scanner.c"
vv261:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv262;
			}
vv262:
// 220 "scanner.re"
			{
			token->opcode = PHVOLT_T_ENDIF;
			return 0;
		}
// 3695 "scanner.c"
vv263:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'R':
			case 'r':	goto vv264;
			default:	goto vv101;
			}
vv264:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv265;
			}
vv265:
// 231 "scanner.re"
			{
			token->opcode = PHVOLT_T_ENDFOR;
			return 0;
		}
// 3778 "scanner.c"
vv266:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'C':
			case 'c':	goto vv267;
			case 'L':
			case 'l':	goto vv268;
			default:	goto vv101;
			}
vv267:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'H':
			case 'h':	goto vv271;
			default:	goto vv101;
			}
vv268:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'L':
			case 'l':	goto vv269;
			default:	goto vv101;
			}
vv269:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv270;
			}
vv270:
// 299 "scanner.re"
			{
			token->opcode = PHVOLT_T_ENDCALL;
			return 0;
		}
// 3877 "scanner.c"
vv271:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'E':
			case 'e':	goto vv272;
			default:	goto vv101;
			}
vv272:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv273;
			}
vv273:
// 398 "scanner.re"
			{
			token->opcode = PHVOLT_T_ENDCACHE;
			return 0;
		}
// 3960 "scanner.c"
vv274:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'O':
			case 'o':	goto vv275;
			default:	goto vv101;
			}
vv275:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'C':
			case 'c':	goto vv276;
			default:	goto vv101;
			}
vv276:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'K':
			case 'k':	goto vv277;
			default:	goto vv101;
			}
vv277:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv278;
			}
vv278:
// 277 "scanner.re"
			{
			token->opcode = PHVOLT_T_ENDBLOCK;
			return 0;
		}
// 4057 "scanner.c"
vv279:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'T':
			case 't':	goto vv280;
			default:	goto vv101;
			}
vv280:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'O':
			case 'o':	goto vv281;
			default:	goto vv101;
			}
vv281:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'E':
			case 'e':	goto vv282;
			default:	goto vv101;
			}
vv282:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'S':
			case 's':	goto vv283;
			default:	goto vv101;
			}
vv283:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'C':
			case 'c':	goto vv284;
			default:	goto vv101;
			}
vv284:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'A':
			case 'a':	goto vv285;
			default:	goto vv101;
			}
vv285:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'P':
			case 'p':	goto vv286;
			default:	goto vv101;
			}
vv286:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'E':
			case 'e':	goto vv287;
			default:	goto vv101;
			}
vv287:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv288;
			}
vv288:
// 415 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_ENDAUTOESCAPE;
			return 0;
		}
// 4190 "scanner.c"
vv289:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'T':
			case 't':	goto vv290;
			default:	goto vv101;
			}
vv290:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'Y':
			case 'y':	goto vv291;
			default:	goto vv101;
			}
vv291:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv292;
			}
vv292:
// 356 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_EMPTY;
			return 0;
		}
// 4281 "scanner.c"
vv293:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'E':
			case 'e':	goto vv294;
			default:	goto vv101;
			}
vv294:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'G':
			case 'H':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'g':
			case 'h':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			case 'F':
			case 'f':	goto vv296;
			case 'I':
			case 'i':	goto vv297;
			default:	goto vv295;
			}
vv295:
// 205 "scanner.re"
			{
			token->opcode = PHVOLT_T_ELSE;
			return 0;
		}
// 4364 "scanner.c"
vv296:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'O':
			case 'o':	goto vv300;
			default:	goto vv101;
			}
vv297:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'F':
			case 'f':	goto vv298;
			default:	goto vv101;
			}
vv298:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv299;
			}
vv299:
// 215 "scanner.re"
			{
			token->opcode = PHVOLT_T_ELSEIF;
			return 0;
		}
// 4454 "scanner.c"
vv300:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'R':
			case 'r':	goto vv301;
			default:	goto vv101;
			}
vv301:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv302;
			}
vv302:
// 210 "scanner.re"
			{
			token->opcode = PHVOLT_T_ELSEFOR;
			return 0;
		}
// 4537 "scanner.c"
vv303:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv304;
			}
vv304:
// 199 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_IF;
			return 0;
		}
// 4614 "scanner.c"
vv305:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			case 'C':
			case 'c':	goto vv333;
			default:	goto vv306;
			}
vv306:
// 236 "scanner.re"
			{
			token->opcode = PHVOLT_T_IN;
			return 0;
		}
// 4690 "scanner.c"
vv307:
			vvaccept = 3;
			vvch = *(VVMARKER = ++VVCURSOR);
			switch (vvch) {
			case ' ':	goto vv332;
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv308;
			}
vv308:
// 332 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_IS;
			return 0;
		}
// 4769 "scanner.c"
vv309:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'E':
			case 'e':	goto vv325;
			default:	goto vv101;
			}
vv310:
			vvaccept = 3;
			vvch = *(VVMARKER = ++VVCURSOR);
			switch (vvch) {
			case ' ':	goto vv311;
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv308;
			}
vv311:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'N':	goto vv315;
			case 'n':	goto vv312;
			default:	goto vv314;
			}
vv312:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'O':	goto vv316;
			case 'o':	goto vv323;
			default:	goto vv104;
			}
vv313:
			++VVCURSOR;
			vvch = *VVCURSOR;
vv314:
			switch (vvch) {
			case ' ':	goto vv313;
			case 'n':	goto vv319;
			default:	goto vv104;
			}
vv315:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'O':
			case 'o':	goto vv316;
			default:	goto vv104;
			}
vv316:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'T':
			case 't':	goto vv317;
			default:	goto vv104;
			}
vv317:
			++VVCURSOR;
vv318:
// 320 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_NOTEQUALS;
			return 0;
		}
// 4894 "scanner.c"
vv319:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'o':	goto vv320;
			default:	goto vv104;
			}
vv320:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 't':	goto vv321;
			default:	goto vv104;
			}
vv321:
			++VVCURSOR;
// 326 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_NOTEQUALS;
			return 0;
		}
// 4915 "scanner.c"
vv323:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'T':	goto vv317;
			case 't':	goto vv324;
			default:	goto vv104;
			}
vv324:
			vvch = *++VVCURSOR;
			goto vv318;
vv325:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'R':
			case 'r':	goto vv326;
			default:	goto vv101;
			}
vv326:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'A':
			case 'a':	goto vv327;
			default:	goto vv101;
			}
vv327:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'B':
			case 'b':	goto vv328;
			default:	goto vv101;
			}
vv328:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'L':
			case 'l':	goto vv329;
			default:	goto vv101;
			}
vv329:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'E':
			case 'e':	goto vv330;
			default:	goto vv101;
			}
vv330:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv331;
			}
vv331:
// 386 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_ITERABLE;
			return 0;
		}
// 5037 "scanner.c"
vv332:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'N':
			case 'n':	goto vv315;
			default:	goto vv104;
			}
vv333:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'L':
			case 'l':	goto vv334;
			default:	goto vv101;
			}
vv334:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'U':
			case 'u':	goto vv335;
			default:	goto vv101;
			}
vv335:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'D':
			case 'd':	goto vv336;
			default:	goto vv101;
			}
vv336:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case 'E':
			case 'e':	goto vv337;
			default:	goto vv101;
			}
vv337:
			++VVCURSOR;
			switch ((vvch = *VVCURSOR)) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '\\':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto vv100;
			default:	goto vv338;
			}
vv338:
// 350 "scanner.re"
			{
			s->statement_position++;
			token->opcode = PHVOLT_T_INCLUDE;
			return 0;
		}
// 5149 "scanner.c"
vv339:
			vvch = *++VVCURSOR;
			switch (vvch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':	goto vv342;
			default:	goto vv104;
			}
vv340:
			vvaccept = 0;
			VVMARKER = ++VVCURSOR;
			vvch = *VVCURSOR;
vv341:
			switch (vvch) {
			case '.':	goto vv339;
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':	goto vv340;
			default:	goto vv3;
			}
vv342:
			++VVCURSOR;
			vvch = *VVCURSOR;
			switch (vvch) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':	goto vv342;
			default:	goto vv344;
			}
vv344:
// 191 "scanner.re"
			{
			token->opcode = PHVOLT_T_DOUBLE;
			token->value = estrndup(start, VVCURSOR - start);
			token->len = VVCURSOR - start;
			q = VVCURSOR;
			return 0;
		}
// 5209 "scanner.c"
		}
// 699 "scanner.re"


		}
	}

	return status;
}
