/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.indentation;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.indentation.ArrayInitHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.AssignHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.CaseHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.CatchHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.ClassDefHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.DoWhileHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.ElseHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.ExpressionHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.FinallyHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.ForHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.IfHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.ImportHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentationCheck;
import com.puppycrawl.tools.checkstyle.checks.indentation.LabelHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.MemberDefHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.MethodCallHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.MethodDefHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.NewHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.ObjectBlockHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.PackageDefHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.SlistHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.StaticInitHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.SwitchHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.TryHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.WhileHandler;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HandlerFactory {
    private static final Log LOG = LogFactory.getLog("com.puppycrawl.tools.checkstyle.checks.indentation");
    private final Map mTypeHandlers = new HashMap();
    private final Map mCreatedHandlers = new HashMap();

    private void register(int aType, Class aHandlerClass) {
        try {
            Constructor ctor = aHandlerClass.getConstructor(IndentationCheck.class, DetailAST.class, ExpressionHandler.class);
            this.mTypeHandlers.put(new Integer(aType), ctor);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("couldn't find ctor for " + aHandlerClass);
        }
        catch (SecurityException e) {
            LOG.debug("couldn't find ctor for " + aHandlerClass, e);
            throw new RuntimeException("couldn't find ctor for " + aHandlerClass);
        }
    }

    public HandlerFactory() {
        this.register(33, CaseHandler.class);
        this.register(89, SwitchHandler.class);
        this.register(7, SlistHandler.class);
        this.register(16, PackageDefHandler.class);
        this.register(92, ElseHandler.class);
        this.register(83, IfHandler.class);
        this.register(95, TryHandler.class);
        this.register(96, CatchHandler.class);
        this.register(97, FinallyHandler.class);
        this.register(85, DoWhileHandler.class);
        this.register(84, WhileHandler.class);
        this.register(91, ForHandler.class);
        this.register(9, MethodDefHandler.class);
        this.register(8, MethodDefHandler.class);
        this.register(14, ClassDefHandler.class);
        this.register(154, ClassDefHandler.class);
        this.register(6, ObjectBlockHandler.class);
        this.register(15, ClassDefHandler.class);
        this.register(30, ImportHandler.class);
        this.register(29, ArrayInitHandler.class);
        this.register(27, MethodCallHandler.class);
        this.register(43, MethodCallHandler.class);
        this.register(22, LabelHandler.class);
        this.register(12, StaticInitHandler.class);
        this.register(11, SlistHandler.class);
        this.register(80, AssignHandler.class);
        this.register(98, AssignHandler.class);
        this.register(99, AssignHandler.class);
        this.register(100, AssignHandler.class);
        this.register(101, AssignHandler.class);
        this.register(102, AssignHandler.class);
        this.register(103, AssignHandler.class);
        this.register(104, AssignHandler.class);
        this.register(105, AssignHandler.class);
        this.register(106, AssignHandler.class);
        this.register(107, AssignHandler.class);
        this.register(108, AssignHandler.class);
        this.register(10, MemberDefHandler.class);
        this.register(136, NewHandler.class);
    }

    public boolean isHandledType(int aType) {
        Set typeSet = this.mTypeHandlers.keySet();
        return typeSet.contains(new Integer(aType));
    }

    public int[] getHandledTypes() {
        Set typeSet = this.mTypeHandlers.keySet();
        int[] types = new int[typeSet.size()];
        int index = 0;
        Iterator i = typeSet.iterator();
        while (i.hasNext()) {
            types[index] = (Integer)i.next();
            ++index;
        }
        return types;
    }

    public ExpressionHandler getHandler(IndentationCheck aIndentCheck, DetailAST aAst, ExpressionHandler aParent) {
        ExpressionHandler handler = (ExpressionHandler)this.mCreatedHandlers.get(aAst);
        if (handler != null) {
            return handler;
        }
        if (aAst.getType() == 27) {
            return this.createMethodCallHandler(aIndentCheck, aAst, aParent);
        }
        Integer type = new Integer(aAst.getType());
        ExpressionHandler expHandler = null;
        try {
            Constructor handlerCtor = (Constructor)this.mTypeHandlers.get(type);
            if (handlerCtor != null) {
                expHandler = (ExpressionHandler)handlerCtor.newInstance(aIndentCheck, aAst, aParent);
            }
        }
        catch (InstantiationException e) {
            LOG.debug("couldn't instantiate constructor for " + aAst, e);
            throw new RuntimeException("couldn't instantiate constructor for " + aAst);
        }
        catch (IllegalAccessException e) {
            LOG.debug("couldn't access constructor for " + aAst, e);
            throw new RuntimeException("couldn't access constructor for " + aAst);
        }
        catch (InvocationTargetException e) {
            LOG.debug("couldn't instantiate constructor for " + aAst, e);
            throw new RuntimeException("couldn't instantiate constructor for " + aAst);
        }
        if (expHandler == null) {
            throw new RuntimeException("no handler for type " + type);
        }
        return expHandler;
    }

    ExpressionHandler createMethodCallHandler(IndentationCheck aIndentCheck, DetailAST aAst, ExpressionHandler aParent) {
        DetailAST ast;
        for (ast = (DetailAST)aAst.getFirstChild(); ast != null && ast.getType() == 59; ast = (DetailAST)ast.getFirstChild()) {
        }
        if (ast != null && this.isHandledType(ast.getType())) {
            aParent = this.getHandler(aIndentCheck, ast, aParent);
            this.mCreatedHandlers.put(ast, aParent);
        }
        return new MethodCallHandler(aIndentCheck, aAst, aParent);
    }

    void clearCreatedHandlers() {
        this.mCreatedHandlers.clear();
    }
}

