#ifndef INCLUDED_AG_TIME
#define INCLUDED_AG_TIME



#include <ctime>



namespace ag {



//! The Time class encapsulates the properties of the current time.
/*!
*/
class Time
{

private:

  //! Struct with current time information.
  std::time_t      d_time;

public:

  //----------------------------------------------------------------------------
  // CREATORS
  //----------------------------------------------------------------------------

                   Time                ();

  /* virtual */    ~Time               ();

  //----------------------------------------------------------------------------
  // MANIPULATORS
  //----------------------------------------------------------------------------

  Time&            operator-=          (const Time& aTime);

  friend Time      operator-           (const Time& lhs,
                                        const Time& rhs);

  //----------------------------------------------------------------------------
  // ACCESSORS
  //----------------------------------------------------------------------------

  size_t           inSeconds           () const;

};



//------------------------------------------------------------------------------
// INLINE FUNCIONS
//------------------------------------------------------------------------------



//------------------------------------------------------------------------------
// FREE OPERATORS
//------------------------------------------------------------------------------

Time               operator-           (const Time& lhs,
                                        const Time& rhs);



//------------------------------------------------------------------------------
// FREE FUNCTIONS
//------------------------------------------------------------------------------



} // namespace ag

#endif
