#ifndef INCLUDED_SIP
#include "sip.h"
#define INCLUDED_SIP
#endif


// Library headers.

// PCRaster library headers.

// Module headers.

/**
* Destructor
*/
SIP::~SIP(){
}


/**
* Constructor
*/
SIP::SIP()
  {
}


void SIP::setSIP(size_t mxiter, size_t nparam, double accl, double hclose, size_t ipcalc, double wseed, bool updated){
  d_mxiter = mxiter;
  d_nparam = nparam;
  d_accl = accl;
  d_hclose = hclose;
  d_ipcalc = ipcalc;
  d_wseed = wseed;
  d_iprsip = 1;
  d_updated = updated;
}


bool SIP::modified() const {
  return d_updated;
}


void SIP::update() {
  d_updated = false;
}


std::ostream& operator<<(std::ostream& os, const SIP& sip){
  os << "# Generated by PCRaster Modflow\n";
  os << sip.d_mxiter << " " << sip.d_nparam << "\n";
  os << sip.d_accl << " " << sip.d_hclose << " " << sip.d_ipcalc << " " << sip.d_wseed << " " << sip.d_iprsip << "\n";
  return os;
}

