---
title: Pandoc Extras
author: John MacFarlane
---

This is a curated list of some of the most useful third-party
software that extends pandoc's capabilities.  For a more
complete list, see the [Pandoc Extras wiki page](https://github.com/jgm/pandoc/wiki/Pandoc-Extras).


### GUI

  - [PanWriter](https://github.com/mb21/panwriter/#panwriter) is
    a Markdown editor with live preview that can import and export
    using pandoc.
  - [Pandoc Mac OS X
    Services](https://github.com/mb21/Pandoc-Mac-OS-X-Services)
    allows you to invoke pandoc from any text editor with the
    opened file as input.

### Editor support

  - [pandoc-mode](http://joostkremers.github.com/pandoc-mode/) for Emacs
  - [vim-pandoc](https://github.com/vim-pandoc) for Vim

### CLI wrappers

  - [panzer](https://github.com/msprev/panzer) allows you to
    specify command-line options and styles in the Markdown file's YAML
    metadata.
  - [pandocomatic](https://heerdebeer.org/Software/markdown/pandocomatic/)
    is similar to panzer but also provides support for
    converting directory trees.
  - [panrun](https://github.com/mb21/panrun) is a more
    minimalistic alternative to panzer and pandocomatic.

### Editing/document changes

  - [pandiff](https://github.com/davidar/pandiff) creates prose
    diffs for any document format supported by pandoc.
  - [pancritic](https://github.com/ickc/pancritic) allows using
    [CriticMarkup](http://criticmarkup.com/spec.php#caveats) with pandoc.

### Charts and data

  - [R Markdown](https://rmarkdown.rstudio.com) allows you to
    process Markdown documents with integrated data and charts
    (integrates pandoc).
  - [pandoc-plot](https://github.com/LaurentRDC/pandoc-plot)
    allows you to integrate programmatically generated plots
    generated by various tools.

### Citations

  - [zotxt](https://github.com/egh/zotxt) is Zotero extension
    for working with pandoc

### Numbering and cross-references

  - [pandoc-crossref](https://github.com/lierdakil/pandoc-crossref)
    is a filter that adds support for figure, table, and
    equation numbers and cross-references.
  - [pandoc-xnos](https://github.com/tomduck/pandoc-xnos) is
    a suite of filters supporting numbering and
    cross-referencing figures, equations, tables, and sections.

### Academic publishing workflows

  - [Quarto](https://quarto.org/) is an open-source scientific and technical publishing system
    to make reproducible, production quality 
    articles, presentations, websites, blogs, and books.
    It supports equations, citations, crossrefs, figure panels, callouts, advanced layout, etc.
  - [Manubot](https://manubot.org) is a workflow and set of tools for the next
    generation of scholarly publishing, including citation support and
    support for multiple output formats.
    It's especially suited for papers with a very large set of authors.
  - [pandoc-ext](https://github.com/pandoc-ext) includes goodies such as
    putting the Abstract into a section,
    multiple bibliographies,
    support the Citation Typing Ontology (CiTO), etc.
  - [Pandoc Scholar](https://github.com/pandoc-scholar/pandoc-scholar) is a
    set of utilities to make publishing of scientific articles as simple and
    pleasant as possible. It simplifies setting authors' metadata in
    YAML blocks, allows to add semantic annotation to citations, and
    only requires the programs `pandoc` and `make`.
    Please note that it is no longer maintained and refers to `Quarto` and `pandoc-ext`

### Containers

  - [pandoc docker images](https://github.com/pandoc/dockerfiles)

### Lua filters

(For a fuller list, see [the lua-filters
repository](https://github.com/pandoc/lua-filters).)

  - [Spell
    checking](https://github.com/pandoc/lua-filters/tree/master/spellcheck).
  - [Word count](https://github.com/pandoc/lua-filters/tree/master/wordcount).
  - [Embed textually-specified
    diagrams](https://github.com/pandoc-ext/diagram) in Mermaid, Dot/GraphViz,
    PlantUML, Asymptote, CeTZ, and TikZ.
  - [Create subfigures in pandoc's Markdown](https://github.com/rnwst/pandoc-subfigs).
  - [Handle scholarly
    metadata](https://github.com/pandoc/lua-filters/tree/master/scholarly-metadata).
  - [Panda](http://christophe.delord.free.fr/panda/) provides
    conditionals, code file inclusion, string expansion,
    and diagrams from code blocks.

