# Revision history for pandoc

## pandoc 3.7.0.2 (2025-05-28)

  * RST writer:

    + Don't emit alignment markers in grid tables (#10857).

  * Asciidoc writer:

    + Add support for sidebars (GHyman83).

  * LaTeX writer:

    + Include alt option in `\includegraphics` (#6095).

  * Markdown writer:

    + Preserve figure attributes (Nikolay Yakimov, #10867).
      Fixes a regression introduced by 0d2114e, which caused the
      Markdown writer to ignore attributes on the figure if it
      has class or key-value attributes set.

  * HTML writer:

    + Use the ID prefix in the ID for the footnotes section (Benjamin Esham).

  * Text.Pandoc.Writers.Shared:

    + `gridTable`: fix (3.7) regression with missing cell alignments (#10853).
    + `gridTable`: fix headings with colspans (#10855). If the heading
      contains a colspan, we still need to include information in the header
      line about the colspecs.
    + `gridTable`: fix headerless tables. The top line should encode
      colspan information.

  * Text.Pandoc.SelfContained:

    + Fix handling of empty script element (#10862). Previously in this
      case the closing tag was dropped.
    + Do not drop `data-` attributes in script tags (#10861).

  * Lua subsystem (Albert Krewinkel):

    + Add function `pandoc.mediabag.make_data_uri` (#10876).
      The function takes a MIME type and raw data from which it creates an
      RFC 2397 data URI.

  * `tools/update-lua-module-docs`: fix handling of wikilinks
    (Albert Krewinkel).

  * `doc/lua-filters.md`: add missing docs for `pandoc.Caption`
    (Albert Krewinkel).

  * Require texmath 0.12.10.3, typst 0.8.0.1

## pandoc 3.7.0.1 (2025-05-17)

  * Text.Pandoc.Shared.Writer:  Fix numerous problems with `gridTable` and add
    tests (#10848).  These fixes affect the Markdown, RST, and Muse writers.

  * Fix context writer/template to produce tagged PDFs (#10846).
    As before, the `tagging` extension must be enabled.
    We now add the command that tells ConTeXt to start tagging.

## pandoc 3.7 (2025-05-14)

  * Add new command-line option `--variable-json` (#10341).
    This allows non-string values (booleans, lists, maps) to be given to
    template variables on the command line.

  * The `--pdf-engine` option can now take `groff` as a value.

  * Markdown writer:

    + Avoid spaces after/before open/close delimiters (#10696).
      E.g. instead of rendering `x<em> space </em>y` as `x* space *y` we render
      it as `x *space* y`.
    + Handle row/colspans in grid tables, and expand cells when it isn't
      possible to lay them out without breaking string of non-whitespace.
    + Render a figure with Para caption as implicit figure (#10755).
    + When falling back to a Div with class `figure` for a figure that
      can't be represented any other way, include a Div with class
      `caption` containing the caption.
    + Improve use of implicit figures when possible (#10758).
      When the alt differs from the caption, but only as regards formatting, we
      still use an implicit figure.
    + Omit initial newlines in gfm `math` blocks to avoid an ugly blank line.
    * Support the `four_space_rule` extension for `plain` output (#10813,
      Manolis Stamatogiannakis).

  * RST writer:

    + Handle row/colspans in grid tables, and expand cells when it isn't
      possible to lay them out without breaking string of non-whitespace.

  * Muse writer:

    + Handle row/colspans in grid tables, and expand cells when it isn't
      possible to lay them out without breaking string of non-whitespace.

  * JATS writer:

    + Fix escaping for writing-review-editing role (#10744).

  * HTML writer:

    + Remove trailing slash from default revealjs URL (#8749). This
      avoids a double slash in the URL's path component.

  * LaTeX writer:

    + Make alignment work within `multirow` in tables (#10772).

  * Typst writer:

    + Support `mark` class on spans (#10747).
    + Add equation label if math contains `\label{..}` (#10805).

  * Roff format writers (man, ms):

    + Use the most compatible form for roff escapes (#10716).
      For example, `\(xy` instead of `\[xy]`. This was the original
      AT&T troff form and is the most widely supported. The
      bracketed form causes problem for some tools, e.g.
      `makewhatis` on macOS. And emit `e` followed by an escape
      for a unicode combining accent rather than the form `\[e aa]`,
      which works for groff but not e.g. on macOS's man.
      This change affects Text.Pandoc.RoffChar,
      Text.Pandoc.Writers.Roff, and the Man and Ms writers.

  * Docx writer:

    + Ensure that figures and tables with custom styles are not dropped
      (#10705).
    + Preserve Relationships for images from reference docx (#10759).
      This should allow one to include an image in a reference.docx and
      reference it in an openxml template.
    + Don't renumber rels (#10769). We used to renumber the
      Relationships so they didn't conflict with the set of fixed
      Relationships we imposed. We are now preserving the ids
      from the reference doc's document.xml.refs, so we shouldn't
      renumber them or references introduced by the user (e.g. in
      a template) will fail.

  * Ms writer:

    + Improve PDF TOC labels. We now use the plain writer to render these,
      so that Greek characters etc. will show up properly.
    + When no `pdf-engine` variable is specified, do not use the
      `.pdfhref` macros at all (#10738). This gives better results for links
      in formats other than PDF, since the link text would simply
      disappear if it exists only in a `.pdfhref` macro. When a PDF
      engine is specified, escape the argument of `.pdfhref O` in a way
      that is appropriate.

  * OpenDocument writer:

    + Fix character styles in footnotes (#10791). Character
      styles governing the position of the footnote reference
      should not be imposed on the footnote text.

  * Powerpoint writer:

    + Use reference-doc font for captions (#9896, R. N. West).

  * DocBook writer:

    + Use literallayout element for LineBlock (#10825).

  * MediaWiki reader/writer:

    + Allow definition on same line as term (#10708).

  * LaTeX reader:

    + Skip at most one argument to LaTeX tabular newline (#7512,
      Evan Silberman).
    + Disable ligatures inside `\texttt` (#10781).
    + Support more symbol commands (#10782).

  * Commonmark Reader:

    + Handle GFM math irregularity with braces (#10631). In GFM, you need
      to use `\\{` rather than `\{` for a literal brace.

  * DocBook reader:

    + Improve handling of literallayout (#10825). This is now only made
      a CodeBlock when there is a `monospaced` class. Otherwise it is made
      a LineBlock.

  * Org reader:

    + Add AVIF to Org Reader image extensions (#10736, Christian Christiansen).
    + Don't include newlines in inine code/verbatim (#10730).
      Convert newlines to spaces as we do in other formats.
    + Change handling of inline TeX (#10836). Previously inline
      TeX was handled in a way that was different from org's own export,
      and that could lead to information loss. This was particularly noticeable
      for inline math environments such as `equation`.  Previously, an
      `equation` environment starting at the beginning of a line would create
      a raw block, splitting up the paragraph containing it (see
      #10836). On the other hand, an `equation` environment not
      at the beginning of a line would be turned into regular
      inline elements representing the math. (This would cause
      the equation number to go missing and in some cases degrade
      the math formatting.) Now, we parse all of these as raw
      "latex" inlines, which will be omitted when converting to
      formats other than LaTeX (and other formats like pandoc's
      Markdown that allow raw LaTex).

  * Beamer template: fix regression in 3.6.4, reverting the omission of
    `\date` when the document does not have a date. By default, beamer
    will display a date when no `\date` is present in the title block,
    so this was an unintended behavior change. The reverted
    change was motivated by the desire to include a custom
    `\date` in the frontmatter via header-includes. This can be
    achieved more simply by simply setting the `date` variable.
    In markdown you can even use `date` in metadata and put some
    raw LaTeX there.

  * Ms template:

    + Use T rather than P as default font family (#10738).
    + Put PDF-specific things under a conditional.
      Don't include them if `pdf-engine` isn't set.

  * Upgrade reveal.js URL to v5 (#10740, Kolen Cheung).
    v4 is no longer available on unpkg.com.

  * Text.Pandoc.PDF: Allow `groff` to be used as `--pdf-engine` with `ms`
    (#10738). When `groff` is used as a PDF engine, the `groff`
    extension to `ms` is automatically enabled. Limitations:

    - `groff` currently produces larger PDFs than `pdfroff`.
    - With `groff`, a table of contents produced with
      `--table-of-contents/--toc` will always be placed at the end of
      the document.
    - Certain characters (e.g. Greek characters) may be dropped in
      the PDF outline.

  * Text.Pandoc.Writers.Shared:

    + Export `delimited` [API change].
    + New version of `gridTable` (#6344) [API change]. This
      handles row and colspans. It also ensures that cells won't
      wrap text in places where it wouldn't normally wrap, even
      if this means making the cells wider than requested by the
      colspec (#9001, #7641). Because the parameters are
      different, this is a breaking API change.

  * Text.Pandoc.App: set `pdf-engine` variable.
    If `--pdf-engine` is specified or if a PDF is being produced, we set the
    `pdf-engine` variable. This allows writers and templates to behave
    differently depending on the PDF engine.

  * Text.Pandoc.Class and Text.Pandoc.URI:

    + Fix parsing of base64 data URIs to allow URI escapes and
      whitespace (which will be ignored) (#10704).
    + Handle percent encoding in `pBase64URI` instead of
      unescaping later, for efficiency (#10704).

  * Text.Pandoc.Citeproc.BibTeX:

    + Recognize `en` as a `langid` in biblatex bibliographies (#10764).

  * Text.Pandoc.MIME:

    + Add mime type and extension for `avif` (#10704).
    + Handle `apng`, `avif`, `jxl` (#10704).

  * Text.Pandoc.Readers.LaTeX.Math: export `inlineEnvironmentNames`.
    Internal module, not a change to the public API.

  * `reference.docx` (Andrew Dunning):

    + Remove extra spaces around text placeholders.
    + Add footnote block text sample.

  * Text.Pandoc.Class.Sandbox:

    + Add `sandboxWithFileTree` function [API change] (Albert Krewinkel).

  * Lua subsystem (Albert Krewinkel):

    + pandoc-lua-engine: add all test files to the cabal file.
    + Allow `pandoc.read` to be called in "sandbox" mode for added
      security (#10831). Readers running in a sandbox will not be
      able to access the network or file system. The sandbox is
      enabled if the fourth parameter is a list of files or
      filename/content pairs. The files are read and then made
      available in the sandbox via en ersatz file system.

  * Makefile:

    + Add target `release-checkist`.
    + Install @daisy/ace from npm if not present.
    + Use pandoc lua instead of lua.
    + Fix typo in `latex-package-dependencies` target.
    + Use `jq` instead of `json_reformat` in `validate-docx-golden-tests2`.

  * NiX infrastructure: new working `flake.nix` and simpler `shell.nix`.
    Removed old `default.nix`.

  * Require random >= 1.3 and use `splitGen`. `split` has been deprecated.

  * Use citeproc-0.9. Bump citeproc bounds for pandoc, pandoc-lua-engine.

  * Use texmath-0.12.10.1.

  * Use released typst 0.8 (partially supporting typst 0.13).

  * Use citeproc 0.9.0.1.

  * MANUAL.txt:

    + Fix default URL for revealjs.
    + Add note that `alerts` extension only works with commonmark (#9716).
    + Remove "Body Text Char" from list of Word styles that can be customized
      using a reference.docx (#10646). This doesn't seem to be present in
      pandoc-generated docx files, nor is it a Word default.
    + For pandoc lua, add note about the environment.
    + Improve documentation of `--variable` option.

  * `doc/typst-property-output.md`: Mention that `typst:no-figure` is a
    class, not an attribute (#10826, Niklas Eicker).

  * Change RELEASE-CHECKLIST to RELEASE-CHECKLIST-TEMPLATE.org. Use org-babel
    to automate many of the steps of the release.

  * INSTALL.md: update MacPorts information (#10719, Mohamed Akram).

  * COPYRIGHT: fix link to source code.

  * CONTRIBUTING.md: Fix link to discussion forum. (#10834, R. N. West).

## pandoc 3.6.4 (2025-03-16)

  * Disable `citations` extension in writers if `--citeproc` is used (#10662).
    Otherwise we get undesirable results, as the format's native
    citation mechanism is used instead of (or in addition to) the
    citeproc-generated citations.

  * Markdown reader:

    + Allow line break between URL and title of link (#10621).
    + Give better position information when YAML metadata parsing fails
      with a YAML exception (#10231).
    + Fixed `escapedChar'` parser (#10672). It should not accept
      escaped newlines.
    + Remove some misguided list fanciness (#9865, #7778, cf. #5628).
      Previously we tried to handle things like commented out list items:
      ```
      - one
      <!--
      - two
      -->
      - three
      ```
      and also things like:
      ```
      - one `and
      - two` and
      ```
      But the code we added to handle these cases caused problems with
      other, more straightforward things, like:
      ````
      - one
      - ```
        code
        ```
      - three
      ````
      So we are rolling back all the fanciness, so that the markdown
      parser now behaves more like the commonmark parser, in which
      indicators of block-level structure always take priority over
      indicators of inline structure.

  * HTML reader:

    + Skip MathJaX-introduced cruft (#10673).
    + Ignore style tags in the body (#10643).

  * LaTeX reader:

    + Better handle comments/whitespace in option lists and includes (#10659).
    + Support `\newline`, `\linebreak`.

  * Docx reader/writer:

    + Revert commit adding row heads
      (cbe67b9602a736976ef6921aefbbc60d51c6755a) (#10627).
      Word sets `w:firstColumn="1"` by default for tables.  You have to find
      the Table Design tab and explicitly uncheck "First Column" to make this
      go away.  In most cases, I don't think writers intend to designate
      the first column as a row head, so this commit is going to produce
      unexpected results.  In addition, because of the table normalization
      done by pandoc-type's `tableWith`, any table containing a colspanned
      cell in the left-hand column will get broken if the first column is
      designated a row head.  For these reasons it seems best to revert this
      change, which was made in response to #9495.

  * LaTeX writer and template:

    + Remove `selnolig-langs` (#9863). We now specify the language as
      a global option again, so we no longer need to specify it when
      invoking selnolig.
    + Use babel options `shorthands=off` (#6817).
    + Use `*` for multirow width when no colwidth specified (#10685).
      Otherwise the multirow will be excessively wide.
    + Protect `\phantomsection` (#10688, etclub).

  * Markdown writer:

    + Omit extra space after bullets (#7172). Those who want the old
      behavior can obtain it by using `-t markdown+four_space_rule`.
    + Treat `Emph [Emph ils]]` as `ils` (#10642). Otherwise we get
      `**content**` which means strong emphasis.

  * EPUB writer:

    + Use a nonbreaking space after section number in nav.xhtml.
      This seems to be required for iOS books app to display the space.

  * Typst writer:

    + Better heuristics for escaping potential list markers (#10650).
    + Ensure that `citation-style` works as well as `csl` (#10661).

  * Powerpoint writer:

    + Avoid extra blank lines before author when there is no
      subtitle (#10619).

  * JATS template:

    + Fix typo in author prefix in article.jats_publishing template
      (#10622, Tiago-Manzato).

  * Text.Pandoc.Parsing:

    + Smart quote parsing: ignore curly quotes (#10610). Previously we
      tried to match curly quotes as well as straight quotes,
      producing Quoted inlines. But it seems better just to assume
      that those who use curly quotes want them passed through
      verbatim. This also fixes an (unintended) bug whereby curly
      single left quotes would sometimes be changed to single right quotes.

  * Text.Pandoc.Shared:

    + `makeSections`: put some attributes on section element only.
      Certain `role` and `epub:type` attributes should only be on the section
      (and indeed, many `role`s give a validation error if left on the
      heading element).

  * Text.Pandoc.Logging:

    + Change NoTitleElement from WARNING to INFO (#10671). Users
      commonly complain about the warning when producing HTML
      documents without an explicit title. It seems that an info
      message is more appropriate, since pandoc's default here (using
      the input's base name) ensures compliance with the standard and
      many users are happy with that default. Those who want to make
      sure the message is seen can use `--verbose`.

  * Beamer template: only emit `\date` if set (#10687, josch).

  * Fix invalid OOXML in definition_list.docx test (#10394).

  * MANUAL.txt:

    + Correct typo: 'date' for doubled 'title' (#10654, Olivier Dossmann).
    + Add note about `template` variable for typst.
    + Change maxwidth default in MANUAL.txt (#10683).
    + Improve EPUB metadata documentation.
    + In Security section, alert readers to a threat relating to iframe in
      HTML, and add LaTeX, Typst to the list of formats that have an
      `include` (#10682).

  * `doc/lua-filters.md`: Add missing html_math_method 'katex' (R. N. West).

  * Use texmath 0.12.9.

  * Use typst 0.7. Fixes an issue with package loading, a regression
    in pandoc 3.6.3.

## pandoc 3.6.3 (2025-02-09)

  * Track wikilinks with a class instead of a title (Evan Silberman).
    Previously wikilinks were distinguished by giving them the `title`
    `wikilink`.  Now that we have link attributes, it makes more sense
    to give them the `class` `wikilink`. This change affects all readers
    and writers that support wikilinks.

  * DocBook reader:

    + Handle title inside `orderedlist` (#10594). Also some other
      elements that allow title: `blockquote`, `calloutlist`, etc.
    + Better handle `informalequation` (#10592, tombolano). Include `id`
      attribute.
    + Better handle `formalpara`, `example`, and `sidebar` (#8666, tombolano).
      Include identifiers and titles in each case.

  * Markdown reader:

    + Simplify and fix normal citation parsing (#10584).
      This fixes a bug that causes some normal citations to be
      parsed as bracketed regular citations.

  * ODT reader:

    + Create Figure elements for images that are figures (#10567).
    + Avoid producing spurious blockquotes in list items (#9505).
    + Fix unwanted block quotes (#10575). Previously the reader created
      block quotes whenever a paragraph was marked indented (even though
      this just affects the first line). With this change we still
      generate block quotes for content that has an altered left margin,
      but not for indented paragraphs.

  * Docx reader:

    + Do not issue warning for comments with `+styles` (#10571, Stephen Reindl).

  * LaTeX reader:

    + Test \{,re}newcommand arguments (#4470, Evan Silberman).

  * Pod reader:

    + Consume blanks after =encoding in pod reader (#10537, Evan Silberman).

  * JATS writer:

    + Add CRediT roles to JATS (Charles Tapley Hoyt and Jez Cope, #10152).
      Enable annotating author roles using the Contribution Role Taxonomy
      (CRediT) and export this information in conformant JATS.

  * LaTeX writer/templates:

    + Improve babel support (#8283). Previously we used the `.ini`
      files for every language, but for European languages these tend to
      provide inferior results to the `.ldf` files used by classic
      Babel. Currently Babel documentation recommends using the classic
      system for European languages written in Latin and Cyrillic
      scripts and Vietnamese. So the LaTeX writer and template now
      follow this guidance.

      Main languages in the list of languages with good "classic" support
      are added to global documentclass options and will be automatically
      handled by Babel using the `.ldf` files.

      If the main language is not in this list, the `babeloptions` variable
      will be set to `provide=*`, which will cause support to be loaded from
      the `.ini` file rather than an `.ldf`. So, for example, setting
      `-V babeloptions=''` with a polytonic Greek document will cause the
      `.ldf` support to be used instead of the `.ini`.

      The default setting of this variable can be overwritten, but in most
      cases the default should give good results.

    + Allow `csquotesoptions` to be specified.
    + Fix indentation bugs in `font-settings.latex`.

  * Docx writer:

    + Repeat reference doc's `sectPr` for each new section (#10577).
      Previously we were only carrying over the reference doc's `sectPr`
      at the end of the document, so it wouldn't affect the intermediate
      sections that are now added if `--top-level-division` is `chapter`
      or `part`. This could lead to bad results (e.g. page numbering
      starting only on the last chapter).
    + Create section divisions with `--top-level-division=part` (#10576).
    + Improve title style in reference.docx; base Author and Date
      on Title; remove condensed spacing (Andrew Dunning, #10581).

  * Typst writer:

    + Brace tables with `typst:no-figure` and `typst:text` attributes (#10563,
      Gordon Woodhull).

  * Ms writer:

    + Fix escaping of `-` (#10536). `-` should now be escaped in man
      output but not in ms output (where `\-` is a unicode minus sign).

  * HTML styles: fix style of `hr` so it works when printed (#10535, Hendrik Erz).
    Previously `background-color` was used to style the hr, but this gets ignored
    when printing.  This commit uses `border-top` instead.

  * Text.Pandoc.Shared:

    + Handle `<abbr>` as a span-like inline in `htmlSpanLikeElements`
      (#5793, Evan Silberman).

  * Text.Pandoc.MediaBag:

    + Prefer MIME type when determining extensions for MediaBag items (#10557,
      Max Heller).  This should give different results for remote images
      that are served at URLs that do not contain misleading extensions
      (e.g. `shields.io`).

  * Text.Pandoc.Citeproc:

    + Fix moving punctuation before citation notes. This previously worked with
      regular citations, but not author-in-text citations. Now it works with both.

  * `doc/lua-filters.md`:

    + Correct luacheck URL (#10589, R. N. West).
    + Add static analysis paragraph to debugging section (#10568, R. N. West).
    + Add note about extensions handling in `read` and `write` (Albert Krewinkel).

  * `doc/extras.md`:

    + Add entry for pandoc-subfigs (R. N. West).
    + Update diagram Lua filter URL and description (R. N. West).

  * MANUAL.txt:

    + Add note on using typst to produce pdf/a-2b.
    + Document top-level-division functionality with Docx (#10579, Andrew Dunning).

  * Raise xml-conduit upper bound.

  * Depend on latest commonmark-pandoc, commonmark-extensions,
    citeproc, typst.

  * Makefile: make `make binpath` quiet.

## pandoc 3.6.2 (2025-01-12)

  * New input format: `pod` (Evan Silberman). Pod ("Plain old documentation")
    is a markup languaged used principally to document Perl modules and
    programs.

  * New reader module Text.Pandoc.Readers.Pod, exporting `readPod`
    [API change].

  * Docx reader:

    + Support row heads in tables (#9495). Reader: When `w:tblLook` has
      `w:firstColumn` set (or an equivalent bit mask), we set row heads = 1
      in the AST.
    + Read table styles as custom styles when `styles` extension
      is enabled (#9603).

  * HTML reader:

    + Add size information for font awesome SVG icons (#10134).
      If the icon has class `fa-fw` or `fa-w16` or `fa-w14`, we add a width
      attribute to prevent the icon from appearing full-width in PDF or
      docx output.

  * Djot reader:

    + Use a Span with class "mark" rather than "highlighted" for
      highlighted text, for consistency with the other pandoc readers and
      writers.

  * mandoc reader:

    + Add mdoc St for C23 (Evan Silberman).

  * RST reader:

    + Fix handling of underscores (#10497). Fixes a a regression
      introduced in 3.6.

  * Docx writer:

    + Support row heads in tables (#9495). Writer: set `w:firstColumn` in
      `w:tblLook` when there are row heads. (Word only allows one, so this
      is triggered by any number of row heads > 0.)

  * Djot writer:

    + Render a Span with sole class "mark" as highlighted text.

  * Asciidoc writer:

    + Don't emit the class in a span if it's just "mark" (#10511).
      The "mark" class is used for highlighting, and Asciidoc treats
      bare `#...#` with no attributes as highlighted text.
    + Improve escaping (#10385, #2337, #6424).

  * EPUB v2 writer:

    + Fix cover image (#10505).  This is a regression introduced in 3.6.

  * Typst writer:

    + Fix handling of pixel image dimensions (#9945).
      These are now converted to inches as in the LaTeX writer.

  * Improve error message given when users specify `asciidoc` as input
    format (#8416, Santiago Zarate).

  * Allow random 1.3.

  * Use texmath 0.12.8.13 (typst improvements).

  * `lua-filters.md`: document `system.os` return values (#10523).

  * `MANUAL.txt`:

    + Improve manual's coverage of custom styles.
    + Replace LibreOffice PDF documentation link to latest so it links
      to the latest major release rather than a specific major release
      (which there are two of every year) (Stéphane Guillou).
    + Improve links and descriptions for `odt`, `opendocument` (#10518).

## pandoc 3.6.1 (2024-12-23)

  * Allow YAML bibliographies to be arrays of references (#10452).
    Previously, they had to be YAML objects with a `references` key.

  * Change `--template` to allow use of extensionless templates (#5270).
    The intent is to allow bash process substitution: e.g.,
    `--template <(echo "foo")`. Previously pandoc *always* added an
    extension based on the output format, which caused problems
    with the absolute filenames used by bash process substitution
    (e.g. `/dev/fd/11`). Now, if the template has no extension,
    pandoc will first try to find it without the extension, and
    then add the extension if it can't be found. So, in general,
    extensionless templates can now be used. But this has been
    implemented in a way that should not cause problems for
    existing uses, unless you are using a template `NAME.FORMAT`
    but happen to have an extensionless file `NAME` in the template
    search path.

  * Allow `--shift-heading-level-by=-1` to work in djot in the same way
    it works for other formats (with the top-level heading being
    promoted to metadata title) (#10459).  This needed special
    treatment because of the way djot surrounds sections with Divs.

  * RST reader:

    + Handle explicit reference links (#10484, Evan Silberman).
      This case was missed when changing the reference link strategy for
      RST to allow a single pass. (It is a regression in pandoc 3.6.)

  * Markdown reader:

    + Use T.P.URI's `pBase64DataURI` in parsing data URIs (#10075,
      Evan Silberman and John MacFarlane).
    + More efficient base64 data URI parsing (#10075, Evan
      Silberman and John MacFarlane). This should yield dramatic
      performance improvements for markdown documents containing
      large data URIs in images.

  * HTML reader:

    + Don't canonicalize data: URIs (#10075). It can be very expensive
      to call network-uri's URI parser on these.

  * LaTeX reader:

    + Handle `figure*` environment as a figure (#10472).

  * MediaWiki reader:

    + Allow empty quoted attributes (#10490).
    + Allow cells starting with `+` (#10491).

  * Textile reader:

    + Improve parsing of spans (#9878). The span needs to be separated
      from its surroundings by spaces. Also, a span can have attributes,
      which we now attach.
    + Inline constructors shouldn't trigger if closer is preceded by
      whitespace (#10414).

  * Docx writer:

    + Put chapters in separate sections, and restart footnotes
      by section by default (#2773). The main effect of this change is that
      when `--top-level-division=chapter` is used, chapters will start on
      a new page and footnote numbering will restart for each chapter.
      Both of these defaults can be overridden in the reference.docx.
    + Use styleIds not styleNames for Title, Subtitle, etc.
      (#10282). This fixes a regression introduced in pandoc 3.5.
      This change affects the default openxml template as well as the
      OpenXML writer.

  * Markdown writer:

    + Avoid collapsing of initial/final newline in markdown raw blocks.
      This makes it easy to write a filter that adds extra blank lines
      before certain elements (#10477).

  * Mediawiki writer:

    + Escape line-initial characters that would otherwise be interpreted
      as list starts (#9700).

  * LaTeX writer:

    + Properly handle boolean value for `csquotes` variable (#10403).
    + Use displayquote for block quotes with `csquotes` (#10456).

  * HTML writer:

    + Avoid calling parseURIString for data URIs (#10075).
      This was done to determine the "media category," but we can
      get that directly from the mime component of data: URIs.

  * Typst writer:

    + Properly handle data URIs in images (#10460).

  * LaTeX/Beamer templates:

    + Fix default.beamer `nocite` location (Thomas Hodgson).
      It must be inside a frame or it is ignored (#10465).
    + Move nocites from LaTeX preamble to body (#10461, Thomas
      Hodgson). Putting `\nocite` in the preamble works only with biblatex.

  * Text.Pandoc.Parsing:

    + Correct example in comment on `charsInBalanced` (Evan Silberman).

  * Text.Pandoc.Error:

    + Mention typst in rendering `PandocUnknownWriterError` for `pdf`
      (Evan Silberman).

  * Text.Pandoc.MediaBag:

    + `insertMedia`: fast path for data URIs. Avoid the slow URI
      parser from network-uri on large data URIs (#10075).

  * Text.Pandoc.Class:

    + Add shortcut for base64 data URIs in `downloadOrRead` (#10075).
      This avoids calling the slow URI parser from network-uri on
      data URIs, instead calling our own parser.

  * Text.Pandoc.MIME:

    + Fix `extensionFromMimeType`. We had a few special cases encoded,
      but as previously written they wouldn't work properly with
      modifiers like `;charset=utf-8`.

  * Text.Pandoc.URI:

    + Export `pBase64DataURI`.  Modify `isURI` to use this and avoid
      calling network-uri's inefficient `parseURI` for data URIs.

  * Text.Pandoc.PDF:

    + Fix temp file extension in `toPdfViaTempFile` (#10468).
      This fixes a regression in pandoc 3.6, which changed
      the extension from `html` to `source`. Apparently
      `wkhtmltopdf` needs it to be `.html`.  So now we have added
      a parameter to `toPdfViaTempFile` that allows the extension
      to be specified in a way that is appropriate to the PDF engine
      used.

  * Lua (Albert Krewinkel):

    + Support more elements as input to `pandoc.utils.stringify`
      (#10450). Elements of type Caption, Cell, TableHead, and TableFoot
      can now be stringified.
    + Add `Caption` constructor to `pandoc` module.

  * Miscellaneous code quality improvements (Joseph C. Sible).

  * Depend on citeproc 0.8.1.2, skylighting and skylighting-core
    0.14.5.

  * `doc/lua-filters.md: Fix links to constructors (Albert Krewinkel).


## pandoc 3.6 (2024-12-07)

  * Add `mdoc` as input format (Evan Silberman). This change
    introduces a reader for mdoc, a roff-derived semantic markup
    language for manual pages. This reader has been developed almost
    exclusively against mandoc's documentation and implementation of
    mdoc as a reference, and the real-world manual pages tested
    against are those from the OpenBSD base system. Of ~3500 manuals
    in mdoc format shipped with a fresh OpenBSD install, 17 cause the
    mdoc reader to exit with a parse error. Any further chasing of
    edge cases is deferred to future work.

  * New module: Text.Pandoc.Readers.Mdoc, exporting `readMdoc` [API change].

  * Issue warnings for duplicate YAML metadata keys (#10312).

  * Ensure that `--sandbox` affects `--embed-resources`. Previously it
    did not (contrary to what was implied by the manual), which means
    that an image with URL `/etc/passwd` would leak an encoded version
    of that file to HTML output with `--self-contained` or
    `--embed-resources`, even if `--sandbox` was used. Thanks to
    Samuel Mortenson for pointing out the issue.

  * Text.Pandoc.App.OutputSettings: add `sandbox'` function.
    This computes the sandboxed files from Opt and avoids code repetition.

  * Docx reader:

    + Parse index references as empty spans with attributes (#10171).
      Attributes included are `entry`, and optionally `bold`, `italic`,
      `yomi`, `see`.
    + Don't create multiple paragraphs for title or subtitle (#10359).
      If there are multiple paragraphs with Title or Subtitle style,
      use only the first for metadata.
    + Handle case where Zotero `itemData` has different id from the
      `citationItem` id.  In this case we use the `citationItemId`
      in the bibliography as well, overriding the `referenceId`
      in the itemData (#10366).

  * LaTeX reader:

    + Put parsed minipage in specially marked Div (#10266).

  * HTML reader:

    + Parse footnotes defined by dpub-aria roles (#5294).

  * MediaWiki reader:

    + Fix indented tables with caption (#10390).
    + Fix parsing of col/rowspan (#6992).

  * Typst reader:

    + Avoid generating empty paragraphs.
    + Support `underparen`, `overparen`.
    + Fix `#quote` attribution. If attribution is not present, don't print
      the `--` (#10320).
    + Fix typo in unicode code point for em dash (see #10320).

  * Commonmark reader:

    + `implicit_figures` should check for empty caption
      and not produce an implicit figure in this case (#10429).

  * RST reader:

    + Use a new one-pass parsing strategy. Instead of having an initial pass
      where we collect reference definitions, we create links with target
      `##SUBST##something` or `##REF##something` or `##NOTE##something`,
      and resolve these in a pass over the parsed AST. This allows us to handle
      link references that are not at the top level (#10281).
    + Ignore newlines in URL in explicit link (#10279).
    + Handle block level substitutions.
    + Support `:file:` on raw directive (#8584).
    + Implement option lists (#10318).
    + Avoid putting metadata in Para (#7766). Create MetaInlines when possible,
      just as with markdown input. MetaBlocks is still used when there are
      multiple paragraphs or non-paragraph content.
      This change also affects field lists.
    + Fix linked substitutions (#6588). E.g. `|Python|_`.
    + Support inline anchors (#9196).
    + Explicit links define references (#5081). For example,
      ``Go to `g`_ `g <www.example.com>`_.`` should produce two links to
      www.example.com.

  * EPUB writer:

    + Use standardized filename for cover image instead of the original name
      (#10404). This avoids problems with e.g. filenames containing spaces.

  * Markdown writer:

    + Issue INFO warning when not rendering table, e.g., when `raw_html` is
      disabled and the table can't be fit into a supported markdown table
      format (#10407).
    + Respect empty LineBlock lines in `plain` output (Evan Silberman).
      The plain writer behaved as a markdown variant with `Ext_line_blocks`
      turned off, and so empty lines in a line block would get eliminated.

  * LaTeX writer:

    Ensure that beamer footnotes go on frame, not column (#5769).

  * HTML writer:

    + Unwrap empty incremental divs (#10328, Albert Krewinkel).
      Divs are unwrapped if the only purpose of the div seems to be to control
      whether lists are presented incrementally on slides.

  * Typst writer:

    + Make template sensitive to a `page-numbering` variable (#10370).
      This can be set to an empty string (or, in metadata, to false) for
      no page numbers.
    + Make `smart` extension work (#10271). If `smart` is not enabled, a command
      in the default template will disable smartquote substitutions.
      When `smart` is enabled, render curly apostrophes as straight
      and escape straight apostrophes. When `smart` is disabled,
      render curly apostrophes as curly and don't escape straight
      apostrophes. Similarly for quotes, em and en dashes. This should
      give more idiomatic typst output, with fewer unnecessary
      escapes.

  * ANSI writer:

    + Respect empty LineBlock lines (Evan Silberman).

  * JATS writer:

    + Correct spelling of suppress attribute (#10350, Andreas Deininger).

  * Typst template:

    + Remove `definitions.typst` partial.
    + Remove unnecessary definition of `endnote`.
    + Incorporate the one remaining definition into `default.typst`.
    + Use typst 0.12 code for two column layout (#10294, Luis Rivera).
    + Note: the new templates presuppose typst 0.12; if you try to use an
      earlier version of typst, an error will be raised.

  * LaTeX/Beamer template:

    + Split `fonts.latex` partial into two parts: `fonts.latex` and
      `font-settings.latex`.
    + In beamer template, load beamer theme between `fonts.latex` and
      `font-settings.latex`. This allows a theme (such as metropolis)
      to set its own default font, while still allowing the user to
      override it. This fixes a regression in pandoc 3.5 (#10297).
    + Note: Users who have custom templates based on pandoc 3.5 templates will
      need to add `font-settings.latex()` after `fonts.latex()` in the
      latex template. In a beamer template, the beamer theme-setting
      code needs to be moved between these two partials.

  * ConTeXt template: Ensure that font names don't wrap (#10305).

  * `epub.css`: remove background-color (#10264, Suraj Patil).
    With this greyish background color, epubs look bad on a Kindle (#10263).

  * Text.Pandoc.ImageSize: add WebP support (Evan Silberman, #10397).
    Add `Webp` constructor on ImageType [API change].

  * Text.Pandoc.Readers.Roff and a new unexported module
    Text.Pandoc.Readers.Roff.Escape: parameterize Roff
    escaping (Evan Silberman) [API change]. This allows code to
    be reused between the mdoc and man readers, despite the
    differing Token types.

  * Text.Pandoc.PDF:

    + PDF via LaTeX: always do max runs if `toc` is present (#10308).
      The old method (checking to see if toc hash had changed) is not
      completely reliable.
    + Use `.source` extension, not `.html`, in `toPdfViaTempFile` (#10314).

  * Text.Pandoc.Logging: add `YamlWarning` constructor to `LogMessage`
    [API change] (#10312).

  * Text.Pandoc.Format: remove duplicate typst entry (#10388, Caleb Mclennan).

  * Fix a typo in the `ua.yaml` localization for 'See' (Jens).

  * Lua subsystem (Albert Krewinkel):

    + Remove prefixes from Lua type names (#8574). Lua type names were
      inconsistent with regard to the use of prefixes; all prefixes
      are removed now, and Lua types now have the same name as the
      Haskell types. The use of app-specific prefixes is suggested by
      the Lua manual to avoid collisions. However, this shouldn't be a
      problem with pandoc, as it cannot be used as a Lua package.

  * doc/libraries.md: Add newly developed Haskell packages.
    Sort list alphabetically (Albert Krewinkel).

  * doc/lua-filters.md: document `pandoc.List:iter` method (Albert Krewinkel).
    List objects have a new function `iter` that returns an iterator
    function that returns the next list item on each call.

  * MANUAL.txt:

    + Clarify what the example of YAML EPUB metadata shows (#10405).
    + Fix typo in template syntax (#10265, Pascal Wagler).
    + Update manual with information on openxml template (#10273).
    + Clarify that `--variable` can only assign string values (#10298).

  * Fix comments in TEI writer referring to DocBook (#10430, Evan Silberman).

  * Fix several typos in documentation (#10349, Andreas Deininger).

  * Allow Diff 1.0.

  * Add font-settings.latex partial to pandoc.cabal (#10379).

  * Bump upper bound for data-default.

  * Use latest typst, texmath, pandoc-lua-marshal, commonmark-pandoc,
    commonmark-extensions, skylighting, skylighting-format-blaze-html.


## pandoc 3.5 (2024-10-04)

  * Add command-line options `--list-of-figures/--lof` and
    `--list-of-tables/--lot` (#10029, Akash Patel).
    Only docx, latex, and context are affected by these options currently.
    Setting the `lof` and `lot` variables will also work for the formats
    that are currently supported.

  * Defaults files:  interpolation of environment variables now
    works for `to` and `from` fields (#8024). This is needed because
    these files can contain paths of custom readers/writers.

  * Docx reader:

    + Reset lists after headers in same list `numId` (#10258).
      To accomplish this, we add a Heading constructor to BodyPart and
      include on it all the information list items have.

  * DocBook reader:

    + Parse id, class, and tabstyle on tables (#10181, Erik Rask).
      Add parsing of id (xml:id), class, and tabstyle XML attributes
      for table and informaltable in the DocBook reader.
      The tabstyle value is put in the 'custom-style' attribute.

  * Dokuwiki reader:

    + Be more forgiving about misaligned lists, like dokuwiki itself (#8863).
    + Improve blockquote parsing in dokuwiki. Allow for quoted code blocks.
    + Enable smart extension.
    + Properly parse `--` and `---` as dashes.
    + Fix block quote behavior (#6461). Blockquotes are not really block
      containers in DokuWiki; the lines are interpreted literally (so,
      e.g., you can't start a list), and line breaks are added at the ends.

  * EPUB reader:

    + Fix links to other files in the EPUB, making them internal links
      to a fragment derived from the filename (#10207).  There was
      already code to handle links like `#foo`, but not to handle links
      like `ch0001.html#foo`.

  * LaTeX reader:

    + Add em, ex, px, mu to list of units for dimension args (#10212).

  * ANSI writer:

    + Fix subscripts (Evan Silberman).

  * DokuWiki writer:

    + Don't emit `<HTML>` tags (#7413). The use of these tags is now
      strongly discouraged for security reasons, and will be removed.
      We previously used them as a fallback for lists that could not
      be represented using DokuWiki syntax, e.g. ordered lists with
      fancy numbers or lists with multiple blocks in their items.
      We also used them for block quotes with multiple blocks as
      their contents. We now use the `<WRAP>` syntax (from the optional
      WRAP plugin) to handle lists with multiple blocks as their contents.
      A new method of handling block quotes with complex contents
      has the side benefit of also handling nested block quotes,
      which weren't supported before.
      `<HTML>` and `<html>` tags are only for raw HTML blocks and
      inlines, and only if the `raw_html` extension is enabled. (It is
      now a valid extension for `dokuwiki`, though off by default.)

  * Docx writer:

    + Support `--list-of-figures` and `--list-of-tables` (or `lof` and
      `lot` variables) (Akash Patel).

  * HTML writer:

    + Don't emit missing title/lang warnings if templates does not
      contain the `pagetitle` or `lang` variables respectively (#9370).

  * LaTeX writer:

    + Better fix for lists in definition lists (#10241).
      In commit a26ec96d89ccf532f7bca7591c96ba30d8544e4a we added an
      empty `\item[]` to the beginning of a list that occurs first
      in a definition list, to avoid having one item on the line with
      the label. This gave bad results in some cases (#10241) and there
      is a more idiomatic solution anyway: using `\hfill`.
    + Avoid error on `refs` div with empty citations (#10185).
      If there are no citations, don't emit an empty CSLReferences environment.

  * RST writer:

    + Change bullet list hang from 3 to 2. This accords with the style in
      the RST reference docs.
    + Handle cases where indented context starts with block quote (#10236).
      In these cases we emit an empty comment to fix the point from
      which indentation is measured; otherwise the block quote is not
      parsed as a block quote. This affects list items and admonitions.
    + Don't enclose the list table in a `.. table::`; this leads to
      doubled captions (#10226).
    + Fix alignment of list table items corresponding to cells (#10227).

  * JATS template:

    + Support `floats-group` (Albert Krewinkel, see #10196).
      The content of the `floats-group` variable is now rendered in a
      `<floats-group>` element when using the *publishing* or *archiving* tag
      sets.

  * LaTeX and Beamer templates:

    + Split old default.latex into two templates, `default.latex` and
      `default.beamer`, factoring common parts into partials:
      `fonts.latex`, `common.latex`, `passoptions.latex`,
      `hypersetup.latex`, `after-header-includes.latex`.
    + Make `default.beamer` the default template for beamer.
    + Add `shorttitle`, `shortsubtitle`, `shortauthor`, `shortinstitute`,
      `shortdate` variables to beamer template (#10248, Thomas Hodgson).
    + Make `--number-sections` work with beamer (#12045, Thomas Hodgson).
    + Support a list of images for `titlegraphic` in beamer template
      (#10246, Thomas Hodgson). Title graphic options will be
      applied to each title graphic. Images will be separated by `\enspace`.
    + Beamer theme options (#10243)
    + Add theme options to beamer template: `colorthemeoptions`,
      `fontthemeoptions`, `innerthemeoptions`, `outerthemeoptions` (#10243,
      Thomas Hodgson).
    + Don't load amsmath, amssym in beamer template. These are loaded by
      beamer automatically.

  * Text.Pandoc.SelfContained:

    + Improve handling of links to remote CSS (#10261).

  * Text.Pandoc.Class:

    + Allow extracting `data:` URIs even in PandocPure (`--sandbox`)
      (#10249).
    + Export `extractURIData` [API change].

  * Text.Pandoc.PDF:

    + Read `.toc` and `.log` files from output directory (#10186).
      When this is different from the input directory, this is
      where `.toc` and `.log` files are written.

  * Text.Pandoc.Shared:

    + Modify `addPandocAttributes` for changes in commonmark-pandoc.
      The new commonmark-pandoc version automatically adds the
      attribute `wrapper="1"` on all Divs and Spans that
      are introduced just as containers for attributes that belong
      properly to their contents.  So we don't need to add the
      attribute here. This gives much better results in some cases.
      Previously the wrapper attribute was being added even for
      explicit Divs and Spans in djot, but it is not needed in these cases.

  * Text.Pandoc.Options:

    + Add `writerListOfFigures` and `writerListOfTables` fields
      to `WriterOptions` (#8245, Akash Patel). [API change]

  * Text.Pandoc.App:

    + Add `optListOfFigures` and `optListOfTables` to `Opt` (#8245)
      [API change].

  * Lua subsystem (Albert Krewinkel):

    + Update List module (#9835). The module now comes with a method
      `:at(index[, def])` that allows to access indices, accepts
      negative indices to count from the end, and will return the
      `def` value as a default if the list has no item at the given position.
      Furthermore, the list constructor `pandoc.List` now accepts iterators.
      E.g., `pandoc.List(text:gmatch '%S+')` returns the list of words
      in `text`.
    + Support character styling via `pandoc.layout`. The `Doc` values
      produced and handled by the `pandoc.layout` module can now
      be styled using `bold`, `italic`, `underlined`, or `strikeout`. The
      style is ignored in normal rendering, but becomes visible when
      rendering to ANSI output. The `pandoc.layout.render` function
      now takes a third parameter that defines the output style,
      either *plain* or *ansi*.
    + It is now possible to return a single filter from a filter file, e.g.
      ``` lua
      -- Switch single- and double quotes
      return {
        Quoted = function (q)
          elem.quotetype = elem.quotetype == 'SingleQuote'
            and 'DoubleQuote' or 'SingleQuote'
          return elem
        end
      }
      ```
      The filter must not contain numerical indexes, or it might be treated
      as a list of filters.
    + Add `list_of_figures` and `list_of_tables` to writer options
      (Akash Patel).

  * Use latest releases of commonmark, commonmark-pandoc, texmath, djot.

  * Stop depending on package SHA (Albert Krewinkel). Use `crypton` instead.

  * `linux/make_artifacts.sh`: add riscv64 support (Olivier Benz).

  * Fix invalid XML in `test/docx/normalize.docx` (#10242).

  * `doc/lua-filters.md`: list functions in `pandoc.utils` alphabetically
    (Albert Krewinkel).

  * MANUAL.txt:

    + Clarify  use of `beamerarticle` variable (#10250).
    + Add clarification to address user issues like #6704 (Yehuda Katz).

## pandoc 3.4 (2024-09-09)

  * New output format: `ansi` (for formatted console output) (Evan Silberman).
    Most Pandoc elements are supported and printed in a reasonable way, if
    not always ideally. This version does no detection of terminal
    capabilities, nor does it fall back to different output styles for
    less-capable terminals.

  * Add command line options `--table-caption-position` and
    `--figure-caption-position`. These allow the user to specify whether
    to put captions above or below tables and figures, respectively.
    The following output formats are supported: HTML (and related such
    as EPUB), LaTeX (and Beamer), Docx, ODT/OpenDocument, Typst.

  * Change default `--pdf-engine` via HTML to WeasyPrint (#10142).
    `wkhtmltopdf` is deprecated.  `weasyprint` is the easiest-to-install,
    maintained alternative.  For better results, one might prefer
    `pagedjs-cli`.

  * Org reader:

    + Fix parsing of src blocks with an `-i` flag (#10071, Albert Krewinkel).
      Tabs are now preserved in the contents of *src* blocks if the the block
      has the `-i` flag.

  * RTF reader:

    + Handle images inside `shp` contexts (#10145).

  * RST reader:

    + Improve simple table support (#10093). Multiline rows occur
      only when the *first* cell is empty; we were previously treating
      lines with *any* empty cell as row continuations. In addition, we
      no longer wrap multiline cells in Para if they can be represented
      as Plain. This is consistent with docutils behavior.

  * LaTeX reader:

    + Math environments don't have bracketed options (#10160).
    + Parse nested tabular environments (#4746).

  * Typst reader:

    + Change how "block" elements are handled. Previously they were
      always parsed as divs.  But actually they can occur in some "inline"
      contexts.  Now we first try to parse them as inlines, and only as
      blocks if that fails.  A surrounding Div or Span element is added
      only if there is an identifier.

  * HTML reader:

    + Only parse main element's contents (if present) (#10140).
      If main has an id or class, we include a div with that id or class;
      otherwise just the contents.
    + Read TeX annotation in MathML content if present (#9971).
    + Better handle KaTeX-generated math (#9971). KaTeX emits the mathml
      followed by a span with an HTML fallback. Previously pandoc was
      converting both.  We now ignore the HTML fallback span, marked
      with class `katex-html`.

  * Docx reader:

    + Add "SuppressAuthor" and "AuthorOnly" to citationMode
      when `+citations` is used (thomjur).

  * New module: Text.Pandoc.Writers.ANSI [API change] (Evan Silberman).

  * Docx writer:

    + Support `custom-style` attribute for docx table (Sebbones).
    + Support `--number-offsets`.
    + Make table/figure rendering sensitive to caption position settings.

  * OpenDocument writer:

    + Make table/figure rendering sensitive to caption position settings.

  * Typst writer/template:

    + Implement figure caption positions by triggering a show rule in
      the default template, which determines caption positions for
      figures and tables globally.
    + Don't include trailing semicolon after `@` style citations with suffixes
      (#10148).
    + Template: move header-includes before show doc (#9996, Gordon Woodhull).

  * LaTeX writer:

    + Make table/figure rendering sensitive to caption position settings (#5116).
    + Preserve locator labels with `--natbib` (#10057).

  * HTML writer/template:

    + Make `<figcaption>` placement sensitive to caption position
      settings. For tables, `<caption>` must be the first element, and
      positioning is determined by CSS, for here we set a variable
      which the default template is sensitive to.
    + Use `makeSectionsWithOffsets` for `writerNumberOffsets`,
      instead of the old, inefficient code.
    + Don't add doc-biblioref role to every link in a citation;
      only to links to the bibliography (#10156).
    + Add `data-` when rendering `label` attribute (#10048).

  * Markdown writer:

    + Avoid emitting markdown caption if table has fallen back to raw HTML,
      which will then contain a `<caption>` tag (#10094).
    + Make math sensitive to `tex_math_gfm` extension (#9121).
      This means that in GFM output, the "new style" math will be used
      by default, e.g.

          $`x=y`$

          ```math
          x = y
          ```

      To defeat this and get the older behavior, namely

          $x=y$

          $$x=y$$

      one could use `-t gfm-tex_math_gfm`.

  * AsciiDoc writer:

    + Add `link:` prefix when needed (#10105). AsciiDoc requires it
      except for `http`, `https`, `irc`, `mailto`, `ftp` schemes (#10105).
    + Preserve original base level (#10062). We used to normalize so
      that the base level is always 1, but asciidoc no longer seems
      to care about that, and the behavior creates difficulties when
      we are converting fragments.
    + Don't emit empty figure caption (#10047).

  * ODT writer:

    + Add TableCaption to styles.xml (#10058, Ian Max Andolina).

  * LaTeX template:

    + Fix wrong beamer color in (sub)section page (Jonathan).

  * Text.Pandoc.Options:

    + Add `CaptionPosition` and new `WriterOptions` fields
      `writerFigureCaptionPosition` and `writerTableCaptionPosition`
      [API change].

  * Text.Pandoc.Opt:

    + Change default for optNumberOffset to `[]`. This behaves the same as
      `[0,0,0,0,0]`.
    + Add `Opt` fields `optFigureCaptionPosition` and
      `optTableCaptionPosition` [API change].

  * Text.Pandoc.Format: change `formatFromFilePaths` so that it is
    smarter about URLs.  URLs are parsed, and we take the format from
    the path component, if present (#10141). This means that
    `https://emacs.org/` will be treated as HTML, while
    `https://emacs.org/sample.org` will be treated as Org.

  * Text.Pandoc.URI:

    + Add unofficial `gemini:` to list of URI schemes (Pau RE).

  * Text.Pandoc.Shared:

    + Add `makeSectionsWithOffsets` [API change].
    + Remove `stripEmptyParagraphs [API change] (Albert Krewinkel).
      This function is no longer used.

  * Text.Pandoc.Highlighting: Expose `formatANSI` [API change]
    (Evan Silberman).

  * Text.Pandoc.Writers.Shared: export `to{Sub,Super}scriptInline`
    [API change] (Evan Silberman).

  * Remove use of partial functions (e.g. `head`) in code.

  * Use latest skylighting-core, skylighting, doclayout, texmath, typst.

  * pandoc-lua-engine: Add accessors for several writer options, including
    some that were added in previous releases.

  * pandoc-server: Initialize some missing fields in WriterOptions:
    `writerEpubTitlePage`, `writerChunkTemplate`, `writerListTables`,
    `writerFigureCaptionPosition`, `writerTableCaptionPosition`.

  * CONTRIBUTING.md: Summarize steps for adding a new cli option.

  * MANUAL.txt:

    + Clarify that the `--number-offset` option should only
      directly affect numbering of the first section heading in
      a document; subsequent headings will increment normally.
    + Fix asciidoc link (#10039).
    + Fix CSL Docs broken link (#10100, Tristano Ajmone).
    + Document the use of `luatexja` when CJKmainfont is used with lualatex
      (#3873, Kolen Cheung).
    + Add a `citations` (typst) section to the manual (#9127).
    + Clarify that `citations` affects both input and output for `org`.
    + Add note on `--citeproc` that you may need to disable `citations`
      extension on the output format (e.g., `-t markdown-citations`) to
      see the rendered citation (#9127, #10012).

  * INSTALL.md — reorganise info on static binaries and add conda-forge
    install options (#10098, #10069, Ian Max Andolina).

## pandoc 3.3 (2024-07-28)

  * New cli option: `--link-images`.  This causes images to be linked
    rather than embedded in ODT.

  * Allow `--number-sections` to take an optional `true|false` argument.

  * RTF reader:

    + Handle `\*\shppict` without dropping image (#10025).

  * TWiki Reader:

    + Recognize WikiWords as internal links (#9941).
    + Avoid partial function.

  * Typst reader:

    + Ignore 'pad' and just parse its body (#9958).
    + Use typst 0.5.0.5. Fixes parsing of equations like `$1.$`.

  * Docx writer:

    + Fix regression with nested lists (#9994). The bug affects e.g.
      ordered lists with bullet sublists; after the sublist the top-level
      list reverts to bullets instead of being properly numbered.
      This is a regression introduced in version 3.2.1.

  * BibTeX writer:

    + Ensure that "literal" names are enclosed in braces (#9987).

  * Man writer:

    + Use default middle header when metadata does not include `header`
      (#9943).  This change causes pandoc to omit the middle
      header parameter when `header` is not set, rather than
      emitting `""`.  The parameter is optional and man will use
      a default based on the section if it is not specified.

  * HTML templates: don't load polyfill (#9918).
    This was added in a period when MathJaX required polyfill.
    MathJaX no longer recommends this and polyfill should no
    longer be necessary on any reasonably modern browser.

  * Translations:

    + Add `ua.yaml` (Jens Oehlschlägel).
    + Add a script (`tools/update-translations.py`) and Makefile
      target (`update-translations`) to update translation data
      automatically from babel and polyglossia upstream
      (Stephen Huan).
    + Use this script to update language data, increasing the number
      of languages we cover (Stephen Huan).  Fix a few small bugs in
      existing translations.

  * Fix some mistakes with Japanese language code (#9938).
    In several places we were mistakenly assuming that the BCP 47 code for
    Japanese language was `jp`.  It is `ja`.

  * Text.Pandoc.Options:

    + New field in WriterOptions: `writerLinkImages` [API change] (#9815).

  * Text.Pandoc.App.Opt:

    + New field in Opt: `optLinkImages` [API change] (#9815).

  * Lua subsystem:

    + Keep `lpeg` and `re` as "loaded" modules (Albert Krewinkel).
      The modules `lpeg` and `re` are now treated as if they had been
      loaded with `require`. Previously the modules were only assigned
      to global values, but could be loaded again via `require`,
      thereby allowing to use a system-wide installation. However, this
      proved to be confusing.

      The old behavior can be restored by adding the following lines to
      the top of Lua scripts, or to the `init.lua` in the data dir.

          debug.registry()['_LOADED'].lpeg = nil
          debug.registry()['_LOADED'].re = nil

  * `pandoc-cli`: Include pandoc copyright in Lua version info (Albert
    Krewinkel).

  * `pandoc-cli`: Refer printing of version info to the Lua interpreter
    (Albert Krewinkel). The Lua interpreter no longer terminates when
    called with `-v` or `--version` arguments, thus improving
    compatibility with the default `lua` interpreter program.

  * Avoid partial functions in JATS reader, DocBook writer, Haddock reader.

  * Allow tls 2.1.x.

  * MANUAL.txt:

    + Make documentation of extensions clearer (#9060).
    + Fix section level for two Extensions entries.

  * lua-filters.md: Partially autogenerate docs for module `pandoc`
    (Albert Krewinkel). The documentation system isn't powerful enough to
    generate the full documentation automatically.

## pandoc 3.2.1 (2024-06-24)

  * Fix `gfm_auto_identifiers` to replace emojis with their aliases,
    as documented (#9876).

  * CSV reader:

    + Turn line breaks into LineBreaks not SoftBreaks (#9797).

  * Docx reader:

    + Support task lists (#8211).
    + Fix a small bug in parsing delimiters in numbered lists,
      which led to the default delimiter being used wrongly in some cases.
    + Improve handling of captions.
      - Turn captioned images into Figure elements. Closes #9391.
      - Improve the logic for associating elements with captions (#9358).
      - Ensure that captions that can't be associated with an
        element aren't just silently dropped (#9610).
    + Support HorizontalRule. We support both pandoc-style and the style
      described on a Microsoft support page, an empty paragraph with
      a bottom border (#6285).
    + React to `"left"` value on `jc` attribute.
    + Handle column and cell alignments (#8551). We take the column alignments
      from the first body row.
    + Fix a bug that caused comments inside insertions or deletions
      to be ignored (#9833).

  * HTML reader:

    + Better handle non-`li` elements in `ul` and `ol` (#9809).
      For example, a `p` after a closed `li` will be incorporated into
      the previous `li`. This mirrors what browsers do with this
      invalid HTML.

  * LaTeX reader:

    + Fix parsing of dimensions beginning with `.`, e.g. `\kern.1pt` (#9902).

  * Markdown reader:

    + Allow author-only textual citations (#7219). E.g. `-@reese2002`
      outside of brackets.

  * RST reader:

    + Tighten up rules for when emphasis can start (#9805).
    + Support `:cite:` role with citeproc (#9904). A subset of the
      functionality of the sphinxcontrib-bibtex extension to Sphinx
      is supported.

  * Textile reader:

    + Don't let spans begin right after a symbol (#9878).

  * Typst reader:

    + Fix an incomplete pattern match (#9807).
    + Handle inline bodies ending in a parbreak. E.g.
      ```
      `#strong[
      test
      ]
      ```

  * ConTeXt template: remove `\setupbackend[export=yes]` (#9820).

  * Docx writer:

    + Allow OpenXML templates to be used with `docx` (#8338, #9069, #7256,
      #2928). The `--reference-doc` option allows customization of styles in
      docx output, but it does not allow one to adjust the content of the output
      (e.g., changing the order in which metadata, the table of contents,
      and the body of the document are displayed), or adding boilerplate
      text before or after the document body.  For these changes, one can
      now use `--template` with an OpenXML template.  (See the default
      `openxml` template for a sample.) `--include-before-body` and
      `--include-after-body` can also now be used with `docx` output.
      The included files must be OpenXML fragments suitable for
      inclusion in the document body.
    + New unexported module Text.Pandoc.Writers.Docx.OpenXML.
    + Omit `jc` attribute on table cells with AlignDefault (#5662).
    + Better formatting for task lists. Task lists are now properly
      formatted, with no bullet (#5198).
    + Replace an expensive generic traverse to remove Space elements,
      for better performance.
    + Wrap figures with `id` in a bookmark (#8662).
    + Add eastAsia font hints to `w:r` (#9817). We do this when the text
      in the run contains any CJK characters. This ensures that ambiguous
      code points (e.g. quotation marks) will be represented as "wide"
      characters when together with CJK characters.
    + Clean up Abstract Title and Subtitle in default reference docx.
      Center Subtitle, remove color.

  * HTML writer:

    + Ensure URI escaping needed for `html4` (#9905).
      Unicode characters need not be escaped for html5, and still won't be.
    + Don't emit unnecessary classes in HTML tables (#9325, Thomas Soeiro).
      Pandoc used to emit a `header` class on the `tr` element that forms
      the table header. This is no longer needed, because `head > tr` will
      do the same thing. Similarly, pandoc used to emit `even` and `odd`
      classes on `tr`s, allowing striped styling.  This is no longer needed,
      because one can use e.g. `tbody tr:nth-child(2n)`.
      Compatibility warning:  users who relied on these classes to style
      tables may need to adjust their CSS.

  * JATS writer:

    + Support `supplementary-material` in metadata for `jats_articlepublishing`
      (#9818).

  * LaTeX writer:

    + New method for ensuring images don't overflow (#9660).
      Previously we relied on graphicx internals and made global
      changes to Gin to force images to be resized if they exceed
      textwidth.  This approach is brittle and caused problems
      with `\includesvg` (see #9660). The new approach uses a new macro
      `\pandocbounded` that is now defined in the LaTeX template.
      (Thanks here to Falk Hanisch in https://github.com/mrpiggi/svg/issues/60.)
      The LaTeX writer has been changed to enclose `\includegraphics`
      and `\includesvg` commands in this macro when they don't explicitly
      specify a width or height. In addition, the writer now adds
      `keepaspectratio` to the `\includegraphics` or `\includesvg`
      options if `height` is specified without width, or vice versa.
      Previously, this was set in the preamble as a global option.
      Users should attend to the following compatibility issues:
      - If custom templates are used with the new LaTeX writer, they will have
        to be updated to include the new `\pandocbounded` macro, or an error
        will be raised because of the undefined macro.
      - Documents that specify explicit dimensions for an image may render
        differently, if the dimensions are greater than the line width or
        page height. Previously pandoc would shrink these images to fit,
        but the new behavior takes the specified dimensions literally.
        In addition, pandoc previously always enforced `keepaspectratio`,
        even when width and height were both specified, so images with
        width and height specified that do not conform to their intrinsic
        aspect ratio will appear differently.
    + Task lists must be unordered (#9185).
    + Specify language option for `selnolig` and only include it if
      `english` or `german` is used (#9863). (This includes changes to the
      LaTeX template.) This should restore proper ligature suppression when
      lualatex is used.
    + Fix `--toc-depth` with beamer output (#9861). Previously only top-level
      sections were ever included in the TOC, regardless of the setting of
      `--toc-depth`.
    + Use `\linewidth` instead of `\columnwidth` or `\textwidth`
      for resizing figures, table cells, etc. in LaTeX (#9775).
      `\linewidth`, unlike the others, is sensitive to indented environments
      like lists.

  * LaTeX template: put `babel-lang` in options to beamer (#9868).
    This is required to make beamer use proper localized terms for
    things like "Section."

  * Markdown writer:

    + Don't print extra caption when using `implicit_figures`.
    + Ensure blank line after HTML blocks in commonmark-based formats (#9792).
    + Fix bug rendering block quotes in lists (#9908).

  * Texinfo writer:

    + Ensure proper escaping in all node/link contexts.
    + Target node rather than anchor when possible in internal links.
    + Remove illegal characters from internal link anchors (#6177).
    + Use two commas not one in `@ref`.
    + Don't add anchors to headings. We don't need them, now that we
      make internal links use the node.
    + Avoid duplicate node names.
    + Improve menus. Properly handle the case where the node name is
      different from the descriptive title.

  * Texinfo template: add variables for filename and version.

  * Typst writer:

    + Support '.typst:no-figure' and 'typst:figure:kind=kind' attributes
      (#9778, Carlos Scheidegger). This extends support for fine-grained
      properties in Typst. If the `typst:no-figure` class is present on a
      Table, the table will not be placed in a figure. If the
      `typst:figure:kind` attribute is present, its value will be used
      for the figure's `kind` (#9777). These features are documented in
      `doc/typst-property-output.md`.

  * Typst template:

    + Add subtitle (#9747, Mickaël Canouil).
    + Use content rather than string for title, author, date, email (#9823).
      This allows formatting in title, author, date, and email fields.
      Since the PDF metadata requires a string, and typst only
      converts the title to a string (not the authors), we use

  * Textile writer:

    + Get rid of header, odd, even classes on `tr` (#9376).

  * Text.Pandoc.Class:

    + `fillMediaBag`: Convert IOErrors to warnings when fetching absolute
       paths (#9859, Albert Krewinkel).  This will allow many conversions that
       would have failed with an error to succeed (albeit without images or
       other needed resources).

  * Text.Pandoc.ImageSize:

    + Don't prefer exif width/height when they conflict with image
      width/height (#9871).  That was a mistaken call in #6936.
      Usually when these values disagree, it is because the image
      has been resized by a tool that leaves the original exif values
      the same, so the width/height metadata are more likely to be
      correct that exif width/height.

  * Text.Pandoc.SelfContained:

    + Strip CRs from XML before base64 encoding for data URI
      (so tests can work on Windows).
    + Only create `<svg>` elements for SVG images when the image has
      the class `inline-svg`. Otherwise just use a `data` URI as we do
      with other images (#9787).

  * Lua subsystem (Albert Krewinkel):

    + Split Init module into more modules. The module has grown unwieldy and
      is therefore split into three internal Haskell modules, `Init`,
      `Module`, and `Run`.
    + Add function `pandoc.utils.run_lua_filter` (#9803).
    + Add function `pandoc.template.get` (#9854, co-authored by Carsten Gips).
      The function allows to specify a template with the same argument value
      that would be used with the `--template` command line parameter.
    + Keep CommonState object in the registry. The state is an internal
      value and should be treated as such. The `PANDOC_STATE` global is
      merely a copy; unsetting the global no longer breaks the Lua engine.
    + Allow passing an environment to `run_lua_filter`.
      The default is now to use a *copy* of the global environment when running
      a filter; this ensures better separation when `run_lua_filter` is used
      multiple times. A custom environment can be specified via the
      optional third parameter.
    + Set `pandoc.List` as default metatable for JSON lists (#9834).
      Lists created by `pandoc.json.decode` now behave like lists generated
      via `pandoc.List`. This also ensures that `pandoc.List` tables are
      encoded as JSON arrays when passed to `pandoc.json.encode`.

  * Text.Pandoc.Writers.Shared: export `toTaskListItem` [API change].

  * Add unexported module Text.Pandoc.Char. This exports `isCJK`.
    Use this instead of locally defined `isCJK` in T.P.Readers.MediaWiki.

  * MANUAL.txt:

    + Remove false claim that Lua mode does not support `-i` (#9757,
      Ian Max Andolina).
    + Use level-3 headings for extensions (to avoid gaps).
    + Add anchor for tagging extension.
    + Remove explicit referencess to generate anchors.
      These will be linkified automatically.
    + Fixed links to `option--reference-doc`.
    + Add a note that column widths aren't supported in pptx for Divs
      with class `columns` (#9890).
    + Fix alerts example (#9826, Ian Max Andolina).
    + Fix markup of `babelfonts` example code (Albert Krewinkel).

  * `doc/custom-writers.md`:

    + Fix usage of Template in example (Albert Krewinkel).
    + Document the separator arg of `Writer.Blocks` (Albert Krewinkel).

  * `doc/lua-filters.md` (Albert Krewinkel):

    + Fix outdated documentation for math and quoting functions and fields.
    + Autogenerate docs for module `pandoc.template` and `pandoc.layout`.
    + Document operators of the "Doc" type.

  * pandoc-lua-engine: depend on pandoc >= 3.2 (see #9755).

  * Allow crypton-connection 0.4, time 1.14.

  * Allow tasty-quickcheck 0.11.

  * Use latest emojis, skylighting, skylighting-core, citeproc, djot,
    commonmark-extensions, typst-hs

## pandoc 3.2 (2024-05-11)

  * Change to `--file-scope` behavior (#8741): previously a Div with an
    identifier derived from the filename would be added around the contents
    of each file. This caused problems for "chunking" files into chapters,
    e.g. in EPUB. We no longer add the surrounding Div. This cooperates
    better with chunking. Note, however, that if you have relied on the old
    behavior to link to the beginning of the contents of a file using
    its filename as identifier, that will no longer work.

  * Markdown reader:

    + Allow repeated labels in numbered example lists.
      Previously if you tried to use the same label as an earlier
      example list item, you'd get a new number, not the old one,
      and references to the label would go to the second occurrence.
      Now an existing label will be reused, and no new number will
      be generated.  Caveat:  this only works reliably when the
      re-used example list item occurs by itself in a list, or
      occurs in a list of previously used example list items that
      occur in exactly the same order as previously.
    + Fix `normalCite` so it doesn't consume past a closing `]` boundary
      (#9710).  This was causing an exponential performance bug on long
      lists of links containing potential emphasis characters.
    + Generalize `inlinesInBalancedBrackets` to `inBalancedBrackets`,
      with a parameter for the inner parser.
    + Auto-close unclosed divs (#9635). This applies to both fenced and
      HTML-ish varieties. Otherwise we face an exponential performance
      problem with backtracking. A warning is issued when a div is
      implicitly closed.

  * RST reader:

    + Fix `figclass` and `align` annotations for figures (#7473, Gokul
      Rajiv).

  * LaTeX writer:

    + Use `polytonicgreek` instead of `polutonikogreek` with babel (#9698).
      `polutonikogreek` is outdated. Also recognize both in the LaTeX
      reader.
    + Improve treatment of math inside soul commands (#1294, #5529).
      soul commands (`ul`, `hl`, `st`) are very fragile and the math
      must be handled specially.

  * LaTeX reader:

    + Fix over-eager macro expansion in conditionals (#9676).
    + Parse `flalign`, `flalign*` math environments (#9679). We parse
      these as Math elements with an `aligned` environment. Semantically
      it's not exactly the same, but better than falling back to raw LaTeX.

  * LaTeX template: add `titlegraphicoptions` variable (#9207, Guilhem
    Saurel).

  * Docx reader:

    + Issue warning rather than error when we can't parse EndNote citations
      (see #8433).
    + Fix anchor in header after anchor (#9626, mbracke).

  * RTF reader:

    + Don't try to handle non-default code pages (#9683). Emit a warning
      instead.

  * OpenDocument writer:

    + Implement custom-style for spans (#9657).

  * Typst writer:

    + Add blank line in definition lists with multiple definitions (see
      #9704).
    + Property output (#9648, Gordon Woodhull). The Typst writer will pass
      on specially marked attributes as raw Typst parameters on selected
      elements. This allows extensive customization using filters.
      A separate document (`doc/typst-property-output.md`) has been added
      that provides extensive documentation and examples of the use of
      this feature.

  * Markdown writer:

    + Don't try to align columns in pipe tables with lines greater than
      COLUMNS. The alignment just reduces readibility when the lines
      soft wrap.
    + Don't use `raw_attribute` syntax for raw blocks, unless there is no
      other option (see #9677).  Macros in a `raw_attribute` block don't
      get interpreted when it is read again by pandoc's markdown reader.

  * ConTeXt writer:

    + Replace depreciated `\sc` with `\setsmallcaps` (#9518, James P.
      Ascher).

  * Docx writer:

    + Use conventional styles/indents for Word bullet lists (#7280).

  * `reference.docx`:

    + Use current standard Word theme (#7280). This includes using the
      sans-serif font Aptos instead of the serif font Cambria, and
      default colors for headings.
    + Remove duplicate `DefaultParagraphFont` in `styles.xml`.

  * New module Text.Pandoc.Transforms [API change] (Albert Krewinkel).
    This module exports the following functions which were formerly
    exported from Tetx.Pnadoc.Shared: `headerShift`,
    `filterIpynbOutput`, `eastAsianLineBreakFilter`, as well as some
    functions that were previously not exported.

  * Text.Pandoc.Shared:

    + `headerShift`, `filterIpynbOutput`, and `eastAsianLineBreakFilter`
      are no longer exported from this module; they are now exported
      from Text.Pandoc.Transforms (Albert Krewinkel).

  * Text.Pandoc.Error:

    + Improve reporting of unsupported extensions errors (#9247, Albert
      Krewinkel).

  * Text.Pandoc.App:

    + Move "transforms" after filters (#9664). This will mean that
      `--shift-heading-level-by` affects a heading added by
      `reference-section-title`.

  * Text.Pandoc.App.CommandLineOptions:

    + Simplify output for `OptVersion`. Omit the information about versions
      of dependencies. We no longer emit version info at this level anyway;
      `pandoc-cli` intercepts and handles `--version`. This code would
      only be called if someone used the pandoc library function
      `handleWithOptInfo` in their own program.

  * Text.Pandoc.ImageSize:

    + Export `ImageSize` datatype.

  * Text.Pandoc.SelfContained:

    + Merge class attribute when both img and svg specify it (#9652,
      Carlos Scheidegger).

  * Text.Pandoc.Logging:

    + Add `ScriptingInfo` constructor for `LogMessage` [API change]
      (Albert Krewinkel).
    + Make `DocxParserWarning` a WARNING, not INFO. [API change].
    + Add `UnsupportedCodePage` constructor to `LogMessage` [API change].
    + Add `UnclosedDiv` constructor for `LogMessage` [API change].

  * Lua subsystem (Albert Krewinkel:

    + Add a `pandoc.log` module.
    + Uupdate to pandoc-lua-marshal version 0.2.7 (#8916).
      This fixes counterintuitive behavior of the `content` property on
      BulletList and OrderedList items. Unmarshalling of that field now
      matches the behavior of the constructor.
    + Use newest zip module. This adds a `symlink` function to Entry objects,
      allowing to check if an entry represents a symbolic link.
    + Improve `pandoc.json.decode` docs.
    + Update and fix docs for `pandoc.types.Version` and `pandoc.utils.type`.
    + Add new module `pandoc.image` The module provides basic querying
      functions for image properties.
    + Bump pandoc-lua-engine to 0.2.1.4.

  * Use latest KaTeX CDN asset (#9707, Salim B).

  * `pandoc-cli`: ensure UTF8 when emitting version info.

  * tools/update-lua-module-docs.lua: improve script-internal docs, cleanup
    (Albert Krewinkel).

  * Allow network 3.2.

  * Use latest versions of texmath, djot, skylighting-core, skylighting.

  * Fix command test for #9652.

  * Fix some typos in code comments (#9638, guqicun).

  * Command tests: include regular PATH after directory with the test
    executable (ensures that DLLs will be found on Windows).

  * MANUAL.txt:

    + Document `handout` variable for beamer (#9742).
    + Document formats affected by `--slide-level` (#9745).
    + Update the list of required LaTeX packages (#9728, Albert Krewinkel).
    + Use more descriptive link text for ODT (#9673).
    + Add clarification about `toc-title` in `docx`, `pptx` (#9645).
    + Better document truthiness for conditionals (#9661).
    + Mention that `custom-style` works with ODT (Ian Max Andolina).
    + Harmonize typographic dashes (#9688, Salim B). Standardize on `---`
      with no space.

  * INSTALL.md: Minor tweaks (#9705, Leo Heitmann Ruiz).

## pandoc 3.1.13 (2024-04-07)

  * Org reader:

    + Fix treatment of `id` property under heading (#9639).

  * DocBook reader:

    + Add empty title to admonition div if not present (#9569).
      This allows admonition elements (e.g. `<note>`) to work with
      `gfm` admonitions even if the `<title>` is not present.

  * DokuWiki reader:

    + Link text cannot contain formatting (e.g., `//` is not italics) (#9630).
    + An explicitly empty link text (`[[url|]]`) works the same as an omitted
      link text (#9632).

  * Typst reader:

    + Support Typst 0.11 table features: col/rowspans, table head
      and foot (#9588).
    + Parse cell col/rowspans.

  * CSLJson writer:

    + Put `$` or `$$` around math in `csljson` output (#9616).

  * ConTeXt writer:

    + Fix options order with `\externalfigure`. The dimensions should
      come after the class if both are present.

  * Typst writer:

    + Put label after Span, not before. Labels get applied to preceding markup
      item.
    + Support Typst 0.11 table features (#9588): colspans, rowspans,
      cell alignment overrides, relative column widths,
      header and footer, multiple table bodies with intermediate headers.
      Row heads are not yet supported.
    + The default typst template has been modified so that tables
      don't have lines by default. As is standard with pandoc, we only
      add a line under a header or over a footer. However, a different
      default stroke pattern can easily be added in a template.
    + More reliable escaping in inline `[..]` contexts (#9586). For example,
      we need to escape `[\1. April]` or it will be treated as an ordered list.
    + Handle `unnumbered` on headings (#9585).

  * LaTeX writer:

    + Fix math inside strikeout (#9597).

  * Text.Pandoc.Writers.Shared:

    + Export `isOrderedListMarker` [API change].

  * Change lhs tests so they don't use `--standalone`.
    This will avoid test failures due to minor changes in
    skylighting versions, e.g. #9589.

  * Use latest texmath, typst.

  * Require pandoc-lua-marshal 0.2.6 (#9613, Albert Krewinkel).
    Fixes an issue arising when the value of `content` properties
    on *BlockQuote*, *Figure*, and *Div* elements was an empty list.

  * Update lua-filters.md (#9611, Carlos Scheidegger).


## pandoc 3.1.12.3 (2024-03-17)

  * Markdown reader: Fix bug with footnotes at end of fenced div (#9576).

  * LaTeX reader:

    + Improve tokenization of `@` (#9555). Make tokenization sensitive to
      `\makeatletter`/`\makeatother`. Previously we just always treated
      `@` as a letter.  This led to bad results, e.g. with the sequence `\@`.
      E.g., `a\@ b` would parse as "ab" and `a\@b` as "a".
    + Make `withRaw` work inside `parseFromToks` (#9517).
      This is needed for raw environments to work inside table cells.
    + Better handling of table colwidths (#9579). Previously the parser just
      failed if the column width specified in `p{}` wasn't a multiple of
      `\linewidth`. This led to cases where content was skipped.

  * Typst writer:

    + Add 'kind' parameter to figures with tables (#9574).
    + Avoid unnecessary box around image in figure (#9236).
    + Omit width/height in images unless explicitly specified (#9236).
      Previously we computed width/heigth for images that didn't have
      size information, because otherwise typst would expand the image
      to fit page width. This typst behavior has changed in 0.11.
      This change fixes a bug in which images would sometimes overflow
      page margins, depending on their intrinsic size.
    + Don't add hard-coded `inset` to tables (#9580). Instead, set this
      globally in the default template, allowing it to be customized.

  * LaTeX template: Fix block headings support for unnumbered paragraphs
    (#9542, #6018, Oliver Fabel).

  * HTML templates: Replace polyfill provider (#9537, @SukkaW).
    Replace polyfill.io with cdnjs.cloudflare.com/polyfill.
    polyfill.io has been acquired by Funnull, and the service has
    become unstable.

  * Korean translations: delete colon in translation for 'to'.
    This was invalid YAML, and not desired anyway, since a colon
    is added.

  * Use latest commonmark, commonmark-extensions.
    This fixes a 3.12 regression in parsing of commonmark/gfm autolinks
    (jgm/commonmark-hs#151).

  * Depend on djot 0.1.1.3, which fixes a serious parsing bug affecting
    regular paragraphs after lists.

  * Depend on latest skylighting, skylighting-core, typst-hs, texmath.

  * MANUAL.txt: Change broken link to IDML cookbook (#9563).

## pandoc 3.1.12.2 (2024-02-29)

  * Docx reader:

    + Ensure that table captions are counted (#9518).
    + Detect caption by style name not id (#9518).
      The styleId can change depending on the localization.
    + Avoid emitting empty paragraph where caption was.

  * Markdown reader: fix regression in link parsing with wikilinks extensions
    (#9481).  This fixes a regression introduced in 3.1.12.

  * Org reader/writer: support admonitions (#9475).

  * Org writer: omit extra blank line at end of quote block.

  * Typst writer: ensure that `-`, `+`, etc. are escaped at beginning of block
    (#9478). Our recent relaxing of escaping (#9386) caused problems for
    things like emphasized `-` characters that were rendered using
    `#strong[-]#`.  This now gets rendered as `#strong[\-]`.

  * LaTeX writer: fix bug when a language is specified in two different ways
    (#9472). If you used `lang: de-DE` but then had a span or div with
    `lang=de`, the preamble would try to load `ngerman` twice, leading
    to an error. This fix ensures that a language is only loaded once.

  * Docx writer: Don't copy over `footnotePr` in `settings.xml`
    from reference.docx (#9522).

  * EPUB writer: omit EPUB2-specific meta tag on EPUB3 (#9493).
    This caused a validation failure in epubs with cover images.

  * Lua: avoid crashing when an error message is not valid UTF-8 (Albert
    Krewinkel).

  * Text.Pandoc.SelfContained:

    + Add `role="img"` to svgs.
    + Add `aria-label` to svg elements with `alt` text if present.
      Screen readers ignore `alt` attributes on svg elements but do
      pay attention to `aria-label` (#9525).

  * Text.Pandoc.Shared: Fix regression in section numbering in
    `makeSections` (#9516). Starting with pandoc 3.1.12, unnumbered
    sections incremented the section number.

  * Text.Pandoc.Class: fix `openUrl` TLS negotiation (#9483).
    With the release of TLS 2.0.0, the TLS library started requiring
    Extended Main Secret for the TLS handshake. This caused problems
    connecting to zotero's server and others that do not support TLS 1.3.
    This commit relaxes this requirement.

  * Depend on djot 0.1.1.0 (fixes rendering on multiline block attributes).

  * Use new releases of skylighting-format-blaze-html (#9520).
    Fixes auto-wrapping of long source lines in HTML print media.

  * Use new commonmark-extensions (fixes issue with the
    `rebase_relative_paths` extension when used with commonmark/gfm.

  * Makefile: improve epub-validation target (#9493).
    Use `--epub-cover-image` to catch issues that only arise with that.

## pandoc 3.1.12.1 (2024-02-17)

  * EPUB writer: omit EPUBv3-specific accessibility features on epub2
    (#9469). Fixes a regression in 3.1.12.

  * More fixes for SVG ids with `--self-contained` (#9467).
    This generalizes the fix to #9420 so it applies to things like
    `style="fill(url(#..."` and should fix problems with SVGs including
    gradients.

  * Powerpoint writer: properly handle math in headings and tables (#9465).
    This ensures that paragraphs containing math are wrapped in
    a `mc:AlternateContent` node as required.

  * Makefile: make validate-epub check v2 output too.

## pandoc 3.1.12 (2024-02-14)

  * Add `djot` as input and output format. Djot is a light markup syntax
    (https://djot.net).

    + New module Text.Pandoc.Readers.Djot [API change]. The function
      `readDjot` is also exported by Text.Pandoc.Readers.
    + New module Text.Pandoc.Writers.Djot [API change]. The function
      `writeDjot` is also exported by Text.Pandoc.Writers.

  * `--number-sections` now uses the first digit for the number of
    the top-level section, no matter what its level. So if the top-level
    section is level-2, numbers will be `1`, `2`, etc. rather than
    `0.1`, `0.2`, as in the past (#5071). For some backwards compatibility,
    we revert to the old behavior when the `--number-offset` option is used.

  * DocBook reader:

    + Better handling of `<procedure>` and `<substeps>` (#9341):
      `<procedure>` now gets parsed as an ordered list, and
      `<substeps>` as a sublist.

  * Man reader:

    + Move spaces outside of emph/strong (#9445).

  * MediaWiki reader:

    + Don't make leading blanks underscores in image links (#9425).
    + Allow lowercase `image:` (#9424).

  * BibTeX reader:

    + Support `pagetotal` in converting BibLaTeX.

  * Markdown reader:

    + Fix wikilinks extensions to allow newlines in titles (#9454).

  * EPUB reader:

    + Don't put `#` characters in identifiers.

  * LaTeX reader:

    + Improve treatment of `\cref`, `\Cref` (#7463). Use the
      reference-type `ref+label` and `ref+Label`. Also, associate with
      `\vref` `ref` instead of `ref+page`.
    + Limited support for `\Cref` (#7463).
    + Generate relative widths for `\linewidth`, `\textheight` (#9388).

  * Typst reader:

    + Fix handling of `\overline` (#9294). Due to a typo, it was being
      incorrectly rendered as an `\underset`.
    + Improve handling of inline `#quote` (#9413).
    + Fix handling of `dot()`, `tilde()`, `ddot()` (jgm/typst-hs#38).
    + Fix character used for `norm` (jgm/typst-hs#38).

  * Typst writer:

    + Use reference form (e.g. `@jones2000[p. 30]`) for citations when
      possible.
    + Use `#ref` or `@` for links with `reference-type="ref"` (#7463).
      This attribute is added to LaTeX `\cref`, for example.
    + Improve citation support (#9452). Emit `form: "prose"` or `form: "year"`
      qualifiers if the citation is author-in-text or suppress-author.
      Strip initial comma from suffix, since typst will add an extra one.
    + Unescape URI escapes in image paths (#9389).
    + Handle labels and citaiton ids with spaces and other special
      characters (#9387). In these cases, we produce an explicit `label()`
      rather than using `<>` or `@`.
    + Avoid producing illegal labels (#9387).
    + Avoid unnecessary escapes (#9386).

  * LaTeX writer:

    + Make writer sensitive to `empty_paragraphs` extension (#9443).
    + Fix beamer highlighting (mh4ckt3mh4ckt1c4s).
    + Create valid table even when table is empty (#9350).
    + Set font fallback for babel main font (Max Heller).
    + Add some kerns where needed between quotes (#9371).

  * HTML writer:

    + Add suffix to multiple footnote section ids, so they are
      unique (Sam May). This is necessary when `--reference-location`
      is `block` or `section`.

  * EPUB writer:

    + Add ARA roles for accessibility (#9378, Iacobus1983).
      Footnote references are given role "doc-noteref", footnote text
      gets "doc-footnote", and nav gets "doc-toc".
    + Ensure that an alt attribute is always added (#9354). This seems to
      be required by iBooks; even an empty alt attribute will satisfy it.
    + Add `xml:lang` to package element (#9372).
    + Add accessibility metadata to EPUB metadata (#9372, #9400,
      Iacobus1983 and John MacFarlane). Reasonable default values are
      used to ensure that pandoc's EPUBs conform to the EU Accessibilty Act
      requirements, but values can be overridden using metadata.

  * Docx writer:

    + Restore ability to center-justify table (#9393). The fix to
      #5947 caused all tables to be left indented. This was necessary
      to avoid extra indentation in table cells when a table appeared
      in a list item. This change makes the changes conditional, so
      that they only affect tables in list items.

  * Man writer:

    + Fix bug with long URLs (#9458). URLs with more than 68 characters didn't
      display properly because of wrapping.
    + Support (limited) syntax highlighting in code blocks (#9446).
      Currently only boldface and italics are supported. The `monochrome`
      style might be of use for those generating man pages.

  * Org writer:

    + Escape special lines in code blocks (#9218, Albert Krewinkel).

  * Markdown writer:

    + Use different width fences for nested divs (#9450). Outer divs
      have longer fences. This aids clarity for the reader, making it
      easier to see where the div ends. It also makes the output
      compatible with some other implementations, e.g. micromark,
      which require different-width fences for nesting.
    + Fix output for pipe tables with a huge number
      of columns (#9346). Previously we got invalid pipe tables when the
      number of table columns exceeded the setting of `--columns`.

  * Powerpoint writer:

    + Fix regression in layout for slides with figures (#9442).
    + Use internal column widths in pptx writer tables (#5706,
      Tomas Dahlqvist). The table writer used to only divide all
      available width evenly for all columns. In this update the code
      uses the incoming widths if they are available. If they are not
      set the earlier even distribution is used. Some of the golden
      templates are adjusted slightly because of different rounding when
      using the new calculation model.

  * Custom writers:

    + Fix handling of common state (#9229, Albert Krewinkel).
      The CommonState (`PANDOC_STATE` in Lua) may change between the time that
      a custom writer script is first loaded and when the writer is run.
      However, the writer was always using the initial state, which led to
      problems, e.g. when the mediabag was updated in a filter, as those
      updates where not visible to the writer. The state is now updated
      right before the writer function runs.

  * Text.Pandoc.SelfContained:

    + Fix id replacements in SVGs with clipping paths (#9420).
      This fixes `--embed-resources` when SVGs have `clip-path` attributes.
    + Fix size of duplicated SVGs with `--embed-resources` (#9439).

  * ConTeXt template: support font fallback (#9361, Lawrence Chonavel).

  * Text.Pandoc.Shared:

    + `addPandocAttributes`: use `wrapper` attribute, not `wrap`, for
      Divs and Spans added as wrappers to hold attributes on elements
      that do not accept them.
    + `makeSections` behavior changes:
      - When the optional base level parameter is provided, we no
        longer ensure that the sequence of heading levels is gapless
        (#9398). Instead, we set the lowest heading level to
        the specified base level, and adjust the others accordingly. If
        an author wants to skip a level, e.g. from level 1 to level 3,
        they can do that. In general, the heading levels specified
        in the source document are preserved; `makeSections` only
        puts them into a hierarchical structure.
      - Section numbers are now assigned differently, as described above
        under `--number-sections` changes (#5071).
    + Improve `makeSections` code for section number calculation.

  * Text.Pandoc.Chunks:

    + Autogenerate unique ids for sections missing them (#9383).
      This is needed for TOC generation to work properly. We can't
      create TOC links if there are no ids. This fixes some EPUB validation
      issues we've been getting since switching over to Chunks for chunking.
    + Improve `fixTOCTreePaths`. We weren't adding ids for section headings
      that don't head a chunk, but these headings are needed for a TOC.

  * Lua: catch encoding error in `pandoc.read` (#9385, Albert Krewinkel).
    Fixed a bug that could lead to an un-catchable error and program
    termination when `pandoc.read` was called with invalid UTF-8 input.

  * LaTeX template: support font fallback (lawcho).  This support is
    LuaLaTeX-specific.  See MANUAL.txt for documentation.

  * Text.Pandoc.Readers: Add `readMan` to exports [API change] (George Stagg).

  * Text.Pandoc.PDF:

    + Reliably detect when TOC has changed (#9295). Sometimes the TOC
      changes but there are no warnings: this happens when no labels
      are present. In this case we must rerun LaTeX. So we now take the
      SHA1 hash of the TOC file and rerun LaTeX if it changes between runs.
    + Increase maximum number of LaTeX runs to 4 (#9299). On some documents,
      4 runs are needed (e.g. when a LastPage reference is used).
    + Avoid `readFileLazy`, which caused improperly cleaned-up
      temp directories on Windows (#9460).

  * MANUAL.txt:

    + Harmonize spelling of Markdown and MultiMarkdown (#9402, Salim B).
    + Add `<pre>` to list of exceptions for `markdown_in_html_blocks`
      extension (#9305).
    + Add clarification to docs for `--resource-path` (#9417).

  * Makefile: Validate generated EPUB as part of prerelease checks.

  * Add validation for docx golden files to CI (Edwin Török).

## pandoc 3.1.11.1 (2024-01-05)

  * Docx reader:

    + Fix HYPERLINK with only switch and no argument (#9246).

  * Org reader:

    + Parse caption and label for grid tables (#9279).

  * MediaWiki reader:

    + Handle multiline math in list items (#9293).

  * OPML writer:

    + Respect `--wrap` options & `--columns` in contents of notes (#9297).

  * ODT/OpenDocument writers:

    + Properly handle highlighting styles (#9287). These styles were
      going into an `office:styles` element in `content.xml`, but this
      is invalid. Instead they must go in `styles.xml`. The variable
      `highlighting-styles` no longer has any effect on the default
      opendocument template, and highlighting styles are not included
      in `opendocument` output.

  * Markdown writer:

    + Add table identifier at end of caption if present (#9279).

  * Text.Pandoc.PDF:

    + Expand list of environment variables to display in verbose output
      (#9303).
    + Ensure that we find all the LaTeX warnings requiring a rerun (#9284).
      This should fix a regression from 3.1.9 that led to incorrect
      alignments in tables (and possibly other issues).

  * Docx writer:

    + Ensure that pandoc's output validates (Edwin Török, #9273, #9269,
      John MacFarlane, #9265, #9266, #9264).
    + Don't emit empty table rows, which seem to cause problems for
      Word (#9224).

  * LaTeX writer:

    + Omit superfluous page locator label when used with `--natbib` or
      `--biblatex` (#9275). These will treat a bare number as a
      page locator, and they will be able to localize it. Note that the
      recognition of the locator label is locale-sensitive; if `lang` is
      `de`, then `S. 33` is a page reference, and `p. 33` is not!

  * Text.Pandoc.Chunks: Fine tune `makeChunks` (#9281).

    + Ensure that chunks not based on sections (those with the
      "preamble" class) get unique identifiers, by appending chunk number.
    + This will also ensure that they get unique path names when
      the path is generated from the identifier.

  * Default HTML5 template: remove html5shiv (and support for IE < 9).

  * Makefile:

    + Fix `make quick-stack`: `j` was expecting a number (Edwin Török).
    + Run built pandoc (instead of pandoc in path).
    + Add `validate-epub` target, using `epubcheck` to test the golden files.
    + Add `validate-docx-golden-tests` target.

## pandoc 3.1.11 (2023-12-15)

  * Typst writer:

    + Emit `;` after typst code, unless followed by space (#9252).
      Otherwise there's the potential that the typst code will swallow
      up a following character.

  * Text.Pandoc.Logging:

    + Add `MakePDFWarning` constructor to LogMessage [API change].
    + Add `MakePDFInfo` constructor to LogMessage [API change].

  * Text.Pandoc.PDF:

    + LaTeX warnings are passed on to the user as warnings.
    + Use `report` with `MakePDFWarning` and `MakePDFInfo` to relay
      verbose information and warnings, instead of writing directly
      to stderr.
    + Parse logs to determine whether additional runs needed, instead of
      running a fixed number of times (#9255). (The number of times
      that was appropriate given pandoc's default templates didn't
      always work for custom templates, and thus pandoc 3.1.10's
      change in the number of runs led to some regressions in PDF
      production.)

  * Makefile: in `make prelease`, add checks that pandoc-cli and
    pandoc have the same version, that pandoc-cli depends on this
    exact version of pandoc, that there is an entry for this version
    in the changelog, and that the version numbers in the
    generated man pages are correct.

  * Regenerate man pages with pandoc 3.1.10. This properly escapes hyphens
    and fixes version numbers in man pages for `pandoc-server` and
    `pandoc-lua`.

  * Depend on texmath 0.12.8.6. This omits unneeded `lr`s in typst
    math output.

  * Depend on typst 0.5. This allows the typst reader to support
    multiline strings, the version type, and the `as`
    keyword with `import`.

## pandoc 3.1.10 (2023-12-12)

  * Link pandoc-cli version to pandoc version. Henceforth pandoc-cli's
    version will be synchronized with pandoc's, and pandoc-cli will
    depend on an exact pandoc version. This will avoid confusion by
    ensuring that `cabal install pandoc-cli-X.Y.Z` installs pandoc
    version X.Y.Z. It will make things more straightforward for
    upstream packagers (see #9232). This scheme does not follow the
    Haskell PVP, but that should cause no harm, because this package
    does not expose a library.

  * Add `alerts` markdown extension. This enables GitHub style markdown
    alerts as a commonmark extension. This extension is now default for
    `gfm`. It can't be used with `markdown`, only with `commonmark` and
    variants.

  * Markdown reader:

    + Preserve newlines in math instead of changing to spaces.
      Otherwise we can get unwanted results if there's
      a `%` comment (#9193).
    + Make attributes work with reference links (#9171).

  * HTML reader:

    + Improve handling of invalidly nested sublists (#9187, cf. #8150).

  * MediaWiki reader:

    + Allow attribute keys with hyphens (#9178).

  * ODT reader:

    + Support attr `text:continue-numbering` (#8979, Stephan Meijer).

  * Typst reader:

    + Allow references (e.g. `@foo`) to become citations
      if there is no corresponding label in the document.
    + Collapse adjacent `cite` elements.
    + Handle supplements in `cite`.
    + Change `cite` (only one key allowed, a label) (typst 0.9 breaking change).
    + Support `quote` element (typst 0.9).

  * LaTeX reader:

    + Handle otherlanguage environment and language-name environments like
    `\begin{french}...\end{french}` (#9202).
    + Fix theorem label parsing (#8872, Hikaru Ibayashi).

  * Docx reader:

    + Unwrap content of shaped textboxes (Stephan Meijer, #9214).
    + Improve handling of `w:sym` (#9220). We now look up symbols in symbol
      fonts using the table defined at Text.Pandoc.Readers.Docx.Symbols.
    + Add unexported module Text.Pandoc.Readers.Docx.Symbols. This gives us a
      table to use to resolve characters included in docx via `w:sym` element.

  * Man reader:

    + Properly handle `.sp` macro inside lists and block quotes (#9201).

  * LaTeX writer:

    + Fix bug with big footnotes inside emphasis (#8982, Hikaru Ibayashi).
    + Handle identifiers inside heading contents. `\phantomsection` can't
      be used in this case, so we need `\hypertarget` (#9209).

  * LaTeX template:

    + Include `bookmark` package unconditionally. This package
      produces better PDF bookmarks than `hyperref` and does it on the
      first pass.

  * Typst writer:

    + Use `quote` for block quotes.
    + Support `--toc-depth` as in other writers (#9242).
    + Put inline image dimensions on enclosing box, not image (#9104).
    + Better handling of tables with captions (#9194).
      We now put these in a figure with a caption argument.
    + Update typst writer to typst 0.9 citation format (#9188).

  * Typst template:

    + Remove custom definition of `blockquote` in default template.
      (We now use built-in `quote`.)
    + Support table of contents.
    + Support csl (#9186, Ian Max Andolina). Typst now supports CSL for its
      native citation engine, so pandoc should use a specified `csl`
      style in the template, falling back to `bibliographystyle` if
      `csl` is not specified.

  * Docx writer:

    + Use different style for block quotes in notes (#9243).
      Using "Footnote Block Text" for the style name, so it can be
      given a different font size if footnotes are.
    + Allow embedded fonts to be used in reference.docx (#6728).

  * HTML5 writer:

    + To conform to validator's expectations, `doc-footnote` role is used
      with `aside` and `doc-endnotes` with `section`.
    + `aside` is used only for notes at ends of sections or blocks;
      if all the notes come at the end of the document, `section` is
      used so we can have the `doc-endnotes` role.

  * JATS writer:

    + Handle case where there is material after refs div (#9166). Previously in
      such cases the references were not being moved to back matter.

  * Ms writer:

    + Don't do normal escapes in filename arguments for PSPIC etc.

  * T.P.RoffChar: escape `-` as `\-`. The `groff_man (7)` man page indicates
    that `-` characters will be treated as typographic hyphens and are not
    appropriate for cases where the output should be copy-pasteable as an
    ASCII hyphen-minus character.  (E.g. in command line options.)
    However, until a recent update groff man did not actually do this;
    it treated `-` and `\-` the same.  With the new update (1.23.0)
    the two are distinguished (see https://lwn.net/Articles/947941/
    for background), so now it is important that pandoc escape `-`.

  * Text.Pandoc.Extension: add `Ext_alerts` constructor [API change].

  * Text.Pandoc.PDF: We now default to running LaTeX only
    once in producing a PDF (instead of twice). This is made possible by the
    shift to the `bookmark` package, which does not require a second pass for
    PDF bookmarks. If a table of contents is present, we still have to run
    three times to get the page numbers, and if beamer is used we still do a
    minimum of two runs.

  * Text.Pandoc.Shared:

    + `renderTags'`: use minimized tag for `rect`.
    + Allow svg `path` element to be minimized.
    + Export `combineAttr` [API change].
    + Improve `isTightList` so that it recognizes an item containing only a list
      which is itself tight as potentially an item in a tight list (#9161).

  * Text.Pandoc.MIME: Ensure we use `.svg` not `.svgz` as extension
    for `image/svg+xml` mime type. This fixes issues with embedded
    SVG images in docx output, among other things (#9195).

  * Text.Pandoc.Class: `openURL` improvements for data uris.
    Only treat data URI as `base64` if ';base64' is specified.
    Otherwise treat as UTF-8 (not 100% reliable but should cover most
    other cases). Strip off `;base64` (or `;charset=...` or whatever)
    from mime type (#9195).

  * Text.Pandoc.SelfContained: Improve treatment of embedded SVGs
    (#9206, #8948).

    + Ensure unique ids for elements by prefixing SVG id.
    + Ensure SVG `id` attribute except when `use` element is used.
    + Remove `width`, `height` attributes from svg element when `use`
      element is used. Instead, add `width` and `height` 100% to the
      `use` element. This seems to get the sizing right.

  * Text.Pandoc.Citeproc: Don't link citations if
    `suppress-bibliography` specified, for there will be nothing to
    link to (#9163).

  * epub.css: add styling for sup and sub (#9160).

  * Switch from `base64` to `base64-bytestring` (#9233).

  * Use newest versions of commonmark, commonmark-extensions,
    commonmark-pandoc, texmath, typst, skylighting, skylighting-core.

  * Benchmark: use standalone documents for reader tests.
    Otherwise typst reader benchmark fails. Note: this means that we are now
    parsing longer documents, so bench results on readers won't be comparable
    to before.

  * MANUAL.txt: update defaults file docs for bibliography fields (#9173).
    Recommend using top-level `bibliography` `csl`, etc. instead
    of a nested `metadata` field. Reason: `${USERDATA}` and `${HOME}`
    are only expanded in these contexts, not in `metadata`.

  * Move man pages to pandoc-cli package (#9245).

## pandoc 3.1.9 (2023-10-27)

  * Make `reference-section-title` work with `jats+element_citations`
    (#9021).

  * Add `bits` as synonym of `jats` as input format.

  * JATS reader:

    + Modify JATS reader to handle BITS too (#9138, Julia Diaz).
      Add provision for title-group, book, book-part-wrapper, book-meta,
      book-part-meta, book-title, book-title-group, index, toc, legend,
      title, collection-meta
    + Fix handling of alt-text (#9130, Julia Diaz). Previously we were
      looking for an attribute that doesn't exist in JATS; alt-text is
      provided by a child element.

  * CommonMark reader:

    + Handle `Ext_tex_math_gfm` (#9121). Parse GFM-specific math
      constructions when `tex_math_gfm` enabled.

  * DokuWiki reader:

    + Allow autolinks to be avoided using e.g. `https:%%//%%...` (#9153).
    + Parse `<code>` and `<file>` as block-level code (#9154).
      Previously we treated them as inline code in some contexts,
      but that is not how DokuWiki works.

  * LaTeX reader:

    + Better handle spacing commands `\hfill`, `\vfill`, `\hskip`,
      `\vskip`, etc. (#9150).
    + Fix incorrect abbreviation for astronomical unit (#9125,
      Michael McClurg).

  * Markdown reader:

    + Fix blindspot with superscript in links (#8981).
      Previously `[^super^](#ref)` wasn't parsed as a link, due to
      code that was meant to prevent footnote markers from being
      recognized as reference links.  This commit tightens up that
      code to avoid this bad effect. We have also added a new
      restriction on footnote labels: they cannot contain the characters
      `^`, `[`, or `]`. Though this is technically a breaking change, we
      suspect that the impact will be minimal, as it's very unlikely
      people would be using these characters in their note labels.
    + Don't apply `--default-image-extension` to data URIs (#9118).
    + More accurate check that a normalCite is not a link,
      bracketed span, or reference (#9080).

  * HTML reader:

    + Allow th to close td and vice versa (#9090).
    + Parse task lists using input elements (#9047, Seth Speaks).

  * Creole reader:

    + Handle empty cells correctly (#9141, Sascha Wilde).

  * Org writer:

    + Escape literal `*`, `|`, `#` at beginning of line with ZWS (#9159).

  * ICML writer:

    + Prevent doubled attributes (#9158).

  * Powerpoint writer:

    + Fix a corruption error caused when the document used both a
      regular png and a png in a data URI (#9113). (Similarly for any
      other image format.) The problem was that duplicate entries in
      `[Content Types].xml` were being created, one for the mime type
      `image/png`, one for `image/png;base64`.

  * LaTeX writer:

    + Fix rowspans in tables so they use the width of
      the column (`=` as the width parameter) (#9140).
    + Don't treat table as "simple" if they have col widths.
      This should help fix a problem wherein some grid tables with
      colspans were overly wide (#9140).
    + Fix uneven indents in line block output (#9088).

  * JATS writer: fix 3.1.4 regression in handling block-level metadata
    (#9092).

  * Ms writer: improvements in image handling (#4475).

    + PDFPIC is now used for PDF images in figures.
    + Inline images that are postscript or PDF are rendered using
      PSPIC or PDFPIC. This isn't ideal, because they will still be
      rendered as if in a separate paragraph, but it's probably
      better than just printing the image name.
    + Units are included in height.

  * HTML writer:

    + If raw format is an HTML side deck format, emit it (James J Balamuta).

  * Typst writer:

    + Add `#box` around image to make it inline. (#9104)
      An `#image` by itself in typst is a block-level element.
      To force images to be inline (as they are in pandoc), we need
      to add a box with an explicit width. When a width is not given
      in image attributes, we compute one from the image itself, when
      possible.
    + Don't allow long heading to wrap (#9132).
    + Escape `(` (#9137). If unescaped `(` occurs in
      certain contexts, it can be parsed as function application.

  * Man writer:

    + Fix some spacing issues around links (#9120).
      We need to use `\c` before a `.UR` or `.MT`, to avoid
      an extra space, and also after.  To ensure that a space
      at the beginning of the following line doesn't get swallowed
      up, we escape it with `\`.
    + Use UR, MT macros for URLs, emails (#9120).

  * Text.Pandoc.Extensions:

    + Add `Ext_tex_math_gfm` constructor to Extension (#9121).
      [API change]. This handles two GitHub-specific syntaxes for math.
      This is now default for `gfm`, in addition to `tex_math_dollars`.
    + Remove duplicates for `Ext_raw_html` and `Ext_pipe_tables`
      in some of the lists (Tim Stewart).

  * Text.Pandoc.Metadata: Add helpful message on some metadata
    YAML errors (#9155).

  * Text.Pandoc.Shared:

    + `splitSentences`: don't split after initials.
      This improves the man and ms writer output, preventing
      sentence breaks after initials.
    + Add `addPandocAttributes` function [API change].
      This is meant to simplify addition of attributes to Pandoc
      elements: for elements that don't have a slot for attributes, an
      enclosing Div or Span is added to hold the attributes.

  * MANUAL.txt:

    + Clarify that formatting can't cross line boundaries
      in line blocks (#9119).
    + Fix legacy option for citation (#8737, 3w36zj6)

  * Update `et` translations (priiduonu).

  * Updated `no` translations (Stephan Daus).
    Renamed no.yaml (macrolanguage Norwegian) to nb.yaml (Norwegian Bokmål).
    Created soft symbolic link from no.yaml pointing to nb.yaml.

  * Lua subsystem: Use the newest LPeg version (lpeg-1.1.*) (#9107,
    Albert Krewinkel).

  * Default `epub.css`: Apply style to h6, format styles, and
    combine identical styles under shared selectors (samuel-weinhardt).

  * Update nix flake with dependencies (piq9117).

  * LaTeX template: fix `\CSLBlock` vertical space (John Purnell).

  * Allow tasty 1.5 and Diff 0.5.

  * Require commonmark-extensions 0.2.4, commonmark 0.2.4.

  * Require texmath 0.12.8.4. This should improve math in
    powerpoint, fixing empty boxes around roots in some cases.

  * Require typst 0.3.2.1

## pandoc 3.1.8 (2023-09-08)

  * JATS reader:

    + Ignore `<processing-meta>` element (#9057, Julia Diaz).
    + Fix conversion of date to ISO 8601 format (#8865).

  * LaTeX template:

    + Add code allow `\cite` to break across lines (#9050).
    + Fix regression with CSL `display="block"` (#7363).
      This restores the line break before the block.
    + Rewrite `CSLReferences` environment to avoid depending on
      `enumitem`, which plays badly with beamer.  Instead we use
      a regular list environment. Thanks to @jpcirrus for the
      concept (#9053).
    + Restore the pre-3.1.7 format of the `CSLReferences`
      environment, which again has two parameters. The first
      determines whether a hanging indent is used (1 = yes, 0 = no),
      and the second is the entry line spacing (0 = none).
    + Add a strut to avoid inconsistencies in spacing (#9058).
    - Remove a break at the end of `CSLRightInline` to avoid
      inconsistencies in spacing. It shouldn't be necessary
      because the paragraph should extend to the right margin (#9058).

  * LaTeX writer:

    + Fix regression with figure labels (#9045). In 3.1.7, pandoc
      added two labels to LaTeX figure environments, one with a
      phantomsection.
    + Fix default citeproc entry-spacing. According to the CSL manual,
      the default entry spacing is 1. We were treating it as 0 (#9058).

  * HTML writer:

    + Use the ID prefix in the ID for the footnotes section (#9044,
      Benjamin Esham).
    + Fix CSL entry-spacing default (#9058).

  * Text.Pandoc.Citeproc:  always include an `entry-spacing` attribute
    in the Div if the bibliography element contains an entry-spacing
    attribute (previously we omitted it when it was 0) (#9058).

  * Clean up pandoc's own man pages by regenerating with pandoc 3.1.7.

  * pandoc-lua-engine: bump lower bound for pandoc (#9046).

  * Depend on texmath 0.12.8.2, fixing binom in typst writer (#9063).

## pandoc 3.1.7 (2023-08-31)

  * Org reader:

    + Don't parse alphabetical lists unless the `fancy_lists` extension is
      enabled (#9042).
    + Allow escaping commas in macro arguments (Amneesh Singh).

  * JATS reader:

    + Support for `<permissions>` metadata (#9037, Julia Diaz).
      metadata objects with multiple fields are created, matching the
      structure in JATS.
    + Correct name of JATS element `attrib`.

  * Markdown reader:

    + Support images with wikilink syntax, e.g. `![[foo|bar]]`, when
      one of the `wikilinks` extension is enabled (#8853).
    + Allow a citation or reference link to be parsed after a `!` (#8254).
    + Fix dropped `!` before nonexistent reference (#9038).

  * LaTeX writer:

    + Fix regression in escaping URLs (#9043).
    + Use `\cite` and `\bibitem` to link up citations, even with citeproc.
      (#9031). This will give us better accessibility; when tagging is
      enabled, the citation can be linked to the bibliography entry.
      This changes some of the details of the layout and the default
      template. We now make `CSLReferences` a special enumitem list
      that will contain `\bibitem`s. Internal links inside citations to
      ids beginning in `ref-` are creating using `\cite` instead of
      `\hyperref`.
    + Use `\phantomsection` and `\label` instead of `\hypertarget` (#9022).
    + Use `\hyperref` for LaTeX internal links, `\hyperlink` for
      beamer (since `\hyperref` doesn't seem to work) (#9022).
    + Backslash-escape `%` and `#` in URLs (#9014).

  * JATS writer:

    + Fix placement of ref-list when no title is specified for the
      reference section (#9017). (In this case we place it in `back`
      with an empty title.)

  * Man writer:

    + Avoid a `.PP` right after a section heading (#9020).
      This is at best a no-op (in groff man and mandoc) and at worst
      (in some formatters) may create extra whitespace.
    + We revert the fanciness introduced in #7506, which employs a
      custom font name `V` and a macro that makes this act like boldface
      in a terminal and monospace in other formats.  Unfortunately,
      this code uses a mechanism that is not portable (and does not
      work in mandoc) (#9020).
    + Instead of using `V` for inline code, we simply use `CR`.
      Note that `\f[CR]` is emitted instead of plain `\f[C]`,
      because there is no `C` font in man.  (This produces warnings
      in recent versions of groff, #9020.)
    + For code blocks, we now use the `.EX` and `.EE` macros,
      together with `.IP` for spacing and indentation.  This gives
      more standard code that can be better interpreted e.g. by mandoc
      (#9020).

  * Man template: don't emit `.hy`, regardless of setting of
    `hyphenate` variable (#9020).

  * LaTeX template: special redefinition of `\st` for CJK (#9019).
    soul's version raises on error on CJK text.

  * Use latest skylighting-format-blaze-html (#7248).
    This works around a longstanding iOS Safari bug that caused long
    lines to be displayed in a different font size in highlighted code.

  * Allow skylighting 0.14 (and require it in pandoc core).

  * Allow text 2.1.

## pandoc 3.1.6.2 (2023-08-22)

  * Org reader: allow example lines to end immediately after the colon
    (Brian Leung).

  * Docx reader:

    + Omit "Table NN" from caption (#9002).
    + Avoid spurious block quotes in list items (#8836).

  * JATS reader: Fix display of block elements (#8889, Julia Diaz).
    A number of block elements, like disp-quote, list, and disp-formula, were
    always treated as inlines if appearing inside paragraphs, even if their
    usage granted a separate block.

  * HTML reader: avoid duplicate id on header and div (#8991).

  * Typst writer:

    + Use `~` for nonbreaking space, and escape literal `~` (#9010).
    + Put the label in right place for Div, use `#block` (#8991).
      Previously we were putting the label at the beginning of
      the Div's contents, but according to the documentation such a
      label gets attached to the *preceding* element.  We now use an
      explicit `#block` and add the label at the end.

  * LaTeX writer:

    + Improve escaping of URIs in href, url (#8992).
    + Improve internal links and targets (#8744). We no longer
      wrap section headings in a `\hypertarget`. This is unnecessary
      (hyperref creates an anchor based on the label) and it interferes with
      tagging. In addition, we now use `\hyperref` rather than `\hyperlink`
      for internal links. Currently `\hypertarget` is still being used for
      link anchors not on headings. Thanks to @u-fischer.

  * HTML format templates (style.html): Fix typo in clause for svg
    (Jackson Schuster).

  * Use lastest texmath, typst-symbols, typst. Targets typst 0.7.


## pandoc 3.1.6.1 (2023-08-11)

 * HTML reader: properly calculate RowHeadColumns (#8984). This fixes a
   bug in the calculation of the number of header columns in table row.
   It also changes the algorithm for determining the table body's
   RowHeadColumns based on the numbers of head columns in each row.
   Previously we used the max, and #8634 switched to the min, which
   led to bad results. Now we only set RowHeadColumns to a non-zero value
   if *all* rows have the same number of head columns.

  * OpenDocument writer:

    + Implement syntax highlighting for inline and block code (#6710).
    + Support highlighted text in ODT/OpenDocument writers for Span
      with class `mark` (#8960). The color can be adjusted by
      modifying the Highlighted style.

  * Typst writer: escape `//` so it doesn't get interpreted as a comment
    (#8966).

  * ChunkedHTML writer: Fix regression including MathJax script (#8967).
    The fix for #8620 caused the script to be included when the table of
    contents but not the body text of a page contains math.  But it broke the
    case where the table of contents doesn't contain math but the page does.
    This patch fixes the issue.

  * Text.Pandoc.SelfContained:

    + Retain attributes in SVG tag when referring to another
      SVG's content using `<use>` (#8969).
    + Allow units in width and height for SVG. Units are optional but allowed.
    + Don't coerce calculated SVG dimensions to Int.
    + fix calculation of SVG width and height. We were computing width and
      height from viewBox incorrectly (#8969).
    + Add clause for SVG to default CSS for HTML (#8969).
    + Ensure that width and height attributes don't get specified
      twice is both the img tag and the svg include them (#8965).
    + Omit unnecessary attributes xmlns, xmlns:xlink, and version on
      SVG element (#8965).
    + Use 20 character rather than 40 character hashes for generated IDs
      (#8965).

  * Use pandoc-types 1.23.1. This fixes a regression with toJSONFilter (#8976),
    which in 1.23.0.1 no longer worked on pure values of type `a -> [a]`.

  * Use ghc 9.6 for release builds (#8947).

  * Fix some links in FAQs (Diogo Almiro).


## pandoc 3.1.6 (2023-07-20)

  * Fix CVE-2023-38745, a variant of the vulnerability in CVE-2023-35936.
    Guilhem Moulin noticed that the fix to CVE-2023-35936 was incomplete.
    An attacker could get around it by double-encoding the malicious
    extension to create or override arbitrary files.

  * `--embed-resources`: Use inline SVG instead of data uris for SVG
    images in HTML5 (#8948). Note that SelfContained does not have
    access to the writer name, so we check for HTML5 by determining
    whether the document starts with `<DOCTYPE! html>`. This means
    that inline SVG won't be used when generating document fragments.

  * Fix regression on short boolean arguments (#8956).
    In 3.1.5 boolean arguments were allowed an optional argument
    (`true|false`).  This created a regression for uses of fused
    short arguments, e.g. `-somyfile.html`, which was equivalent
    to `-s -omyfile.html`, but now raised an error because
    pandoc attempted to parse `o` as a boolean `true` or `false`.
    This change allows the fused short arguments to be used again.
    Note that `-strue` will be interpreted as `-s` with an
    argument `true`, not as `-s -t -rue`.  It is best to
    use long option names with the optional boolean values,
    to avoid confusion.

  * Make `--epub-title-page`'s argument optional. It takes a boolean
    argument, and now that all of our boolean flags take such an
    argument, we can make this one optional for consistency.

  * Improve errors for illegal output formats. Previously if you did
    `pandoc -s -t bbb`, it would give you an error about the missing
    `bbb` template instead of saying that `bbb` is not a
    supported output format.

  * Improve errors for incorrect command-line option values (#8879).
    Always give the name of the relevant argument.

  * Fix typo on error message for incorrect `--preserve-tabs` argument.
    Thanks @fsoedjede

  * Docx reader: use SVG version of image if present (#7244).
    Previously the backup PNG was exported even if an SVG was
    present, but the SVG should be preferred.

  * Typst reader: fix regression in recognition of display math (#8949).
    The last release caused all math to be parsed as inline math.

  * JATS writer: don't use `<code>` for inline code (#8889).
    It is intended for block-level code.

  * HTML writer: don't make line blocks sensitive to `--wrap` (#8952).

  * RST writer: fix figure handling (#8930, #8871).
    This fixes a number of regressions from pandoc 2.x.
    Properly handle caption, alt attribute in figures.
    No longer treat a paragraph with a single image in it as a figure
    (we have a dedicated Figure element now).

  * Docx writer: Copy "mirror margins" property from reference.docx (#8946).

  * Text.Pandoc.UTF8: Deprecate `decodeArg` which is now a no-op.
    This was needed for old base versions which we no longer support.

  * Use released skylighting, typst.

  * Allow latest commonmark-extensions. This allows entities in wikilinks.

  * Switch back to using ghc 9.2 for linux and Windows binary releases
    (#8947, #8955). With ghc 9.4+, we were getting AVX instructions
    in the amd64 binary, which aren't supported on older hardware.
    For maximum compatibility we switch back to ghc 9.2, which doesn't
    cause the problem. (As documented, ghc should not be emitting these
    instructions, so we aren't clear on the diagnosis, but the cure
    has been tested.)

  * Change Windows release build to use cabal instead of stack.

## pandoc 3.1.5 (2023-07-07)

  * Allow all boolean flags to take an optional `true` or `false` value
    (#8788, Sam S. Almahri). The default is true if no value is specified,
    so this is fully backwards-compatible.

  * Support `--id-prefix` for markdown output (#8878)

  * Markdown reader:

    + Add strictness annotations to fix a memory leak (#8762).

  * Typst reader:

    + Use typst-hs 0.3.0.0, which is more robust, fixes many bugs, and
      targets typst 0.6.
    + Package loading is now supported, as long as the package has been
      cached or is local.
    + Rewrite Typst reader in a way that makes it easier to extend.
    + Filter out CR in raw.
    + Handle block content for link element.
    + Handle block-level content in text element.
    + Handle style, align, place in inline contexts too.
    + Improve info message for skipped elements.

  * Add typst reader tests (#8942).

  * MediaWiki reader:

    + Revise treatment of "link trail." Previously we only included ASCII
      letters. That is correct for English but not for, e.g., Spanish (see
      comment in #8525). A safer approach is to include all letters except
      those in the CJK unified ideograph ranges.

  * AsciiDoc writer:

    + Make modern AsciiDoc the target for `asciidoc` (#8936).
      The AsciiDoc community now regards the dialect parsed by `asciidoctor`
      as the official AsciiDoc syntax, so it should be the target of our
      `asciidoc` format. The `asciidoc` output format now behaves like
      `asciidoctor` used to. `asciidoctor` is a deprecated synonym. For
      the old `asciidoc` behavior (targeting the Python script),
      use `asciidoc_legacy`. The templates have been consolidated. Instead of
      separate `default.asciidoctor` and `default.asciidoc` templates, there
      is just `default.asciidoc`.
    + Text.Pandoc.Writers.AsciiDoc API changes:
      - `writeAsciiDoc` now behaves like `writeAsciiDoctor` used to.
      - `writeAsciiDoctor` is now a deprecated synonym for `writeAsciiDoc`.
      - New exported function `writeAsciiDocLegacy` behaves like
        `writeAsciDoc` used to.
    + Update line-through for asciidoc writer to custom inline style (#8933,
      Kevin Broch).

  * Typst writer:

    + Support `unlisted` class in headings (#8941).
    + Consolidate bibliography files into one `#bibliography` command (#8937).
    + Improve handling of autolinks (#8931).

  * Docx writer:

    + Make relative widths work in tables. This didn't work before because we
      were missing an attribute that tells Word to used fixed widths rather
      than computing optimal ones.

  * DokuWiki writer: fix lists with Div elements (#8920).
    The DokuWiki writer doesn't render Divs specially, so their presence in
    a list (e.g. because of custom-styles) need not prevent a regular
    DokuWiki list from being used. (Falling back to raw HTML in this case is
    pointless because no new information is given.)

  * LaTeX writer:

    + Fix babel name for `fa` (should be `persian`).
    + Prevent babel language from being imported twice (#8925).

  * Text.Pandoc.Class:

    + Add `toTextM` [API change]. This is like `Text.Pandoc.UTF8.toText`,
      except:

      - it takes a file path as first argument, in addition to
        bytestring contents
      - it raises an informative error with source position if
        the contents are not UTF8-encoded

    This replaces `utf8ToText` whenever we have the filename and are
    in a PandocMonad instance. This will lead to more informative error
    messages for UTF8-encoding, indicating the file path and byte offset
    where the error occurs (#8884).

  * Remove invalid term "Subject" from Turkish translations (#8921).

  * stack.yaml: add pkg-config to nix packages (#8927, pacien).

  * Allow aeson 2.2.

  * MANUAL: Add clarification on --section-divs. Closes #8882.


## pandoc 3.1.4 (2023-06-24)

  * Fix a security vulnerability in MediaBag and T.P.Class.IO.writeMedia.
    This vulnerability, discovered by Entroy C, allows users to write
    arbitrary files to any location by feeding pandoc a specially crafted
    URL in an image element.  The vulnerability is serious for anyone
    using pandoc to process untrusted input.  The vulnerability does
    not affect pandoc when run with the `--sandbox` flag. [CVE-2023-35936]

  * Allow `epub-title-page` to be used in defaults files (#8908).

  * Issue `Extracting` info message (in `--verbose` mode) when using
    `--extract-media` or extracting media temporarily in PDF production.

  * HTML reader: Update TableBody RowHeadColumns caculation (#8634,
    Ruqi). This change sets RowHeadColumns to the minimum value of each row,
    which gives better results in cases where rows have different numbers
    of leading th tags.

  * Dokuwiki reader: retain image query parameters as attributes (#8887, echo0).

  * Textile reader: Add support for link references (#8706, Stephen Altamirano).
    Textile supports what it calls "link alias", which are analogous to
    Markdown's reference-style links.

  * LaTeX reader: support alt text on images (#8743, Albert Krewinkel).

  * Commonmark reader: Make `implicit_figures` work again.
    Support for this (introduced in #6350) disappeared when we made an
    architectural change.

  * JATS reader:

    + Add footer and multiple body parsing to table reader (#8765, Noah Malmed).
    + Parse references title from ref-list (#8365).

  * JATS writer:

     + Make `--number-sections` work.
     + Include title in ref-list (#8364). Previously the reference title ended
       up in a separate section at the back of the body instead of in the ref-list
       in the back matter.

  * Mediawiki writer: allow highlighting to work for F# language
    (Adelar da Silva Queiróz).

  * LaTeX writer: Fix escaping of `&` in `\href` and `\url` (#8903).

  * Docx writer:

    + Fix localization of "Abstract" title (#8702).
    + Allow `abstract-title` to be specified in docx metadata (#8794).

  * ChunkedHTML writer: Make math work in top-level page (#8915).

  * Text.Pandoc.Logging: add new log message type `ScriptingWarning`
    [API change] (Albert Krewinkel).

  * Lua: report warnings from Lua scripts (Albert Krewinkel).
    Lua's warning system is plugged into pandoc's reporting architecture.
    Warnings that are raised with the Lua `warn` function are now reported
    together with other messages.

  * Use crypton-connection instead of connection (#8896, Felix Yan).
    Follows the change introduced in tls 1.7.0.

  * Bump versions for skylighting-core, skylighting.

  * Include lua/module/sample.svg in cabal extra-source-files (Felix Yan).

  * Add Nynorsk (New Norwegian) translations (Per Christian Gaustad).

  * Add tests for `fillMediaBag`/`extractMedia`.

  * INSTALL.md:

    + Mention alternatives to LaTeX to generate PDF (Norwid Behrnd).
    + Update Linux install links (harabat).

  * pandoc-extras.md: add to "Academic publishing workflows" (#8696,
    Vladimir Alexiev).

## pandoc 3.1.3 (2023-06-07)

  * New output format: `typst`.

  * New module: Text.Pandoc.Readers.Typst [API change].

  * DocBook reader:

    + Support more emphasis roles (Albert Krewinkel).
      The role "bf" is taken to indicate "bold face", i.e.,
      "strongly emphasized" text, while "underline" leads to
      underlined text.

  * JATS reader:

    + Improve title and label parsing in the JATS reader (#8718,
      Noah Malmed.)
    + Add rowspan, colspan and alignment to cells in jats table
      reader (#8408, Noah Malmed)

  * Org reader (Albert Krewinkel):

    + Require abstract environment to use lowercase.
    + Treat `#+NAME` as synonym for `#+LABEL` (#8578).

  * ODT reader:

    + Allow lists in table cells (#8892).
    + Allow frames inside spans (#8886).

  * RST reader:

    + Fix sorting on anonymous keys (#8877). This fixes a link
      resolution bug bug affecting RST documents with anonymous links.

  * HTML reader:

    + Fix iframe with data URI of an image (#8856).
      In this case we don't want to try to parse the data at the URL.
      Instead, create an image inside a div.

  * RTF reader:

    + Fix bug in table parsing (#8767). In certain cases, text before a
      table was being incorporated into the table itself.

  * Docx reader:

    + Introduce support for Intense Quote (Stephan Meijer).

  * Markdown reader:

    + Disallow escaping of `~` and `"` in `markdown_strict` (#8777,
      Albert Krewinkel). This matches the behavior of the legacy
      `Markdown.pl` as well as what is described in the manual.

  * LaTeX reader: ignore args to column type in `\multicolumn` (#8789).

  * HTML writer:

    + Use first paragraph in task item as checkbox label (#8729, Albert
      Krewinkel).

  * Ms writer:

    + Coerce titles to inlines (#8835). Block-level formatting is not
      allowed inside `.TL`.

  * LaTeX writer:

    + Fix width for multicolumn simple table (#8831).

  * Jira writer:

    + Use first code block class as highlighting language (#8814, Albert
      Krewinkel). The writer no longer searches the list of
      classes for a known programming language but always uses
      the first class in that list as the language identifier.

  * OpenDocument writer:

    + Handle row header column cells as header cells (#8764, Michael Stahl).
    + Fix invalid `text:p` inside `text:p` from meta (#8256).

  * ODT writer:

    + Don't add settings.xml (Michael Stahl). This will cause defaults
      to be used, which is what we want.
    + Don't add unnecessary Configurations2 directory (Michael Stahl).
    + Don't add thumbnail (Michael Stahl).
    + Put `manifest.version` on directory file-entry (Michael Stahl).
      See ODF 1.3 part 2, 4.16.14.1.
    + Stop validator complaints by producing ODF 1.3 (Michael Stahl).

  * MediaWiki writer:

    + Remove links from inside links in mediawiki writer (#8739,
      Wout Gevaert).

  * Typst writer:

     + Omit bibliography if `citations` not enabled (#8763).
      With this change, the typst writer will omit the `#bibliography`
      command when `citations` is not enabled.  (If you want to use
      pandoc's own `--citeproc`, you should combine it with
      `-t typst-citations` to disable native typst citations.
    + Use `<..>` for labels, create internal links.
    + Use `#footnote` for notes (#8893).
    + Fix alignment issue in lists.  It's an aesthetic issue
      only; the first line had an extra space indent after the
      list marker.

  * Commonmark writer:

    + Use shortcut reference links: commonmark supports these.

  * EPUB template: add `lang` attribute to `<html>` (Gabriel Lewertoski).

  * Template styles.html: fix task-list styling in reveal.js
    (#8731, Albert Krewinkel).

  * LaTeX template: Fix `\babelfont` (#8728).

  * Text.Pandoc.Parsing:

    + Remove unnecessary 'spaces' in `parseFromString`.

  * Text.Pandoc.ImageSize: Drop BOM at start of SVG if present.
    Otherwise our code can fail to determine image size.

  * Lua subsystem:

    + Fix value of PANDOC_SCRIPT_FILE for custom readers & writers
      (#8781, Albert Krewinkel). The value did not hold the actual
      file path for scripts in the *custom* folder of the datadir.

  * Fix YAML in translation files for `cs` and `pl` (#8787).

  * Fix pdf output via typst (#8754).  One must now use `typst
    compile` rather than `typst`.

  * MANUAL.txt:

    + Added note that the user will need to create the user data
      dir (#8727).
    + Add `wikilinks` to non-default extensions (Ilona).
    + Update link to custom djot writer (Albert Krewinkel).
    + Better link to citation syntax.
    + Fix typo (sdhoward).
    + Note that `#` fancy list markers don't work with commonmark (#8772,
      William Lupton).
    + Add commonmark `fenced_div` note (#8773, William Lupton).
    + Move highlighting documentation, with minor adjustments
      (William Lupton).
    + Fix inaccurate statement about spaces and tabs in template
      syntax
      (Frank Seifferth).

  * Update documentation for org-mode (Christian Christiansen, #8716).

  * doc/lua-filter.md:

    + Fix typos (#8734, perro tuerto).
    + Fix anchor (Toni Dietze).
    + Use full field name in example (#8857, Matt Dodson).
    + Fix copy-paste error (#8798, thron7).

  * CONTRIBUTING.md: update info on ghc versions.

  * INSTALL.md:

    + Fix cabal install instructions (Albert Krewinkel).
    + Use more relevant link to NetBSD/pkgsrc entry (Charlotte Koch).
    + Fix Windows install instructions for winget (#8799).

  * Tests: Rename test/docx/block_quotes_parse_indent.native for
    consistency (Stephan Meijer).

  * Add `tls` constraint on cabal.project. This is needed to
    avoid problems caused by the transition to `crypton`.

  * Require texmath 0.12.8.


## pandoc 3.1.2 (2023-03-26)

  * Add a Lua REPL (Albert Krewinkel). This can be started
    with `pandoc lua -i`.  It is also possible to instruct a filter to
    open the REPL at a certain point, for debugging (see `pandoc.cli.repl`).

  * Support `typst` as a `--pdf-engine`.

  * Add typst writer (#8713).  New module Text.Pandoc.Writers.Typst,
    exporting `writeTypst` [API change].

  * Org reader:

    + Allow zero width space as an escape character (#8716,
      Christian Christiansen). Allow the character U+200B to be used as
      an escape character as described in the Org-mode documentation
      (<https://orgmode.org/manual/Escape-Character.html>).

  * DocBook reader:

    + Handle "book" for xref references (#8712, Andres Freund)
      This also adds a test xref to book and part.
    + Handle `<part>` (#8712).

  * HTML reader:

    + Fix behavior with `-native_spans-raw_html` (#8711). Previously with
      this configuration, `<span>`s were not treated as inline elements at all.

  * HTML writer:

    + Avoid duplicate classes (#8705).
    + Use img element instead of embed for `.svg.gz` and `.png.gz` etc. (#8699).
    + HTML writer footnotes changes (#8695): when `--reference-location=section`
      or `=block`, use an `aside` element for the notes rather than a `section`.
      When `--reference-location=section`, include the `aside` element inside
      the section element, rather than outside. (In slide shows, this option
      causes footnotes on a slide to be displayed at the bottom of the slide.)

  * EPUB writer:

    + Use different structure for epub footnotes (#8676, see #8672, #5583).
      Many EPUB readers are thrown off by pandoc's current footnote
      output.  Both the ol and the fact that the footnote backlink is
      at the end of the note seem to pose problems.
      With this commit, we now create a list of aside (or div) elements,
      instead of an ordered list. Each element begins with a note number
      that is linked back to the note reference.  (So, the backlink occurs
      at the beginning rather than the end.) Thanks to @Porges and @lewer.

  * Docx writer:

    + Include abstract title (#8702). Uses localized term for abstract.

  * Markdown writer:

    + Use implicit figures if there's a caption but no alt (#8689,
      Albert Krewinkel).

  * Jira reader (Albert Krewinkel):

    + Add panel title as nested div (#8681).
    + Require jira-wiki-markup 1.5.1 (#8680). This fixes a bug in the parser
      that caused text between two exclamation marks to be parsed as an
      image. The first `!` of image markup must now be followed by a
      non-space character; otherwise, the enclosed text is parsed as
      normal content.
    
  * Ms writer:

    + Fix handling of Figure (#8660).

  * ICML writer:

    + Fix images with data (#8675). The Contents element
      should be inside Properties.

  * LaTeX writer:

    + Add Chinese to Babel languages.
    + Fix background image in Beamer when there are figure environments (#8671,
      Martín Pozo).

  * LaTeX template:

    + Add `babelfonts` variable to default LaTeX template.
      This allows specifying certain fonts to be used with
      certain babel languages. Thanks to Frederik Elwert.
    + Fix highlight/underline with lualatex (#8707). We need the lua-ul package
      instead of soul, which doesn't work with lualatex.

  * Lua (Albert Krewinkel):

    + Add `pandoc.cli.repl` function
    + Fix `json.encode` for nested AST elements. Ensures that objects with
      nested AST elements can be encoded as JSON.
    + Auto-generate docs for pandoc modules.
    + Load text module as `pandoc.text`. This only affects the name in the
      Lua-internal documentation. It is still possible to load the modules
      via `require 'text'`, although this is deprecated.
    + Move docs from module `text` to `pandoc.text`
      The latter is easier to use and more consistent with the other modules.
    + Keep the Lua stack clean A metatable used during initialization was
      not properly removed from the stack. Likewise, accessing the
      CommonState from Lua previously led to the pollution of the
      Lua stack with a left-over value.
    * Add function `pandoc.format.from_path`.
    + Allow to get the JSON encoding of log messages.

  * Text.Pandoc.Format: Add new function `formatFromFilePaths` [API change]
    (#8710, Albert Krewinkel).

  * The old Text.Pandoc.App.FormatHeuristics module has been removed.

  * In `--version`, use Windows `%APPDATA%` variable to describe
    user data dir (#8686, Pablo Rodríguez).

  * Text.Pandoc.App.CommandLineOptions: don't lowercase arg to `--from`/`--read`
    (Albert Krewinkel). This prevented users to use custom writers with
    uppercase characters in their filenames. Format-normalization,
    including lower-casing of format identifiers, happens during
    format parsing.

  * Documentation:

    + Add `doc/nix.md`.
    + Add `doc/extras.md`. This was formally in the website repo.
    + `doc/lua-filters.md`: improve docs for `pandoc.zip`.

  * Factor out `make_macos_release.sh` from the release candidate workflow.
    Use cabal instead of stack to build the macos binary.

  * Modify linux/make_artifacts.sh so it will work on cirrus.

  * Switch to hslua-2.3

  * Depend on latest releases of texmath, doclayout.

## pandoc 3.1.1 (2023-03-05)

  * EPUB reader: Give additional information in error if the epub
    zip container can't be unpacked.

  * TSV reader: don't gobble tabs as whitespace (#8661).

  * Org reader: accept empty tables (#8659).

  * LaTeX reader: fix multiplication syntax for tabular (#8658).
    We recognized `*{6}{...}` but not `*6{...}` or `*6c`.

  * Docx reader: parse image alt texts in LibreOffice generated files.
    LibreOffice tags images slightly differently than Word; this change lets
    the parses take that difference into account when looking for an image
    description (alt text).

  * DocBook reader:

    + Fix `<xref>` references to tables in DocBook files
      (#8626, Pavol Otto).
    + Parse `figure` as a Figure element in the AST (#8668).

  * JATS reader: avoid generating duplicate figure captions (#8669).

  * RST reader: align with spec in syntax for role names (#8653).
    In particular, we now allow colons in row names.

  * Add note on converting from .doc format to FAQs (#8654).

  * Trap error in getAppUserDataDirectory (#8648).
    This can raise an error if pandoc is run in a non-user environment.

  * LaTeX writer: do not use longtable foot with Beamer (#8638, Albert
    Krewinkel). The table foot is made part of the table body, as
    otherwise it won't show up in the output. The root cause for
    this is that longtable cannot detect page breaks in Beamer.
    
  * LaTeX template: Add CJKsansfont and CJKmonofont for XeLaTeX
    (#8656, Yudong Jin). `CJKsansfont` and `CJKmonofont` will be
    set for xelatex only if `CJKmainfont` is also provided.

  * URL style in ConTeXt (#8612, Thomas Hodgson). Previously, a
    URL like this would be in monospace text:
    `\useURL[url1][https://example.com]`.  Now, it will match the
    main text unless the `linkstyle` variable is set, which
    controls the styling of all links.  Closes #8602.

  * Asciidoc writer: Properly escape `|` in table cells (#8665).

  * asciidoc{,tor} template: fix revision date when author is unset
    (#8637, arcnmx). Revision line syntax is only valid in
    combination with an author line, so the date attribute must be
    set explicitly when the author is missing

  * HTML writer: allow "track" element to be treated as block-level HTML
    (#8629).

  * Include needed polyfill when MathJaX is used (#8625).

  * JATS writer: include alt-text in `<graphic>`,
    `<inline-graphic>` elements (#8631, Albert Krewinkel).

  * Chunked HTML writer:  Retain metadata in processing sections
    for chunked HTML (#8620).  Previously we suppressed metadata
    in all but the top page, in order to prevent the title block
    from being printed on every page. This prevented use of
    custom variables set by metadata fields.  This commit moves
    to a better solution: a conditional in the default template
    restricts the title block to the top page.

  * Lua API:

    + Add new function `pandoc.system.cputime` (Albert
      Krewinkel).  The function returns the CPU time consumed by
      pandoc and can be used to benchmark Lua computations.
    + Add module `pandoc.json` to handle JSON encoding (#8605,
      Albert Krewinkel).

  * Use pandoc-lua-marshal 0.2.1 (Albert Krewinkel).
    All major AST elements now have `__tojson` metamethods that return the
    JSON representation of an element. This allows to JSON-encode these
    elements with libraries that respect the `__tojson` metamethod,
    including dkjson.

  * Use latest zip-archive.  This allows pandoc to open certain
    epubs that it could not open before.

  * Use commonmark-extensions 0.2.3.4. This fixes some bugs involving
    definition lists and inline formatting.

  * Use latest skylighting-format-context

  * MANUAL.txt:

    + Document chunk-template in defaults file.
    + Remove obsolete "raw content in a style" section.
    + Revise documentation for `--mathml` to reflect support in all major
      browsers (#8667).

  * docs/custom-readers.md: Update JSON parsing example. The example now
    uses the built-in `pandoc.json` library to parse the API output.

  * doc/press.md: Add article on CiTO in J Cheminform by @egonw.

  * doc/lua-filters.md: fix typo in `run_json_filter` (Morgan Willcock).


## pandoc 3.1 (2023-02-09)

  * Fix regression with `--print-highlight-style` option (#8586).

  * Add new `--chunk-template` option (#8581), allowing more control
    over the filenames in chunked HTML output.

  * Text.Pandoc.App: Add `optChunkTemplate` constructor to Opt [API change].

  * Text.Pandoc.Options: add `writerChunkTemplate` constructor to
    `WriterOptions` [API change].

  * Text.Pandoc.Chunks: add Data, Typeable, Generic, ToJSON, FromJSON
    instances for `PathTemplate` [API change].

  * Text.Pandoc.Citeproc: Fix bug in `metaValueToReference` (#8611).
    This bug caused us to get some repeated content when converting
    MetaBlock to Inlines.

  * Textile reader:

    + Support footnote backlinks (#8585, Stephen Altamirano).
    + Don't allow brackets in URLs (#8582).

  * ODT reader: fix blockquote indent detection (#3437, Daniel Kessler).

  * LaTeX writer: include short figure/table caption if one is given
    (Albert Krewinkel). Short captions are used by LaTeX when generating
    the list of figures or list of tables. Adding a short caption will
    now overwrite the full caption in these lists.

  * Powerpoint writer: fix handling of simple figures (#8565,
    Albert Krewinkel). This ensures that simple figures are displayed
    in the same way as before the introduction of a dedicated `Figure`
    constructor in the AST.

  * Improve handling of `%` in bib(la)tex parsing (#8597, #8595).

  * Use released skylighting 0.13.2.1

  * INSTALL.md: direct people to cabal install pandoc-cli.

  * doc/lua-filters.md: document 'Figure' type and constructor (Albert
    Krewinkel). Fix typos (Martin Joerg).

  * Fix link in manual (#8583, Salim B).

## pandoc 3.0.1 (2023-01-25)

  * Fix use of extensions with custom readers (#8571).

  * Text.Pandoc.Writers.Shared: export `setupTranslations` [API change].
    Use this in HTML and OpenDocument writers, to ensure that
    translations are set up properly even when we don't go through
    `convertWithOpts`.

  * LaTeX reader: fix regression in macro resolution for environments (#8573).

  * Chunked HTML writer: Fix handling of images with absolute URLs (#8567).

  * HTML writer:

    + Don't omit newlines in task lists.
    + Don't disable checkboxes in task lists (#8562).

  * Ensure that automatically set variables `pandoc-version`, `outputfile`,
    `title-prefix`, `epub-cover-image`, `curdir`, `dzslides-core` can be
    overridden by `--variable` on the command line. Previously they would
    create lists in the template Context, which is not desirable.

  * Fix man page copying in `linux/make_artifacts.sh` (#8566).
    Previously we were copying the pandoc-server.1 pandoc page to pandoc-lua.1.

  * pandoc.cabal: remove pandoc.cabal, stack.cabal from extra-source-files
    (#8560). The problem is that if these are in extra-source-files, then they
    get put in the tarball, and then anyone trying to build the source
    from an unpacked tarball will run into the problem that cabal.project
    and stack.yaml refer to pandoc-server, pandoc-lua-engine, and
    pandoc-cli, which aren't in the tarball.

  * Require texmath 0.12.6 for better MathML output.

  * Fix typo in Lua filter documentation (Carlos Scheidegger).

  * Fix formatting of link in pandoc-server.md (James Scott-Brown).

  * Minor changelog fixups.

## pandoc 3.0 (2023-01-18)

  * Split pandoc-server, pandoc-cli, and pandoc-lua-engine
    into separate packages (#8309). Note that installing
    the `pandoc` package from Hackage will no longer give you the
    `pandoc` executable; for that you need to install `pandoc-cli`.

  * Pandoc now behaves like a Lua interpreter when called as
    `pandoc-lua` or when `pandoc lua` is used (#8311, Albert Krewinkel).
    The Lua API that is available in filters is automatically
    available to the interpreter. (See the `pandoc-lua` man page.)

  * Pandoc behaves like a server when called as `pandoc-server`
    or when `pandoc server` is used. (See the `pandoc-server` man page.)

  * A new command-line option `--list-tables`, causes tables to be
    formatted as list tables in RST (#4564, with Francesco Occhipinti).

  * New command line option: `--epub-title-page=true|false` allows
    the EPUB title page to be omitted (#6097).

  * `--reference-doc` can now accept a URL argument (#8535) and
    load a remote reference doc.

  * `--version` output no longer contains version info for dependent
    packages. Instead, it contains a "Features" line that indicates
    whether the binary was compiled with support for acting as a server,
    and for using Lua filters and Custom writers.

  * A new option `--split-level` replaces `--epub-chapter-level`
    and affects both EPUB and chunked HTML output.  `--epub-chapter-level`
    will still work but is deprecated.

  * Multiple input files with `--file-scope`: fix case where the links
    are URL-encoded, e.g. with `%20` (#8467).

  * Produce error if `--csl` is used more than once (#8195, Prat).

  * Remove deprecated `--atx-headers` option.

  * Remove deprecated option `--strip-empty-paragraphs`.

  * In `--verbose` mode add message when running citeproc (as with
    other filters).

  * Add new `mark` extension for highlighted text in Markdown,
    using `==` delimiters (#7743).

  * Add new extensions `wikilinks_title_after_pipe` and
    `wikilinks_title_before_pipe` for `commonmark` and `markdown`.
    (#2923, Albert Krewinkel). The former enables links of style
    `[[Name of page|Title]]` and the latter `[[Title|Name of
    page]]`. Titles are optional in both variants, so this works
    for both: `[[https://example.org]]`, `[[Name of page]]`. The
    writer is modified to render links with title `wikilink` as
    a wikilink if a respective extension is enabled. Pandoc will
    use `wikilinks_title_after_pipe` if both extensions are
    enabled.

  * Add prefixes to identifiers with `--file-scope` (#6384).
    This change only affects the case where `--file-scope` is used
    and more than one file is specified on the command line.
    In this case, identifiers will be prefixed with a string
    derived from the file path, to disambiguate them. For example,
    an identifier `foo` in `contents/file1.txt` will become
    `contents__file1.txt__foo`.  Links will be adjusted accordingly:
    if `file2.txt` links to `file1.txt#foo`, then the link will
    be changed to point to `#file1.txt__foo`.  Similarly, a link
    to `file1.txt` will point to `#file1.txt`.  A Div with an
    identifier derived from the file path will be added around
    each file's content, so that links to files will still work.

  * New output format: `chunkedhtml`. This creates a zip file
    containing multiple HTML files, one for each section,
    linked with "next," "previous," "up," and "top" links.
    (If `-o` is used with an argument without an extension,
    it is treated as a directory and the zip file is automatically
    extracted there, unless it already exists.) The top page will
    contain a table of contents if `--toc` is used.  A
    `sitemap.json` file is also included. The option
    `--split-level` determines the level at which sections are
    to be split.

  * Support complex figures (Albert Krewinkel, Aner Lucero).
    There is now a dedicate Figure block constructor for
    figures.  The old hack of representing a figure as
    `Para [Image attr [..alt..] (source, "fig:title")]`
    has been dropped.  Here is a summary of figure support
    in different formats:

    + Markdown reader: paragraphs containing just an image are treated as
      figures if the `implicit_figures` extension is enabled. The identifier
      is used as the figure's identifier and the image description is also
      used as figure caption; all other attributes are treated as belonging
      to the image.
    + Markdown writer: figures are output as implicit figures if possible,
      via HTML if the `raw_html` extension is enabled, and as Div elements
      otherwise.
    + HTML reader: `<figure>` elements are parsed as figures, with the
      caption taken from the respective `<figcaption>` elements.
    + HTML writer: the alt text is no longer constructed from the caption,
      as was the case with implicit figures. This reduces duplication, but
      comes at the risk of images that are missing alt texts. Authors should
      take care to provide alt texts for all images. Some readers, most
      notably the Markdown reader with the `implicit_figures` extension,
      add a caption that's identical to the image description. The writer
      checks for this and adds an `aria-hidden` attribute to the
      `<figcaption>` element in that case.
    + JATS reader: The `<fig>` and `<caption>` elements are parsed into
      figure elements, even if the contents is more complex.
    + JATS writer: The `<fig>` and `<caption>` elements are used write
      figures.
    + LaTeX reader: support for figures with non-image contents and for
      subfigures.
    + LaTeX writer: complex figures, e.g. with non-image contents and
      subfigures, are supported. The `subfigure` template variable is set if
      the document contains subfigures, triggering the conditional loading
      of the *subcaption* package. Contants of figures that contain tables
      are become unwrapped, as longtable environments are not allowed within
      figures.
    + DokuWiki, Haddock, Jira, Man, MediaWiki, Ms, Muse, PPTX, RTF, TEI,
      ZimWiki writers: Figures are rendered like Div elements.
    + Asciidoc writer: The figure contents is unwrapped; each image in the
      the figure becomes a separate figure.
    + Classic custom writers: Figures are passed to the global function
      `Figure(caption, contents, attr)`, where `caption` and `contents` are
      strings and `attr` is a table of key-value pairs.
    + ConTeXt writer: Figures are wrapped in a "placefigure" environment
      with `\startplacefigure`/`\endplacefigure`, adding the features
      caption and listing title as properties. Subfigures are place in a
      single row with the `\startfloatcombination` environment.
    + DocBook writer: Uses `mediaobject` elements, unless the figure contains
      subfigures or tables, in which case the figure content is unwrapped.
    - Docx writer: figures with multiple content blocks are rendered as
      tables with style `FigureTable`; like before, single-image figures are
      still output as paragraphs with style `Figure` or `Captioned Figure`,
      depending on whether a caption is attached.
    + DokuWiki writer: Caption and "alt-text" are no longer combined. The
      alt text of a figure will now be lost in the conversion.
    + FB2 writer: The figure caption is added as alt text to the images in
      the figure; pre-existing alt texts are kept.
    + ICML writer: Only single-image figures are supported. The contents of
      figures with additional elements gets unwrapped.
    + OpenDocument writer: A separate paragraph is generated for each block
      element in a figure, each with style `FigureWithCaption`. Behavior for
      single-image figures therefore remains unchanged.
    + Org writer: Only the first element in a figure is given a caption;
      additional block elements in the figure are appended without any
      caption being added.
    + RST writer: Single-image figures are supported as before; the contents
      of more complex images become nested in a container of type `float`.
    + Texinfo writer: Figures are rendered as float with type `figure`.
    + Textile writer: Figures are rendered with the help of HTML elements.
    + XWiki: Figures are placed in a group.

  * Changes in custom readers/writers:

    + It is now possible to have a custom reader and a custom writer for
      a format together in the same file.  The file may also define
      a custom template for the writer.
    + Pandoc now checks the folder `custom` in the user's data directory
      for a matching script if it can't find one in the local directory.
      Previously, the `readers` and `writers` data directories were
      searched for custom readers and writers, respectively. Scripts in
      those directories must be moved to the `custom` folder.
    + Custom readers used to implement a fallback behavior that allowed to
      consume just a string value as input to the `Reader` function. This
      has been removed, the first argument is now always a list of
      sources. Use `tostring` on that argument to get a string.

  * New module Text.Pandoc.Writers.ChunkedHTML,
    exporting `writeChunkedHtml` [API change].

  * We now set the `pandoc-version` variable centrally rather
    than in the writers.  One effect is the man writer now emits
    a comment with the pandoc version.

  * pandoc-server:

    + Add simple CORS support to pandoc-server (#8427).
    + Print message to stderr when starting the server.

  * Docx reader:

    + Mark unnumbered headings with class `unnumbered` (#8148,
      Albert Krewinkel). This change ensures good conversion
      results when converting with `--number-sections`.
    + Support parsing of highlighted text.
    + Fix handling of `oMathPara` in `w:p` with other content (#8483).

  * ODT reader:

    + Fix relative links. ODT adds a `../` to relative links
      (see #3524); this needs to be removed when converting from ODT.
    + Handle "section" elements (#8409).
    + Rename Text.Pandoc.Readers.Odt -> Text.Pandoc.Readers.ODT,
      for consistency with Writers.ODT. Rename `readOdt` -> `readODT`.
      [API change]

  * DocBook reader:

    + Support href on link even in a fragment (#8437).
      (We now just look for an `href` attribute without
      worrying about the namespace.)
    + Parse title from imageobject/objectinfo (#8437).

  * JATS reader:

    + Handle uri element in references (#8270).

  * Ipynb reader:

    + Add cell id to attachment filename when storing in MediaBag (#8415).
      Otherwise attachments with the same name can overwrite each other.

  * LaTeX reader:

    + Skip parenthenized args of toprule, midrule, etc (#8242).
    + Handle `##` macro arguments properly (#8243).
    + Remove unused function `toksToString` in Parsing module.
    + Support more `soul` commands, including `\hl`.
    + Add `unnumbered` class for `\part*` (#8447)
    + Fix `TEXINPUTS` handling (#8392). If `TEXINPUTS` ends with `:`,
      then the system default `TEXINPUTS` is added.  We handle this by
      just adding the working directory in this case.
    + Parse short table caption (see jgm/pandoc-types#103).
      This is not too useful yet, because writers don't do anything with
      the short caption.

  * MediaWiki reader:

    + Parse table cell with attributess, to support rowspan, colspan (#8231,
      Ruqi).
    + Refine "blending" rules for MediaWiki links (#8525, Ruqi).
      The rules for "blending" characters outside a link into the link are
      described here: https://en.wikipedia.org/wiki/Help:Wikitext#Blend_link
      These pose a problem for CJK languages, which generally don't have
      spaces after links. However, it turns out that the blending behavior, as
      implemented on Wikipedia, is (contrary to the documentation) only for
      ASCII letters. This commit implements that restriction, which fixes
      the problem for CJK.

  * HTML reader:

    + Fix regression for `<tt>` (#8330). It was no longer being parsed as
      Code (Justin Wood).

  * RST reader:

    + Support `mark` role for round-trip.

  * Textile reader:

    + Support linked images (#8541).
    + Fix strong emph ending with link (#8540).
    + Adding a Parser to look for ordered list start attribute numbers
      if any (#2465, vkraven).
    + Handle empty paragraphs (#8487). Also, if attributes are added
      explicitly to a paragraph, put it in a Div with the attributes.

  * Markdown reader:

    + Allow fenced code block "bare" language to be combined
      with attributes (#8174, Siphalor), e.g.
      ````
      ```haskell {.class #id}
      ```
      ````
    + Allow table caption labels to start with lowercase `t` (#8259).
    + Grid tables: allow specifying a table foot by enclosing it with
      part separator lines, i.e., row separator lines consisting only
      of `+` and `=` characters (#8257, Albert Krewinkel). E.g.:
      ```
      +------+-------+
      | Item | Price |
      +======+=======+
      | Eggs | 5£    |
      +------+-------+
      | Spam | 3£    |
      +======+=======+
      | Sum  | 8£    |
      +======+=======+
      ```
    + Fix `implicit_header_references` with duplicate headings (#8300).
      Documentation says that when more than one heading has the same text,
      an implicit reference `[Heading text][]` refers to the first one.
      Previously pandoc linked to the last one instead. This patch
      makes pandoc conform to the documented behavior.
    + Parse highlighted text inside `==..==` if `mark` extension enabled.

  * Org reader:

    + Allow org-ref v2 citations with `&` prefix (#8302).
    + Make `#+pandoc-emphasis-pre` work as expected (#8360, Amir Dekel).

  * BibTeX reader:

    + Fix handling of `%` in `url` field (#7678).
      `%` does not function as a comment character inside `url`
      (where URL-encoding is common).
    + Allow `url` field in `bibtex` as well as `biblatex` (#8287).
      This field is not officially supported for BibTeX, but many styles
      can handle it (<https://www.bibtex.com/f/url-field/>),
      and others will ignore it.
    + Support `software` type in biblatex <-> CSL conversions (#8504).
    + Make sure `version` field comes through in biblatex (#8504).

  * BibTeX writer:

    + Pass through `url` even for `bibtex` (#8287).

  * Org writer:

    + Pass through unknown languages in code blocks (#8278), instead
      of producing `begin_example`.
    + Use span attributes `tag-name` in headers as tags (#8513, Albert
      Krewinkel). This enables round-tripping of tags in Org headings.

  * EndNote reader:

    + Better error when parsing EndNote references fails.

  * DocBook writer:

    + Rename Text.Pandoc.Writers.Docbook -> Text.Pandoc.Writers.DocBook.
      Rename `writeDocbook` -> `writeDocBook`, for consistency with
      the DocBook reader's naming. [API change]
    + Fix position of textobject (#8437). It is a child of
      `inlinemediaobject`, not `imageobject`.
    + Add regression tests for #8437.
    + Render image alt text using textobject element (#8437).
    + Don't indent contents of title element.
    + Store "unnumbered" class in DocBook role attribute (#1402, lifeunleaded).

  * ConTeXt writer (Albert Krewinkel):

    + Support syntax highlighting for code.
    + Always use `\type` for inline code.
      Inline codes that contained curly braces where previously rendered
      with `\mono`; this led to unexpected results when the presentation
      of `\type` was customized, as those changes would not have
      been applied to code rendered with `\mono`.
    + Add support for unlisted, unnumbered headings (#8486).
    + Support `tagging` extension (Albert Krewinkel). Paragraphs
      are enclosed by `\bpar` and `\epar` commands, and `highlight` commands
      are used for emphasis. This results in much better tagging in PDF output.

  * LaTeX writer:

    + Do not repeat caption on headless tables (Albert Krewinkel).
      The caption of headless tables was repeated on each page that
      contained part of the table. It is now made part of the
      "first head", i.e. the table head that is printed only once.
    + Add separator line between table's body and its foot
      (Albert Krewinkel).
    + Ignore languages with no babel equivalent, instead of generating an
      invalid command in the preamble (#8325).
    + Use `\includesvg` for SVGs and include the `svg` package (#8334).
    + Use `soul` instead of `ulem` for strikeout, underline (#8411).
      This handles things like hyphenation, line breaks, and nonbreaking
      spaces better.
    + Use `\toprule\noalign{}` instead of `\toprule()` in tables,
      and similarly for `\midrule` and `\bottomrule` (#8223).
      This facilitates redefining `\toprule`, `\midrule`, and `\bottomrule`
      without needing to gobble the ()s. (Those who redefine these macros
      on the assumption that they will be followed by `()` may need to
      change their definitions.)
    + Support highlighted text for Span with class `mark`.

  * JATS writer:

    + Use `<break/>` for LineBreak in the limited contexts that accept it
      (#8344).
    + Officially deprecate `writeJATS` in favor of `writeJatsArchiving`.

  * RTF writer:

    + Add space after unicode escape commands (#8264).  This fixes
      a bug that caused characters to disappear after unicode escapes.

  * RST writer:

    + Render tables as list tables when the `--list-tables` option is
      specified (`writerListTables`) (#4564, Francesco Occhipinti).
    + Improve inline escaping rules (#8380).
    + Use special `mark` role for Span with class `mark`.

  * Commonmark writer:

    + Ensure that we don't have blank lines in raw HTML (#8307).

  * HTML writer:

    + Only add role attribute in HTML5 (#8241). It is not valid in HTML4.
    + Avoid aria-hidden in code blocks for HTML4 (#8241).
    + Only treat `. . .` as a slide pause in slides, and not in regular
      HTML output (#8281).
    + Properly merge classes for headings of level > 6 (#8363).
    + Prevent `<a>` inside `<a>` (#7585). If a link text contains a link,
      we replace it with a span.
    + Replace deprecated aria roles for bibliography entries (#8354).
      `doc-biblioentry` -> `listitem`, `doc-bibliography` -> `list`.
    + Remove obsolete stuff about mathml-script.
      This was a shim we used to include for mathml support.
      We don't do anything with this any more, so this is dead code.
    + Include math links if there are raw commands or environments that
      can be interpreted as math e.g. by MathJax (#8469).
    + Add prooftree to list of math environments (#8462). This will cause
      raw LaTeX prooftree environments to be rendered appropriately when
      `--mathjax` is used.

  * HTML, Markdown writers: filter out empty class attributes (#8251).
    These should not be generated by any pandoc readers, but they
    might be produced programmatically.

  * Markdown writer:

    + Avoid HTML fallbacks in the generated TOC (Albert Krewinkel, #8131).
      The generated table of contents usually has IDs for each TOC link,
      allowing to link back to specific parts of the TOC. However, this
      leads to unidiomatic markup in formats like gfm, which do not support
      attributes on links and hence fall back to HTML. The IDs on TOC items
      are now removed in that case, leading to more aesthetic TOCs.
    + Escape `!` before `[` (#8254).
    + Support `mark` extension.

  * AsciiDoc writer:

    + In link text, only replace commas with entities when they're in
      Str elements.  If a link contains an image, it may have attributes,
      and the commas there should not be converted (see #8437, #8070).

  * ODT writer:

    + Fix relative links (#3524).

  * Docx writer:

    + Better handling of tables in lists (#5947). Previously the content
      of each list cell was indented when the table belonged to a list
      item.
    + Indent tables in list items (#5947).
    + Adjust correct attribute on `lang` element (#7022). For East Asian
      languages, we need to adjust `w:eastAsia` rather than `w:val`.
      This allows normal fonts to be used for any Latin-font text.
      Similarly, for bidi languages, we need to adjust `w:bidi`
      rather than `w:val`. We treat `he` and `ar` as bidi languages,
      `zh`, `ja`, `ko` as East Asian languages.
    + Support relative image widths (Albert Krewinkel).
      Image widths given in percent are interpreted to be relative to
      the text width. Previously, percent widths were taken relative to
      the image's native size, inconsistently with other writers.
    + Avoid using 'error' for unassigned table cells (#8468). Instead,
      throw a regular pandoc error.
    + Render a Span with class `mark` as highlighted. Currently
      yellow is hardcoded.

  * MediaWiki writer:

    + Use the 'new' table structure, so that colspan and rowspan are
      supported (Wout Gevaert).

  * Man writer:

    + Use UTF-8 by default for non-ascii characters (#8507).
      Only use groff escapes if `--ascii` has been specified on the
      command line (`writerPreferAscii`).

  * ICML writer:

    + Use Contents element for images with raw data instead of a link
      with a data: uri (#8398).

  * EPUB writer:

    + Refactor to use Text.Pandoc.Chunks.
    + Refactored and simplified code.
    + Make title page optional (#6097).

  * Ms writer:

    + Properly format display equations (#8308).
    + Remove -C option on PSPIC. Some old versions don't support this
      option, and since it's the default it shouldn't be necessary.

  * XWiki writer:

    + Use template if it is specified (#8296). Previously
      templates were ignored.

  * LaTeX template:

    + Set fonts after Beamer theme (Jeremie Knuesel). Beamer themes
      such as metropolis and saintpetersburg change the default
      fonts. This change gives precedence to the user font settings
      by moving them after the loading of the Beamer theme.
    + Set `\babelfont` when `mainlang` and `lang` are specified and
      `pdflatex` is not being used (#8538). This is needed for good
      results in Arabic.
    + Add variable `urlstyle` (#8429, Amar Al-Zubaidi). This is set to
      `same` by default, so users should not experience any change.

  * HTML template:

    + Remove default font size, line height and font family in
      default inline css (#8423). `mainfont`, `fontsize`,
      and `linestretch` can still be used as before; the only difference
      is that we no longer provide opinionated defaults.
      This commit also adds a `maxwidth` variable that sets `max-width`;
      if not set, 36em is used as a default.
    + Add `code { hyphens: manual; }`.
    + Use `styles.citations.html` partial in `styles.html`.
    + Fix class name `hanging` -> `hanging-indent` in
      `styles.citations.html`.
    + Put Consolas before Lucida Console for code font (#8543).
      This is to prevent Lucida Console from being used on Windows, where
      it causes spacing issues in some applications, with boldface
      glyphs wider than regular ones.

  * EPUB CSS changes: Reduce the amount of inline CSS used for EPUBs
    (#8379). Almost everything is now in the default EPUB CSS
    (`data/epub.css`), which can be overridden either by
    putting `epub.css` in the user data directory or by using
    `--css` on the command line.  Inline styles are only used
    for syntax highlighting (which depends on the style
    specified, and is only included on pages with highlighted
    code) and for bibliography formatting (which can depend on
    the CSL style, and is only used in the page containing the
    bibliography).

    Note that, for compatibility with older readers, we don't
    use flexbox to style `column/columns` divs by default, as
    we do in HTML.  Instead, we use an older method which only
    works when there are two `column` divs inside a `columns`
    div.  If you need more than two columns and aren't worried
    about support for older EPUB readers, you can modify the
    default CSS (there is a comment in the CSS telling you what
    to do).

  * Reveal.js template: prevent line-wrapping of parallax options
    (#8503, Albert Krewinkel).

  * reference.pptx: Remove unsupported element (#8342, #6338, Link Swanson).
    The default template contained text above the header, which can mislead
    users into thinking there is a way to put text there using pandoc.

  * Text.Pandoc.Readers.Metadata:

    + Fix metadata parsing corner case (#8465).
    + Don't fail on inline metadata beginning with newline (#8358).

  * Text.Pandoc.App:

    + Move initial input-to-Pandoc code to internal submodule (Albert
      Krewinkel).
    + Change `parseOptionsFromArgs` and `parseOptions` (#8406)
      They now return `Either OptInfo Opt`. [API change]
    + Add `OptInfo` type [API change].
    + Add `handleOptInfo` function.  This performs the IO actions for
      things like `--version` that were previously done in
      `parseOptionsFromArgs` [API change].
    + `convertWithOpts`: add argument for a `ScriptingEngine` [API change].
    + Unify check for standalone output (Albert Krewinkel).
    + New `optEpubTitlePage` field on `Opt` [API change] (#6097).
    + Remove `optEpubChapterLevel`, add `optSplitLevel` [API change].
    + Export `IpynbOutput(..)` [API change].

  * Text.Pandoc.App.OutputSettings:

    + Remove unused field `outputWriterName` in `OutputSettings`.

  * Text.Pandoc.Citeproc:

    + Check both extension and mime type to determine bibliography type
      when the bibliography is fetched remotely (#7151).
    + CslJson: allow an object with `items` property in addition to
      an array of references. This is what is returned by e.g.
      `https://api.zotero.org/groups/904125/items?v=...&format=csljson`
    + Require a digit for an implicit "page" locator inside explicit
      locator syntax `{...}` (#8288). Previously a locator specified as
      `{}` would be rendered as `p.` with nothing after it.
    + Update `sub verbo` to `sub-verbo` (#8315). This is a change in
      the term's canonical name in citeproc. As a result of this change,
      `sub verbo` locators have not worked in pandoc since citeproc 0.7.
    + Text.Pandoc.Citeproc.MetaValue: remove unused function
      `metaValueToPath`.
    + Add internal module Text.Pandoc.Citeproc.Name (#8345). This exports
      `toName`, which previously had been part of T.P.Citeproc.BibTeX,
      and allows for cleaner module dependencies.

  * Export module `Text.Pandoc.Slides` [API Change] (Albert Krewinkel).

  * Add new module Text.Pandoc.Format [API change] (Albert Krewinkel).
    The module provides functions and types for format spec parsing and
    processing. The function `parseFormatSpec` was moved from
    Text.Pandoc.Extensions to the new module and renamed to
    `parseFlavoredFormat`. It now operates in
    a PandocMonad and is based on the updated types.

  * Text.Pandoc.Sources:

    + Add UpdateSourcePos instances for String and
      strict and lazy ByteString [API change].

  * Text.Pandoc.Extensions:

    + Fix JSON decoding of Extensions (#8352, Albert Krewinkel).
    + Add new exported function `readExtension` [API change].
    + Remove `parseFormatSpec` [API change]. This has been moved
      to Text.Pandoc.Format and renamed as `parseFlavoredFormat`
      (Albert Krewinkel).
    + Simpler implementation of Extensions based on Set
      (benchmarks show no performance penalty).
    + Add `CustomExtension` constructor to `Extension` [API change].
    + Remove `Bounded`, `Enum` instances for `Extension`.
    + Add `extensionsToList` function.
    + Revise `readExtension` so it can handle `CustomExtension`, and so
      that it returns a Text rather than `Maybe Text`.
    + Add `showExtension` [API change].
    + Add `Ext_mark` extension [API change].
    + Add `Ext_tagging` constructor [API change] (Albert Krewinkel).
    + Add `Ext_wikilinks_title_after_pipe`, `Ext_wikilinks_title_before_pipe`
      [API change] (Albert Krewinkel).

  * Text.Pandoc.PDF:

    + Fix `papersize` on PDF generation via ms (#8403).
      We need to set an option in pdfroff in addition to including
      a macro in the ms file. With this fix, `-Vpapersize=a4` should be
      sufficient to produce A4 PDF via ms.
    + Change default background color of PDFs generated via HTML (#8422,
      Marcin Serwin).

  * Text.Pandoc.MIME:

    + Base module on package `mime-types`, which
      is already a transitive dependency (#8277, Albert Krewinkel).
    + Remove deprecated overrides (#8292).

  * Text.Pandoc.XML:

    + Re-export `lookupEntity` from commonmark-hs [API change].

  * Text.Pandoc.Parsing:

    + Remove gratuitious renaming of Parsec types. We were exporting
      Parser, ParserT as synonyms of Parsec, ParsecT.
      There is no good reason for this and it can cause confusion.
      Also, when possible, we replace imports of Text.Parsec with
      Text.Pandoc.Parsing. The idea is to make it easier, at some point,
      to switch to megaparsec or another parsing engine if we want to.
      New (re-)exports: `Stream(..)`, `updatePosString`, `SourceName`,
      `Parsec`, `ParsecT`. Removed exports: `Parser`, `ParserT`
      [API change].
    + Export `errorMessages`, `messageString` [API change].
    + Export `fromParsecError`, which can be used to turn a parsec
      ParseError into a regular PandocParseError (#8382) [API change].
    + Remove `nested` [API change]. It was not being used, and in fact it
      was a bad idea from the beginning, as it had no hope of solving
      the problem it was introduced to solve.
    + Change `characterReference`, `charsInBalanced`. `characterReference`
      so they now return a Text (some named references don't correspond
      to a single Char). Use the the `lookupEntity` function from
      commonmark-hs instead of the slow one from tagsoup [API change].
    + `charsInBalanced` now takes a Text parser rather than a Char parser
      as argument [API change].

  * Text.Pandoc.Shared:

    + Export `textToIdentifier` [API change].
    + Remove deprecated `crFilter`. [API change]
    + Remove deprecated `deLink`. [API change]
    + Deprecate `notElemText`.
    + Deprecate `makeMeta`.
    + Remove `pandocVersion` (now available in Text.Pandoc.Version
      as `pandocVersionText`).
    + Remove `findM` [API change]. This was only used in one place, and
      can be replaced with simpler code.
    + Remove deprecated `makeMeta` [API change].
    + Remove `ordNub` [API change]. This is just `nubOrd` from
      Data.Containers.ListUtils.
    + Remove `mapLeft` [API change]. This is just a synonym for
      Bifunctor.first.
    + Remove `elemText`, `notElemText` [API change].
    + Drop export of `pandocVersion` and `pandocVersionText`,
      which are now exported by Text.Pandoc.Version.
    + Remove `escapeURI`, `isURI`. These are now exported by
      Text.Pandoc.URI, and removing them from Shared helps make
      the module structure more straightforward.
    + Use LineBreak as default block sep in `blocksToInlines`.
      (#8499, Albert Krewinkel). This change also affects the
      `pandoc.utils.blocks_to_inlines` Lua function.
    + `defaultUserDataDir` is no longer exported (it has been
      moved to T.P.Data) [API change].
    + New function `figureDiv`, offering offers a standardized way
      to convert a figure into a Div element (Albert Krewinkel) [API change].

  * Text.Pandoc.Writers.Shared:

    + Export `htmlAddStyle`, `htmlAlignmentToString` and `htmlAttrs`
      [API change] (Wout Gevaert).
    + Use 'literal tag' instead of 'text (T.unpack tag)' in `tagWithAttrs`
      (Wout Gevaert).
    + `toTableOfContents`: handle nested Divs better (#8402).

  * Rename Text.Pandoc.Network.HTTP -> Text.Pandoc.URI.
    This is still an unexported internal module.
    Export `urlEncode`, `escapeURI`, `isURI`, `schemes`, `uriPathToPath`.
    Drop exports of `schemes` and `uriPathToPath`.

  * Text.Pandoc.URI `isURI`: don't require non-ASCII characters to be
    escaped (#8508).

  * Rename Text.Pandoc.Readers.LaTeX.Types -> Text.Pandoc.TeX (internal
    module).

  * Text.Pandoc.Options:

    + WriterOptions now has a field `writerListTables`,
      specifying that list tables be used in RST output [API change].
    + New `writerEpubTitlePage` field on `WriterOptions` (#6097)
      [API change].
    + Remove `writerEpubChapterLevel`, add `writerSplitLevel` [API change].

  * Text.Pandoc.Filter:

    + Export `applyFilters` [API change].
    + Export `applyJSONFilter` [API Change] (Albert Krewinkel).
    + Parameterize `applyFilters` over scripting engine [API change] (Albert
      Krewinkel).

  * New exported module Text.Pandoc.Chunks [API change].  This
    module provides functions to split Pandoc documents into
    chunks to be rendered in separate files, e.g. one per
    section.  Internal identifiers are rewritten appropriately to
    point to the new locations (#6122).

  * Text.Pandoc.Readers:

    + Change argument type of `getReader`, so it takes a `FlavoredFormat`
      instead of a `Text` [API change] (Albert Krewinkel).

  * Text.Pandoc.Writers:

    + Change argument type of `getWriter`, so it takes a `FlavoredFormat`
      instead of a `Text` [API change] (Albert Krewinkel).

  * Text.Pandoc.Templates:

    + Do not try to normalize input to `getDefaultTemplate` (Albert
      Krewinkel). The function `getDefaultTemplate` no longer splits off
      extension modifers from the given format, as that conflicts with
      using custom writers as formats. Haskell library users should use
      `getDefaultTemplate <=< (fmap formatName . parseFlavoredFormat)`
      if the input format can still contain extensions. The same is true
      for `compileDefaultTemplate`, which calls `getDefaultTemplate`
      internally
    + Add Wrapper type documentation (#8490, William Rusnack).

  * New exported module Text.Pandoc.Scripting (Albert Krewinkel).
    The module contains the central data structure for scripting engines
    (e.g., Lua) [API change].

  * Text.Pandoc.Error:

    + Add new PandocError constructor `PandocNoScriptingEngine` [API change]
      (Albert Krewinkel).
    + Add new PandocError constructor `PandocFormatError` [API change]
      (Albert Krewinkel). The new error is used to report problems with
      input or output format specifications.
    + Add new PandocError constructor `PandocNoTemplateError`
      (Albert Krewinkel).
    + Remove `PandocParsecError` constructor from `PandocError` (#8385).
      Henceforth we just use `PandocParseError`.

  * New module Text.Pandoc.Version, exporting `pandocVersionText`
    and `pandocVersion` [API change].  `pandocVersion` returns a `Version`
    instead of a `Text`, which is consistent with `pandocTypesVersion`.

  * Text.Pandoc.Class:

    + Make `getPOSIXTime`, `getZonedTime` sensitive to `SOURCE_DATE_EPOCH`
      environment variable if set (#7093).  (`getTimestamp` was
      already sensitive.)  This ensures that EPUB builds are reproducible.
    + Text.Pandoc.Class no longer exports `readDataFile`,
      `readDefaultDataFile`, `setTranslations`, and `translateTerm`
      [API change].
    + Text.Pandoc.Class now exports `checkUserDataDir` [API change].

  * T.P.Class.IO: export function `writeMedia` [API change] (Albert Krewinkel).
    This is useful for the `pandoc.mediabag` module.

  * Separate out Text.Pandoc.Data and Text.Pandoc.Translations from
    Text.Pandoc.Class (#8348). This makes Text.Pandoc.Class
    more self-contained.

    + Text.Pandoc.Data is now an exported module, providing `readDataFile`
      and `readDefaultDataFile` (both formerly provided by
      Text.Pandoc.Class), and also `getDataFileNames` (formerly
      unexported in Text.Pandoc.App.CommandLineOptions)
      and `defaultUSerDataDir` (formerly provided by
      Text.Pandoc.Shared). [API change]
    + Text.Pandoc.Translations is now an exported module (along with
      Text.Pandoc.Translations.Types), providing `readTranslations`,
      `getTranslations`, `setTranslations`, `translateTerm`,
      `lookupTerm`, `readTranslations`, `Term(..)`, and `Translations` [API
      change].

  * Text.Pandoc now exports Text.Pandoc.Data and `setTranslations`
    and `translateTerm` {API change].

  * Export module Text.Pandoc.Class.IO [API change].
    The module is useful when defining instances of class PandocMonad for
    types that are also instances of MonadIO.

  * Remove modules Text.Pandoc.Writers.Custom and Text.Pandoc.Readers.Custom
    [API Change] (Albert Krewinkel). The functions `writeCustom` and
    `readCustom` are available from module Text.Pandoc.Lua.

  * Text.Pandoc.Server:

    + Split this module into a separate package, `pandoc-server`,
      allowing the `pandoc` library to be compiled without server support.
    + Return object if JSON is accepted. Previously we just returned
      a JSON-encoded string. Now we return something like:
      ```
      {
          "output": "<p>hello</p>"
          "base64": false,
          "messages": [
              {
                  "message": "Not rendering RawInline (Format \"tex\") \"\\\\noe\"",
                  "verbosity": "INFO"
              }
          ],
      }
      ```
      This is a change in the pandoc-server JSON API.
    + Set translations in the writer based on `lang` metadata.
    + Return error in JSON object if response is JSON.
    + Remove `parseServerOpts`. [API change]

  * Text.Pandoc.Lua:

    + This module has been moved to a separate package,
      `pandoc-lua-engine`.
    + Export `applyFilter`, `readCustom`, and `writeCustom`.
      No longer export the lower-level function `runFilterFile` [API
      change].
    + Change type of `applyFilter` [API Change] (Albert Krewinkel).
      The module Text.Pandoc.Filter.Lua has been merged into
      Text.Pandoc.Lua. The function `applyFilter` now has type
      ``` haskell
      applyFilter :: (PandocMonad m, MonadIO m)
                  => Environment-> [String]-> FilePath-> Pandoc-> m Pandoc
      ```
      where `Environment` is defined in Text.Pandoc.Filter.Environment.
    + Export new function `getEngine` [API Change].
      The function returns the Lua scripting engine.
    + Add unexported modules T.P.Lua.Reader, T.P.Lua.Writer.
      These contain the definitions of `readCustom` and `writeCustom`
      that were previously in T.P.Readers.Custom and T.P.Writers.Custom.
    + Cleanup module dependencies, for a cleaner module dependency graph.
    + The `writeCustom` function has changed to return a Writer and
      an ExtensionsConfig [API change].  This allows ByteString writers
      to be defined.
    + The `readCustom` function has changed to return a Reader and an
      ExtensionsConfig [API change].

  * Lua subsystem (Albert Krewinkel):

    + The whole Lua subsystem has been moved to a separate package,
      `pandoc-lua-engine`.  `pandoc` does not depend on it.
      `convertWithOpts` has a new parameter that can be used to
      pass in the scripting engine defined in `pandoc-lua-engine`
      (or a different one, in theory).
    + Fix the behavior of Lua "Version" objects under equality
      comparisons (#8267).
    + Support running Lua with a GC-collected Lua state.
    + Ensure that extensions marshaling is consistent.
    + Produce more informative error messages for pandoc errors.
      Errors are reported in Lua in the same words in which they would be
      reported in the terminal.
    + Add new module `pandoc.format`. The module provides functions to
      query the set of extensions supported by formats and the set
      of extension enabled per default.
    + Add function `pandoc.template.apply`.
    + Add function `pandoc.template.meta_to_context`.
      The functions converts Meta values to template contexts; the intended
      use is in combination with `pandoc.template.apply`.
    + Allow Doc values in `WriterOptions.variables`.
      The specialized peeker and pusher function for `Context Text` values
      does not go via JSON, and thus keeps Doc values unchanged during
      round-tripping.
    + Fix rendering of Lua errors in Lua, so that the
      `Error running Lua` message is not prepended multiple times.
    + Add new module `pandoc.zip`.
    + Allow strings in place of compiled templates (#8321).
      This allows to use a string as parameter to `pandoc.template.apply`
      and in the WriterOptions `template` field.
    + Rename `reader_extensions`/`writer_extensions` globals as `Extensions`
      (#8390).
    + Add `pandoc.scaffolding.Writer` (#8377). This can be used to reduce
      boilerplate in custom writers.
    + Fix peeker for PandocError (Albert Krewinkel). String error messages
      were incorrectly popped of the stack when retrieving a PandocError.
    + Add functions `pandoc.text.toencoding`, `pandoc.text.fromencoding`
      (#8512, Albert Krewinkel).
    + Add `pandoc.cli` module. Allow processing of CLI options in Lua.
    + Support `-D` CLI option for custom writers.
      A new error `PandocNoTemplateError` (code 87) is thrown if a template
      is required but cannot be found.
    + Allow table structure as format spec. This allows to pass structured
      values as format specifiers to `pandoc.write` and `pandoc.read`.
    + Add function `pandoc.mediabag.write` (Albert Krewinkel).
    + Add module `pandoc.structure` (Albert Krewinkel). The function
      `make_sections` has been given a friendlier interface and moved to the
      new module; the old `pandoc.utils.make_sections` has been deprecated.

  * Custom writers:

    + The global variables `PANDOC_DOCUMENT` and `PANDOC_WRITER_OPTIONS`
      are no longer set when the writer script is loaded. Both variables
      are still set in classic writers before the conversion is started,
      so they can be used when they are wrapped in functions.
    + Deprecate classic custom writers.
    + Add function `pandoc.write_classic`. The function can be used to
      convert a classic writer into a new-style writer by setting it as
      the value of `Writer`:
      ``` lua
      Writer = pandoc.write_classic
      ```
      or to fully restore the old behavior:
      ``` lua
      function Writer (doc, opts)
        PANDOC_DOCUMENT = doc
        PANDOC_WRITER_OPTIONS = opts
        load(PANDOC_SCRIPT_FILE)()
        return pandoc.write_classic(doc, opts)
      end
      ```
    + Support extensions in custom writers. Custom writers can define the
      extensions that they support via the global `writer_extensions`.
      The variable's value must be a table with all supported extensions
      as keys, and their default status as values. For example,
      the below specifies that the writer supports the extensions `smart`
      and `sourcepos`, but only the `smart` extension is enabled by default:
      ``` lua
      writer_extensions = {
        smart = true,
        sourcepos = false,
      }
      ```
    + Custom writers can define a default template via a global `Template`
      function; the data directory is no longer searched for a default
      template. Writer authors can restore the old lookup behavior with
      ``` lua
      Template = function ()
        local template
        return template.compile(template.default(PANDOC_SCRIPT_FILE))
      end
      ```

  * Custom readers:

    + Support extensions in custom readers.
      Custom readers, like writers, can define the set of supported
      extensions by setting a global. E.g.:
      ``` lua
      reader_extensions = {
        smart = true,
        citations = false,
      }
      ```

  * Use latest versions of `commonmark-extensions`, `texmath`,
    `citeproc`, `gridtables`, and `skylighting`.

  * Use pandoc-types 1.23.  This adds the `Figure` Block
    constructor and removes the `Null` Block constructor.

  * Require aeson >= 2.0.

  * Use jira-wiki-markup 1.5.0 (#8511, Albert Krewinkel). Fixes issues with
    icon-like sequences at the beginning of words.

  * Use doctemplates 0.11, avoiding a transitive dependency on HsYAML.

  * Use skylighting 0.13.1.2.

  * Allow mtl 2.3.1 (Alexander Batischev).

  * Use latest skylighting-format-context.

  * Allow building with mtl 2.3.

  * Remove `lua53` flag.  We now only support Lua 5.4.

  * Add hie.yaml for haskell language server.

  * Add tools/latex-package-dependencies.lua.

  * Update default CSL with latest `chicago-author-date.csl`.

  * make_artifacts.sh: various small improvements.

  * Remove sample.lua from data files (#8356).

  * Documentation:

    + Deprecate `PANDOC_WRITER_OPTIONS` in custom writers (Albert Krewinkel).
    + Document `pandoc.write_classic` (Albert Krewinkel).
    + Document new table features (Albert Krewinkel).
    + Clarify what background-image does in reveal.js (#6450).
    + Documentation improvements for `blank_before_blockquote`
      (#8324, Pranesh Prakash).
    + Update grid table documentation (#8346).
    + Add note about MathJax fonts to `--embed-resources`.
    + Use cabal's --package-env more (#8317, Artem Pelenitsyn).
    + Modify Zerobrane instructions to use Lua 5.4 (#8353, Ian Max Andolina).
    + Fix documentation for highlight-style in `pandoc-server.md`.
    + Fix link to fedora package site (#8246, Akos Marton).
    + Rephrase paragraph on format extensions (#8375, Ilona Silverwood).
    + Update README.template (#8496, Sven Wick).
    + Fix a tiny typo in lua-filters.md (TomBen).
    + Clarify that `--css` should be used with `-s`.
    + Clarify font selection for pdf -t ms (#8421, nbehrnd).
    + Clarify docs for `--metadata-file` (#8459).
    + Fix typo in epub.md (Vladimir Alexiev).
    + Add missing backtick in filters.md (R. N. West).
    + `doc/lua-filters.md`: add documentation for `pandoc.format`
      (Albert Krewinkel).
    + Fix epub-embed-font documentation (#8455, Terence Eden).
    + Removed obsolete Templates section in CONTRIBUTING.md.
    + Add manual section on accessible PDFs, archiving standards (#8312,
      Albert Krewinkel).

  * Tests.Command: remove unused `runTest`.

  * Add pandoc-lua.1 man page.

  * Improve `shell.nix`.

  * Add `tools/moduledeps.lua` for inspecting the internal module
    dependency tree.

  * Fix macOS zip so pandoc-server is a symlink. This cuts its size by 2x.

  * CI: Improve CI speed by caching more, eliminating macos builds,
    and splitting benchmarks into a separate action, run by
    manual dispatch. (We still test that benchmarks build in
    the regular CI.) The cache can be expired manually by
    modifying the secret `CACHE_VERSION`.

  * Remove the unnecessary Setup.hs from pandoc.
    Cabal does not need this with build-type 'simple'.

  * Add pandoc-lua and pandoc-server (symlinks) and their man pages
    to releases.

  * Use hslua-cli package for pandoc-lua interface (Albert Krewinkel).

  * Add `server` flag to pandoc-cli, allowing it to be compiled without
    server support.

  * pandoc-cli: Allow building a binary without Lua support (Albert
    Krewinkel). Disabling the `lua` cabal flag will result in a
    binary without Lua.

  * Move `--version` handling to pandoc-cli. We need it here in order
    to print information about whether server and Lua support have been
    compiled in.

  * Move `nightly` flag from pandoc to pandoc-cli (#8339).

  * Makefile changes:

    - `make help` will now print all the targets and what they do.
    - Add targets: `coverage`, `weeder`, `moduledeps`, `prerelease`,
      `ghcid`, `repl`, `linecounts`, `hie.yaml`, `binpath`.
    - Note that you can `` alias pandoc=`make binpath` `` for
      convenient local testing of a build.
    - Rename `quick-cabal` -> `build`, `quick-test` -> `test`.
    - Exclude tests from `SOURCEFILES`.

  * Factor out xml-light into an internal library.

  * Add CITATION.cff (#8434).

  * Move trypandoc to a separate repository, jgm/trypandoc.

## pandoc 2.19.2 (2022-08-22)

  * Fix regression with data uris in 2.19.1 (#8239).
    In 2.19.1 we used the base64URL encoding rather than base64.

  * pandoc-server: handle `citeproc` parameter as documented (#8235).

  * Org reader: treat *emacs-jupyter* src blocks as code cells (#8236,
    Albert Krewinkel). This improves support for notebook-like org files
    that are intended to be used with emacs-jupyter package.

  * HTML writer and templates: revert to using `width` property for column
    widths (Albert Krewinkel). The default `flex` and `overflow-x` properties
    of a column are set to `auto`. In combination, these changes allow to
    get good results when using columns with or without explicit widths.

  * Org writer (Albert Krewinkel):

    + Add support for jupyter nodebook cells (#6367).
    + Prefix code language of ipynb code blocks with `jupyter-`.
      This is the convention used by the *emacs-jupyter* package.
    + Keep code block attributes as header args. This allows to keep more
      information in the resulting `src` blocks, making it easier to
      roundtrip from or through Org. Org babel ignores unknown header
      arguments.
    + Add code block identifier as `#+name` to src blocks.

  * Fix some typos in the codebase (luz paz).

  * Require hslua-module-path 1.0.3 (#8228, Albert Krewinkel).

## pandoc 2.19.1 (2022-08-18)

  * Add server capabilities.

    + New exported module Text.Pandoc.Server [API change].
    + The pandoc executable now starts up a web server when renamed or
      symlinked as `pandoc-server`, and functions as a CGI program when
      renamed or symlinked as `pandoc-server.cgi`.  See the man page for
      `pandoc-server` for full documentation.

  * Text.Pandoc.App.Opts: Redo `FromJSON` for `Opt` so that optional
    values can be omitted (in which case the values from
    `defaultOptions` are used).

  * Org reader: treat "abstract" block as metadata (Albert Krewinkel, #8204).
    A block of type "abstract" is assumed to define the document's abstract.
    It is transferred from the main text to the metadata.

  * Org template: add abstract from metadata as block of type "abstract"
    (#8204).

  * HTML writer: use `flex` property for column widths
    (Albert Krewinkel, #8232).

  * LaTeX writer:

    + Add label to tables that have an identifier (Albert Krewinkel, #8219).
      Tables with an identifier are marked with a `\label`. A caption is
      always included in this case, even if the caption is empty.
    + Use `\textquotesingle` for straight quotes in text.
    + Fix widths of multicolumn cells (#8218).

  * LaTeX template: fix behavior of `colorlinks` variable (Albert
    Krewinkel, #8226). Fixes a regression in 2.19 that required the
    `boxlinks` variable to be set in addition to the usual link coloring
    variables. Otherwise links were never colored in LaTeX PDF output.

  * Text.Pandoc.Highlighting: Export `lookupHighlightingStyle`
    [API change]. Previously this lived in an unexported module
    Text.Pandoc.App.CommandLineOptions, under the name
    `lookupHighlightStyle`.

  * Text.Pandoc.App:

    + Remove unneeded MonadIO constraints in readSources.
    + Factor out `convertWithOpts'` from `convertWithOpts`.
      This runs in any PandocMonad, MonadIO, MonadMask instance.
      So far it is not exported, but it might find a use later.

  * Support `--strip-comments` in commonmark/gfm (#8222).
    This change makes the commonmark reader sensitive to
    `readerStripComments`.

  * Lua: add function `pandoc.utils.citeproc` (Albert Krewinkel).
    The function runs the *citeproc* processor on a Pandoc document.
    Exposing this functionality to Lua allows to make citation processing
    part of a filter or writer, simplifies the creation of multiple
    bibliographies, and enables the use of varying citation styles in
    different parts of a document.

  * Refactor `linux/make_artifacts.sh`.

  * Update INSTALL.md installation from source instructions.

  * Use base64 package instead of base64-bytestring. It is supposed to be
    faster and more standards-compliant.

  * trypandoc improvements:

    + Add dropdown with canned examples.
    + Add citeproc support.
    + Support csv, bibliographic and binary formats.
    + Add load from file.
    + Add permalink.  Don't always reload page.
    + Use vanilla JS and CSS + the new `pandoc-server.cgi`.

  * Allow haddock-library-1.11.0.

  * Convert `tool/extract-changes.hs` to a Lua filter.


## pandoc 2.19 (2022-08-03)

  * Add `--embed-resources` flag (Elliot Bobrow, #7331).  This can be
    used to embed resources without implying `--standalone`.
    Deprecate `--self-contained` in favor of `--embed-resources --standalone`.

  * Allow environment variable interpolation in `highlight-style`
    and `pdf-engine` fields in defaults files
    (#8061; Jaehwang Jung, #8073).

  * Allow placing custom readers and writers in user data directory
    (Albert Krewinkel, #8112) (`readers` and `writers` subdirectories).

  * Add `tsv` (tab separated values) as an input format (#7974).
    [API change]: Text.Pandoc.Readers.CSV now exports `readTSV`.
    Internal change:  In Text.Pandoc.CSV, `CSVOptions` has changed
    so that `csvQuote` takes a Maybe value.

  * Add `tex_math_dollars` to `gfm` default extensions (reflecting
    gfm's new support for math).

  * RST, Org, Markdown readers: support rowspans and colspans in grid tables
    (#8202, Albert Krewinkel). Note: the writers does not yet support these
    more complex grid table features, so these complex grid tables will
    not round-trip.

  * HTML, LaTeX, and MediaWiki readers: use `formatCode`
    (#8162, #8129, Elliot Bobrow). This moves formatting from inside inline
    code elements to the outside, since pandoc's Code element only takes string
    content.

  * Markdown reader:

    + Don't parse inline notes with blank lines inside (#8028).
    + Allow attributes in special spans (e.g. `smallcaps`, `underline`)
      (Albert krewinkel, #4102). These spans are parsed as
      SmallCaps or Underline elements, but any attributes are included
      in a wrapping Span.

  * HTML reader:

    + Allow sublists that are not marked as items (Albert
      Krewinkel, #8150). This is technically invalid HTML, but it can
      be found in the wild and browsers handle it.

  * Org reader (Albert Krewinkel):

    + Recognize absolute paths on Windows (Albert Krewinkel, #8201).
    + Recognize {webp,jxl} files as images (YI).
    + Allow attrs for Org tables (Albert Krewinkel, #8049). Tables with
      attributes are no longer wrapped in Div elements; attributes are added
      directly to the table element.
    + Support line selection in INCLUDE directives (Brian Leung, #8060).
    + Fix Post / Pre mixup when setting emphasis chars (Amir Dekel, #8134).

  * LaTeX reader:

    + Support `\includesvg` (#8027).
    + Unescape characters in `\lstinline` inside `\passthrough` (#8179).
    + Improve `mathEnvWith` (#8122). When converting e.g. an align
      environment to an aligned environment inside a Math element, we need
      to include a newline before the `\end{aligned}`, since the previous
      line might end in a comment.
    + Fix treatment of extensions for `\input` in LaTeX reader (#8092).
      Previously we required a `.tex` extension, but TeX
      allows any extension for `\input` (as opposed to `\include`).

  * RTF reader:

    + support `\nosupersub` (#8170).

  * TikiWiki reader:

    + Support underlined text

  * DocBook reader:

    + Improved reading `<xref>` elements (Frerich Raabe, #8065).

  * JATS reader:

    + Strip `ref-` prefix from ref id in xref (#8007).
    + Support edition in references (#8087).

  * RIS reader:

    + Make parser more forgiving (#8034). Allow blank lines after entries.
      Allow entries with no space after the `-`, provided they
      just have a newline, e.g. `DB -\n`.
    + Get right order of names (#8055).

  * MediaWiki reader:

    + Allow HTML comment after row start (#8110).

  * DokuWiki reader:

    + The `tex_math_dollars` extension is now supported for `dokuwiki`
      (but off by default) (#8178).
    + Content inside `<latex>...</latex>` is parsed as raw LaTeX inline,
      and inside `<LATEX>..</LATEX>` as raw LaTeX block (#8178).
    + The behavior of `<php>...</php>` is changed, so that instead of
      producing a code block, it produces raw HTML with `<?php ... ?>`.

  * LaTeX writer:

    + Improve grouping with autocites (#8088).
    + Extend list of book documentclasses (Wentau Han, #8053).
    + Fix width of multicolumn cells (Albert Krewinkel, #8090).
      Cells spanning multiple columns must be given an explicit width,
      calculated from the table properties.
    + Beamer: allow containsverbatim as alternative to fragile (#8080).

  * HTML writer:

    + Add 'footnotes' identifier to footnotes section (#8043).
    + Fix bug with `--number-offset`. This formerly caused section divs
      to be produced, even when `--section-divs` was not specified (#8097).
    + Use CSS flexboxes for columns (Albert Krewinkel). This allows
      an arbitrary number of columns, while the previous approach assumed
      exactly two columns.
    + Allow "spanlike" classes to be combined (see #8194). Previously
      classes like "underline" and "marked" had to be the first class
      in a span in order for the span to be interpreted as a "ul" or
      "mark" element.  This commit allows these special classes to be
      "stacked," e.g. `[test]{.mark .underline}`; in addition, the
      special classes are no longer required to come first in the list
      of classes.
    + Avoid doubled style attribute when height and width are added to
      style because of an image, but the image already has a style attribute
      (#8047).
    + Do not include the deprecated doc-endnote role (#8030).
      doc-endnote was deprecated in DPUB-ARIA 1.1.
    + Remove extra soft break for tasklist (black-desk, #8142).
      Browser will display the extra newline character between checkbox and
      text as a space, which make tasklist items cannot be aligned.

  * EPUB writer:

    + Allow choice of math method for v3 (#8164). Previously we always
      used MathML for math in EPUB3, because the spec includes MathML.
      But this is not widely supported by readers, so it seems better
      to allow users to choose their math method as they can with
      EPUB2 or HTML. **NOTE:** Existing workflows that produce EPUBv3
      documents including math will be affected by this change.  You
      must add `--mathml` to your command line if you want to continue
      producing MathML.

  * RST writer:

    + Fix missing spaces with nested inlines (#8182).
    + Always escape literal backslash (#8178).

  * Ms writer:

    + Add comment in preamble stating generator.
    + Fix roff ms syntax highlighting definitions (#8175, thanks to
      Branden Robinson).

  * ConTeXt writer:

    + Support complex table structures (Albert Krewinkel, #8116).
      The following table feature are now supported in ConTeXt:

      - colspans,
      - rowspans,
      - multiple bodies,
      - row headers, and
      - multi-row table head and foot.

      The wrapping `placetable` environment is also given a `reference` option
      with the table identifier, enabling referencing of the table from within
      the document.
    + Unify link handling (Albert Krewinkel, #8096).
      Autolinks, i.e. links with content that's the same as the linked URL,
      are now marked with the `\url` command. All other links, both internal
      and external, are created with the `\goto` command, leading to shorter,
      slightly more idiomatic code. As before, autolinks can still be styled
      via `\setupurl`, other links via `\setupinteraction`.
    + Use "sectionlevel" environment for headings (Albert Krewinkel, #5539).
      The document hierarchy is now conveyed using the
      `\startsectionlevel`/`\stopsectionlevel` by default. This makes it easy
      to include pandoc-generated snippets in documents at arbitrary levels.
      The more semantic environments "chapter", "section", "subsection", etc.
      are used if the `--top-level-division` command line parameter is set to
      a non-default value.

  * Docx writer:

    + Add `w:lang` to `rPr` for Span and Div with lang attribute, so
      that Word can know that "Apfel" is not a spelling error (#8026).
    + Prevent crashing when handling invalid tables (Albert Krewinkel, #8102).
      Tables with different numbers of cells per row would sometimes crash
      pandoc. This fix prevents this by cutting off overlong rows.

  * ICML writer:

    + Support custom-style attribute on Table (#8079).

  * AsciiDoc writer:

    + Fix commas in link text (#8070). Commas in link text trigger
      interpretation of attributes. To block this, we replace them with
      numeric entities.
    + Fix underline. We were rendering it as `+++text+++`; this is now
      changed to `[.underline]#text#`.  See comment at
      <https://github.com/jgm/pandoc/issues/8070#issuecomment-1126883824>.

  * FB2 writer:

    + Fix handling of non-section Divs (#8123).

  * Markdown writer:

    + Disable soft wrapping when `hard_line_breaks` enabled (#8035).
      We were already doing this for `markdown`; this commit does
      the same thing for `markua` and `commonmark` and `gfm`.
    + Avoid excessive indentation on bullet lists for `commonmark`,
      `markua`, `gfm`.  They are now nested by 2 spaces instead of 4 (#8011).

  * Text.Pandoc.Class:

    + Add new function `findFileWithDataFallback` [API Change]
      (Albert Krewinkel).
    + `fillMediaBag`: Keep attributes of original image on Span (Albert
      Krewinkel, #8099). Images that cannot be fetched are replaced with a
      Span that contains the image's description. The span now also retains
      all original image attributes and inherits all attributes of the image.
      Furthermore, the classes `image` and `placeholder` are added, and path
      and title are store in attributes `original-image-src` and
      `original-image-title`, respectively.

  * Text.Pandoc.Shared:

    + `makeSections`: don't make a section for a div with class "fragments"
      (#8098).
    + Ensure that Nulls are ignored by `makeSection` and in segmenting
      slides (#8155).
    + Add `formatCode` function to Text.Pandoc.Shared [API change]
      (Elliot Bobrow, #8129).
    + `taskListItemToAscii`: handle asciidoctor's characters (#8011).
      Asciidoctor uses different unicode characters for task
      lists; we should recognize them too and be able to convert
      them to ascii task lists in formats like gfm.
    + Deprecate `deLink` and mark for later removal.

  * Text.Pandoc.Writers.Shared:

    + `toTableOfContents`: Don't replace links with empty spans in TOC (#8020).

  * Text.Pandoc.Readers.Metadata:

    + Ensure that metadata values w/o trailing newlines are
      parsed as inlines, as the manual states.
      Previously, they were parsed as inlines if they would
      otherwise have been a single Plain or Para, but otherwise
      left unchanged.  This led to some quirky results (e.g. #8143).
      We now use the general function `blocksToInlines` from T.P.Shared.

  * Text.Pandoc.Parsing:

    + Simplify `gridTableWith'`, `gridTableWith` [API Change] (Albert
      Krewinkel). The functions `gridTableWith` and `gridTableWith'` no
      longer takes a boolean argument that toggles whether a table head
      should be parsed: both, tables with heads and without heads, are
      always accepted now.

  * Lua subsystem (Albert Krewinkel):

    + Extend `pandoc.system` module (Albert Krewinkel, #8184).
      The module now has the additional functions `list_directory`,
      `make_directory`, and `remove_directory`. This makes it easier to write
      cross-platform scripts that need to inspect or modify the file system.
    + Require pandoc-lua-marshal 0.1.7. Adds a `clone` methods to
      Pandoc objects and allows to pass Blocks in instead of full
      Caption elements.
    + Add fields `pandoc.readers` and `pandoc.writers` (#8177).
      The set of supported input and output formats is made available to Lua
      users.
    + Ensure that tables marshaled via JSON arrays behave like Lists.
      This allows to invoke methods like `map` and `includes` on lists like
      `PANDOC_WRITER_OPTIONS.extensions`.
    + Require hslua-2.2.1, unless lua53 flag is set, and do not reset
      foreign encoding before running Lua. This fixes a problem where
      the encoding used for Lua filenames would sometimes mismatch the
      encoding used by the OS.
    + Simplify module loading code. Modules are now loaded directly;
      the special pandoc Lua package searcher is no longer necessary and
      has been removed.
    + Add function pandoc.mediabag.fill (#8104). The function allows to
      fill the mediabag with all images in a given document. Images that
      cannot be fetched are replaced with a Span containing the
      image description.

  * Populate mediabag after filters have run (Albert Krewinkel, #8099).
    The mediabag is filled with document resources after the filters have
    run. This allows, for example, filter authors to modify image paths
    before pandoc tries to fetch the images.
    Lua filters that rely on a filled mediabag can use the new
    `pandoc.mediabag.fill` function to perform that action in the filter.

  * Ms template: redefine rather than removing .CH macro (#8175).

  * JATS template (Albert Krewinkel, except as noted):

    + Include particles, prefix, suffix in names.
    + Mark authors with cor-id as corresponding authors.
      Corresponding authors are marked by setting the attribute
      `corresp="yes"` in their respective `<contrib>` element.
    + Unconditionally include permissions element (#8040).
      Fixes a bug that caused license information to be omitted when no
      copyright information was provided.
    + Follow JATS4R recommendation and PudMed Central for license URI
      (Castedo Ellerman, #8041).

  * LaTeX template:

    + Rename  `\textormath` to `\TextOrMath` (Hos Es, #8036).
    + Fix links-as-notes (Albert Krewinkel, #8077).

  * HTML template styles:

    + Remove `span.underline` rule. This is superfluous now that we
      render Underline as `<u>`.
    + Improve CSS for task lists (#8151).

  * LaTeX template: Add `boxlinks` variable for LaTeX/PDF output (#8198).
    If `boxlinks` is set but `colorlinks` is not, then boxes will
    be printed around links (`hidelinks` will not be set in `hypersetup`).

  * `--self-contained`: Handle `url()` in `<style>` elements (#8193).

  * Text.Pandoc.PDF: use SHA1 hash of filename when converting SVG.
    The previous code threw away the directory component of
    the filename in constructing a new one. This led to
    surprising results if you had e.g. `foo/pic.svg` and `bar/pic.svg`;
    in the final PDF they'd be the same image, because the latter
    would overwrite the former in the temp directory.

  * Remove Muse reader round-trip tests. These are nondeterministic and have
    repeatedly failed on strange edge cases.

  * Update fonts MIME following IANA recommendation (Gabriel Lewertowski,
    #8127).

  * Future compat change for `liftA2` export from Prelude (Georgi Lyubenov,
    #8132).

  * Update `default.csl` from the latest chicago-author-date.csl.

  * Update manfilter.hs for greater portability (#8045).
    The tables in our man pages were not rendering correctly
    with mandoc, now used by default with macOS. mandoc doesn't
    allow man formatting inside table cells. For maximum portability,
    we now render the tables in plain format and include them as code
    blocks in the man page.

  * CI: update macos container version (#8197, Sukka).

  * Add `nightly` flag. This causes a `-nightly-COMPILEDATE`
    suffix to be added the the output of `--version` (#8016).
    This is used in the nightly CI builds.

  * Update dependencies (aeson, skylighting, pandoc-lua-marshall,
    citeproc, texmath).

  * Documentation improvements (thanks to Jiří Wolker,
    Castedo Ellerman, Albert Krewinkel, Bastien Dumont, Cezar Drożak, Benjamin
    Wuethrich, Ivan Panchenko, Sukil Etxenike, Masataka Ogawa).

## pandoc 2.18 (2022-04-04)

  * New input formats: `endnotexml` (EndNote XML bibliography),
    `ris` (RIS bibliography).

  * A RIS bibliography file may now be used with `--citeproc`.

  * Citeproc: Allow a formatted bibliography to be placed in metadata fields
    via a Div with class `refs` (#7969, #526).  Thus, one can include a
    metadata field, say `refs`, whose content is an
    empty div with id `refs`, and the formatted bibliography will be put into
    this metadata field.  It may then be interpolated into a template using the
    variable `refs`.

  * Ensure that you don't get PDF output to terminal.  `-t pdf` now behaves
    like `-t docx` and gives an error unless the output is redirected.

  * `--version` now prints hslua version (#7929) and
    Lua version (#7997, Albert Krewinkel).

  * Change `--metadata-file` parsing so that, when the input format is not
    markdown or a markdown variant, pandoc's markdown is used (#6832, #7926).
    When the input format is a markdown variant, the same format is used.
    Reason for the change: it doesn't make sense to run the markdown parser
    with a set of extensions designed for a non-markdown format, and
    this dramatically limits what people can do in metadata files.

  * Trim whitespace from math in `--webtex` (#7892).
    This fixes problems with --webtex and markdown output,
    when display math starts or ends with a newline.

  * `--self-contained`: issue warning rather than failing with an error
    if a resource can't be found (#7904).

  * New exported module Text.Pandoc.Readers.EndNote, exporting
    `readEndNoteXML` and `readEndNoteXMLCitation` [API change].

  * New exported module, Text.Pandoc.Readers.RIS, exporting `readRIS` (#7894)
    [API change].

  * LaTeX reader:

    + Handle subequations as inline math environment (#7883).
    + Rudimentary support for `vbox` (#7939).
    + Support `\today` (#7905).
    + Handle `\label` and `\ref` for footnotes (#7930).
    + Allow inline groups starting with `\bgroup` (#7953).
    + Use custom TokStream that keeps track of whether macros are expanded.
      This allows us to improve performance a bit by avoiding unnecessary
      runs of the macro expansion code (e.g. from 24 ms to 20 ms on
      our standard benchmark).
    + Further optimizations for inline parsing.
    + Better handling of `\usepackage`.  If the package is local but
      causes parse errors, parse everything up to the error and skip the
      rest.  Issue a `CouldNotParseIncludeFile` warning indicating that
      parsing failed at that point.
    + Text.Pandoc.Readers.LaTeX.Parsing: Monoid and Semigroup instances for
      TokStream.

  * HTML reader:

    + Give warnings and emit empty note when parsing
      `<a epub:type="noteref">` and the identifier
      doesn't correspond to anything in the note table (#7884).
      Previously we just silently skipped these cases.
    + Fix parsing of epub footnotes (#7884).

  * DocBook reader:

    + Handle complete set of entities as specified at
      <https://www.w3.org/2003/entities/2007doc/byalpha.html> (#7938).
    + Handle abstract in info section (#7747).
    + Improve info parsing.
    + Simplify metadata parsing code (#7747).
      Handle abstract as block-level content.
      Report skipped info elements with `--verbose`.
    + Handle address and coyright in metadata (#7747).

  * DokuWiki reader:

    + Add DokuWiki table alignment (#5202, damon-sava-stanley).

  * RST reader:

    + Fix treatment of headerless simple tables (#7902).
    + Wrap math in Span to preserve attributes (#7998, Albert Krewinkel).
      Math elements with a name, classes, or other fields are wrapped in a
      `Span` with these attributes.

  * JATS reader:

    + Improve handling of fn-group elements (#6348, Albert Krewinkel).
      Footnotes in `<fn-group>` elements are collected and re-inserted into
      the document as proper footnotes in the place where they are referenced.
    + Handle `pub-date` (#8000).
    + Support PMID, DOI, issue in citations (#7995).
    + Improve refs parsing.  Handle `issn` and `isbn`; use simpler form
      for issued date.
    + Strip 'ref-' from ref id in constructing CSL id.  This allows better
      round-tripping, because the JATS writer adds the `ref-` prefix to
      the citation id to get the ref element's id.

  * Org reader:

    + Allow ":" in property drawer keys (Lucas V. R).
      Any non-space character is allowed as property drawer key, including ":"
      itself (so it is not really a delimiter). The real delimiter is a space
      character, so in a drawer like
      ```
      :PROPERTIES:
      ::k:ey:: value
      :END:
      ```
      ":k:ey:" is a key with value "value".

    + Allow comments above property drawer.
    + More flexible LaTeX environments (Lucas V. R).
    + Handle `#+bibliography:` as metadata so that it can work with
      `--citeproc`.
    + Parse `#+print_bibliography:` as Div with id `refs`.
    + Allow multiple `#+bibliography:`.

  * Markdown reader:

    + Allow one-column pipe tables with pipe on right (#7919).
    + Remove restriction on identifiers, so they no longer need to
      begin with a letter (#7920).

  * Docx reader:

    + Enable `citations` extension for docx reader (#7840).
      When enabled, Zotero, Mendeley, and EndNote citations embedded in
      a docx are parsed as native pandoc citations.
      (When disabled, the generated citation
      text and bibliography are passed through as regular text.)
      The bibliography generated by the plugin is suppressed.
      Instead, bibliographic data embedded in citation items is added
      to the `references` metadata field so that it can be used
      with `--citeproc`.

  * Docbook writer:

    + Interpret links without contents as cross-references (#7360, Jan Tojnar).
      Links without text contents are converted to `<xref>` elements. DocBook
      processors will generate appropriate cross-reference text when presented
      with an xref element.

  * Docx writer:

    + Single numbering ID for examples (#7895, mjfs).
      This change ensures that example list items all belong to a single
      number sequence, so that if items are added or deleted in a word
      processor, the other items will renumber automatically.
    + Add bookmark with table id to table (#7989, Nikolai
      Korobeinikov, #7285).  This allows tables with ids to be linked to.

  * Ipynb writer:

    + Handle metadata better (#7928).  Previously we used the markdown
      writer to render metadata.  This had some undesirable consequences
      (e.g. en dash expanded to `--` when `smart` enabled), so now we use
      the plain writer.

  * LaTeX writer:

    + Avoid extra space before `\CSLRightInline` (#7932).
    + Add `scrreport` to `chaptersClasses` (#6168, ivardb).
    + Support `page`,`trim`,`clip` attributes on images (#7181).
    + Add `()` after booktabs rules (#8001).  These commands take optional
      arguments with () and [], which can lead to problems if the content
      of the table cell begins with these characters.

  * RST writer:

    + Support all standard metadata ("bibliographic") fields.

  * HTML writer: performance improvements.

  * Org writer:

    + Stop indenting property drawers, quote blocks
      (#3245, Albert Krewinkel).  This follows the current default org-mode
      behavior.

  * Markdown writer:

    + Move table-related code into submodule (Albert Krewinkel).
    + Don't produce redundant header identifier when the
      `gfm_auto_identifiers` extension is set (#7941).
    + Update escaping rules for `\`.  We now escape `\` only if `raw_tex`
      is enabled or it is followed by a non-alphanumeric.

  * JATS writer:

    + Encode author "others" as `<etal/>` (Albert Krewinkel).
      Citeproc adopted the BibTeX convention to use the author name "others"
      when there are additional authors that are not named. JATS uses the
      `<etal>` element for this.
    + Avoid doubled ref-list element (#7990).  Previously when generating JATS
      with the `element_citations` extension enabled, the references were
      put in a doubly-nested ref-list element (`<ref-list><ref-list>...`).
    + Keep edition info in element citations (#7993, Albert Krewinkel).
    + Fix handling of CSL variable 'page' (not 'pages' as we had before).
      It should go to 'lpage' and 'rpage', not 'page-range'.

  * EPUB writer: refactor for clarity (#7991, Jonathan Dönszelmann,
    Ola Wolska, Ivar de Bruin, Jaap de Jong).

  * Custom writer (Albert Krewinkel):

    + Support new-style Writer function (Albert Krewinkel).
      See the documentation for custom writers for details.
    + Produce stacktrace if Writer function fails

  * Text.Pandoc.Logging: add `CouldNotParseIncludeFile` constructor
    for `LogMessage` [API change].

  * Text.Pandoc.Shared:

    + Put id attributes on TOC entries (#7907, damon-sava-stanley).
      Naming scheme of id is "toc-" + id of linked to header/section.
      Effects HTML, Markdown, Powerpoint, and RTF.
    + Define `ordNub` as alias for `nubOrd` from containers package (#7963,
      Albert Krewinkel).
    + Export `ensureValidXmlIdentifiers`.  This function changes identifiers
      that don't start with letters, and internal links to these identifiers,
      making them compatible with XML standards.  The change
      is simple: we add `id_` to the front.  There is potential
      for duplication if there are already `id_...` identifiers
      defined, but this seems rare enough not to worry too much
      about.

  * Ensure that valid XML identifiers are used in Docbook, EPUB, FB2,
    HTML4, S5, Slidy, Slideous, ICML, ODT, TEI writers.
    Thus, if you convert `[anchor]{#1} and [link to](#1)`,
    `id_1` will be used instead of `1` for the identifier.

  * Lua (Albert Krewinkel).

    + Add module `pandoc.layout` to format and layout text.
    + Move custom writer code into Lua hierarchy.
    + Use pandoc-lua-marshal 0.1.5.
    +  Allow any type of callable object as argument to List
       functions `filter`, `map`, and `find_if`. These previously
       required the argument to be of type `function`, which was too
       restrictive.
    + Inline: the type of Image captions is now `Inlines` instead of `List`.
    + Allow passing `Sources` to `pandoc.read` (#8002).

  * Text.Pandoc.PDF:

    + Restore `wkhtmltopdf` as default pdf engine for HTML (Albert Krewinkel).
    + Allow custom writer as format if engine is explicitly specified (#7898,
      Albert Krewinkel).  Note that it may be necessary to explicitly
      specify a template on the command line.

  * Text.Pandoc.MediaBag: improve detection of absolute paths (#7881).

  * Text.Pandoc.Extensions:

    + Remove `raw_tex` extension from list of commonmark extensions, and
      from the `commonmark_x` defaults.  commonmark doesn't parse raw TeX,
      and it doesn't make sense to write it if we don't parse it.
    + Remove `native_divs` from allowed gfm extensions (#7965).  This allows
      `<div>` to be suppressed using `-raw_html`.  Previously `native_divs`
      was enabled but could not be suppressed, because it was not in the
      list of available extensions for commonmark-based formats.

  * Text.Pandoc.Parsing:

    + Partition module into (internal) submodules (#7962, Albert Krewinkel).
    + Unify grid table parsing (#7971, Albert Krewinkel).
      Grid table parsing in Markdown and RST are updated use the same
      functions. Functions are generalized to meet requirements for both
      formats.  This change also lays the ground for further generalizations
      in table parsers, including support for advanced table features.
      [API change] in Text.Pandoc.Parsing:

      - Parse results of functions `tableWith'` and `gridTableWith'` are now a
        `mf TableComponents` instead of a quadruple of alignments, column
        widths, header rows and body rows.
      - Additional exports from Text.Pandoc.Parsing:
        `tableWith'`, `TableComponents`, `TableNormalization`,
        `toTableComponents`, `toTableComponents'`.

  * Text.Pandoc.XML.Light: add versions of the parsers that allow
    specifying a custom entity map.  Exports new functions:
    `parseXMLElementWithEntities`, `parseXMLContentsWithEntities` [API change].

  * Text.Pandoc.Writers.GridTable: improve module documentation (Albert
    Krewinkel).

  * Text.Pandoc.Parsing.GridTable: simplify column handling code (Albert
    Krewinkel).

  * Text.Pandoc.MIME: Add mime type for mkv extension (#7181).

  * Text.Pandoc.Asciify: Fix regression with `ascii_identifiers` and Turkish
    undotted i (#8003).

  * Relax upper bound for hslua, allow hslua-2.2. (#7929)
    Lua 5.4 is used by default after this is merged. Packagers may still
    include Lua 5.3 instead by building pandoc with `--constraint='hslua <2.2'`.
    Differences between 5.3 and 5.4 should not generally affect pandoc Lua
    filters.  See list of incompatible changes here:
    <https://www.lua.org/manual/5.4/manual.html#8.1>

  * JATS template: allow multiple licenses (Albert Krewinkel).

  * LaTeX template:

    + Skip `\babelprovide` if `babel-lang` is empty (#7945) to avoid an error.
    + Move hyperref near end of preamble (#5811).  It now comes after
      header-includes and right before title, author, date, abstract.
      Note:  Users who presuppose hyperref in their header-includes
      will now have to add `\usepackage{hyperref}` to their header-includes
      to make it available there.  (The redundant `\usepackage` will
      do no harm in this case.)
    + Remove special redefinition of `\sout`.  This used to be necessary to
      avoid problems with hyperref, when headings contain strikeout text,
      but it does not seem to be necessary any more (tested).

  * Tests: improve location reporting of failing tests (Albert Krewinkel).

  * Add tests for idempotency of `makeSections` (#7950).

  * Add armhf support in linux build script (#7944, Tony).

  * Use latest pandoc-types, so that toJSONFilter will work with
    Meta and MetaValue.

  * Use latest doclayout, texmath, commonmark, citeproc.

  * INSTALL.md: add reference to install via winget (#7951, Guriy Samarin).

  * MANUAL.txt:

    - Document way to get list in block quote in slide shows (#7916).
    - Minor changes to security section.
    - Note that `smart` works for html input.
    - Fix typos (#7934, Dimitris Apostolou).
    - Fix documentation for citations and org mode.
    - Remove claim that `--self-contained` does not work with `--mathjax`
      (#682).

  * doc/org.md: remove obsolete citations section.
    This mostly described citation formats we no longer support.

  * doc/lua-filters.md: Fix typo (#7981, Mario Lang).

  * Makefile: Use cabal for default build

  * Add `lua53` cabal flag.  It is false by default.  If set to true, compile
    with hslua 2.1 and Lua 5.3, otherwise hslua 2.2 and Lua 5.4.


## pandoc 2.17.1.1 (2022-01-31)

  * Fix regression in 2.17.1 which caused problems finding
    default files in the default user data directory.  (Reverts
    the item "logic bug in `fullDefaultsPath`", which was
    misguided.)

  * Sample custom writer: use single quotes for strings (#7487,
    Albert Krewinkel).

## pandoc 2.17.1 (2022-01-30)

  * Support `pagedjs-cli` as pdf engine (#7838, Albert Krewinkel).
    PagedJS is a polyfill and supports the Paged Media standards by the W3C.
    <https://www.pagedjs.org/>

  * CommonMark reader: fix source position after YAML metadata (#7863).

  * LaTeX reader:

    + Remove retokenizing in `rawLaTeXParser`.
    + Ensure that `\raggedright` doesn't gobble an argument (#7757).
    + Improve `descItem`.  For some reason we were skipping
      arbitrary blocks before `\item`.  This is now changed to "skip
      whitespace and comments."
    + Improve handling of `\newif`.  Adding a pair of braces around the
      second argument of `\def` prevents LaTeX from an emergency stop
      on input like the following (#6096).
      ```
      \newif\ifepub
      \epubtrue
      \ifepub
      hi
      \fi
      ```

  * Docx reader: Parse both Zotero citation and bibliography as
    `FieldInfo` (#7840).

  * LaTeX writer:

    + Allow arbitrary frameoptions to be passed to a beamer
      frame, using the frameoptions attribute (#7869).
    + Add s and squeeze to recognized beamer frameoptions (#7869).

  * Markdown writer: handle explicit column widths with pipe tables (#7847).
    If a table has explicit column width information *and* the content
    extends beyond the `--columns` width, we need to adjust the
    widths of the pipe separators to encode this width information.

  * Docx writer: Separate tables even with RawBlocks between (#7724,
    Michael Hoffmann).  Adjacent docx tables need to be separated by an
    empty paragraph. If there's a RawBlock between tables which renders
    to nothing, be sure to still insert the empty paragraph so that
    they will not collapse together.

  * Man writer: use custom font V for inline code (#7506).
    The V font is defined conditionally, so that it renders
    like CB in output formats that support that, and like B
    in those that don't (e.g. the terminal).
    Aliases also defined for VI, VB, VBI.

  * Asciidoc writer: Support checklists in asciidoctor writer (#7832,
    Nikolai Korobeinikov, ricnorr).  The checklist syntax (similar to
    `task_list` in markdown) seems to be an asciidoctor-only addition.

  * HTML writer:

    + Avoid duplicate "style" attributes on table cells (#7871).
    + Don't break lines inside code elements.  With the new (default)
      line wrapping of HTML, in conjunction with the default CSS which
      includes `code { whitespace: pre-wrap; }`, spurious line
      breaks could be introduced into inline code (#7858).

  * Custom writer: preserve order of element attributes (#7489, Albert
    Krewinkel).  Attribute key-value pairs are marshaled as AttributeList,
    i.e., as a userdata type that behaves both like a list and a map. This
    allows to preserve the order of key-value pairs.

  * Switch to hslua-2.1 (Albert Krewinkel). This allows for some code
    simplification and improves stability.

  * Don't read files outside of user data directory (Even Brenden).
    If a file path does not exist relative to the working directory, and
    it does exist relative to the user data directory, but outside of
    of the user data directory, do not read it. This applies to
    `readDataFile` and `readMetadataFile` in PandocMonad and, by
    extension, any module that uses these by passing them relative paths.

  * Text.Pandoc.Class.`makeCanonical`: Correctly handle consecutive ".."s
    at the beginning of a path (Even Brenden).  Prior to this commit,
    `../../file` would evaluate to `file`, when it should be unchanged.

  * Search for metadata files in `$DATADIR/metadata` (#7851, Even Brenden).
    If files specified with `--metadata-file` are not found in the working
    directory, look in `$DATADIR/metadata` (#5876).

  * Text.Pandoc.Class: export `readMetadataFile` [API change] (#5876).

  * Text.Pandoc.Error: export new `PandocCouldNotFindMetadataFileError`
    constructor for `PandocError` [API change] (#5876).

  * Avoid putting a frame around speaker notes in beamer (#7857).
    If speaker notes (a Div with class 'notes') occur right
    after a section heading, but above slide level, the
    resulting `\note{..}` caommand should not be wrapped in
    a frame, as that will cause a spurious blank slide.

  * CSS in HTML template: adjust #TOC and h1 on mobile (#7835, Mauro Bieg).

  * Text.Pandoc.Readers.LaTeX.Parsing: don't export `totoks`.
    Make the first param of `tokenize` a SourcePos instead of
    SourceName, and use it instead of `totoks`.

  * Text.Pandoc.Shared: Modify `stringify` so it ignores `[Citation]`
    inside `Cite` (#7855).  Otherwise we'll sometimes get two copies of
    things, one from the `citationPrefix` or `citationSuffix` and another
    from the embedded fallback text.  When there is no fallback text,
    we'll get no content.  However, it really isn't an alternative to just
    rely on the result of running `query` on the embedded `Citation`s;
    this will result in a jumble of text rather than anything structured.

  * Omit `--enable-doc` in the cabal haddock invocation in
    `tools/build-and-upload-api-docs.sh`.

  * Text.Pandoc.App.Opt: fix logic bug in `fullDefaultsPath`.
    Previously we would (also) search the default user data directory
    for a defaults file, even if a different user data directory
    was specified using `--data-dir`.  This was a mistake; if
    `--data-dir` is used, the default user data directory should
    not be searched.

  * Text.Pandoc.Shared: `defaultUserDataDir` behavior change (#7842).
    If the XDG data directory is not defined (e.g. because
    it's not supported in the OS or HOME isn't defined), we
    return the empty string instead of raising an exception.

  * Update command tests to distinguish stderr and test exit status.

  * MANUAL: add that speaker notes can be used with beamer (#7856).

  * Update `build-and-upload-api-docs.sh`.

  * Document `--trace` option.
    Document `no-check-certificate` in defaults files.
    Document 'sandbox' option for defaults files.  (#7873).

  * Fix pattern syntax in sample readability custom reader.

  * doc/custom-readers.lua: add example for "readable HTML."

  * Fix message in man page about where code can be found.

  * `manfilter.lua`:  remove extra indent in table cells with code blocks.

  * Fix lua-filters documentation for table column widths (#7864).

  * epub.doc: Update links to KindleGen (#7846, Benson Muite, Mauro Bieg).
    KindleGen has been deprecated and we need to link to archived versions.

  * Use tables in defaults files documentation, so each
    default option is paired with the corresponding command-line
    option (Carsten Allefeld).

  * Use skylighting 0.12.2.

  * Add pandoc-lua-marshal to Nix shell (#7849, Even Brenden).


## pandoc 2.17.0.1 (2022-01-14)

  * Require pandoc-lua-marshal 0.1.3.1 (#7831, Albert Krewinkel).
    Fixes a problem with `List.includes` and `List.find` that caused a
    Lua stackoverflow and subsequent program crash.

  * HTML template: load header-includes before math (#7833, Kolen Cheung).
    MathJax expect the config comes before loading the MathJax script.
    This change of order allows one to config MathJax via
    header-includes, which loads before the MathJax script. Cf. #2750.

  * When reading defaults file, stop at a line `...`.  This line signals
    the end of a YAML document.  This restores the behavior we got with
    HsYaml.  yaml complains about content past this line.  See
    https://github.com/jgm/pandoc/issues/4627#issuecomment-1012438765

  * Text.Pandoc.Citeproc: allow `notes-after-punctuation` to work with
    numerical styles that use superscripts (e.g.
    american-medical-association.csl), as well as with note styles. The
    default setting of `notes-after-punctuation` is true for note styles
    and false otherwise.  This restores a behavior of pandoc-citeproc
    that wasn't properly carried over to Citeproc (#7826, cf.
    jgm/pandoc-citeproc#384).

  * Use commonmark-pandoc 0.2.1.2 (#7769).

  * Add FAQ on images in ipynb containers (#7749, Kolen Cheung).

## pandoc 2.17 (2022-01-12)

  * Support `markua` as an output format (#1871, Tim Wisotzki and
    Saumel Lemmenmeier). Markua is a markdown variant used by Leanpub.

  * Add text wrapping for HTML output (#7764). Previously the HTML writer
    was exceptional in not being sensitive to the `--wrap` option.  With
    this change `--wrap` now works for HTML. The default (as with other
    formats) is automatic wrapping.  Note that the contents of `script`,
    `textarea`, and `pre` tags are always laid out with the `flush`
    combinator, so that unwanted spaces won't be introduced if these occur
    in an indented context in a template.

  * Don't read sources until in/out format are verified (#7797).

  * Issue error with `--list-extensions` for invalid formats (#7797).

  * Make `--citeproc` recognize `.yml` as well as `.yaml` extensions
    as YAML bibliography files (#7707, Jörn Krenzer).

  * Use latest version of KaTeX with `--katex`.

  * Fix parsing of footnotes in `--metadata-file` (#7813).  Previously
    non-inline footnotes were not being parsed.

  * ODT reader:

    + Parse list-header as a list item (Tuong Nguyen Manh).

  * Commonmark reader:

    + Put sourcepos attribute on header, not enclosing div
      with `-f commonmark+sourcepos` (#7769).

  * Markdown reader:

    + Don't allow `^` at beginning of link or image label (#7723).
      This is reserved for footnotes. Fixes regression from 0a93acf.
    + Fix parsing of "bare locators" after author-in-text citations.
      Previously `@item [p. 12; @item2]` was incorrectly parsed as
      three citations rather than two.  This is now fixed by ensuring
      that `prefix` doesn't gobble any semicolons.
    + Revert changes to `inlinesInBalancedBrackets` (commit fa83246),
      which caused regressions.
    + Improve detection of pipe table line widths (#7713).  Fixed
      calculation of maximum column widths in pipe tables.  It is
      now based on the length of the markdown line, rather than a
      "stringified" version of the parsed line.  This should be
      more predictable for users. In addition, we take into account
      double-wide characters such as emojis.

  * Custom (Lua) readers:

    + First argument is now a list of sources instead of the
      concatenated text (Albert Krewinkel).  The list
      structure can easily be converted to a string by applying
      `tostring`, but it is also possible to access the elements
      (each with a `text` and `name`). A small example is added
      to the custom reader documentation, showcasing its use in a
      reader that creates a syntax-highlighted code block for
      each source code file passed as input. Existing readers
      will still work through a fallback mechanism, issuing a
      deprecation notice.

  * Org reader:

    + Parse official org-cite citations (#7329). We also support the older
      org-ref style as a fallback. We no longer support the
      "markdown style" or "Berkeley style" citations.
    + Support alphabetical (fancy) lists (Lucas Viana). When the
      `fancy_lists` extension is enabled, alphabetical list markers are
      allowed, mimicking the behaviour of Org Mode when
      `org-list-allow-alphabetical` is enabled.
    + Support counter cookies in lists (Lucas Viana). Such cookies are
      used to override the item counter in ordered lists. In org it is
      possible to set the counter at any list item, but since Pandoc AST
      does not support this, we restrict the usage to setting an offset for
      the entire ordered list, by using the cookie in the first list item.
    + Allow trailing spaces after key/value pairs in directives (Albert
      Krewinkel). Ensures that spaces at the end of attribute directives like
      `#+ATTR_HTML: :width 100%` (note the trailing spaces) are accepted.

  * LaTeX reader:

    + Omit visible content for `\label{...}`. Previously we
      included the text of the label in square brackets, but this is
      undesirable in many cases. See discussion in
      <https://github.com/jgm/pandoc/issues/813#issuecomment-978232426>.
    + Improve references (#813). Resolve references to theorem environments.
      Remove the Span caused by "label" in figure, table, and theorem
      environments; this had an id that duplicated the environments' id.
    + Fix semantics of `\ref`. We were including the ams
      environment type in addition to the number. This is proper
      behavior for `\cref` but not for `\ref`.  To support `\cref`
      we need to store the environment label separately.
    + Add babel mappings for Guajati (gu) and Oriya (or) (#7815).
    + Fix typo `panjabi` -> `punjabi` in babel mappings (#7814).

  * HTML reader:

    + Parse attributes on links and images (#6970).

 * Docx reader:

    + Handle multiple pic elements inside a drawing (#7786).
    + Change `elemToParPart` to return `[ParPart]` instead of `ParPart`.
      Also remove `NullParPart `constructor, as it is no longer
      needed. This will allow us to handle elements that contain
      multiple ParParts, e.g. `w:drawing` elements with multiple `pic:pic`.

  * DocBook reader:

    + Collapse internal spaces in literal and other similar tags (#7821),
      as the standard docbook toolchain does.
    + Be sensitive to spacing="compact" in lists (#7799). When
      `spacing="compact"` is set, Para elements are turned into Plain,
      so we get a "tight" list.

  * Markdown writer:

    + Add new exported function `writeMarkua` from Text.Pandoc.Writers.Markdown
      [API change] (#1871, Tim Wisotzki and Saumel Lemmenmeier).
    + Fix indentation issue in footnotes (#7801).
    + Avoid extra space before citation suffix if it already starts
      with a space.
    + Ensure semicolon between the locator and the next citation when an
      author-in-text citation has a locator and following citations.
    + Improve escaping for `#` (#7726).

  * Custom (Lua) writers:

    + Allow variables to be set via second return value of `Doc`
      (#6731, Albert Krewinkel). New templates variables can be added by
      giving variable-value pairs as a second return value of the
      global function `Doc`. Example:
      ```
      function Doc (body, meta, vars)
        vars.date = vars.date or os.date '%B %e, %Y'
        return body, vars
      end
      ```
    + Provide global `PANDOC_WRITER_OPTIONS` (#6731, Albert Krewinkel).
    + Assign default Pandoc object to global `PANDOC_DOCUMENT` (Albert
      Krewinkel). The default Pandoc object is now non-strict, i.e., only
      the parts of the document that are accessed will be marshaled to Lua.
      A special type is no longer necessary. This change also makes it
      possible to use the global variable with library functions such as
      `pandoc.utils.references`, or to inspect the document contents with
      `walk()`.

  * LaTeX writer:

    + Fix typo `panjabi` -> `punjabi` in babel mappings (#7814).

  * MediaWiki writer:

    + Remove redundant display text for wiki links (Jesse Hathaway).

  * Docx writer:

    + Handle bullets correctly in lists by not reusing numIds
      (#7689, Michael Hoffmann).  This fixes a bug in which a Div in
      a list item would receive bullets on its contained paragraphs.

  * Org writer:

    + Fix list items starting with a code block or other non-paragraph
      content (#7810).
    + Avoid blank lines after tight sublists (#7810).
    + Fix extra blank line inserted after empty list item (#7810).
    + Don't add blank line before lists (#7810).
    + Support starting number cookies (Lucas Viana).  This is necessary
      for lists that start at a number other than 1.
    + Support the new org-cite syntax (#7329).

  * Haddock writer:

    + Avoid blank lines after tight sublists (#7810).

  * Ipynb writer:

    + Ensure deterministic order of keys.
    + Handle cell output with raw block of markdown (#7563, Kolen Cheung).
      Write RawBlock of markdown in code-cell output. This is designed
      to fit the behavior of #7561, which makes the ipynb reader parse
      code-cell output with mime "text/markdown" to a RawBlock of markdown.
      This commit makes the ipynb writer writes this RawBlock of markdown
      back inside a code-cell output with the same mime, preserving this
      information in round-trip.
    + In choosing between multiple output options, always favor
      those marked with the output format over images (Kolen Cheung).
      Previously, both `fmt == f` case and Image have a rank of 1.

  * Ipynb reader & writer: properly handle cell "id" (#7728).
    This is passed through if it exists (in Nb4); otherwise
    the writer will add a random one so that all cells have an "id".

  * Ms writer:

    + Properly encode strings for PDF contents (#7731).

  * JATS writer:

    + Keep quotes in element-citations (Albert Krewinkel).
      Fixed a bug that lead to quote characters being lost in
      element-citations.

  * RTF writer:

    + Properly handle images in data URIs (#7771).

  * Commonmark writer:

    + Allow ')' delimiters on ordered lists.

  * RST writer:

    + Avoid extra blank line after empty list item (#7810).

  * HTML writer:

    + Make line breaks more consistent. With `--wrap=none`, we now
      output line breaks between block-level elements. Previously they
      were omitted entirely, so the whole document was on one line, unless
      there were literal line breaks in pre sections.  This makes
      the HTML writer's behavior more consistent with that of
      other writers. Also, regardless of wrap settings,
      put newline after `<dd>` and after block-level elements in
      the footnotes section. And add a line break between an `img` tag
      and the associated `figcaption`.
    + reveal.js: Make sure images with `r-stretch` are not in p tags.
      They must be direct children of the section. There was previously
      code to make this work with the older class name `stretch`, but
      the name has changed in reveal.js.
    + reveal.js:  don't add `r-fit-text` class to section. It must go on
      the header only.

  * AsciiDoc writer:

    + Improve detection of intraword emphasis (#7803).

  * OpenDocument writer:

    + Fix vertical alignment bug with display math (#7777).  Previously some
      displayed formulas would be floated above a preceding text line.
      This is fixed by setting `vertical-rel` to `text` rather than
      `paragraph-content`.

  * JATS template (Albert Krewinkel):

    + Fix position of contrib affiliations in authoring set. Any
      `<aff>` element must come before any `<email>` element.
    + Fix affiliation tagging in `articleauthoring` output.
      Affiliations were `xlink`ed even in the articleauthoring tag set, but
      `<aff>` are not allowed as children of `contrib-group` elements in that
      tag set. Each affiliation must be listed directly in the contrib
      element.
    + Add support for article subtitles.

  * EPUB template:

    + Include abstract in default template.
    + Ensure that the essential styles needed by pandoc (`styles.html`
      partial) are included in the templates. This is important for correct
      formatting of CSL bibliographies. Note that much of the styling in
      `styles.html` will be ignored for EPUB, because of the conditional on
      `document-css`.  Setting the `document-css` variable will cause it
      not to be ignored.

  * HTML template:  Add abstract (#7588, Jannik Buhr, John MacFarlane).
    By default, a localized title (the word "Abstract") will be
    used, unless the variable `abstract-title` is set.

  * ConTeXt template:  Make title appear in PDF title bar.  This is
    recommended for accessibility reasons.  Note: doesn't work with macOS
    Preview.app.

  * `reference.pptx`: change to use 16:9 aspect ratio, Powerpoint's default.

  * Text.Pandoc.Writers:

    + Do not export `writeCustom` [API change]. This ensures that all
      writers exported in T.P.Writers are parameterized and work with any
      `PandocMonad` type. This is consistent with T.P.Readers, as
      `readCustom` is not exported from that module either.

  * Text.Pandoc.Writers.Shared:

    + `endsWithPlain` now returns True if the list ends with a list
      that ends with a Plain, and so on recursively (#7810).

  * Text.Pandoc.Class.IO:

    + `writeMedia`:  unescape percent-encoding in creating file path.
      This addresses a problem with spaces in image filenames
      when creating PDFs (#7819); it also affects `--extract-media`.

  * New internal module Text.Pandoc.Writers.Blaze, exporting `layoutMarkup`.
    This converts a blaze Html structure into a doclayout Doc Text.

  * Text.Pandoc.Extensions:

    + `parseFormatSpec`: cleaner error message for invalid extensions.

  * Text.Pandoc.MediaBag:

    + Fix bug in `extractMedia`, which caused the test for `..`
      in paths to fail, with the result that images with `..`
      in the path name could be extracted outside of the
      directory specified by `extractMedia`. It also led a check for
      `media` in resource paths to fail in the docx reader.

  * Text.Pandoc.Citeproc:

    + Avoid adding comma before an author-in-text citation in a note
      if it begins with a title (no author) (#7761).
    + Text.Pandoc.Citeproc.Locator now exports `toLocatorMap`,
      `LocatorInfo`, and `LocatorMap`.  The type of `parseLocator`
      has changed, so it now takes a `LocatorMap` rather than a `Locale`
      as parameter, and returns a `LocatorInfo` instead of a tuple.
    + Fix citation locator detection for German.  `toLocatorMap` now
      stores keys case-folded. We want to do a case-insensitive
      comparison when parsing locators, so that e.g. both
      `Chap.` and `chap.` work. Previously we case-folded terms
      when doing the lookup, but they weren't case-folded in the
      map itself, which led to locator-detection breaking for
      German (where the terms have uppercase letters).

  * Lua (Albert Krewinkel):

    + Allow single elements as singleton MetaBlocks/MetaInlines. Single
      elements should always be treated as singleton lists in the Lua
      subsystem.
    + Add `pandoc.template` module. The module provides a `compile`
      function to use strings as templates.
    + Add `pandoc.WriterOptions` constructor.
    + Add function `pandoc.write`.
    + Provide global `PANDOC_WRITER_OPTIONS` (#5221).
    + The function Text.Pandoc.Filter.applyFilters now takes a filter
      environment of type `Environment`, instead of a ReaderOptions value
      [API change].
    + The `Environment` type is exported from Text.Pandoc.Filter
      and allows to combine ReaderOptions and WriterOptions in a single
      value [API change].
    + Global, exported from Text.Pandoc.Lua, has a new type constructor
      `PANDOC_WRITER_OPTIONS` [API change].
    + Add constructors `pandoc.Blocks` and `pandoc.Inlines`.
      The functions convert their argument into a list of Block and Inline
      values, respectively. When applied to a string, they split the
      string into `Str` elements separated by `Space` or `SoftBreak`
      (#7712).
    + Support topdown traversals The traversal order of filters can now
      be selected by setting the key `traverse` of the filter to either
      `'topdown'` or `'typewise'`; the default remains `'typewise'`.
      Topdown traversals can be cut short by returning `false` as a
      second value from the filter function. No child-element of the
      returned element is processed in that case.
    + Marshal ReaderOptions field `extensions`, `track_changes` via JSON.
      Extensions are now available as a list of strings; the track-changes
      settings are given as the kebab-case representation used in JSON.
    + Allow binary (byte string) readers to be used with `pandoc.read`.
    + Use global state when parsing documents in `pandoc.read`.
      The function `pandoc.read` is updated to use the same state that was
      used while parsing the main input files. This ensures that log
      messages are preserved and that images embedded in the input are
      added to the mediabag.
    + Cleanup stack in `peekReadOptionsTable`. A ReaderOptions element was
      left on top of the stack when the `peekReadOptionsTable` function
      was invoked.
    + `walk` methods are added to `Pandoc`, `Block`, `Inline`,
      `Blocks`, `Inlines` values; the methods are similar to
      `pandoc.utils.walk_block` and `pandoc.utils.walk_inline`, but
      apply to filter to the element's contents.
    + Functions of name `Doc` are no longer accepted as alternatives for
      `Pandoc` filter functions. This functionality was undocumented.
    + Improve handling of empty caption, body by `from_simple_table`
      #7776). Create truly empty table caption and body when these are
      empty in the simple table.
    + Change representation of `TableHead`, `TableFoot`, and `Row` values
      (#7718).  The objects now also follow the principle that element
      attributes are accessible through the `.attr` field. Rows in `TableHead`
      and `TableFoot` are available via the `.rows` field. Row objects have a
      `.cells` field, containing the list of table cells.
    + [Simplify](Simplify) code of `pandoc.utils.stringify`. Minor behavior change:
      plain strings nested in tables are now included in the result string.
    + Simplify and deprecate function `pandoc.utils.equals`. The function
      is no longer required for element comparisons; it is now an alias
      for the `==` operator.
    + Add function `pandoc.utils.references` (#7752).
    + Add new library function `pandoc.utils.type`.  The function behaves
      like the default `type` function from Lua's standard library,
      but is aware of pandoc userdata types. A typical use-case would be
      to determine the type of a metadata value.
    + Fix return types of `blocks_to_inlines`, `make_sections`.
      Ensures the returned lists have the correct type (`Inlines` and
      `Blocks`, respectively).
    + Use more natural representation for Reference values
      Omit `false` boolean values, push integers as numbers.

  * Lua: use package pandoc-lua-marshal (#7719, Albert Krewinkel).
    The marshaling functions for pandoc's AST are extracted into a separate
    package. The package comes with a number of changes:

    + Pandoc's List module was rewritten in C, and error messages were
      improved.
    + Lists of `Block` and `Inline` elements are marshaled using the new
      list types `Blocks` and `Inlines`, respectively. These types
      currently behave identical to the generic List type, but give better
      error messages. This also opens up the possibility of adding
      element-specific methods to these lists in the future.
    + Elements of type `MetaValue` are no longer pushed as values which
      have `.t` and `.tag` properties. This was already true for
      `MetaString` and `MetaBool` values, which are still marshaled as Lua
      strings and booleans, respectively. Affected values:
      - `MetaBlocks` values are marshaled as a `Blocks` list;
      - `MetaInlines` values are marshaled as a `Inlines` list;
      - `MetaList` values are marshaled as a generic pandoc `List`s.
      - `MetaMap` values are marshaled as plain tables and no longer
        given any metatable.
    + `Cell` values are now marshaled as userdata objects; a constructor
      function for table cells is provided as `pandoc.Cell`.
    + The test suite for marshaled objects and their constructors has
      been extended and improved.
    + A bug in `Citation` objects, where setting a citation's suffix
      modified it's prefix, has been fixed.
    + Inlines, Blocks, and List objects now have an `__eq` metamethod,
      testing equality by comparing two lists element-wise.

  * Powerpoint tests: shorten lines by grouping tests (Albert
    Krewinkel). This makes the test output more pleasant to read
    in narrow terminal windows.

  * make check: check for unreleased dependencies.

  * Add `tools/build-and-upload-api-docs.sh`.

  * Update cabal description.

  * `MANUAL.txt`: Add section on EPUB styling.

  * `MANUAL.txt`: clarify "standard Markdown" as "original Markdown"
    (#7802, Martin Fischer).

  * `doc/custom-writers.md`: use filter to include source of example.

  * Add an example to `doc/custom-readers.md`.

  * Fix typo in `custom-readers.md` (#7722, Mauro Bieg).

  * `doc/jats.md`: add link to JATS documentation (Martin Fischer).

  * `doc/lua-filters.md`: many improvements (Albert Krewinkel,
    John MacFarlane).

  * Use commonmark-extensions 0.2.3. This allows a bare-word class attribute
    on fenced divs.

  * Use ipynb 0.2.

  * Use citeproc 0.6.0.1.

  * Use texmath 0.12.4.

  * Use doctemplates 0.10.0.1.

## pandoc 2.16.2 (2021-11-21)

  * Add interface for custom readers written in Lua (#7669).
    Users can now do `-f myreader.lua` and pandoc will treat the
    script `myreader.lua` as a custom reader, which parses an input
    string to a pandoc AST, using the pandoc module defined for
    Lua filters.  A sample custom reader can be found in `data/creole.lua`.
    Also see documentation in `doc/custom-readers.md`.

  * New module Text.Pandoc.Readers.Custom, exporting `readCustom` [API change].

  * Allow `plain` to be used in raw attribute syntax.

  * Accept empty `--metadata-file` (#7675).
    This was a regression from 2.15 behavior.

  * Markdown reader: Improve `inlinesInBalancedBrackets`.
    This is just a small improvement in terms of performance, but it's simpler
    and more direct code.  Also, we avoid parsing interparagraph spaces in
    balanced brackets, as the original did.

  * BibTeX reader: Properly handle commented lines in BibTeX/BibLaTeX (#7668).

  * RST reader: handle class attribute for for custom roles (#7699,
    willj-dev).  Previously the class attribute was ignored, and the name
    of the role used as the class.

  * DocBook reader:

    + Add `<titleabbr>` support (Rowan Rodrik van der Molen).
    + Support for `<indexterm>` (#7607, Rowan Rodrik van der Molen).

  * LaTeX reader:

    + Add rudimentary support for `\autoref` (#7693).
    + Add 'uri' class when parsing `\url`, for consistency
      with treatment of autolinks in other formats (#7672).

  * JATS reader: Capture `alt-text` in figures (#7703, Aner Lucero).

  * MediaWiki writer: use HTML spans for anchors when header has id (#7697).
    We need to generate a span when the header's ID doesn't match
    the one MediaWiki would generate automatically.  Note that MediaWiki's
    generation scheme is different from pandoc's (it uses uppercase letters,
    and `_` instead of `-`, for example).  This means that in going from
    markdown to mediawiki, we'll now get spans before almost every heading,
    unless explicit identifiers are used that correspond to the ones MediaWiki
    auto-generates.  This is uglier output but it's necessary for internal
    links to work properly.

  * Markdown writer: don't create autolinks when this loses information
    (#7692).  Previously we sometimes lost attributes when rendering links
    as autolinks.

  * Text.Pandoc.Readers.Metadata: allow multiple YAML documents when parsing
    YAML for `yamlBsToRefs`.  Some people use `---` as the end delimiter in
    YAML bibliography files, which causes the `yaml` library to emit an
    error unless we explicitly allow multiple YAML documents (and just
    consider the first).

  * JATS writer:

    + Ensure figures are wrapped with `<p>` in list items
      (Albert Krewinkel).  This prevents the generation of invalid output.
    + Add URL to element citation entries (Albert Krewinkel).
      The URL of a reference, if present, is added in tag `<uri>` to
      element-citation entries.

  * HTML writer: Don't create invalid `data-` attribute for empty
    attribute key (#7546).

  * LaTeX writer:

    + Babel mappings: use `ancientgreek` for `grc`.
    + With `-t latex-smart`, don't generate `\ldots` from ellipsis (#7674).
      Instead just use unicode ellipsis.

  * JATS template: fix `equal-contrib` attribute (Albert Krewinkel).
    The standard requires the value to be either `yes` or `no`, but is was
    set to `true` for authors who contributed equally.

  * reveal.js template: Add `disableLayout` variable (Christophe Dervieux).

  * Text.Pandoc.Error: sort errors in `handleError` by exit code
    (Albert Krewinkel).

  * Text.Pandoc.Writers.Shared: Improve toLegacyTable (#7683,
    Christian Despres).

  * Lua subsystem:

    + Include lpeg module (#7649, Albert Krewinkel).  Compiles the `lpeg`
      library (Parsing Expression Grammars For Lua) into
      the program.  Package maintainers may choose to rely on package
      dependencies to make lpeg available, in which case they can compile
      the with the constraint `lpeg +rely-on-shared-lpeg-library`.
      `lpeg` and `re` are always made available in global variables,
      without the need for a `require`.

    + Set `lpeg` and `re` as globals; allow shared lib access via `require`.
      The `lpeg` and `re` modules are loaded into globals of the respective
      name, but they are not necessarily registered as loaded packages. This
      ensures that

      - the built-in library versions are preferred when setting the globals,
      - a shared library is used if pandoc has been compiled without `lpeg`,
        and
      - the `require` mechanism can be used to load the shared library if
        available, falling back to the internal version if possible and
        necessary.

    + Fix argument order in constructor `pandoc.Cite` (Albert Krewinkel).
      This restores the old behavior; argument order had been switched
      accidentally in pandoc 2.15.

    + Add Pushable instance for `ReaderOptions` (Albert Krewinkel).

    + Allow to pass custom reader options to `pandoc.read` as an
      optional third argument (#7656, Albert Krewinkel).
      The object can either be a table or a ReaderOptions value
      like `PANDOC_READER_OPTIONS`. Creating new ReaderOptions objects is
      possible through the new constructor `pandoc.ReaderOptions`.

    + Display Pandoc values using their native Haskell representation
      (Albert Krewinkel).

    + Require latest hslua (2.0.1) (#7661, #7657, Albert Krewinkel).
      This fixes issues with

      - misleading error messages when a required function parameter is
        omitted;
      - absent properties still being listed in the output of `pairs`; and
      - alias accessing leading to errors instead of returning `nil`, e.g.
        with `(pandoc.Str '').identifier`.

    + Add missing space in "package not found" message (#7658, Albert
      Krewinkel).

  * Update build files (#7696, Fabián Heredia Montiel).
    Drop old windows 32-bit constraints.
    Update cabal `tested-with` field to correspond to `ci.yml` matrix

  * Remove unneeded package dependencies from benchmark target.

  * Require ghc >= 8.6, base >= 4.12.
    This allows us to get rid of the old custom prelude and
    some crufty cpp.  But the primary reason for this is that
    conduit has bumped its base lower bound to 4.12, making it
    impossible for us to support lower base versions.

  * Require Cabal 2.4.  Use wildcards to ensure that all pptx tests are
    included (#7677).

  * Update `bash_completion.tpl` (S.P.H.).

  * Add `data/creole.lua` as sample custom reader.

  * Add `doc/custom-readers.md` and `doc/custom-writers.md`.

  * `doc/lua-filters.md`: add section on global modules, including lpeg
    (Albert Krewinkel).

  * `MANUAL.txt`: update table of exit codes and corresponding errors
    (Albert Krewinkel).

  * Use latest texmath.

## pandoc 2.16.1 (2021-11-02)


  * Docx reader:  don't let first line indents trigger block quotes (#7655).
    This fixes a regression introduced in pandoc 2.15.

  * Docx writer: use `getTimestamp` for modification times in
    reference.docx (#7654).  This ensures that when `SOURCE_DATE_EPOCH` is
    set, the modification times of files taken from the reference.docx will
    be set deterministically, allowing for reproducible builds.

  * Lua subsystem (Albert Krewinkel):

    + Load module `pandoc.path` on startup (#7524).  Previously the module
      always had to be loaded via `require 'pandoc.path'`.
    + Fix typo in SoftBreak constructor.
    + Re-add `content` property to Strikeout elements.
      Fixes a regression introduced in 2.15.
    + Be more forgiving when retrieving the Image `caption` property.
      Fixes a regression introduced in 2.15.
    + Display Attr values using their native Haskell representation.
    + Allow omitting the 2nd parameter in pandoc.Code constructor.
      Fixes a regression introduced in 2.15 which required users to always
      specify an Attr value when constructing a Code element.
    + Allow to compare, show Citation values.  Comparisons of Citation
      values are performed in Haskell; values are equal if they represent
      the same Haskell value. Converting a Citation value to a string
      now yields its native Haskell string representation.
    + Restore List behavior of MetaList (#7650).  Fixes a regression
      introduced in 2.16 which had MetaList elements lose
      the `pandoc.List` properties.
    + Restore `content` property on Header elements.
    + Ensure Block elements have all expected properties.
    + Ensure Inline elements have all expected properties.

  * Allow tasty-bench 0.3.x.

## pandoc 2.16 (2021-10-31)

  * Switch back from HsYAML to yaml for parsing YAML metadata (#6084).
    HsYAML is around 20 times slower in parsing large YAML bibliographies.
    In addition, HsYAML is not being actively maintained.  This sets us back
    in our attempts to free ourselves from C dependencies (#4535).  But I
    don't see a good alternative until a faster pure Haskell parser is available.
    Notes:

    + We've removed the FromYAML instances for all types that had them, since
      this is a HsYAML-specific typeclass [API change].  (The yaml package just
      uses From/ToJSON instead of having a dedicated From/ToYAML class.)
    + Unlike HsYAML (in the configuration we were using), yaml parses 'Y', 'N',
      'Yes', 'No', 'On', 'Off' as boolean values.  Users may need to quote these
      when they are meant to be interpreted as strings.  Similarly, 'null' is
      parsed as a YAML null value (and will be treated as an empty string by
      pandoc rather than the string 'null').  Quoting it will force it to be
      interpreted as a string.
    + Some tests had to be adjusted accordingly.
    + Pandoc now behaves in a more useful way when the YAML metadata contains
      escaping errors: instead of just failng silently and falling back to
      some other interpretation of the section, it raises a YAML parsing error.

  * Markdown writer: Ensure that special values are quoted in YAML metadata.
    These include "Y", "yes", "on", and "off", which are now (with yaml library)
    considered boolean values, as well as "null".

  * Change JSON encodings of some types.

    + For LineEnding use lowercase constructors, e.g. `crlf`, `native`.
    + For HTMLSlideVariant use lowercase constructors.
    + For ReaderOptions use e.g. `default-image-extension`
      instead of `readerDefaultImageExtension` for field names.
    + For Extension, use e.g. `tex_math_dollars` instead of
      `Ext_tex_math_dollars` as constructor.
    + For Extensions, use an array of Extensions, instead of
      an object wrapping the tag `Extensions` and an integer.
      (The integer representation is not supposed to be part of the
      public API.)
    + For Opt, use field names like `tab-stop` instead of `optTabStop`.

  * Docx writer:

    + Add IDs to native_numbering test (Tristan Stenner).
    + Move ": " out of the caption bookmark (Tristan Stenner).
      This is needed so that native references to the figure are included as
      "As seen in Figure X, it is..." instead of "As seen in [Figure: X, it is..."

  * Lua (Albert Krewinkel, except as noted):

    + Use hslua module abstraction where possible.
    + Fix placement of tests for Block elements in pandoc module tests
    + Increase strictness when getting attribute keys
    + Re-add `t` and `tag` property to Attr values.
      Removal of these properties from Attr values was a regression.
    + Fix `pandoc.utils.stringify` regression.  The `pandoc.utils.stringify`
      function returned empty strings when called with a string argument.
    + Fix a copy/paste bug in Lua marshalling code (John MacFarlane, #7639).
      This caused links to be changed to figures when Lua filters changed
      link properties.
    + Re-add `content` property to Link elements (#7647).
      This was a regression introduced in version 2.15.
    + Generate constants in module pandoc programmatically.
    + Marshal SimpleTable, ListAttributes, Citation, and Block values as
      userdata objects.  Properties of Block values are marshalled lazily,
      which generally improves performance considerably. Script users may also
      notice the following differences:

      - Block element properties can no longer be accessed by numerical
        indexing of the `.c` field. The `.c` property now serves as an alias
        for `.content`, so some filter that used this undocumented method
        for property access may continue to work, while others will need to
        be updated and use proper property names.
      - The marshalled Block elements now have a `show` method, and a
        `__tostring` metamethod. Both return the Haskell string
        representation of the element.
      - Block values now have the Lua type `userdata` instead of `table`.

  * Add a short guide to pandoc's sources (Albert Krewinkel).

  * Fix epub files in epub reader tests, so that they are valid
    according to epubcheck (#7586).

  * Allow time 1.13.

  * Require latest skylighting (0.12.1).

  * Fix build on GHC 9.2 (Joseph C. Sible).

  * Fix trypandoc so it builds with aeson > 2.


## pandoc 2.15 (2021-10-23)

  * Add `--sandbox` option  (#5045).

    + Add sandbox feature.  When this option is used, readers and writers
      only have access to input files (and other files specified directly on
      command line).  This restriction is enforced in the type system.
    + Filters, PDF production, custom writers are unaffected.  This
      feature only insulates the actual readers and writers, not
      the pipeline around them in Text.Pandoc.App.
    + Note that when `--sandboxed` is specified, readers won't have
      access to the resource path, nor will anything have access to
      the user data directory.

  * `--self-contained`: Fix bug that caused everything to be made a data
    URI (#7635, #7367).  We only need to use data URIs in certain cases, but
    due to a bug they were being used always.

  * Pandoc will now fall back to latin1 encoding for inputs that can't be
    read as UTF-8.  This is what it did previously for content fetched
    from the web and not marked as to content type. It makes sense to do
    the same for local files.  In this case a `NotUTF8Encoded` warning
    will be issued, indicating that pandoc is interpreting the input as latin1.

  * Markdown reader:

    + Don't parse links or bracketed spans as citations (#7632).
      Previously pandoc would parse `[link to (@a)](url)` as a
      citation; similarly `[(@a)]{#ident}`.  This is undesirable.  One should
      be able to use example references in citations, and even if `@a` is
      not defined as an example reference, `[@a](url)` should be a link
      containing an author-in-text citation rather than a normal citation
      followed by literal `(url)`.
    + Fix interaction of `--strip-comments` and list parsing (#7521).
      Use of `--strip-comments` was causing tight lists to be rendered as
      loose (as if the comment were a blank line).
    + Fix parsing bug for math in bracketed spans and links (#7623).
      This affects math with unbalanced brackets (e.g. `$(0,1]$`)
      inside links, images, bracketed spans.
    + Fix code blocks using `--preserve-tabs` (#7573).  Previously they
      did not behave as the equivalent input with spaces would.

  * DocBook reader:

    + Honor linenumbering attribute (Samuel Tardieu).
    The attribute DocBook `linenumbering="numbered"` on code blocks
    maps to the `numberLines` class internally.

  * LaTeX reader:

    + Implement siunitx v3 commands (#7614).
      We support `\unit`, `\qty`, `\qtyrange`, and `\qtylist`
      as synonyms of `\si`, `\SI`, `\SIrange`, and `\SIlist`.
    + Properly handle `\^` followed by group closing (#7615).
    + Recognize that `\vadjust` sometimes takes "pre" (#7531).
    + Ignore (and gobble parameters of) CSLReferences environment (#7531).
      Otherwise we get the parameters as numbers in the output.
    + Restrict `\endinput` to current file (Simun Schuster).

  * RST reader: handle escaped colons in reference definitions (#7568).

  * HTML reader:

    + Handle empty tbody element in table (#7589).

  * Ipynb reader (Kolen Cheung):

    + Get cell output mime from `raw_mimetype` in addition to `format`.
      (`format` is what the spec calls for, but `raw_mimetype` is
      often used in practice; see jupyter/nbformat#229).
    + Add more formats that can be handled as "raw" cells.
    + Fix mime type for `rst`.
    + Support `text/markdown`, which is now a supported mime type for raw
      output (#7561).

  * RTF reader:

    + Support `\binN` for binary image data.
    + If doc begins with {\rtf1 ... } only parse its contents.
      Some documents seem to have non-RTF (e.g. XML) material after the
      `{\rtf1 ... }` group.
    + Ignore `\pgdsc` group.  Otherwise we get style names treated as test.
    + Better handling of `\*` and bookmarks.  We now ensure that groups
      starting with `\*` never cause text to be added to the document.
      In addition, bookmarks now create a span between the start
      and end of the bookmark, rather than an empty span.

  * Docx reader:

    + Avoid blockquote when parent style has more indent (Milan Bracke).
      When a paragraph has an indentation different from the parent (named)
      style, it used to be considered a blockquote. But this only makes sense
      when the paragraph has more indentation. So this commit adds a check
      for the indentation of the parent style.
    + Fix handling of empty fields (Milan Bracke).  Some fields only
      have an `instrText` and no content, Pandoc didn't understand these,
      causing other fields to be misunderstood because it seemed like
      a field was still open when it wasn't.
    + Implement PAGEREF fields (Milan Bracke).  These fields, often used
      in tables of contents, can be a hyperlink.
    + Fix handling of nested fields (Milan Bracke).  Fields delimited by
      `fldChar` elements can contain other fields. Before, the nested
      fields would be ignored, except for the end, which would be
      considered the end of the parent field.
    + Add placeholder for word diagram instead of just omitting it (Ezwal).

  * Org reader:

    + Don't parse a list as first item in a list item (#7557).
    + Allow an initial `:PROPERTIES:` drawer to add to metadata (#7520).

  * Docx writer:

    + Make id used in `native_numbering` predictable (#7551).
    If the image has the id IMAGEID, then we use the id ref_IMAGEID
    for the figure number.  This allows one to create a filter that
    adds a figure number with figure name, e.g.
    `<w:fldSimple w:instr=" REF ref_superfig "><w:r><w:t>Figure X</w:t>
    </w:r></w:fldSimple>`.
    If an image lack an id, an id of the form `ref_fig1` is used.
  + Ensure we have unique ids for `wp:docPr` and `pic:cNvPr` elements
    (#7527, #7503).
  + Handle SVG images (#4058).  This change has several parts:
    - In Text.Pandoc.App, if the writer is docx, we fill the media
      bag and attempt to convert any SVG images to PNG, adding these
      to the media bag.  The PNG backups have the same filenames as
      the SVG images, but with an added .png extension.  If the conversion
      cannot be done (e.g. because rsvg-convert is not present),
      a warning is omitted.
    - In Text.Pandoc.Writers.Docx, we now use Word 2016's syntax for
      including SVG images. If a PNG fallback is present in the media bag,
      we include a link to that too.

  * Powerpoint writer (Emily Bourke):

    + Add support for more layouts (#5097).  Up til now, four layouts
      were supported: "Title Slide" (used for the automatically generated
      metadata slide), "Section Header" (used for headings above slide
      level), "Two Column" (used when there's a columns div), "Title and
      Content" (used for all other slides).  We now support three
      additional layouts: "Comparison", "Content with Caption", and
      "Blank".  The manual describes the logic that determines which
      layout is used for a slide.  Layouts may be customized in the
      reference doc.
    + Support specifying slide background images using a `background-image`
      attribute on the slide's heading.  Only the "stretch" mode is supported,
      and the background image is centred around the slide in the image's
      larger axis, matching the observed default behaviour of PowerPoint.
    + Add support for incremental lists (through same methods as in
      other slide writers) (#5689).
    + Copy embedded fonts from reference doc.
    + Include all themes in output archive.
    + Fix list level numbering (#4828, #4663).  In PowerPoint,
      the content of a top-level list is at the same level as the content
      of a top-level paragraph: the only difference is that a list style
      has been applied.  Previously, the writer incremented the paragrap
      h level on each list, turning what should be top-level lists into
      second-level lists.
    + Line up list continuation paragraphs.  This commit
      changes the `marL` and `indent` values used for plain paragraphs
      and numbered lists, and changes the spacing defined in the
      reference doc master for bulleted lists.  For paragraphs, there is
      now a left-indent taken from the `otherStyle` in the master.
      For numbered lists, the number is positioned where the text would be
      if this were a plain paragraph, and the text is indented to the next
      level. This means that continuation paragraphs line up nicely with
      numbered lists.  Existing reference docs may need to be modified so
      that `otherStyle` and `bodyStyle` indent levels match, for this
      feature to work with them.
    + Consolidate text runs when possible (jgm).  This slims down the output
      files by avoiding unnecessary text run elements.
    + Support footers in the reference doc.
      There is one behaviour which may not be immediately obvious: if the
      reference doc specifies a fixed date (i.e. not automatically updating),
      and there’s a date specified in the metadata for the document, the
      footer date is replaced by the metadata date.
    + Fix presentation rel numbering.  Before now, the numbering of `rId`s
      was inconsistent when making the presentation XML and when making
      the presentation relationships XML.
    + Don’t add relationships unnecessarily.  Before now, for any layouts
      added to the output from the default reference doc, the relationships
      were unconditionally added to the output. However, if there was already
      a layout in slideMaster1 at the same index then that results in
      duplicate relationships.
    + If slide level is 0, don't insert a slide break between a heading
      and a following table, "columns" div, or paragraph starting
      with an image.
    + Fix capitalisation of `notesMasterId`.
    + Restructure tests.

  * Asciidoc writer:

    + Translate numberLines attribute to `linesnum` switch (Samuel Tardieu).
    + Improve escaping for `--` in URLs (#7529).

  * LaTeX writer:

    + Make babel use more idiomatic (#7604, hseg).  Use babel's
      bidi implementation.  Import babel languages individually instead
      of as package options.  Move `header-includes` to after
      `babel` setup so it can be modified.
    + Use babel, not polyglossia, with xelatex.  Previously polyglossia
      worked better with xelatex, but that is no longer the case, so
      we simplify the code so that babel is used with all latex
      engines.  This involves a change to the default LaTeX template.

  * Markdown writer:

    + Avoid bad wraps at the Doc Text level.  Previously we tried to
      do this at the Inline list level, but it makes more sense to
      intervene on breaking spaces at the Doc Text level.
    + Use `underline` class rather than `ul` for underline.
      This only affects output with `bracketed_spans` enabled.
      The markdown reader parses spans with either `.ul` or `.underline` as
      Underline elements, but we're moving towards preferring the latter.

  * RST writer:

    + Properly handle anchors to ids with spaces or leading underscore
      (#7593).  In this cases we need the quoted form, e.g.
      ```
      .. _`foo bar`:

      .. _`_foo`:
      ```
      Side note: rST will "normalize" these identifiers anyway,
      ignoring the underscore.

  * HTML writer:

    + Render `\ref` and `\eqref` as inline math, not display (see #7589).
    + Pass through `\ref` and `\eqref` if MathJax is used (#7587).
    + Pass through inline math environments with KaTeX.
    + Support `--reference-location` for HTML output (#7461,
      Francesco Mazzoli).
    + Set "hash" to True by default (for reveal.js) (#7574).  See #6968
      where the motivation for setting "hash" to True is explained.

  * Native writer:  Use pretty-show to format native output (#7580).
    Previously we used our own homespun formatting.  But this produces
    over-long lines that aren't ideal for diffs in tests.
    Performance is slower by about a factor of 10, but this isn't
    really a problem because native isn't suitable as a serialization
    format. (For serialization you should use json, because the reader
    is so much faster than native.)

  * Org writer:

    + Don't indent contents of code blocks.  We previously indented them
      by two spaces, following a common convention.  Since the convention
      is fading, and the indentation is inconvenient for copy/paste, we are
      discontinuing this practice.
    + Update list of supported source languages in org writer (#5440).

  * Ipynb writer (Kolen Cheung):

    + Improve round trip identity for raw cell output.
      See jupyter/nbformat#229.  The Jupyter ecosystem, including nbconvert,
      lab and notebook, deviated from their own spec in nbformat, where
      they used the key `raw_mimetype` instead of `format`.  Moreover,
      the mime-type of rst used in Jupyter deviated from that suggested by
      https://docutils.sourceforge.io/FAQ.html and is defined as
      `text/restructuredtext` when chosen from "Raw NBConvert Format" in
      Jupyter.  The new behavior should matche the real world usage better,
      hence improving the round-trip "identity" in raw-cell.
    + Add more formats that can be handled as "raw" cells.

  * EPUB writer:

    + Add EPUB3 subject metadata (authority/term) (nuew).
      This adds the ability to specify EPUB 3 `authority` and `term` specific
      refinements to the `subject` tag. Specifying a plain `subject` tag in
      metadata will function as before.
    + Treat epub:type "frontispiece" as front matter (#7600).

  * reveal.js template: Fix line numbers in source code (#7634).
    We need `overflow: visible` for these to work, and reveal's
    default css disables this.  So we re-enable it in the default template.

  * Text.Pandoc.Writers.Shared:

    + Export `splitSentences` as a Doc Text transform [API change].
      Use this in man/ms.  We used to attempt automatic sentence
      splitting in man and ms output, since sentence-ending
      periods need to be followed by two spaces or a newline in
      these formats.  But it's difficult to do this reliably at
      the level of `[Inline]`.

  * Text.Pandoc.Translations: small revisions for compatibility
    with aeson 2.

  * Don't prepend `file://` to `--syntax-definition` on Windows (#6374).
    This was a fix for a problem in skylighting, but this
    problem doesn't exist now that we've moved from HXT to xml-conduit.

  * Text.Pandoc.Extensions:

    + Add `Ext_footnotes` to default `gfm` etxensions.  Now `gfm`
      supports footnotes.
    + Alphabetize Extension constructors (also affects `--list-extensions`).

  * Text.Pandoc.Citeproc.Util: Better implementation of `splitStrWhen`.
    Previously the citeproc code had two less efficient
    implementations.

  * Update documentation for definition_list extension (#7594).
    In 2015, we relaxed indentation requirements for the first
    line of a definition (see commit d3544dc and issue #2087), but
    the documnentation wasn't updated to reflect the change.

  * Text.Pandoc.Citeproc.BibTeX: Fix expansion of special strings in series
    e.g. `newseries` or `library` (#7591).  Expansion should not happen
    when these strings are protected in braces, or when they're
    capitalized.

  * Text.Pandoc.Logging: add `NotUTF8Encoded` constructor to `LogMessage`
    [API change].

  * Text.Pandoc.App.FormatHeuristics: remove `.tei.xml` extension for TEI
    (#7630).  This never worked, because `takeExtension`
    only returns `.xml`.  So it won't be missed if we remove it.

  * Text.Pandoc.Image:

    + Generalize `svgToPng` to MonadIO.
    + `svgToPng`, change first parameter from WriterOptions to Int.

  * Text.Pandoc.Class:

    + Add `readStdinStrict` method to PandocMonad [API change].
    + Generalize type of `extractMedia` [API change].
      It was uselessly  restricted to PandocIO, instead of any
      instance of PandocMonad and MonadIO.

  * Text.Pandoc.Class.PandocIO: derive MonadCatch, MonadThrow, MonadMask.
    This allows us to use `withTempDir` [API change].

  * Add module Text.Pandoc.Class.Sandbox, defining
   `sandbox`.  Exported via Text.Pandoc.Class. [API change]

  * Text.Pandoc.Filter:  Generalize type of `applyFilters`
    from PandocIO to any instance of MonadIO and PandocMonad [API change].

  * Text.Pandoc.PDF: generalize type of `makePDF`:
    instead of PandocIO, it can be used in any instance of
    PandocMonad, MonadIO, and MonadMask [API change].

  * Lua subsystem and custom writers: generalize types from PandocIO
    to any instance of PandocMonad and MonadIO [API change].
    The type of `runLua` is now

        (PandocMonad m, MonadIO m) =>
        LuaE PandocError a -> m (Either PandocError a)

    The change from `Lua` to `LuaE PandocError` is due to the switch to
    hslua-2.0; see next item.

  * Lua modules (Albert Krewinkel):

    + Switch to hslua-2.0.  The new HsLua version takes a somewhat different
      approach to marshalling and unmarshalling, relying less on typeclasses
      and more on specialized types. This allows for better performance and
      improved error messages.  Furthermore, new abstractions allow to
      document the code and exposed functions.
    + Marshal Version values, Inline elements, Attr elements,
      and Pandoc elements as userdata.
    + Remove deprecated inline constructors `DoubleQuoted`,
      `SingleQuoted`, `DisplayMath`, and `InlineMath`.
    + Attr values are no longer normalized when assigned to an Inline
      element property.
    + It's no longer possible to access parts of Inline elements via
      numerical indexes. E.g., `pandoc.Span('test')[2]` used to give
      `pandoc.Str 'test'`, but yields `nil` now. This was undocumented
      behavior not intended to be used in user scripts. Use named properties
      instead.
    + Accessing `.c` to get a JSON-like tuple of all components no longer
      works. This was undocumented behavior.
    + Only known properties can be set on an element value. Trying to set a
      different property will now raise an error.
    + Adds a new `pandoc.AttributeList()` constructor, which creates the
      associative attribute list that is used as the third component of
      `Attr` values. Values of this type can often be passed to constructors
      instead of `Attr` values.
    + Convert IOErrors to PandocErrors in `pandoc.pipe` function (#7523).

  * Text.Pandoc.PDF:  Previously we had to run `runIOorExplode` inside
    `withTempDir`.  Now that PandocIO is an instance of MonadMask, this is
    no longer necessary.

  * Text.Pandoc.App:

    + Reorganize to make it easier to limit IO in main loop.
      Previously we used liftIO fairly liberally.  The code has
      been restructured to avoid this.
    + Move output-file writing out of PandocMonad action.

  * Text.Pandoc.App.OutputSettings: Generalize some types
    so we can run this with any instance of PandocMonad and MonadIO,
    not just PandocIO.

  * Use `simpleFigure` builder in readers  and `SimpleFigure`
    pattern synonym in writers (Aner Lucero).

  * Allow time 1.12.

  * Use skylighting-0.12, skylighting-core-0.12.
    This fixes highlighting issues with typescript, scala, and other
    syntaxes that include keyword lists from different syntaxes.

  * Use citeproc 0.6, commonmark 0.2.2.1, commonmark-extensions 0.2.2,
    texmath 0.12.3.2, ipynb 0.1.0.2.  (These changes also allow
    building with aeson >= 2.)

  * Require doclayout >= 0.3.1.1.  This fixes recognition of "real widths"
    of emoji characters, which is important for tabular layout.

  * Cut out over 100K of fat in epub test golden files.

  * Make `test/epub/wasteland.epub` valid.

  * Add missing `%` on some command tests.
    This prevented `--accept` from working properly.

  * Command tests: raise error if command doesn't begin with `%`.

  * OOXML tests: use pretty-printed form to display diffs.
    Otherwise everything is on one line and the diff is uninformative.

  * Fix compareXML helper in Tests.Writers.OOXML.
    Given how it is used, we were getting "mine" and "good"
    flipped in the test results.

  * MANUAL.txt:

    + Clarify `attributes` extension support (William Lupton).
    + Document formats affected by `--reference-location`.
    + Document error code 25
    + Add some more info regarding `--slide-level=0` (Salim B).
    + Add more to security section of manual.
    + Mention support of `title-toc` (#7171, Christophe Dervieux).

  * doc/lua-filters.md:

    + Add missing type for Image title (Quinn).
    + Improve order of Image fields (Quinn).
    + Rephrase pandoc.path docs (#7548, Quinn).
    + Do not leak working directory in TikZ filter (Jeroen de Haas).

## pandoc 2.14.2 (2021-08-21)

  * Allow `--slide-level=0` (#7476). When the slide level is set
    to 0, headings won't be used at all in splitting the document
    into slides. Horizontal rules must be used to separate slides.

  * Add RTF reader (#3982). `rtf` is now supported as an input
    format as well as an output format. New module
    Text.Pandoc.Readers.RTF (exporting `readRTF`). [API change]

  * HTML reader:  treat comments as blank when parsing (#7482).

  * Markdown reader:

    + Fix raw LaTeX injection issue (#7497). Using a code block
      containing `\end{verbatim}`, one could inject raw TeX into a
      LaTeX document even when `raw_tex` is disabled. Thanks to
      Augustin Laville for noticing the bug.
    + Multimarkdown sub- and superscripts (#5512, OCzarnecki).
      Added an extension `short_subsuperscripts` which modifies
      the behavior of `subscript` and `superscript`, allowing
      subscripts or superscripts containing only alphanumerics
      to end with a space character (eg. `x^2 = 4` or `H~2 is
      combustible`).  This improves support for multimarkdown.

  * RST reader: Fix `:literal:` includes (#7513).  These should create
    code blocks, not insert raw RST.

  * LaTeX reader:

    + Proper implicit grouping around environment macros.
    + Support `\global` before `\def`, `\let`, etc. (#7494).
    + Fix scope for LaTeX macros (#7494). They should by default
      scope over the group in which they are defined (except `\gdef`
      and `\xdef`, which are global). In addition, environments must
      be treated as groups.
    + Improve handling of plain TeX macro primitives (#7474).
      Fixed semantics for `\let`.
    + Implement `\edef`, `\gdef`, and `\xdef`.

  * Docx reader: Improve docx reader's robustness in extracting
    images (#7511). The docx reader made some assumptions about
    how docx containers were laid out that were not always true, with
    the result that some images in documents did not get
    extracted.

  * LaTeX writer: Increase table column width precision (#7466,
    Peter Fabinski). In some cases, the rounding performed by the
    LaTeX table writer would introduce visible overrun outside
    the text area. This adds two more decimal places to the width
    values.

  * Powerpoint writer:

    + Include image title in description (#7352, Emily Bourke). The
      image title (i.e. `![alt text](link "title")`) was previously
      ignored when writing to pptx. This commit includes it in
      PowerPoint's description of the image, along with the link.
    + Select layouts from reference doc by name (Emily Bourke). Until
      now, users had to make sure that their reference doc contains
      layouts in a specific order: the first four layouts in the file
      had to have a specific structure. Now the layout selection uses
      the layout names rather than order: users must make sure their
      reference doc contains four layouts with specific names, and if
      a layout with the right name isn’t found pandoc will emit
      a warning and use the corresponding layout from the default
      reference doc as a fallback.

  * Docx writer: be sensitive to the `native_numbering` extension
    (#7499).  Figure and table numbers are now only included if
    `native_numbering` is enabled.  (By default it is disabled.)
    This is a behavior change with respect to 2.14.1, but the
    default behavior is now that of previous versions.  The
    change was necessary to avoid incompatibilities between
    pandoc's native numbering and third-party cross reference
    filters like pandoc-crossref.

  * RTF writer:

    + Omit `\bin` in `\pict`. According to the spec, this is not
      needed or wanted when the data is in hexadecimal format, as
      here.
    + Emit `\outlinelevel`` for section headings.

  * RTF template: specify font family for fixed-width font f1.
    According to the spec, this is mandatory.

  * LaTeX writer: Use ulem for underline (#7351). ulem is
    conditionally included already when the `strikeout` variable
    is set, so we set this when there is underlined text, and use
    `\uline` instead of `\underline`. This fixes wrapping for
    underlined text.

  * Text.Pandoc.Citeproc:

    + Revise citeproc code to fit new citeproc 0.5 API (thanks to
      Benjamin Bray). Linkification of URLs in the bibliography
      is now done in the citeproc library, depending on the
      setting of an option.  We set that option depending on the
      value of the metadata field `link-bibliography` (defaulting
      to true, for consistency with earlier behavior). If a DOI,
      PMID, PMCID, or URL field is present but not explicitly
      rendered, the title (or if no title, the whole entry) is
      hyperlinked. These changes implement the recommendations
      from the draft CSL v1.0.2 spec (Appendix VI):
      <https://github.com/citation-style-language/documentation/blob/master/specification.rst#appendix-vi-links>
    + Avoid odd handling of quotes. Recent citeproc changes
      allow us to ignore Quoted elements; citeproc now uses its own
      method for represented quoted things, and only localizes and
      flipflops quotes it adds itself. Convert Quoted in bib
      entries to special Spans before passing them off to
      citeproc. This ensures that we get proper localization and
      flipflopping if, e.g., quotes are used in titles
      (jgm/citeproc#87).
    + Removed quote localization from citeproc processing.
      This is now done in citeproc itself.

  * Text.Pandoc.Logging: Add PowerpointTemplateWarning log message
    type [API change] (Emily Bourke).

  * Text.Pandoc.Extension: Add `Ext_short_subsuperscripts`
    constructor to `Extension` [API change] (OCzarnecki).

  * Various sample.lua editorial fixes (#7493, #7487, William
    Lupton).

  * Bump base-compat version so we get compatibility with base 4.12.

  * Use Prelude from base-compat for ghc 8.4 too.

  * Add haskell-language-server to shell.nix (#7496, Emily Bourke).

  * Tests.Helpers: export testGolden and use it in RTF reader.
    This gives a diff output on failure.

  * Remove obsolete and incorrect sentence in `--slide-level` docs.

  * Add internal module Text.Pandoc.Network.HTTP, exporting
    `urlEncode`.

  * Text.Pandoc.Parsing: `parseFromString`: preserve at least
    the source directory (#7464). Previously we just set the
    source name to "chunk" when parsing from strings, to avoid
    misleading source positions. This had the side effect that
    `rebase_relative_paths` would break inside sections that
    were parsed as strings. So, now we use
    "ORIGINAL_SOURCE_PATH_chunk" instead of just "chunk".

  * Text.Pandoc.MIME: use image/x-xcf instead of application/x-xcf
    (#7454).

  * Don’t compare `cdLine` in OOXML golden tests (Emily Bourke).
    The `cdLine` field gives the line of the file some CData was
    found on, which reflects irrelevant formatting differences.

  * Provide more detailed XML diff in tests (Emily Bourke).

  * OOXML tests: silence warnings. These can make the test output
    confusing, making people think tests are failing when they're
    passing.

  * INSTALL.md: Add GitLab CI/CD example (#7448, Veratyr).

  * MANUAL.txt

    - Clarifications (William Lupton).
    - Add a note on security risks of include directives.

  * Document use of the 'underline' class (#7492, #7484, William
    Lupton).

  * Add a FAQ about the "Cannot allocate memory" error on M1 macs.

  * Use texmath 0.12.3.1.

  * Use released citeproc 0.5.

  * Remove dependency on HTTP package (#7456, mt_caret).

## pandoc 2.14.1 (2021-07-18)

  * Text.Pandoc.ImageSize: Add Tiff constructor for ImageType (#7405)
    [Minor API change].  This allows pandoc to get size information from
    tiff images.

  * Markdown reader:  don't try to read contents in self-closing HTML tag.
    Previously we had problems parsing raw HTML with self-closing
    tags like `<col/>`. The problem was that pandoc would look
    for a closing tag to close the markdown contents, but the
    closing tag had, in effect, already been parsed by `htmlTag`.

  * LaTeX reader:

    + Avoid trailing hyphen in translating languages (#7447).
      Previously `\foreignlanguage{english}` turned into `<span lang="en-">`.
      The same issue affected Arabic.
    + Support `\cline` in LaTeX tables (#7442).
    + Improved parsing of raw LaTeX from Text streams (`rawLaTeXParser`,
      used to read LaTeX in Markdown files, #7434).  We now use source
      positions from the token stream to tell us how much of the text stream
      to consume.  Getting this to work required a few other changes to
      make token source positions accurate.

  * DocBook reader:

    + Handle images with imageobjectco elements (#7440).
    + Add support for citerefentry (#7437, Jan Tojnar).

  * RST reader: fix regression with code includes (#7436).
    With the recent changes to include infrastructure,
    included code blocks were getting an extra newline.

  * HTML reader:

    + Recognize data-external when reading HTML img tags (#7429,
      Michael Hoffmann).  Preserve all attributes in img tags.  If attributes
      have a `data-` prefix, it will be stripped.  In particular, this
      preserves a `data-external` attribute as an `external` attribute in
      the pandoc AST.
    + Add col, colgroup to 'closes' definitions

  * HTML writer:

    + Remove duplicated alt text in HTML output (Aner Lucero).
    + Remove `aria-hidden` when explicit alt text is provided (Aner Lucero).
    + Set boolean values for reveal.js variables.

  * Docx writer:

    + Add table numbering for captioned tables.
      The numbers are added using fields, so that Word can
      create a list of tables that will update automatically.
    + Support figure numbers.  These are set up in such a way that they
      will work with Word's automatic table of figures (#7392).

  * Markdown writer: put space between Plain and following fenced Div
    (#4465).

  * EPUB writer: Don't incorporate externally linked images in EPUB documents
    (#7430, Michael Hoffmann).  Just as it is possible to avoid incorporating
    an image in EPUB by passing `data-external="1"` to a raw HTML snippet,
    this makes the same possible for native Images, by looking for an
    associated `external` attribute.

  * Text.Pandoc.PDF:

    + Fix `svgIn` path error (#7431).  We were duplicating
      the temp directory; this didn't cause problems on macOS or linux
      because there we use absolute paths for the temp directory.
      But on Windows it caused errors converting SVG files.
    + `convertImage`: normalize paths (#7431).  This will avoid paths
      on Windows with mixed path separators.

  * Text.Pandoc.Class: Always use / when adding directory to image destination
    with `extractMedia`, even on Windows.

  * Text.Pandoc.Citeproc:

    + Allow `$` characters in bibtex keys (#7409).
    + Set proper initial source name in parsing BibTeX (for better error
      messages.)
    + Revamp note citation handling (#7394).  Use latest
      citeproc, which uses a Span with a class rather than a Note for notes.
      This helps us distinguish between user notes and citation notes.  Don't
      put citations at the beginning of a note in parentheses.  Fix small bug
      in handling of citations in notes, which led to commas at the end of
      sentences in some cases.
    + Cleanup and efficiency improvement in `deNote`.
    + Improve punctuation moving with `--citeproc`.  Previously, using
      `--citeproc` could cause punctuation to move in quotes even when
      there aer no citations. This has been changed; punctuation moving
      is now limited to citations.  In addition, we only move footnotes
      around punctuation if the style is a note style, even if
      `notes-after-punctuation` is `true`.

  * Use citeproc 0.10. This helps improve note citations (see above)
    and eliminates double hyperlinks in author-in-text citations.
    Author-only citations are no longer hyperlinked.  See jgm/citeproc#77.
    It also fixes moving of punctuation inside quotes to conform to
    the CSL spec: only comma and period are moved, not question
    mark or exclamation point.

  * Text.Pandoc.Error: fix line calculations in reporting parsec errors.
    Also remove a spurious initial newline in the error report.

  * Use doctemplates 0.4.1, which gives us better support for boolean
    variable values.  Previously `$if(foo)$` would evaluate to true
    for variables with boolean `false` values, because it cared only
    about the string rendering (#7402).

  * Require commonmark-pandoc >= 0.2.2.1.
    This fixes task lists with multiple paragraphs.

  * Use skylighting 0.11.

  * CSS in HTML template: reset overflow-wrap on code blocks
    (Mauro Bieg, #7423).

  * LaTeX template: Revert change in PR #7295: "move title, author, date up
    to top of preamble." The change caused problem for people who used
    LaTeX commands defined defined later in the preamble in the title
    or author fields (#7422).

  * Add `doc/faqs.md`.  This is imported from the website; in the future the
    website version will be drawn from here.
    Added a FAQ on the use of `\AtEndPreamble` for cases when the contents of
    `header-includes` need to refer to definitions that come later in the
    preamble.  See #7422.

  * Upgrade Debian 10 AMI for build-arm.sh.

  * CircleCI: change to using xcode 11.1.0 (macOS 10.14.4).
    We previously built on 10.13, but 10.13 no longer gets
    security updates and CirclCI is deprecating.

## pandoc 2.14.0.3 (2021-06-22)

  * Text.Pandoc.MediaBag `insertMediaBag`: ensure we get a sane mediaPath
    for URLs (#7391).  In earlier 2.14.x versions, we'd get
    incorrect paths for resources downloaded from URLs when the
    media are extracted (including in PDF production).
  * Text.Pandoc.Parsing: improve `emailAddress` (#7398).
    Previously the parser would accept characters in domains
    that are illegal in domains, and this sometimes caused it
    to gobble bits of the following text.
  * txt2tags reader: modify the email address parser so
    it still includes form parameters, even after the change to
    `emailAddress` in Text.Pandoc.Parsing.
  * Text.Pandoc.Readers.Metadata: Fix regression with comment-only YAML
    metadata blocks (#7400).
  * reveal.js writer and template: better handling of options.  Previously
    it was impossible to specify false values for options that default to
    true (e.g. `center`); setting the option to false just caused the portion
    of the template setting the option to be omitted.  Now we prepopulate
    all the variables with their default values, including them all
    unconditionally and allowing them to be overridden.
  * Markdown writer: Fix regression in code blocks with attributes (#7397).
    Code blocks with a single class but nonempty attributes
    were having attributes drop as a result of #7242.
  * LaTeX writer:
    + Add strut at end of minipage if it contains line breaks.
      Without them, the last line is not as tall as it should be in
      some cases.
    + Always use a minipage for cells with line breaks, when
      width information is available (#7393).  Otherwise the way we treat them
      can lead to content that overflows a cell.
    + Use `\strut` instead of `~` before `\\` in empty line.
  * Use lts-18.0 stack resolver.
  * Require skylighting 0.10.5.2 (adding support for Swift).
  * Require commonmark 0.2.1.
  * Rephrase section on unsafe HTML in manual.
  * Create SECURITY.md

## pandoc 2.14.0.2 (2021-06-13)

  * Fix MediaBag regressions (#7345). iIn the 2.14 release `--extract-media`
    stopped working as before; there could be mismatches between the
    paths in the rendered document and the extracted media.
    This patch makes several changes that restore the earlier behavior
    (while keeping the same API).  The `mediaPath` in 2.14 was always
    constructed from the SHA1 hash of the media contents.  Now, we
    preserve the original path unless it's an absolute path or contains
    `..` segments (in that case we use a path based on the SHA1 hash of
    the contents).

    In Text.Pandoc.MediaBag, `mediaDirectory` and `mediaItems` now use the
    `mediaPath`, rather than the mediabag key, for the first component of the
    tuple.  This makes more sense, I think, and fits with the documentation of
    these functions; eventually, though, we should rework the API so that
    `mediaItems` returns both the keys and the MediaItems.

    In Text.Pandoc.Class.IO, rewriting of source paths in `extractMedia` has
    been fixed.

    In Text.Pandoc.Class.PandocMonad, `fillMediaBag` has been modified so that
    it doesn't modify image paths (that was part of the problem in #7345).

    We now do path normalization (e.g. `\` separators on Windows) in
    writing the media.

  * Text.Pandoc.PDF:

    + Text.Pandoc.PDF: Fix regression in 2.14 for generation of PDFs with
      SVGs (#7344).
    + Only print relevant part of environment on `--verbose`.  Since
      `--verbose` output might be put in an issue, we want to avoid
      spilling out secrets in environment variables.

  * Markdown reader: fix pipe table regression in 2.11.4 (#7343).
    Previously pipe tables with empty headers (that is, a header
    line with all empty cells) would be rendered as headerless
    tables.  This broke in 2.11.4.  The fix here is to produce an
    AST with an empty table head when a pipe table has all empty
    header cells.

  * LaTeX reader: don't allow optional `*` on symbol control sequences
    (#7340).  Generally we allow optional starred variants of LaTeX commands
    (since many allow them, and if we don't accept these explicitly,
    ignoring the star usually gives acceptable results).  But we
    don't want to do this for `\(*\)` and similar cases.

  * Docx reader: handle absolute URIs in Relationship Target (#7374).

  * Docx writer: fix handling of empty table headers (Albert Krewinkel,
    #7369).  A table header which does not contain any cells is now treated as
    an empty header.

  * LaTeX writer: Fix regression in table header position (#7347).
    In recent versions the table headers were no longer bottom-aligned
    (if more than one line).  This patch fixes that by using minipages
    for table headers in non-simple tables.

  * CommonMark writer:

    + Do not use simple class for fenced-divs (Jan Tojnar, amends #7242.)
    + Do not throw away attributes when `Ext_attributes` is enabled.
      `Ext_attributes` covers at least the following:
      `Ext_fenced_code_attributes`, `Ext_header_attributes`,
      `Ext_inline_code_attributes`, `Ext_link_attributes`.

  * Markdown writer:

    + Allow `pipe_tables` to be disabled for commonmark formats
      (`commonmark_x`, `gfm`) (#7375).
    + Re-use functions from Text.Pandoc.Markdown.Inline (Jan Tojnar).

  * DocBook writer: Remove non-existent admonitions (Jan Tojnar).
    `attention`, `error` and `hint` are reStructuredText specific.

  * HTML writer: Don't omit width attribute on div (#7342).

  * Text.Pandoc.MIME, `extensionFromMimeType`: add a few special cases.
    When we do a reverse lookup in the MIME table, we just get the
    last match, so when the same mime type is associated with several
    different extensions, we sometimes got weird results, e.g. `.vs`
    for `text/plain`.  These special cases help us get the most standard
    extensions for mime types like `text/plain`.

  * Lua utils: fix handling of table headers in `from_simple_table` (Albert
    Krewinkel, #7369).  Passing an empty list of header cells now results
    in an empty table header.

  * Text.Pandoc.Citeproc:

    + Avoid duplicate classes and attributes on references div.
    + Fix regression in citeproc processing (#7376).  If inline
      references are used (in the metadata `references` field), we
      should still only include in the bibliography items that are
      actually cited (unless `nocite` is used).

  * Require citeproc 0.4.0.1.  This fixes a bug which led to doubled
    "et al." in some (rare) circumstances.

  * MANUAL.txt:

    + Mention GladTeX for EPUB export (Sebastian Humenda).
      This updates the manual and the web site about the GladTeX usage.
    + More details and a useful link for YAML syntax.

  * CONTRIBUTING.md: update modules overview (Albert Krewinkel).

  * using-the-pandoc-api.md: switch from String to Text (Albert Krewinkel).


## pandoc 2.14.0.1 (2021-06-01)

  * Commonmark reader: Fix regression in 2.14 with YAML metdata block parsing,
    which could cause the document body to be omitted after metadata (#7339).

  * HTML reader: fix column width regression in 2.14 (#7334).
    Column widths specified with a style attribute were off by a factor of 100.

  * Markdown reader: in `rebasePaths`, check for both Windows and Posix
    absolute paths.  Previously Windows pandoc was treating
    `/foo/bar.jpg` as non-absolute.

  * Text.Pandoc.Logging: In rendering `LoadedResource`, use relative paths.

  * Docx writer: fix regression on captions (#7328).  The "Table Caption"
    style was no longer getting applied.  (It was overwritten by "Compact.")

  * Use commonmark-extensions 0.2.1.2

## pandoc 2.14 (2021-05-28)

  * Change reader types, allowing better tracking of source positions
    [API change].  Previously, when multiple file arguments were provided,
    pandoc simply concatenated them and passed the contents to the readers,
    which took a Text argument.  As a result, the readers had no way of knowing
    which file was the source of any particular bit of text.  This meant that
    we couldn't report accurate source positions on errors or include accurate
    source positions as attributes in the AST.  More seriously, it meant that
    we couldn't resolve resource paths relative to the files containing them
    (see e.g. #5501, #6632, #6384, #3752).

  * Add `rebase_relative_paths` extension (#3752).  When enabled, this
    extension rewrites relative image and link paths by prepending
    the (relative) directory of the containing file.  This
    behavior is useful when your input sources are split
    into multiple files, across several directories, with files
    referring to images stored in the same directory.  The
    extension can be enabled for all markdown and commonmark-based formats.

  * Add Text.Pandoc.Sources (exported module), with a `Sources` type and a
    `ToSources` class.  A `Sources` wraps a list of `(SourcePos, Text)` pairs
    [API change]. A parsec `Stream` instance is provided for `Sources`.  The
    module also exports versions of parsec's `satisfy` and other Char parsers
    that track source positions accurately from a `Sources` stream (or any
    instance of the new `UpdateSourcePos` class).

  * Text.Pandoc.Parsing

    + Export the modified Char parsers defined in Text.Pandoc.Sources
      instead of the ones parsec provides.  Modified parsers to use a
      `Sources` as stream [API change].
    + Improve include file functions [API change].  Remove old
      `insertIncludedFileF`.  Give `insertIncludedFile` a more general type,
      allowing it to be used where `insertIncludedFileF` was.
    + Add parameter to the `citeKey` parser from
      Text.Pandoc.Parsing, which controls whether the `@{..}`
      syntax is allowed [API change].

  * Text.Pandoc.Error: Modified the constructor `PandocParsecError` to take a
    `Sources` rather than a `Text` as first argument, so parse error locations
    can be accurately reported.

  * Fix source position reporting for YAML bibliographies (#7273).

  * Issue error message when  reader or writer format is malformed
    (#7231).  Previously we exited with an error status but (due to a bug)
    no message.

  * Smarter smart quotes (#7216, #2103).  Treat a leading `"` with no
    closing `"` as a left curly quote.  This supports the practice, in
    fiction, of continuing paragraphs quoting the same speaker without an
    end quote.  It also helps with quotes that break over lines in line blocks.

  * Markdown reader:

    + Use MetaInlines not MetaBlocks for multimarkdown metadata fields.
      This gives better results in converting to e.g.  pandoc markdown.
    + Implement curly-brace syntax for Markdown citation keys (#6026).
      The change provides a way to use citation keys that contain
      special characters not usable with the standard citation key syntax.
      Example: `@{foo_bar{x}'}` for the key `foo_bar{x}`.  It also allows
      separating citation keys from immediately following text, e.g. `@{foo}A`.

  * RST reader:

    + Seek include files in the directory of the file
      containing the include directive, as RST requires (#6632).
    + Use `insertIncludedFile` from Text.Pandoc.Parsing
      instead of reproducing much of its code.

  * Org reader: Resolve org includes relative to the directory containing the
    file containing the INCLUDE directive (#5501).

  * ODT reader: Treat tabs as spaces (#7185, niszet).

  * Docx reader:

    + Add handling of vml image objects (#7257, mbrackeantidot).
    + Support new table features (Emily Bourke, #6316):  column
      spans, row spans, multiple header rows, table description
      (parsed as a simple caption), captions, column widths.

  * LaTeX reader:

    + Improved siunitx support (#6658, #6620).
    + Better support for `\xspace` (#7299).
    + Improve parsing of `\def` macros.  We previously set "verbatim mode"
      even for parsing the initial `\def`; this caused problems
      for `\def` nested inside another `\def`.
    + Implement `\newif`.

  * ConTeXt writer: improve ordered lists (#5016, Denis Maier).
    Change ordered list from itemize to enumerate.  Add new
    itemgroup for ordered lists.  Remove manual insertion of
    width attributes.  Use tabular figures in ordered list
    enumerators.

  * HTML reader:

    + Don't fail on unmatched closing "script" tag (Albert Krenkel, #7282).
    + Keep h1 tags as normal headers (#2293, Albert Krewinkel).
      The tags `<title>` and `<h1 class="title">` often contain the same
      information, so the latter was dropped from the document. However, as
      this can lead to loss of information, the heading is now always
      retained.  Use `--shift-heading-level-by=-1` to turn the `<h1>`
      into the document title, or a filter to restore the previous behavior.
    + Handle relative lengths (e.g. `2*`) in HTML column widths (#4063).
      See <https://www.w3.org/TR/html4/types.html#h-6.6>.

  * DocBook/JATS readers:

    + Fix mathml regression caused by the switch in XML libraries (#7173).
    + Fix "phrase" in DocBook: take classes from "role" not "class" (#7195).

  * DocBook reader: ensure that first and last names are separated (#6541).

  * Jira reader (Albert Krewinkel, #7218):

    + Support "smart" links: `[alias|https://example.com|smart-card]` syntax.
    + Allow spaces and most unicode characters in attachment links.
    + No longer require a newline character after `{noformat}`.
    + Only allow URI path segment characters in bare links.
    + The `file:` schema is no longer allowed in bare links; these
      rarely make sense.

  * Plain writer: handle superscript unicode minus (#7276).

  * LaTeX writer:

    + Better handling of line breaks in simple tables (#7272).
      Now we also handle the case where they're embedded in other elements,
      e.g. spans.
    + For beamer output, support `exampleblock` and `alertblock` (#7278).
      A block will be rendered as an `exampleblock` if the heading
      has class `example` and an `alertblock` if it has class `alert`.
    + Separate successive quote chars with thin space (#6958,
      Albert Krewinkel).  Successive quote characters are separated with
      a thin space to improve readability and to prevent unwanted ligatures.
      Detection of these quotes sometimes had failed if the second quote
      was nested in a span element.
    + Separate successive quote chars with thin space (#6958, Albert
      Krewinkel).

  * EPUB Writer: Fix belongs-to-collection XML id choice (#7267, nuew).
    The epub writer previously used the same XML id for both the book
    identifier and the epub collection. This causes an error on epubcheck.

  * BibTeX/BibLaTeX writer: Handle `annote` field (#7266).

  * ZimWiki writer: allow links and emphasis in headers (#6605,
    Albert Krewinkel).

  * ConTeXt writer:

    + Support blank lines in line blocks (#6564, Albert Krewinkel,
      thanks to @denismaier).
    + Use span identifiers as reference anchors (#7246, Albert Krewinkel).

  * HTML writer:

    + Keep attributes from code nested below `pre` tag (#7221,
      Albert Krewinkel).  If a code block is defined with `<pre><code
      class="language-x">…</code></pre>`, where the `<pre>` element has no
      attributes, then the attributes from the `<code>` element are used
      instead. Any leading `language-` prefix is dropped in the code's
      `class` attribute are dropped to improve syntax highlighting.
    + Ensure headings only have valid attribs in HTML4 (#5944, Albert
      Krewinkel).
    + Parse `<header>` as a Div (Albert Krewinkel).

  * Org writer:

    + Inline latex envs need newlines (#7252, tecosaur).
      As specified in https://orgmode.org/manual/LaTeX-fragments.html, an
      inline \begin{}...\end{} LaTeX block must start on a new line.
    + Use LaTeX style maths deliminators (#7196, tecosaur).

  * JATS writer (Albert Krewinkel):

    + Use either styled-content or named-content for spans (#7211).
      If the element has a content-type attribute, or at least one class,
      then that value is used as `content-type` and the span is put inside
      a `<named-content>` element. Otherwise a `<styled-content>` element
      is used instead.
    + Reduce unnecessary use of `<p>` elements for wrapping (#7227).
      The `<p>` element is used for wrapping in cases were the contents
      would otherwise not be allowed in a certain context. Unnecessary
      wrapping is avoided, especially around quotes (`<disp-quote>` elements).
    + Convert spans to `<named-content>` elements (#7211).  Spans with
      attributes are converted to `<named-content>` elements instead of
      being wrapped with `<milestone-start/>` and `<milestone-end>`
      elements. Milestone elements are not allowed in documents using the
      articleauthoring tag set, so this change ensures the creation of valid
      documents.
    + Add footnote number as label in backmatter (#7210).  Footnotes in the
      backmatter are given the footnote's number as a label.  The
      articleauthoring output is unaffected from this change, as footnotes
      are placed inline there.
    + Escape disallows chars in identifiers.  XML identifiers must start
      with an underscore or letter, and can contain only a limited set
      of punctuation characters. Any IDs not adhering to these rules are
      rewritten by writing the offending characters as `Uxxxx`,
      where `xxxx` is the character's hex code.

  * Jira writer:  use `{color}` when span has a color attribute
    (Albert Krewinkel, tarleb/jira-wiki-markup#10).

  * Docx writer:

    + Autoset table width if no column has an explicit width (Albert
      Krewinkel).
    + Extract Table handling into separate module (Albert Krewinkel).
    + Support colspans and rowspans in tables (Albert Krewinkel, #6315).
    + Support multirow table headers (Albert Krewinkel).
    + Improve integration of settings from reference.docx (#1209).
      This change allows users to create a reference.docx that
      sets `w:proofState` for spelling or grammar to `dirty`,
      so that spell/grammar checking will be triggered on the
      generated docx.
    + Copy over more settings from reference.docx (#7240).  From settings.xml
      in the reference-doc, we now include: `zoom`, `embedSystemFonts`,
      `doNotTrackMoves`, `defaultTabStop`, `drawingGridHorizontalSpacing`,
      `drawingGridVerticalSpacing`, `displayHorizontalDrawingGridEvery`,
      `displayVerticalDrawingGridEvery`, `characterSpacingControl`,
      `savePreviewPicture`, `mathPr`, `themeFontLang`, `decimalSymbol`,
      `listSeparator`, `autoHyphenation`, `compat`.
    + Set zoom to 100% by default in settings.xml.
    + Align math options more with current Word defaults (e.g.  Cambria Math
      font).
    + Remove `rsid`s from default settings.xml.  Word will add these
      when revisions are made.

  * Ms writer: Handle tables with multiple paragraphs (#7288).
    Previously they overflowed the table cell width.  We now set line lengths
    per-cell and restore them after the table has been written.

  * Markdown writer:

    + Use cleaner braceless syntax for code blocks with a
      single class (#7242, Jan Tojnar).
    + Add quotes properly in markdown YAML metadata fields (#7245).
      This fixes a bug, which caused the writer to look at the *last*
      rather than the *first* character in determining whether quotes
      were needed.  So we got spurious quotes in some cases and
      didn't get necessary quotes in others.
    + Use `@{..}` syntax for citations when needed.
    + Use fewer unneeded escapes for `#` (see #6259).
    + Improve escaping of `@`.  We need to escape literal `@` before
      `{` because of the new citation syntax.

  * Commonmark writer: Use backslash escapes for `<` and `|`...
    instead of entities (#7208).

  * Powerpoint writer: allow `monofont` to be specified in metadata
    (#7187).

  * LaTeX template:

    + Use non-starred names for xcolor color names (#6109).
      This should make svgnames and x11names work properly.
    + Fix bad vertical spacing after bibliography (#7234, badumont).
    + List of figures before list of tables (#7235, Julien Dutant).
    + Move CSL macro definitions before header-includes so they can be
      overridden (#7286).
    + Improve treatment of CSL `entry-spacing` (#7296).
      Previously with the default template settings (`indent` variable
      not set), we would get interparagraph spaces separating bib
      entries even with `entry-spacing="0"`.  On the other hand,
      setting `entry-spacing="2"` gave ridiculously large spacing.
      This change makes the spacing caused by `entry-spacing` a multiple
      of `\parskip` by default, which gives aesthetically reasonable
      output.  Those who want a larger or smaller unit (e.g. because
      they use `indent` which sets `\parskip` to 0) may
      `\setlength{\cslentryspacingunit}{10pt}` in header-includes
      to override the defaults.
    + Move title, author, date up to top of preamble (#7295).
      This allows header-includes to use them, and puts them
      in a position where you can see them immediately.
    + Define commands for zero width non-joiner character
      (#6639, Albert Krewinkel).  The zero-width non-joiner character
      is used to avoid ligatures (e.g. in German).

  * ConTeXt template:

    + Define `enumerate` itemgroup (#5016, Denis Maier).
    + List of figures before list of tables (#7235, Julien Dutant).

  * reveal.js template:

    + Support `toc-title` (#7171, Florian Kohrt).
    + Use `hash: true` by default rather than `history: true` (#6968).

  * HTML-based slide shows: add support for `institute` (#7289, Thomas
    Hodgson).

  * Text.Pandoc.Extensions: Add constructor `Ext_rebase_relative_paths` to
    `Extensions` [API change].

  * Text.Pandoc.XML.Light: add Eq, Ord instances for Content,
    Element, Attr, CDataKind [API change].

  * Text.Pandoc.MediaBag:

    + Change type to use a `Text` key instead of `[FilePath]`.
      We normalize the path and use `/` separators for consistency.
    + Export `MediaItem` type [API change].
    + Change `MediaBag` type to a map from Text to MediaItem [API change].
    + `lookupMedia` now returns a `MediaItem` [API change].
    + Change `insertMedia` so it sets the `mediaPath` to a filename based on
      the SHA1 hash of the contents.  This will be used when contents
      are extracted.

  * Text.Pandoc.Class.PandocMonad:

    + Remove `fetchMediaResource` [API change].  Use `fetchItem` to get
      resources in `fillMediaBag`.
    + Add informational message in `downloadOrRead` indicating what path
      local resources have been loaded from.

  * Text.Pandoc.Logging:

    + Remove single quotes around paths in messages.
    + Add LoadedResource constructor to LogMessage [API change].
      This is for INFO-level messages telling where image data has been
      loaded from.  (This can vary because of the resource path.)

  * Text.Pandoc.Asciify: simplify code and export `toAsciiText` [API change].
    Instead of encoding a giant (and incomplete) map, we now
    just use unicode-transforms to normalize the text to
    a canonical decomposition, and manipulate the result.

  * App: allow tabs expansion even if file-scope is used (Albert Krewinkel,
    #6709).  Tabs in plain-text inputs  are now handled correctly, even if
    the `--file-scope` flag is used.

  * Add new internal module Text.Pandoc.Writers.GridTable (Albert Krewinkel).

  * Text.Pandoc.Highlighting: Change type of `languagesByExtension`, adding
    a parameter for a `SyntaxMap` [API change] (Jan Tojnar, #7241).
    Languages defined using `--syntax-definition` were not recognized by
    `languagesByExtension`.  This patch corrects that, allowing the writers
    to see all custom definitions.  The LaTeX writer still uses the default
    syntax map, but that's okay in that context, since
    `--syntax-definition` won't create new listings styles.

  * Text.Pandoc.Citeproc:

    + Ensure that CSL-related attributes are passed on to a Div with id
      'refs'.  Otherwise things like `entry-spacing` won't work when
      such Divs are used.
    + Use metadata's `lang` for the lang parameter of citeproc, overriding
      `localeLanguage`.
    + Recognize locators spelled with a capital letter (#7323).
    + Add a comma and a space in front of the suffix if it doesn't start
      with space or punctuation (#7324).
    + Don't detect math elements as locators (#7321).

  * Remove Text.Pandoc.BCP47 module [API change].  Use types and functions
    from UnicodeCollation.Lang instead.  This is a richer implementation
    of BCP 47.

  * Text.Pandoc.Shared:

    + Fix regression in grid tables for wide characters (#7214).
      In the translation from String to Text, a char-width-sensitive
      `splitAt'` was dropped.  This commit reinstates it and uses it to make
      `splitTextByInstances` char-width sensitive.
    + Add `getLang` (formerly in the now-removed BCP47) [API change].

  * Text.Pandoc.SelfContained: use `application/octet-stream`
    for unknown mime types instead of halting with an error (#7202).

  * Lua filters: respect Inlines/Blocks filter functions in `pandoc.walk_*`
    (Albert Krewinkel).

  * Add text as build-depend for trypandoc (#7193, Roman Beránek).

  * Bump upper-bounds for network-uri, time, attoparsec.

  * Use citeproc 0.4.

  * Use texmath 0.12.3.

  * Use jira-wiki-markup 1.3.5 (Albert Krewinkel).

  * Require latest skylighting (fixes a bug in XML syntax highlighting).

  * Use latest xml-conduit.

  * Use latest commonmark, commonmark-extensions, commonmark-pandoc.

  * Use haddock-library-1.10.0 (Albert Krewinkel).

  * Allow compilation with base 4.15 (Albert Krewinkel).

  * MANUAL:

    + Add information about `lang` and bibliography sorting.
    + Add info about YAML escape sequences, link to spec (#7152,
      Albert Krewinkel).
    + Note that `institute` variable works for HTML-based slides.
    + Update documentation on citation syntax.
    + Add citation example for locators and suffixes (Tristan Stenner)

  * Updated and fixed typos in documentation (Charanjit Singh,
    Anti-Distinctlyminty, Tatiana Porras, obcat).

  * Add instructions for installing pandoc-types before compiling filter.

  * INSTALL: add note that parallel installations should be avoided
    (#6865).

  * Remove `biblatex-nussbaum.md` test.  It is basically the same
    as `biblaetx-quotes.md`.

  * Command tests: fail if a file contains no tests---and fix a
    test that failed in that way!

  * Use smaller images in tests, reducing the size of the source tarball by 8 MB.


## pandoc 2.13 (2021-03-21)

  * Support `yaml_metadata_block` extension for `commonmark`, `gfm` (#6537).
    This supported is a bit more limited than with pandoc's
    `markdown`.  The YAML block must be the first thing in the input,
    and the leaf notes are parsed in isolation from the rest of
    the document.  So, for example, you can't use reference
    links if the references are defined later in the document.

  * Fix fallback to default partials when custom templates are used.
    If the directory containing a template does not contain the partial,
    it should be sought in the default templates, but this was not
    working properly (#7164).

  * Handle `nocite` better with `--biblatex` and `--natbib` (#4585).
    Previously the nocite metadata field was ignored with these formats.
    Now it populates a `nocite-ids` template variable and causes a
    `\nocite` command to be issued.

  * Text.Pandoc.Citeproc: apply `fixLinks` correctly (#7130).  This is code
    that incorporates a prefix like `https://doi.org/` into a following link
    when appropriate.

  * Text.Pandoc.Shared:

    + Remove `backslashEscapes`, `escapeStringUsing` [API change].  Replace
      these inefficient association list lookups with more efficient escaping
      functions in the writers that used them (for a 10-25% performance boost
      in org, haddock, rtf, texinfo writers).
    + Remove `ToString`, `ToText` typeclasses [API change].  These were needed
      for the transition from String to Text, but they are no longer used and
      may clash with other things.
    + Simplify `compactDL`.

  * Text.Pandoc.Parsing:

    + Change type of `readWithM` so that it is no longer polymorphic
      [API change].  The `ToText` class has been removed, and now that we've
      completed the transition to Text we no longer need this to operate
      on Strings.
    + Remove `F` type synonym [API change].  Muse and Org were defining their
      own `F` anyway.

  * Text.Pandoc.Readers.Metadata:

    + Export `yamlMetaBlock` [API change].
    + Make `yamlBsToMeta`, `yamlBsToRefs` polymorphic on the parser state
      [API change].

  * Markdown reader: Fix regression with `tex_math_backslash` (#7155).

  * MediaWiki reader: Allow block-level content in notes (ref) (#7145).

  * Jira reader (Albert Krewinkel):

    + Fixed parsing of autolinks (i.e., of bare URLs in the text).
      Previously an autolink would take up the rest of a line, as spaces
      were allowed characters in these items.
    + Emoji character sequences no longer cause parsing failures. This was
      due to missing backtracking when emoji parsing fails.
    + Mark divs created from panels with class "panel".

  * RST reader: fix logic for ending comments (#7134).  Previously comments
    sometimes got extended too far.

  * DocBook writer:  include Header attributes as XML attributes on
    section (Erik Rask).  Attributes with key names that are not allowed
    as XML attributes are dropped, as are attributes with invalid values
    and `xml:id` (DocBook 5) and `id` (DocBook 4).

  * Docx writer:

    + Make `nsid` in `abstractNum` deterministic.  Previously we assigned
      a random number, but we don't need random values, so now we just
      assign a value based on the list marker.
    + Use integral values for `w:tblW` (#7141).

  * Jira writer (Albert Krewinkel):

    + Block quotes are only rendered as `bq.` if they do not contain a
      linebreak.
    + Jira writer: improve div/panel handling.  Include div attributes in
      panels, always render divs with class `panel` as panels, and
      avoid nesting of panels.

  * HTML writer: Add warnings on duplicate attribute values.
    This prevents emitting invalid HTML.  Ultimately it would be good to
    prevent this in the types themselves, but this is better for now.

  * Org writer: Prevent unintended creation of ordered list items (#7132,
    Albert Krewinkel).  Adjust line wrapping if default wrapping would cause
    a line to be read as an ordered list item.

  * JATS templates: support 'equal-contrib' attrib for authors (Albert
    Krewinkel).  Authors who contributed equally to a paper may be marked
    with `equal-contrib`.

  * reveal.js template: replace JS comment with HTML (#7154, Florian Kohrt).

  * Text.Pandoc.Logging: Add `DuplicateAttribute` constructor to `LogMessage`.
    [API change]

  * Use `-j4` for linux release build.  This speeds up the build dramatically
    on arm.

  * cabal.project: remove ghcoptions.  Move flags to top level, so they can
    be set differently on the command line.

  * Require latest texmath, skylighting, citeproc, jira-wiki-markup.
    (The latest skylighting fixes a bad bug with Haskell syntax highlighting.)
    Narrow version bounds for texmath, skylighting, and citeproc, since
    the test output depend on them.

  * Use doclayout 0.3.0.2.  This significantly reduces the time and memory
    needed to compile pandoc.

  * Use `foldl'` instead of `foldl` everywhere.

  * Update bounds for random (#7156, Alexey Kuleshevich).

  * Remove uses of some partial functions.

  * Don't bake in a larger stack size for the executable.

  * Test improvements:

    + Use `getExecutablePath` from base, avoiding the dependency on
      `executable-path`.
    + Factor out `setupEnvironment` in Helpers, to avoid code duplication.
    + Fix finding of data files by setting teh `pandoc_datadir` environment
      variable when we shell out to pandoc. This avoids the need to use
      `--data-dir` for the tests, which caused problems finding `pandoc.lua`
      when compiling without the `embed_data_files` flag (#7163).

  * Benchmark improvements:

    + Build `+RTS -A8m -RTS` into default ghc-options for benchmark.
      This is necessary to get accurate benchmark results; otherwise we
      are largely measuring garbage collecting, some not related to the
      current benchmark.
    + Allow specifying BASELINE file in 'make bench' for comparison
      (otherwise the latest benchmark is chosen by default).
    + Force `readFile` in benchmarks early (Bodigrim).

  * CONTRIBUTING: suggest using a `cabal.project.local` file (#7153,
    Albert Krewinkel).

  * Add ghcid-test to Makefile.  This loads the test suite in ghcid.


## pandoc 2.12 (2021-03-08)

  * `--resource-path` now accumulates if specified multiple
    times (#6152).  Resource paths specified later on the command line are
    prepended to those specified earlier.  Thus,
    `--resource-path foo --resource-path bar:baz` is equivalent to
    `--resource-path bar:bas:foo`.  (The previous behavior was
    for the last `--resource-path` to replace all the rest.)
    `resource-path` in defaults files behaves the same way: it
    will be prepended to the resource path set by earlier
    command line options or defaults files.  This change
    facilitates the use of multiple defaults files: each can
    specify a directory containing resources it refers to
    without clobbering the resource paths set by the others.

  * Allow defaults files to refer to the home directory, the
    user data directory, and the directory containing the defaults file
    itself (#5871, #5982, #5977).  In fields that expect file paths
    (and only in these fields),

    + `${VARIABLE}` will expand to the value of the environment variable
      `VARIABLE` (and in particular `${HOME}` will expand to the path
      of the home directory).  A warning will be raised for undefined
      variables.
    + `${USERDATA}` will expand to the path of the user data
      directory in force when the defaults file is being processed.
    + `${.}` will expand to the directory containing the defaults file.
      (This allows default files to be placed in a directory containing
      resources they make use of.)

  * When downloading content from URL arguments, be sensitive to
    the character encoding (#5600).  We can properly handle UTF-8 and latin1
    (ISO-8859-1); for others we raise an error.  Fall back to latin1 if
    no charset is given in the mime type and UTF-8 decoding fails.

  * Allow abbreviations that don't end in a period to be
    specified using `--abbreviations` (#7124).

  * Add new unexported module Text.Pandoc.XML.Light, as well
    as Text.Pandoc.XML.Light.Types, Text.Pantoc.XML.Light.Proc,
    Text.Pandoc.XML.Light.Output.  (Closes #6001, #6565, #7091).

    This module exports definitions of `Element` and `Content`
    that are isomorphic to xml-light's, but with Text
    instead of String.  This allows us to keep most of the code in existing
    readers that use xml-light, but avoid lots of unnecessary allocation.

    We also add versions of the functions from xml-light's
    Text.XML.Light.Output and Text.XML.Light.Proc that operate on our
    modified XML types, and functions that convert xml-light types to our
    types (since some of our dependencies, like texmath, use xml-light).

    We export functions that use xml-conduit's parser to produce an
    `Element` or `[Content]`.  This allows existing pandoc code to use
    a better parser without much modification.

    The new parser is used in all places where xml-light's parser was
    previously used.  Benchmarks show a significant performance improvement
    in parsing XML-based formats (with docbook, opml, jats, and docx
    almost twice as fast, odt and fb2 more than twice as fast).

    In addition, the new parser gives us better error reporting than
    xml-light.  We report XML errors, when possible, using the new
    `PandocXMLError` constructor in `PandocError`.

    These changes revealed the need for some changes in the tests.  The
    docbook-reader.docbook test lacked definitions for the entities it used;
    these have been added. And the docx golden tests have been updated,
    because the new parser does not preserve the order of attributes.

  * DocBook reader:

    + Avoid expensive tree normalization step, as it is not necessary
      with the new XML parser.
    + Support `informalfigure` (#7079) (Nils Carlson).

  * Docx reader:

    + Use Map instead of list for Namespaces.  This gives a speedup of
      about 5-10%. With this and the XML parsing changes, the docx reader
      is now about twice as fast as in the previous release.

  * HTML reader:

    + Small performance tweaks.
    + Also, remove exported class `NamedTag(..)` [API change]. This was just
      intended to smooth over the transition from String to Text and is no
      longer needed.
    + As a result, the functions `isInlineTag` and `isBlockTag`
      are no longer polymorphic; they apply to a `Tag Text` [API change].
    + Do a lookahead to find the right parser to use.  This takes
      benchmarks from 34ms to 23ms, with less allocation.
    + Fix bad handling of empty `src` attribute in `iframe` (#7099).
      If `src` is empty, we simply skip the `iframe`.
      If `src` is invalid or cannot be fetched, we issue a warning
      nd skip instead of failing with an error.

  * JATS reader:

    + Avoid tree normalization, which is no longer necessary given the
      new XML parser.

  * LaTeX reader:

    + Don't export `tokenize`, `untokenize` [API change].  These are internal
      implementation details, which were only exported for testing.
      They don't belong in the public API.
    + Improved efficiency of the parser.  With these changes the reader
      is almost twice as fast as in the last release in our benchmarks.
    + Code cleanup, removing some unnecessary things.
    + Rewrite `withRaw` so it doesn't rely on fragile assumptions
      about token positions (which break when macros are expanded)
      (#7092).  This requires the addition of `sEnableWithRaw` and
      `sRawTokens` in `LaTeXState`, and a new combinator `disablingWithRaw`
      to disable collecting of raw tokens in certain contexts.
      Add `parseFromToks` to Text.Pandoc.Readers.LaTeX.Parsing.
      Fix parsing of single character tokens so it doesn't mess
      up the new raw token collecting.  These changes slightly increase
      allocations and have a small performance impact.
    + Handle some bibtex/biblatex-specific commands that used to be
      dealt with in pandoc-citeproc (#7049).
    + Optimize `satisfyTok`, avoiding unnecessary macro expansion steps.
      Benchmarks after this change show 2/3 of the run time and 2/3 of the
      allocation of the Feb. 10 benchmarks.
    + Removed `sExpanded` in state.  This isn't actually needed and checking
      it doesn't change anything.
    + Improve `braced'`.  Remove the parameter, have it parse the
      opening brace, and make it more efficient.
    + Factor out pieces of the LaTeX reader to make the module smaller.
      This reduces memory demands when compiling.  Created
      Text.Pandoc.Readers.{LaTeX,Math,Citation,Table,Macro,Inline}.
      Changed Text.Pandoc.Readers.LaTeX.SIunitx to export a command map
      instead of individual commands.
    + Handle table cells containing `&` in `\verb` (#7129).

  * Make Text.Pandoc.Readers.LaTeX.Types an unexported module [API change].

  * Markdown reader:

    + Improved handling of mmd link attributes in references (#7080).
      Previously they only worked for links that had titles.
    + Improved efficiency of the parser (benchmarks show a 15% speedup).

  * OPML reader:

    + Avoid tree normalization, which is no longer necessary with the
      new XML parser.

  * ODT reader:

    + Finer-grained errors on parse failure (#7091).
    + Give more information if the zip container can't be unpacked.

  * Org reader:

    + Support `task_lists` extension (Albert Krewinkel, #6336).
    + Fix bug in org-ref citation parsing (Albert Krewinkel, #7101).
      The org-ref syntax allows to list multiple citations separated by
      comma.  Previously commas were accepted as part of the citation id,
      so all citation lists were parsed as one single citation.

  * RST reader:

    + Use `getTimestamp` instead of `getCurrentTime` to fetch timestamp.
      Setting `SOURCE_DATE_EPOCH` will allow reproducible builds.
    + RST reader: fix handling of header in CSV tables (#7064).
      The interpretation of this line is not affected by the delim option.

  * Jira reader:

    + Modified the Doc parser to skip leading blank lines. This fixes
      parsing of documents which start with multiple blank lines (Albert
      Krewinkel, #7095).
    + Prevent URLs within link aliases to be treated as autolinks (Albert
      Krewinkel, #6944).

  * Text.Pandoc.Shared

    + Remove formerly exported functions that are no longer used in the
      code base: `splitByIndices`, `splitStringByIndicies`, `substitute`,
      and `underlineSpan` (which had been deprecated in April 2020)
      [API change].
    + Export `handleTaskListItem` (Albert Krewinkel) [API change].
    + Change `defaultUserDataDirs` to `defaultUserDataDir` [API
      change].  We determine what is the default user data directory
      by seeing whether the XDG directory and/or legacy
      directory exist.

  * BibTeX writer:

    + BibTeX writer: use doclayout and doctemplate.  This change allows
      bibtex/biblatex output to wrap as other formats do,
      depending on the settings of `--wrap` and `--columns` (#7068).

  * CSL JSON writer:

    + Output `[]` if no references in input, instead of raising a
      PandocAppError as before.

  * Docx writer:

    + Use `getTimestamp` instead of `getCurrentTime` for timestamp.
      Setting `SOURCE_DATE_EPOCH` will allow reproducible builds.

  * EPUB writer:

    + Use `getTimestamp` instead of `getCurrentTime` for timestamp.
      Setting `SOURCE_DATE_EPOCH` will allow reproducible builds (#7093).
      This does not suffice to fully enable reproducible in EPUB, since
      a unique id is still being generated for each build.
    + Support `belongs-to-collection` metadata (#7063) (Nick Berendsen).

  * JATS writer:

    + Escape special chars in reference elements (Albert Krewinkel).
      Prevents the generation of invalid markup if a citation element
      contains an ampersand or another character with a special meaning
      in XML.

  * Jira writer:

    + Use Span identifiers as anchors (Albert Krewinkel).
    + Use `{noformat}` instead of `{code}` for unknown languages (Albert
      Krewinkel). Code blocks which are not marked as a language supported
      by Jira are rendered as preformatted text via `{noformat}` blocks.

  * LaTeX writer:

    + Adjust hypertargets to beginnings of paragraphs (#7078).
      Use `\vadjust pre` so that the hypertarget takes you to the beginning
      of the paragraph rather than one line down.
      This makes a particular difference for links to citations using
      `--citeproc` and `link-citations: true`.
    + Change BCP47 lang tag from `jp` to `ja` (Mauro Bieg, #7047).
    + Use function instead of map for accent lookup (should be
      more efficient).
    + Split the module to make it easier to compile on low-memory
      systems:  added Text.Pandoc.Writers.LaTeX.{Util,Citation,Lang}.

  * Markdown writer:

    + Handle math right before digit.  We insert an HTML comment to
      avoid a `$` right before a digit, which pandoc will not recognize
      as a math delimiter.
    + Split the module to make it easier to compile on low-memory
      systems: added Text.Pandoc.Writers.Markdown.{Types,Inline}.

  * ODT writer:

    + Use `getTimestamp` instead of `getCurrentTime` for timestamp.
      Setting `SOURCE_DATE_EPOCH` will allow reproducible builds.
    + Update default ODT style (Lorenzo).  Previously, the "First paragraph"
      style inherited from "Standard" but not from "Text body." Now
      it is adjusted to inherit from "Text body", to avoid some ugly
      spacing issues. It may be necessary to update a custom `reference.odt`
      in light of this change.

  * Org writer:

    + Support `task_lists` extension (Albert Krewinkel, #6336).

  * Pptx writer:

    + Use `getTimestamp` instead of `getCurrentTime` for timestamp.
      Setting `SOURCE_DATE_EPOCH` will allow reproducible builds.

  * JATS templates: tag `author.name` as `string-name` (Albert Krewinkel).
    The partitioning the components of a name into surname, given names,
    etc. is not always possible or not available. Using `author.name`
    allows to give the full name as a fallback to be used when
    `author.surname` is not available.

  * Add default templates for bibtex and biblatex, so that
    the variables `header-include`, `include-before`, `include-after`
    (or alternatively the command line options
    `--include-in-header`, `--include-before-body`, `--include-after-body`)
    may be used.

  * LaTeX template:

    + Update to iftex package (#7073) (Andrew Dunning)
    + Wrap url colours in braces (#7121) (Loïc Grobol).

  * revealjs template: Add 'center' option for vertical slide centering.
    (maurerle, #7104).

  * Text.Pandoc.XML: Improve efficiency of `fromEntities`.

  * Text.Pandoc.MIME

    + Add exported function `getCharset` [API change].

  * Text.Pandoc.UTF8: change IO functions to return Text, not String
    [API change].  This affects `readFile`, `getContents`, `writeFileWith`,
    `writeFile`, `putStrWith`, `putStr`, `putStrLnWith`, `putStrLn`.
    `hPutStrWith`, `hPutStr`, `hPutStrLnWith`, `hPutStrLn`, `hGetContents`.
    This avoids the need to uselessly create a linked list of characters
    when emiting output.

  * Text.Pandoc.App

    + Add `parseOptionsFromArgs` [API change, new exported function].
    + Add fields for CSL options to `Opt` [API change]:
      `optCSL`, `optbibliography`, `optCitationAbbreviations`.

  * Text.Pandoc.Citeproc.BibTeX

    + `Text.Pandoc.Citeproc.writeBibTeXString` now returns
      `Doc Text` instead of `Text` (#7068).
    + Correctly handle `pages` (= `page` in CSL) (#7067).
    + Correctly handle BibLaTeX `langid` (= `language` in CSL, #7067).
    + In BibTeX output, protect foreign titles since there's no language
      field (#7067).
    + Clean up BibTeX parsing (#7049).  Previously there was a messy code
      path that gave strange results in some cases, not passing through raw
      tex but trying to extract a string content.  This was an artefact of
      trying to handle some special bibtex-specific commands in the BibTeX
      reader. Now we just handle these in the LaTeX reader and simplify
      parsing in the BibTeX reader. This does mean that more raw tex will
      be passed through (and currently this is not sensitive to the
      `raw_tex` extension; this should be fixed).

  * Text.Pandoc.Citeproc.MetaValue

    + Correctly parse "raw" date value in markdown references metadata.
      (See jgm/citeproc#53.)

  * Text.Pandoc.Citeproc

    + Use https URLs for links (Salim B, #7122).

  * Text.Pandoc.Class

    + Add `getTimestamp` [API change].  This attempts to read the
      `SOURCE_DATE_EPOCH` environment variable and parse a UTC time
      from it (treating it as a unix date stamp, see
      https://reproducible-builds.org/specs/source-date-epoch/). If the
      variable is not set or can't be parsed as a unix date stamp, then the
      function returns the current date.

  * Text.Pandoc.Error

    + Add `PandocUnsupportedCharsetError` constructor for
      `PandocError` [API change].
    + Export `renderError` [API change].
    + Refactor `handleError` to use `renderError`. This allows us render
      error messages without exiting.

  * Text.Pandoc.Extensions

    + `Ext_task_lists` is now supported by org (and turned
      on by default) (Albert Krewinkel, #6336).
    + Remove `Ext_fenced_code_attributes` from allowed commonmark attributes
      (#7097).  This attribute was listed as allowed, but it didn't actually
      do anything. Use `attributes` for code attributes and more.

  * Lua subsystem:

    + Always load built-in Lua scripts from default data-dir (Albert
      Krewinkel).  The Lua modules `pandoc` and `pandoc.List` are now always
      loaded from the system's default data directory. Loading from a
      different directory by overriding the default path, e.g. via
      `--data-dir`, is no longer supported to avoid unexpected behavior
      and to address security concerns.
    + Add module "pandoc.path" (Albert Krewinkel, #6001, #6565).
      The module allows to work with file paths in a convenient and
      platform-independent manner.
    + Use strict evaluation when retrieving AST value from the stack
      (Albert Krewinkel, #6674).

  * Text.Pandoc.PDF

    + Disable `smart` extension when building PDF via LaTeX.
      This is to prevent accidental creation of ligatures like
      `` ?` `` and `` !` `` (especially in languages with quotations like
      German), and similar ligature issues.  (See jgm/citeproc#54.)

  * Text.Pandoc.CSV:

    + Fix parsing of unquoted values (#7112).  Previously we didn't allow
      unescaped quotes in unquoted values, but they are allowed
      in CSV.

  * Test suite:

    + Use a more robust method for testing the executable.  Many
      of our tests require running the pandoc executable. This
      is problematic for a few different reasons. First,
      cabal-install will sometimes run the test suite after
      building the library but before building the executable,
      which means the executable isn't in place for the tests.
      One can work around that by first building, then building
      and running the tests, but that's fragile.  Second, we
      have to find the executable. So far, we've done that using
      a function `findPandoc` that attempts to locate it
      relative to the test executable (which can be located
      using findExecutablePath).  But the logic here is delicate
      and work with every combination of options.  To solve both
      problems, we add an `--emulate` option to the
      `test-pandoc` executable.  When `--emulate` occurs as the
      first argument passed to `test-pandoc`, the program simply
      emulates the regular pandoc executable, using the rest of
      the arguments (after `--emulate`). Thus, `test-pandoc
      --emulate -f markdown -t latex` is just like `pandoc -f
      markdown -t latex`.  Since all the work is done by library
      functions, implementing this emulation just takes a couple
      lines of code and should be entirely reliable.  With this
      change, we can test the pandoc executable by running the
      test program itself (locatable using `findExecutablePath`)
      with the `--emulate` option. This removes the need for the
      fragile `findPandoc` step, and it means we can run our
      integration tests even when we're just building the
      library, not the executable.  [Note: part of this change
      involved simplifying some complex handling to set
      environment variables for dynamic library paths.  I have
      tested a build with `--enable-dynamic-executable`, and it
      works, but further testing may be needed.]
    + Print accurate location if a test fails (Albert
      Krewinkel).  Ensures that tasty-hunit reports the location
      of the failing test instead of the location of the helper
      `test` function.

  * Documentation: Update URLs and use `https` where possible (#7122,
    Salim B).

  * Add `doc/libraries.md`, a description of libraries that support pandoc.

  * MANUAL.txt

    + MANUAL: block-level formatting is not allowed in line blocks (#7107).
    + Clarify `tex_math_dollars` extension.  Note that no blank lines
      are allowed between the delimiters in display math.
    + Add MANUAL section on reproducible builds.
    + Document no template fallback for absolute path (#7077, Nixon
      Enraght-Moony.)
    + Improve docs for cite-method.
    + Update README and man page.

  * Makefile: in `make bench`, create CSV files for comparison and compare
    against previous benchmark run.  Add timestamp to CSV filenames.

  * cabal.project: don't explicitly set -trypandoc.
    If we do, this can't be overridden on the cabal command line.

  * doc/lua-filters.md: improve documentation for
    `pandoc.mediabag.insert`, `pandoc.mediabag.fetch`,
    `directory`, `normalize` (Albert Krewinkel).

  * Allow base64-bytestring-1.2.* (Dmitrii Kovanikov)

  * Require jira-wiki-markup 1.3.3 (Albert Krewinkel)

  * Require citeproc 0.3.0.8, which correctly titlecases when titles
    contain non-ASCII characters.

  * Use skylighting 0.10.4.  This version of skylighting uses xml-conduit
    rather than hxt. This speeds up parsing of XML syntax definitions
    fourfold, and removes four packages from pandoc's dependency graph:
    hxt-charproperties, hxt-unicode, hxt-regex-xmlschema, hxt.

  * Add script `tools/parseTimings.pl` to help pin down which
    modules take the most time and memory to compile.

  * Avoid unnecessary use of NoImplicitPrelude pragma (#7089) (Albert
    Krewinkel)

  * Benchmarks

    + Use the lighter-weight tasty-bench instead of criterion.
    + Run writer benchmarks for binary formats too.
    + Alphabetize benchmarks.
    + Don't run benchmarks for bibliography formats
      (yet; we need a special input for them).
    + Show allocation data
    + Clean up benchmark code.
    + Allow specifying patterns using `-p blah'.

  * trypandoc: add 2 second timeout.

  * Use `-split-sections` in creating linux release binary.
    This reduces executable size significantly (by about 30%).

  * Remove `weigh-pandoc`.  It's not really useful any more, now that our
    regular benchmarks include data on allocation.

  * Improve linux package build process and add script to
    automate building an arm64 binary package.


## pandoc 2.11.4 (2021-01-22)

  * Add `biblatex`, `bibtex` as output formats (closes #7040).

  * Recognize more extensions as markdown by default (#7034):
    `mkdn`, `mkd`, `mdwn`, `mdown`, `Rmd`.

  * Implement defaults file inheritance (#6924, David Martschenko).
    Allow defaults files to inherit options from other defaults files by
    specifying them with the following syntax:
    `defaults: [list of defaults files or single defaults file]`.

  * Fix infinite HTTP requests when writing epubs from URL source (#7013).
    Due to a bug in code added to avoid overwriting the cover image
    if it had the form `fileX.YYY`, pandoc made an endless sequence
    of HTTP requests when writing epub with input from a URL.

  * Org reader:

    + Allow multiple pipe chars in todo sequences (Albert Krewinkel, #7014).
      Additional pipe chars, used to separate "action" state from "no further
      action" states, are ignored. E.g., for the following sequence, both
      `DONE` and `FINISHED` are states with no further action required:
      `#+TODO: UNFINISHED | DONE | FINISHED`.
    + Restructure output of captioned code blocks (Albert Krewinkel, #6977).
      The Div wrapper of code blocks with captions now has the class
      "captioned-content". The caption itself is added as a Plain block
      inside a Div of class "caption". This makes it easier to write filters
      which match on captioned code blocks. Existing filters will need to be
      updated.
    + Mark verbatim code with class `verbatim` (Dimitri Sabadie, #6998).

  * LaTeX reader:

    + Handle `filecontents` environment (#7003).
    + Put contents of unknown environments in a Div when `raw_tex` is not
      enabled (#6997). (When `raw_tex` is enabled, the whole environment is
      parsed as a raw block.) The class name is the name of the environment.
      Previously, we just included the contents without the surrounding Div,
      but having a record of the environment's boundaries and name can be
      useful.

  * Mediawiki reader:

    + Allow space around storng/emph delimiters (#6993).

  * New module Text.Pandoc.Writers.BibTeX, exporting
    writeBibTeX and writeBibLaTeX. [API change]

  * LaTeX writer:

    + Revert table line height increase in 2.11.3 (#6996).
      In 2.11.3 we started adding `\addlinespace`, which produced less dense
      tables.  This wasn't an intentional change; I misunderstood a comment in
      the discussion leading up to the change. This commit restores the earlier
      default table appearance.  Note that if you want a less dense table, you
      can use something like `\def\arraystretch{1.5}` in your header.

  * EPUB writer:

    + Adjust internal links to identifiers defined in raw HTML sections
      after splitting into chapters (#7000).
    + Recognize `Format "html4"`, `Format "html5"` as raw HTML.
    + Adjust internal links to images, links, and tables after splitting into
      chapters. Previously we only did this for Div and Span and Header
      elements (see #7000).

  * Ms writer:

    + Don't justify text inside table cells.

  * JATS writer:

    + Use `<element-citation>` if `element_citations`
      extension is enabled (Albert Krewinkel).
    + Fix citations (Albert Krewinkel, #7018).  By default
      we use formatted citations.
    + Ensure that `<disp-quote>` is always wrapped in `<p>` (#7041).

  * Markdown writer:

    + Cleaned up raw formats.  We now react appropriately
      to `gfm`, `commonmark`, and `commonmark_x` as raw formats.

  * RST writer:

    + Fix bug with dropped content from inside spans with a class in
      some cases (#7039).

  * Docx writer:

    + Handle table header using styles (#7008).  Instead of hard-coding
      the border and header cell vertical alignment, we now let this
      be determined by the Table style, making use of Word's
      "conditional formatting" for the table's first row.  For
      headerless tables, we use the tblLook element to tell Word
      not to apply conditional first-row formatting.

  * Commonmark writer:

    + Implement start number on ordered lists (#7009).  Previously they always
      started at 1, but according to the spec the start number is respected.

  * HTML writer:

    + Fix implicit_figure at end of footnotes (#7006).

  * ConTeXt template: Remove `\setupthinrules` from default template.
    The width parameter this used is not actually supported,
    and the command didn't do anything.

  * Text.Pandoc.Extensions:

    + Add `Ext_element_citations` constructor (Albert Krewinkel).

  * Text.Pandoc.Citeproc.BibTeX: New unexported function
    `writeBibtexString`.

  * Text.Pandoc.Citeproc:

    + Use finer grained imports (Albert Krewinkel).
    + Factor out and export `getStyle` [API change].
    + Export `getReferences` [API change, #7106].
    + Factor out getLang.

  * Text.Pandoc.Parsing: modify `gridTableWith'` for headerless tables.
    If the table lacks a header, the header row should be an empty
    list. Previously we got a list of empty cells, which caused
    an empty header to be emitted instead of no header.  In LaTeX/PDF
    output that meant we got a double top line with space between.

  * ImageSize:  use `viewBox` for SVG if no length, width attributes (#7045).
    This change allows pandoc to extract size information from more SVGs.

  * Add simple default.nix.

  * Use commonmark 0.1.1.3.

  * Use citeproc 0.3.0.5.

  * Update default CSL to use latest chicago-author-date.csl.

  * CONTRIBUTING.md: add note on GNU xargs.

  * MANUAL.txt:

    + Update description of `-L`/`--lua-filter`.
    + Document use of citations in note styles (#6828).

## pandoc 2.11.3.2 (2020-12-29)

  * HTML reader: use renderTags' from Text.Pandoc.Shared (Albert Krewinkel).
    A side effect of this change is that empty `<col>` elements are written
    as self-closing tags in raw HTML blocks.

  * Asciidoc writer: Add support for writing nested tables (#6972, timo-a).
    Asciidoc supports one level of nesting. If deeper tables are to be
    written, they are omitted and a warning is issued.

  * Docx writer: fix nested tables with captions (#6983).
    Previously we got unreadable content, because docx seems
    to want a `<w:p>` element (even an empty one) at the end of
    every table cell.

  * Powerpoint writer: allow arbitrary OOXML in raw inline elements
    (Albert Krewinkel).  The raw text is now included verbatim in the
    output. Previously is was parsed into XML elements, which prevented
    the inclusion of partial XML snippets.

  * LaTeX writer: support colspans and rowspans in tables (#6950,
    Albert Krewinkel).  Note that the multirow package is needed for
    rowspans.  It is included in the latex template under a variable,
    so that it won't be used unless needed for a table.

  * HTML writer: don't include p tags in CSL bibliography entries
    (#6966).  Fixes a regression in 2.11.3.

  * Add `meta-description` variable to HTML templates (#6982). This
    is populated by the writer by stringifying the `description`
    field of metadata (Jerry Sky).  The `description` meta tag will
    make the generated HTML documents more complete and SEO-friendly.

  * Citeproc: fix handling of empty URL variables (`DOI`, etc.).
    The `linkifyVariables` function was changing these to links
    which then got treated as non-empty by citeproc, leading
    to wrong results (e.g. ignoring nonempty URL when empty DOI is present).
    See jgm/citeproc#41.

  * Use citeproc 0.3.0.3.  Fixes an issue in author-only citations when
    both an author and translator are present, and an issue with
    citation group delimiters.

  * Require texmath 0.12.1.  This improves siunitx support in math,
    fixes bugs with `\*mod` family operators and arrays, and avoids
    italicizing symbols and operator names in docx output.

  * Ensure that the perl interpreter used for filters with `.pl`
    extension (wuffi).

  * MANUAL: note that textarea content is never parsed as Markdown
    (Albert Krewinkel).


## pandoc 2.11.3.1 (2020-12-18)

  * Added some missing files to extra-source-files and data
    files, so they are included in the sdist tarball.  Closes #6961.
    Cleaned up some extraneous data and test files, and added
    a CI check to ensure that the test and data files included
    in the sdist match what is in the git repository.

  * Use citeproc 0.3.0.1, which avoids removing nonbreaking
    space at the end of the `initialize-with` attribute. (Some
    journals require nonbreaking space after initials, and this
    makes that possible.)

## pandoc 2.11.3 (2020-12-17)

  * With `--bibliography` (or `bibliography` in metadata), a
    URL may now be provided, and pandoc will fetch the resource.
    In addition, if a file path is provided and it is not
    found relative to the working directory, the resource
    path will be searched (#6940).

  * Add `sourcepos` extension for `commonmark`, `gfm`, `commonmark_x`
    (#4565).  With the `sourcepos` extension set set, `data-pos`
    attributes are added to the AST by the commonmark reader. No other
    readers are affected.  The `data-pos` attributes are put on elements
    that accept attributes; for other elements, an enlosing Div or Span
    is added to hold the attributes.

  * Change extensions for `commonmark_x`: replace `auto_identifiers`
    with `gfm_auto_identifiers` (#6863).  `commonmark_x` never actually
    supported `auto_identifiers` (it didn't do anything), because the
    underlying library implements gfm-style identifiers only.  Attempts
    to add the `auto_identifiers` extension to `commonmark` will now
    fail with an error.

  * HTML reader:

    + Split module into several submodules (Albert Krewinkel).  Reducing
      module size should reduce memory use during compilation.
    + Support advanced table features (Albert Krewinkel):
      block level content in captions, row and colspans,
      body headers, row head columns, footers, attributes.
    + Disable round-trip testing for tables. Information for cell
      alignment in a column is not preserved during round-trips (Albert
      Krewinkel).
    + Allow finer grained options for tag omission (Albert Krewinkel).
    + Simplify list attribute handling (Albert Krewinkel).
    + Pay attention to `lang` attributes on body element (#6938).
      These (as well as `lang` attributes on the html element) should update
      lang in metadata.
    + Retain attribute prefixes and avoid duplicates (#6938).
      Previously we stripped attribute prefixes, reading `xml:lang` as
      `lang` for example. This resulted in two duplicate `lang`
      attributes when `xml:lang` and `lang` were both used.  This commit
      causes the prefixes to be retained, and also avoids invald
      duplicate attributes.

  * Commonmark reader:

    + Refactor `specFor`.
    + Set input name to `""` to avoid clutter in sourcepos output.

  * Org reader:

    + Parse `#+LANGUAGE` into `lang` metadata field (#6845, Albert
      Krewinkel).
    + Preserve targets of spurious links (#6916, Albert
      Krewinkel).  Links with (internal) targets that the reader doesn't
      know about are converted into emphasized text. Information on the
      link target is now preserved by wrapping the text in a Span of class
      `spurious-link`, with an attribute `target` set to the link's
      original target. This allows to recover and fix broken or unknown
      links with filters.

  * DocBook reader:

    + Table text width support (#6791, Nils Carlson).
      Table width in relation to text width is not natively supported
      by docbook but is by the docbook `fo` stylesheets through an XML
      processing instruction, `<?dbfo table-width="50%"?>`.

  * LaTeX reader:

    + Improve parsing of command options (#6869, #6873).
      In cases where we run into trouble parsing inlines til the
      closing `]`, e.g. quotes, we return a plain string with the
      option contents. Previously we mistakenly included the brackets
      in this string.
    + Preserve center environment (#6852, Igor Pashev).
      The contents of the `center` environment are put in a `Div`
      with class `center`.
    + Don't parse `\rule` with width 0 as horizontal rule. These are
      sometimes used as spacers in LaTeX.
    + Don't apply theorem default styling to a figure inside (#6925).
      If we put an image in italics, then when rendering to Markdown
      we no longer get an implicit figure.

  * Dokuwiki reader:

    + Handle unknown interwiki links better (#6932).
      DokuWiki lets the user define his own Interwiki links.  Previously
      pandoc reacted to these by emitting a google search link, which is
      not helpful. Instead, we now just emit the full URL including the
      wikilink prefix, e.g. `faquk>FAQ-mathml`.  This at least gives users
      the ability to modify the links using filters.

  * Markdown writer:

    + Properly handle boolean values in writing YAML metadata (#6388).
    + Ensure that a new csl-block begins on a new line (#6921).
      This just looks better and doesn't affect the semantics.

  * RST writer:

    + Better image handling (#6948).  An image alone in its paragraph
    (but not a figure) is now rendered as an independent image, with an
    `alt` attribute if a description is supplied.  An inline image that
    is not alone in its paragraph will be rendered, as before, using a
    substitution.  Such an image cannot have a "center", "left", or
    "right" alignment, so the classes `align-center`, `align-left`, or
    `align-right` are ignored.  However, `align-top`, `align-middle`,
    `align-bottom` will generate a corresponding `align` attribute.

  * Docx writer:

    + Keep raw openxml strings verbatim  (#6933, Albert Krewinkel).
    + Use Content instead of Element.  This allows us to inject
      raw OpenXML into the document without reparsing it into an
      Element, which is necessary if you want to inject an open
      tag or close tag.
    + Fix bullets/lists indentation, so that the first level is slightly
      indented to the right instead of right on the margin (cholonam).
    + Support bold and italic in "complex script" (#6911).
      Previously bold and italics didn't work properly in LTR
      text.  This commit causes the w:bCs and w:iCs attributes
      to be used, in addition to w:b and w:i, for bold and
      italics respectively.

  * ICML writer:

    + Fix image bounding box for custom widths/heighta (Mauro Bieg, #6936).

  * LaTeX writer:

    + Improve table spacing (#6842, #6860).
      Remove the `\strut` that was added at the end of minipage
      environments in cells.  Replace `\tabularnewline` with
      `\\ \addlinespace`.
    + Improve calculation of column spacing (#6883).
    + Extract table handling into separate module (Albert Krewinkel).
    + Fix bug with nested `csl-` display Spans (#6921).
    + Improve longtable output (#6883).  Don't create minipages for
      regular paragraphs.  Put width and alignment information in the
      longtable column descriptors.

  * OpenDocument writer:

    + Support for table width as a percentage of text width
      (#6792, Nils Carson).
    + Implement Div and Span ident support (#6755, Nils Carson).
      Spans and Divs containing an ident in the Attr will become bookmarks
      or sections with idents in OpenDocument format.
    + Add two extensions, `xrefs_name` and `xrefs_number` (#6774, Nils
      Carlson).  Links to headings, figures and tables inside the
      document are substituted with cross-references that will use the
      name or caption of the referenced item for `xrefs_name` or the
      number for `xrefs_number`.  For the `xrefs_number` to be useful
      heading numbers must be enabled in the generated document and
      table and figure captions must be enabled using for example the
      `native_numbering` extension.  In order for numbers and reference
      text to be updated the generated document must be refreshed.

  * JATS writer:

    + Support advanced table features (Albert Krewinkel).
    + Support author affiliations (#6687, Albert Krewinkel).

  * Docbook writer:

    + Use correct id attribute consistently (Jan Tojnar).
      DocBook5 should always use `xml:id` instead of `id`.
    + Handle admonition titles better (Jan Tojnar).
      Docbook reader produces a `Div` with `title` class for `<title>`
      element within an “admonition” element. Markdown writer then turns
      this into a fenced div with `title` class attribute. Since fenced
      divs are block elements, their content is recognized as a
      paragraph by the Markdown reader. This is an issue for Docbook
      writer because it would produce an invalid DocBook document from
      such AST – the `<title>` element can only contain “inline”
      elements.  Handle this special case separately by unwrapping
      the paragraph before creating the `<title>` element.
    + Add XML namespaces to top-level elements (#6923, Jan Tojnar).
      Previously, we only added `xmlns` attributes to chapter
      elements, even when running with `--top-level-division=section`.
      These namespaces are now added to part and section elements too,
      when they are the selected top-level divisions.
      We do not need to add namespaces to documents produced with
      `--standalone` flag, since those will already have xmlns attribute on
      the root element in the template.

  * HTML writer:

    + Fix handling of nested `csl-` display spans (#6921).
      Previously inner Spans used to represent CSL display attributes were
      not rendered as div tags as intended.

  * EPUB writer:

    + Include title page in landmarks (#6919).
      Note that the toc is also included if `--toc` is specified.
    + Add frontmatter type on body element for nav.xhtml (#6918).

  * EPUB templates: use preserveAspectRatio="xMidYMid" for cover image (#6895,
    Shin Sang-jae).  This change affects both the epub2 and the epub3
    templates.  It avoids distortion of the cover image by requiring that the
    aspect ratio be preserved.

  * LaTeX template:

    + Include `csquotes` package if `csquotes` variable set.
    + Put back `amssymb`.  We need it for checkboxes in todo lists,
      and maybe for other things.  In this location it seems compatible
      with the cases that prompted #6469 and PR #6762.
    + Disable language-specific shorthands in babel (#6817, #6887).
      Babel defines "shorthands" for some languages, and these can
      produce unexpected results. For example, in Spanish, `1.22`
      gets rendered as `122`, and `et~al.` as `etal`.
      One would think that babel's `shorthands=off` option (which
      we were using) would disable these, but it doesn't.  So we
      remove `shorthands=off` and add some code that redefines
      the shorthands macro.  Eventually this will be fixed in babel,
      I hope, and we can revert to something simpler.

  * JATS template: allow array of persistent institute ids in `pid`
    (Albert Krewinkel).

  * Text.Pandoc.Parsing:  minor code and efficiency improvements.

  * Text.Pandoc.Extension:

    + Add `Ext_sourcepos` constructor for `Extension` [API change].
    + Add `Ext_xrefs_name` and `Ext_xrefs_number` constructors for
      `Extension` (Nils Carson) [API change].

  * Text.Pandoc.Citeproc:

    + Fix truncation of `[Citation]` list in `Cite` inside footnotes (#6890).
      This affected author-in-text citations in footnotes.  It didn't cause
      problems for the printed output, but for filters that expected the
      citation id and other information.
    + Allow the use of both inline and external references (#6951),
      as with pandoc-citeproc.  References defined in the document's
      metadata take priority over references with the same id defined in
      an external bibliography.
    + Use `fetchItem` to get external bibliography (#6940).
    + Ensure that BCP47 lang codes can be used.  We ignore the variants
      and just use the base lang code and country code when passing off
      to citeproc.
    + Citeproc BibTeX parser: revert change in `getRawField`
      which was made (for reasons forgotten) when transferring
      this code from pandoc-citeproc.  The change led to `--` in
      URLs being interpreted as en-dashes, which is unwanted (#6874).

  * Text.Pandoc.ImageSize:

    + Default to DPI 72 if the format specifies DPI of 0 (#6880).
      This shouldn't happen, in general, but it can happen with
      JPEGs that don't conform to the spec.  Having a DPI of 0
      will blow up size calculations (division by 0).
    + ImageSize: use JuicyPixels to determine size for png, jpeg, and
      gif, instead of doing our own binary parsing (#6936). This
      gives more reliable results.

  * Text.Pandoc.CSS:

    + Remove `foldOrElse` (internal module) (Albert Krewinkel).

  * Use skylighting 0.10.2 (#6625).

  * Use citeproc 0.3. This fixes issues with references with
    duplicate ids (jgm/citeproc#36).

  * Use doctemplates 0.9.  This fixes issues with boolean
    metadata values in the Markdown writer (#6388)
    and in `meta-json` (#6650).  It also fixes
    issues with nested for loops in templates.

  * Add translations zh-Hans.yaml and zh-Hant.yaml (#6904, #6909,
    Kolen Cheung, taotieren).

  * Add tests: True to cabal.project.
    This fixes some CI failures for cabal.

  * Normalize test/tables/*.native (#6888, Kolen Cheung).

  * Move executable to `app` directory to avoid problems with cabal repl.

  * CONTRIBUTING: add section "How can I help?" (#6892, Albert Krewinkel).
    Also adds a paragraph aimed at highlighting the importance of feature
    maintenance.

  * MANUAL: Document that --number-sections works in `ms` (#6935).


## pandoc 2.11.2 (2020-11-19)

  * Default to using ATX (`##`-style) headings for Markdown output
    (#6662, Aner Lucero).  Previously we used Setext (underlined) headings
    by default for levels 1--2.

  * Add option `--markdown-headings=atx|setext`, and deprecate
    `--atx-headers` (#6662, Aner Lucero).

  * Support `markdown-headings` in defaults files.

  * Fix corner case in YAML metadata parsing (#6823).  Previously YAML
    metadata would sometimes not get recognized if a field ended with a
    newline followed by spaces.

  * `--self-contained`: increase coverage (#6854).
    Previously we only self-contained attributes for certain tag names
    (`img`, `embed`, `video`, `input`, `audio`, `source`, `track`,
    `section`).  Now we self-contain any occurrence of `src`,
    `data-src`, `poster`, or `data-background-image`, on any tag; and
    also `href` on `link` tags.

  * Markdown reader:

    + Fix detection of locators following in-text citations.
      Prevously, if we had `@foo [p. 33; @bar]`, the `p. 33` would be
      incorrectly parsed as a prefix of `@bar` rather than a suffix of
      `@foo`.
    + Improve period suppression algorithm for citations in notes
      in note citation styles (#6835).
    + Don't increment `stateNoteNumber` for example list references.
      This helps with #6836 (a bug in which example list references
      disturb calculation of citation note number and affect when
      `ibid` is triggered).

  * LaTeX reader:

    + Move `getNextNumber` from Readers.LaTeX to Readers.LaTeX.Parsing.
    + Fix negative numbers in siunitx commands.  A change in pandoc 2.11
      broke negative numbers, e.g.  `\SI{-33}{\celcius}` or `\num{-3}`.
      This fixes the regression.

  * DocBook reader: drop period in formalpara title
    and put it in a div with class `formalpara-title`, so that
    people can reformat with filters (#6562).

  * Man reader: improve handling of `.IP` (#6858).  We now better handle
    `.IP` when it is used with non-bullet, non-numbered lists, creating a
    definition list.  We also skip blank lines like groff itself.

  * Bibtex reader: fall back on `en-US` if locale for LANG not found.
    This reproduces earlier pandoc-citeproc behavior (jgm/citeproc#26).

  * JATS writer:

    + Wrap all tables (Albert Krewinkel).
      All `<table>` elements are put inside `<table-wrap>` elements, as the
      former are not valid as immediate child elements of `<body>`.
    + Move Table handling to separate module (Albert Krewinkel).
      Adds two new unexported modules:
      Text.Pandoc.Writers.JATS.Types, Text.Pandoc.Writers.JATS.Table.

  * Org writer:

    + Replace org #+KEYWORDS with #+keywords (TEC).
      As of ~2 years ago, lower case keywords became the standard (though
      they are handled case insensitive, as always).
    + Update org supported languages and identifiers according to the
      current list contained in
      <https://orgmode.org/worg/org-contrib/babel/languages/index.html>
      (TEC).

  * Only use `filterIpynbOutput` if input format is ipynb (#6841).
    Before this change content could go missing from divs with class
    `output`, even when non-ipynb was being converted.

  * When checking reader/writer name, check base name now that we permit
    extensions on formats other than markdown.

  * Text.Pandoc.PDF: Fix `changePathSeparators` for Windows (#6173).
    Previously a path beginning with a drive, like `C:\foo\bar`, was
    translated to `C:\/foo/bar`, which caused problems.
    With this fix, the backslashes are removed.

  * Text.Pandoc.Logging:

    + Add constructor `ATXHeadingInLHS` to `LogMessage` [API change].
    + Add constructor `EnvironmentVariableUndefined` to
      `LogMessage` [API change].

  * Fix error that is given when people specify `doc` output (#6834,
    gison93).

  * LaTeX template:  add a `\break` after parbox in `CSLRightInline`.
    This should fix spacing problems between entries with numeric styles.
    Also fix number of params on `CSLReferences`.

  * reveal.js template: Put quotes around `controlsLayout`,
    `controlsBackArrows`, and `display`, since these require strings.
    Add `showSlideNumber`, `hashOneBasedIndex`, `pause`.

  * Use citeproc 0.2.  This fixes a bug with title case around parentheses.

  * pandoc.cabal: remove 'static' flag.
    This isn't really necessary and can be misleading (e.g. on macOS,
    where a fully static build isn't possible). cabal's new option
    `--enable-executable-static` does the same. On stack you can add
    something like this to the options for your executable in package.yaml:

        ld-options: -static -pthread

  * Remove obsolete bibutils flag setting in `linux/make_artifacts.sh`.

  * Manual:

    + Correct `link-citation` -> `link-citations`.
    + Add a sentence about `pagetitle` for HTML (#6843, Alex Toldaiev).

  * INSTALL.md: Remove references to `pandoc-citeproc` (#6857).

  * CONTRIBUTING: describe hlint and how it's used (#6840, Albert
    Krewinkel).

## pandoc 2.11.1.1 (2020-11-07)

  * Citeproc: improve punctuation in in-text note citations (#6813).
    Previously in-text note citations inside a footnote would sometimes have
    the final period stripped, even if it was needed (e.g. on the end of
    'ibid').

  * Use citeproc 0.1.1.1.  This improves the decision about when
    to use `ibid` in cases where citations are used inside
    a footnote (#6813).

  * Support `nocase` spans for `csljson` output.

  * Require latest commonmark, commonmark-extensions.
    This fixes a bug with `autolink_bare_uris` and commonmark.

  * LaTeX reader: better handling of `\\` inside math in table cells (#6811).

  * DokuWiki writer:  translate language names for code elements
    and improve whitespace (#6807).

  * MediaWiki writer: use `syntaxhighlight` tag instead of deprecated
    `source` for highlighted code (#6810).  Also support `startFrom`
    attribute and `numberLines`.

  * Lint code in PRs and when committing to master (#6790,
    Albert Krewinkel).

  * doc/filters.md: describe technical details of filter invocations (#6815,
    Albert Krewinkel).


## pandoc 2.11.1 (2020-11-03)

  * DocBook Reader: fix duplicate bibliography bug (#6773, Nils Carlson).

  * HTML reader:

    + Parse contents of iframes (#6770).
    + Parse inline svg as image unless `raw_html` is set in the reader (in
      which case the svg is passed through as raw HTML) (#6770).

  * LaTeX reader:

    + Fix bug parsing macro arguments (#6796).  If `\cL` is
      defined as `\mathcal{L}`, and `\til` as `\tilde{#1}`, then
      `\til\cL` should expand to `\tilde{\mathcal{L}}`, but
      pandoc was expanding it to `\tilde\mathcal{L}`.  This is
      fixed by parsing the arguments in "verbatim mode" when the
      macro expands arguments at the point of use.
    + Properly support optional (cite) argument for
      `\blockquote` from `csquotes` (#6802).

  * LaTeX writer: Improved calculation of table column widths.
    We now have LaTeX do the calculation, using `\tabcolsep`.
    So we should now have accurate relative column widths no
    matter what the text width.  The default template has been modified to load
    the calc package if tables are used.

  * HTML writer: Fix duplicate "class" attribute for table
    rows (Andy Morris).

  * Text.Pandoc.Filter: allow shorter YAML representation of Citeproc
    (Albert Krewinkel).  The map-based YAML representation of filters expects
    `type` and `path` fields. The path field had to be present for all filter
    types, but is not used for citeproc filters. The field can now be omitted
    when type is "citeproc", as described in the MANUAL.

  * Text.Pandoc.Error: Add `PandocBibliographyError` constructor
    for `PandocError` [API change].  This ensures that bibliography parsing
    errors generate messages that include the bibliography file name --
    otherwise it can be quite mysterious where it is coming from.

  * Citeproc: properly handle `csl` field with `data:` URI (#6783).
    This is used with the JATS writer, so this fixes a regression
    in pandoc 2.11 with JATS output and citeproc.

  * Allow `citation-abbreviations` in defaults file.

  * JATS templates: ensure `jats_publishing` output is valid
    (Albert Krewinkel).

  * LaTeX template:  Fix `CSLRightInline`, so that it does not
    run over the right margin.

  * HTML template: default CSS tweaks (Mauro Bieg and John
    MacFarlane).

    - Fix margin before codeblock
    - Add `monobackgroundcolor` variable, making the background color
      and padding of code optional.
    - Ensure that backgrounds from highlighting styles take precedence over
      monobackgroundcolor
    - Remove list markers from TOC
    - Add margin-bottom where needed
    - Remove italics from blockquote styling
    - Change borders and spacing in tables to be more consistent with other
       output formats
    - Style h5, h6
    - Set font-size for print media to 12pt.
    - Reduce interline space.
    - Reduce interparagraph space.
    - Reduce line width.
    - Remove the special `line-height: 1` for table cells.
    - Remove the special line-height for pre.
    - Ensure that there is a bit more space before a heading
      than after.
    - Slightly reduced space after title header.
    - Add CSS example to MANUAL

  * man template:  Change comment that triggers `tbl` from
    `.\"t` to `'\" t`, as specified in groff_man(7) (#6803).

  * Use latest commonmark, commonmark-extensions.
    This fixes a bug with nested blocks in footnotes with the
    `footnote` extension to `commonmark`.  See jgm/commonmark-hs#63.

  * Citeproc: use comma for in-text citations inside footnotes.
    When an author-in-text citation like `@foo` occurs in a footnote,
    we now render it with:  `AUTHOR NAME + COMMA + SPACE + REST`.
    Previously we rendered: `AUTHOR NAME + SPACE + "(" + REST + ")"`.
    This gives better results.  Note that normal citations are still
    rendered in parentheses.

  * Use latest citeproc:

    + citeproc no longer capitalizes notes, so we do it
      in pandoc when appropriate.
    + Closes #6783.

  * Clarify manual on `--track-changes` (#6801).

  * Add `doc/jats.md` to document pandoc's handling of JATS
    (#6794, Albert Krewinkel).

  * Fix code example in lua-filters.md (#6795).

## pandoc 2.11.0.4 (2020-10-21)

  * Commonmark writer: fix regression with fenced divs (#6768).
    Starting with 2.10.1, fenced divs no longer render with
    HTML div tags in commonmark output.  This is a regression
    due to our transition from cmark-gfm.  This commit fixes it.

  * Use released version of citeproc.  (This fixes a mis-step
    in the 2.11.0.3 release, which is now deprecated.)

  * Use latest sylighting, with support for `groovy`.

  * Document that --html-q-tags requires the smart extension on the reader
    (#6766).

## pandoc 2.11.0.3 (2020-10-20)

  * Use latest citeproc (closes #6765). This fixes a problem with
    author-in-text citations for references including both an author
    and an editor. Previously, both were included in the text, but only
    the author should be.

  * With `--citeproc`, ensure that the final period is removed when
    citations that occur in notes in note-based styles get put in
    parentheses.  See jgm/citeproc#20.

  * Normalize rewritten image paths with `--extract-media` (#6761).
    This change will avoid mixed paths like this one when
    `--extract-media` is used with a Word file:
    `![](C:\Git\TIJ4\Markdown/media/image30.wmf)`.  Instead we'll get
    `![](C:\Git\TIJ4\Markdown`media`image30.wmf)`.

  * Modify `--version` output.  Use space more efficiently and report the
    citeproc and ipynb versions, along with skylighting, texmath, and
    pandoc-types.  Drop the word "default" before "user data directory."

  * DocBook reader: bibliomisc and anchor support (#6754, Nils Carlson).
    Also ensure that bibliodiv without a title no longer results in
    an empty Header.

  * ConTeXt template: adds `\setupinterlinespace` to fonts larger
    than normal (#6763, Denis Maier).

  * LaTeX template: Do not load amssymb if not needed (#6469, Angelo Peronio).
    See <https://tex.stackexchange.com/a/549938>.

  * Relax upper bound on hslua, allow hslua-1.3.* (Albert Krewinkel).

  * MANUAL:

    + Improve explanation of "indent" variable (#6767, Cyrus Yip).
    + Remove org from list of input formats supporting raw_tex (#6753,
      Nick Fleisher).


## pandoc 2.11.0.2 (2020-10-15)

  * Fix handling of `xdata` in bibtex/biblatex bibliographies (#6752).

  * Fix some small typos in the API documentation (#6751, Michael Hoffmann).

  * Require citeproc 0.1.0.2.  This fixes a regression from pandoc-citeproc
    involving spacing between components of a reference in certain styles
    (e.g. `cell.csl`).

  * Fix typos in comments, doc strings, error messages, and tests
    (Albert Krewinkel, #6738).

## pandoc 2.11.0.1 (2020-10-13)

  * LaTeX reader: support more acronym commands (#6746):
    `\acl`, `\aclp`, and capitalized versions of already
    supported commands.

  * Commonmark reader: add `pipe_table` extension *after* defaults (#6739).
    Otherwise we get bad results for non-table, non-paragraph
    lines containing pipe characters.

  * Markdown writer: Fix autolinks rendering for gfm (#6740).
    Previously, autolinks rendered as raw HTML, due to the
    `class="uri"` added by pandoc's markdown reader.

  * LaTeX writer:

    + Escape option values in lstlistings environment (#6742).
    + Fix handling of `lang` `pt-BR` (#2953).  For polyglossia we now
      use `\setmainlanguage[variant=brazilian]{portuguese}` and for babel
      `\usepackage[shorthands=off,main=brazilian]{babel}`.

  * Depend on latest citeproc (0.1.0.1).

    + This fixes the citation number issue with ieee.csl and other
      styles that do not explicitly sort bibliographies (#6741). (Pandoc
      was numbering them by their order in the bibliography file,
      rather than the order cited, as required by the CSL spec.)
    + Fixes groupin/collapsing with citation items with prefixes.

  * default.latex: fix `CSLReference` macro definition.

  * Fix MANUAL.txt CSL JSON conversion examples.

  * Fix spelling errors in changelog, MANUAL.txt, `doc/org.md` (#6738).


## pandoc 2.11 (2020-10-11)

  * Add `--citeproc` (`-C`) option to trigger built-in citation processing.
    It is no longer necessary to use the external `pandoc-citeproc`
    filter.  `--citeproc` behaves like a filter and can be positioned
    relative to other filters as they appear on the command line.

    The new built-in citation processing uses the citeproc library,
    a reimplementation of CSL citation processing that fixes many
    of the shortcomings of pandoc-citeproc.  In general, citation
    processing should work much the same as it did with pandoc-citeproc,
    but with greater fidelity to CSL styles and better performance.
    (The tests from the pandoc-citeproc package have been carried
    over to pandoc.) The following differences should be noted:

    - At this point, only some of the writers (HTML, ms, LaTeX) properly
      interpret CSL display styles.  You should get decent output in
      all formats (at least as good as with pandoc-citeproc), but
      indentation and block-alignment may not be right.

    - pandoc-citeproc searches the `~/.csl` directory for `.csl`
      styles.  Pandoc instead searches the `csl` subdirectory of
      the pandoc user data directory (e.g., `~/.pandoc/csl` or
      `~/.local/share/pandoc/csl`).  Users who already keep
      CSL styles in `~/.csl` may find it convenient to add a
      symlink.

    - Some of the bibliography formats supported by pandoc-citeproc (via
      hs-bibutils) are no longer supported:  Copac, EndNote,
      ISI, MEDLINE, MODS, and RIS.  If you use one of these formats,
      you may use the `bibutils` utility to convert to BibLaTeX.
      We now support only BibTeX, BibLaTeX, CSL JSON,
      and pandoc's YAML/Markdown analogue of CSL JSON.

    - pandoc-citeproc would always retrieve the independent parent
      of a dependent style by doing an HTTP request.  pandoc will
      now first seek the independent parent locally (in the resource
      path or in the `csl` subdirectory of the pandoc user data
      directory) before resorting to HTTP.  In addition, you may
      omit the `.csl` extension, e.g. `--csl zoology`.

    - Using the `--bibliography` option (or including
      `bibliography` in YAML metadata) no longer triggers
      citation processing implicitly: one must always use the
      `--citeproc` option if citation processing is wanted.

  * Add `csljson` as and input and output format. This allows pandoc
    to convert between `csljson` and other bibliography formats
    (e.g. `-f csljson -t markdown -s` or `-f bibtex -t csljson`),
    and to generate formatted versions of CSL JSON bibliographies
    (e.g., `pandoc -f csljson --citeproc pl.json -o pl.pdf`).

  * Added `bibtex`, `biblatex` as input formats.  This allows pandoc
    to convert between BibLaTeX and BibTeX and other bibliography formats,
    and to generated formatted versions of BibTeX/BibLaTeX bibliographies
    (e.g., `pandoc -f biblatex --citeproc pl.bib -o pl.pdf`).

  * Raise informative errors when YAML metadata parsing fails (#6730).
    Previously the command would succeed, returning empty metadata,
    with no errors or warnings.

  * Sort languages in `--list-highlight-languages` output (#6718,
    Albert Krewinkel).  Languages were previously sorted by their
    long name, which leads to unexpected results).

  * Add CSS to default HTML template (#6601, Mauro Bieg).  This
    greatly improves the default typography in pandoc's HTML
    output.  The CSS is sensitive to a number of variables
    (e.g. `mainfont`, `fontsize`, `linestretch`): see the manual for
    details. To restore the earlier, more spartan output, you can
    disable this with `-M document-css=false`.

  * Support `--toc-depth` option for ODT writer (#6696, niszet).

  * Fix issues with Windows UNC paths with some options (#5127).

  * Remove `fenced_code_blocks` and `backtick_code_blocks` from allowed
    `commonmark` and `gfm` extensions.  These shouldn't really be counted
    as extensions, because they can't be disabled in commonmark.
    Adjust markdown writer to check for the commonmark variant in addition
    to extensions.

  * Add these extensions to `gfm` and `commonmark`:
    `fenced_code_blocks`, `backtick_code_blocks`, `fenced_code_attributes`.
    These can't really be disabled in the reader, but they need to be enabled
    in the writer or we just get indented code.

  * Make sure proper set of extensions is recognized for `commonmark_x`.

  * Allow `gfm_auto_identifiers`, `ascii_identifiers` extensions for `docx`.

  * Markdown reader:

    + Add `Maybe FilePath` parameter to `yamlToMeta` [API change].
    + Export `yamlToRefs` [API change], a version of `yamlToMeta`
      specialized to references.
    + Set `citationNoteNum` accurately in citations.
    + Revise abbreviation support.  Don't insert a nonbreaking space after a
      potential abbreviation if it comes right before a note or citation.
      This causes problems for citeproc's moving of note citations.

  * LaTeX reader:

    + Support missing siunitx commands (#6658).
    + Support `squared`, `cubed`, `tothe` in siunitx (#6657).
    + Improved uncertainty handling in slunitx.
    + Factored out siunitx stuff into separate unexposed module.
    + Fix improper empty cell filtering (#6689, Christian Despres).
    + Fix parsing of "show name" in `\newtheorem` (#6734).
      Previously we were just treating it as a string and
      ignoring  accents and formatting.
    + Prevent wrong nesting of `\multirow` and `\multicolumn` table
      cells (#6603, Laurent P. René de Cotret).
    + Table cell parser not consuming spaces correctly (#6596,
      Laurent P. René de Cotret).
    + Change `SIRange` to `SIrange` (#6617, Emerson Harkin).
    + Allow blank lines inside `\author` (#6324).

  * DocBook reader:

    + Don't squelch space at end of emphasis and other inline elements;
      instead, move it outside the element (#6719).
    + Implement table cell alignment (#6698, Nils Carlson).
    + Implement column span support for tables (#6492, Nils Carlson).
    + Update list of block level tags (#6610).


  * JATS reader:

    + Don't squelch space at end of emphasis and other inline elements;
      instead, move it outside the element (#6719).

  * RST reader:

    + Apply `.. class::` directly to following Header rather than creating
      a surrounding Div (#6699).

  * Docx reader:

    + Allow empty dates in comments and tracked changes (#6726, Diego
      Balseiro).

  * Markdown writer:

    + Be less aggressive about using quotes for YAML values,
      allowing e.g. a quotation mark or bracket as long as it's not at the
      beginning of the line.
    + Use double quotes for YAML metadata (#6727).
    + Sort YAML metadata keys in Markdown output case-insensitive.


  * Asciidoc writer:

    + Support asciidoctor's block figures (#6538, argent0).

  * LaTeX writer:

    + Fix spacing issue with list in definition list.
      When a list occurs at the beginning of a definition list definition,
      it can start on the same line as the label, which looks bad.
      Fix that by starting such lists with an `\item[]`.

  * HTML writer:

    + Support intermediate table headers (#5314, Albert Krewinkel).
    + Support attributes on all table elements (Albert Krewinkel).
    + Render table footers if present (#6314, Albert Krewinkel).
    + Fix addition of `doc-biblioentry` role.
    + Support colspans and rowspans in HTML tables (#6312, Albert Krewinkel).

  * ICML writer:

    + Support internal document links (#5541, Leonard Rosenthol).
    + Changed default link state to invisible (#6676, Leonard Rosenthol).

  * Docx writer:

    + Better handle list items whose contents are lists (#5948, Michael
      Hoffmann).  If the first element of a bulleted or ordered list is
      another list, then that first item would previously disappear if the
      target format is docx.
    + Separate adjacent tables (#4315).  Word combines adjacent tables,
      so to prevent this we insert an empty paragraph between two
      adjacent tables.

  * Org writer:

    + Don't force blank line after headings (#6554).

  * OpenDocument writer:

    + Implement table cell alignment (#6700 Nils Carson, Mauro Bieg).
    + New table cell support with row and column spans (#6682, Nils Carson).
    + Syntax highlighting for inline code (#6711, niszet).

  * Add Text.Pandoc.Citeproc module, exporting `processCitations`
    [API change].  This depends on several other, unexported
    modules under Text.Pandoc.Citeproc.

  * Add module Text.Pandoc.Writers.CslJson, exporting `writeCslJson`.
    [API change]

  * Add module Text.Pandoc.Readers.CslJson, exporting `readCslJson`.
    [API change]

  * Add module Text.Pandoc.Readers.BibTeX, exporting `readBibTeX` and
    `readBibLaTeX`. [API change]

  * Text.Pandoc.Filter: Add `CiteprocFilter` constructor to Filter.
    [API change] This runs the processCitations transformation.
    We need to treat it like a filter so it can be placed
    in the sequence of filter runs (after some, before others).
    In FromYAML, this is parsed from `citeproc` or `{type: citeproc}`,
    so this special filter may be specified either way in a defaults file
    (or by `citeproc: true`, though this gives no control of positioning
    relative to other filters).

  * Add new exported module Text.Pandoc.Writers.AnnotatedTable [API change]
    (#6655, Christian Despres).  This module (which should generally
    be imported qualified to avoid name conflicts) provides a
    `Table` type that mirrors the structure of a pandoc `Table`,
    but with added inferred information so that the writers do not have to
    lay out tables themselves. The `toTable` and `fromTable` functions convert
    between an annotated `Table` and a regular pandoc `Table`. In addition to
    producing a `Table` with coherent and well-formed annotations, the
    `toTable` function also normalizes its input table like the table
    builder does.  Tests ensure that `toTable` normalizes tables exactly
    like the table builder, and that its annotations are coherent.

  * Text.Pandoc.Logging:

    + Remove unused `CouldNotParseYamlMetadata` constructor for `LogMessage`
      [API change].
    + Add `CiteprocWarning` constructor to `LogMessage` [API change].

  * Text.Pandoc.Readers.Metadata: export `yamlBsToRefs` [API change].
    These allow specifying an id filter so we parse only references
    that are used in the document.

  * Text.Pandoc.Parsing:

    + Export ParseError [API change].
    + Add `stateInNote` and `stateNoteNumber` to `ParserState`
      [API change].  These are used to populate note numbers for citation
      processing.

  * Fix apparent typos in sample.lua (#6729, William Lupton).
    Also make the writer less aggressive in escaping quotes.

  * Text.Pandoc.Options:

    + `defaultMathJaxURL`: use `tex-chtml-full` instead of `tex-mml-chtml`
      (#6599, Kolen Cheung).  This drops the MathML support (which we
      don't need for HTML math rendering) and includes the full JavaScript,
      which makes it possible to use `--self-contained` (though there may
      still be issues if the required math fonts aren't available).  This
      change should also reduce latency in pages with lots of formulas.
    + Add `/tex-chtml-full.js` to `defaultMathJaxURL` (#6593) Previously we
      added this in processing command line options, but not in processing
      defaults files, which was inconsistent.

  * epub.css: Fix cover page selectors and add note explaining their use
    (#6649, a-vrma).

  * Add data files needed for Text.Pandoc.Citeproc:  these include
    `default.csl` in the data directory and a `citeproc` directory that
    is only used at compile-time for biblatex localizations.  Note that we've
    added `file-embed` as a mandatory rather than a conditional
    dependency, because of the biblatex localization files.

  * Lua filters:

    + Add SimpleTable for backwards compatibility (#6575, Albert Krewinkel).
      A new type `SimpleTable` is made available to Lua filters. It is
      similar to the `Table` type in pandoc versions before 2.10;
      conversion functions from and to the new Table type are provided.
      Old filters using tables now require minimal changes and can use, e.g.,

          if PANDOC_VERSION > {2,10,1} then
            pandoc.Table = pandoc.SimpleTable
          end

      and

          function Table (tbl)
            tbl = pandoc.utils.to_simple_table(tbl)
            …
            return pandoc.utils.from_simple_table(tbl)
          end

      to work with the current pandoc version.

    + Make `attr` argument optional in `Table` constructor (Albert Krewinkel).
      This changes the Lua API. It is highly unlikely for this change to affect
      existing filters, since the documentation for the new Table constructor
      (and type) was incomplete and partly wrong before.  The Lua API is now
      more consistent, as all constructors for elements with attributes now
      take attributes as the last parameter.

  * MANUAL.txt:

    * Add a dedicated Citations section which consolidates the information
      the manual used to contain about citation processing, and incorporates
      some information formerly found in the pandoc-citeproc man page.
    + Add note about lualatex using `selnolig`.
    + Remove duplicate `seriespage` (#6568, Blake Eryx).
    + Remove lists of support extensions for markdown variants (#6604).
      Instead, offer the advice to use `--list-extensions=FORMAT`.
    + Fix position of attributes in header (Albert Krewinkel).
    + Delete obsolete section on compact and loose lists (#6684).


  * doc/lua-filters.md:

    + Add info on how to debug Lua filters (#6732, Ian Max Andolina).
    + Document Underline type and constructor (Albert Krewinkel).
    + Document `body` field (Albert Krewinkel).
    + Add missing header attribute
    + Add missing Link.title field (Albert Krewinkel).
    + Make the setting-the-date example conditional (the-solipsist).
      This makes the example a bit more realistic.
    + Remove outdated link table example.

  * doc/org.md:

    + Add section on tables (Albert Krewinkel).
    + Add section on handling of unknown directives (Albert Krewinkel).

  * CONTRIBUTING.md: fix typo (#6584, Dmitry Volodin).

  * Use golden test framework for command tests.  This means that
    `--accept` can be used to update expected output.

  * Use the `smart` extension when generating pandoc's man page (#6613).

  * Release-candidate: don't build windows i386.
    So far we haven't been able to figure out how to get
    stack to use a 32-bit ghc.

  * Use `null` instead of deprecated `Builder.isNull`.

  * Makefile:

    + Fix macospkg target to fetch target from S3 artifacts.
    + Fix pandoc-templates target to include all partials.

  * Remove duplicated dependency in pandoc.cabal (#6591, Felix Yan).

  * Sort build depends in pandoc.cabal alphabetically (#6691,
    Albert Krewinkel).

  * Add .travis.yml for macos release candidate build (#6622).
    We need to build the release candidate on Travis rather
    than GitHub actions, because GH has macos 10.15, and
    binaries compiled on that OS will not work with 10.13.
    This build is only triggered on `rc/*` branches.

  * Remove instructions for building pandoc-citeproc from CI and
    release binary build instructions.  We will no longer distribute
    pandoc-citeproc.

  * Fix math rendering in trypandoc (this broke after
    commit d8ad766d17603784b86fc5c2e1b22864125d04d1).

  * Use latest versions of skylighting, commonmark (#6589),
    comonmark-extensions, commonmark-pandoc, texmath.

  * Relax version bounds for hslua, hslua-module-text, bytestring.

  * Use released pandoc-types 1.22.  This changes the JSON
    encoding slightly for the new table types introduced
    in 1.21, so they're more consistent with the rest.
    Developers of libraries for pandoc filters will want
    to take note.

  * Fix hlint suggestions, update hlint.yaml (#6680, Christian Despres).

  * Code cleanup (#6678, Joseph C. Sible).

  * Add haddocks to functions in Text.Pandoc.Writers.Shared (Albert
    Krewinkel).

  * Remove duplicate `tshow` definition.

  * Linux release candidate build: use ghc-musl container.  This simplifies
    our build process (over using a customized alpine container).


## pandoc 2.10.1 (2020-07-23)

  * Add `commonmark_x` output format. This is `commonmark` with a number
    of useful pandoc extensions enabled.

  * Many more extensions now work with `commonmark` and `gfm`.

  * Add generic `attributes` extension.  This allows attributes to
    be added to any block or inline element in a uniform way.  Since
    the Pandoc AST doesn't include attributes on each element type,
    the attributes will sometimes be added by creating a surrounding
    Div or Span container.  Currently this extension is only
    compatible with the `commonmark` and `gfm` readers.

    To add an attribute to a block-level element, e.g. a paragraph,
    put it before the block:
    ```
    {#mypara}
    This is a paragraph.
    ```
    Multiple attributes may be used and will be combined:
    ```
    {#mypara}
    {.blue .warning key="val"}
    This is a paragraph.
    ```
    To add an attribute to an inline-level element, put it
    immediately after the element:
    ```
    *emphasized text*{.special}
    ```

  * Support `--number-sections` for docx output (#1413).

  * LaTeX reader:

    + Support `\SIRange` reader (#6418, Emerson Harkin).
    + Support table col-span and row-span (#6311, Laurent P. René de Cotret).
      Supports `\multirow` and `\multicolumn`.
    + Support amsthm:  `\newtheorem`, `\theoremstyle`, and theorem and
      proof environments, including labels and references.  The only thing
      that is unsupported is the second optional argument, which causes
      numbering to be reset after the specified series is incremented.
    + Moved some code to T.P.LaTeX.Parsing.  We need to reduce the size
      of the LaTeX reader to ease compilation on resource-limited systems.

  * RST reader:

    + Fix csv tables with multiline cells (#6549).
    + Fix spurious newlines in some attributes from directives.
    + Avoid extra newline in included code blocks.

  * Commonmark reader:

    + Switch from cmark-gfm to commonmark-hs for commonmark and gfm
      parsing.  This avoids depending on a C library
      and allows us to support more pandoc extensions for
      `commonmark` and `gfm`.

  * DocBook reader:

    + Parse releaseinfo as metadata (#6542).

  * Docx reader:

    + Only use `bCs/iCs` on runs with `rtl` or `cs` property (#6514, Nikolay
      Yakimov).
    + Code cleanup/refactoring (Nikolay Yakimov).

  * Org reader (Albert Krewinkel):

    + Respect export setting which disables entities
      MathML-like entities, e.g., `\alpha`, can be disabled with the
      `#+OPTION: e:nil` export setting (Albert Krewinkel).
    + Respect export setting disabling footnotes.  Footnotes can be removed
      from the final document with the `#+OPTION: f:nil` export setting.
    + Respect tables-excluding export setting.  Tables can be removed from
      the final document with the `#+OPTION: |:nil` export setting.

  * Markdown writer:

    + Move `asciify` out of `escapeString`.  Otherwise `unsmartify`
      doesn't catch quotes that have already been turned to entities.
    + Add `writeCommonmark` (new exported function, API change).
    + Use unicode super/subscript characters when possible if the
      `superscript` or `subscript` extension or `raw_html` aren't available.
    + Render caption as following paragraph when `table_caption` extension
      is not enabled.
    + Use numerical labels for reference links that are longer
      than 999 characters or contain square brackets, for conformity
      with commonmark (#6560).

  * Commonmark writer:

    + Instead of using cmark-gfm, use `writeCommonmark` from the
      Markdown writer.  This function calls the markdown writer
      with appropriate extensions and a few small modifications
      (e.g. not requiring backslashes before spaces inside
      super/subscripts).  With this change `comonmark` and
      `gfm` output can be used with a wider selection of
      extensions.

  * Jira writer: keep image caption as alt attribute (#6529, Albert
    Krewinkel).

  * HTML writer:

    + Improve alt-text/caption handling for HTML5 (#6491, Albert Krewinkel).
      Screen readers read an image's `alt` attribute and the figure caption,
      both of which come from the same source in pandoc. The figure caption is
      hidden from screen readers with the `aria-hidden` attribute. This
      improves accessibility.  For HTML4, where `aria-hidden` is not allowed,
      pandoc still uses an empty `alt` attribute to avoid duplicate contents.

  * Ms writer:

    + Fix code highlighting with blank lines.  Previously blank lines
      were simply omitted from highlighted code.
    + Escape starting periods in ms writer code blocks (#6505, Michael
      Hoffmann).  If a line of ms code block output starts with a period (.),
      it should be prepended by `\&` so that it is not interpreted as a roff
      command.

  * Text.Pandoc.Extensions:

    + Add `raw_markdown` extension (which only affects `ipynb`
      input).
    + Trim down `githubMarkdownExtensions`.
      Previously it included all of the following, which make
      sense for the legacy `markdown_github` but not for `gfm`,
      since they are part of base commonmark and thus
      can't be turned off in `gfm`:

      - `Ext_all_symbols_escapable`
      - `Ext_backtick_code_blocks`
      - `Ext_fenced_code_blocks`
      - `Ext_space_in_atx_header`
      - `Ext_intraword_underscores`
      - `Ext_lists_without_preceding_blankline`
      - `Ext_shortcut_reference_links`

      These have been removed from `githubMarkdownExtensions`, though
      they're still turned on for legacy `markdown_github`.
    + Add `Ext_attributes` constructor for `Extension` [API change].

  * LaTeX template: use selnolig to selectively suppress ligatures with
    lualatex (#6534).

  * Benchmark bytestring readers (Nikolay Yakimov).

  * Documentation:

    + Update using-the-pandoc-api.md (favonia).
    + Fix Typos in lua-filters.md (tajmone).
    + Rewrite Raw HTML/TeX section in MANUAL.txt to avoid duplicate
      headings for the extensions.
    + Fix typo in MANUAL.txt (Benjamin Wuethrich).
    + Remove duplicate 'titlepage' in MANUAL.txt (Blake Eryx).
    + CONTRIBUTING.md: Advertise the official nightlies in GitHub actions.
      Replaces #6500, thanks to @ickc.



## pandoc 2.10 (2020-06-29)

  * Use pandoc-types 1.21.  This adds two things:

    + A native Underline constructor for Inline (#6277, Vaibhav Sagar).
    + More expressive types for tables (#1024, Christian Despres).
      Tables can now take attributes; and rowspans and colspans,
      column headers, multiple row headers, table head and foot
      can all be represented.  (Note, however, that reader and
      writer support for these features is still lacking, so
      most users won't see any differences in table conversion
      yet.  These changes just lay the foundation for further
      improvements.)

  * Support new Underline element in readers and writers (#6277,
    Vaibhav Sagar).

  * Support new Table type (Christian Despres).
    The Builder.simpleTable now only adds a row to the TableHead
    when the given header row is not null. This uncovered an
    inconsistency in the readers: some would unconditionally
    emit a header filled with empty cells, even if the header
    was not present. Now every reader has the conditional
    behaviour.  Only the XWiki writer depended on the header row
    being always present; it now pads its head as necessary.

  * Add an option to disable certificate validation (#6156, Cédric Couralet,
    Cécile Chemin, Juliette Fourcot).  This commit adds the option
    `--no-check-certificate`, which disables certificate checking when
    resources are fetched by HTTP.

  * Unify defaults and markdown metadata parsers (#6328, Nikolay
    Yakimov). Clean up code in Text.Pandoc.Readers.Metadata and
    properly handle errors in `yamlToMeta`.  This fixes parsing
    of Boolean fields in metadata withinin defaults files and reduces
    code duplication.

  * Docbook reader:

    + Implement `<procedure>` (#6442, Mathieu Boespflug).
    + Implement `<phrase>` (#6438, Mathieu Boespflug).
    + Treat envar and systemitem like code (#6435, Mathieu Boespflug).
    + Implement `<replaceable>` (#6437, Mathieu Boespflug)
    + Map `<simplesect>` to unnumbered section (#6436, Mathieu Boespflug).

  * JATS reader:

    + Handle "label" element in section title (#6288).
    + Parse abstract element into metadata field of same name
      (#6480, Albert Krewinkel).

  * Jira reader (Albert Krewinkel):

    + Resolve multiple parsing problems, including issues with empty
      table cells, faulty recognition of closing emphasis characters, and
      parsing of image attributes (#6212, #6219, #6220).
    + Two consecutive markup chars are now parsed verbatim (#6343);
      styled text must not be empty.
    + Newlines are no longer allowed within styled text (#6325).
    + Links to anchors are now parsed as links (#6407).
    + Retain image attributes (#6234).  Jira images attributes as in
      `!image.jpg|align=right!` are retained as key-value pairs. Thumbnail
      images, such as `!example.gif|thumbnail!`, are marked by a
      `thumbnail` class in their attributes.
    + Use Underline for inserted text (#6237). Previously, the span was
      marked with the non-standard class `inserted`.
    + Improve icon conversion for `(/)`, `(x)`, `(!)`, `(?)`
      `(+)`, `(-)`, `(off)`, `(*)`. (#6236, #6264).
    + Support citations, attachment links, and user links (#6231, #6238,
      #6239).
    + Resolve parsing issues of blockquote, color (#6233, #6235).

  * HTML reader:

    + Parse attributes into table attributes.
    + Support `<bdo>` (#5794, Tristan de Cacqueray).
    + Add `summary` to list of block-level HTML tags (#6385).
      This improves support for summary/details inside Markdown.
      NOTE:  you need to include a blank line before the closing
      `</details>`, if you want the last part of the content to
      be parsed as a paragraph.
    + Fix parsing unclosed th elements in a table (#6247).

  * Commonmark reader: Implement `implicit_figures` extension (#6350).

  * Markdown Reader:

    + Fix inline code in lists (#6284, Nikolay Yakimov).
      Previously inline code containing list markers was sometimes
      parsed incorrectly.
    + Don't require blank line after grid table (#6481).
      This allows grid tables to be enclosed in fenced divs with no
      intervening blank lines.

  * LaTeX reader:

    + Don't parse beyond `\end{document}` (#6380).
      This required some internal changes to `\subfile` handling.
    + Better handling of `\lettrine`.  SmallCaps instead of Span
      for the part after the initial capital.  Ensure that both
      arguments are parsed, so that in Markdown both
      are treated as raw LateX. (Closes #6258.)

  * Org reader (Albert Krewinkel):

    + Recognize images with uppercase extensions (#6472).
    + Keep unknown keyword lines as raw org.  The lines of unknown
      keywords, like `#+SOMEWORD: value` are no longer read as metadata,
      but kept as raw `org` blocks. This ensures that more information
      is retained when round-tripping org-mode files; additionally,
      this change makes it possible to support non-standard org
      extensions via filters.
    + Unify keyword handling.  Handling of export settings and other
      keywords (like `#+LINK`) has been combined and unified.
    + Support `LATEX_HEADER_EXTRA` and `HTML_HEAD_EXTRA`
      settings.  These export settings are treated like their non-extra
      counterparts, i.e., the values are added to the `header-includes`
      metadata list.
    + Allow multiple `#+SUBTITLE` export settings.  The values of all
      lines are read as inlines and collected in the `subtitle`
      metadata field.
    + Read `#+INSTITUTE` values as text with markup.  The value is
      stored in the `institute` metadata field and used in the
      default beamer presentation template.
    + The behavior of the `#+AUTHOR` and `#+KEYWORD` export
      settings has changed: Org now allows multiple such lines
      and adds a space between the contents of each line. Pandoc
      now always parses these settings as meta inlines; setting
      values are no longer treated as comma-separated lists.
      Note that a Lua filter can be used to restore the previous
      behavior.
    + Read description lines as inlines (#6485). `#+DESCRIPTION` lines
      are now treated as text with markup. If multiple such
      lines are given, then all lines are read and separated by soft
      linebreaks.
    + Honor tex export option (#4070).  The `tex` export option can be set
      with `#+OPTION: tex:nil` and allows three settings:
      `t` (the default) causes LaTeX fragments to be parsed as TeX or added
      as raw TeX.  `nil` removes all LaTeX fragments from the document.
      `verbatim` treats LaTeX as text.


  * RST reader:

    + Pass arbitrary attributes through in code blocks (#6465).
      Exceptions: name (which becomes the id), class (which becomes the
      classes), and number-lines (which is treated specially to fit
      with pandoc highlighting).
    + Handle `date::` directive (#6276).

  * Textile reader: support `pre.` for code blocks (#6454).

  * Ipynb reader:

    + Implement `raw_markdown` extension (#5408).  Specifying
      `-f ipynb+raw_markdown` will cause Markdown cells
      to be represented as raw Markdown blocks, instead of being
      parsed.  This is not what you want when going from `ipynb`
      to other formats, but it may be useful when going from `ipynb`
      to Markdown or to `ipynb`, to avoid semantically insignificant
      changes in the contents of the Markdown cells that might
      otherwise be introduced.
    + Handle application/pdf output as image (#6430).
    + Properly handle image/svg+xml as an image (#6430).

  * Docx reader:

    + Distinguish between docx parsing and docx container unpacking errors.

  * MediaWiki reader:

    + Fix `gfm_auto_identifiers` so that `-` is not replaced by `_` (#6335).

  * Vimwiki reader:

    + Add nested syntax highlighting (#6256, Vlad Hanciuta).
      Nested syntaxes are specified like this:
      ```
      {{{sql
      SELECT * FROM table
      }}}
      ```
      The preformatted code block parser has been extended to check if the
      first attribute of the block is not a `key=value` pair, and in that
      case it will be considered as a class.


  * Jira writer (Albert Krewinkel):

    + Always escape braces (#6478).  Braces are now always escaped, even
      within words or when surrounded by whitespace. Jira and
      Confluence treat braces specially.
    + Convert Underline to inserted text (`+inserted+`).
    + Add image attributes (#6234).  Image attributes are added
      to the output as image parameters. If the image has a
      class "thumbnail", then a thumbnail image is generated;
      all other attributes are discarded in this case.

  * LaTeX writer:

    + Ensure that `-M csquotes` works even in fragment mode (#6265).
    + Escape `^` specially for listings (#6460).
    + Create hypertarget for links with identifier (#6360).
    + Distinguish between single and double quotes when using enquote
      package (#6457, dbecher-ito).
    + Add support for customizable alignment of columns in beamer (#6331,
      andrebauer).
    + Add support for customizable alignment of columns in beamer
      (#4805, #4150, andrebauer).

  * HTML writer:

    + Use CSS in favor of `<br>` for display math (#6372)
      Some CSS to ensure that display math is
      displayed centered and on a new line is now included
      in the default HTML-based templates; this may be
      overridden if the user wants a different behavior.

  * Org writer:

    + Clean-up Div handling (Albert Krewinkel).

  * Docx writer:

    + Enable column and row bands for tables (#6371).
      This change will not have any effect with the default style.
      However, it enables users to use a style (via a reference.docx)
      that turns on row and/or column bands.

  * OpenDocument (and ODT) writer:

    + Add custom-style "Abstract" in metadata abstract.
      This ensures that the abstract is rendered with style Abstract.
    + Enable custom-style attribute on a Div.
      This allows you to apply a custom style to contained paragraphs.

  * DocBook writer:

    + Add id of figure to enclosed image.
    + Add personname element to docbook author (#6244).

  * FB2 writer:

    + Properly handle cover-image containing spaces (#6391).

  * Markdown writer:

    + Ensure consistent padding for pipe tables (#6240).
    + Avoid unnecessary escapes before intraword `_` when
      `intraword_underscores` extension is enabled (#6296).

  * RST writer:

    + Properly handle images with same alt text (#6194).
      Previously we created duplicate references for these in rendering RST.

  * AsciiDoc writer:

    + Add blank line after Div (#6308).

  * Haddock Writer:

    + Support Haddock tables (Joe Hermaszewski).
      See this PR on Haddock for details on the table format:
      <https://github.com/haskell/haddock/pull/718>.

  * PowerPoint writer (Jesse Rosenthal):

    + Write math input verbatim in speaker notes (#6301).
      OMML in speaker notes would lead to corrupt PowerPoint output. We now
      output the OMML verbatim as LaTeX in the speaker notes.

  * LaTeX template: Make polyglossia package options list-aware
    (#6444, Frederik Elwert).

  * Reveal.js template:

    + Update template for reveal.js 4.0.0 (#6390, Salim B).
    + Update template with newly available options (#6347, Jake Zimmerman).
    + Use CDN version of revealjs v4 by default (#6408).

  * opendocument template: Add abstract and subtitle to opendocument
    template (#6369).

  * reference.odt: clean up styles.  Add Abstract.
    Change Author, Date to centered paragraphs with no character
    styling.

  * epub.css: wrap overlong lines in highlighted code blocks (#6242).
    This fixes a problem in iBooks v2.4 with our earlier
    horizontally scrolling code blocks.  The problem seems to
    be a bug in iBooks, not pandoc, but since iBooks is a major
    target we're changing pandoc's default behavior so that
    pandoc-produced epubs work on that platform.

  * Text.Pandoc.PDF:

    + Use `--enable-local-file-access` in invoking `wkhtmltopdf` (#6474).
      `wkhtmltopdf` changed in recent versions to require this for
      access to local files.  This fixes PDF via HTML5 with `--css`.
    + Send verbose output to stderr, not stdout (#6483).

  * Text.Pandoc.MIME: Fix MIME type for TrueType fonts in EPUBs
    (#6464, Michael Reed).

  * Text.Pandoc.Shared:

    + `makeSections`: omit number attribute when unnumbered class
      is present (#6339).  Previously the attribute was included but given
      an empty value, and this caused the table of contents creation
      functions in Text.Pandoc.Writers.Shared to think these items had
      numbers, which meant that they were included in the TOC even if the
      `unlisted` class was used.
    + Deprecate `underlineSpan` in Shared in favor of
      `Text.Pandoc.Builder.underline` (Vaibhav Sagar).
    + `renderTags'`: use self-closing tag for col element (#6295).

  * Text.Pandoc.UUID: Fix `getRandomUUID`, which previously would
    return the same value twice in a row. Make `getRandomUUID`
    polymorphic in PandocMonad.  Remove `getUUID` (#6228, Joseph C. Sible).

  * Text.Pandoc.Class: Generalize `PandocIO` functions to `MonadIO`.

  * Fixed Katex standalone script (#6399, Lucas Escot).
    Global macros are now persistent when using the HTML Writer with the
    `--katex` option.

  * Lua subsystem (Albert Krewinkel):

    + Use new type PandocLua for all pandoc Lua operations (API change).
      The new type `PandocLua` is an instance of the `PandocMonad` typeclass
      and can thus be used in a way similar to `PandocIO`.
    + Use PandocError for exceptions in Lua subsystem (API change).
      The PandocError type is used throughout the Lua subsystem. All Lua
      functions throw an exception of this type if an error occurs. The
      `LuaException` type is removed and no longer exported from
      `Text.Pandoc.Lua`. In its place, a new constructor `PandocLuaError`
      is added to PandocError.

  * Lua filters: improve error messages for failing filters (#6332,
    Albert Krewinkel).  Print the Lua error properly instead of
    displaying their `show` string.

  * Use latest skylighting.  This fixes a bug with lua multiline
    comments (and may improve handling of other syntaxes as well).
    IT also adds `aria-hidden="true"` to the empty a elements, which
    helps people who use screen readers.

  * Use latest texmath.

  * Require latest doctemplates 0.8.2.
    This adds support for template pipes `first`, `rest`,
    `last`, `allbutlast`.

  * Revert  0e48a02 and dependency on base-noprelude, which hasn't
    been updated for ghc 8.10 (see #6187).

  * Dependency adjustments:

    + Allow haddock-library 1.9.x.
    + Allow hslua 1.1 (#6243, Felix Yan).
    + Allow base64-bytestring 1.1.
    + Use latest jira-wiki-markup.
    + Allow http-client 0.7.
    + Allow tasty 1.3.x.
    + Allow aeson 1.5 (#6400, Felix Yan).
    + Remove unused dependency `vector` (#6462, Laurent P. René de Cotret).
    + Bump QuickCheck upper bound.

  * Significant code cleanup and simplification (Joseph C. Sible, #6223,
    #6209, #6225, #6229, #6226, #6340).

  * Remove unnecessary hlint ignores (#6341, Joseph C. Sible).

  * Remove obsolete RelaxedPolyRec extension (#6487, Nikolay Yakimov).

  * trypandoc improvements (Mike Tzou):

    + Add standalone option to the command text (#6210).
    + Update third party libraries.

  * MANUAL.txt:

    + Clarify template partial naming (#6476, Mauro Bieg).
    + Describe `jira` as "Jira/Confluence wiki markup" (#6351, Albert
      Krewinkel).  In the past, Jira's wiki markup was also used by -- and
      could be imported into -- Atlassian Confluence.
    + Add link to print-css.rocks (#6272, Mauro Bieg).
    + Clarify pipe table column width adjustment (#6254).
    + Fix ATX header syntax.
    + Fix misleading note about image size conversions (#6353).
    + Update links to reveal.js documentation (#6386, Salim B).
    + Separate adjacent verbatim code blocks (#6307, tom-audm).

  * org.md:

    + Document behavior of `smart` extension (#4387, Albert Krewinkel).
    + Describe all supported export options in detail.

  * lua-filters.md:

    + Fix description of BulletList Lua type (Levi Gruspe).
    + Use pandoc.system module in TikZ example (Albert
      Krewinkel).  Showcase temporary directory handling with
      `with_temporary_directory` and `with_working_directory`.

  * INSTALL.md: fix FreeBSD port link (#6422, Mo).
    The FreeBSD port was renamed from pandoc to hs-pandoc in 2010.
    The old pandoc port is still at version 1.5.1.1

  * Propagate `(DY)LD_LIBRARY_PATH` in tests (#6376, Lila).

  * Bump `cabal-version` to 2.2 (#6377).

  * Make it possible to compile using Stack on NixOS (#6439, Mathieu
    Boespflug).

  * CI action to check for commit message length (Nikolay Yakimov, #6398).


## pandoc 2.9.2.1 (2020-03-23)

  * Markdown reader: Fix table alignment when heading begins with t (#6153).
    Due to a typo (`t` instead of `\t`) we were center aligning column
    headings that begin with a lowercase `t`!

  * Text.Pandoc.Readers.Roff:

    + Fix parsing of `\.` in man/ms readers (#6175).
      Previously due to a typo it was being parsed as `` ` ``.
    + Fix parsing of `\'` in man/ms readers (#6175).  It was being parsed
      as a backtick.

  * Jira reader (Albert Krewinkel):

    + Fix parsing of tables without preceding blankline (#6198).
      A bug was fixed which caused faulty parsing if a table was not
      preceded by a newline and the first table cell had no space
      after the initial `|` characters.
    + Fix parsing of strikeout, emphasis (#6196).  A bug was fixed which
      caused non-emphasized text containing digits and/or non-special
      symbols (like dots) to sometimes be parsed incorrectly.
    + Support colored inline text, indented lists (#6183, #6184).

  * Ms writer:

    + Fix definition lists so indent even when paragraph indent is
      set to 0 (as is the default).  Also ensure indent for display math
      that falls back to TeX.
    + Use `.QS/.QE` instead of `.RS/.RE` for block quotes.

  * EPUB writer: fix regression on detection of front/back/bodymatter
    (#6170).  This bug caused sections with epub:type `dedication` to be
    misplaced in bodymatter instead of frontmatter as specified
    in the manual.  The same problem would affect other epub:types.
    The pattern matching needed to be changed with the use of
    `makeSection`.

  * AsciiDoc writer:  remove redundant `otherwise` guard in
    `inlineToAsciiDoc` (#6146, Ryan Scott).

  * Text.Pandoc.Class:

    + Fix missing import when data files are not embedded (Albert Krewinkel).
    + Subdivide Text.Pandoc.Class into small unexported modules
      and ensure that all functions have Haddock documentation (#6106,
      Albert Krewinkel).
    + Finer grained imports of Text.Pandoc.Class submodules (#6203, Albert
      Krewinkel).

  * Text.Pandoc.XML: Add to list of HTML5 attributes:
    `allow`, `autocapitalize`, `decoding`, `enterkeyhint`,
    `imagesizes`, `imagesrcset`, `loading`.

  * Use implicit Prelude (#6187, Albert Krewinkel).
    The previous behavior was introduced as a fix for #4464. It seems that
    this change alone did not fix the issue, and `stack ghci` and `cabal
    repl` only work with GHC 8.4.1 or newer, as no custom Prelude is loaded
    for these versions. Given this, it seems cleaner to revert to the
    implicit Prelude.

  * Always use custom prelude (#6187, Albert Krewinkel).
    Previously, the custom prelude was used only with older GHC versions, as
    a workaround for problems with ghci. The ghci problems are resolved by
    replacing package `base` with `base-noprelude`, allowing for consistent
    use of the custom prelude across all GHC versions.

  * Remove outdated checks for no longer supported base versions
    (Albert Krewinkel).

  * PDF via wkhtmltopdf: put user-specified options last (#6171).
    Certain options (e.g. `cover`) need to come after flags on
    the command line.

  * Text.Pandoc.App: set resource path at the beginning so it can affect
    things like include-in-header (#5982).

  * Change macOS release candidate CI process so that notarized
    packages can be produced (#6169).

  * Make MANUAL more explicit about nonbreaking space handling by
    `all_symbols_escapable` (#6154, Fabien Schurter).

  * trypandoc (Mike Tzou):

    + Add checkbox for standalone option (#6189).
    + Use strict mode for JavaScript code (#6188).
    + Fetch resources over https (#6188).
    + Remove unnecessary attributes on style, script elements (#6188).

  * Use details tag to make GitHub releases changelog collapsible.

  * Update filter code in doc/filters.md so it works with latest pandoc
    (#6185).

  * linux/Dockerfile: upgrade to alpine 3.11 (#6180, Albert Krewinkel).
    This is used to build the static linux binaries.


## pandoc 2.9.2 (2020-02-15)

  * Add `csv` as an input format (#6100).  The CSV table is converted into a
    pandoc simple table.  A new module Text.Pandoc.Readers.CSV
    exports `readCSV` [API change].

  * Introduce new format variants for JATS writer (#6014, Albert Krewinkel):

    - `jats_archiving` for the "Archiving and Interchange Tag Set",
    - `jats_publishing` for the "Journal Publishing Tag Set", and
    - `jats_articleauthoring` for the "Article Authoring Tag Set."

    The `jats` output format is now an alias for `jats_archiving`.
    The module Text.Pandoc.Writers.JATS now exports
    `writeJatsArchiving`, `writeJatsPublishing`, and
    `writeJatsArticleAuthoring`, as well as the legacy
    `writeJATS` [API change].

  * `--defaults`: Support `bibliography` and `csl` fields.
    Move `addMeta` from Text.Pandoc.App.CommandLineOptions to
    Text.Pandoc.App.Opt (internal change).

  * Add timing info for filters in `--verbose` mode (#6112).
    When verbose mode is specified (verbosity == INFO), print a
    notice when running a filter and when a filter completes (including
    timing).

  * LaTeX reader:

    + Allow `&` in LaTeX citation keys (#6110).
    + Improve caption and label parsing.
    + Don't emit empty Span elements for labels.
    + Put tables with labels in a surrounding Div.
    + Resolve `\ref` to table numbers (#6137).
    + Skip comments in more places where this is needed (#6114).
    + Allow beamer overlays for all commands in all raw tex (#6043).
      This affects parsing of raw tex in LaTeX and in Markdown and
      other formats.
    + Improve parsing of raw environments (#6034).  If parsing fails
      in a raw environment (e.g. due to special characters like unescaped
      `_`), try again as a verbatim environment, which is less sensitive to
      special characters.  This allows us to capture special environments
      that change catcodes as raw tex when `-f latex+raw_tex` is used.

  * RST reader:

    + Add highlight directive (#6140, Lucas Escot).

  * MediaWiki writer:

    + Prevent triple `[[[` which confuses MediaWiki (#6119).

  * HTML reader:

    + Don't parse `data-id` as `id` attribute.  And similarly don't
      parse any `data-X` as `X` when `X` is a valid HTML attribute.

  * Org reader:

    + Simplify parsing of sub- and superscripts (#6127, Albert Krewinkel).
      Speeds up parsing of single-word, markup-less sub- and superscripts.

  * LaTeX writer:

    + Group biblatex citations even with prefix and suffix (#5849, Ethan
      Riley).  Previously biblatex citations were only grouped if there
      was no prefix.  This patch allows them to be grouped in subgroups split
      by prefixes and suffixes, which allows better citation sorting.
    + Fix regression in handling of columns in beamer slides (#6033).
      Columns in title slides were causing problems with
      slide division.
    + Fix duplicate frame classes in LaTeX/Beamer output (#6107).

  * HTML writer:

    + Fix duplicate attributes on headings (#6062), regression from 2.7.x.
    + Fix `--number-offset` with HTML TOC.  Eventually it would be worth
      adding a parameter to `makeSections` so this could be done at that
      level; then it would also affect other writers that construct
      TOC manually.
    + reveal.js: restore old behavior for 2D nesting (#6032).
      The fix to #6030 actually changed behavior, so that the
      2D nesting occurred at slide level N-1 and N, instead of
      at the top-level section.  This commit restores the v2.7.3 behavior.
      If there are more than 2 levels, the top level is horizontal
      and the rest are collapsed to vertical.
    + reveal.js: ensure that pauses work even in title slides (#5819).

  * Markdown writer:

    + Fix regression: spurious dots in markdown_mmd metadata output (#6133).

  * Docx writer:

    + Fix regression with Compact style on tight lists (#6072).
      Starting in 2.8, the docx writer no longer distinguishes between tight
      and loose lists, since the Compact style is omitted.  This is a
      side-effect of the fix to #5670, as explained in the changelog.  This
      patch fixes the problem by extending the exception currently offered to
      Plain blocks inside tables to Plain blocks inside list items.

  * Jira writer:

    + Fix output of table headers (Albert Krewinkel, #6035).

  * Add Text.Pandoc.Image with unexported svgToPng.

  * Text.Pandoc.XML: Export `html5Attributes`, `html4Attributes`,
    `rdfaAttributes` (formerly unexported in Text.Pandoc.Writers.HTML).
    [API change]

  * Text.Pandoc.Shared: Export a new function `findM` (#6125,
    Joseph C. Sible).

  * Text.Pandoc.Logging: Add `RunningFilter`, `FilterCompleted`
    constructors to LogMessage [API change].

  * Text.Pandoc.CSV: fix bug in CSV parser; previously an extra blank record
    would sometimes be inserted at the end.

  * LaTeX template: add space option to xeCJK with PassOptionsToPackage
    (#6002).  Otherwise we can get a clash with documentclasses that
    already load the package.

  * Lua filters:

    + Allow filtering of element lists (#6038, Albert Krewinkel).  Lists of
      Inline and Block elements can now be filtered via `Inlines` and
      `Blocks` functions, respectively. This is helpful if a filter
      conversion depends on the order of elements rather than a single
      element.  For example, the following filter can be used to remove all
      spaces before a citation:

          function isSpaceBeforeCite (spc, cite)
            return spc and spc.t == 'Space'
             and cite and cite.t == 'Cite'
          end

          function Inlines (inlines)
            for i = #inlines-1,1,-1 do
              if isSpaceBeforeCite(inlines[i], inlines[i+1]) then
                inlines:remove(i)
              end
            end
            return inlines
          end

    + Add methods `insert`, `remove`, and `sort` to pandoc.List
      (Albert Krewinkel).  Example of use:

          local numbers = pandoc.List {2, 3, 1}
          numbers:sort()     -- numbers is now {1, 2, 3}
    + Make `pandoc.List` a callable constructor (Albert Krewinkel).
      It is now possible to construct a new List via
      `pandoc.List()` instead of `pandoc.List:new()`.
    + Add tests for pandoc.List module (Albert Krewinkel).

  * Text.Pandoc.App.CommandLineOptions: Change `setVariable` to use `Text`
    instead of `String`.  This avoids some unnecessary unpacking.

  * Use versioned directory for windows release zipfile.
    Also remove old `make-windows-installer.bat`, superseded by GitHub
    actions workflow, and modify `pandoc.wxs` for new paths.

  * Extensive code cleanup (#6141, #6128, #6129, #6130, #6123,
    #6105, 6102, #6117, #6124, #6115, #6116, #6111, Joseph C. Sible).

  * Fix hlint warnings (Albert Krewinkel).

  * Use latest doclayout, doctemplates (#6031).  The new version of
    doclayout fixes a memory leak that affected `--include-in-header` with
    large files (and possibly other cases involving extremely long lines).

  * Use latest texmath.

  * Use latest skylighting and fix test suite (#6086).

  * sample.lua: Fix typo in descriptive comments (#6136, Caleb Maclennan).
    Fix typo in error message (#6135).

  * Add Docker and GH Actions instructions/links to INSTALL.md.

  * Update filter documentation (#6065). Improve cabal v2 instructions.
    Remove example using pandoc API directly (we have other
    docs for that and it was outdated).

  * Lua filter docs:

    + Cross-link constructors and types (Albert Krewinkel).
      Thanks to @bpj for the idea.
    + Sort pandoc.List methods alphabetically (Albert Krewinkel).
    + Unify, fix anchors and internal links (#6061, Albert Krewinkel).
      Links and anchors now follow consistent conventions, like
      lowercase-only anchor names.  This breaks some links to specific
      sections in the document, but will make it much easier to link
      documentation in the future.
    + Clarify filter function execution order (#6059, Albert Krewinkel).

  * In docs, update URLs and use `https:` wherever possible (#6090,
    Salim B).

## pandoc 2.9.1.1 (2020-01-05)

  * Markdown reader:

    + Fix parsing bug affected indented code after raw HTML (#6009, #5360).

  * LaTeX writer:

    + Fix regression in beamer slide structure with certain slide levels
      (#6030).
    + Allow framebreaks for beamer's TOC (Heiko Schlittermann, #6012)
    + Properly handle unnumbered headings level 4+ (#6018).
      Previously the `\paragraph` command was used instead of
      `\paragraph*` for unnumbered level 4 headings.

  * HTML writer:

    + Fix revealjs slide structure regression with certain slide levels
      (#6030).
    + Add newlines to make slide show output more readable.

  * Org writer:

    + Remove extra spaces from table cells (Albert Krewinkel, #6024).

  * JATS template: Update JATS dtd (Arfon Smith, #6020).  Use the archiving
    and interchange DTD rather than the more restrictive journal publishing
    DTD (which doesn't permit ext-link as a valid child).

  * Text.Pandoc.PDF: Fix `runTeXProgram` so that the input source is always
    overwritten (#6027).  Previously it wasn't overridden if the file already
    existed, which led to bad results on subsequent runs when
    `pdf-engine-opt=-output-directory=` was used to specify an explicit temp
    dir.

  * Text.Pandoc.BCP47: Change `getLang` to handle block-level contents
    (#6008).  Some readers (e.g. RST) will populate the `lang` metadata field
    with block-level content.  `getLang` has been modified to handle this.
    Previously in these cases the LaTeX writer would not properly set the
    "main language" of the document.

  * Fix `test/tables.org` (Albert Krewinkel).

  * Use HTTPS in copyright message (Felix Yan, #6010)


## pandoc 2.9.1 (2019-12-23)

  * Add Jira reader (Albert Krewinkel, #5556).

  * Jira writer: use jira-wiki-markup renderer (Albert Krewinkel,
    #5926). The following improvements are included in this change:

    + non-jira raw blocks are fully discarded instead of showing
      as blank lines;
    + table cells can contain multiple blocks;
    + unnecessary blank lines are removed from the output;
    + markup chars within words are properly surrounded by
      braces;
    + preserving soft linebreaks via `--wrap=preserve` is
      supported.

    Note that backslashes are rendered as HTML entities, as there
    appears no alternative to produce a plain backslash if it is
    followed by markup. This may cause problems when used with
    confluence, where rendering seems to fail in this case.

  * Fix regression with `--number-sections`. Starting with 2.8,
    `--number-sections` also had the effect of `--section-divs`,
    even if `--section-divs` was not specified.

  * Improved table of contents generation in markdown, RTF,
    commonmark, better handling cases where section headings are
    enclosed in divs.

  * Ensure that later default file values for `variable` replace
    earlier ones (5988).

  * HTML reader: Add `nav` to list of block-level tags.

  * Org reader (Albert Krewinkel):

    + Wrap named table in Div, using name as id (#5984).
      Tables which are given a name via `#+NAME:` or `#+LABEL:`
      are wrapped in an additional Div, with the name set as the
      Div's ID.
    + Report parsing errors properly.
    + Fix parsing problem for colons in headline (#5993).

  * Text.Pandoc.PDF: Ensure UTF8 when printing source in
    `--verbose` mode, avoiding an error on platforms that
    default to something other than UTF-8 (#5997).

  * Text.Pandoc.Templates: Strip directory before trying to find
    partial in data files (#5987).

  * Text.Pandoc.Shared: Improve `makeSections` so we don't get
    doubled "number" attributes in EPUB output (or anywhere
    else) (#5986).

  * Added tests for `--toc` and `--section-divs`.

  * Text.Pandoc.MIME: Added glsl MIME type for WebGL maps (#6000,
    Jared Lander).

  * MANUAL: A bit clearer explanation for `--base-header-level`.
    We now say exactly how to translate between the deprecated
    `--base-header-level` and `--shift-heading-level-by`.

  * lua-filters.md:

    + Remove spurious dot in title (#5996, Mauro Bieg).
    + Replace metadata example with image centering (#6004,
      Albert Krewinkel). Thanks to @efx for proposing this filter.


## pandoc 2.9 (2019-12-11)

  * Text.Pandoc.Templates [API change]

    + Add Monad wrappers `WithDefaultPartials` and `WithPartials`.
      Wrapping these around an instance of `PandocMonad` gives
      us different instances of `TemplateMonad`, with different
      search behavior in retrieving partials.
      To compile a template and limit partial search to pandoc's
      data files, use `runWithDefaultPartials (compileTemplate ...)`.
      To compile a template and allow partials to be found locally
      (either on the file system or via HTTP, in the event that
      the main template has an absolute URL), ue
      `runWithPartials (compileTemplate ...)`.
    + Export `getTemplate`, which seeks a template locally,
      or via HTTP if the template has an absolute URL, falling
      back to the data files if not found.
    + Export `compileDefaultTemplate` -- does `getDefaultTemplate`
      and compiles the result, raising an error on failure.

  * Text.Pandoc.Class [API change]

    + Remove `TemplateMonad` instances for `PandocIO` and `PandocPure`.
      These were too limiting and caused a bug whereby a local
      partial could be used even when the default template was requested.
      We now rely on instances provided in the Templates module.

  * Text.Pandoc.App.OutputSettings: Simplify template retrieval code.

  * ConTeXt template: Adjust to title formatting (#5949, Denis Maier).
    Add `\setupinterlinespace` to `title`, `subtitle`, `date` and `author`
    elements:  otherwise longer titles that run over multiple lines will look
    squashed as `\tfd` etc. won't adapt the line spacing to the font size.

  * reveal.js template: Add title-slide-attributes variable (#5981,
    Frederik Elwert).

  * More informative JSON parse error (#5973).

  * Use external emojis package (forked from pandoc).  Removed emoji data
    in Text.Pandoc.Emoji.

  * Fix regression in `makeSections` (#5965).
    Previously `hierarchicalize` (the ancestor of `makeSections`) would put
    header attributes on the containing Div.  In 2.8 this behavior changed,
    which broke some tools depending on pandoc.  Here we roll back this change,
    so that attributes again migrate from the header to the containing Div when
    `makeSections` is run.  Note that attributes are retained on the header as
    well (unlike before) -- with the exception of the `id` attribute, which of
    course cannot be duplicated.

  * Fix `--toc-depth` regression in 2.8 (#5967).

  * Use doctemplates 0.8.  Rename template 'filters' as 'pipes'
    to avoid confusion with the other notion of filter used by pandoc.

  * Fix README.md so that relative links from manual become absolute.
    Previously they'd be broken links when viewed on GitHub or Hackage.
    So we add the base URL for the pandoc manual.

  * Document display math syntax in manual.

## pandoc 2.8.1 (2019-12-05)

  * Add `ascii_identifiers` as a supported extension for `markdown`.
    This fixes a regression in 2.8.

  * Fix regression with behavior of `--variable` (#5962).
    Previously `-Vfoo=1 -Vfoo=2` would produce a list value for foo;
    with 2.8 it produced just `2`.  This commit restores the earlier
    behavior.

  * Roll back part of of `--shift-heading-level-by` change (#5957).
    With positive heading shifts, starting in 2.8 this option
    caused metadata titles to be removed and changed to regular
    headings.  This behavior is incompatible with the old
    behavior of `--base-header-level` and breaks old workflows,
    so we have rolled back the change. Note that there is now an
    asymmetry in positive and negative heading level shifts:
    With positive shifts, the metadata title stays the same and
    does not get changed to a heading in the body, while with
    negative shifts, a heading can be converted into the
    metadata title.

  * Text.Pandoc.Shared: Fix `makeSections` so it doesn't turn
    column Divs into sections.

  * HTML writer: add task-list class to ul if all elements are
    task list items.  This will allow styling unordered task
    lists in a way that omits the bullet.

  * HTML-based templates: Add CSS to suppress bullet on unordered task lists.

  * ConTeXt template: Fix `\startcslreferences` and use ConTeXt syntax
    conventions (#5945, Denis Maier).  The old version had a too large
    a skip at the beginning of the reference list.

  * LaTeX template: keep the `\author{}` command even if author is not
    specified (#5961, Yihui Xie).  Avoids a LaTeX warning.

  * Generate Emoji module with TH.

    + Add Text.Pandoc.Emoji.TH.
    + Replace long literal list in Text.Pandoc.Emoji with one-liner
      generating it from `emoji.json` using TH.
    + Add Makefile target to download `emoji.json`.
    + Remove `tools/emoji.hs`.

  * Increase GC allocation space for compilation in cabal.project.

  * Clean up manual on PDF generation backend options (#5940).

  * Update release checklist to include code signing step and update
    Windows release-candidate builds (#5950).


## pandoc 2.8.0.1 (2019-11-26)

  * List `pdf` in `--list-output-formats`.
  * EPUB writer: Fix regression with `--css` (#5937).  In 2.8 `--css`
    would not have an effect on EPUB output.
  * RST writer: Use grid tables for one-column tables, since
    simple tables clash with heading syntax in this case (#5936).
  * Add unexported module Text.Pandoc.Readers.Metadata (see #5914).
  * Use doctemplates 0.7.2, which adds the `nowrap` filter to
    templates.
  * Update default man template using `nowrap` for .TH heading (#5929).
  * HTML templates: Add support for `toc-title` variable (#5930,
    Alexandre Franke).
  * Remove `grffile` (LaTeX package) requirement in MANUAL.txt
    (#5927, Ian Max Andolina).
  * Use skylighting 0.8.3.

## pandoc 2.8 (2019-11-22)

  * Improvements in templates system (from doctemplates):

    + Pandoc templates now support a number of new features that
      have been added in doctemplates: notably, `elseif`, `it`,
      partials, filters, and syntax to control nesting and reflowing of
      text.  These changes make pandoc more suitable out of the
      box for generating plain-text documents from data in YAML
      metadata.  It can create enumerated lists and even tabular
      structures.
    + We now used templates parameterized on doclayout Doc types.
      The main impact of this change is better reflowing of
      content interpolated into templates.  Previously,
      interpolated variables were rendered independently and
      interpolated as strings, which could lead to overly long
      lines. Now the templates interpolated as Doc values which
      may include breaking spaces, and reflowing occurs after
      template interpolation rather than before.
    + Remove code from the LaTeX, Docbook, and JATS writers that
      looked in the template for strings to determine whether it
      is a book or an article, or whether csquotes is used. This
      was always kludgy and unreliable.
    + Change template code to use new API for doctemplates.

  * Add `--defaults`/`-d` option.  This adds the ability to specify
    a collection of default values for options in a YAML file. For
    example, one might define a set of defaults for letters,
    and then do `pandoc -d letter myletter.md -o myletter.pdf`.
    See the documentation of this feature in MANUAL.txt.

  * Raise error on unsupported extensions (#4338).

  * The `--list-extensions[=FORMAT]` option now lists only
    extensions that affect the given FORMAT.

  * Add `-L` option as shortcut for `--lua-filter`.

  * Add `--shift-heading-level-by` option and deprecate
    `--base-heading-level` (#5615). The new option does
   everything the old one does, but also allows negative shifts.
   It also promotes the document metadata (if not null) to a
   level-1 heading with a +1 shift, and demotes an initial
   level-1 heading to document metadata with a -1 shift. This
   supports converting documents that use an initial level-1
   heading for the document title.

  * Allow `--metadata-file` to be used repeatedly to include
    multiple metadata files (Owen McGrath, #5702). Values in
    files specified first will be overridden by those in later
    files.

  * `--ascii` now uses numerical hex character references (#5718).

  * Allow PDF output to stdout (#5751).  PDF output now behaves like other
    binary formats: it will not be output to the terminal, but can be
    sent to stdout using either `-o -` or a pipe.  The intermediate format
    will be determined based on the setting of `--pdf-engine`.

  * Make some writers sensitive to 'unlisted' class on headings (#1762).
    If this is present on a heading with the 'unnumbered' class,
    the heading won't appear in the TOC.  This class has no
    effect if 'unnumbered' is not also specified.  This affects HTML-based
    writers (including slide shows and EPUB), LateX (including beamer), RTF,
    and PowerPoint.  Other writers do not yet support `unlisted`.

  * Fix `gfm_auto_identifiers` behavior with emojis (#5813).  Note that
    we also now use emoji names for emojis when `ascii_identifiers`
    is enabled.

  * When `--ipynb-output` is used with the default "best" format, strip
    ANSI escape codes for non-ipynb output (#5633).  These cause problems
    in many formats, including LaTeX.

  * Don't look for template files remotely for remote input (#5579).
    Previously pandoc would look for the template at a remote URL when a
    URL was used for the input file, instead of taking it from the
    data directory.

  * Allow combining `-Vheader-includes` and `--include-in-header` (#5904).
    Previously `header-includes` set as a variable would be
    clobbered by material included using `--include-in-header`.

  * Change merge behavior for metadata.  Previously, if a document
    contained two YAML metadata blocks that set the same field, the
    conflict would be resolved in favor of the first. Now it is resolved
    in favor of the second (due to a change in pandoc-types).
    This makes the behavior more uniform with other things in pandoc
    (such as reference links and `--metadata-file`).

  * Don't add a newline to fragment output if there's already one.

  * Change exit codes and document in MANUAL.txt:

    + `PandocAppError` was 1, is now 4
    + `PandocOptionError` was 2, is now 6
    + `PandocMakePDFError` was 65, is now 66

  * Switch to new pandoc-types and use Text instead of String [API change].
    (Christian Despres, #5884).

  * HTML reader:

    + Better handling of `<q>` with cite attribute (#5798, Ole Martin Ruud).
      If a `<q>` tag has a `cite` attribute, we interpret it as a Quoted
      element with an inner Span.
    + Add support for HTML `<samp>` element (#5792, Amogh Rathore).
      The `<samp>` element is parsed as Code with class `sample`.
    + Add support for HTML `<var>` element (#5799, Amogh Rathore).
      The `<var>` element is parsed as Code with class `variable`.
    + Add support for `<mark>` elements (Florian B, #5797).  Parse
      `<mark>` elements from HTML as Spans with class `mark`.
    + Add support for `<kbd>` elements, parsing them as Span with class
      `kbd` (Daniele D'Orazio, #5796).
    + Add support for `<dfn>`, parsing this as a Span with class `dfn`
      (#5882, Florian Beeres).

  * Markdown reader:

    + Headers: don't parse content over newline boundary (#5714).
    + Handle inline code more eagerly within lists (Brian Leung, #5627).
    + Removed some needless lookaheads.
    + Don't parse footnote body unless extension enabled.
    + Fix small super/subscript issue (#5878).  Superscripts and subscripts
      cannot contain spaces, but newlines were previously allowed
      (unintentionally).  This led to bad interactions in some cases
      with footnotes.  With this change newlines are also not allowed inside
      super/subscripts.
    + Use `take1WhileP` for `str`, table row.  This yields a small but
      measurable performance improvement.


  * LaTeX reader:

    + Fix parsing of optional arguments that contain braced text (#5740).
    + Don't try to parse includes if `raw_tex` is set (#5673).
      When the `raw_tex` extension is set, we just carry through
      `\usepackage`, `\input`, etc. verbatim as raw LaTeX.
    + Properly handle optional arguments for macros (#5682).
    + Fix `\\` in `\parbox` inside a table cell (#5711).
    + Improve `withRaw` so it can handle cases where the token string is
      modified by a parser (e.g. accent when it only takes part of a Word
      token) (#5686).  This fixes a bug that caused the ends of
      certain documents to be dropped.
    + Handle `\passthrough` macro used by latex writer (#5659).
    + Support tex `\tt` command (#5654).
    + Search for image with list of extensions like latex does, if an
      extension is not provided (#4933).
    + Handle `\looseness` command values better (#4439).
    + Add `mbox` and `hbox` handling (Vasily Alferov, #5586).
      When `+raw_tex` is enabled, these are passed through literally.
      Otherwise, they are handled in a way that emulates LaTeX's behavior.
    + Properly handle `\providecommand` and `\provideenvironment` (#5635).
      They are now ignored if the corresponding command or environment
      is already defined.
    + Support epigraph command in LaTeX Reader (oquechy, #3523).
    + Ensure that expanded macros in raw LaTeX  end with a space
      if the original did (#4442).
    + Treat `ly` environment from lilypond as verbatim (Urs Liska, #5671).
    + Add `tikzcd` to list of special environments (Eigil Rischel).
      This allows it to be processed by filters, in the same way that
      one can do for `tikzpicture`.

  * Roff reader:

    + Better support for `while`.
    + More improvements in parsing conditionals.
    + Fix problem parsing comments before macro.
    + Improve handling of groups.
    + Better parsing of groups (#5410).  We now allow groups
      where the closing `\\}` isn't at the beginning of a line.

  * RST reader:

    + Keep `name` property in `imgAttr` (Brian Leung, #5619).
    + Fixed parsing of indented blocks (#5753).  We were requiring
      consistent indentation, but this isn't required by RST.
    + Use title, not admonition-title, for admonition title.
      This puts RST reader into alignment with docbook reader.
    + Don't strip final underscore from absolute URI (#5763).
    + Avoid spurious warning when resolving links to internal anchors
      ending with `_` (#5763).

  * Org reader:

    + Accept `ATTR_LATEX` in block attributes (Albert Krewinkel, #5648).
      Attributes for LaTeX output are accepted as valid block attributes;
      however, their values are ignored.
    + Modify handling of example blocks (Brian Leung, #5717).
    + Allow the `-i` switch to ignore leading spaces (Brian Leung).
    + Handle awkwardly-aligned code blocks within lists (Brian Leung).
      Code blocks in Org lists must have their `#+BEGIN_` aligned in a
      reasonable way, but their other components can be
      positioned otherwise.
    + Fix parsing of empty comment lines (#5856, Albert Krewinkel).
      Comment lines in Org-mode can be completely empty.

  * Muse reader (Alexander Krotov):

    + Add RTL support (#5551).
    + Do not allow closing asterisks to be followed by `*`.
    + Do not split series of asterisks into symbols and emphasis (#5821).
    + Do not terminate emphasis on `*` not followed by space.

  * DokuWiki reader:

    + Parse markup inside monospace ('') (#5916, Alexander Krotov).

  * Docx reader:

    + Move style-parsing-specific code to a new unexported module,
      Text.Pandoc.Readers.Docx.Parse.Styles (Nikolay Yakimov).
    + Move StyleMap to docx writer (Nikolay Yakimov).
    + Only use LTR when it is overriding BiDi setting (#5723, Jesse
      Rosenthal).  The left-to-right direction setting in docx is used
      in the spec only for overriding an explicit right-to-left setting.
      We only process it when it happens in a paragraph set with BiDi.
      This is especially important for docs exported from Google Docs,
      which explicitly (and unnecessarily) set `rtl=0` for every paragraph.
    + Fix list number resumption for sublists (#4324).
      The first list item of a sublist should not resume numbering
      from the number of the last sublist item of the same level,
      if that sublist was a sublist of a different list item.

  * Docbook reader:

    + Richer parse for admonitions (Michael Peyton Jones, #1234).
      Instead of parsing admonitions as blockquotes, we now parse
      them as Divs with an appropriate class. We also handle titles
      for admonitions as a nested Div with the "title" class.
    + Fix nesting of chapters and sections (#5864, Florian Klink,
      Félix Baylac-Jacqué).
    + Fix bug with entities in mathphrase element (#5885).

  * MediaWiki reader:

    + Skip optional `{{table}}` template (#5757).

  * LaTeX reader:

    + Fix dollar-math parsing to ensure that space is left between a
      control sequence and a following letter (#5836).
    + In `untokenize`, ensure space between control sequence
      and following letter (#5836).
    + Don't omit macro definitions defined in the preamble.
      These were formerly omitted (though they still affected macro
      resolution if `latex_macros` was set).  Now they are included in
      the document body.
    + Parse macro definitions as raw LaTeX when `latex_macros` is
      disabled.  (When `latex_macros` is enabled, we omit them, since
      pandoc is applying the macros itself.)
    + Fix a hang/memory leak in certain circumstances (#5845).
    + Text.Pandoc.Readers.LaTeX.Parsing: add `[Tok]` parameter to
      `rawLaTeXParser`.  This allows us to repeat retokenizing
      unnecessarily in e.g. `rawLaTeXBlock`.
    + Add KOMA-Script metadata commands (#5910, Andrew Dunning).
      Add all titling commands to existing definition for `\dedication`.
    + Parse `\micro` siunitx unit command (#5921, Jose Luis Duran).

  * Markdown writer:

    + Ensure proper nesting when we have long ordered list markers (#5705).
    + Make `plain` output plainer (#5741).  Previously we used the following
      Project Gutenberg conventions for plain output: extra space before and
      after level 1 and 2 headings, all-caps for strong emphasis,
      underscores surrounding regular emphasis. Now these
      conventions are used only when the `gutenberg` extension is
      enabled. By default, Strong and Emph are rendered without
      special formatting, and headings are rendered without
      special formatting, and with only one blank line following.
      To restore the former behavior, use `-t plain+gutenberg`.
    + Prefer using raw_attribute when enabled (#4311).
      The `raw_attribute` will be used to mark raw bits, even HTML
      and LaTeX, and even when `raw_html` and `raw_tex` are
      enabled, as they are by default. To get the old behavior,
      disable `raw_attribute` in the writer.
    + Prefer `pipe_tables` to raw HTML even when we must
      lose width information (#2608, #4497).
    + Improve escaping in list items (#5918).

  * AsciiDoc writer:

    + Don't include `+` in code blocks for regular asciidoc.
      This is asciidoctor-specific.
    + Handle admonitions (#5690).

  * LaTeX writer:

    + Add thin space when needed in LaTeX quote ligatures (#5684).
    + Use `\hspace{0pt}` for 0-width space U+200B (#5756).
    + Use `cslreferences` environment for csl bibliographies.
      This allows bibliographies to receive special formatting.
      The template now contains definition of this environment (enabled
      only when CSL is used).  It also defines a `\cslhangindent` length.
      This is set to 2em by default when the bibliography style specifies
      a hanging indent.  To override the length, you can use e.g.
      `\setlength{\cslhangindent}{7em}` in header-includes.
      See jgm/pandoc-citeproc#410.
    + Strip off `{}` around locator for biblatex/natbib output (#5722).
    + Fix line breaks at start of paragraph (#3324).
      Previously we just omitted these. Now we render them
      using `\hfill\break` instead of `\\`.  This is a revision
      of a PR by @sabine (#5591) who should be credited with the idea.
    + We no longer look in the template or header-includes to see if a
      book or article documentclass is used, or to see whether the
      `csquotes` package is used. To use `csquotes` for LaTeX, set
      `csquotes` in your variables or metadata. To specify a book
      style, use the `documentclass` variable or
      `--top-level-division`.
    + Fix horizontal rule (#5801).  We change to use 0.5pt rather than
      `\linethickness`, which apparently only ever worked "by accident"
      and no longer works with recent updates to texlive.

  * ConTeXt writer:

    + Add option to include source files in ConTeXt PDFs (Tristan
      Stenner, #5578). The metadata field or variable
      (`includesource`) can be set to attach the source documents
      to the resulting PDF.
    + Customizable type of PDF/A for the ConTeXt writer (Karl
      Pettersson, #5608).  The `pdfa` variable may now be set in metadata.
      Also updated color profile settings in accordance with ConTeXt wiki,
      and made ICC profile and output intent for PDF/A customizable
      using `pdfaiccprofile` and `pdfaintent`.
    + Unit tests: adjust code property to avoid an irrelevant
      failure involving inline code with two consecutive newlines.
    + Set `csl-hanging-indent` variable if needed.
    + Use special environment for CSL references.
    + Use braces, not start/stop, for inline language tags.
      This prevents unwanted gobbling of spaces.

  * HTML writer:

    + Use numeric character references with `--ascii` (#5718).
      Previously we used named character references with html5 output.
      But these aren't valid XML, and we aim to produce html5 that is
      also valid XHTML (polyglot markup).  (This is also needed for epub3.)
    + Ensure that line numbers in code blocks get id-prefix (#5650).
    + Ensure TeX formulas are rendered correctly (Philip Pesca,
      #5658). The web service passed in to `--webtex` may render
      formulas using inline or display style by default.
      Prefixing formulas with the appropriate command ensures
      they are rendered correctly.
    + Render inline formulas correctly with `--webtex` (Philip
      Pesca, #5655). We add `\textstyle` to the beginning of the
      formula to ensure it will be rendered in inline style.
    + Pass through `aria-` attributes to HTML5 (#5642).
    + Render a Quoted element with an inner Span with
      `cite` attribute using a `<q>` tag (#5798, Ole Martin Ruud).
    + Render a Span with class `mark` using the `<mark>` element
      (Florian Beeres, #5797).
    + Render Span with class `dfn` using `<dfn>` element
      (Florian Beeres, #5882).
    + Render Span with class `kbd` using `<kbd>` element (Daniele
      D'Orazio, #5796).
    + Render Code with class `variable` using `<var>` element
      (Amogh Rathore, #5799).
    + Render Code with class `sample` using `<samp>` element
      (Amogh Rathore, #5799).

  * EPUB writer:

    + Improve splitting into chapters (#5761), using `makeSection`.
    + Avoid issuing warning multiple times when title not set (see #5760).
    + Use svg tag wrapper for cover image (#5638).  In addition, the
      code generating the image has been moved to the template, to make it
      more customizable. NOTE: Those who use custom EPUB
      templates will need to adjust their templates, adding the
      code to generate the cover image. (Previously this was just
      inserted into 'body'.)
    + Improve toChapters, making it work better if there are Divs
      around sections.
    + Add support for EPUB2 covers (blmage, #3992).
    + Do not override existing "fileN" medias when writing to EPUB format
      (blmage, #4206).
    + Ensure that `lang` variable is set on all chapters (so that it
      will add an `xml:lang` attribute on the `html` element).

  * RST writer:

    + Removed remnants of `admonition-title`.
    + Fix handling of `:align:` on figures and images (#4420).
      When the image has the `align-right` (etc.) class, we now use
      an `:align:` attribute.
    + Improve spacing for tables with no width information (#5899).
      If a simple table would be too wide, we use a grid table.
    + Fix backslash escaping after strings (Albert Krewinkel, #5906).
      The check whether a complex inline element following a string must
      be escaped, now depends on the last character of the string instead
      of the first.
    + Ensure there's a blank line before tables (#5898).

  * Dokuwiki writer:

    + Handle mixed lists without HTML fallback (#5107).

  * XWiki writer:

    + Fix multiline table (Zihang Chen, #5683).

  * Muse writer:

    + Add RTL support (Alexander Krotov, #5551).

  * Man writer:

    + Suppress non-absolute link URLs (#5770).  Absolute URLs are
      still printed in parentheses following the link text, but relative
      URLs are suppressed (just as internal links starting with '#'
      always have been).
    + Improved definition list term output.  Now we boldface code but
      not other things. This matches the most common style in man pages
      (particularly option lists).

  * Ms writer:

    + Use `.LP` instead of `.PP` for line block (#5588).
    + Use boldface for definition terms in DefinitionLists.

  * JATS writer:

    + Do not emit empty `<fn-group>` (Mauro Bieg, #5595).
    + Update template to v1.1dtd (#5632, Arfon Smith).
    + Update `data/jats.csl` to avoid commas between editor
      name-part elements. (#5629)
    + Add `abstract` to template (Mauro Bieg).

  * TEI writer:

    + Don't strip hash from internal links (#5922).

  * Jira writer:

    + Remove escapeStringForJira for code blocks (Jan-Otto Kröpke).
    + Remove extraneous newline after single-line block quotes
      (#5858, Albert Krewinkel).
    + Improve escaping of special characters, using backslash escapes
      instead of HTML entities (#5858, Albert Krewinkel).

  * OpenDocument writer:

    + Avoid duplicate attributes (#4634). We use the innermost
      attribute in nested cases.
    + If `native_numbering` extension is set, use native OpenDocument
      enumeration for figures and tables (Nils Carlson).
    + Place caption before table (#5681, Dmitry Pogodin).

  * ODT writer:

    + Add a test for MathML formulas in ODT documents (blmage).
    + Improve the parsing of frames in ODT documents (blmage).

  * Docx writer:

    + Make handling of styles more robust in localized versions
      of Word (Nikolay Yakimov, #5523, #5052, #5074).  We now use
      style names, not ids, for assigning semantic meaning, since
      the ids can change depending on the locale. Style name
      comparisons are case-insensitive, since those are
      case-insensitive in Word. Since docx style names can have
      spaces in them, and pandoc-markdown classes can't, anywhere
      when style name is used as a class name, spaces are
      replaced with ASCII dashes `-`. Code styles, i.e. "Source
      Code" and "Verbatim Char" now honor style inheritance. Docx
      Reader now honours "Compact" style (used in
      Pandoc-generated docx). The side-effect is that "Compact"
      style no longer shows up in docx+styles output. Styles
      inherited from "Compact" will still show up.
    + Re-use Readers.Docx.Parse for StyleMap (#5766, Nikolay Yakimov).
    + Internal improvements and code simplification (Nikolay Yakimov).
    + Preserve built-in styles in DOCX with custom style (Ben Steinberg,
      #5670).  This change prevents custom styles on divs and spans
      from overriding styles on certain elements inside them, like
      headings, blockquotes, and links. On those elements, the
      "native" style is required for the element to display correctly.
      This change also allows nesting of custom styles; in order to do so,
      it removes the default "Compact" style applied to Plain blocks,
      except when inside a table.
    + Add `proofState` to list of elements carried over from
      settings.xml in the reference.docx (Krystof Beuermann, #5703).
    + Change order of `ilvl` and `numId` in `document.xml` (Agustín
      Martín Barbero, #5645). Also, make list para properties go first.
      This reordering of properties shouldn't be necessary but
      it seems Word Online does not understand the docx correctly otherwise.

  * PowerPoint writer:

    + Code formatting is now context dependent (Jeroen de Haas, #5573).
      This commit alters the way in which the Powerpoint writer treats
      inline code and code blocks. Inline code is now formatted at
      the same size as the surrounding text. Code blocks are now given
      a margin and font size according to their level.
      Furthermore this commit allows changing the font with which code is
      formatted via the `monofont` option.
    + Start numbering at appropriate numbers (Jesse Rosenthal, #5709).
      Starting numbers for ordered lists were previously ignored. Now
      we specify the number if it is something other than 1.

  * Text.Pandoc.Parsing:

    + Add `manyChar`, `many1Char`, `manyTillChar`, `many1TillChar`,
      `many1Till`, `manyUntil`, `mantyUntilChar`: these are like their
      unsuffixed counterparts but pack some or all of their output
      (Christian Despres, #5884).
    + Add `stateAllowLineBreaks` to `ParserState` [API change].
    + Fix inline parsing in grid table cells (#5708).
    + Change type of `setLastStrPos` so it takes a `Maybe SourcePos`
      rather than a `SourcePos` [API change].
    + Make `parseFromString'` and `gridTableWith` and
      `gridTableWith'` polymorphic in the parser state,
      constraining it with `HasLastStrPosition` [API change].
    + `parseFromString'`: reset `stateLastStrPos` to `Nothing` before parse.
    + Rename takeWhileP -> take1WhileP and clean it up.
      (It doesn't match the empty sequence.)

  * Text.Pandoc.PDF:

    + For PDFs via HTML, ensure temp file is deleted even if the pdf
      program is not found (#5720).
    + Better detection of a Cygwin environment (#5451).
    + Don't assume tex log file is UTF8-encoded (#5872).
      Fall back to latin1 if it can't be read as UTF-8.

  * Text.Pandoc.Extensions:

    + Export new function `getAllExtensions`, which returns the
      extensions that affect a given format (whether enabled by default
      or not) [API change].
    + Change type of `parseFormatSpec` from
      `Either ParseError (String, Extensions -> Extensions)`
      to `Either ParseError (String, [Extension], [Extension])`
      [API change].
    + Add `Ext_gutenberg` constructor to `Extension` [API change].
    + Add `Ext_native_numbering` constructor to `Extension` [API change]
      (Nils Carlson).

  * Text.Pandoc.Readers, Text.Pandoc.Writers:

    + Change type of `getReader` and `getWriter` so they return
      a value in the PandocMonad instance rather than an Either
      [API change].  Exceptions for unknown formats and unsupported
      extensions are now raised by these functions.

  * Text.Pandoc.App

    + Change `optMetadataFile` type from `Maybe FilePath` to `[FilePath]`
      (Owen McGrath, #5702) [API change].

  * Text.Pandoc.Logging:

    + Add `CouldNotDeduceFormat` constructor to `LogMessage` [API change].
      Issue this warning when we're falling back to markdown or
      html because we don't recognize the extension of the input or
      output files.
    + Clarify warning for missing title (#5760).
    + Add `UnusualConversion` constructor to `LogMessage` [API change]
      (Mauro Bieg, #5736).  Emit warning on `-f latex -o out.pdf`.

  * Lua filters:

    + Improve function documentation (Albert Krewkinkel).
    + Traverse nested blocks and inlines in correct order (Albert
      Krewinkel, #5667). Traversal methods are updated to use the new
      Walk module so that sequences with nested Inline (or Block) elements
      are traversed in the order in which they appear in the linearized
      document.
    + New unexported module `Text.Pandoc.Lua.Walk` (Albert Krewinkel).
      Lua filters must be able to traverse sequences of AST
      elements and to replace elements by splicing sequences back
      in their place. Special `Walkable` instances can be used for
      this; those are provided in a new module
      `Text.Pandoc.Lua.Walk`.
    + `Attr` values can now be given as normal Lua tables (Albert
      Krewinkel, #5744).  This can be used as a convenient alternative
      to constructing `Attr` values with `pandoc.Attr`. Identifiers
      are taken from the `id` field, classes must be given as
      space separated words in the `class` field. All remaining fields
      are included as attributes. With this change, the following lines
      now create equal elements:
      ```
      pandoc.Span('test', {id = 'test', class = 'a b', check = 1})
      pandoc.Span('test', pandoc.Attr('test', {'a','b'}, {check = 1}))
      ```
      This also works when using the *attr* setter:
      ```
      local span = pandoc.Span 'text'
      span.attr = {id = 'test', class = 'a b', check = 1}
      ```
      Furthermore, the *attributes* field of AST elements can now be a
      plain key-value table even when using the `attributes` accessor:
      ```
      local span = pandoc.Span 'test'
      span.attributes = {check = 1}   -- works as expected now
      ```
    + Export `make_sections`, remove `hierarchicalize`. Lua filters that
      use `hierarchicalize` will need to be rewritten to use
      `make_sections`.
    + Add a `clone()` method to all AST elements (Albert Krewinkel, #5568).
    + Fix Lua function names in pandoc.system (niszet). Change
      `get_current_directory` to `get_working_directory` and
      `with_temp_directory` to `with_temporary_directory`, to
      conform to the manual.

  * Text.Pandoc.Error:

    + Add constructors `PandocUnknownReaderError`,
      `PandocUnknownWriterError`, `PandocUnsupportedExtensionError`.
      [API change].
    + Better message for `PandocShouldNeverHappenError`.
    + Better message for `PandocTemplateError`.

  * Text.Pandoc.Emoji:

    + Update emoji list (#5666). Done using new `tools/emojis.hs`,
     which uses the list from the gem GitHub uses. Future updates
     can be done with this tool.

  * Text.Pandoc.PDF:

    + Pass value of `--dpi` to `rsvg-convert` when converting SVG to PDF
      in the process of creating a PDF (#5721).

  * Text.Pandoc.Shared:

    + Replace `Element` and `makeHierarchical` with `makeSections`.
      Now that we have Divs, we can use them to represent the
      structure of sections, and we don't need a special Element type.
      `makeSections` reorganizes a block list, adding Divs with class
      `section` around sections, and adding numbering if needed.
      This change also fixes some longstanding issues recognizing section
      structure when the document contains Divs (#3057, see also #997).
    + Remove `Element` type [API change]
    + Remove `makeHierarchicalize` [API change]
    + Add `makeSections` [API change]
    + Export `deLink` [API change]
    + Make `filterIpynbOutput` strip ANSI escapes from code in output
      for non-ipynb formats, when the default "best" option is used with
      `--ipynb-output` (#5633).
    + Fix `camelCaseToHyphenated` so it handles `ABCDef` better.
    + Improve `isTight` (#5857).  If a list has an empty item,
      this should not count against its being a tight list.
    + Export `htmlSpanLikeElements` [API change] (Daniele D'Orazio, #5796).
      This is a mapping of HTML span-like elements that are internally
      represented as a Span with a single class.
    + Change the implementation of `htmlSpanLikeElements` to retain
      classes and attributes (#5882, Florian Beeres).

  * Text.Pandoc.Slides: recognize content in Divs when determining
    slide level.

  * Text.Pandoc.SelfContained:

    + Omit content-type on type attribute for `<style>` (#5725).
      It doesn't seem to be valid for HTML5, and as a result Chrome
      ignores the style element.

  * Text.Pandoc.Pretty has been removed [API change].
    We now use the new external doclayout module instead.

  * Text.Pandoc.Writers.Shared:

    + Remove `metaToJSON`, `metaToJSON'` [API change].
    + Modify `addVariablesToContext`, `defField`, `setField`, `getField`,
     `resetField` to work with Context rather than JSON values. [API change]
    + Export new function `endsWithPlain` [API change].
    + Change `gridTables` so it does better at keeping the widths of
      columns (#4320) and does better at figuring out column widths
      when no widths are given (#5899).

  * Text.Pandoc.Options

    + Change type of `writerTemplate` to `Maybe Template` instead
      of `Maybe String`.
    + Change To/FromJSON instances for `HTMLMathMethod`, `CiteMethod`,
      `ObfuscationMethod`, `TrackChanges`, `WrapOption`,
      `TopLevelDivision`, `ReferenceLocation`, `HTMLSlideVariant` (#5790).
      In each case we use lowercase (or hyphenated lowercase) for
      constructors to line up more closely with command-line option
      values.  This is a breaking change for those who manually decode or
      encode JSON for these data types (e.g. for `ReaderOptions` or
      `WriterOptions`).

  * Text.Pandoc.Filters:

    + Add `FromYAML` instance for `Filter`.
    + `applyFilters`: Add and apply filters in order (not reversed)
      This changes `applyFilters` from Text.Pandoc.Filter so
      that it does a left fold rather than a right fold, applying
      the filters in the order listed.

  * Text.Pandoc.XML:

    + Change `toEntities` to emit numerical hex character references
      (#5718).

  * Text.Pandoc.Highlighting:

    + Add additional listings languages (Wandmalfarbe).

  * Text.Pandoc.MediaBag:

    + Some of the types using Strings were switched to use FilePath instead
      (Christian Despres, #5884).

  * Text.Pandoc.Templates:

    + Don't import/export `varListToJSON` [API change].  It is removed in
      doctemplates >= 0.3.
    + Change type of `renderTemplate'` [API change].  Return value is
      now Text rather than being polymorphic.  This makes room for
      upcoming removal of the `TemplateTarget` class from doctemplates.

  * Text.Pandoc.App.Opt [API changes]:

    + More convenient To/FromJSON instances.  Make the field names
      like `strip-empty-paragraphs` rather than `optStripEmptyParagraphs`.
      Anyone who is using JSON serialization of Opt will need to adjust
      things accordingly.
    + Change `optHighlightStyle` to a `Maybe String` instead of
      `Maybe Style`.  Do the parsing/loading of themes later, after
      option parsing.
    + Remove `optBaseHeaderLevel` from `Opt`.  We now just use
      `optShiftHeadingLevelBy`, to avoid redundancy.
    + Change `optShiftHeadingLevel` to `optShiftHeadingLevelBy` to
      match the option.
    + Custom FromJSON instance for `LineEnding`, so either `CRLF`
      or `crlf` will work.
    + Change `optVariables` from `[(String, String)]` to `Context Text`.
    + Change `optMetadata` to `Meta`, to allow structured values.
      The current behavior of the `--metadata` option stays the same.
    + Rename `optReader`, `optWriter` as `optFrom`, `optTo`.
    + Add `FromYAML` instances to `Opt` and to all subsidiary types.
    + Rename `optMetadataFile` to `optMetadataFiles`.
    + Rename `optPDFEngineArgs` to `optPDFEngineOpts`.
    + Rename `optWrapText` to `optWrap`.
    + Add `IpynbOutput` enumerated type: use this instead of
      a string for `optIpynbOutput`.
    + Change optInputFiles to a `Maybe [FilePath]` (#5888) [API change].
      `Nothing` means: nothing specified.
      `Just []` means: an empty list specified (e.g. in defaults).
    + List fields in Opt so they aren't reversed (#5881) [API change].
      Previously `optIncludeInHeader`, etc. were in reverse order.
    + The `sourcefile` variable is now always a list. It used to be
      sometimes a string, sometimes a list (when there was more than one).

  * Template changes:

    + default.latex: added code for `cslreferences` environment,
      to be used for pandoc-citeproc references. A `csl-hanging-indent`
      variable (set automatically if there is a `hanging-ident`
      class on the references Div) controls whether contents of this
      environment receive a hanging indent.
    + default.latex: Add `space` as default option for xeCJK, so that
      spaces between words are preserved (#5855, jeongminkim-islab).
      This is necessary for Korean.
    + default.latex: Remove include of `grffile` (#5848).
      This package used to be needed for proper handling of image filenames
      containing periods (in addition to the period before the extension).
      It no longer works with the latest LaTeX kernel and graphicx,
      so we have removed it. Future versions of graphicx will handle
      these filenames without the need for `grffile`.
    + default.context: add a saner default for page numbers.
      Previously they appeared centered at the top of the page;
      now we put them centered at the bottom, unless the `pagenumbering`
      variable is set.
    + default.context: define a start-stop-pair `cslreferences` to
      allow for hanging indents in the bibliography (#5875, Denis Maier).
    + default.ms: update defaults.  Use Palatino font, use slightly
      wider interparagraph space, don't indent paragraphs,
      and put page numbers on the bottom.  This brings ms output
      closer to default LaTeX output.
    + default.revealjs: add navigationMode (Mauro Bieg, #5657).
    + default.muse: handle multiple authors better.
    + docbook4, docbook5 templates: add indentation to body.
    + HTML-based templates: use `styles.html` partial to avoid
      code duplication.
    + HTML-based templates: change indentation of styles in template.

  * reference.docx (#5820):

    + Change Block Text (block quote) style so that the same font
      is used as in the body text, and the block text is indented
      left and right.
    + All headings now have a uniform color.
    + Level-1 headings no longer set `w:themeShade="B5"`.
    + Level-2 headings are now 14 point rather than 16 point.
    + Level-3 headings are now 12 point rather than 14 point.
    + Level-4 headings are italic rather than bold.

  * epub.css: Add CSS for hanging-indent div to support pandoc-citeproc's
   new hanging indents.

  * pandoc.cabal:

    + Repeat ghc-options in all stanzas.
    + Remove conditionals for ghc < 8 (Albert Krewinkel, #5693).
    + Compile with `-Wcpp-undef` and `-fhide-source-paths` when possible
      (Albert Krewinkel).
    + Add cabal.project to extra-source-files (Albert Krewinkel).
    + Add dependency on skylighting-core (#5729). Even though it shouldn't
      be needed, some tools require it.
    + Require latest pandoc-types, texmath, skylighting, haddock-library.
    + Ensure TemplateHaskell is added to other-extensions when it is
      used (Vanessa McHale, #5728).
    + Remove `derive_json_via_th` flag; always use TH.  This cuts down
      on code duplication and reduces the chance for errors.  See #4083.

  * Makefile:

    + Add ghci target.
    + Add ghcid target.
    + Remove references to obsolete flag (#5694).

  * Benchmarks: fix failure on ipynb.

  * Use MathJax 3 (zorkow).

  * KaTeX math: respect `classoption=fleqn` variable,
    bump KaTeX version to 0.11.1 (#5815, Mauro Bieg).

  * Fix redundant constraint compiler warnings (Pete Ryland, #5625).

  * Use throwError instead of fail when appropriate.

  * Use Prelude.fail to avoid ambiguity with fail from GHC.Base.

  * Add `diff-zip.sh` to tools (John MacFarlane, Agustín Martín Barbero).
    This is intended to make it easier to test differences in zip
    containers, like epub, docx, or odt.

  * Add `.gitattributes` (#5747).  This ensures that the golden files
    in `test/fb2/reader/` don't have newlines converted. This should fix
    a test failure on GitHub CI with Windows.

  * Reorder options in `--help`.

  * Revise code for HsYAML-0.2.0.0 (@vijayphoenix, #5704).

  * Remove blank line in code example in Haddocks (Leif Metcalf, #5679).

  * Fix trypandoc with `getReader`/`getWriter` changes.

  * Allow building pandoc with GHC 8.8.

  * linux tarball: add architecture `-amd64` to filename.
    Now it will be: `pandoc-VERSION-linux-ARCH.tar.gz`.

  * MANUAL.txt:

    + Add section for exit codes.
    + Document some pptx limitations in slide show section:
      No incremental display (#5689).  No pause with `. . .` (#5701).
    + reveal.js flags (Mauro Bieg, #5653).
    + Document addition of `data-` prefix to unknown attributes in HTML5.
    + Link to YAML spec (Mauro Bieg, #5687).
    + Fix capitalization of "Linux" (#5859, Marcus Stollsteimer).
    + Use a table for exit codes.
    + Put all template variable docs into one section.
    + Use ATX headers consistently.
    + Add fuller documentation of templates (#5779), including
      new template syntax, partials, etc.
    + Add documentation for the variable `hyperrefoptions` (Wandmalfarbe).
    + Clarify when macro definitions are passed as raw latex.
      In Markdown input, they are always passed through.  In LaTeX, only if
      `latex_macros` is disabled.
    + Clarify that `--dpi` provides a default and doesn't override
      dpi values specified in the images themselves (#5721).
    + Document how to use custom writers with `--standalone` (#5866).
    + Clarify `--preserve-tabs` default.

  * INSTALL.md:

    + Fix instructions for libicu.
    + Add Void Linux instructions (Volodymyr Kozachnyskyi).

  * CONTRIBUTING.md:

    + Add information on tests (Agustín Martín Barbero, #5652).
    + Add information about command test naming to CONTRIBUTING (Florian B).

  * Fix typos in changelog and comments (#5896, Brian Wignall).

  * doc/lua-filters.md:

    + Fix mistakes in mediabag module docs (#5851, Albert Krewinkel).
    + Improve metadata replacement example in lua-filters doc (#5851).
    + Mention which Lua version is shipped with pandoc (Albert Krewinkel,
      #5892).

## pandoc 2.7.3 (2019-06-11)

  * Add `jira` (Atlassian's Jira wiki markup) as output format (#2497,
    Albert Krewinkel).

  * Add `tex_math_dollars` to `multimarkdownExtensions` (#5512).
    This form is now supported in multimarkdown,
    in addition to `tex_math_double_backslash`.

  * Fix `--self-contained` so it works when output format has extensions.
    Previously if you used `--self-contained` with `html-smart` or
    `html+smart`, it wouldn't work.

  * Add template variable `curdir` with working directory
    from which pandoc is run (#5464).

  * Markdown reader: don't create implicit reference for empty header
    (#5549).

  * Muse reader: allow images inside link descriptions (Alexander Krotov).

  * HTML reader: epub related fixes.

    + With epub extensions, check for `epub:type` in addition to `type`.
    + Fix problem with noteref parsing which caused block-level
      content to be eaten with the noteref.
    + Rename `pAnyTag` to `pAny`.
    + Refactor note resolution.
    + Trim definition list terms (Alexander Krotov).

  * LaTeX reader:

    + Add braces when resolving `\DeclareMathOperator`
      (#5441).  These seem to be needed for xelatex but not pdflatex.
    + Allow newlines in `\mintinline`.
    + Pass through unknown listings language as class (#5540).
      Previously if the language was not in the list of languages supported
      by listings, it would not be added as a class, so highlighting
      would not be triggered.
    + `rawLaTeXInline`: Include trailing `{}`s in raw latex commands (#5439).
      This change affects the markdown reader and other readers that allow raw
      LaTeX.  Previously, trailing `{}` would be included for unknown
      commands, but not for known commands.  However, they are sometimes used
      to avoid a trailing space after the command.  The chances that a `{}`
      after a LaTeX command is not part of the command are very small.

  * MediaWiki reader: handle multiple attributes in table row (#5471,
    chinapedia).

  * Docx reader: Add support for `w:rtl` (#5545).  Elements with this
    property are put into Span inlines with `dir="rtl"`.

  * DocBook reader: Issue `IgnoredElement` warnings.

  * Org reader (Albert Krewinkel):

    + Fix planning elements in headers level 3 and higher
      (#5494).  Planning info is now always placed before
      the subtree contents.  Previously, the planning info was placed after
      the content if the header's subtree was converted to a list, which
      happens with headers of level 3 and higher per default.
    + Omit, but warn about unknown export options.  Unknown export
      options are properly ignored and omitted from the output.
    + Prefer plain symbols over math symbols (#5483).
      Symbols like `\alpha` are output plain and unemphasized, not as math.
    + Recognize emphasis after TODO/DONE keyword (#5484).

  * FB2 reader:

    + Skip unknown elements rather than throwing errors (#5560).
      Sometimes custom elements are used (e.g. `id` element
      inside `author`); previously the reader would halt with an error.
      Now it skips the element and issues an `IgnoredElement` warning.
    + Parse notes (#5493, Alexander Krotov).
    + Internal improvements (Alexander Krotov).

  * OpenDocument writer:  Roll back automatic figure/table numbering
    (#5474).  This was added in pandoc 2.7.2, but it makes it impossible
    to use pandoc-crossref. So this has been rolled back for now,
    until we find a good solution to make this behavior optional
    (or a creative way to let pandoc-crossref and this feature
    to coexist).

  * New module Text.Pandoc.Writers.Jira, exporting `writeJira` [API
    change] (Albert Krewinkel).

  * EPUB writer:

    + Don't include 'landmarks' if there aren't any.
      Previously we could get an empty ol element, which caused
      validation errors with epubcheck.
    + Ensure unique ids for styleesheets in content.opf (#5463).
    + Make stylesheet link compatible with kindlegen (#5466,
      Eric Schrijver).  Pandoc omitted `type="text/css"` from both
      `<style>` and `<rel="stylesheet">` elements in all templates, which
      is valid according to the spec. However, Amazon’s kindlegen software
      relies on this attribute on `<link>` elements when detecting
      stylesheets to include.

  * HTML writer:

    + Output video and audio elements depending on file
      extension of the image path (Mauro Bieg).
    + Emit empty alt tag in figures (#5518, Mauro Bieg).
      The same text is already in the <figcaption> and
      screen-readers would read it twice, see #4737.
    + Don't add variation selector if it's already there.
      This fixes round-trip failures.
    + Prevent gratuitous emojification on iOS (#5469).
      iOS chooses to render a number of Unicode entities, including '↩', as
      big colorful emoji.  This can be defeated by appending Unicode
      VARIATION SELECTOR-15'/'VARIATION SELECTOR-16'.  So we now append this
      character when escaping strings, for both '↩' and '↔'.  If other
      characters prove problematic, they can simply be added to
      `needsVariationSelector`.  + Add `class="heading"` to level 7+ Headers
      rendered as `<p>` elements (#5457).

  * RST writer: treat Span with no attributes as transparent (#5446).
    Previously an Emph inside a Span was being treated as
    nested markup and ignored.  With this patch, the Span
    is just ignored.

  * LaTeX writer:

    + Include inline code attributes with `--listings` (#5420).
    + Don't produce columns environment unless beamer (#5485).
    + Fix footnote in image caption.  Regression: the fix for #4683 broke
      this case.
    + Don't highlight code in headings (#5574).  This causes
      compilation errors.
    + Use `\mbox` to get proper behavior inside `\sout` (#5529).

  * EPUB writer: Fix document section assignments (#5546).
    For example, introduction should go in bodymatter, not frontmatter, and
    epigraph, conclusion, and afterward should go in bodymatter, not
    backmatter.  For the full list of assignments, see the manual.

  * Markdown writer:

    + Add backslashes to avoid unwanted interpretation of
      definition list terms as other kinds of block (#554).
    + Ensure the code fence is long enough (#5519).
      Previously too few backticks were used when the code block
      contained an indented line of backticks.  (Ditto tildes.)
    + Handle labels with integer names (Jesse Rosenthal, #5495).
      Previously if labels had integer names, it could produce a conflict
      with auto-labeled reference links. Now we test for a conflict and
      find the next available integer.  This involves adding a new state
      variable `stPrevRefs` to keep track of refs used in other document
      parts when using `--reference-location=block|section`

  * Textile writer: fix closing tag for math output (Albert Krewinkel).
    Opening and closing tag for math output match now.

  * Org writer: always indent src blocks content by 2 spaces (#5440, Albert
    Krewinkel).  Emacs always uses two spaces when indenting the content of
    src blocks, e.g., when exiting a `C-c '` edit-buffer. Pandoc used to
    indent contents by the space-equivalent of one tab, but now always uses
    two spaces, too.

  * Asciidoc writer:

    + Use `` `+...+` `` form for inline code.
      The old `` `a__b__c` `` yields emphasis inside code in asciidoc.
      To get a pure literal code span, use `` `+a__b__c+` ``.
    + Use proper smart quotes with asciidoctor (#5487).
      Asciidoctor has a different format for smart quotes.
    + Use doubled ## when necessary for spans (#5566).
    + Ensure correct nesting of strong/emph (#5565): strong
      must be the outer element.

  * JATS writer:

    + Wrap elements with p when needed (#5570).  The JATS spec restricts
      what elements can go inside `fn` and `list-item`.  So we wrap other
      elements inside `<p specific-use="wrapper">` when needed.
    + Properly handle footnotes (#5511) according to "best practice."
      (Group them at the end in `<fn-group>` and use `<xref>` elements
      to link them.)
    + Fix citations with PMID so they validate (#5481).  This includes
      an update to data/jats.csl.
    + Ensure validity of `<pub-date>` by parsing the date and
      extracting year, month, and day, as expected.  Also add an
      iso-8601-date attribute automatically.
    + Don't use `<break>` element for LineBreak. It is only
      allowed in a few special contexts, and not in `<p>` elements.
    + Don't make `<string-name>` a child of `<string>`, which is illegal.

  * FB2 writer:

    + Do not wrap note references into `<sup>` and brackets
      (Alexander Krotov).  Existing FB2 readers, such as FBReader, already
      display links with type="note" as a superscript.
    + Use genre metadata field (#5478).

  * Muse writer: do not escape empty line after `<br>` (Alexander Krotov).

  * Add unicode code point in "Missing character" warning (#5538).
    If the character isn't in the console font, the message is pretty useless,
    so we show the code point for anything non-ASCII.

  * Lua: add Version type to simplify comparisons (Albert Krewinkel).
    Version specifiers like `PANDOC_VERSION` and `PANDOC_API_VERSION` are
    turned into `Version` objects. The objects simplify version-appropriate
    comparisons while maintaining backward-compatibility.
    A function `pandoc.types.Version` is added as part of the newly
    introduced module `pandoc.types`, allowing users to create version
    objects in scripts.

  * pandoc lua module (Albert Krewinkel):

    - Fix deletion of nonexistent attributes (#5569).
    - Better tests for Attr and AttributeList.

  * pandoc.mediabag lua module (Albert Krewinkel):

    + Add function `delete` for deleting a single item.
    + Add function `empty` for removing all entries.
    + Add function `items` for iterating over mediabag.

  * Text.Pandoc.Class: Fix handling of `file:` URL scheme in
    `downloadOrRead` (#5517, Mauro Bieg).  Previously `file:/`
    URLs were handled wrongly and pandoc attempted to make HTTP
    requests, which failed.

  * Text.Pandoc.MIME: add `mediaCategory` [API change] (Mauro Bieg).

  * Text.Pandoc.Shared:

    + Add `onlySimpleTableCells` [API change]
      (Mauro Bieg) and use this to consolidate simple-table detection
      (#5524).  This fixes an inconsistency in the HTML reader, which did not
      treat tables with `<p>` inside cells as simple.
    + `metaToJSON`: treat digits starting with 0 as a string, not a number
      (#5479).  This fixes a regression in YAML metadata in pandoc 2.7.2.

  * Text.Pandoc.Logging: Add `IgnoredElement` constructor for
    `LogMessage`.  `SkippedConetnt` doesn't work for some XML-based
    readers which don't have access to parsec source positions.

  * Text.Pandoc.Asciify: Add Turkish undotted-i (#5433, Mauro Bieg).

  * Improve output of Lua tests (#5499, Albert Krewinkel).
    This makes use of tasty-lua, a package to write tests in Lua
    and integrate the results into Tasty output. Test output becomes
    more informative: individual tests and test groups become visible
    in test output. Failures are reported with helpful error messages.

  * Lua: add `pandoc.system` module (#5468, Albert Krewinkel).
    The `system` Lua module provides utility functions to interact with the
    operating- and file system. E.g.
    `print(pandoc.system.get_current_directory())`
    or
    ```lua
        pandoc.system.with_temporary_directory('tikz', function (dir)
          -- write and compile a TikZ file with pdflatex
        end)
    ```

  * LaTeX template: Add pdflang to hypersetup if lang is set (#5443).

  * beamer template: Fix using Beamer with geometry (#5505, Daniel Maslowski).
    Beamer already loads geometry, so we need to use the `\geometry`
    command to set geometry options.

  * EPUB2/3 templates: Move inline styles to default epub.css (#5466).
    NOTE: Those who use a custom CSS stylesheet with EPUB should
    add these lines:

        code{ white-space: pre-wrap; }
        span.smallcaps{ font-variant: small-caps; }
        span.underline{ text-decoration: underline; }
        q { quotes: "“" "”" "‘" "’"; }
        div.column{ display: inline-block; vertical-align: top; width: 50%; }

  * reveal.js template:

    + Updates for revealjs 3.8.0 (#5435, ebiim).
    + Remove reference to head.min.js (#5448, Winnie Hellmann).
      NOTE: users will need to update reveal.js to at least 3.8.0
      for their presentations generated with this version of pandoc
      to work correctly.

  * Text.Pandoc.PDF:

    + Replace `</>` with literal `/` (#5451).
      We use forward-slash for a directory separator in tmpDir,
      even on Windows (because that's what tex likes).  So we
      should not put a backslash between the tmpDir and the
      filename on Windows.  This is harmless enough in normal
      Windows setups, but it breaks on Cygwin.
      Thanks to @cc2x for noticing and diagnosing the problem.
    + Allow use of `-output-directory` in `--pdf-engine-opt` (#5462).
      This is currently possible with `mklatex` and `-outdir`, but
      was not yet possible with xelatex and `-output-directory`.
    + For PDF via ms/pdfroff, make TOC appear at beginning and in
      PDF bookmarks (#5553).  Previously the TOC appeared at the end
      of the document, and was not bookmarked.  To keep it at the end,
      add `--pdf-engine-opt=--no-toc-relocation` to your command line.

  * Fix broken links in documents (#5473, Shim Myeongseob).
    Also, use absolute links to pandoc.org when possible, so that
    the links can be followed by people viewing these documents
    on GitHub.

  * Improved sample lua tikz filter in lua-filters docs (#5445,
    Matthew Doty).  There are three changes:

    + It only processes elements which begin with `\begin{tikzpicture}`
    + It uses pdf2svg instead of imagemagick to preserve fidelity
    + The images produced have transparent backgrounds

  * MANUAL.txt:

    + Add note about `title-meta`, `author-meta`, `date-meta` (#5486).
    + Fix typo (#5489, Christian Krause).

  * add test/tables.xwiki to git and pandoc.cabal (#5498, Mauro Bieg).

  * Disable missing-home-modules warning in `stack.yaml`.
    Otherwise `stack ghci` fails.


## pandoc 2.7.2 (2019-04-05)

  * Add XWiki writer (#1800, Derek Chen-Becker).
    Add `Text.Pandoc.Writers.XWiki`, exporting `writeXWiki` [API change].

  * Dokuwiki Reader: parse single curly brace (#5416, Mauro Bieg).

  * Vimwiki reader: improve handling of internal links (#5414).
    We no longer append `.html` to link targets, and we add a title
    `wikilink`.  This mirrors behavior of other wiki readers.  Generally
    the `.html` extension is not wanted.  It may be important for output
    to HTML in certain circumstances, but it can always be added using a
    filter that matches on links with title `wikilink`.

    If your workflow requires the current behavior, here is a lua filter
    that will add the `.html` extension:

    ```lua
    function Link(el)
      if el.title == 'wikilink' then
        el.target = el.target .. ".html"
      end
      return el
    end
    ```
  * ipynb reader:

    + Use format `ipynb` for raw cell where no format given.
    + Avoid introducing spurious `.0` on integers in metadata.

  * Markdown reader: fenced div takes priority over setext header.

  * HTML reader: read `data-foo` attribute into `foo` (#5392).
    The HTML writer adds the `data-` prefix for HTML5 for nonstandard
    attributes.  But the attributes are represented in the AST without
    the `data-` prefix, so we should strip this when reading HTML.

  * LaTeX reader: Improve autolink detection (#5340).

  * PowerPoint writer (Jesse Rosenthal):

    + Expand builtin reference doc to model all layouts.
      The previous built-in reference doc had only title and content
      layouts. Add in a section-header slide and a two-content slide, so
      users can more easily modify it to build their own templates.
    + Always open up in slide view.  When editing a
      template/reference-doc, the user might be in Master view, but when
      producing a slide show, it is assumed that slide view will be
      desired.
    + Remove `handoutsMasterList` from template presentation.xml
    + Fix numerous errors in templating (#5402). Previously, some templates
      produced by Office 365 (MacOS) would not render with `--reference-doc`
      correctly. We now apply correct shapes for content, and build
      shape trees correctly.
    + Make default placeholder type for template lookup.
    + Apply speaker notes to metadata slide if applicable.
    + Test for speaker notes after breaking header.
    + Correctly handle notes after section-title header.
      Previously, if notes came after a section-title header (ie, a level-1
      header in a slide-level=2 presentation), they would go on the next
      slide. This keeps them on the slide with the header.
    + Internal improvements.

  * ipynb writer:

    + Use format `ipynb` for raw cell where no format given.
      According to nbformat docs, this is supposed to render in every
      format.  We don't do that, but we at least preserve it as a raw
      block in markdown, so you can round-trip.
    + Consolidate adjacent raw blocks.  Sometimes pandoc creates two
      HTML blocks, e.g. one for the open tag and one for a close tag.
      If these aren't consolidated, only one will show up in output cell.
    + Fixed carry-over of nbformat from metadata.
    + Preserve `nbformat_minor` if it's given.  This helps with round-tripping.

  * LaTeX writer:

    + Avoid inadvertently creating ?` or !` ligatures (#5407).
      These are upside down ? and !, resp.
    + Fix footnotes in table caption and cells (#5367).  This fixes a
      bug wherein footnotes appeared in the wrong order, and with
      duplicate numbers, when in table captions and cells.
      We now use regular `\footnote` commands, even in the table
      caption and the minipages containing cells. Apparently
      longtable knows how to handle this.

  * HTML writer: Don't add data- prefix to RDFa attributes (#5403).

  * JATS writer: Ensure that plain strings go inside `<pub-id>` tag (#5397).

  * Markdown writer:

    + Better rendering of numbers (#5398).  If the number is integral,
      we render it as an integral not a float.
    + Proper rendering of empty map in YAML metadata (#5398).  Should
      be `{}`, not empty string.
    + Properly escape attributes in Markdown writer (#5369).
    + Be sure implicit figures work in list contexts (#5368).
      Previously they would sometimes not work: e.g., when they
      occurred in final paragraphs in lists that were originally
      parsed as Plain and converted later using PlainToPara.

  * Docx writer: Use `w:br` without attributes for line breaks (#5377).
    We previously added the attribute `type="textWrapping"`, but
    this causes problems on Word Online.

  * LaTeX template (Andrew Dunning):

    + Ensure correct heading/table order (#5365).  Improve workaround
      (#1658) for tables following headings.  The new solution works whether
      or not the `indent` variable is enabled.
    + Remove `subparagraph` variable. The default is now to use run-in
      style for level 4 and 5 headings (`\paragraph` and `\subparagraph`).
      To get the previous default behavior (where these were formatted as
      blocks, like `\subsubsection`), set the `block-headings` variable.
    + Add pandoc to PDF metadata (#5388).
    + Group graphics-related code (#5389).
    + Move `\setstretch` after front matter (#5179).  Ensures that
      `\maketitle`, `\tableofcontents`, and so forth are not affected by
      changes to line spacing.

  * Update data/jats.csl to avoid commas between name-part elements
    (#5397).

  * Add support for golang (`go`) with `--listings` (#5427).

  * Text.Pandoc.Shared - improve `metaToJSON` behavior with numbers.
    We now do a better job marshalling numbers from MetaString
    or MetaInlines into JSON Number.

  * Text.Pandoc.Writers.Shared: `metaValueToJSON`: use Number Values for
    integers.  Pandoc's MetaValue doesn't have a distinguished number type,
    so numbers are put in MetaStrings.  If the MetaString consists
    entirely of digits, we convert it to a Number.  We should probably
    consider adding a MetaNumber constructor to MetaValue, for better
    round-tripping with JSON etc.  This change aids round-tripping in
    ipynb metadata fields, like `toc_depth`.

  * Text.Pandoc.Class: `fetchItem`: don't treat UNC paths as
    protocol-relative URLs (#5127).  These are paths beginning `//?/UNC/...`.

  * Text.Pandoc.ImageSize: Improve `pdfSize` so it handles
    a wider range of PDFs (#4322, with help from Richard Davis).

  * Text.Pandoc.Pretty: avoid stack overflow by using strict sum (#5401).

  * Fix harmless error in file-scope code (#5422).

  * MANUAL.txt:

    + Improve 'header' and 'heading' usage (#5423, Andrew
      Dunning).  The term 'header' was being used where 'heading'
      is more appropriate.
    + Add paragraph on options affecting markdown in ipynb.

  * stack.yaml - remove -Wmissing-home-modules
    This seems to cause problems with stack ghci.  Remove RTS options.

  * Add ghc-options to cabal.project.

  * appveyor.yml - use ghc 8.6.4.  Fixes segfault issues on Windows (#5037).

  * linux build process: Remove clone of pandoc-citeproc (#5366).
    It wasn't being used; cabal.project specifies the version to use.

## pandoc 2.7.1 (2019-03-14)

  * Add tectonic as an option for --pdf-engine (#5345, Cormac Relf).
    Runs tectonic on STDIN instead of a temporary .tex file, so that it
    looks in the working directory for `\include` and `\input` like the rest
    of the engines.  Allows overriding the output directory
    args with `--pdf-engine-opt=--outdir --pdf-engine-opt="$DIR"`.

  * Allow `-o/--output` to be used with `--print-default-data-file`,
    `--print-highlighting-style`, `--print-default-template`.
    Note that `-o` must occur BEFORE the `--print*` command on the command
    line (this is documented, #5357).

  * LaTeX reader:

    + Support `\underline`, `\ul`, `\uline` (#5359, Paul
      Tilley).  These are parsed as a Span with class `underline`, as
      with other readers.
    + Ensure that `\Footcite` and `\Footcites` get put in a note.

  * ipynb reader:

    + Remove sensitivity to `raw_html`, `raw_tex` extensions.
      We now include every output format. Pruning is handled by
      `--ipynb-output`.
    + Better handling of cell metadata.  We now include even complex cell
      metadata in the Div's attributes (as JSON, in complex cases, or
      as plain strings in simple cases).

  * ipynb writer:

    + Recurse into native divs for output cell data (#5354).
    + Render cell metadata fields from div attributes.

  * Docx writer: avoid extra copy of abstractNum and num elements
    in numbering.xml.  This caused pandoc-produced docx files to
    be uneditable using Word Online (#5358).

  * Markdown writer: improve handling of raw blocks/inline.
    We now emit raw content using `raw_attribute` when no more
    direct method is available.  Use of `raw_attribute` can be
    forced by disabling `raw_html` and `raw_tex`.

  * LaTeX writer: Add classes for frontmatter support (#5353, Andrew Dunning)
    and remove frontmatter from `scrreprt`.

  * LaTeX template:

    + Improve readability (#5363, Andrew Dunning).
    + Robust section numbering removal (#5351, Andrew Dunning).
      Ensures that section numbering does not reappear with custom
      section levels.  See <https://tex.stackexchange.com/questions/473653/>.
    + Better handling of front/main/backmatter (#5348).
      In pandoc 2.7 we assumed that every class with chapters would accept
      `\frontmatter`, `\mainmatter`, and `\backmatter`.  This is not so (e.g.
      report does not).  So pandoc 2.7 breaks on report class by including an
      unsupported command.  Instead of the `book-class` variable, we use two
      variables, `has-chapters` and `has-frontmatter`, and set these
      intelligently in the writer.

  * Text.Pandoc.Shared: Improve `filterIpynbOutput`.  Ensure that
    images are prioritized over text. `best` should include everything
    for ipynb.

  * Tests.Old: specify `--data-dir=../data` to ensure tests can find
    data files even if they haven't been installed.  Remove old
    `pandoc_datadir` environment variable, which hasn't done anything for a
    long time.

  * MANUAL.txt: Add recommendation to use `raw_attribute` with ipynb (#5354).

  * Use cmark-gfm-hs 0.1.8 (note that 0.1.7 is buggy).

  * Use latest pandoc-citeproc, texmath.


## pandoc 2.7 (2019-03-03)

  * Use XDG data directory for user data directory (#3582). Instead of
    `$HOME/.pandoc`, the default user data directory is now
    `$XDG_DATA_HOME/pandoc`, where `XDG_DATA_HOME` defaults to
    `$HOME/.local/share` but can be overridden by setting the
    environment variable. If this directory is missing, then
    `$HOME/.pandoc` is searched instead, for backwards compatibility.
    However, we recommend moving local pandoc data files from
    `$HOME/.pandoc` to `$HOME/.local/share/pandoc`. On Windows the
    default user data directory remains the same.

  * Slide show formats behavior change:  content under headers
    less than slide level is no longer ignored, but included in
    the title slide (for HTML slide shows) or in a slide after
    the title slide (for beamer).  This change makes possible
    2D reveal.js slideshows with content in the top slide on
    each stack (#4317, #5237).

  * Add command line option `--ipynb-output=all|none|best` (#5339).
    Output cells in ipynb notebooks often contain several different
    versions of an output, with different MIME types, e.g. an HTML
    table and a plain-text fallback.  Specifying `--ipynb-output=best`
    (the default) ensures that the best version for the output format
    is used.  `all` includes all versions, and `none` suppresses them
    all, leaving output cells empty.

  * `asciidoctor` is now an output format separate from `asciidoc`,
    to accommodate some minor implementation-specific differences
    (currently just in the treatment of display math).

  * Add `latexmk` as an option for `--pdf-engine` (#3195).
    Note that you can use `--pdf-engine-opt=-outdir=bar` to specify
    a persistent temp directory.

  * Markdown reader:

    + Improve tight/loose list handling (#5285). Previously the
      algorithm allowed list items with a mix of Para and Plain, which
      is never wanted.
    + Add newline when parsing blocks in YAML (#5271). Otherwise last
      block gets parsed as a Plain rather than a Para. This is a
      regression in pandoc 2.x. This patch restores pandoc 1.19
      behavior.
    + Make `yamlToMeta` respect extensions (#5272, Mauro Bieg).
      This adds a `ReaderOptions` parameter to `yamlToMeta` [API change].
    + Fix bug parsing fenced code blocks (#5304). Previously parsing
      would break if the code block contained a string of backticks of
      sufficient length followed by something other than end of line.

  * LaTeX reader: don't let `\egroup` match `{`. `braced` now actually
    requires nested braces. Otherwise some legitimate command and
    environment definitions can break.

  * Docx reader (Jesse Rosenthal):

    + Rename `getDocumentPath` as `getDocumentXmlPath`.
    + Use field notation for setting `ReaderEnv`.
    + Figure out `document.xml` path once at the beginning of parsing, and
      add it to the environment, so we can avoid repeated lookups.
    + Dynamically determine main document xml path (#5277).
      The desktop Word program places the main document file in
      `word/document.xml`, but the online word places it in
      `word/document2.xml`. This file path is actually stated in the root
      `_rels/.rels` file, in the `Relationship` element with an
      `http://../officedocument` type.
    + Fix paths in archive to prevent Windows failure (#5277).
      Some paths in archives are absolute (have an opening slash) which, for
      reasons unknown, produces a failure in the test suite on MS
      Windows. This fixes that by removing the leading slash if it exists.
    + Add comments to aid code readability.
    + Trim space inside the last inline (#5273).
    + Unwrap sdt elements in footnotes and comments (#5302).

  * Muse reader (Alexander Krotov):

    + Test that block level markup does not break `<verbatim>`.
    + Add secondary note support.

  * ipynb reader: handle images referring to attachments. Previously
    we didn't strip off the attachment: prefix, so even though the
    attachment was available in the mediabag, pandoc couldn't find it.

  * JATS reader:

    + Fix parsing of figures (#5321). This ensures that a figure
      containing a single image is parsed as a pandoc "implicit
      figure" (i.e., a Para with a single Image whose title attribute
      begins with `fig:`). More complex figures will still be parsed
      as divs.
    + Support `fig-group` block element (#5317).
    + Handle citations with multiple references (#5310). The `rid`
      attribute can have a space-separated list of ids.

  * AsciiDoc Writer: Add `writeAsciiDoctor` [API change, Tarik Graba].
    Handle display math appropriately for Asciidoctor.

  * JATS writer: wrap figure caption in `<p>` to fix validation (#5290,
    Mauro Bieg).

  * HTML writer:

    + Implement WAI-ARIA roles for (end)notes, citations, and
      bibliography (#4213). Note that doc-biblioref is only used when
      link-citations produces links, since it belongs on links.
    + Include content (including speaker notes) in title slides
      (#4317, #5237).

  * ipynb writer:

    + Ensure final newline.
    + Only include metadata under `jupyter` field.
    + Don't create attachments for images with absolute URIs,
      including data: URIs (#5303).
    + Keep plain text fallbacks in output even if a richer format is
      included (#5293). We don't know what output format will be needed.
      See the `--ipynb-output` command line option for a way to control
      what formats are included in the output.

  * Markdown writer: use `markdown="1"` when appropriate for Divs:
    when `native_divs` and `markdown_in_html_blocks` are disabled
    but `raw_html` and `markdown_attribute` are enabled.

  * LaTeX writer:

    + Use right fold for `escapeString`.  This is more elegant than
      the explicit recursive code we were using.
    + Avoid `{}` after control sequences when escaping.
      `\ldots{}.` doesn't behave as well as `\ldots.` with the latex
      ellipsis package.  This patch causes pandoc to avoid emitting
      the `{}` when it is not necessary.  Now `\ldots` and other
      control sequences used in escaping will be followed by either
      a `{}`, a space, or nothing, depending on context.
    + For beamer, include contents under headers superordinate to
      slidelevel (#4317). Currently we keep the fancy title slide, and
      add a new slide with the same title and whatever content was
      under the header.

  * Powerpoint writer (Jesse Rosenthal): support underlines.
    Use span with single class "underline" as in docx writer.

  * Muse writer: escape secondary notes (Alexander Krotov).

  * FB2 writer: add section identifiers support (#5229, John KetzerX).

  * Make `--fail-if-warnings` work for PDF output (#5343).

  * Lua filters (Albert Krewinkel):

    + Load module `pandoc` before calling `init.lua` (#5287). The file
      `init.lua` in pandoc's data directory is run as part of pandoc's
      Lua initialization process. Previously, the `pandoc` module was
      loaded in `init.lua`, and the structure for marshaling was
      set up after. This allowed simple patching of element
      marshaling, but made using `init.lua` more difficult. Now, all
      required modules are now loaded before calling `init.lua`. The
      file can be used entirely for user customization. Patching
      marshaling functions, while discouraged, is still possible via
      the `debug` module.
    + All Lua modules bundled with pandoc, i.e., `pandoc.List`,
      `pandoc.mediabag`, `pandoc.utils`, and `text` are re-exported from the
      `pandoc` module. They are assigned to the fields `List`, `mediabag`,
      `utils`, and `text`, respectively.

  * Text.Pandoc.Lua (Albert Krewinkel):

    + Split `StackInstances` into smaller Marshaling modules.
    + Get `CommonState` from Lua global. This allows more control over
      the common state from within Lua scripts.

  * LaTeX template:

    + Support the `subject` metadata variable (#5289, Pascal Wagler).
    + Add `\frontmatter`, `\mainmatter`, `\backmatter`
      for book classes (#5306).

  * epub3 template: Add titlepage class to section (#5269).

  * HTML5 template: Add ARIA role `doc-toc` for table of contents (#4213).

  * Make `--metadata-file` use selected extensions (#5279, #5272, Mauro Bieg).

  * Text.Pandoc.Shared:

    + Remove `withTempDir` [API change].
    + Add new exported function `defaultUserDataDirs` [API change].
    + Add `filterIpynbOutput` [API change].
    + `compactify`: Avoid lists with a mix of Plain and Para elements
      (#5285).

  * Text.Pandoc.Translations: reorder alphabetically and remove `Author`
    (#5334, Mauro Bieg).

  * Text.Pandoc.Extensions:

    + More carefully groom ipynb default extensions.
    + Add `all_symbols_escapable` to `githubMarkdownExtensions`.

  * Text.Pandoc.PDF:

    + Use system temp directory when possible (#1192). Previously we
      created temp dirs in the working directory, partly (a) because
      there were problems using the system temp directory on Windows,
      when their pathnames included tildes, and partly (b) because
      programs like `epstopdf.pl` would not be allowed to write to
      directories outside the working directory in restricted mode. We
      now (a) use the system temp dir except when the path includes
      tildes, and (b) set `TEXMFOUTPUT` when creating the PDF, so that
      subsidiary programs can use the system temp directory. This
      addresses problems that occurred when pandoc was used in a
      synced directory (such as Dropbox).
    + Change types of subsidiary functions to PandocIO, to allow
      warnings to be threaded through (#5343).

  * Text.Pandoc.MIME: add WebP (#5267, Mauro Bieg).

  * Tests: avoid calling `findPandoc` multiple times.

  * Old tests: remove need for temp files by using `pipeProcess`.

  * Added simple ipynb reader/writer tests (#5274).

  * Rearrange `--help` output in a more rational way, with common
    options at the beginning and options grouped by function (#5336).

  * trypandoc: Add JATS and other missing formats (Arfon Smith, #5291).

  * Add missing copyright notices and remove license boilerplate (#4592,
    Albert Krewinkel).

  * Use latest basement/foundation on 32bit windows.

  * Use latest skylighting (#5328). Custom syntax definitions no
    longer try to load `language.dtd`.

  * Require texmath 0.11.2.1

  * Use latest pandoc-citeproc (0.16.1.1).

  * MANUAL.txt:

    + Clarify variable substitution indentation in templates (#5338,
      Agustín Martín Barbero).
    + Reorder custom-styles section (#5324, Mauro Bieg).

## pandoc 2.6 (2019-01-30)

  * Support ipynb (Jupyter notebook) as input and output format.

    + Add `ipynb` as input and output format (extension `.ipynb`).
    + Added Text.Pandoc.Readers.Ipynb [API change].
    + Added Text.Pandoc.Writers.Ipynb [API change].
    + Add `PandocIpynbDecodingError` constructor to Text.Pandoc.Error.Error
      [API change].
    + Depend on ipynb library.
    + Note: there is no template for ipynb.

  * Add DokuWiki reader (#1792, Alexander Krotov).  This adds
    Text.Pandoc.Readers.DokuWiki [API change], and adds `dokuwiki`
    as an input format.

  * Implement task lists (#3051, Mauro Bieg). Added `task_lists`
    extension. Task lists are supported from markdown and gfm input.
    They should work, to some degree, in all output formats, though in
    most formats you'll get a bullet list with a unicode character for
    the box. In HTML, you get checkboxes and in LaTeX/PDF output, a
    box is used as the list marker. API changes:

    + Added constructor `Ext_task_lists` to `Extension`.
    + Added `taskListItemFromAscii` and `taskListItemToAscii` to
      Text.Pandoc.Shared.

  * Allow some command line options to take URL in addition to FILE.
    `--include-in-header`, `--include-before-body`, `--include-after-body`.

  * HTML reader:

    + Handle empty `start` attribute (see #5162).
    + Treat `textarea` as a verbatim environment (#5241) and preserve
      spacing.

  * RST reader:

    + Change treatment of `number-lines` directive (Brian Leung,
      #5207). Directives of this type without numeric inputs should
      not have a `startFrom` attribute; with a blank value, the
      writers can produce extra whitespace.
    + Removed superfluous `sourceCode` class on code blocks (#5047).
    + Handle `sourcecode` directive as synonym for `code` (#5204).

  * Markdown reader:

    + Remove `sourceCode` class for literate Haskell code blocks
      (#5047). Reverse order of `literate` and `haskell` classes on
      code blocks when parsing literate Haskell, so `haskell` is
      first.
    + Treat `<textarea>` as a verbatim environment (#5241).

  * Org reader:

    + Handle `minlevel` option differently (#5190, Brian Leung).
      When `minlevel` exceeds the original minimum level observed in
      the file to be included, every heading should be shifted
      rightward.
    + Allow for case of `:minlevel == 0` (#5190).
    + Fix treatment of links to images (#5191, Albert Krewinkel).
      Links with descriptions which are pointing to images are no
      longer parsed as inline images, but as links.
    + Add support for #+SELECT_TAGS (Brian Leung).
    + Separate filtering logic from conversion function (Brian Leung).

  * TWiki reader: Fix performance issue with underscores (#3921).

  * MediaWiki reader: use `_` instead of `-` in auto-identifiers (#4731).
    We may not still be exactly matching mediawiki's algorithm.

  * LaTeX reader:

    + Remove `sourceCode` class for literate Haskell code blocks
      (#5047). Reverse order of `literate` and `haskell` classes on
      code blocks when parsing literate Haskell, so `haskell` is
      first.
    + Support `\DeclareMathOperator` (#5149).
    + Support `\inputminted` (#5103).
    + Support `\endinput` (#5233).
    + Allow includes with dots like `cc_by_4.0`.  Previously the `.0`
      was interpreted as a file extension, leading pandoc not to add
      `.tex` (and thus not to find the file).  The new behavior matches
      tex more closely.

  * Man reader:

    + Use `mapLeft` from Shared instead of defining own.

  * Docx reader (Jesse Rosenthal):

    + Handle level overrides (#5134).

  * Docx writer:

    + Support custom properties (#3024, #5252, Agustín Martín Barbero).
      Also supports additional core properties:  `subject`, `lang`,
      `category`, `description`.
    + Make Level into a real type, instead of an alias for a tuple
      (Jesse Rosenthal).

  * ICML writer (Mauro Bieg):

    + Support custom-styles (#5137, see #2106).
    + Support unnumbered headers (#5140).

  * Texinfo writer: Use header identifier for anchor if present (#4731).
    Previously we were overwriting an existing identifier with a new one.

  * Org writer: Preserve line-numbering for example and code blocks
    (Brian Leung).

  * Man/Ms writers: Don't escape `-` as `\-`. The `\-` gets rendered
    in HTML and PDF as a unicode minus sign.

  * Ms writer: Ensure we have a newline after .EN in display math (#5251).

  * RST writer: Don't wrap simple table header lines (#5128).

  * Asciidoc writer: Shorter delimiters for tables, blockquotes
    (#4364). This matches asciidoctor reference docs.

  * Dokuwiki writer: Remove automatic `:` prefix before internal image
    links (#5183, Damien Clochard).  This prevented users from making
    relative image links.

 *  Zimwiki writer: remove automatic colon prefix before internal
    images (#5183, Damien Clochard).

  * MediaWiki writer: fix caption, use 'thumb' instead of 'frame'
    (#5105). Captions used to have the word 'caption' prepended; this
    has been removed. Also, 'thumb' is used instead of 'frame' to
    allow images to be resized.

  * reveal.js writer:

    + Ensure that we don't get > 2 levels of section nesting,
      even with slide level > 2 (#5168).
    + If slide level == N but there is no N-level header, make
      sure the next header with level > N gets treated as a slide
      and put in a section, rather than remaining loose (#5168).

  * Markdown writer:

    + Make `plain` RawBlocks pass through in `plain` output.
    + Include needed whitespace after HTML figure (#5121).
      We use HTML for a figure in markdown dialects that can't
      represent it natively.

  * Commonmark writer:

    + Fix handling of SoftBreak with `hard_line_breaks` (#5195).
    + Implement `--toc` (`writerTableOfContents`)
      in commonmark/gfm writers (#5172).

  * EPUB writer:

    + Ensure that picture transforms are done on metadata too.
    + Small fixes to `nav.xhtml`:
      Add 'landmarks' id attribute to the landmarks nav.
      Replace old default CSS removing numbers from ol.toc li
      with new rules that match `nav#toc ol, nav#landmarks ol`.
      We keep the `toc` class on `ol` for backwards compatibility.

  * LaTeX writer:

    + Make raw content marked `beamer` pass through in `beamer`
      output (pandoc/lua-filters#40).
    + Beamer: avoid duplicated `fragile` property in some cases
      (#5208).
    + Add `#` special characters for listings (#4939).
      This character needs special handling in `\lstinline`.

 *  RTF writer: use `toTableOfContents` from Shared to replace
    old duplicated code.

  * Pptx writer:

    + Support custom properties.  Also supports additional core
      properties: `subject`, `category`, `description` (#5252,
      Agustín Martín Barbero).
    + Use `toTableOfContents` from Shared to replace old duplicated code.

  * ODT writer (Augustín Martín Barbero):

    + Fix typo in custom properties (#2839).
    + Improve standard properties, including the following core
      properties: `generator` (Pandoc/VERSION), `description`, `subject`,
      `keywords`, `initial-creator` (from authors), `creation-date`
      (actual creation date) (#5252).

  * Custom writers:

    + Allow '-' in filenames for custom lua writers (#5187).
    + sample.lua: add `SingleQuoted`, `DoubleQuoted` (#5104).
    + sample.lua: Add a missing `>` (MichaWiedenmann).

  * reveal.js template:  Add `zoomKey` config (#4249).

  * HTML5 template: Remove unnecessary type="text/css" on style and
    link for HTML5 (#5146).

  * LaTeX template (Andrew Dunning, except where noted):

    + Prevent fontspec from scaling `mainfont` to match the default
      font, Latin Modern. A main font set to 12pt could
      previously appear between 11pt to 13pt depending on its design.
      To return to the earlier rendering, use `-V
      mainfontoptions="Scale=MatchLowercase"` (#5212, #5218).
    + Display monospaced fonts without TeX ligatures when using
      `--pdf-engine=lualatex`. It now matches the behaviour of other
      engines (#5212, #5218).
    + Remove the deprecated `romanfont` variable. The functionality of
      `mainfont` is identical (#5218).
    + Render `\subtitle` with the standard document classes.
      Previously, `subtitle` only appeared when using the KOMA-Script
      classes or Beamer (#5213, #5244).
    + Use Babel instead of Polyglossia for LuaLaTeX. This avoids
      several language selection problems, notably with retaining
      French spacing conventions when switching to a verbatim
      environment or another language; and in printing Greek text
      without hyphenation (#5193).
    + Use the [`xurl`](https://ctan.org/pkg/xurl) package if
      available, improving the appearance of URLs by allowing them to
      break at additional points (#5193).
    + Use [`bookmark`](https://ctan.org/pkg/bookmark) if available
      to correct heading levels in PDF bookmarks: see the [KOMA-Script
      3.26 release notes](https://komascript.de/release3.26) (#5193).
    + Require the [`xcolor`](https://ctan.org/pkg/xcolor) package to
      avoid a possible error when using additional packages alongside
      footnotes in tables (#5193, closes #4861).
    + Remove obsolete `fixltx2e` package, which has no functionality
      with TeX Live 2015 or later (#5193).
    + Allow multiple `fontfamilies.options` (#5193, closes #5194).
    + Restrict `institute` variable to Beamer (#5219).
    + Use [`footnotehyper`](https://ctan.org/pkg/footnotehyper)
      package if available to make footnotes in tables compatible
      with `hyperref` (#5234).
    + Number parts and chapters in book classes only if the
      `numbersections` variable is set, for consistency with other
      output formats. To return to the previous behaviour, use
      `-V numbersections -V secnumdepth=0` (#5235).
    + Reindent file (#5193).
    + Use built-in parskip handling with KOMA-Script classes (#5143, Enno).
    + Set default listings language for lua, assembler (#5227, John
      MacFarlane).  Otherwise we get an error when trying to compile code
      with lua or assembler code.  To change the default dialect
      (currently 5.3 for lua and x86masm for assembler), you can use
      `--include-in-header` to inject something like
      `\lstset{defaultdialect=[5.2]Lua}`.

  * Text.Pandoc.Readers: Changed types of `readJSON`; it now runs
    in an instance of PandocMonad, like the other readers and
    writers.  [API change]

  * Text.Pandoc.Writers: Changed types of `writeJSON`; it now runs
    in an instance of PandocMonad, like the other readers and
    writers.  [API change]

  * Text.Pandoc.Error: Added `PandocUTF8DecodingError` constructor
    for `PandocError`. [API change]

  * Text.Pandoc.Writers.Shared - add `toTableOfContents`. [API change]
    This is refactored out from the Markdown writer.
    It can be used in other writers to create a table of contents.

  * Improve error messages for UTF-8 decoding errors. Now we give
    the filename and byte offset (#4765).

  * Text.Pandoc.XML: Strip out illegal XML characters in
    `escapeXMLString` (#5119).

  * Text.Pandoc.Process: update `pipeProcess` (Albert Krewinkel).
    The implementation of `pipeProcess` was rewritten to fix sporadic
    failures caused by prematurely closed pipes.

  * Use `safeRead` instead of `read` everywhere in the code
    (John MacFarlane, Mauro Bieg, #5162, #5180).

  * Text.Pandoc.SelfContained: Decompress `.svgz` when
    converting to `data:` URI (#5163, Alexander Krotov).

  * Text.Pandoc.Parsing: Remove unused `HasHeaderMap`
    (#5175, Alexander Krotov). [API change]

  * Normalize Windows paths to account for change in ghc 8.6 (#5127).
    When pandoc is compiled with ghc 8.6, Windows paths are treated
    differently, and paths beginning `\\server` no longer work.
    This commit rewrites such patsh to `\\?\UNC\server` which works.
    The change operates at the level of argument parsing, so it
    only affects the command line program.

  * Simplify/fix reading of `--metadata` values on command line
    to avoid problems relating to hvr/HsYAML#7 (#5177).

  * data/pandoc.lua: auto-fix nested constructor arguments (Albert
    Krewinkel).  Incorrect types to pandoc element constructors are
    automatically converted to the correct types when possible. This was
    already done for most constructors, but conversions are now also done
    for nested types (like lists of lists).

  * Removed custom Setup.hs, use build-type: simple. The only thing we
    gained from the custom build was automatic installation of the man
    page when using 'cabal install'. But custom builds cause problems,
    e.g., with cross-compilation. Installation of the man page is
    better handled by packagers. Note to packagers (e.g. Debian): it
    may be necessary to add a step installing the man page with the
    next release.

  * Allow latest http-client, tasty, zip-archive, Glob.

  * Require skylighting >= 0.7.5, adding support for sml, J,
    typescript.

   * Tests:  Cleaned up `findPandoc` in `Tests.Helpers`, so it
     works well with cabal v2.

  * INSTALL.md:

    + Use button for installer links (John MacFarlane, Mauro Bieg,
      #5167).
    + Fix links and bump required stack version (max).
    + Improve installation notes on associated software (Andrew
      Dunning). Includes explanation of how to install related tools
      with package managers (since the method of installing
      `rsvg-convert` is not obvious).

  * doc/org.md: improve documentation of org features (Albert
    Krewinkel).

  * doc/lua-filters.md:  use 3rd level headers for module fields.

  * MANUAL:

    + Clarify automatic identifiers (#5201). We remove
      non-alphanumerics. This includes, e.g., emojis.
    + Fix example for Div with id (Geoffrey Ely).
    + Update list of LaTeX packages used.
    + Make it clear that `hard_line_breaks` works in `gfm` (see #5195).
    + Mention `raw_attribute` in documentation for `raw_html` and
      `raw_tex` (#5240, thanks to @eiro).
    + Clarify that `$sep$` must come right before `$endfor$` in templates
      (#5243, Lev Givon).
    + Document metadata support for docx, odt, pptx writers (Agustín
      Martín Barbero).
    + Reorganize template variables (#5249, Andrew Dunning).
      Add additional headings to categorize variables, and
      alphabetize when there is large number; add more examples.
    + Document `date-meta` template variable (#5260, Tristan Stenner).

  * trypandoc: Fix CSS and viewport.

## pandoc 2.5 (2018-11-27)

  * Text.Pandoc.App: split into several unexported submodules (Albert
    Krewinkel):  Text.Pandoc.App.FormatHeuristics,
    Text.Pandoc.App.Opt, Text.Pandoc.App.CommandLineOptions,
    Text.Pandoc.App.OutputSettings.  This is motivated partly by the
    desire to reduce recompilations when something is modified,
    since App previously depended on virtually every other module.

  * Text.Pandoc.Extensions

    + Semantically, `gfm_auto_identifiers` is now a modifier of
      `auto_identifiers`; for identifiers to be set, `auto_identifiers` must
      be turned on, and then the type of identifier produced depends on
      `gfm_auto_identifiers` and `ascii_identifiers` are set. Accordingly,
      `auto_identifiers` is now added to `githubMarkdownExtensions` (#5057).
    + Remove `ascii_identifiers` from `githubMarkdownExtensions`.
      GitHub doesn't seem to strip non-ascii characters any more.

  * Text.Pandoc.Lua.Module.Utils (Albert Krewinkel)

    + Test AST object equality via Haskell (#5092).  Equality of Lua
      objects representing pandoc AST elements is tested by unmarshalling
      the objects and comparing the result in Haskell.
      A new function `equals` which performs this test has been added to the
      `pandoc.utils` module.
    + Improve stringify.  Meta value strings (MetaString)
      and booleans (MetaBool) are now converted to the literal string and the
      lowercase boolean name, respectively. Previously, all values of these
      types were converted to the empty string.

  * Text.Pandoc.Parsing: Remove Functor and Applicative constraints where Monad
    already exists (Alexander Krotov).

  * Text.Pandoc.Pretty: Don't render BreakingSpace at end of line
    or beginning of line (#5050).

  * Text.Pandoc.Readers.Markdown

    + Fix parsing of citations, quotes, and underline emphasis
      after symbols.  Starting with pandoc 2.4, citations, quoted inlines,
      and underline emphasis were no longer recognized after certain
      symbols, like parentheses (#5099, #5053).
    + In pandoc 2.4, a soft break after an abbreviation would be
      relocated before it to allow for insertion of a nonbreaking
      space after the abbreviation. This behavior is here reverted.
      A soft break after an abbreviation will remain, and no nonbreaking
      space will be added. Those who care about this issue should take care not
      to end lines with an abbreviation, or to insert nonbreaking spaces
      manually.

  * Text.Pandoc.Readers.FB2: Do not throw error for unknown elements in
    `<body>` (Alexander Krotov).  Some libraries include custom elements
    in their FB2 files.

  * Text.Pandoc.Readers.HTML

    + Allow `tfoot` before body rows (#5079).
    + Parse `<small>` as a Span with class "small" (#5080).
    + Allow thead containing a row with `td` rather than `th` (#5014).

  * Text.Pandoc.Readers.LaTeX

    + Cleaned up handling of dimension arguments.  Allow decimal points,
      preceding space.
    + Don't allow arguments for verbatim, etc.
    + Allow space before bracketed options.
    + Allow optional arguments after `\\` in tables.
    + Improve parsing of `\tiny`, `\scriptsize`, etc.  Parse as raw,
      but know that these font changing commands take no arguments.

  * Text.Pandoc.Readers.Muse

    + Trim whitespace before parsing grid table cells (Alexander Krotov).
    + Add grid tables support (Alexander Krotov).

  * Text.Pandoc.Shared

    + For bibliography match Div with id `refs`, not class `references`.
      This was a mismatch between pandoc's docx, epub, latex, and markdown
      writers and the behavior of pandoc-citeproc, which actually looks for a
      div with id `refs` rather than one with class `references`.
    + Exactly match GitHub's identifier generating algorithm (#5057).
    + Add parameter for `Extensions` to `uniqueIdent` and
      `inlineListToIdentifier` (#5057).  [API change]
      This allows these functions to be sensitive to the settings of
      `Ext_gfm_auto_identifiers` and `Ext_ascii_identifiers`, and allows us to
      use `uniqueIdent` in the CommonMark reader, replacing custom code.  It
      also means that `gfm_auto_identifiers` can now be used in all formats.

  * Text.Pandoc.Writers.AsciiDoc

    + Use `.`+ as list markers to support nested ordered lists (#5087).
    + Support list number styles (#5089).
    + Render Spans using `[#id .class]#contents#` (#5080).

  * Text.Pandoc.Writers.CommonMark

    + Respect `--ascii` (#5043, quasicomputational).
    + Make sure `--ascii` affects quotes, super/subscript.

  * Text.Pandoc.Writers.Docx

    + Fix bookmarks to headers with long titles (#5091).
      Word has a 40 character limit for bookmark names.  In addition, bookmarks
      must begin with a letter.  Since pandoc's auto-generated identifiers may
      not respect these constraints, some internal links did not work.  With
      this change, pandoc uses a bookmark name based on the SHA1 hash of the
      identifier when the identifier isn't a legal bookmark name.
    + Add bookmarks to code blocks (Nikolay Yakimov).
    + Add bookmarks to images (Nikolay Yakimov).
    + Refactor common bookmark creation code into a function (Nikolay Yakimov).

  * Text.Pandoc.Writers.EPUB: Handle calibre metadata (#5098).
    Nodes of the form

          <meta name="calibre:series" content="Classics on War and Politics"/>

      are now included from an epub XML metadata file.  You can also include
      this information in your YAML metadata, like so:

          calibre:
           series: Classics on War and Policitics

      In addition, ibooks-specific metadata can now be included via an XML
      file. (Previously, it could only be included via YAML metadata, see
      #2693.)

  * Text.Pandoc.Writers.HTML: Use plain `"` instead of `&quot;` outside of
    attributes.

  * Text.Pandoc.Writers.ICML: Consolidate adjacent strings, inc. spaces.
    This avoids splitting up the output unnecessarily into separate elements.

  * Text.Pandoc.Writers.LaTeX: Don't emit `[<+->]` unless beamer output, even
    if `writerIncremental` is True (#5072).

  * Text.Pandoc.Writers.Muse (Alexander Krotov).

    + Output tables as grid tables if they have multi-line cells.
    + Indent simple tables only on the top level.
    + Output tables with one column as grid tables.
    + Add support for `--reference-location`.
    + Internal improvements.

  * Text.Pandoc.Writers.OpenDocument: Fix list indentation (Nils Carlson,
    #5095).  This was a regression in pandoc 2.4.

  * Text.Pandoc.Writers.RTF: Fix warnings for skipped raw inlines.

  * Text.Pandoc.Writers.Texinfo: Add blank line before `@menu` section (#5055).

  * Text.Pandoc.XML: in `toHtml5Entities`, prefer shorter entities
    when there are several choices for a particular character.

  * data/abbreviations

    + Add additional abbreviations (Andrew Dunning)
      Many of these borrowed from the Chicago Manual of Style 10.42,
      'Scholarly abbreviations'.

  * Templates

    + Asciidoc template:  add :lang: to title header is lang is set in
      metadata (#5088).

  * pandoc.cabal: Add cabal flag `derive_json_via_th` (Albert Krewinkel)
    Disabling the flag will cause derivation of ToJSON and FromJSON
    instances via GHC Generics instead of Template Haskell. The flag is
    enabled by default, as deriving via Generics can be slow (see #4083).

  * trypandoc:

    + Tweaked drop-down lists.
    + Put link to site in footer.
    + Preselect output format.
    + Update on change of in or out format.
    + Add man input format.

  * MANUAL.txt:

    + Fix outdated description of latex_macros extension.
    + Clarified placement of bibliography.
    + Added "A note on security."
    + Fix note on curly brace syntx for locators.
    + Document new explicit syntax for citeproc locators.
    + Remove confusing cross-links for some extensions.
    + Don't put pandoc in code ticks in heading.
    + Document that `--ascii` works for gfm and commonmark too.
    + Add `man` to `--from` options.

  * doc/customizing-pandoc.md: various improvements (Mauro Bieg).


## pandoc 2.4 (2018-11-03)

### New features

  * New input format `man` (Yan Pashkovsky, John MacFarlane).

### Behavior changes

  * `--ascii` is now implemented in the writers, not in Text.Pandoc.App,
    via the new `writerPreferAscii` field in `WriterOptions`.
    Now the `write*` functions for Docbook, HTML, ICML, JATS, LaTeX,
    Ms, Markdown, and OPML are sensitive to `writerPreferAscii`.
    Previously the to-ascii translation was done in Text.Pandoc.App,
    and thus not available to those using the writer functions
    directly.

  * `--ascii` now works with Markdown output.  HTML5 character reference
    entities are used.

  * `--ascii` now works with LaTeX output. 100% ASCII output can't be
    guaranteed, but the writer will use commands like `\"{a}` and `\l`
    whenever possible, to avoid emitting a non-ASCII character.

  * For HTML5 output, `--ascii` now uses HTML5 character reference
    entities rather than numerical entities.

  * Improved detection of format based on extension (in Text.Pandoc.App).
    We now ensure that if someone tries to convert a file for a
    format that has a pandoc writer but not a reader, it won't just
    default to markdown.

  * Add viz. to abbreviations file (#5007, Nick Fleisher).

  * AsciiDoc writer:  always use single-line section headers,
    instead of the old underline style (#5038).  Previously the single-line
    style would be used if `--atx-headers` was specified, but
    now it is always used.

  * RST writer: Use simple tables when possible (#4750).

  * CommonMark (and gfm) writer: Add plain text fallbacks. (#4528,
    quasicomputational). Previously, the writer would unconditionally
    emit HTML output for subscripts, superscripts, strikeouts (if the
    strikeout extension is disabled) and small caps, even with
    `raw_html` disabled. Now there are plain-text (and, where
    possible, fancy Unicode) fallbacks for all of these corresponding
    (mostly) to the Markdown fallbacks, and the HTML output is only
    used when `raw_html` is enabled.

  * Powerpoint writer: support raw openxml (Jesse Rosenthal, #4976).
    This allows raw openxml blocks and inlines to be used in the pptx
    writer. Caveats: (1) It's up to the user to write
    well-formed openxml. The chances for corruption, especially with
    such a brittle format as pptx, is high. (2) Because of
    the tricky way that blocks map onto shapes, if you are using
    a raw block, it should be the only block on a slide
    (otherwise other text might end up overlapping it). (3) The
    pptx ooxml namespace abbreviations are different from the
    docx ooxml namespaces. Again, it's up to the user to get it
    right. Unzipped document and ooxml specification should be
    consulted.

  * With `--katex` in HTML formats, do not use the autorenderer (#4946).
    We no longer surround formulas with `\(..\)` or `\[..\]`. Instead,
    we tell katex to convert the contents of span elements with
    class "math". Since math has already been identified, this
    avoids wasted time parsing for LaTeX delimiters. Note, however,
    that this may yield unexpected results if you have span elements
    with class "math" that don't contain LaTeX math.
    Also, use latest version of KaTeX by default (0.9.0).

  * The man writer now produces ASCII-only output, using groff escapes,
    for portability.

  * ODT writer:

    + Add title, author and date to metadata; any remaining
      metadata fields are added as `meta:user-defined` tags.
    + Implement table caption numbering (#4949, Nils Carlson).
      Captioned tables are numbered and labeled with format "Table 1:
      caption", where "Table" is replaced by a translation, depending
      on the value of `lang` in metadata. Uncaptioned tables are not
      enumerated.
    + OpenDocument writer: Implement figure numbering in captions (#4944,
      Nils Carlson). Figure captions are now numbered 1, 2, 3, ...
      The format in the caption is "Figure 1: caption" and so on
      (where "Figure" is replaced by a translation, depending on the
      value of `lang` in the metadata). Captioned figures are numbered
      consecutively and uncaptioned figures are not enumerated. This
      is necessary in order for LibreOffice to generate an
      Illustration Index (Table of Figures) for included figures.

  * RST reader: Pass through fields in unknown directives as div attributes
    (#4715). Support `class` and `name` attributes for all directives.

  * Org reader: Add partial support for `#+EXCLUDE_TAGS` option. (#4284,
    Brian Leung). Headers with the corresponding tags should not
    appear in the output.

  * Log warnings about missing title attributes now include a
    suggestion about how to fix the problem (#4909).

  * Lua filter changes (Albert Krewinkel):

    + Report traceback when an error occurs. A proper Lua traceback is
      added if either loading of a file or execution of a filter
      function fails. This should be of help to authors of Lua filters
      who need to debug their code.

    + Allow access to pandoc state (#5015). Lua filters and custom
      writers now have read-only access to most fields of pandoc's
      internal state via the global variable `PANDOC_STATE`.

    + Push ListAttributes via constructor (Albert Krewinkel).
      This ensures that ListAttributes, as present in OrderedList elements,
      have additional accessors (viz. `start`, `style`, and `delimiter`).

    + Rename ReaderOptions fields, use snake_case. Snake case is used
      in most variable names, using camelCase for these fields was an
      oversight. A metatable is added to ensure that the old field
      names remain functional.

    + Iterate over AST element fields when using `pairs`. This makes
      it possible to iterate over all ield names of an AST element by
      using a generic `for` loop with pairs`:

          for field_name, field_content in pairs(element) do
          ...
          end

      Raw table fields of AST elements should be considered an
      implementation detail and might change in the future. Accessing
      element properties should always happen through the fields
      listed in the Lua filter docs.

      Note that the iterator currently excludes the `t`/`tag` field.

    + Ensure that MetaList elements behave like Lists. Methods usable
      on Lists can also be used on MetaList objects.

    + Fix MetaList constructor (Albert Krewinkel). Passing a MetaList
      object to the constructor `pandoc.MetaList` now returns the
      passed list as a MetaList. This is consistent with the
      constructor behavior when passed an (untagged) list.

  * Custom writers: Custom writers have access to the global variable
    `PANDOC_DOCUMENT`(Albert Krewinkel, #4957). The variable contains
    a userdata wrapper around the full pandoc AST and exposes two
    fields, `meta` and `blocks`. The field content is only
    marshaled on-demand, performance of scripts not accessing the
    fields remains unaffected.

### API changes

  * Text.Pandoc.Options: add `writerPreferAscii` to `WriterOptions`.

  * Text.Pandoc.Shared:

    + Export `splitSentences`. This was previously duplicated in the Man and
      Ms writers.
    + Add `ToString` typeclass (Alexander Krotov).

  * New exported module Text.Pandoc.Filter (Albert Krewinkel).

  * Text.Pandoc.Parsing

    + Generalize `gridTableWith` to any `Char` Stream (Alexander Krotov).
    + Generalize `readWithM` from `[Char]` to any `Char` Stream
      that is a `ToString` instance (Alexander Krotov).

  * New exposed module Text.Pandoc.Filter (Albert Krewinkel).

  * Text.Pandoc.XML: add `toHtml5Entities`.

  * New exported module Text.Pandoc.Readers.Man (Yan Pashkovsky, John
    MacFarlane).

  * Text.Pandoc.Writers.Shared

    + Add exported functions `toSuperscript` and
      `toSubscript` (quasicomputational, #4528).
    + Remove exported functions `metaValueToInlines`,
      `metaValueToString`. Add new exported functions
      `lookupMetaBool`, `lookupMetaBlocks`, `lookupMetaInlines`,
      `lookupMetaString`. Use these whenever possible for uniformity
      in writers (Mauro Bieg, #4907). (Note that
      removed function `metaValueToInlines` was in previous
      released versions.)
    + Add `metaValueToString`.

  * Text.Pandoc.Lua

    + Expose more useful internals (Albert Krewinkel):

      - `runFilterFile` to run a Lua filter from file;
      - data type `Global` and its constructors; and
      - `setGlobals` to add globals to a Lua environment.

      This module also contains `Pushable` and `Peekable` instances
      required to get pandoc's data types to and from Lua. Low-level
      Lua operation remain hidden in Text.Pandoc.Lua.

    + Rename `runPandocLua` to `runLua` (Albert Krewinkel).

    + Remove `runLuaFilter`, merging this into Text.Pandoc.Filter.Lua's
      `apply` (Albert Krewinkel).

### Bug fixes and under-the-hood improvements

  * Text.Pandoc.Parsing

    + Make `uri` accept any stream with Char tokens (Alexander Krotov).
    + Rewrite `uri` without `withRaw` (Alexander Krotov).
    + Generalize `parseFromString` and `parseFromString'` to any
      streams with Char token (Alexander Krotov)
    + Rewrite `nonspaceChar` using `noneOf` (Alexander Krotov)

  * Text.Pandoc.Shared: Reimplement `mapLeft` using `Bifunctor.first`
    (Alexander Krotov).

  * Text.Pandoc.Pretty: Simplify `Text.Pandoc.Pretty.offset`
    (Alexander Krotov).

  * Text.Pandoc.App

    + Work around HXT limitation for --syntax-definition with windows
      drive (#4836).
    + Always preserve tabs for man format. We need it for tables.
    + Split command line parsing code into a separate unexported
      module, Text.Pandoc.App.CommandLineOptions (Albert Krewinkel).

  * Text.Pandoc.Readers.Roff: new unexported module for tokenizing
    roff documents.

  * New unexported module Text.Pandoc.RoffChar, provided character
    escape tables for roff formats.

  * Text.Pandoc.Readers.HTML: Fix `htmlTag` and `isInlineTag` to
    accept processing instructions (#3123, regression since 2.0).

  * Text.Pandoc.Readers.JATS: Use `foldl'` instead of `maximum` to
    account for empty lists (Alexander Krotov).

  * Text.Pandoc.Readers.RST: Don't allow single-dash separator in
    headerless table (#4382).

  * Text.Pandoc.Readers.Org: Parse empty argument array in inline src
    blocks (Brian Leung).

  * Text.Pandoc.Readers.Vimwiki:

    + Get rid of `F`, `runF` and `stateMeta'` in favor of `stateMeta`
      (Alexander Krotov).
    + Parse `Text` without converting to `[Char]` (Alexander Krotov).

  * Text.Pandoc.Readers.Creole: Parse `Text` without converting to
    `[Char]` (Alexander Krotov).

  * Text.Pandoc.Readers.LaTeX

    + Allow space at end of math after `\` (#5010).
    + Add support for `nolinkurl` command (#4992, Brian Leung).
    + Simplified type on `doMacros'`.
    + Tokenize before pulling tokens, rather than after (#4408). This
      has some performance penalty but is more reliable.
    + Make macroDef polymorphic and allow in inline context.
      Otherwise we can't parse something like `\lowercase{\def\x{Foo}}`.
     I have actually seen tex like this in the wild.
    + Improved parsing of `\def`, `\let`. We now correctly parse:
      ```
      \def\bar{hello}
      \let\fooi\bar
      \def\fooii{\bar}
      \fooi +\fooii

      \def\bar{goodbye}
      \fooi +\fooii
      ```
    + Improve parsing of `\def` argspec.
    + Skip `\PackageError` commands (see #4408).
    + Fix bugs omitting raw tex (#4527). The default is `-raw_tex`,
      so no raw tex should result unless we explicitly say `+raw_tex`.
      Previously some raw commands did make it through.
    + Moved `isArgTok` to Text.Pandoc.Readers.LaTeX.Parsing.
    + Moved `babelLangToBCP`, `polyglossiaLangToBCP` to new module,
      Text.Pandoc.Readers.LaTeX.Lang (unexported).
    + Simplified accent code using unicode-transforms.
      New dependency on unicode-transforms package for normalization.
    + Allow verbatim blocks ending with blank lines (#4624).
    + Support `breq` math environments: `dmath`, `dgroup`, `darray`.
      This collects some of the general-purpose code from the LaTeX reader,
      with the aim of making the module smaller.

  * Text.Pandoc.Readers.Markdown

    + Fix awkward soft break movements before abbreviations (#4635).
    + Add updateStrPos in a couple places where needed.

  * Text.Pandoc.Readers.Docx: Trigger bold/italic with bCs, iCs
    (#4947). These are variants for "complex scripts" like Arabic
    and are now treated just like b, i (bold, italic).

  * Text.Pandoc.Readers.Muse (Alexander Krotov)

    + Try to parse lists before trying to parse table.
      This ensures that tables inside lists are parsed correctly.
    + Forbid whitespace after opening and before closing markup
      elements.
    + Parse page breaks.
    + Simplify `museToPandocTable` to get rid of partial functions.
    + Allow footnotes to start with empty line.
    + Make sure that the whole text is parsed.
    + Allow empty headers. Previously empty headers caused parser to
      terminate without parsing the rest of the document.
    + Allow examples to be indented with tabs.
    + Remove indentation from examples indicated by `{{{` and `}}}`.
    + Fix parsing of empty cells.
    + Various changes to internals.
    + Rewrite some parsers in applicative style.
    + Avoid tagsoup dependency.
    + Allow table caption to contain `+`.

  * Text.Pandoc.Writers.LaTeX

    + Add newline if math ends in a comment (#4880). This prevents the
      closing delimiter from being swalled up in the comment.
    + With `--listings`, don't pass through org-babel attributes (#4889).
    + With `--biblatex`, use `\autocite` when possible (#4960).
      `\autocites{a1}{a2}{a3}` will not collapse the entries. So, if
      we don't have prefixes and suffixes, we use instead
      `\autocite{a1,a2,a3}`.
    + Fix description lists contining highlighted code (#4662).

  * Text.Pandoc.Writers.Man

    + Don't wrap `.SH` and `.SS` lines (#5019).
    + Avoid unnecessary `.RS`/`.RE` pair in definition lists with
      one paragraph definitions.
    + Moved common groff functions to Text.Pandoc.Writers.Groff.
    * Fix strong/code combination on man (should be `\f[CB]` not
      `\f[BC]`, see #4973).
    + Man writer: use `\f[R]` instead of `\f[]` to reset font
      (Alexander Krotov, #4973).
    + Move `splitSentences` to Text.Pandoc.Shared.

  * Text.Pandoc.Writers.Docx

    + Add framework for custom properties (#3034). So far, we don't
      actually write any custom properties, but we have the
      infrastructure to add this.

    + Handle tables in table cells (#4953). Although this is not
      documented in the spec, some versions of Word require a `w:p`
      element inside every table cell. Thus, we add one when the
      contents of a cell do not already include one (e.g. when a table
      cell contains a table).

  * Text.Pandoc.Writers.AsciiDoc:  Prevent illegal nestings.
    Adjust header levels so that n+1 level headers are only
    found under n level headers, and the top level is 1.

  * Text.Pandoc.Writers.OpenDocument: Improve bullet/numbering
    alignment (#4385). This change eliminates the large gap we used
    to have between bullet and text, and also ensures that numbers
    in numbered lists will be right-aligned.

  * Text.Pandoc.Writers.ZimWiki

    + Number ordered list items sequentially, rather than always
      with 1 (#4962).
    + Remove extra indentation on lists (#4963).

  * Text.Pandoc.Writers.EPUB: Use metadata field `css` instead of
    `stylesheet` (Mauro Bieg, #4990).

  * Text.Pandoc.Writers.Markdown: Ensure blank between raw block and
    normal content (#4629). Otherwise a raw block can prevent a
    paragraph from being recognized as such.

  * Text.Pandoc.Writers.Ms

    + Removed old `escapeBar`. We don't need this now that we use
      `@` for math delim.
    + Moved common code to Text.Pandoc.Writers.Roff and to
      Text.Pandoc.RoffChar.
    + Move `splitSentences` to Text.Pandoc.Shared (to avoid duplication
      with the man writer).

   * Text.Pandoc.Writers.Muse (Alexander Krotov).

    + Add support for grid tables.
    + Fix Muse writer style.
    + Use `length` instead of `realLength` to calculate definition
      indentation. Muse parsers don't take character width into
      account when calculating indentation.
    + Do not insert newline before lists.
    + Use lightweight markup after `</em>` tag.

  * New unexported module Text.Pandoc.Writers.Roff, providing functions
    useful for all roff format writers (man, ms).

  * Text.Pandoc.Lua

    + Move globals handling to separate module Text.Pandoc.Lua.Global
      (Albert Krewinkel).

    + Lua filter internals: push Shared.Element as userdata (Albert
      Krewinkel). Hierarchical Elements were pushed to Lua as plain
      tables. This is simple, but has the disadvantage that marshaling
      is eager: all child elements will be marshaled as part of the
      object. Using a Lua userdata object instead allows lazy access
      to fields, causing content marshaling just (but also each time)
      when a field is accessed. Filters which do not traverse the full
      element contents tree become faster as a result.

### Default template changes

  * LaTeX template:

    + Add variable `hyperrefoptions` (#4925, Mathias Walter).
    + Add variable `romanfont`, `romanfontoptions` (#4665, OvidiusCicero).

  * AsciiDoc template: use single-line style for title.

  * revealjs template: Fix typo in the socket.io javascript plugin (#5006,
    Yoan Blanc).

  * Text.Pandoc.Lua.Util: add missing docstring to `defineHowTo`
    (Albert Krewinkel).

  * data/pandoc.lua: add datatype ListAttributes (Albert Krewinkel)

  * data/sample.lua: replace custom pipe function with pandoc.utils.pipe
    (Albert Krewinkel).

### Documentation improvements

  * INSTALL.md

    + Add chromeos install instructions (#4958) (Evan Pratten).
    + Add note about TinyTeX.

  * MANUAL.txt

    + Change `groff` -> `roff`.
    + Implement `--ascii` for Markdown writer.
    + Clarify LaTeX image dimensions output (Mauro Bieg).

  * doc/customizing-pandoc.md: added skeleton (Mauro Bieg, #3288).

  * doc/getting-started.md: Added title to test1.md to avoid warning.

  * doc/lua-filters.md: merge type references into main document,
    fix description of Code.text (Albert Krewinkel).

### Build infrastructure improvements

  * Makefile

    + Makefile: added quick-cabal, full-cabal targets.
    + Make .msi download targets insensitive to order of appveyor builds.

  * Update benchmarks for ghc 8.6.1.

   * pandoc.cabal:

    + Enable more compiler warnings (Albert Krewinkel).
    + Make base lower bound 4.8.
    + Bump upper bound for QuickCheck.
    + Bump upper bound for binary.
    + Updated version bounds for containers and haddock-library (#4974).
    + Added docx/docPropos/custom.xml to cabal data-files.
    + Require skylighting 0.7.4 (#4920).
    + New dependency on unicode-transforms package for normalization.

  * Improved .travis.yml testing and test with GHC 8.6.1 (Albert Krewinkel).

  * Added `tools/changelog-helper.sh`.

  * Added test/grofftest.sh for testing the man reader on real man pages.

## pandoc 2.3.1 (2018-09-28)

  * RST reader:

    + Parse RST inlines containing newlines (#4912, Francesco Occhipinti).
      This eliminates a regression introduced after pandoc 2.1.1, which
      caused inline constructions containing newlines not to be recognized.
    + Fix bug with internal link targets (#4919).  They were gobbling up
      indented content underneath.

  * Markdown reader: distinguish autolinks in the AST.  With this change,
    autolinks are parsed as Links with the `uri` class. (The same is true
    for bare links, if the `autolink_bare_uris` extension is enabled.)
    Email autolinks are parsed as Links with the `email` class.  This
    allows the distinction to be represented in the AST.

  * Org reader:

    + Force inline code blocks to honor export options (Brian Leung).
    + Parse empty argument array in inline src blocks (Brian Leung).

  * Muse reader (Alexander Krotov):

    + Added additional tests.
    + Do not allow code markup to be followed by digit.
    + Remove heading level limit.
    + Simplify `<literal>` tag parsers
    + Parse Text instead of String. Benchmark shows 7% improvement.
    + Get rid of HTML parser dependency.
    + Various code improvements.

  * ConTeXt writer: change `\` to `/` in Windows image paths (#4918).
    We do this in the LaTeX writer, and it avoids problems.
    Note that `/` works as a LaTeX path separator on Windows.

  * LaTeX writer:

    + Add support for multiprenote and multipostnote arguments
      with `--biblatex` (Brian Leung, #4930).  The multiprenotes occur before
      the first prefix of a multicite, and the multipostnotes follow the
      last suffix.
    + Fix a use of `last` that might take empty list.  If you ran with
      `--biblatex` and have an empty document (metadata but no blocks),
      pandoc would previously raise an error because of the use of
      `last` on an empty list.

  * RTF writer: Fix build failure with ghc-8.6.1 caused by missing
    MonadFail instance (Jonas Scholl).

  * ODT Writer: Improve table header row style handling (Nils Carlson).
    This changes the way styles for cells in the header row
    and normal rows are handled in ODT tables.
    Previously a new (but identical) style was generated for
    every table, specifying the style of the cells within the table.
    After this change there are two style definitions for table cells,
    one for the cells in the header row, one for all other cells.
    This doesn't change the actual styles, but makes post-processing
    changes to the table styles much simpler as it is no longer
    necessary to introduce new styles for header rows and there are
    now only two styles where there was previously one per table.

  * HTML writer:

    + Don't add `uri` class to presumed autolinks.  Formerly the `uri`
      class was added to autolinks by the HTML writer, but it had to
      guess what was an autolink and could not distinguish
      `[http://example.com](http://example.com)` from
      `<http://example.com>`.  It also incorrectly recognized
      `[pandoc](pandoc)` as an autolink.  Now the HTML writer
      simply passes through the `uri` attribute if it is present,
      but does not add anything.
    + Avoid adding extra section nestings for revealjs.
      Previously revealjs title slides at level (slidelevel - 1)
      were nested under an extra section element, even when
      the section contained no additional (vertical) content.
      That caused problems for some transition effects.
    + Omit unknown attributes in EPUB2 output.  For example,
      `epub:type` attributes should not be passed through,
      or the epub produced will not validate.

  * JATS writer: remove 'role' attribute on 'bold' and 'sc' elements (#4937).
    The JATS spec does not allow these.

  * Textile writer: don't represent `uri` class explicitly
    for autolinks (#4913).

  * Lua filters (Albert Krewinkel):

    + Cleanup filter execution code.
    + Better error on test failure.

  * HTML, Muse reader tests: reduce time taken by round-trip test.

  * Added cabal.project.

  * MANUAL: `epub:type` is only useful for epub3 (Maura Bieg).

  * Use hslua v1.0.0 (Albert Krewinkel).

  * Fix `translations/ru` to use modern Russian orthography
    (Ivan Trubach).

  * Build Windows binary using ghc 8.6.1 and cabal new-build. This
    fixes issues with segfaults in the 32-bit Windows binaries (#4283).

## pandoc 2.3 (2018-09-16)

  * Add `--metadata-file` option (Mauro Bieg, #1960), which allows
    users to specify metadata in a YAML file, regardless of the
    input format (#1960).

  * Text.Pandoc.Writers.Shared: export `isDisplayMath` (API change).

  * Text.Pandoc.Readers.Markdown: export `yamlToMeta` (API change,
    Mauro Bieg).

  * Text.Pandoc.Readers.LaTeX.Types:

    + New type `ArgSpec` (API change).
    + Second parameter of `Macro` constructor is now `[ArgSpec]` instead of
      `Int` (API change).

  * Markdown reader:

    + Use `tex` instead of `latex` for raw tex-ish content. We can't
      always tell if it's LaTeX, ConTeXt, or plain TeX. Better just to
      use `tex` always. Note that if `context` or `latex` specifically
      is desired, you can still force that in a markdown document by
      using the raw attribute. Note that this change may affect some
      filters, if they assume that raw tex parsed by the Markdown reader
      will be RawBlock (Format `latex`). In most cases it should be
      trivial to modify the filters to accept `tex` as well.
    + Refactor and reorganize YAML code (Mauro Bieg).
    + Make `example_lists` work for interrupted lists
      without `startnum` (#4908).

  * HTML reader:

    + Parse `<script type="math/tex` tags as math (#4877).
      These are used by MathJax in some configurations.
    + Extract spaces inside links instead of trimming them
      (Alexander Krotov, #4845).
    + Added round-trip tests (Alexander Krotov).
    + Make parsing sensitive to the `raw_tex` extension (#1126). This now
      allows raw LaTeX environments, `\ref`, and `\eqref` to be parsed
      (which is helpful for translation HTML documents using MathJaX).

  * Org reader (Albert Krewinkel):

    + Respect export option `p` for planning info.  Inclusion of planning info
      (`*DEADLINE*`, `*SCHEDULED*`, and `*CLOSED*`) can be controlled via the
      `p` export option: setting the option to `t` will add all planning
      information in a *Plain* block below the respective headline.
    + Org reader internals: don't rely on RecordWildCards and ViewPatterns
      ghc extensions.
    + Strip planning info from output.  Planning info is parsed, but not
      included in the output (as is the default with Emacs Org-mode, #4867).

  * LaTeX reader:

    + Handle parameter patterns for `\def` (#4768, #4771).
      For example:  `\def\foo#1[#2]{#1 and #2}`.
    + Allow `%` characters in URLs. This affects `\href` and `\url` (#4832).
    + Fixed parsing of `\texorpdfstring`. We were returning the wrong
      argument as the content.
    + Support `blockcquote`, `foreignblockquote`, `foreigncblockquote`,
      `hyphenblockquote`, `hyphencblockquote`, `enquote*`, `foreignquote`,
      `hyphenquote` from `csquotes` (#4848). Note that `foreignquote`
      will be parsed as a regular Quoted inline (not using the quotes
      appropriate to the foreign language).
    + Support more text-mode accents (#4652). Add support for `\|`, `\b`, `\G`,
      `\h`, `\d`, `\f`, `\r`, `\t`, `\U`, `\i`, `\j`, `\newtie`,
      `\textcircled`. Also fall back to combining characters when composed
      characters are not available.
    + Resolve `\ref` for figure numbers.
    + Support `mintinline` (#4365, Marc Schreiber).
    + Fix siunitx unit commands so they are only recognized in
      siunitx contexts (#4842). For example, `\l` outside of an
      siunitx context should be l-slash, not l (for liter).
    + Fix double `unnumbered` class (#4838). The `unnumbered` class
      was being included twice for starred sections.

  * RST reader: Don't skip link definitions after comments (#4860).

  * Muse reader (Alexander Krotov):

    + Close the `</quote>` in indented tag test.
      There is already a separate test for unclosed `</quote>`.
    + Autonumber sections in the correct order.  Parsing now stops
      at each section header to ensure the header is registered before
      parsing of the next section starts.
    + Move duplicate code into `headingStart` function.
    + Allow newline after opening `*` or `**`.
    + Don't allow digits after closing marker in lightweight markup
      This change makes reader more compatible with Emacs Muse.
    + Parse `<verse>` tag in one pass instead of using
      `parseFromString`. This change makes it possible to have
      verbatim `</verse>` tag inside verse.

  * ODT reader:  deal gracefully with missing `<office:font-face-decls/>`
    (#4336). This allows pandoc to parse ODT document produced by KDE's
    Calligra.

  * Muse writer (Alexander Krotov):

    + Output headers without asterisks if not on the top level.
    + Never wrap definition list terms.
    + Set `envInsideBlock = True` when rendering notes.
    + Use `""` instead of `[]` for empty String.
    + Check for whitespace in the beginning and end of Str's.
    + Escape `-`, `;` and `>` in the beginning of strings.
    + Escape list markers in the beginning of notes.
    + Normalize inline list before testing if tags should be used.
    + Use tags instead of lightweight markup for empty strings.
    + Use lightweight markup when possible.
    + Escape empty strings.  This guarantees that `conditionalEscapeString`
      never returns empty string.
    + Wrap conditionalEscapeString result into `Muse` type.
      This removes the need to pass `envInsideLinkDescription` to it.
    + Separate `shouldEscapeString` function.
    + Simplify inline list rendering.
    + Replace newlines in strings with spaces.

  * Docx writer:

    + Add MetaString case for abstract, subtitle (#4900, Mauro Bieg).
    + Properly handle display math in spans (#4826). This isn't a
      complete solution, since other nestings of display math may still
      cause problems, but it should work for what is by far the most
      common case.

  * HTML writer:

    + Always output `<dt>` element, even if it is empty (#4883,
      Alexander Krotov).
    + Don't prefix `epub:` attributes with `data-`.

  * Org writer: Don't escape literal `_`, `^` (#4882). Org doesn't
    recognize these escapes.

  * ODT writer: Fix percentage image scaling (#4881, Nils Carlson).
    Image scaling was broken when a width was set to a percentage.

  * EPUB writer: set `epub:type` on body element in each chapter,
    depending on the `epub:type` of the first section (#4823). This
    only affects epub3. See
    http://www.idpf.org/epub/profiles/edu/structure/#h.l0bzsloklt10

  * FB2 writer: put `coverpage` element between title and date rather than in
    `document-info` element (#4854).

  * Markdown writer: Escape `~` if strikeout extension enabled (#4840).

  * Haddock writer: Use proper format for latex math in haddock (#4571, Joe
    Hermaszewski). Inline math in `\(..\)`, display math in `\[..\]`,
    tex is now used. Previously we'd "fake it with unicode" and fall
    back to tex when that didn't work. But newer haddock versions
    support latex math.

  * TEI writer:

    + Ensure that title element is always present, even if empty (#4839).
    + Put author tags in the template, rather than adding them in
      the writer (#4839).

  * LaTeX writer/template: be sensitive to `filecolor` variable (#4822).
    `linkcolor` only affects internal links, and `urlcolor` only
    affects linked URLs.  For external links, the option to use is
    `filecolor`.

  * ConTeXt writer: output raw `tex` blocks as well as `context` (#969).

  * RST writer:

    + Use `.. raw:: latex` for `tex` content.
    + Use `.. container` for generic Divs, instead of raw HTML.
    + Render Divs with admonition classes as admonitions (#4833).
      Also omit Div with class `admonition-title`. These are generated
      by the RST reader and should be omitted on round-trip.

  * Text.Pandoc.PDF: fix message printed when rsvg-convert is not available
    (#4855, Antonio Terceiro).

  * HTML5 template: add the `title-block-header` identifier to the
    `header` element, to make it easier to style precisely (#4767,
    J. B. Rainsberger).

  * OpenDocument template: Remove unnecessary indenting of TOC title (#4798,
    José de Mattos Neto).

  * latex template: Add support for $toc-title$ to LaTeX (and PDF)
    (#4853, Wandmalfarbe).

  * TEI template: improve `publicationStmt`. Add support for
    `publisher`, `address`, `pubPlace`, and `date` variables.

  * beamer template: Support "toc-title" (#4835, Cyril Roelandt).

  * Text.Pandoc.Extensions: Fix haddock on `Ext_footnotes` (Chris Martin).

  * Lua: cleanup Lua utils, remove unused functions (Albert Krewinkel).

  * MANUAL.txt:

    + Clarify that `--biblatex/--natbib` don't work directly for PDF
      (#4904).
    + Document `epub:type` attribute (Mauro Bieg, #4901)
    + Clarify when `--resource-path` has an effect.
    + More detail on customization in syntax highlighting section.
    + Document encoding issue with `--listings` (#4871, Damien Clochard).
    + Remove docs on removed `--katex-stylesheet` (Mauro Bieg, #4862).
    + Use https for context wiki links (#4910).

  * CONTRIBUTING.md:

    + Link to lua-filters repository (#4874).
    + Fix mistake in REPL instructions for stack. (#4849, Brian Leung).

  * lua-filters.md: add links to filters, and to lua-filters repository
    (#4874).

  * INSTALL.md:

    + Indicate that cabal >= 2.0 is needed.
    + Added chocolatey installation method (#4844, Miodrag Milić).

  * Travis: exclude round-trip tests, except for nightly test which can fail.

  * Use latest texmath, pandoc-citeproc.

  * Use a patched version of foundation until
    https://github.com/haskell-foundation/foundation/pull/503
    is fixed.

  * Clean up appveyor build and Windows package creation.
    We now use 64-bit stack and ghc 8.4.3, lts-12 for the 64-bit build. The
    WiX-based msi is now 64-bit for 64-bit builds (fixing #4795).

  * Remove obsolete RELEASE-CHECKLIST.md.

  * Added additional compiler warnings in Makefile and CI builds.

## pandoc 2.2.3.2 (2018-08-07)

  * Markdown reader: Properly handle boolean values in YAML metadata (#4819).
    This fixes a regression in 2.2.3, which cause boolean values to
    be parsed as MetaInlines instead of MetaBool.

    We here record another undocumented (but desirable) change in 2.2.3:
    numerical metadata fields are now parsed as MetaInlines rather than
    MetaString.

## pandoc 2.2.3.1 (2018-08-06)

  * Markdown reader: Fix parsing of embedded mappings in YAML metadata
    (#4817).  This fixes a regression in 2.2.3 which caused embedded
    mappings (e.g. mappings in sequences) not to work in YAML metadata.

## pandoc 2.2.3 (2018-08-05)

  * RST reader: improve parsing of inline interpreted text roles (#4811).

    + Use a Span with class "title-reference" for the default
      title-reference role.
    + Use `B.text` to split up contents into `Space`s, `SoftBreak`s,
      and `Str`s for `title-reference`.
    + Use Code with class "interpreted-text" instead of Span and Str for
      unknown roles.  (The RST writer has also been modified to round-trip
      this properly.)
    + Disallow blank lines in interpreted text.
    + Backslash-escape now works in interpreted text.
    + Backticks followed by alphanumerics no longer end interpreted text.
    + Remove support for nested inlines (Francesco Occhipinti).
      RST does not allow nested emphasis, links, or other inline
      constructs.  This fixes several bugs (#4581, #4561, #4792).

  * Org reader: fix parsers relying on `parseFromString` (#4784, Albert
    Krewinkel).  Emphasis was not parsed when it followed directly after
    some block types (e.g., lists).

  * Markdown reader: Allow unquoted numbers and booleans as YAML mapping
    keys.  Previously in 2.2.2 you could not do
    ```
    ---
    0: bar
    ...
    ```
    but only
    ```
    ---
    '0': bar
    ...
    ```
    With this change, both forms work.

  * DocBook reader: metadata handling improvements.
    Now we properly parse title and subtitle elements that are direct
    children of book and article (as well as children of bookinfo,
    articleinfo, or info).  We also now use the `subtitle` metadata
    field for subtitles, rather than tacking the subtitle on to the
    title.

  * RST writer:

    + Allow images to be directly nested within links (#4810, Francesco
      Occhipinti).
    + Use `titleblock` instead of `title` variable for title block (#4803,
      Francesco Occhipinti).  `titleblock` contains a properly formatted
      title and subtitle (using top-level headers).  `title` and
      `subtitle` variables are still available and just contain the
      title and subtitle text.  Note that this change will require an
      update to custom rst templates.
    + Render Code with class "interpreted-text" as interpreted text role.

  * MediaWiki writer: Avoid extra blank line in tables with empty cells
    (#4794).  Note that the old output is semantically identical, but the
    new output looks better.

  * Lua Utils module: add function `blocks_to_inlines` (#4799, Albert
    Krewinkel).  Exposes a function converting which flattenes a list of
    blocks into a list of inlines. An example use case would be the
    conversion of Note elements into other inlines.

  * RST template:  use `titleblock` instead of `title`.  Users of
    custom RST templates will want to update this.

  * LaTeX template: Moved some beamer code in default.latex template.
    This change allows beamer themes to change the template and font (as
    Metropolis does) (#4450).

  * Better error message on `-t pdf -o out.pdf` (#1155, Mauro Bieg).

  * Added test case for #4669 to repository.

  * INSTALL.md: Fix broken link for cabal-install (#4806, ChanHoHo).

  * MANUAL.txt:

    + Add beamer info for slide backgrounds (#4802, John Muccigrosso).
    + Clarify when `csquotes` is used in LaTeX writer (#4514).
    + Add `commonmark` to list of output formats where `raw_tex` has an
      effect (see #4527).


## pandoc 2.2.2.1 (2018-07-19)

  * Fix regression finding templates in user data directory (#4777).
    Under version 2.2.1 and prior pandoc found latex templates in the
    templates directory under the data directory, but this broke in 2.2.2.

  * Fix for bug in parsing `\input` in `rawLaTeXBlock` and
    `rawLaTeXInline` (#4781). (This primarily affects the markdown
    reader, and other readers that accept raw tex.)
    Starting in 2.2.2, everything after an `\input` (or `\include`)
    in a markdown file would be parsed as raw LaTeX.

  * MANUAL:

    + Clarify `gfm` vs `markdown_github` (#4783, Mauro Bieg).
    * Use `keywords` instead of `tags` in YAML metadata example (#4779).
      Unlike `tags`, `keywords` is used in some of the writers
      and default templates.

  * Add missing `rollingLinks` option to revealjs template (#4778,
    Igor Khorlo).

## pandoc 2.2.2 (2018-07-16)

  * Use HsYAML instead of yaml for translations and YAML metadata (#4747).
    yaml wraps a C library; HsYAML is pure Haskell.  Advances #4535.

    Note: HsYAML implements YAML 1.2, in which the valid true
    values are `true`, `True`, `TRUE`.  This means a change in
    the semantics of YAML metadata that could affect users:
    `y`, `yes`, and `on` no longer count as true values.

  * Fix regression: make `--pdf-engine` work with full paths (#4681, Mauro
    Bieg).

  * CommonMark reader: Handle `ascii_identifiers` extension (#4742,
    Anders Waldenborg).  Non-ascii characters were not stripped from
    identifiers even if the `ascii_identifiers` extension was
    enabled (which is is by default for gfm).

  * TikiWiki reader: Improve list parsing (#4722, Mauro Bieg).
    Remove trailing Space from list items.  Parse lists that have no space
    after marker.

  * LaTeX reader:

    + Treat `lilypond` as a verbatim environment (#4725).
    + Parse figure label into Image id (#4700, Mauro Bieg).
    + Beamer: Allow "noframenumbering" option (#4696, Raymond Ehlers).
    + Allow spaces around `\graphicspath` arguments (#4698).
    + Handle includes without surrounding blanklines (#4553).
      In addition, `\input` can now be used in an inline context,
      e.g. to provide part of a paragraph, as it can in LaTeX.
    + In `rawLaTeXBlock`, handle macros that resolve to a
      `\begin` or `\end` (#4667).
    + In `rawLaTeXBlock`, don't expand macros in macro definitions (#4653).
      Note that this only affected LaTeX in markdown.
    + Tighten up reading of beamer overlay specifications (#4669).
      Ideally we'd turn these on only when reading beamer, but currently
      beamer is not distinguished from latex as an input format.
      This commit also activates parsing of overlay specifications
      after commands in general (e.g. `\item`), since they can occur
      in many contexts in beamer.
    + Parse more siunitx unit commands (#4296, #4773).
    + Be more forgiving in key/value option parsing (#4761).

  * Markdown reader:

    + Allow empty code spans, e.g. `` ` ` ``.
    + Emojis are now wrapped in Spans with class `emoji` and
      attribute `data-emoji` (Anders Waldenborg, #4743).
      This allows the writer to handle them in a special way
      (e.g. using a special font, or just rendering the
      emoji name).

  * Muse reader (Alexander Krotov, except where indicated):

    + Get rid of non-exhaustive pattern match warning (Mauro Bieg).
    + Add support for floating images.
    + Add support for images with specified width.
    + Parse image URLs without "guard" and "takeExtension".
    + Split link and image parsing into separate functions.
    + Parse links starting with "URL:" explicitly instead of trying to strip
      "URL:" prefix after parsing.

  * Texinfo writer: Use `@sup` and `@sub` instead of custom macros (#4728,
    Alexander Krotov).

  * Markdown writer: Preserve `implicit_figures` with attributes, even if
    `implicit_attributes` is not set, by rendering in raw HTML (#4677).

  * Markdown and commonmark/github writers now respect the `emoji`
    extension.  So, `-f markdown+emoji -t markdown+emoji` now leaves
    `:smile:` as `:smile:` rather than converting it to a smile
    character.

  * Docx writer: Be sensitive to `toc` in YAML metadata (#4645).

  * ODT/OpenDocument writer: Make internal links work (#4358).
    This adds proper bookmarks to the headers with non-null IDs.

  * EPUB writer: Properly escape pagetitle.  Previously we weren't
    escaping `&` and other XML characters in the pagetitle, so a title
    containing a `&` would be invalid.

  * AsciiDoc Writer: Eescape square brackets at start of line (#4545,
    Mauro Bieg).

  * RST writer:

    + Don't treat 'example' as a syntax name (#4748).
      This fixes conversions from org with example blocks.
    + Support `--number-sections` via the `section-numbering`
      directive in standalone output.

  * reveal.js writer and template: reuse mathjax URL
    provided by the argument to `--mathjax` or the normal pandoc default,
    rather than a hard-coded one in the template (#4701).

  * LaTeX writer:

    + Properly handle footnotes in table captions (#4683).
      Refactored code from figure captions to use in both places.
    + In beamer output, fix single digit column percentage (#4690, Mauro
      Bieg).

  * FB2 writer (Alexander Krotov):

    + Convert Plain to Para in annotation (#2424).
    + Fix order of items in title-info (#2424).

  * Custom writer: fix error message on script failure (Albert Krewinkel).
    Error messages produced by Lua were not displayed by Pandoc.

  * Text.Pandoc.Emoji now exports `emojiToInline`, which returns a Span
    inline containing the emoji character and some attributes with metadata
    (class `emoji`, attribute `data-emoji` with emoji name).  (API change,
    Anders Waldenborg, #4743).

  * Text.Pandoc.PDF:

    + Revert fix for #4484 (only compress images on last run, #4755).
      This will mean some increase in the time it takes to
      produce an image-heavy PDF with xelatex, but it will
      make tables of contents correct, which is more important.
    + Fix logic error in `runTeXProgram`.  We were running the tex program
      one more time than requested.  This should speed up PDF production.

  * Allow `--template` to take a URL as argument.

  * Text.Pandoc.Highlighting: Add missing re-export of `breezeDark`
    highlighting style (#4687, Adrian Sieber, API change).

  * Clarify macOS install in INSTALL.md (#4661).  Make the binary package
    installer the recommended method, and note that on some older versions of
    macOS, homebrew installs from source and takes a lot of disk space
    (#4664, Ian).

  * MANUAL:

    + Clarify EPUB linked media (#4756, Mauro Bieg)
    + Update manual for "true" YAML values.  Now that we're using HsYAML and
      YAML 1.2, the valid true values are `true`, `True`, `TRUE`.  NOTE!
      `y`, `yes`, `on` no longer count as true values.
    + Document `-F` as alias for `--filter` (thanks to Gandalf Saxe).
    + Update manual on how math is rendered in LaTeX.
    + Add proxy description (#4131, Mauro Bieg).
    + Clarify that `--toc` requires `--standalone` (#4703).
    + Update citation styles link (#4699, wiefling).

  * In API docs, clarify how `Ext_east_asian_line_breaks` extension works
    (kaizshang91).  Note that it will not take effect when readers/writers
    are called as libraries (#4674).

  * Improved translations/fr (#4766, lux-lth).

  * Removed inadvertently added `.orig` files from repository (#4648).

  * Remove `network-uri` flag and use 'Network.Socket'.
    This removes a compiler warning.  There is no need for the old
    `network-uri` flag, since network 2.6 was released in 2014.

  * Add stack.lts10.yaml, stack.lts11.yaml.  use lts-12 in stack.yaml.

  * Bump upper bounds for dependent packages.

  * Exclude foundation 0.0.21 for ghc 7.10.  Otherwise cabal gets
    confused because of the way ghc 7.10 is excluded in foundation's
    cabal file.  This can be removed when haskell-foundation/foundation#500
    is fixed.

  * Require cabal-version >= 2.0.  This is needed for haddock-library.




## pandoc 2.2.1 (2018-05-10)

  * Restored and undeprecated gladtex for HTML math (#4607).

    + Added `GladTeX` constructor to `Text.Pandoc.Options.HTMLMathMethod`
      [API change, reverts removal in v2.2]
    + Restored and undeprecated `--gladtex` option, removed in v2.2.

  * LaTeX reader:  Handle `$` in `/text{..}` inside math (#4576).

  * Org reader: Fix image filename recognition (Albert Krewinkel).
    Use a function from the filepath library to check whether a string is a
    valid file name.  The custom validity checker that was used before gave
    wrong results (e.g. for absolute file paths on Windows,
    kawabata/ox-pandoc#52).

  * FB2 reader: Replace some errors with warnings (Alexander Krotov).

  * HTML writer:

    + Strip links from headers when creating TOC (#4340).
      Otherwise the TOC entries will not link to the sections.
    + Fix regression with tex math environments in HTML + MathJax (#4639).

  * Muse writer (Alexander Krotov): Add support for left-align and
    right-align classes (#4542).

  * Docx writer: Support underline (#4633).

  * Text.Pandoc.Parsing: Lookahead for non-whitespace after
    `singleQuoteStart` and `doubleQuoteStart` (#4637).

  * `test-pandoc-utils.lua`:  more robust testing on both windows
    and \*nix. Previously the pipe tests were only run if
    `\bin/false` and `/bin/sed` were present, which they aren't
    in default MacOS and Windows systems.  Fixed by using `tr`
    and `false`, which should always be in the path on a \*nix
    system, and `find` and `echo` for Windows.

  * Text.Pandoc.Shared: add `uriPathToPath`.
    This adjusts the path from a file: URI in a way that is sensitive
    to Windows/Linux differences.  Thus, on Windows,
    `/c:/foo` gets interpreted as `c:/foo`, but on Linux,
    `/c:/foo` gets interpreted as `/c:/foo`.  See #4613.

  * Use `uriPathToPath` with file: URIs (#4613).

  * Revert piping HTML to pdf-engine (Mauro Bieg, #4413).  Use a temp
    file as before.

  * Text.Pandoc.Class: Catch IO errors when writing media files
    and issue a warning, rather than an error (Francesco Occhipinti, #4559).

  * Don't lowercase custom writer filename (Alexander Krotov, #4610).

  * MANUAL (Mauro Bieg):

    + Clarify truthiness in template variables (#2281).
    + Clarify pipe table width calculation (#4520).

  * ConTeXt template: New Greek fallback typeface (Pablo Rodríguez, #4405).
    CMU Serif gives better typographic results than the previous
    Greek fallback DejaVu Serif.

  * Make HTML template polyglot (#4606, OvidiusCicero), by making
    `<link rel="stylesheet" href="$css$">` self-closing.

  * Use texmath 0.11, allowing better translation of non-ASCII
    characters in math (#4642).


## pandoc 2.2 (2018-04-27)

  * New input format: `fb2` (FictionBook2) (Alexander Krotov).

  * Make `--ascii` work for all XML formats (ICML, OPML, JATS,...),
    and for `ms` and `man`.

  * Remove deprecated `--latexmathml`, `--gladtex`, `--mimetex`, `--jsmath`, `-m`,
    `--asciimathml` options.

  * New module Text.Pandoc.Readers.FB2, exporting readFB2 (Alexander
    Krotov, API change).

  * Markdown reader:

    + Allow empty key-value attributes, like `title=""` (#2944).
    + Handle table w/o following blank line in fenced div (#4560).
    + Remove "fallback" for `doubleQuote` parser.  Previously the
      parser tried to be efficient -- if no end double quote was found,
      it would just return the contents.  But this could backfire in a
      case `**this should "be bold**`, since the fallback would return
      the content `"be bold**` and the closing boldface delimiter
      would never be encountered.
    + Improve computation of the relative width of the last column in a
      multiline table, so we can round-trip tables without constantly
      shrinking the last column.

  * EPUB reader:

    + Fix images with space in file path (#4344).

  * LaTeX reader:

    + Properly resolve section numbers with `\ref` and chapters (#4529).
    + Parse sloppypar environment (#4517, Marc Schreiber).
    + Improve handling of raw LaTeX (for markdown etc.) (#4589, #4594).
      Previously there were some bugs in how macros were handled.
    + Support `\MakeUppercase`, `\MakeLowercase`, `\uppercase`,
      `\lowercase`, and also `\MakeTextUppercase` and
      `\MakeTextLowercase` from textcase (#4959).

  * Textile reader:

    + Fixed tables with no body rows (#4513).
      Previously these raised an exception.

  * Mediawiki reader:

    + Improve table parsing (#4508).  This fixes detection of table
      attributes and also handles `!` characters in cells.

  * DocBook reader:

    + Properly handle title in `section` element (#4526).
      Previously we just got `section_title` for `section` (though `sect1`,
      `sect2`, etc. were handled properly).
    + Read tex math as output by asciidoctor (#4569, Joe Hermaszewski).

  * Docx reader:

    + Combine adjacent CodeBlocks with the same attributes into
      a single CodeBlock.  This prevents a multiline codeblock in
      Word from being read as different paragraphs.

  * RST reader:

    + Allow < 3 spaces indent under directives (#4579).
    + Fix anonymous redirects with backticks (#4598).

  * Muse reader (Alexander Krotov):

    + Add support for Text::Amuse multiline headings.
    + Add `<math>` tag support.
    + Add support for `<biblio>` and `<play>` tags.
    + Allow links to have empty descriptions.
    + Require block `<literal>` tags to be on separate lines.
    + Allow `-` in anchors.
    + Allow verse to be indented.
    + Allow nested footnotes.
    + Internal improvements.

  * Muse writer (Alexander Krotov):

    + Escape `>` only at the beginning of a line.
    + Escape `]` in image title.
    + Escape `]` brackets in URLs as `%5D`.
    + Only escape brackets when necessary.
    + Escape ordered list markers.
    + Do not escape list markers unless preceded by space.
    + Escape strings starting with space.
    + Escape semicolons and markers after line break.
    + Escape `;` to avoid accidental comments.
    + Don't break headers, line blocks and tables with line breaks.
    + Correctly output empty headings.
    + Escape horizontal rule only if at the beginning of the line.
    + Escape definition list terms starting with list markers.
    + Place header IDs before header.
    + Improve span writing.
    + Do not join Spans in normalization.
    + Don't align ordered list items.
    + Remove key-value pairs from attributes before normalization.
    + Enable `--wrap=preserve` for all tests by default.
    + Reduced `<verbatim>` tags in output.
    + Internal changes.

  * RST writer:

    + Use more consistent indentation (#4563).  Previously we
      used an odd mix of 3- and 4-space indentation.  Now we use 3-space
      indentation, except for ordered lists, where indentation must
      depend on the width of the list marker.
    + Flatten nested inlines (#4368, Francesco Occhipinti).
      Nested inlines are not valid RST syntax, so we flatten them following
      some readability criteria discussed in #4368.

  * EPUB writer:

    + Ensure that `pagetitle` is always set, even when structured titles
      are used.  This prevents spurious warnings about empty title
      elements (#4486).

  * FB2 writer (Alexander Krotov):

    + Output links inline instead of producing notes.  Previously all links
      were turned into footnotes with unclickable URLs inside.
    + Allow emphasis and notes in titles.
    + Don't intersperse paragraph with empty lines.
    + Convert metadata value `abstract` to book annotation.
    + Use `<empty-line />` for `HorizontalRule` rather than `LineBreak`.
      FB2 does not have a way to represent line breaks inside paragraphs;
      previously we used `<empty-line />` elements, but these are not allowed
      inside paragraphs.

  * Powerpoint writer (Jesse Rosenthal):

    + Handle Quoted Inlines (#4532).
    + Simplify code with `ParseXml`.
    + Allow fallback options when looking for placeholder type.
    + Check reference-doc for all layouts.
    + Simplify speaker notes logic.
    + Change notes state to a simpler per-slide value.
    + Remove `Maybe` from `SpeakerNotes` in `Slide`. `mempty`
      means no speaker notes.
    + Add tests for improved speaker notes.
    + Handle speaker notes earlier in the conversion process.
    + Keep notes with related blocks (#4477).  Some blocks automatically
      split slides (imgs, tables, `column` divs). We assume that any
      speaker notes immediately following these are connected to these
      elements, and keep them with the related blocks, splitting after them.
    + Remove `docProps/thumbnail.jpeg` in data dir (Jesse Rosenthal, #4588).
      It contained a nonfree ICC color calibration profile and is not needed
      for production of a powerpoint document.

  * Markdown writer:

    + Include a blank line at the end of the row in a single-row multiline
      table, to prevent it from being interpreted as a simple table (#4578).

  * CommonMark writer:

    + Correctly ignore LaTeX raw blocks when `raw_tex` is not
      enabled (#4527, quasicomputational).

  * EPUB writer:

    + Add `epub:type="footnotes"` to notes section in EPUB3 (#4489).

  * LaTeX writer:

    + In beamer, don't use format specifier for default ordered lists
      (#4556).  This gives better results for styles that put ordered list
      markers in boxes or circles.
    + Update `\lstinline` delimiters (#4369, Tim Parenti).

  * Ms writer:

    + Use `\f[R]` rather than `\f[]` to reset font (#4552).
    + Use `\f[BI]` and `\f[CB]` in headers, instead of `\f[I]` and `\f[C]`,
      since the header font is automatically bold (#4552).
    + Use `\f[CB]` rather than `\f[BC]` for monospace bold (#4552).
    + Create pdf anchor for a Div with an identifier (#4515).
    + Escape `/` character in anchor ids (#4515).
    + Improve escaping for anchor ids: we now use _uNNN_ instead of uNNN
      to avoid ambiguity.

  * Man writer:

    + Don't escape U+2019 as `'` (#4550).

  * Text.Pandoc.Options:

    + Removed `JsMath`, `LaTeXMathML`, and `GladTeX` constructors from
    `Text.Pandoc.Options.HTMLMathMethod` [API change].

  * Text.Pandoc.Class:

    + `writeMedia`: unescape URI-escaping in file path.  This avoids
      writing things like `file%20one.png` to the file system.

  * Text.Pandoc.Parsing:

    + Fix `romanNumeral` parser (#4480).  We previously accepted 'DDC'
      as 1100.
    + `uri`: don't treat `*` characters at end as part of URI (#4561).

  * Text.Pandoc.MIME:

    + Use the alias `application/eps` for EPS (#2067).
      This will ensure that we retain the eps extension after reading the
      image into a mediabag and writing it again.

  * Text.Pandoc.PDF:

    + Use `withTempDir` in `html2pdf`.
    + With `xelatex`, don't compress images til the last run (#4484).
      This saves time for image-heavy documents.
    + Don't try to convert EPS files (#2067).  `pdflatex` converts them
      itself, and JuicyPixels can't do it.
    + For `pdflatex`, use a temp directory in the working directory.
      Otherwise we can have problems with the EPS conversion pdflatex
      tries to do, which can't operate on a file above the working
      directory without `--shell-escape`.

  * Changes to tests to accommodate changes in pandoc-types.
    In <https://github.com/jgm/pandoc-types/pull/36> we changed
    the table builder to pad cells.  This commit changes tests
    (and two readers) to accord with this behavior.

  * Set default extensions for `beamer` same as `latex`.

  * LaTeX template:

    + Add `beameroption` variable (#4359, Étienne Bersac).
    + Use `pgfpages` package; this is needed for notes on second
      screen in beamer (Étienne Bersac).
    + Add `background-image` variable (#4601, John Muccigrosso).

  * reveal.js template: Add `background-image` variable (#4600,
    John Muccigrosso).

  * ms template: Fix date.  Previously `.ND` was used, but this only
    works if you have a title page, which we don't.  Thanks to @teoric.

  * Removed pragmas for unused extensions (#4506, Anabra).

  * Fix bash completion for `--print-default-data-file` (#4549).
    Previously this looked in the filesystem, even if pandoc
    was compiled with `embed_data_files` (and sometimes it looked
    in a nonexistent build directory).  Now the bash completion
    script just includes a hard-coded list of data file names.

  * MANUAL:

    + Clarify template vs metadata variables (#4501, Mauro Bieg).
    + Fix raw content example (#4479, Mauro Bieg).
    + Specify that you use html for raw output in epub.
    + Add examples for raw docx blocks (#4472, Tristan Stenner).
      The documentation states that the target format name should match
      the output format, which isn't the case for `docx`/`openxml` and
      some others.
    + Don't say that `empty_paragraphs` affects markdown output (#4540).
    + Consolidate input/output format documentation (#4577, Mauro Bieg).

  * New README template. Take in/out formats from manual.

  * Fix example in lua-filters docs (#4459, HeirOfNorton).

  * Use the `-threaded` GHC flag when building benchmarks (#4587,
    Francesco Occhipinti).

  * Bump temporary upper bound to 1.4.

  * Use pandoc-citeproc 0.14.3.1.

  * Use texmath-0.10.1.2 (fixes escapes in math in ms, #4597).

  * Removed old lib directory.  This was used for something long ago,
    but plays no role now.

  * Removed unneeded data file `LaTeXMathML.js`.

  * Create 64- and 32-bit versions of Windows binary packages.

## pandoc 2.1.3 (2018-03-18)

  * Docx reader (Jesse Rosenthal):

    + Add tests for nested smart tags.
    + Parse nested smart tags.
    + Make unwrapSDT into a general `unwrap` function that can unwrap both
      nested SDT tags and smartTags. This makes the SmartTags constructor in
      the Docx type unnecessary, so we remove it (#4446).
    + Remove unused `docxWarnings` (Alexander Krotov).

  * RST reader: Allow unicode bullet characters (#4454).

  * Haddock reader:  Better table handling, using haddock-library's
    new table support, if compiled against a version that
    includes it.  Note that tables with col/rowspans will not
    translate well into Pandoc.

  * Muse reader (Alexander Krotov):

    + Various internal improvements.
    + Require closing tag to have the same indentation as opening.
    + Do not reparse blocks inside unclosed block tag (#4425).
    + Parse `<class>` tag (supported by Emacs Muse).
    + Do not produce empty Str element for unindented verse lines.

  * LaTeX reader:

    + Add support to parse unit string of `\SI` command (closes #4296,
      Marc Schreiber).

  * Haddock writer:  In the writer, we now render tables always as
    grid tables, since Haddock supports these.

  * DokuWiki writer: rewrite backSlashLineBreaks (#4445, Mauro Bieg).

  * Docx writer: Fixed formatting of `DefaultStyle` ordered lists in
    docx writer.  We want decimal for the top level, not lower roman.

  * RST writer:

    + Strip whitespace at beginning and ending of inline containers
      (#4327, Francesco Occhipinti).
    + Filter out empty inline containers (#4434).  There is nothing in
      RST that corresponds to e.g. `Emph []`, so we just ignore elements
      like this (Francesco Occhipinti).

  * Muse writer (Alexander Krotov):

    + Support spans with anchors.
    + Replace smallcaps with emphasis before normalization.
    + Output smallcaps as emphasis.
    + Expand Cite before list normalization.
    + Write empty inline lists as `<verbatim></verbatim>`.
    + Remove empty Str from the beginning of inline lists during normalization.
    + Escape "-" to avoid creating bullet lists.
    + Fix math expansion for more than one expression per paragraph.
    + Expand math before inline list normalization.

  * Dokuwiki writer: fix LineBreaks in Tables (#4313, Mauro Bieg).

  * Ms writer:

    + Asciify pdf anchors, since unicode anchors don't work (#4436).
      Internal links should be converted automatically, so this shouldn't
      affect users directly.
    + Don't escape hyphens as `\-`; that's for a minus sign (#4467).

  * Beamer writer: put hyperlink after `\begin{frame}` and not in the title
    (#4307).  If it's in the title, then we get a titlebar on slides with
    the `plain` attribute, when the id is non-null.  This fixes a regression
    in 2.0.

  * EPUB writer: Remove notes from TOC in nav.xhtml (#4453, Mauro Bieg).

  * JATS writer: Remove extraneous, significant whitespace (#4335,
    Nokome Bentley).

  * html2pdf: inject base tag with current working directory (#4413, Mauro
    Bieg).  This helps ensure that linked resources are included.

  * Add Semigroup instances for everything for which we defined a
    Monoid instance previously (API change):

    + Text.Pandoc.Class.FileTree.
    + Text.Pandoc.Translations.Translations.
    + Text.Pandoc.Extensions.Extensions.
    + Text.Pandoc.Readers.Odt.StyleReader.Styles.
    + Text.Pandoc.Pretty.Doc.
    + Text.Pandoc.MediaBag.MediaBag.

  * Add custom Prelude to give clean code for Monoid and Semigroup
    that works with ghc 7.10-8.4.  The custom Prelude (`prelude/Prelude`)
    is used for ghc versions < 8.4.  `NoImplicitPrelude` is used
    in all source files, and Prelude is explicitly imported
    (this is necessary for ghci to work properly with the custom prelude).

  * Text.Pandoc.Writers.Shared (Francesco Occhipinti):

    + Export `stripLeadingTrailingSpace`.
    + Don't wrap lines in grid tables when `--wrap=none` (#4320).
    + `gridTable`: Don't wrap lines in tables when `--wrap=none`.  Instead,
      expand cells, even if it results in cells that don't respect relative
      widths or surpass page column width.  This change affects RST,
      Markdown, and Haddock writers.

  * Raise error if someone tries to print docx, odt, etc. template (#4441).

  * LaTeX template: Provide `bidi` package's option using
    `\PassOptionsToPackage`  (#4357, Václav Haisman).  This avoid a
    clash when   `polyglossia` loads it first and then it is loaded again
    for XeLaTeX.

  * ConTeXt template: Added `pdfa` variable to generate PDF/A (#4294, Henri
    Menke).  Instructions on how to install the ICC profiles on ConTeXt
    standalone can be found in the wiki:
    <http://wiki.contextgarden.net/PDFX#ICC_profiles>.
    If the ICC profiles are not available the log will contain error
    messages.

  * Use latest pandoc-types, skylighting

  * Use latest pandoc-citeproc in binary package.

  * Bump upper bound for time, criterion, haddock-library, exceptions,
    http-types, aeson, haddock-library.

  * Bump upper bound tasty-quickcheck 0.10 (#4429, Felix Yan).

  * pandoc.cabal:  fix up other-extensions and language fields.
    Language is now consistently `Haskell2010`, and other-extensions
    is consistently `NoImplicitPrelude`. Everything else to be specified
    in the module header as needed.

  * Removed `old-locale` flag and Text.Pandoc.Compat.Time.
    This is no longer necessary since we no longer support ghc 7.8.

  * Make `weigh-pandoc` into a benchmark program.
    Remove `weigh-pandoc` flag.  `weigh-pandoc` is now built (and run)
    automatically when you build (and run) benchmarks.

  * MANUAL: add instructions for background images reveal.js (#4325, John
    Muccigrosso).

  * appveyor: use VS 2013 environment instead of VS 2015 for Windows builds.

## pandoc 2.1.2 (2018-03-02)

  * Markdown reader:

    + Fix parsing bug with nested fenced divs (#4281).  Previously we allowed
      "nonindent spaces" before the opening and closing `:::`, but this
      interfered with list parsing, so now we require the fences to be flush with
      the margin of the containing block.

  * Commonmark reader:

    + `raw_html` is now on by default.  It can be disabled explicitly
      using `-f commonmark-raw_html`.

  * Org reader (Albert Krewinkel):

    + Move citation tests to separate module.
    + Allow changing emphasis syntax (#4378).  The characters allowed before
      and after emphasis can be configured via `#+pandoc-emphasis-pre` and
      `#+pandoc-emphasis-post`, respectively. This allows to change which
      strings are recognized as emphasized text on a per-document or even
      per-paragraph basis.  Example:

          #+pandoc-emphasis-pre: "-\t ('\"{"
          #+pandoc-emphasis-post: "-\t\n .,:!?;'\")}["

  * LaTeX reader:

    + Fixed comments inside citations (#4374).
    + Fix regression in package options including underscore (#4424).
    + Make `--trace` work.
    + Fixed parsing of `tabular*` environment (#4279).

  * RST reader:

    + Fix regression in parsing of headers with trailing space (#4280).

  * Muse reader (Alexander Krotov):

    + Enable `<literal>` tags even if amuse extension is enabled.
      Amusewiki disables <literal> tags for security reasons.
      If user wants similar behavior in pandoc, RawBlocks and RawInlines
      can be removed or replaced with filters.
    + Remove space prefix from `<literal>` tag contents.
    + Do not consume whitespace while looking for closing end tag.
    + Convert alphabetical list markers to decimal in round-trip test.
      Alphabetical lists are an addition of Text::Amuse.
      They are not present in Emacs Muse and can be ambiguous
      when list starts with "i.", "c." etc.
    + Allow `<quote>` and other tags to be indented.
    + Allow single colon in definition list term.
    + Fix parsing of verse in lists.
    + Improved parsing efficiency.  Avoid `parseFromString`.
      Lists are parsed in linear instead of exponential time now.
    + Replace ParserState with MuseState.
    + Prioritize lists with roman numerals over alphabetical lists.
      This is to make sure "i." starts a roman numbered list,
      instead of a list with letter "i" (followed by "j", "k", ...").
    + Fix directive parsing.
    + Parse definition lists with multiple descriptions.
    + Parse next list item before parsing more item contents.
    + Fixed a bug: headers did not terminate lists.
    + Move indentation parsing from `definitionListItem` to `definitionList`.
    + Paragraph indentation does not indicate nested quote.
      Muse allows indentation to indicate quotation or alignment,
      but only on the top level, not within a <quote> or list.
    + Require that block tags are on separate lines.
      Text::Amuse already explicitly requires it anyway.
    + Fix matching of closing inline tags.
    + Various internal changes.
    + Fix parsing of nested definition lists.
    + Require only one space for nested definition list indentation.
    + Do not remove trailing whitespace from `<code>`.
    + Fix parsing of trailing whitespace.  Newline after whitespace now
      results in softbreak instead of space.

  * Docx reader (Jesse Rosenthal, except where noted):

    + Handle nested sdt tags (#4415).
    + Don't look up dependant run styles if `+styles` is enabled.
    + Move pandoc inline styling inside custom-style span.
    + Read custom styles (#1843).  This will read all paragraph and
      character classes as divs and spans, respectively. Dependent styles
      will still be resolved, but will be wrapped with appropriate style
      tags. It is controlled by the `+styles` extension (`-f docx+styles`).
      This can be used in conjunction with the `custom-style` feature in the
      docx writer for a pandoc-docx editing workflow. Users can convert from
      an input docx, reading the custom-styles, and then use that same input
      docx file as a reference-doc for producing an output docx file. Styles
      will be maintained across the conversion, even if pandoc doesn't
      understand them.
    + Small change to Fields hyperlink parser.  Previously, unquoted string
      required a space at the end of the line (and consumed it). Now we
      either take a space (and don't consume it), or end of input.
    + Pick table width from the longest row or header (Francesco Occhipinti,
      #4360).

  * Muse writer (Alexander Krotov):

    + Change verse markup: `> ` instead of `<verse>` tag.
    + Remove empty strings during inline normalization.
    + Don't indent nested definition lists.
    + Use unicode quotes for quoted text.
    + Write image width specified in percent in Text::Amuse mode.
    + Don't wrap displayMath into `<verse>`.
    + Escape nonbreaking space (`~~`).
    + Join code with different attributes during normalization.
    + Indent lists inside Div.
    + Support definitions with multiple descriptions.

  * Powerpoint writer (Jesse Rosenthal):

    + Use table styles This will use the default table style in the
      reference-doc file. As a result they will be easier when using
      in a template, and match the color scheme.
    + Remove empty slides.  Because of the way that slides were split, these
      could be accidentally produced by comments after images.  When animations
      are added, there will be a way to add an empty slide with either
      incremental lists or pauses.
    + Implement syntax highlighting.  Note that background colors can't
      be implemented in PowerPoint, so highlighting styles that require
      these will be incomplete.
    + New test framework for pptx.  We now compare the output of the
      Powerpoint writer with files that we know to (a) not be corrupt,
      and (b) to show the desired output behavior (details below).
    + Add `notesMaster` to `presentation.xml` if necessary.
    + Ignore links and (end)notes in speaker notes.
    + Output speaker notes.
    + Read speaker note templates conditionally.  If there are speaker
      notes in the presentation, we read in the notesMasters templates
      from the reference pptx file.
    + Fix deletion track changes (#4303, Jesse Rosenthal).

  * Markdown writer: properly escape @ to avoid capture as citation
    (#4366).

  * LaTeX writer:

    + Put hypertarget inside figure environment (#4388).
      This works around a problem with the endfloat package and
      makes pandoc's output compatible with it.
    + Fix image height with percentage (#4389).  This previously caused
      the image to be resized to a percentage of textwidth, rather than
      textheight.

  * ConTeXt writer (Henri Menke):

    + New section syntax and support `--section-divs` (#2609).
      `\section[my-header]{My Header}` ->
      `\section[title={My Header},reference={my-header}]`.
      The ConTeXt writer now supports the `--section-divs` option to
      write sections in the fenced style, with `\startsection` and
      `\stopsection`.
    + xtables: correct wrong usage of caption (Henri Menke).

  * Docx writer:

    + Fix image resizing with multiple images (#3930, Andrew Pritchard).
    + Use new golden framework (Jesse Rosenthal).
    + Make more deterministic to facilitate testing (Jesse Rosenthal).
      - `getUniqueId` now calls to the state to get an incremented digit,
        instead of calling to P.uniqueHash.
      - we always start the PRNG in mkNumbering/mkAbstractNum with the same
        seed (1848), so our randoms should be the same each time.
    + Fix ids in comment writing (Jesse Rosenthal).  Comments from
      `--track-changes=all` were producing corrupt docx, because the
      writer was trying to get id from the `(ID,_,_)` field of
      the attributes, and ignoring the "id" entry in the key-value pairs. We
      now check both.

  * Ms writer: Added papersize variable.

  * TEI writer:

    + Use `height` instead of `depth` for images (#4331).
    + Ensure that id prefix is always used.
    + Don't emit `role` attribute; that was a leftover from the
      Docbook writer.
    + Use 'xml:id', not 'id' attribute (#4371).

  * AsciiDoc writer:

    + Do not output implicit heading IDs (#4363, Alexander
      Krotov).  Convert to `asciidoc-auto_identifiers` for old behaviour.

  * RST writer:

    + Remove `blockToRST'` moving its logic into `fixBlocks`
      (Francesco Occhipinti).
    + Insert comment between lists and quotes (#4248, Francesco Occchipinti).

  * RST template: remove definition of 'math' role as raw.
    This used to be needed prior to v 0.8 of docutils, but
    now math support is built-in.

  * Slides: Use divs to set incremental/non-incremental (#4381,
    Jesse Rosenthal).  The old method (list inside blockquote) still
    works, but we are encouraging the use of divs with class
    `incremental` or `nonincremental`.

  * Text.Pandoc.ImageSize:

    + Make image size detection for PDFs more robust (#4322).
    + Determine image size for PDFs (#4322).
    + EMF Image size support (#4375, Andrew Pritchard).

  * Text.Pandoc.Extensions:

    + Add `Ext_styles` (Jesse Rosenthal, API change).  This will be used in
      the docx reader (defaulting to off) to read pargraph and character
      styles not understood by pandoc (as divs and spans, respectively).
    + Made `Ext_raw_html` default for `commonmark` format.

  * Text.Pandoc.Parsing:

    + Export `manyUntil` (Alexander Krotov, API change).
    + Export improved `sepBy1` (Alexander Krotov).
    + Export list marker parsers: `upperRoman`, `lowerRoman`,
      `decimal`, `lowerAlpha`, `upperAlpha` (Alexander Krotov, API change).

  * Tests/Lua: fix tests on windows (Albert Krewinkel).

  * Lua: register script name in global variable (#4393).  The name of the Lua
    script which is executed is made available in the global Lua variable
    `PANDOC_SCRIPT_FILE`, both for Lua filters and custom writers.

  * Tests: Abstract powerpoint tests out to OOXML tests (Jesse Rosenthal).
    There is very little pptx-specific in these tests, so we abstract out
    the basic testing function so it can be used for docx as well. This
    should allow us to catch some errors in the docx writer that slipped
    by the roundtrip testing.

  * Lua filters: store constructors in registry (Albert Krewinkel).  Lua
    functions used to construct AST element values are stored in the Lua
    registry for quicker access. Getting a value from the registry is much
    faster than getting a global value (partly to idiosyncrasies of hslua);
    this change results in a considerable performance boost.

  * Documentation:

    + `doc/org.md` Add draft of Org-mode documentation (Albert Krewinkel).
    + `doc/lua-filters.md`: document global vars set for filters
      (Albert Krewinkel).
    + INSTALL.md: mention Stack version. (#4343, Adam Brandizzi).
    + MANUAL: add documentation on custom styles (Jesse Rosenthal).
    + MANUAL.txt: Document incremental and nonincremental divs (Jesse
      Rosenthal).  Blockquoted lists are still described, but fenced divs are
      presented in preference.
    + MANUAL.txt: document header and footer variables (newmana).
    + MANUAL.txt: self-contained implies standalone (#4304, Daniel Lublin).
    + CONTRIBUTING.md: label was renamed. (#4310, Alexander Brandizzi).

  * Require tagsoup 0.14.3 (#4282), fixing HTML tokenization bug.

  * Use latest texmath.

  * Use latest pandoc-citeproc.

  * Allow exceptions 0.9.

  * Require aeson-pretty 0.8.5 (#4394).

  * Bump blaze-markup, blaze-html lower bounds to 0.8, 0.9 (#4334).

  * Update tagsoup to 0.14.6 (Alexander Krotov, #4282).

  * Removed ghc-prof-options.  As of cabal 1.24, sensible defaults are used.

  * Update default.nix to current nixpkgs-unstable for hslua-0.9.5 (#4348,
    jarlg).

## pandoc 2.1.1 (2018-01-18)

  * Markdown reader:

    + Don't coalesce adjacent raw LaTeX blocks if they are separated by a
      blank line.  See lierdakil/pandoc-crossref#160.
    + Improved `inlinesInBalancedBrackets` (#4272, jgm/pandoc-citeproc#315).
      The change both improves performance and fixes a regression whereby
      normal citations inside inline notes and figure captions were not
      parsed correctly.

  * RST reader:

    + Better handling for headers with an anchor (#4240).  Instead of creating a
      Div containing the header, we put the id directly on the header.
      This way header promotion will work properly.
    + Add aligned environment when needed in math (#4254).  `rst2latex.py`
      uses an `align*` environment for math in `.. math::` blocks, so this
      math may contain line breaks.  If it does, we put the math in an
      `aligned` environment to simulate `rst2latex.py`'s behavior.

  * HTML reader:

    + Fix col width parsing for percentages < 10% (#4262, n3fariox).

  * LaTeX reader:

    + Advance source position at end of stream.
    + Pass through macro defs in `rawLaTeXBlock` even if the `latex_macros`
      extension is set (#4246).  This reverts to earlier behavior and is
      probably safer on the whole, since some macros only modify things in
      included packages, which pandoc's macro expansion can't modify.
    + Fixed pos calculation in tokenizing escaped space.
    + Allow macro definitions inside macros (#4253).  Previously we went into
      an infinite loop with
      ```
      \newcommand{\noop}[1]{#1}
      \noop{\newcommand{\foo}[1]{#1}}
      \foo{hi}
      ```
    + Fix inconsistent column widths (#4238).  This fixes a bug whereby column
      widths for the body were different from widths for the header in some
      tables.

  * Docx reader (Jesse Rosenthal):

    + Parse hyperlinks in `instrText` tags (#3389, #4266).  This was a form of
      hyperlink found in older versions of word. The changes introduced for
      this, though, create a framework for parsing further fields in MS Word
      (see the spec, ECMA-376-1:2016, §17.16.5, for more on these fields).
      We introduce a new module, `Text.Pandoc.Readers.Docx.Fields` which
      contains a simple parsec parser. At the moment, only simple hyperlink
      fields are accepted, but that can be extended in the future.

  * Muse reader (Alexander Krotov):

    + Parse `~~` as non-breaking space in Text::Amuse mode.
    + Refactor list parsing.

  * Powerpoint writer (Jesse Rosenthal):

    + Change reference to `notesSlide` to `endNotesSlide`.
    + Move image sizing into `picProps`.
    + Improve table placement.
    + Make our own `_rels/.rels` file.
    + Import reference-doc images properly.
    + Move `Presentation.hs` out of `PandocMonad`.
    + Refactor into separate modules.  T.P.W.Powerpoint.Presentation
      defines the Presentation datatype and goes Pandoc->Presentation;
      T.P.W.Pandoc.Output goes Presentation->Archive.
      Text.Pandoc.Writers.Powerpoint a thin wrapper around the two modules.
    + Avoid overlapping blocks in column output.
    + Position images correctly in two-column layout.
    + Make content shape retrieval environment-aware.
    + Improve image handling.  We now determine image and caption placement
      by getting the dimensions of the content box in a given layout.
      This allows for images to be correctly sized and positioned in a
      different template.  Note that images without captions and headers are
      no longer full-screened. We can't do this dependably in different
      layouts, because we don't know where the header is (it could be to
      the side of the content, for example).
    + Read presentation size from reference file.  Our presentation size is
      now dependent on the reference/template file we use.
    + Handle (sub)headers above slidelevel correctly.  Above the slidelevel,
      subheaders will be printed in bold and given a bit of extra space
      before them. Note that at the moment, no distinction is made between
      levels of headers above the slide header, though that can be changed.
    + Check for required files.  Since we now import from reference/dist
      file by glob, we need to make sure that we're getting the files we
      need to make a non-corrupt Powerpoint. This performs that check.
    + Improve templating using `--reference-doc`.  Templating should work
      much more reliably now.
    + Include Notes slide in TOC.
    + Set notes slide header to slide-level.
    + Add table of contents.  This is triggered by the `--toc` flag. Note
      that in a long slide deck this risks overrunning the text box. The user
      can address this by setting `--toc-depth=1`.
    + Set notes slide number correctly.
    + Clean up adding metadata slide.  We want to count the slide numbers
      correctly if it's in there.
    + Add anchor links.  For anchor-type links (`[foo](#bar)`) we produce
      an anchor link. In powerpoint these are links to slides, so we keep
      track of a map relating anchors to the slides they occur on.
    + Make the slide number available to the blocks.  For anchors,
      block-processing functions need to know what slide number
      they're in. We make the `envCurSlideId` available to blocks.
    + Move `curSlideId` to environment.
    + Allow setting `toc-title` in metadata.
    + Link notes to endnotes slide.

  * Markdown writer:

    + Fix cell width calculation (#4265).  Previously we could get
      ever-lengthening cell widths when a table was run repeatedly through
      `pandoc -f markdown -t markdown`.

  * LaTeX writer:

    + Escape `&` in lstinline (Robert Schütz).

  * ConTeXt writer:

    + Use xtables instead of Tables (#4223, Henri Menke).
      Default to xtables for context output.  Natural Tables are used
      if the new `ntb` extension is set.

  * HTML writer:

     + Fixed footnote backlinks with `--id-prefix` (#4235).

  * `Text.Pandoc.Extensions`:  Added `Ext_ntb` constructor (API change,
    Henri Menke).

  * `Text.Pandoc.ImageSize`: add derived `Eq` instance to `Dimension`
    (Jesse Rosenthal, API change).

  * Lua filters (Albert Krewinkel):

    + Make `PANDOC_READER_OPTIONS` available.
      The options which were used to read the document are made available to
      Lua filters via the `PANDOC_READER_OPTIONS` global.
    + Add lua module `pandoc.utils.run_json_filter`, which runs a JSON filter
      on a Pandoc document.
    + Refactor filter-handling code into `Text.Pandoc.Filter.JSON`,
      `Text.Pandoc.Filter.Lua`, and `Text.Pandoc.Filter.Path`.
    + Improve error messages.  Provide more context about the task
      which caused an error.

  * data/pandoc.lua (Albert Krewinkel):

    + Accept singleton inline as a list.  Every constructor which accepts a
      list of inlines now also accepts a single inline element for
      convenience.
    + Accept single block as singleton list. Every constructor which accepts
      a list of blocks now also accepts a single block element for
      convenience.  Furthermore, strings are accepted as shorthand for
      `{pandoc.Str "text"}` in constructors.
    + Add attr, listAttributes accessors.  Elements with
      attributes got an additional `attr` accessor. Attributes were
      accessible only via the `identifier`, `classes`, and `attributes`,
      which was in conflict with the documentation, which indirectly states
      that such elements have the an `attr` property.
    + Drop `_VERSION`.  Having a `_VERSION` became superfluous, as this
      module is closely tied to the pandoc version, which is available via
      `PANDOC_VERSION`.
    + Fix access to Attr components.  Accessing an Attr value (e.g.,
      ` Attr().classes`) was broken; the more common case of accessing it via
      an Inline or Block element was unaffected by this.

  * Move `metaValueToInlines` to from Docx writer to
    `Text.Pandoc.Writers.Shared`, so it can be used by other writers
    (Jesse Rosenthal).

  * MANUAL.txt:

    + Clarify otherlangs in LaTeX (#4072).
    + Clarify `latex_macros` extension.
    + Recommend use of `raw_attribute` extension in header includes (#4253).

  * Allow latest QuickCheck, tasty, criterion.

  * Remove custom prelude and ghc 7.8 support.

  * Reduce compiler noise (exact paths for compiled modules).

## pandoc 2.1 (2018-01-07)

  * Allow filters and lua filters to be interspersed (#4196).  Previously
    we ran all lua filters before JSON filters.  Now we run filters in
    the order they are presented on the command line, whether lua or JSON.
    There are two incompatible API changes: The type of `applyFilters`
    has changed, and `applyLuaFilters` has been removed.  `Filter` is
    also now exported.

  * Use latest skylighting and omit the `missingIncludes` check, fixing
    a major performance regression in earlier releases of the 2.x series
    (#4226).  Behavior change: If you use a custom syntax definition that
    refers to a syntax you haven't loaded, pandoc will now complain when
    it is highlighting the text, rather than doing a check at the start.
    This change dramatically speeds up invocations of pandoc on short
    inputs.

  * Text.Pandoc.Class: make `FileTree` opaque (don't export
    `FileTree` constructor).  This forces users to interact with it using
    `insertInFileTree` and `getFileInfo`, which normalize file names.

  * Markdown reader:

    + Rewrite `inlinesInBalancedBrackets`.  The rewrite is much more
      direct, avoiding `parseFromString`.  And it performs significantly
      better; unfortunately, parsing time still increases exponentially
      (see #1735).
    + Avoid parsing raw tex unless `\` + letter seen.  This seems to
      help with the performance problem, #4216.

  * LaTeX reader: Simplified a check for raw tex command.

  * Muse reader (Alexander Krotov):

    + Enable round trip test (#4107).
    + Automatically translate `#cover` into `#cover-image`.
      Amusewiki uses #cover directive to specify cover image.

  * Docx reader (Jesse Rosenthal):

    + Allow for insertion/deletion of paragraphs (#3927).
      If the paragraph has a deleted or inserted paragraph break (depending
      on the track-changes setting) we hold onto it until the next
      paragraph. This takes care of accept and reject. For this we introduce
      a new state which holds the ils from the previous para if necessary.
      For `--track-changes=all`, we add an empty span with class
      `paragraph-insertion`/`paragraph-deletion` at the end of the paragraph
      prior to the break to be inserted or deleted.
    + Remove unused anchors (#3679).  Docx produces a lot of anchors with
      nothing pointing to them---we now remove these to produce cleaner
      output. Note that this has to occur at the end of the process
      because it has to follow link/anchor rewriting.
    + Read multiple children of `w:sdtContents`.
    + Combine adjacent anchors.  There isn't any reason to have numerous
      anchors in the same place, since we can't maintain docx's
      non-nesting overlapping. So we reduce to a single anchor.
    + Improved tests.

  * Muse writer (Alexander Krotov): don't escape URIs from AST

  * Docx writer:

    + Removed redundant subtitle in title (Sebastian Talmon).
    + `firstRow` table definition compatibility for Word 2016 (Sebastian
      Talmon).  Word 2016 seems to use a default value of "1" for table
      headers, if there is no firstRow definition (although a default
      value of 0 is documented), so all tables get the first Row formatted
      as header.  Setting the parameter to 0 if the table has no header
      row fixes this for Word 2016
    + Fix custom styles with spaces in the name (#3290).

  * Powerpoint writer (Jesse Rosenthal):

    + Ignore Notes div for parity with other slide outputs.
    + Set default slidelevel correctly.  We had previously defaulted to
      slideLevel 2. Now we use the correct behavior of defaulting to the
      highest level header followed by content. We change an expected test
      result to match this behavior.
    + Split blocks correctly for linked images.
    + Combine adjacent runs.
    + Make inline code inherit code size.  Previously (a) the code size
      wasn't set when we force size, and (b) the properties was set from
      the default, instead of inheriting.
    + Simplify `replaceNamedChildren` function.
    + Allow linked images.  The following markdown:
      `[![Image Title](image.jpg)](http://www.example.com)`
      will now produce a linked image in the resulting PowerPoint file.
    + Fix error with empty table cell.  We require an empty `<a:p>` tag,
      even if the cell contains no paragraphs---otherwise PowerPoint
      complains of corruption.
    + Implement two-column slides.  This uses the columns/column div
      format described in the pandoc manual. At the moment, only two
      columns (half the screen each) are allowed. Custom widths are not
      supported.
    + Added more tests.

  * OpenDocument/ODT writers: improved rendering of formulas (#4170, oltolm).

  * Lua filters (Albert Krewinkel):

    + `data/pandoc.lua`: drop 'pandoc-api-version' from Pandoc objects
    + The current pandoc-types version is made available to Lua programs in
      the global `PANDOC_API_VERSION`. It contains the version as a list of
      numbers.
    + The pandoc version available as a global `PANDOC_VERSION` (a list
      of numbers).
    + `data/pandoc.lua`: make `Attr` an `AstElement`.
    + `data/pandoc.lua`: make all types subtypes of `AstElement`.
      `Pandoc`, `Meta`, and `Citation` were just plain functions and did
      not set a metatable on the returned value, which made it difficult
      to amend objects of these types with new behavior. They are now
      subtypes of AstElement, meaning that all their objects can gain
      new features when a method is added to the behavior object
      (e.g., `pandoc.Pandoc.behavior`).
    + `data/pandoc.lua`: split type and behavior tables.  Clearly distinguish
      between a type and the behavioral properties of an instance of that
      type. The behavior of a type (and all its subtypes) can now be
      amended by adding methods to that types `behavior` object, without
      exposing the type objects internals.  E.g.:
      ```lua
      pandoc.Inline.behavior.frob = function () print'42' end
      local str = pandoc.Str'hello'
      str.frob() -- outputs '42'
      ```
    + `data/pandoc.lua`: fix Element inheritance.  Extending all elements
      of a given type (e.g., all inline elements) was difficult, as the
      table used to lookup unknown methods would be reset every time a
      new element of that type was created, preventing recursive property
      lookup. This is was changed in that all methods and attributes of
      supertypes are now available to their subtypes.
    + `data/pandoc.lua`: fix attribute names of Citation (#4222).  The
      fields were named like the Haskell fields, not like the documented,
      shorter version.  The names are changed to match the documentation
      and Citations are given a shared metatable to enable simple
      extensibility.
    + `data/pandoc.lua`: drop function `pandoc.global_filter`.
    + Bump `hslua` version to 0.9.5.  This version fixes a bug that made it
      difficult to handle failures while getting lists or a Map from Lua.
      A bug in pandoc, which made it necessary to always pass a tag when
      using MetaList or MetaBlock, is fixed as a result. Using the pandoc
      module's constructor functions for these values is now optional
      (if still recommended).
    + Stop exporting `pushPandocModule` (API change).  The introduction
      of `runPandocLua` renders direct use of this function obsolete.
    + Update generation of module docs for lua filters.
    + `Lua.Module.Utils`: make stringify work on `MetaValues` (John
      MacFarlane).  I'm sure this was intended in the first place,
      but currently only `Meta` is supported.

  * Improve benchmarks.

    + Set the default extensions properly.
    + Improve benchmark argument parsing.  You can now say
      `make bench BENCHARGS="markdown latex reader"` and both the
      markdown and latex readers will be benchmarked.

  * MANUAL.txt simplify and add more structure (Mauro Bieg).

  * Generate README.md from template and MANUAL.txt.
    `make README.md` will generate the README.md after changes
    to MANUAL.txt have been made.

  * Update copyright notices to include 2018 (Albert Krewinkel).

## pandoc 2.0.6 (2017-12-28)

  * Added `jats` as an input format.

    + Add Text.Pandoc.Readers.JATS, exporting `readJATS` (API
      change) (Hamish Mackenzie).
    + Improved citation handling in JATS reader.  JATS citations
      are now converted to pandoc citations, and JATS ref-lists
      are converted into a `references` field in metadata, suitable
      for use with pandoc-citeproc. Thus a JATS article with embedded
      bibliographic information can be processed with pandoc and
      pandoc-citeproc to produce a formatted bibliography.

  * Allow `--list-extensions` to take an optional FORMAT argument.
    This lists the extensions set by default for the selected FORMAT.
    The extensions are now alphabetized, and the `+` or `-`
    indicating the default setting comes before, rather than after,
    the extension.

  * Markdown reader:

    + Preserve original whitespace between blocks.
    + Recognize `\placeformula` as context.
    + Be pickier about table captions.  A caption starts with a `:` which
      can't be followed by punctuation.  Otherwise we can falsely interpret
      the start of a fenced div, or even a table header line like
      `:--:|:--:`, as a caption.
    + Always use four space rule for example lists.  It would be awkward
      to indent example list contents to the first non-space character after
      the label, since example list labels are often long.  Thanks to
      Bernhard Fisseni for the suggestion.
    + Improve raw tex parsing.  Note that the Markdown reader is also
      affected by the `latex_macros` extension changes described below
      under the LaTeX reader.

  * LaTeX reader:

    + `latex_macros` extension changes (#4179).  Don't pass through macro
      definitions themselves when `latex_macros` is set.  The macros
      have already been applied.  If `latex_macros` is enabled, then
      `rawLaTeXBlock` in Text.Pandoc.Readers.LaTeX will succeed in parsing
      a macro definition, and will update pandoc's internal macro map
      accordingly, but the empty string will be returned.
    + Export `tokenize`, `untokenize` (API change).
    + Use `applyMacros` in `rawLaTeXBlock`, `rawLaTeXInline`.
    + Refactored `inlineCommand`.
    + Fix bug in tokenizer.  Material following `^^` was
      dropped if it wasn't a character escape.  This only affected
      invalid LaTeX, so we didn't see it in the wild, but it appeared
      in a QuickCheck test failure.
    + Fix regression in LateX tokenization (#4159).  This mainly affects the
      Markdown reader when parsing raw LaTeX with escaped spaces.
    + Add tests of LaTeX tokenizer.
    + Support `\foreignlanguage` from babel.
    + Be more tolerant of `&` character (#4208).  This allows us to parse
      unknown tabular environments as raw LaTeX.

  * Muse reader (Alexander Krotov):

    + Parse anchors immediately after headings as IDs.
    + Require that note references does not start with 0.
    + Parse empty comments correctly.

  * Org reader (Albert Krewinkel):

    + Fix asterisks-related parsing error (#4180).
    + Support minlevel option for includes (#4154).  The level of headers
      in included files can be shifted to a higher level by specifying a
      minimum header level via the `:minlevel` parameter. E.g.
      `#+include: "tour.org" :minlevel 1` will shift the headers in
      tour.org such that the topmost headers become level 1 headers.
    + Break-up org reader test file into multiple modules.

  * OPML reader:

    + Enable raw HTML and other extensions by default for notes
      (#4164).  This fixes a regression in 2.0.  Note that extensions can
      now be individually disabled, e.g.  `-f opml-smart-raw_html`.

  * RST reader:

    + Allow empty list items (#4193).
    + More accurate parsing of references (#4156).  Previously we erroneously
      included the enclosing backticks in a reference ID (#4156).  This
      change also disables interpretation of syntax inside references, as
      in docutils.  So, there is no emphasis in `` `my *link*`_ ``.

  * Docx reader:

    + Continue lists after interruption (#4025, Jesse Rosenthal).
      Docx expects that lists will continue where they left off after an
      interruption and introduces a new id if a list is starting again. So
      we keep track of the state of lists and use them to define a "start"
      attribute, if necessary.
    + Add tests for structured document tags unwrapping (Jesse Rosenthal).
    + Preprocess Document body to unwrap `w:sdt` elements (Jesse Rosenthal,
      #4190).

  * Plain writer:

    + Don't linkify table of contents.

  * RST writer:

    + Fix anchors for headers (#4188).  We were missing an `_`.

  * PowerPoint writer (Jesse Rosenthal):

    + Treat lists inside BlockQuotes as lists.  We don't yet produce
      incremental lists in PowerPoint, but we should at least treat lists
      inside BlockQuotes as lists, for compatibility with other slide formats.
    + Add ability to force size.  This replaces the more specific
      `blockQuote runProp`, which only affected the size of blockquotes. We
      can use this for notes, etc.
    + Implement notes.  This currently prints all notes on a final slide.
      Note that at the moment, there is a danger of text overflowing the
      note slide, since there is no logic for adding further slides.
    + Implement basic definition list functionality to PowerPoint writer.
    + Don't look for default template file for Powerpoint (#4181).
    + Add pptx to isTextFormat list.  This is used to check standalone
      and not writing to the terminal.
    + Obey slide level option (Jesse Rosenthal).
    + Introduce tests.

  * Docx writer:

    + Ensure that `distArchive` is the one that comes with pandoc
      (#4182).  Previously a `reference.docx` in `~/.pandoc` (or the user data
      dir) would be used instead, and this could cause problems because a
      user-modified docx sometimes lacks vital sections that we count
      on the `distArchive` to supply.

  * Org writer:

    + Do not wrap "-" to avoid accidental bullet lists (Alexander Krotov).
    + Don't allow fn refs to wrap to beginning of line (#4171, with help from
      Alexander Krotov).  Otherwise they can be interpreted as footnote
      definitions.

  * Muse writer (Alexander Krotov):

    + Don't wrap note references to the next line (#4172).

  * HTML writer:

    + Use br elements in line blocks instead of relying on CSS
      (#4162).  HTML-based templates have had the custom CSS for
      `div.line-block` removed.  Those maintaining custom templates will want
      to remove this too.  We still enclose line blocks in a div with class
      `line-block`.

  * LaTeX writer:

    + Use `\renewcommand` for `\textlatin` with babel (#4161).
      This avoids a clash with a deprecated `\textlatin` command defined
      in Babel.
    + Allow fragile=singleslide attribute in beamer slides (#4169).
    + Use `\endhead` after `\toprule` in headerless tables (#4207).

  * FB2 writer:

    + Add cover image specified by `cover-image` meta (Alexander Krotov,
      #4195).

  * JATS writer (Hamish Mackenzie):

    + Support writing `<fig>` and `<table-wrap>` elements
      with `<title>` and `<caption>` inside them by using Divs with class set
      to one of `fig`, `table-wrap` or `caption` (Hamish Mackenzie).  The
      title is included as a Heading so the constraint on where Heading can
      occur is also relaxed.
    + Leave out empty alt attributes on links.
    + Deduplicate image mime type code.
    + Make `<p>` optional in `<td>` and `<th>` (#4178).
    + Self closing tags for empty xref (#4187).
    + Improve support for code language.

  * Custom writer:

    + Use init file to setup Lua interpreter (Albert Krewinkel).
      The same init file (`data/init`) that is used to setup the Lua
      interpreter for Lua filters is also used to setup the interpreter of
      custom writers.lua.
    + Define instances for newtype wrapper (Albert Krewinkel).  The custom
      writer used its own `ToLuaStack` instance definitions, which made
      it difficult to share code with Lua filters, as this could result
      in conflicting instances.  A `Stringify` wrapper is introduced to
      avoid this problem.
    + Added tests for custom writer.
    + Fixed definition lists and tables in `data/sample.lua`.

  * Fixed regression: when target is PDF, writer extensions were being
    ignored.  So, for example, `pandoc -t latex-smart -o file.pdf`
    did not work properly.

  * Lua modules (Albert Krewinkel):

    + Add `pandoc.utils` module, to hold utility functions.
    + Create a Haskell module Text.Pandoc.Lua.Module.Pandoc to
      define the `pandoc` lua module.
    + Make a Haskell module for each Lua module. Move definitions for the
      `pandoc.mediabag` modules to a separate Haskell module.
    + Move `sha1` from the main `pandoc` module to `pandoc.utils`.
    + Add function `pandoc.utils.hierarchicalize` (convert list of
      Pandoc blocks into (hierarchical) list of Elements).
    + Add function `pandoc.utils.normalize_date` (parses a date and
      converts it (if possible) to "YYYY-MM-DD" format).
    + Add function `pandoc.utils.to_roman_numeral` (allows conversion
      of numbers below 4000 into roman numerals).
    + Add function `pandoc.utils.stringify` (converts any AST element
      to a string with formatting removed).
    + `data/init.lua`: load `pandoc.utils` by default
    + Turn pipe, read into full Haskell functions.  The `pipe` and `read`
      utility functions are converted from hybrid lua/haskell functions
      into full Haskell functions. This avoids the need for intermediate
      `_pipe`/`_read` helper functions, which have dropped.
    + pandoc.lua: re-add missing MetaMap function.  This was a bug
      introduced in version 2.0.4.

  * Text.Pandoc.Class: Add `insertInFileTree` [API change].  This gives
    a pure way to insert an ersatz file into a `FileTree`.  In addition, we
    normalize paths both on insertion and on lookup.

  * Text.Pandoc.Shared: export `blocksToInlines'` (API change, Maura Bieg).

  * Text.Pandoc.MIME: Add opus to MIME type table as audio/ogg (#4198).

  * Text.Pandoc.Extensions:   Alphabetical order constructors for
    `Extension`.  This makes them appear in order in `--list-extensions`.

  * Allow lenient decoding of latex error logs, which are not always
    properly UTF8-encoded (#4200).

  * Update latex template to work with recent versions of beamer.
    The old template produced numbered sections with some recent
    versions of beamer.  Thanks to Thomas Hodgson.

  * Updated reference.docx (#4175).  Instead of just "Hello, world", the
    document now contains exemplars of most of the styles that have an
    effect on pandoc documents.  This makes it easier to see the effect
    of style changes.

  * Removed `default.theme` data file (#4096).  It is no longer needed now
    that we have `--print-highlight-style`.

  * Added `stack.lts9.yaml` for building with lts 9 and ghc 8.0.2.
    We still need this for the alpine static linux build, since
    we don't have ghc 8.2.2 for that yet.

  * Removed `stack.pkg.yaml`.  We only really need `stack.yaml`; we
    can put flag settings for pandoc-citeproc there.

  * Makefile: Add 'trypandoc' and 'pandoc-templates' targets to
    make releases easier.

  * MANUAL.txt:

    + Add note on what formats have `+smart` by default.
    + Use native syntax for custom-style (#4174, Mauro Bieg).
    + Introduce dedicated Extensions section, since some extensions
      affect formats other than markdown (Mauro Bieg, #4204).
    + Clarify default html output for `--section-divs` (Richard Edwards).

  * filters.md: say that Text.Pandoc.JSON comes form pandoc-types.
    Closes jgm/pandoc-website#16.

  * epub.md: Delete removed `-S` option from command (#4151, Georger Araújo).

## pandoc 2.0.5 (2017-12-12)

  * Fix a bug in 2.0.4, whereby pandoc could not read the theme files
    generated with `--print-highlight-style` (#4133).  Improve JSON
    serialization of styles.

  * Fix CSS issues involving line numbers (#4128).
    Highlighted code blocks are now enclosed in a div with class `sourceCode`.
    Highlighting CSS no longer sets a generic color for pre and code; we only
    set these for class `sourceCode`.

  * `--pdf-engine-opt`: fix bug where option order was reversed (#4137).

  * Add PowerPoint (pptx) writer (Jesse Rosenthal).
    It works following the standard Pandoc conventions for making other
    sorts of slides. Caveats:

    + Syntax highlighting is not yet implemented. (This is difficult
      because there are no character classes in Powerpoint.)
    + Footnotes and Definition lists are not yet implemented. (Notes will
      usually take the form of a final slide.
    + Image placement and auto-resizing has a few glitches.
    + Reference powerpoint files don't work dependably from the command
      line. This will be implemented, but at the moment users are advised
      to change themes from within Powerpoint.

  * Create shared Text.Pandoc.Writers.OOXML module (Jesse Rosenthal).
    This is for functions used by both Powerpoint and Docx writers.

  * Add default pptx data for Powerpoint writer (Jesse Rosenthal).

  * Add `empty_paragraphs` extension.

    + Deprecate `--strip-empty-paragraphs` option.  Instead we now
      use an `empty_paragraphs` extension that can be enabled on
      the reader or writer.  By default, disabled.
    + Add `Ext_empty_paragraphs` constructor to `Extension`.
    + Revert "Docx reader: don't strip out empty paragraphs."
      This reverts commit d6c58eb836f033a48955796de4d9ffb3b30e297b.
    + Implement `empty_paragraphs` extension in docx reader and writer,
      opendocument writer, html reader and writer.
    + Add tests for `empty_paragraphs` extension.

  * Markdown reader:

    + Don't parse native div as table caption (#4119).
    + Improved computation of column widths in pipe tables.
      Pipe tables with lines longer than the text width (as set
      by `--columns`) are now scaled to text width, with the relative
      widths of columns determined by the ratios between the
      header lines.  Previously we computed column widths using
      the ratio of header line lengths to column width, so that
      tables with narrow header lines were extremely thin, which
      was very rarely the desired result.

  * LaTeX reader: fix `\` before newline (#4134).  This should be a space,
    as long as it's not followed by a blank line. This has been fixed at the
    tokenizer level.

  * Muse reader (Alexander Krotov):

    + Add test for `#disable-tables` directive in Emacs mode.
    + Don't allow emphasis to be preceded by letter.
    + Add underline support in Emacs Muse mode..
    + Support multiline directives in Amusewiki mode

  * Man writer: omit internal links (#4136).  That is, just print the link
    text without the URL.

  * Markdown reader: accept processing instructions as raw HTML (#4125).

  * Lua filters (Albert Krewinkel):

    + Use script to initialize the interpreter.  The file `init.lua` is
      used to initialize the Lua interpreter which is used in Lua filters.
      This gives users the option to require libraries which they want to
      use in all of their filters, and to extend default modules.
    + Fix package loading for Lua 5.1.  The list of package searchers is
      named `package.loaders` in Lua 5.1 and LuaJIT, and `package.searchers`
      in Lua 5.2 and later.
    + Refactor lua module handling.  The integration with Lua's package/module
      system is improved: A pandoc-specific package searcher is prepended to
      the searchers in `package.searchers`. The modules `pandoc` and
      `pandoc.mediabag` can now be loaded via `require`.
    + Bump lower bound of hslua.  The release hslua 0.9.3 contains a new
      function which makes using Haskell functions as package loaders much
      easier.

  * reveal.js template:  add title-slide identifier to title slide (#4120).
    This allows it to be styled more easily.

  * LaTeX template: Added support for `pagestyle` variable (#4135,
    Thomas Hodgson)

  * Add `-threaded` to ghc-options for executable (#4130, fixes a build
    error on linux).


## pandoc 2.0.4 (2017-12-03)

  * Add `--print-highlight-style` option.  This generates a JSON version
    of a highlighting style, which can be saved as a `.theme` file, modified,
    and used with `--highlight-style` (#4106, #4096).

  * Add `--strip-empty-paragraphs` option.  This works for any input format.
    It is primarily intended for use with docx and odt documents where
    empty paragraphs have been used for inter-paragraph spaces.

  * Support `--webtex` for `gfm` output.

  * Recognize `.muse` file extension.

  * Support beamer `\alert` in LaTeX reader. Closes #4091.

  * Docx reader: don't strip out empty paragraphs (#2252).
    Users who have a conversion pipeline from docx may want to consider adding
    `--strip-empty-paragraphs` to the command line.

  * Org reader (Albert Krewinkel): Allow empty list items (#4090).

  * Muse reader (Alexander Krotov):

    + Parse markup in definition list terms.
    + Allow definition to end with EOF.
    + Make code blocks round trip.
    + Drop common space prefix from list items.
    + Add partial round trip test.
    + Don't interpret XML entities.
    + Remove `nested`.
    + Parse `~~` as non-breaking space in Emacs mode.
    + Correctly remove indentation from notes.  Exactly one space is
      required and considered to be part of the marker.
    + Allow list items to be empty.
    + Add ordered list test.
    + Add more multiline definition tests.
    + Don't allow blockquotes within lists.
    + Fix reading of multiline definitions.
    + Add inline `<literal>` support.
    + Concatenate inlines of the same type

  * Docx writer: allow empty paragraphs (#2252).

  * CommonMark/gfm writer:

    + Use raw html for native divs/spans (#4113).  This allows a pandoc
      markdown native div or span to be rendered in gfm using raw html tags.
    + Implement `raw_html` and `raw_tex` extensions.  Note that `raw_html`
      is enabled by default for `gfm`, while `raw_tex` is disabled by default.

  * Muse writer (Alexander Krotov):

    + Test that inline math conversion result is normalized.
      Without normalization this test produced
      `<em>a</em><em>b</em><em>c</em>`.
    + Improve inline list normalization and move to writer.
    + Escape hash symbol.
    + Escape `----` to avoid accidental horizontal rules.
    + Escape only `</code>` inside code tag.
    + Additional `<verbatim>` is not needed as `<code>` is verbatim already.

  * LaTeX writer:

    + Allow specifying just width or height for image size.
      Previously both needed to be specified (unless the image was
      being resized to be smaller than its original size).
      If height but not width is specified, we now set width to
      textwidth. If width but not height is specified, we now set
      height to textheight.  Since we have `keepaspectratio`, this
      yields the desired result.
    + Escape `~` and `_` in code with `--listings` (#4111).

  * HTML writer: export `tagWithAttributes`.  This is a helper allowing
    other writers to create single HTML tags.

  * Let papersizes `a0`, `a1`, `a2`, ... be case-insensitive by
    converting the case as needed in LaTeX and ConTeXt writers.

  * Change `fixDisplayMath` from `Text.Pandoc.Writers.Shared`
    so that it no longer produces empty `Para`'s as an artifact.

  * `Text.Pandoc.Shared.blocksToInlines`:  rewrote using builder.
    This gives us automatic normalization, so we don't get
    for example two consecutive Spaces.

  * Include default CSS for 'underline' class in HTML-based templates.

  * revealjs template:  add `tex2jax` configuration for the
    math plugin.  With the next release of reveal.js, this will
    fix the problem of `$`s outside of math contexts being
    interpreted as math delimiters (#4027).

  * `pandoc.lua` module for use in lua filters (Albert Krewinkel):

    + Add basic lua List module (#4099, #4081).  The List module is
      automatically loaded, but not assigned to a global variable. It can be
      included in filters by calling `List = require 'List'`.  Lists of blocks,
      lists of inlines, and lists of classes are now given `List` as a metatable,
      making working with them more convenient.  E.g., it is now possible to
      concatenate lists of inlines using Lua's concatenation operator `..`
      (requires at least one of the operants to have `List` as a metatable):

          function Emph (emph)
            local s = {pandoc.Space(), pandoc.Str 'emphasized'}
            return pandoc.Span(emph.content .. s)
          end

      The `List` metatable is assigned to the tables which get passed to
      the constructors `MetaBlocks`, `MetaInline`, and `MetaList`. This
      enables the use of the resulting objects as lists.
    + `Lua/StackInstances`: push Pandoc and Meta via constructor.
      Pandoc and Meta elements are now pushed by calling the respective
      constructor functions of the pandoc Lua module. This makes serialization
      consistent with the way blocks and inlines are pushed to lua and allows
      to use List methods with the `blocks` value.
    + Add documentation for pandoc.List in `lua-filters.md`.

  * Use latest tagsoup.  This fixes a bug in parsing HTML tags with
    `&` (but not a valid entity) following them (#4094, #4088).

  * Use skylighting 0.4.4.1, fixing the color of unmarked code text
    when `numberLines` is used (#4103).

  * Make `normalizeDate` more forgiving (Mauro Bieg, #4101), not
    requiring a leading 0 on single-digit days.

  * Fix `--help` output for `--highlight-style` to include `FILE` (Mauro
    Bieg, #4095).

  * Clearer deprecation warning for `--latexmathml, --asciimathml, -m`.
    Previously we only mentioned `--latexmathml`, even if `-m` was
    used.

  * Changelog: fix description of lua filters in 2.0 release
    (Albert Krewinkel).  Lua filters were initially run *after* conventional
    (JSON) filters.  However, this was changed later to make it easier to deal
    with files in the mediabag. The changelog is updated to describe that
    feature of the 2.0 release correctly.

  * Change Generic JSON instances to TemplateHaskell (Jasper Van der Jeugt,
    #4085).  This reduces compile time and memory usage significantly.

  * `lua-filters.md`: Added tikz filter example.

  * Create alternative zip file for macOS binaries.

  * Create alternative zip file for Windows binaries.

  * Update INSTALL.md since we now provide zips for binaries.

  * Relax `http-types` dependency (Justus Sagemüller, #4084).

  * Add `epub.md`, `getting-started.md` to docs.  These used to live in
    the website repo.

  * Add `packages` target to Makefile.

  * Bump bounds for binary, http-types, tasty-hunit

## pandoc 2.0.3 (2017-11-20)

  * Lua filters: preload text module (Albert Krewinkel, #4077).
    The `text` module is preloaded in lua. The module contains some UTF-8
    aware string functions, implemented in Haskell.  The module is loaded on
    request only, e.g.:

        text = require 'text'
        function Str (s)
          s.text = text.upper(s.text)
          return s
        end

  * Allow table-like access to attributes in lua filters (Albert Krewinkel,
    #4071).  Attribute lists are represented as associative lists in Lua. Pure
    associative lists are awkward to work with. A metatable is attached to
    attribute lists, allowing to access and use the associative list as if
    the attributes were stored in as normal key-value pair in table.
    Note that this changes the way `pairs` works on attribute lists. Instead
    of producing integer keys and two-element tables, the resulting iterator
    function now returns the key and value of those pairs.  Use `ipairs` to
    get the old behavior.  Warning: the new iteration mechanism only works if
    pandoc has been compiled with Lua 5.2 or later (current default: 5.3).

  * Text.Pandoc.Parsing.uri:  allow `&` and `=` as word characters (#4068).
    This fixes a bug where pandoc would stop parsing a URI with an
    empty attribute:  for example, `&a=&b=` wolud stop at `a`.
    (The uri parser tries to guess which punctuation characters
    are part of the URI and which might be punctuation after it.)

  * Introduce `HasSyntaxExtensions` typeclass (Alexander Krotov, #4074).

    + Added new `HasSyntaxExtensions` typeclass for `ReaderOptions` and
      `WriterOptions`.
    + Reimplemented `isEnabled` function from `Options.hs` to accept both
      `ReaderOptions` and `WriterOptions`.
    + Replaced `enabled` from `CommonMark.hs` with new `isEnabled`.

  * Add `amuse` extension (Alexander Krotov) to enable Amuse wiki
    behavior for `muse`.  New `Ext_amuse` constructor for
    `Extension`. Note: this is switched on by default; for
    Emacs behavior, use `muse-amuse`.

  * Muse reader (Alexander Krotov):

    + Count only one space as part of list item marker.
    + Produce SoftBreaks on newlines. Now wrapping can be preserved
      with `--wrap=preserve`.
    + Add Text::Amuse footnote extensions.  Footnote end is indicated by
      indentation, so footnotes can be placed anywhere in the text,
      not just at the end of it.
    + Accept Emacs Muse definition lists when `-amuse`.
      Emacs Muse does not require indentation.

  * HTML reader:

    + Ensure we don't produce level 0 headers (#4076), even for chapter
      sections in epubs.  This causes problems because writers aren't set
      up to expect these.
    + Allow spaces after `\(` and before `\)` with `tex_math_single_backslash`.
      Previously `\( \frac{1}{a} < \frac{1}{b} \)` was not parsed as math in
      `markdown` or `html` `+tex_math_single_backslash`.

  * MANUAL: clarify that math extensions work with HTML.
    Clarify that `tex_math_dollars` and `tex_math_single_backslash`
    will work with HTML as well as Markdown.

  * Creole reader: Fix performance issue for longer lists (Sascha Wilde,
    #4067).

  * RST reader: better support for 'container' directive (#4066).
    Create a div, incorporate name attribute and classes.

  * LaTeX reader:

    + Support column specs like `*{2}{r}` (#4056).  This is equivalent to
      `rr`.  We now expand it like a macro.
    + Allow optional args for parbox (#4056).
    + Allow optional arguments on `\footnote` (#4062).

  * EPUB writer: Fixed path for cover image (#4069).  It was previously
    `media/media/imagename`, and should have been `media/imagename`.

  * Markdown writer: fix bug with doubled footnotes in grid tables
    (#4061).

  * LaTeX template:  include natbib/biblatex after polyglossia (#4073).
    Otherwise we seem to get an error; biblatex wants polyglossia
    language to be defined.

  * Added examples to lua filters documentation.


## pandoc 2.0.2 (2017-11-12)

  * Deprecated ancient HTML math methods: `--latexmathml`, `--gladtex`,
    `--mimetex`, `--jsmath`.

  * Fixed URIs in `data/jats.csl`.  They were being rendered twice,
    leading to invalid XML in default JATS output with pandoc-citeproc.

  * `lua-filters.md`: use real-world man page filter as example.

  * Add lua filter functions `walk_inline` and `walk_block`
    in the pandoc module, to apply filters inside particular
    inline and block elements.

  * Refactored some code from `Text.Pandoc.Lua.PandocModule`
    into new internal module `Text.Pandoc.Lua.Filter`.

  * Markdown reader:

    + Allow fenced code blocks to be indented 1-3 spaces (#4011).
      This brings our handling of them into alignment with CommonMark's.
    + Fix YAML metadata with "chomp" (`|-`).  Previously if a
      YAML block under `|-` contained a blank line, pandoc would
      not parse it as metadata.

  * Removed `etc.` from abbreviations file.  Often `etc.` ends a
    sentence, and we want the period to be treated as a
    sentence-ending period.

  * Fix regression with `--metadata` (#4054).  Values specified with
    `--metadata` should replace a metadata value set in the document
    itself, rather than creating a list including a new value.

  * EPUB writer:

    + Fix EPUB OCF structure.  #3720 had been improperly implemented.
    + Fix modified paths for raw HTML tags (src, poster, etc.)
      (#4050, #4055). This had not been updated for the new EPUB
      container layout, with a separate text/ subdirectory.
    + Fix image paths with empty `--epub-subdirectory`.

  * Miscellaneous code cleanup (Alexander Krotov).

  * Use pandoc-types 1.17.3, which adds `Walkable` instances
    for `[Block] Block` and `[Inline] Inline`.

  * Remove obsolete `stack.full.yaml` (#4052).

  * Change to using pandoc-citeproc 0.12.1 in binary packages.

  * Consolidate math output method documentation (#4049, Mauro Bieg).

  * `MANUAL.txt`: fix header level of "Extension: emoji" (Albert Krewinkel).

  * Use lua filter to generate man page from `MANUAL.txt`, replacing old
    Haskell filters.  This is easier and faster.

  * Improved `INSTALL.md`.

  * Update commands to extract deb archive on Linux (#4043, Salim B).


## pandoc 2.0.1.1 (2017-11-04)

  * Improved fix to #3989 (parsing of HTML tags containing
    `>` in an attribute or comment). The previous fix (in 2.0.1) only
    worked in certain cases.

  * FB2 writer (Alexander Krotov):

    + Add `unrecognised` genre to `<title-info>`
      (Alexander Krotov).  XML schema requires at least one genre.
    + Remove `<annotation>` from `<body>`.

  * CommonMark writer: fix strikethrough for `gfm` (#4038).

  * Use texmath 0.10, which adds support for a wider range of
    symbols and fixes default column alignments in MathML
    and OMML.

  * Highlighting fixes, using skylighting 0.4.3.2:

    + Fix invalid CSS.
    + Support `lineAnchors` (or `line-anchors`) in HTML code blocks.
    + Ensure that code lines don't get duplicate identifiers (#4031).
      The line identifiers are built using the code block's identifier
      as a prefix. If the code block has null identifier, we use
      `cb1`, `cb2`, etc.

  * Added a few abbreviations to `data/abbreviations`,
    and sorted the list (#3984, Wandmalfarbe).

  * Improved support for columns in HTML writer (#4028).

    + Remove `width` attribute from the `div`.
    + Remove space between `<div class="column">` elements,
      since this prevents columns whose widths sum to 100%
      (the space takes up space).
    + Move as much as possible of the CSS to the template.
    + Ensure that all the HTML-based templates (including epub)
      contain the CSS for columns.
    + Columns default to 50% width unless they are given a width
      attribute.  So if you want two equal-width columns, you
      can use a div with class `column` and no `width` attribute.

  * SelfContained: use `base64` for css links with media attribute (#4026).
    This fixes `--self-contained` with S5.

  * Improve `pandoc-template-mode.el` (Vaclav Haisman).

  * INSTALL.md: MacOS instructions needed xar -f (adam234).

  * MANUAL.txt:

    + Clarify that --setext-headers doesn't affect gfm output (#4035).
    + Clarify what is needed to open and close a div in `fenced_divs`
      (#4039, Tristano Ajmone).
    + Removed reference to `default.beamer` in docs (#4024).
      Also added mention of other templates affecting PDF output
      with different settings.


## pandoc 2.0.1 (2017-10-31)

  * Fixed regression in parsing of HTML comments in markdown and other
    non-HTML formats (`Text.Pandoc.Readers.HTML.htmlTag`) (#4019).
    The parser stopped at the first `>` character, even if it wasn't
    the end of the comment.

  * Creole reader (Sascha Wilde):

    + Fix some minor typos and formatting.
    + Add additional test on nowiki-block after para.
    + Fix lists with trailing white space.

  * LaTeX reader: handle `%` comment right after command.
    For example, `\emph%`.

  * Markdown reader:  make sure fenced div closers work in lists.
    Previously the following failed:

        ::: {.class}
        1. one
        2. two
        :::

    and you needed a blank line before the closing `:::`.

  * Make `fenced_divs` affect the Markdown writer.  If `fenced_divs` is
    enabled, Divs will be rendered as fenced divs.

  * LaTeX/Beamer writer: support "blocks" inside columns and other Divs
    (#4016).

  * HTML Writer: consistently use dashed class-names (Mauro Bieg, #3556).
    Note: this change may require some changes in CSS rules.
    `footnoteRef` has become `footnote-ref`, `titleslide` has
    become `title-slide`, and `footnoteBack` has become `footnote-back`.

  * JATS writer: Properly pass through author metadata (#4020).

  * FB2 writer (Alexander Krotov):

    + Write blocks outside of `<p>` in definitions.
    + Make bullet lists consistent with ordered lists, repeating
      the marker for the outer list rather than indenting sublists,
      since indentation does not work in readers.
    + Add new style FB2 tests.

  * `Text.Pandoc.ImageSize`: Add `Millimeter` constructor to `Dimension`
    (#4012) [API change]. Now sizes given in 'mm' are no longer converted
    to 'cm'.

  * Revise documentation of small caps syntax (Andrew Dunning, #4013).

  * Fix broken reference links in manual (Andrew Dunning, #4014)

  * Fixed example of slide columns structure in changelog (#4015).
    Also documented this feature in MANUAL.txt.


## pandoc 2.0.0.1 (2017-10-30)

  * EPUB writer:

    + Fixed filepaths for nonstandard epub-subdirectory values.
    + Ensure that epub2 is recognized as a non-text format,
      so that a template is used.
    + Don't include "prefix" attribute for ibooks for epub2.
      It doesn't validate.
    + Fix stylesheet paths; previously we had an incorrect
      stylesheet path for the cover page and nav page.

  * LaTeX reader:

    + Insert space when needed in macro expansion (#4007).
      Sometimes we need to insert a space after a control sequence
      to prevent it merging with a following letter.
    + Allow unbraced arguments for macros (#4007).
    + Allow body of macro definition to be unbraced (#4007).

  * Linux package build: ensure that pandoc-citeproc is statically linked.

  * trypandoc: add native, ms.


## pandoc 2.0 (2017-10-29)

### New features

  * New output format `ms` (groff ms). Complete support, including
    tables, math, syntax highlighting, and PDF bookmarks. The writer uses
    texmath's new eqn writer to convert math to eqn format, so a ms file
    produced with this writer should be processed with `groff -ms -e` if
    it contains math.

  * New output format `jats` (Journal Article Tag Suite).  This is an XML
    format used in archiving and publishing articles.  Note that a
    URI-encoded CSL stylesheet (`data/jats.csl`) is added automatically
    unless a stylesheet is specified using `--css`.

  * New output format `gfm` (GitHub-flavored CommonMark) (#3841).
    This uses bindings to GitHub's fork of cmark, so it should parse
    gfm exactly as GitHub does (excepting certain postprocessing
    steps, involving notifications, emojis, etc.).  `markdown_github`
    has been deprecated in favor of `gfm`.

  * New output format `muse` (Emacs Muse) (Alexander Krotov, #3489).

  * New input format `gfm` (GitHub-flavored CommonMark) (#3841).
    This uses bindings to GitHub's fork of cmark.  `markdown_github`
    has been deprecated in favor of `gfm`.

  * New input format `muse` (Emacs Muse) reader (Alexander Krotov, #3620).

  * New input format `tikiwiki` (TikiWiki markup) (rlpowell, #3800).

  * New input format `vimwiki` (Vimwiki markup) (Yuchen Pei, #3705).
    Note that there is a new data file, `data/vimwiki.css`, which can
    be used to display the HTML produced by this reader and
    pandoc's HTML writer in the style of vimwiki's own HTML
    export.

  * New input format `creole` (Creole 1.0) (#3994, Sascha Wilde).

  * New syntax for Divs, with `fenced_divs` extension enabled by
    default (#168).  This gives an attractive, plain-text way to create
    containers for block-level content.

  * Added new syntax for including raw content in any output format,
    enabled by the `raw_attribute` extension (which is on by default
    for `markdown` and `multimarkdown`).  The syntax is the same as
    for fenced code blocks or code inlines, only with `{=FORMAT}` for
    attributes, where `FORMAT` is the name of the output format
    (e.g., `ms`, `html`).

  * Implement multicolumn support for slide formats (#1710).
    The structure expected is:

        :::::::::::::: {.columns}
        ::: {.column width="40%"}
        contents...
        :::
        ::: {.column width="60%"}
        contents...
        :::
        ::::::::::::::

    Support has been added for beamer and all HTML slide formats.

  * Allows line comments in templates, beginning with `$--` (#3806).
    (Requires doctemplates 0.2.1.)

  * Add `--eol=crlf|lf|native` flag and writer option to control line endings
    (Stefan Dresselhaus, #3663, #2097).

  * Add `--log` option to save log messages in JSON format to a file (#3392).

  * Add `--request-header` option, to set request headers when pandoc
    makes HTTP requests to fetch external resources. For example:
    `--request-header User-Agent:blah`.

  * Added lua filters (Albert Krewinkel, #3514).  The new `--lua-filter`
    option works like `--filter` but takes pathnames of special lua filters
    and uses the lua interpreter baked into pandoc, so that no external
    interpreter is needed.  Note that lua filters are all applied after
    regular filters, regardless of their position on the command line.
    For documentation of lua filters, see `doc/lua-filters.md`.

  * Set `PANDOC_READER_OPTIONS` in environment where filters are run.
    This contains a JSON representation of `ReaderOptions`, so filters
    can access it.

  * Support creation of pdf via groff `ms` and pdfroff.
    `pandoc -t ms -o output.pdf input.txt`.

  * Support for PDF generation via HTML and `weasyprint` or `prince`
    (Mauro Bieg, #3909).  `pandoc -t html5 -o output.pdf --pdf-engine=prince`.

  * Added `--epub-subdirectory` option (#3720).  This specifies the
    subdirectory in the OCF container that holds the EPUB specific content.
    We now put all EPUB related content in an `EPUB/` subdirectory by default
    (later this will be configurable).

    ```
      mimetype
      META-INF/
        com.apple.ibooks.display-options.xml
        container.xml
      EPUB/ <<--configurable-->>
        fonts/ <<--static-->>
        font.otf
      media/ <<--static-->>
        cover.jpg
        fig1.jpg
      styles/ <<--static-->>
        stylesheet.css
      content.opf
      toc.ncx
      text/ <<--static-->>
        ch001.xhtml
    ```

  * Added `--resource-path=SEARCHPATH` command line option (#852).
    SEARCHPATH is separated by the usual character, depending on OS
    (: on unix, ; on windows).  Default resource path is just working
    directory.  However, the working directory must be explicitly
    specified if the `--resource-path` option is used.

  * Added --abbreviations=FILE option for custom abbreviations file
    (#256).  Dfault abbreviations file (`data/abbreviations`) contains
    a list of strings that will be recognized by pandoc's
    Markdown parser as abbreviations.  (A nonbreaking space will
    be inserted after the period, preventing a sentence space in
    formats like LaTeX.) Users can override the default by putting a file
    abbreviations in their user data directory (`~/.pandoc` on *nix).

  * Allow a theme file as argument to `--highlight-style`.
    Also include a sample, `default.theme`, in `data/`.

  * Allow `--syntax-definition` option for dynamic loading of syntax
    highlighting definitions (#3334).

  * Lists in `markdown` by default now use the CommonMark variable
    nesting rules (#3511). The indentation required for a block-level
    item to be included in a list item is no longer fixed, but is
    determined by the first line of the list item.  To be included in
    the list item, a block must be indented to the level of the first
    non-space content after the list marker. Exception: if are 5 or more
    spaces after the list marker, then the content is interpreted as an
    indented code block, and continuation paragraphs must be indented
    two spaces beyond the end of the list marker.  See the CommonMark
    spec for more details and examples.

    Documents that adhere to the four-space rule should, in most cases,
    be parsed the same way by the new rules.  Here are some examples
    of texts that will be parsed differently:

        - a
          - b

    will be parsed as a list item with a sublist; under the four-space
    rule, it would be a list with two items.

        - a

              code

    Here we have an indented code block under the list item, even though it
    is only indented six spaces from the margin, because it is four spaces
    past the point where a continuation paragraph could begin.  With the
    four-space rule, this would be a regular paragraph rather than a code
    block.

        - a

                code

    Here the code block will start with two spaces, whereas under
    the four-space rule, it would start with `code`.  With the four-space
    rule, indented code under a list item always must be indented eight
    spaces from the margin, while the new rules require only that it
    be indented four spaces from the beginning of the first non-space
    text after the list marker (here, `a`).

    This change was motivated by a slew of bug reports from people
    who expected lists to work differently (#3125, #2367, #2575, #2210,
     #1990, #1137, #744, #172, #137, #128) and by the growing prevalance
    of CommonMark (now used by GitHub, for example).  Those who
    prefer the old behavior can use `-f markdown+four_space_rule`.

  * Added `four_space_rule` extension.  This triggers the old pandoc
    parsing rule for content nested under list items (the "four space
    rule").

  * Added `spaced_reference_links` extension (#2602).  It allows whitespace
    between the two parts of a reference link:  e.g.

        [a] [b]

        [b]: url

    This was previously enabled by default; now it is forbidden by default.

  * Add `space_in_atx_header` extension (#3512).  This is enabled by default
    in pandoc and GitHub markdown but not the other flavors.
    This requirse a space between the opening #'s and the header
    text in ATX headers (as CommonMark does but many other implementations
    do not).  This is desirable to avoid falsely capturing things ilke

        #hashtag

    or

        #5

  * Add `sourcefile` and `outputfile` template variables (Roland Hieber,
    #3431).

  * Allow ibooks-specific metadata in epubs (#2693).  You can now have
    the following fields in your YAML metadata, and it will be treated
    appropriately in the generated EPUB:

    ```
      ibooks:
        version: 1.3.4
        specified-fonts: false
        ipad-orientation-lock: portrait-only
        iphone-orientation-lock: landscape-only
        binding: true
        scroll-axis: vertical
    ```


### Behavior changes

  * Reader functions no longer presuppose that CRs have been
    stripped from the input. (They strip CRs themselves, before
    parsing, to simplify the parsers.)

  * Added support for translations (localization) (#3559).
    Currently this only affects the LaTeX reader, for things
    like `\figurename`.  Translation data files for 46 languages
    can be found in `data/translations`.

  * Make `--ascii` work with DocBook output too.

  * Rename `--latex-engine` to `--pdf-engine`,
    and `--latex-engine-opt` to `--pdf-engine-opt`.

  * Removed `--parse-raw` and `readerParseRaw`.  These were confusing.
    Now we rely on the `+raw_tex` or `+raw_html` extension with latex or html
    input.  Thus, instead of `--parse-raw -f latex` we use `-f latex+raw_tex`,
    and instead of `--parse-raw -f html` we use `-f html+raw_html`.

  * With `--filter` R filters are now recognized, even if they are
    not executable (#3940, #3941, Andrie de Vries).

  * Support SVG in PDF output, converting with `rsvg2pdf` (#1793).

  * Make epub an alias for epub3, not epub2.

  * Removed `--epub-stylesheet`; use `--css` instead (#3472, #847).
    Multiple stylesheets may be used.  Stylesheets will be taken both from
    `--css` and from the `stylesheet` metadata field (which can contain
    either a file path or a list of them).

  * `--mathml` and MathML in HTMLMathMethod no longer take an argument.
    The argument was for a bridge JavaScript that used to be necessary
    in 2004.  We have removed the script already.

  * `--katex` improvements.  The latest version is used, and the
    autoload script is loaded by default.

  * Change MathJax CDN default since old one is shutting down (#3544).
    Note:  The new URL requires a version number, which we'll have
    to update manually in subsequent pandoc releases in order to
    take advantage of mathjax improvements.

  * `--self-contained`: don't incorporate elements with `data-external="1"`
    (#2656).  You can leave an external link as it is by adding the attribute
    data-external="1" to the element.  Pandoc will then not try to
    incorporate its content when `--self-contained` is used.  This is
    similar to a feature already supported by the EPUB writer.

  * Allow `--extract-media` to work with non-binary input formats
    (#1583, #2289).  If `--extract-media` is supplied with a non-binary
    input format, pandoc will attempt to extract the contents of all
    linked images, whether in local files, data: uris, or external uris.
    They will be named based on the sha1 hash of the contents.

  * Make `papersize: a4` work regardless of the case of `a4`.
    It is converted to `a4` in LaTeX and `A4` in ConTeXt.

  * Make `east_asian_line_breaks` affect all readers/writers (#3703).

  * Underlined elements are now treated consistently by readers
    (#2270, hftf); they are always put in a Span with class `underline`.
    This allows the user to treat them differently from other emphasis,
    using a filter.  Docx, Org, Textile, Txt2Tags, and HTML readers
    have been changed.

  * Improved behavior of `auto_identifiers` when there are explicit ids
    (#1745).  Previously only autogenerated ids were added to the list
    of header identifiers in state, so explicit ids weren't taken
    into account when generating unique identifiers.  Duplicated
    identifiers could result.  This simple fix ensures that explicitly given
    identifiers are also taken into account.

  * Use `table-of-contents` for contents of toc, make `toc` a boolean
    (#2872).  Changed markdown, rtf, and HTML-based templates accordingly.
    This allows you to set `toc: true` in the metadata; this
    previously produced strange results in some output formats.
    For backwards compatibility, `toc` is still set to the
    toc contents.  But it is recommended that you update templates
    to use `table-of-contents` for the toc contents and `toc`
    for a boolean flag.

  * Change behavior with binary format output to stdout.
    Previously, for binary formats, output to stdout was disabled
    unless we could detect that the output was being piped (and not
    sent to the terminal).  Unfortunately, such detection is not
    possible on Windows, leaving windows users no way to pipe binary
    output.  So we have changed the behavior in the following way:

    + Output to stdout is allowed when it can be determined that
      the output is being piped (on non-Windows platforms).
    + If the `-o` option is not used, binary output is never sent
      to stdout by default; instead, an error is raised.
    + If `-o -` is used, binary output is sent to stdout, regardless
      of whether it is being piped. This works on Windows too.

  * Better error behavior:  uses of `error` have been replaced by
    raising of `PandocError`, which can be trapped and handled by the
    calling program.

  * Removed `hard_line_breaks` extension from `markdown_github` (#3594).
    GitHub has two Markdown modes, one for long-form documents like READMEs
    and one for short things like issue comments. In issue comments, a line
    break is treated as a hard line break. In README, wikis, etc., it is
    treated as a space as in regular Markdown.  Since pandoc is more likely to
    be used to convert long-form documents from GitHub Markdown,
    `-hard_line_breaks` is a better default.

  * Include `backtick_code_blocks` extension in `mardkown_mmd` (#3637).

  * Escape `MetaString` values (as added with `-M/--metadata` flag) (#3792).
    Previously they would be transmitted to the template without any
    escaping.  Note that `--M title='*foo*'` yields a different result from

        ---
        title: *foo*
        ---

    In the latter case, we have emphasis; in the former case, just
    a string with literal asterisks (which will be escaped
    in formats, like Markdown, that require it).

  * Allow `em`, `cm`, `in` for image height/width in HTML, LaTeX (#3450).

  * HTML writer: Insert `data-` in front of unsupported attributes.  Thus,
    a span with attribute `foo` gets written to HTML5 with `data-foo`, so
    it is valid HTML5.  HTML4 is not affected.  This will allow us to use
    custom attributes in pandoc without producing invalid HTML. (With help
    from Wandmalfarbe, #3817.)

  * Plain writer:  improved super/subscript rendering.  We now
    handle more non-digit characters for which there are
    sub/superscripted unicode characters.  When unicode
    sub/superscripted characters are not available, we use
    `_(..)` or `^(..)` (#3518).

  * Docbook, JATS, TEI writers: print INFO message when omitting interior
    header (#3750).  This only applies to section headers inside list items,
    e.g., which were otherwise silently omitted.

  * Change to `--reference-links` in Markdown writer (#3701).  With
    `--reference-location` of `section` or `block`, pandoc will now repeat
    references that have been used in earlier sections.  The Markdown
    reader has also been modified, so that *exactly* repeated references
    do not generate a warning, only references with the same label but
    different targets.  The idea is that, with references after every block,
    one might want to repeat references sometimes.

  * ODT/OpenDocument writer:

    + Support `lang` attribute (#1667).
    + Added support for `--toc` (#2836).  Thanks to @anayrat.

  * Docx writer:

    + `lang` meta, see #1667 (Mauro Bieg, #3515).
    + Change `FigureWithCaption` to `CaptionedFigure` (iandol, #3658).
    + Use `Table` rather than `Table Normal` for table style (#3275).
      `Table Normal` is the default table style and can't be modified.
    + Pass through comments (#2994).  We assume that comments are defined as
      parsed by the docx reader:

        I want <span class="comment-start" id="0" author="Jesse Rosenthal"
        date="2016-05-09T16:13:00Z">I left a comment.</span>some text to
        have a comment <span class="comment-end" id="0"></span>on it.

      We assume also that the id attributes are unique and properly
      matched between comment-start and comment-end.
    + Bookmark improvements.  Bookmark start/end now surrounds content rather
      than preceding it.  Bookmarks generated for Div with id
      (jgm/pandoc-citeproc#205).
    + Add `keywords` metadata to docx document properties (Ian).

  * RST writer: support unknown interpreted text roles by
    parsing them as `Span` with `role` attributes (#3407).  This
    way they can be manipulated in the AST.

  * HTML writer:

    + Line block: Use class instead of style attribute (#1623).  We now
      issue `<div class="line-block">` and include a default definition
      for `line-block` in the default templates, instead of hard-coding a
      `style` on the div.
    + Add class `footnoteBack` to footnote back references (Timm Albers).
      This allows for easier CSS styling.
    + Render SmallCaps as span with smallcaps class (#1592), rather than
      using a style attribute directly.  This gives the user more flexibility
      in styling small caps in CSS.
    + With reveal.js we use `data-src` instead of `src` for images for
      lazy loading.
    + Special-case `.stretch` class for images in reveal.js (#1291).
      Now in reveal.js, an image with class `stretch` in a paragraph
      by itself will stretch to fill the whole screen, with no
      caption or figure environment.

  * Added warnings for non-rendered blocks to writers.

  * Writers now raise an error on template failure.

  * When creating a PDF via LaTeX, warn if the font is missing some
    characters (#3742).

  * Remove initial check for PDF-creating program (#3819).
    Instead, just try running it and raise the exception if it
    isn't found at that point.  This improves things for users of Cygwin
    on Windows, where the executable won't be found by `findExecutable`
    unless `.exe` is added.  The same exception is raised as before, but
    at a later point.

  * Readers issue warning for duplicate header identifiers (#1745).
    Autogenerated header identifiers are given suffixes so as not to clash
    with previously used header identifiers. But they may still coincide with
    an explicit identifier that is given for a header later in the document,
    or with an identifier on a div, span, link, or image. We now issue
    a warning in this case, so users can supply an explicit identifier.

  * CommonMark reader now supports `emoji`, `hard_line_breaks`, `smart`,
    and `raw_html` extensions.

  * Markdown reader:

    + Don't allow backslash + newline to affect block structure (#3730).
      Note that as a result of this change, the following, which formerly
      produced a header with two lines separated by a line break, will
      now produce a header followed by a paragraph:

        # Hi\
        there

      This may affect some existing documents that relied on
      this undocumented and unintended behavior.  This change makes pandoc
      more consistent with other Markdown implementations, and with itself
      (since the two-space version of a line break doesn't work inside ATX
      headers, and neither version works inside Setext headers).


  * Org reader (Albert Krewinkel, unless noted):

    + Support `table.el` tables (#3314).
    + Support macros (#3401).
    + Support the `#+INCLUDE:` file inclusion mechanism (#3510).
      Recognized include types are `example`, `export`, `src`, and
      normal org file inclusion.  Advanced features like line numbers
      and level selection are not implemented yet.
    + Interpret more meta value as inlines.  The values of the following
      meta variables are now interpreted using org-markup instead of
      treating them as pure strings: `keywords` (comma-separated list of
      inlines), `subtitle` (inline values), `nocite` (inline values, can
      be repeated).
    + Support `\n` export option (#3940).  This turns all newlines in the
      text into hard linebreaks.

  * RST reader:

    + Improved admonition support (#223).  We no longer add an
      `admonition` class, we just use the class for the type of admonition,
      `note` for example.  We put the word corresponding to the label in
      a paragraph inside a `Div` at the beginning of the admonition with
      class `admonition-title`.  This is about as close as we can get to
      RST's own output.
    + Initial support of `.. table` directive.  This allows adding captions
      to tables.
    + Support `.. line-block` directive.  This is deprecated but may still
      be in older documents.
    + Support scale and align attributes of images (#2662).
    + Implemented implicit internal header links (#3475).
    + Support RST-style citations (#853).  The citations appear at the end
      of the document as a definition list in a special div with id
      `citations`. Citations link to the definitions.
    + Recurse into bodies of unknown directives (#3432).
      In most cases it's better to preserve the content than
      to emit it.  This isn't guaranteed to have good results;
      it will fail spectacularly for unknown raw or verbatim directives.
    + Handle chained link definitions (#262).  For example,

          .. _hello:
          .. _goodbye: example.com

      Here both `hello` and `goodbye` should link to `example.com`.
    + Support anchors (#262).  E.g.

          `hello`

          .. _hello:

          paragraph

      This is supported by putting "paragraph" in a `Div` with id `hello`.
    + Support `:widths:` attribute for table directive.
    + Implement csv-table directive (#3533).  Most attributes are supported,
      including `:file:` and `:url:`.
    + Support unknown interpreted text roles by parsing them as Span
      with "role" attributes (#3407).  This way they can be manipulated in
      the AST.

  * HTML reader: parse a span with class `smallcaps` as `SmallCaps`.

  * LaTeX reader:

    + Implemented `\graphicspath` (#736).
    + Properly handle column prefixes/suffixes.  For example, in
      `\begin{tabular}{>{$}l<{$}>{$}l<{$} >{$}l<{$}}`
      each cell will be interpreted as if it has a `$`
      before its content and a `$` after (math mode).
    + Handle komascript `\dedication` (#1845).  It now adds a
      `dedication` field to metadata.  It is up to the user to supply
      a template that uses this variable.
    + Support all `\textXX` commands, where XX = `rm`, `tt`, `up`, `md`,
      `sf`, `bf` (#3488).  Spans with a class are used when there is
      nothing better.
    + Expand `\newenvironment` macros (#987).
    + Add support for LaTeX subfiles package (Marc Schreiber, #3530).
    + Better support for subfigure package (#3577).
      A figure with two subfigures turns into two pandoc
      figures; the subcaptions are used and the main caption
      ignored, unless there are no subcaptions.
    + Add support for `\vdots` (Marc Schreiber, #3607).
    + Add basic support for hyphenat package (Marc Schreiber, #3603).
    + Add basic `\textcolor` support (Marc Schreiber).
    + Add support for `tabularx` environment (Marc Schreiber, #3632).
    + Better handling of comments inside math environments (#3113).
      This solves a problem with commented out `\end{eqnarray}` inside
      an eqnarray (among other things).
    + Parse tikzpicture as raw verbatim environment if `raw_tex` extension
      is selected (#3692).  Otherwise skip with a warning.  This is better
      than trying to parse it as text!
    + Add `\colorbox` support (Marc Schreiber).
    + Set identifiers on Spans used for `\label`.
    + Have `\setmainlanguage` set `lang` in metadata.
    + Support etoolbox's `\ifstrequal`.
    + Support `plainbreak`, `fancybreak` et al from the memoir class
      (bucklereed, #3833).
    + Support `\let`.  Also, fix regular macros so they're expanded at the
      point of use, and NOT also the point of definition.  `\let` macros,
      by contrast, are expanded at the point of definition.  Added an
      `ExpansionPoint` field to `Macro` to track this difference.
    + Support simple `\def` macros.  Note that we still don't support
      macros with fancy parameter delimiters, like `\def\foo#1..#2{...}`.
    + Support `\chaptername`, `\partname`, `\abstractname`, etc.  (#3559,
      obsoletes #3560).
    + Put content of `\ref`, `\label`, `\eqref` commands into `Span` with
      attributes, so they can be handled in filters (Marc Schreiber, #3639)
    + Add Support for `glossaries` and `acronym` package (Marc Schreiber,
      #3589). Acronyms are not resolved by the reader, but acronym and
      glossary information is put into attributes on Spans so that they
      can be processed in filters.
    + Use `Link` instead of `Span` for `\ref`.  This makes more sense
      semantically and avoids unnecessary `Span [Link]` nestings when
      references are resolved.
    + Rudimentary support for `\hyperlink`.
    + Support `\textquoteleft|right`, `\textquotedblleft|right` (#3849).
    + Support `\lq`, `\rq`.
    + Implement `\newtoggle`, `\iftoggle`, `\toggletrue|false` from etoolbox
      (#3853).
    + Support `\RN` and `\Rn`, from biblatex (bucklereed, #3854).
    + Improved support for `\hyperlink`, `\hypertarget` (#2549).
    + Support `\k` ogonek accent.
    + Improve handling of accents.  Handle ogonek, and fall back correctly
      with forms like `\"{}`.
    + Better support for ogonek accents.
    + Support for `\faCheck` and `\faClose` (Marc Schreiber, #3727).
    + Support for `xspace` (Marc Schreiber, #3797).
    + Support `\setmainlanguage` or `\setdefaultlanguage` (polyglossia)
      and `\figurename`.
    + Better handling of `\part` in LaTeX (#1905).  Now we parse chapters as
      level 0 headers, and parts as level -1 headers.  After parsing, we
      check for the lowest header level, and if it's less than 1 we bump
      everything up so that 1 is the lowest header level.  So `\part` will
      always produce a header; no command-line options are needed.
    + Add block version of `\textcolor` (Marc Schreiber).
    + `\textcolor` works as inline and block command (Marc Schreiber).
    + `\textcolor` will be parse as span at the beginning of a paragraph
      (Marc Schreiber).
    + Read polyglossia/babel `\text(LANG){...}` (bucklereed)
    + Improved handling of include files in LaTeX reader (#3971).
      Previously `\include` wouldn't work if the included file
      contained, e.g., a begin without a matching end.
    + Support `\expandafter` (#3983).
    + Handle `\DeclareRobustCommand` (#3983).  Currently it's just treated
      as a synonym for `\newcommand`.
    + Handle `\lettrine` (Mauro Bieg).

  * Math improvements due to updates in texmath:

    + Improved handling of accents and upper/lower delimiters.
    + Support for output in GNU eqn format (used with *roff).
    + Allow `\boldsymbol` + a token without braces, and similarly
      with other styling commands.
    + Improve parsing of `\mathop` to allow multi-character operator names.
    + Add thin space after math operators when "faking it with
      unicode."

  * `walk` is now used instead of `bottomUp` in the `ToJSONFilter`
    instance for `a -> [a]` (pandoc-types).  Note that behavior
    will be slightly different, since `bottomUp`'s treatment of
    a function `[a] -> [a]` is to apply it to each sublist of a
    list, while walk applies it only to maximal sublists.
    Usually the latter behavior is what is wanted, and the
    former can be simulated when needed.  But there may be
    existing filters that need to be rewritten in light of the
    new behavior.  Performance should be improved.

  * There are some changes to syntax highlighting due to revisions
    in the `skylighting` library:

    + Support for `powershell` has been added, and many syntax
      definitions have been updated.
    + Background colors have been added to the `kate` style.
    + The way highlighted code blocks are formatted in HTML has
      been changed (David Baynard), in ways that may require
      changes in hard-coded CSS affecting highlighting.
      (If you haven't included hard-coded highlighting CSS in
      your template, you needn't change anything.)


### API changes

  * New module `Text.Pandoc.Class` (Jesse Rosenthal, John MacFarlane).
    This contains definitions of the `PandocMonad` typeclass, the
    `PandocIO` and `PandocPure` monads, and associated functions.

  * Changed types of all writers and readers.

    + We now use `Text` instead of `String` in the interface (#3731).
      (We have not yet changed the internals of most readers to work
      with `Text`, but making this change in the API now opens up a
      path to doing that.)
    + The result is now of form `m a` with constraint `PandocMonad m`.
      Readers and writers can be combined to form monadic values which
      can be run using either `runIO` or `runPure`.  If `runIO` is used,
      then both readers and writers will be able to do IO when needed
      (for include files, for example); if `runPure` is used,
      then the functions are pure and will not touch IO.
    + Where previously you used
      `writeRST def (readMarkdown def "[foo](url)")`, now you
      would use
      `runPure $ readMarkdown def (pack "[foo](url)") >>= writeRST def`.

  * New module `Text.Pandoc.Readers` (Albert Krewinkel).  This
    contains reader helper functions formerly defined in the
    top-level `Text.Pandoc` module.

    + Changed `StringReader` -> `TextReader`.
    + `getReader` now returns a pair of a reader and
      `Extensions`, instead of building the extensions into the
      reader (#3659).  The calling code must explicitly set
      `readerExtensions` using the `Extensions` returned.  The
      point of the change is to make it possible for the calling
      code to determine what extensions are being used.

  * New module `Text.Pandoc.Writers` (Albert Krewinkel).
    This contains writer helper functions formerly defined in the
    top-level `Text.Pandoc` module.

    + Changed `StringWriter` -> `TextWriter`.
    + `getWriter` now returns a pair of a reader and
      `Extensions`, instead of building the extensions into the
      reader (#3659).  The calling code must explicitly set
      `readerExtensions` using the `Extensions` returned.  The
      point of the change is to make it possible for the calling
      code to determine what extensions are being used.

  * New module `Text.Pandoc.Lua`, exporting `runLuaFilter` (Albert Krewinkel,
    #3514).

  * New module `Text.Pandoc.App`.  This abstracts out the functionality
    of the command line program (`convertWithOpts`), so it can be reproduced
    e.g. in a desktop or web application.  Instead of exiting, we throw errors
    (#3548), which are caught (leading to exit) in pandoc.hs, but allow other
    users of `Text.Pandoc.App` to recover.  `pandoc.hs` is now a 2-liner.
    The module also exports some utility functions for parsing options
    and running filters.

  * New module `Text.Pandoc.Logging` (exported module) (#3392).
    This now contains the `Verbosity` definition previously in
    `Text.Pandoc.Options`, as well as a new `LogMessage` datatype that will
    eventually be used instead of raw strings for warnings.  This will enable
    us, among other things, to provide machine-readable warnings if desired.
    Include ToJSON instance and showLogMessage.  This gives us the possibility
    of both machine-readable and human-readable output for log messages.

  * New module `Text.Pandoc.BCP47`, with `getLang`, `Lang(..)`, `parseBCP47`.

  * New module `Text.Pandoc.Translations`, exporting `Term`,
    `Translations`, `readTranslations`.

  * New module `Text.Pandoc.Readers.LaTeX.Types', exporting `Macro`, `Tok`,
    `TokType`, `Line`, `Column`.

  * `Text.Pandoc.Error`: added many new constructors for `PandocError`.

  * Expose some previously private modules (#3260).  These are often
    helpful to people writing their own reader or writer modules:

    + `Text.Pandoc.Writers.Shared`
    + `Text.Pandoc.Parsing`
    + `Text.Pandoc.Asciify`
    + `Text.Pandoc.Emoji`
    + `Text.Pandoc.ImageSize`
    + `Text.Pandoc.Highlighting`
`
  * New module `Text.Pandoc.Extensions` (Albert Krewinkel):
    Extension parsing and processing functions were defined in the top-level
    `Text.Pandoc` module.  These functions are moved to the Extensions
    submodule as to enable reuse in other submodules.

  * Add `Ext_raw_attribute` constructor for `Extension`.

  * Add `Ext_fenced_divs` constructor for `Extension'.

  * Add `Ext_four_space_rule` constructor in `Extension`.

  * Add `Ext_gfm_auto_identifiers` constructor for `Extension`.

  * Add `Monoid` instance for `Extensions`.

  * Add `Text.Pandoc.Writers.Ms`, exporting `writeMs`.

  * Add `Text.Pandoc.Writers.JATS`, exporting `writeJATS`.

  * Add `Text.Pandoc.Writers.Muse`, exporting `writeMuse`.

  * Add `Text.Pandoc.Readers.Muse`, exporting `readMuse`.

  * Add `Text.Pandoc.Readers.TikiWiki`, exporting `readTikiWiki`.

  * Add `Text.Pandoc.Readers.Vimwiki`, exporting `readVimwiki`.

  * Add `Text.Pandoc.Readers.Creole`, exporting `readCreole`.

  * Export `setVerbosity` from `Text.Pandoc`.

  * `Text.Pandoc.Pretty`: Add `Eq` instance for `Doc`.

  * `Text.Pandoc.XML`: `toEntities`: changed type to `Text -> Text`.

  * `Text.Pandoc.UTF8`:

    + Export `fromText`, `fromTextLazy`, `toText`, `toTextLazy`.
      Define `toString`, `toStringLazy` in terms of them.
    + Add new functions parameterized on `Newline`: `writeFileWith`,
      `putStrWith`, `putStrLnWith`, `hPutStrWith`, `hPutStrLnWith`.

  * `Text.Pandoc.MediaBag`: removed `extractMediaBag`.

  * `Text.Pandoc.Highlighting`:

    + `highlighting` now returns an Either rather than Maybe.
      This allows us to display error information returned by the skylighting
      library.  Display a warning if the highlighting library throws an error.
    + Add parameter for `SyntaxMap` to `highlight`.

  * `Text.Pandoc.Writers.Math`:

    + Export `defaultMathJaxURL`, `defaultKaTeXURL`.  This will ensure that
      we only need to update these in one place.

  * `Text.Pandoc.SelfContained`:

    + Removed `WriterOptions` parameter from `makeSelfContained`.
    + Put `makeSelfContained` in PandocMonad instead of IO.  This removes
      the need to pass MediaBag around and improves exceptions.  It also
      opens up the possibility of using makeSelfContained purely.
    + Export `makeDataURI`.

  * `Text.Pandoc.ImageSize`:

    + Export `lengthToDim`, new function `scaleDimension`.
    + Export `inEm` from ImageSize (#3450).
    + Change `showFl` and `show` instance for `Dimension` so
      extra decimal places are omitted.
    + Added `Em` as a constructor of `Dimension`.
    + Add `WriterOptions` parameter to `imageSize` signature (Mauro Bieg).

  * `Text.Pandoc.Templates`:

    + Change type of `renderTemplate'`.  Now it runs in `PandocMonad`
      and raises a proper `PandocTemplateError` if there are problems, rather
      than failing with uncatchable `error`.
    + Change signature of `getDefaultTemplate`.  Now it runs in any instance
      of `PandocMonad`, and returns a `String` rather than an `Either` value.
      And it no longer takes a `datadir` parameter, since this can be
      retrieved from `CommonState`.

  * `Text.Pandoc.Options`:

    + Added `writerEpubSubdirectory` to `WriterOptions` (#3720).
      The EPUB writer now takes its EPUB subdirectory from this option.
    + In `WriterOptions`, rename `writerLaTeXEngine` to `writerPdfEngine`
      and `writerLaTeXArgs` to `writerPdfArgs` (Mauro Bieg, #3909).
    + Add `writerSyntaxMap` to `WriterOptions`.
    + Removed `writerEpubStylesheet` from `WriterOptions`.
    + Remove `writerUserDataDir` from `WriterOptions`.  It is now carried
      in `CommonState` in `PandocMonad` instances.  (And thus it can be used
      by readers too.)
    + Changed `writerEpubMetadata` to a `Maybe String`.
    + Removed `readerApplyMacros` from `ReaderOptions`.  Now we just check
      the `latex_macros` reader extension.
    + FromJSON/ToJSON instances for `ReaderOptions`.
    + In `HTMLMathMethod`, the `KaTeX` contsructor now takes only
      one string (for the KaTeX base URL), rather than two.
    + Removed `writerSourceURL` from `WriterOptions`.  We now use
      `stSourceURL` in `CommonState`, which is set by `setInputFiles`.

  * `Text.Pandoc.Shared`:

    + `tabFilter` now takes a `Text`, not `String`.
    + `openURL`: Changed type from an Either.  Now it will just raise
      an exception to be trapped later.
    + Remove `normalizeSpaces` (#1530).
    + Remove `warn`.  (Use `report` from `Text.Pandoc.Class` instead.)
    + Export a new function `crFilter`.
    + Add `eastAsianLineBreakFilter` (previously in Markdown reader).
    + Provide custom `isURI` that rejects unknown schemes.
      (Albert Krewinkel, #2713).  We also export the set of known
      `schemes`.  The new function replaces the function of the same name
      from `Network.URI`, as the latter did not check whether a scheme is
      well-known.  All official IANA schemes (as of 2017-05-22) are
      included in the set of known schemes.  The four non-official schemes
      `doi`, `isbn`, `javascript`, and `pmid` are kept.
    + Remove `err`.
    + Remove `readDataFile`, `readDefaultDataFile`, `getReferenceDocx`,
      `getReferenceODT`. These now live in `Text.Pandoc.Class`,
      where they are defined in terms of `PandocMonad`
      primitives and have different signatures.
    + Remove `openURL`.  Use `openURL` from `Text.Pandoc.Class` instead.
    + Add `underlineSpan`.

  * `Text.Pandoc.Readers.HTML`: export new `NamedTag` class.

  * `Text.Pandoc.Readers.Markdown`: remove `readDocxWithWarnings`.
     With the new API one can simply use `getLog` after running
     the reader.

  * `Text.Pandoc.Readers.LaTeX`: Changed types for `rawLaTeXInline`
     and `rawLaTeXBlock`.  (Both now return a `String`, and they are
     polymorphic in state.)


### Bug fixes and under-the-hood improvements

  * TEI writer: Added identifiers on `<div>` elements.

  * DokuWiki reader: Better handling for code block in list item (#3824).

  * Custom writer: Remove old preprocesesor conditionals (Albert Krewinkel).

  * ZimWiki writer: Removed internal formatting from note and table cells,
    because ZimWiki does not support it (Alex Ivkin, #3446).

  * MediaWiki writer:

    + Updated list of syntax highlighting languages (#3461).
      Now `r` gets you `<source>` rather than `<code>` (among others).
    + Add display attribute on `<math>` tags (#3452).  This allows display
      math to be rendered properly.
    + Remove newline before `</ref>` (#2652).
    + Don't softbreak lines inside list items (#3531).

  * Org writer:

    + Reduce to two spaces after bullets (#3417, Albert Krewinkel).
    + Add unit tests (Alexander Krotov).
    + Stop using raw HTML to wrap divs (Albert Krewinkel, #3771).
    + Do not strip `#` from Org anchor links (Alexander Krotov).

  * CommonMark writer:

    + Avoid excess blank lines at end of output.
    + Prefer pipe tables to HTML tables even if it means losing relative
      column width information (#3734).
    + Support table, strikethrough extensions, when enabled (as with gfm).
      Note that we bypass the commonmark writer from cmark and construct our
      own pipe tables, with better results.
    + Properly support `--wrap=none`.
    + Use smallcaps class for `SmallCaps` (#1592).
    + Omit "fig:" prefix in image titles.  This is used internally to
      indicate internal figures.

  * RST writer:

    + Properly handle table captions.
    + Don't wrap lines in in definition list terms.  Wrapping is not allowed.
    + Implemented `+/-smart` and improved escaping with `+smart`.
    + Add empty comments when needed to avoid including a blockquote
      in the indented content of a preceding block (#3675).
    + Improve grid table output, fix bug with empty rows (#3516).
      Uses the new `gridTable` in Writers.Shared, which is here
      improved to better handle 0-width cells.
    + Remove space at beginning/end of RST code span (#3496).  Otherwise
      we get invalid RST.  There seems to be no way to escape the space.
    + Add header anchors when header has non-standard id (#3937).
    + Correctly handle inline code containing backticks, using a `:literal:`
      role (#3974).
    + Don't backslash-escape word-internal punctuation (#3978).

  * Markdown writer:

    + Don't include variables in metadata blocks.  Previously variables set
      on the command line were included in e.g. YAML metadata, contrary to
      documentation and intentions.
    + Improved escaping with `+smart`.
    + Fixed grid tables embedded in grid tables (#2834).
    + Use span with class 'smallcaps' for SmallCaps, instead of a style
      attribute as before (#1592).
    + Escape initial `%` in a paragraph if the `pandoc_title_blocks`
      extension is enabled (#3454).  Otherwise in a document starting with
      a literal `%` the first line is wrongly interpreted as a title.
    + Fixed false ordered lists in YAML metadata (#3492, #1685).  Now we
      properly escape things that would otherwise start ordered lists,
      such as

          ---
          title: 1. inline
          ...
    + Better handling of tables with empty columns (#3337).  We now
      calculate the number of columns based on the longest row (or the
      length of aligns or widths).
    + Escape unordered list markers at beginning of paragraph (#3497), to
      avoid false interpretation as a list.
    + Escape `|` appropriately.
    + Ensure space before list at top level (#3487).
    + Avoid spurious blanklines at end of document after tables and list,
      for example.
    + Fixed bugs in simple/multiline list output (#3384).
      Previously we got overlong lists with `--wrap=none`.  This is fixed.
      Previously a multiline list could become a simple list (and would
      always become one with `--wrap=none`).
    + Don't emit a simple table if `simple_tables` disabled (#3529).
    + Case-insensitive reference links (David A Roberts, #3616).
      Ensure that we do not generate reference links whose labels differ only
      by case.  Also allow implicit reference links when the link
      text and label are identical up to case.
    + Put space before reference link definitions (Mauro Bieg, #3630).
    + Better escaping for links (David A. Roberts, #3619).  Previously the
      Markdown writer would sometimes create links where there were none
      in the source.  This is now avoided by selectively escaping bracket
      characters when they occur in a place where a link might be created.
    + Added missing `\n` (David A. Roberts, #3647).
    + Fixed duplicated reference links with `--reference-links`
      and `--reference-location=section` (#3674).  Also ensure that there
      are no empty link references `[]`.
    + Avoid inline surround-marking with empty content (#3715).
      E.g. we don't want `<strong></strong>` to become `****`.
      Similarly for emphasis, super/subscript, strikeout.
    + Don't allow soft break in header (#3736).
    + Make sure `plain`, `markdown_github`, etc. work for raw.
      Previously only `markdown` worked.  Note: currently a raw block labeled
      `markdown_github` will be printed for any `markdown` format.
    + Ensure that `+` and `-` are escaped properly so they don't cause
      spurious lists (#3773).  Previously they were only
      if succeeded by a space, not if they were at end of line.
    + Use pipe tables if `raw_html` disabled and `pipe_tables` enabled,
      even if the table has relative width information (#3734).
    + Markdown writer: don't crash on `Str ""`.
    + Make `Span` with null attribute transparent.  That is, we don't use
      brackets or `<span>` tags to mark spans when there are no attributes;
      we simply output the contents.
    + Escape pipe characters when `pipe_tables` enabled (#3887).
    + Better escaping of `<` and `>`.  If `all_symbols_escapable` is set,
      we backslash escape these.  Otherwise we use entities as before.
    + When writing plain, don't use `&nbsp;` to separate list and indented
      code.  There's no need for it in this context, since this isn't to be
      interpreted using Markdown rules.
    + Preserve classes in JS obfuscated links (Timm Albers, #2989).
      HTML links containing classes originally now preserve them when using
      javascript email obfuscation.
    + Render `SmallCaps` as a native span when `native_spans` are enabled.
    + Always write attributes with `bracketed_spans` (d-dorazio).

  * Man writer:

    + Fix handling of nested font commands (#3568).  Previously pandoc emitted
      incorrect markup for bold + italic, for example, or bold + code.
    + Avoid error for definition lists with no definitions (#3832).

  * DocBook writer:

    + Fix internal links with `writerIdentifierPrefix opt`
      (#3397, Mauro Bieg).

  * Docx writer:

    + Don't include bookmarks on headers unless non-null id (#3476).
    + Support 9 levels of headers (#1642).
    + Allow 9 list levels (#3519).
    + Don't take `distArchive` from datadir (#3322).  The docx writer takes
      components from the distribution's version of `reference.docx` when it
      can't find them in a user's custom `reference.docx`.  Previously, we
      allowed a `reference.docx` in the data directory (e.g. `~/.pandoc`)
      to be used as the distribution's reference.docx.  This led to a
      bizarre situation where pandoc would produce a good docx using
      `--template ~/.pandoc/ref.docx`, but if `ref.docx` were moved to
      `~/.pandoc/reference.docx`, it would then produce a corrupted docx.
    + Fixed handling of soft hyphen (0173) (#3691).
    + Better handling of keywords (#3719).
    + Cleaner code for handling dir and style attributes for `Div`.
    + Use `Set` for dynamic styles to avoid duplicates.
    + Removed redundant element from data/docx/word/numbering.xml.
      The elements we need are generated when the document is
      compiled; this didn't do anything.
    + Activate `evenAndOddHeaders` from reference docx (#3901,
      Augustín Martín Barbero).

  * ODT/OpenDocument writer:

    + Calculate aspect ratio for percentage-sized images (Mauro Bieg, #3239).
    + Use more widely available bullet characters (#1400).  The old
      characters weren't available in some font sets.  These seem to work
      well on Windows and Linux versions of LibreOffice.
    + Wider labels for lists (#2421).  This avoids overly narrow labels for
      ordered lists with `()` delimiters.  However, arguably it creates
      overly wide labels for bullets.  Also, lists now start flush with
      the margin, rather than indented.
    + Fixed dropped elements in some ordered lists (#2434).

  * FB2 writer:

    + Don't render `RawBlock` as code.
    + Don't fail with an error on interior headers (e.g. in list) (#3750).
      Instead, omit them with an INFO message.
    + Add support for "lang" metadata (Alexander Krotov, #3625).
    + Format `LineBlock` as poem (Alexander Krotov).  Previously writer
      produced one paragraph with `<empty-line/>` elements, which are not
      allowed inside `<p>` according to FB2 schema.
    + Replace `concatMap` with `cMap` (Alexander Krotov).
    + Write FB2 lists without nesting blocks inside `<p>` (Alexander
      Krotov, #4004)

  * HTML writer:

    + Make sure `html4`, `html5` formats work for raw blocks/inlines.
    + Render raw inline environments when `--mathjax` used (#3816).
      We previously did this only with raw blocks, on the assumption
      that math environments would always be raw blocks. This has changed
      since we now parse them as inline environments.
    + Ensure we don't get two style attributes for width and height.
    + Report when not rendering raw inline/block.
    + Issue warning if no title specified and template used (#3473).
    + Info message if `lang` is unspecified (#3486).
    + Removed unused parameter in `dimensionsToAttributeList`.
    + Avoid two class attributes when adding `uri` class (#3716).
    + Fix internal links with `writerIdentifierPrefix opt` (#3397, Mauro
      Bieg).
    + Use revealjs's math plugin for mathjax (#3743).  This is a thin
      wrapper around mathjax that makes math look better on revealjs.
    + Slidy:  use h1 for all slides, even if they were originally
      level 2 headers (#3566).  Otherwise the built-in table of contents
      in Slidy breaks.

  * LaTeX writer:

    + Don't render LaTeX images with data: URIs (#3636).  Note that
      `--extract-media` can be used when the input contains data: URIs.
    + Make highlighted code blocks work in footnotes (Timm Albers).
    + Don't use figure inside table cell (#3836).
    + Use proper code for list enumerators (#3891).  This should fix problems
      with lists that don't use arabic numerals.
    + Always add hypertarget when there's a non-empty identifier (#2719).
      Previously the hypertargets were only added when there was actually
      a link to that identifier.
    + Use `%` after hypertarget before code block.
    + Add `\leavevmode` before hypertarget at start of paragraph (#2704,
      fixes formatting problems in beamer citations).
    + Don't use `lstinline` in `\item[..]` (#645).  If you do, the contents
      of item disappear or are misplaced.  Use `\texttt` instead.
    + Fix problem with escaping in `lstinline` (#1629).  Previously the
      LaTeX writer created invalid LaTeX when `--listings` was specified and
      a code span occurred inside emphasis or another construction.
    + Fix error with line breaks after empty content (#2874).  LaTeX
      requires something before a line break, so we insert a `~` if no
      printable content has yet been emitted.
    + Use BCP47 parser.
    + Fixed detection of otherlangs (#3770).  We weren't recursing into
      inline contexts.
    + Handle language in inline code with `--listings` (#3422).
    + Write euro symbol directly in LaTeX (Andrew Dunning, #3801).
      The textcomp package allows pdfLaTeX to parse `€` directly, making the
      `\euro` command unneeded.
    + Fixed footnotes in table captions (#2378).  Note that if the table has
      a first page header and a continuation page header, the notes will
      appear only on the first occurrence of the header.
    + In `writeBeamer` output, allow hyperlinks to frames (#3220).
      Previously you could link to a header above or below slide level but
      not *to* slide level.  This commit changes that.  Hypertargets are
      inserted inside frame titles; technically the reference is to just
      after the title, but in normal use (where slides are viewed full
      screen in a slide show), this does not matter.
    + Remove `\strut` at beginning of table cells (#3436).  This fixes a
      problem with alignment of lists in table cells.  The `\strut` at the
      end seems to be enough to avoid the too-close spacing that motivated
      addition of the strut  in #1573.
    + Add partial siunitx Support (Marc Schreiber, #3588).

  * ConTeXt writer:

    + Refactored to use BCP47 module.
    + Remove unnecessary `$` (Alexander Krotov, #3482).
    + Use header identifiers for chapters (#3968).

  * EPUB writer:

    + `title_page.xhtml` is now put in `text/`.
    + Don't strip formatting in TOC (#1611).

  * Textile reader:

    + Fix bug for certain links in table cells (#3667).
    + Allow 'pre' code in list item (#3916).

  * HTML reader:

    + Added warnings for ignored material (#3392).
    + Better sanity checks to avoid parsing unintended things as
      raw HTML in the Markdown reader (#3257).
    + Revise treatment of `li` with `id` attribute (#3596).  Previously we
      always added an empty div before the list item, but this created
      problems with spacing in tight lists.  Now we do this: If the list
      item contents begin with a `Plain` block, we modify the `Plain`
      block by adding a `Span` around its contents.  Otherwise, we add a
      `Div` around the contents of the list item (instead of adding an
      empty `Div` to the beginning, as before).
    + Add `details` tag to list of block tags (#3694).
    + Removed `button` from block tag list (#3717).  It is already in the
      `eitherBlockOrInlineTag` list, and should be both places.
    + Use `Set`s instead of lists for block tag lookup.
    + Rewrote to use `Text` throughout.  Effect on memory usage is modest
      (< 10%).
    + Use the lang value of `<html>` to set the lang meta value (bucklereed,
      #3765).
    + Ensure that paragraphs are closed properly when the parent block
      element closes, even without `</p>` (#3794).
    + Parse `<figure>` and `<figcaption>` (Mauro Bieg, #3813).
    + Parse `<main>` like `<div role=main>` (bucklereed, #3791).
      `<main>` closes `<p>` and behaves like a block element generally
    + Support column alignments (#1881).  These can be set either
      with a `width` attribute or with `text-width` in a `style` attribute.
    + Modified state type to be an instance of `HasLogMessages`, so
      `registerHeader` can issue warnings.
    + `</td>` or `</th>` should close any open block tag (#3991).
    + `<td>` should close an open `<th>` or `<td>`.
    + `htmlTag` improvements (#3989).  We previously failed on cases
      where an attribute contained a `>` character. This patch fixes the
      bug, which especially affects raw HTML in Markdown.

  * Txt2Tags reader:

    + Newline is not indentation (Alexander Krotov).

  * MediaWiki reader:

    + Allow extra hyphens after `|-` in tables (#2649).
    + Allow blank line after table start (#2649).
    + Fixed more table issues (#2649).
    + Ensure that list starts begin at left margin (#2606).  Including when
      they're in tables or other list items.
    + Make smart double quotes depend on `smart` extension (#3585).
    + Don't do curly quotes inside `<tt>` contexts (#3585).  Even if `+smart`.
    + Modified state type to be an instance of `HasLogMessages`, so
      `registerHeader` can issue warnings.

  * TWiki reader (Alexander Krotov):

    + Remove unnecessary `$` (#3597).
    + Simplify `linkText` (#3605).

  * EPUB reader:

    + Minor refactoring, avoiding explicit MediaBag handling.
      This all works behind the scenes in CommonState plumbing.

  * Docx reader:

    + Don't drop smartTag contents (#2242).
    + Handle local namespace declarations (#3365).  Previously we didn't
      recognize math, for example, when the xmlns declaration occurred on
      the element and not the root.
    + More efficient trimSps (#1530).  Replacing `trimLineBreaks`.  This
      does the work of `normalizeSpaces` as well, so we avoid the need for
      that function here.
    + Avoid 0-level headers (Jesse Rosenthal, #3830).  We used to parse
      paragraphs styled with "HeadingN" as "nth-level header." But if a
      document has a custom style named "Heading0", this will produce a
      0-level header, which shouldn't exist. We only parse this style
      if N>0. Otherwise we treat it as a normal style name, and
      follow its dependencies, if any.
    + Add tests for avoiding zero-level header (Jesse Rosenthal).

  * ODT reader:

    + Replaced `collectRights` with Rights from `Data.Either`.
    + Remove dead code (Albert Krewinkel).

  * Org reader (Albert Krewinkel, unless noted).

    + Don't allow tables inside list items (John MacFarlane, #3499).
    + Disallow tables on list marker lines (#3499).
    + Convert markup at beginning of footnotes (John MacFarlane, #3576).
    + Allow emphasized text to be followed by `[` (#3577).
    + Handle line numbering switch for src blocks.
      The line-numbering switch that can be given to source blocks (`-n` with
      an start number as an optional parameter) is parsed and translated to a
      class/key-value combination used by highlighting and other readers and
      writers.
    + Stop adding rundoc prefix to src params.  Source block parameter names
      are no longer prefixed with `rundoc`. This was intended to simplify
      working with the rundoc project, a babel runner. However, the rundoc
      project is unmaintained, and adding those markers is not the reader's
      job anyway.  The original language that is specified for a source
      element is now retained as the `data-org-language` attribute and only
      added if it differs from the translated language.
    + Allow multi-word arguments to src block params (#3477).  The reader now
      correctly parses src block parameter list even if parameter arguments
      contain multiple words.
    + Avoid creating `nullMeta` by applying `setMeta` directly
      (Alexander Krotov).
    + Replace `sequence . map` with `mapM`.
    + Fix smart parsing behavior.  Parsing of smart quotes and special
      characters can either be enabled via the `smart` language extension or
      the `'` and `-` export options. Smart parsing is active if either the
      extension or export option is enabled.  Only smart parsing of special
      characters (like ellipses and en and em dashes) is enabled by default,
      while smart quotes are disabled.  Previously, all smart parsing was
      disabled unless the language extension was enabled.
    + Subject full doc tree to headline transformations (Albert Krewinkel,
      #3695).  Emacs parses org documents into a tree structure, which is
      then post-processed during exporting. The reader is changed to do the
      same, turning the document into a single tree of headlines starting
      at level 0.
    + Fix cite parsing behaviour (Herwig Stuetz).  Until now, `org-ref`
      cite keys included special characters also at the end. This caused
      problems when citations occur right before colons or at the end of
      a sentence.  With this change, all non alphanumeric characters at
      the end of a cite key are ignored.  This also adds `,` to the list
      of special characters that are legal in cite keys to better mirror
      the behaviour of org-export.
    + Fix module names in haddock comments.  Copy-pasting had lead to
      haddock module descriptions containing the wrong module names.
    + Recognize babel result blocks with attributes (#3706).  Babel
      result blocks can have block attributes like captions and names.
      Result blocks with attributes were not recognized and were parsed
      as normal blocks without attributes.
    + Include tags in headlines.  The Emacs default is to include tags in the
      headline when exporting.  Instead of just empty spans, which contain the
      tag name as attribute, tags are rendered as small caps and wrapped in
      those spans.  Non-breaking spaces serve as separators for multiple tags.
    + Respect export option for tags (#3713).  Tags are appended to
      headlines by default, but will be omitted when the `tags` export option
      is set to nil.
    + Use `tag-name` attribute instead of `data-tag-name`.
    + Use `org-language` attribute rather than `data-org-language`.
    + Modified state type to be an instance of `HasLogMessages`, so
      `registerHeader` can issue warnings.
    + End footnotes after two blank lines.  Footnotes can not only be
      terminated by the start of a new footnote or a header, but also by two
      consecutive blank lines.
    + Update emphasis border chars (#3933).  The org reader was updated to
      match current org-mode behavior: the set of characters which are
      acceptable to occur as the first or last character in an org emphasis
      have been changed and now allows all non-whitespace chars at the
      inner border of emphasized text (see `org-emphasis-regexp-components`).

  * RST reader:

    + Fixed small bug in list parsing (#3432).  Previously the parser didn't
      handle properly this case:

          * - a
            - b
          * - c
            - d
    + Handle multiline cells in simple tables (#1166).
    + Parse list table directive (Keiichiro Shikano, #3432).
    + Make use of `anyLineNewline` (Alexander Krotov, #3686).
    + Use `anyLineNewline` in `rawListItem` (Alexander Krotov, #3702).
    + Reorganize block parsers for ~20% faster parsing.
    + Fixed `..include::` directive (#3880).
    + Handle blank lines correctly in line blocks (Alexander Krotov, #3881).
      Previously pandoc would sometimes combine two line blocks separated
      by blanks, and ignore trailing blank lines within the line block.
    + Fix indirect hyperlink targets (#512).

  * Markdown reader:

    + Allow attributes in reference links to start on next line (#3674).
    + Parse YAML metadata in a context that sees footnotes defined in
      the body of the document (#1279).
    + When splitting pipe table cells, skip tex math (#3481).
      You might have a `|` character inside math.  (Or for that matter
      something that the parser might mistake for raw HTML.)
    + Treat span with class `smallcaps` as SmallCaps.
      This allows users to specify small caps in Markdown this way:
      `[my text]{.smallcaps}` (#1592).
    + Fixed internal header links (#2397).
      This patch also adds `shortcut_reference_links` to the list
      of mmd extensions.
    + Treat certain environments as inline
      when they occur without space surrounding them (#3309, #2171).
      E.g. equation, math.  This avoids incorrect vertical space
      around equations.
    + Optimized `nonindentSpaces`.  Makes the benchmark go from 40 to 36 ms.
    + Allow latex macro definitions indented 1-3 spaces.
      Previously they only worked if nonindented.
    + Improved parsing of indented raw HTML blocks (#1841).
      Previously we inadvertently interpreted indented HTML as
      code blocks.  This was a regression.  We now seek to determine the
      indentation level of the contents of an HTML block, and (optionally)
      skip that much indentation.  As a side effect, indentation may be
      stripped off of raw HTML blocks, if `markdown_in_html_blocks` is
      used. This is better than having things interpreted as indented
      code blocks.
    + Fixed smart quotes after emphasis (#2228).  E.g. in `*foo*'s 'foo'`.
    + Warn for notes defined but not used (#1718).
    + Use `anyLineNewline` (Alexander Krotov).
    + Interpret YAML metadata as Inlines when possible (#3755).  If
      the metadata field is all on one line, we try to interpret it as
      Inlines, and only try parsing as Blocks if that fails.  If it
      extends over one line (including possibly the `|` or `>` character
      signaling an indented block), then we parse as Blocks.  This was
      motivated by some German users finding that `date: '22. Juin 2017'`
      got parsed as an ordered list.
    + Fixed spurious parsing as citation as reference def (#3840).
      We now disallow reference keys starting with `@` if the
      `citations` extension is enabled.
    + Parse `-@roe` as suppress-author citation (pandoc-citeproc#237).
      Previously only `[-@roe]` (with brackets) was recognized as
      suppress-author, and `-@roe` was treated the same as `@roe`.
    + Fixed parsing of fenced code after list when there is no intervening
      blank line (#3733).
    + Allow raw latex commands starting with `\start` (#3558).  Previously
      these weren't allowed because they were interpreted as starting
      ConTeXt environments, even without a corresponding `\stop`...
    + Added `inlines`, `inlines1`.
    + Require nonempty alt text for `implicit_figures` (#2844).
      A figure with an empty caption doesn't make sense.
    + Removed texmath macro material; now all this is handled
      in the LaTeX reader functions.
    + Fixed bug with indented code following raw LaTeX (#3947).

  * LaTeX reader:

    + Rewrote LaTeX reader with proper tokenization (#1390,
      #2118, #3236, #3779, #934, #982).  This rewrite is primarily
      motivated by the need to get macros working properly.  A side benefit
      is that the reader is significantly faster.  We now tokenize the
      input text, then parse the token stream.  Macros modify the token
      stream, so they should now be effective in any context, including
      math. Thus, we no longer need the clunky macro processing
      capacities of texmath.
    + Parse `\,` to `\8198` (six-per-em space) (Henri Werth).
    + Allow `\newcommand\foo{blah}` without braces.
    + Support `\lstinputlisting` (#2116).
    + Issue warnings when skipping unknown latex commands (#3392).
    + Include contents of `\parbox`.
    + Allow `\hspace` and `\vspace` to count as raw block or inline.
      Previously we would refuse to parse anything as raw inline if
      it was in the `blockCommands` list.  Now we allow exceptions
      if they're listed under ignoreInlines in inlineCommands.
      This should make it easier e.g. to include an `\hspace`
      between two side-by-side raw LaTeX tables.
    + Don't drop contents of `\hypertarget`.
    + Handle spaces before `\cite` arguments.
    + Allow newpage, clearpage, pagebreak in inline contexts as well as
      block contexts (#3494).
    + Treat `{{xxx}}` the same as `{xxx}` (#2115).
    + Use `pMacroDefinition` in macro (for more direct parsing).
      Note that this means that `macro` will now parse one
      macro at a time, rather than parsing a whole group together.
    + Fixed failures on `\ref{}`, `\label{}` with `+raw_tex`.  Now these
      commands are parsed as raw if `+raw_tex`; otherwise, their argument
      is parsed as a bracketed string.
    + Don't crash on empty `enumerate` environment (#3707).
    + Handle escaped `&` inside table cell (#3708).
    + Handle block structure inside table cells (#3709).  `minipage` is no
      longer required.
    + Handle some width specifiers on table columns (#3709).  Currently
      we only handle the form `0.9\linewidth`.  Anything else would have
      to be converted to a percentage, using some kind arbitrary assumptions
      about line widths.
    + Make sure `\write18` is parsed as raw LaTeX.  The change is in the
      LaTeX reader's treatment of raw commands, but it also affects the
      Markdown reader.
    + Fixed regression with starred environment names (#3803).
    + Handle optional args in raw `\titleformat` (#3804).
    + Improved heuristic for raw block/inline.  An unknown command at the
      beginning of the line that could be either block or inline is
      treated as block if we have a sequence of block commands followed by
      a newline or a `\startXXX` command (which might start a raw ConTeXt
      environment).
    + Don't remove macro definitions from the output, even if
      `Ext_latex_macros` is set, so that macros will be applied.
      Since they're only applied to math in Markdown, removing the macros
      can have bad effects.  Even for math macros, keeping them should be
      harmless.
    + Removed `macro`.  It is no longer necessary, since the
      `rawLaTeXBlock` parser will parse macro definitions.  This also avoids
      the need for a separate `latexMacro` parser in the Markdown reader.
    + Use `label` instead of `data-label` for label in caption (#3639).
    + Fixed space after `\figurename` etc.
    + Resolve references to section numbers.
    + Fix `\let\a=0` case, with single character token.
    + Allow `@` as a letter in control sequences.  `@` is commonly used
      in macros using `\makeatletter`.  Ideally we'd make the tokenizer
      sensitive to `\makeatletter` and `\makeatother`, but until then this
      seems a good change.
    + Track header numbers and correlate with labels.
    + Allow `]` inside group in option brackets (#3857).
    + lstinline with braces can be used (verb cannot be used with braces)
      (Marc Schreiber, #3535).
    + Fix keyval function: pandoc did not parse options in braces correctly
      (Marc Schreiber, #3642).
    + When parsing raw LaTeX commands, include trailing space (#1773).
      Otherwise things like `\noindent foo` break and turn into
      `\noindentfoo`.  Affects `-f latex+raw_tex` and `-f markdown` (and other
      formats that allow `raw_tex`).
    + Don't treat "..." as Quoted (#3958).  This caused quotes to be omitted in
      `\texttt` contexts.
    + Add tests for existing `\includegraphics` behaviour (Ben Firshman).
    + Allow space before `=` in bracketd options (Ben Firshman).
    + Be more forgiving in parsing command options.  This was needed, for
      example, to make some minted options work.
    + Strip off quotes in `\include` filenames.

  * Added `Text.Pandoc.CSV`, simple (unexported) CSV parser.

  * `Text.Pandoc.PDF`:

    + Got `--resource-path` working with PDF output (#852).
    + Fetch images when generating PDF via context (#3380).
      To do this, we create the temp directory as a subdirectory
      of the working directory. Since context mk IV by default looks
      for images in the parent directory, this works.
    + Use `report` instead of `warn`, make it sensitive to verbosity settings.
    + Use `fillMediaBag` and `extractMedia` to extract media to temp dir.
      This reduces code duplication.
    + `html2pdf`: use stdin instead of intermediate HTML file
    + Removed useless `TEXINPUTS` stuff for `context2pdf`.  mkiv context
      doesn't use `TEXINPUTS`.

  * `Text.Pandoc.Pretty`:

    + Simplified definition of `realLength`.
    + Don't error for blocks of size < 1.  Instead, resize to 1 (see #1785).

  * `Text.Pandoc.MIME`:

    + Use `application/javascript` (not `application/x-javascript`).
    + Added `emf` to mimeTypes with type `application/x-msmetafile` (#1713).

  * `Text.Pandoc.ImageSize`:

    + Improve SVG image size code (Marc Schreiber, #3580).
    + Make `imageSize` recognize basic SVG dimensions (Mauro Bieg, #3462).

  * Use `Control.Monad.State.Strict` throughout.  This gives 20-30% speedup
    and reduction of memory usage in most of the writers.

  * Use `foldrWithKey` instead of deprecated `foldWithKey`.

  * `Text.Pandoc.SelfContained`:

    + Fixed problem with embedded fonts (#3629).
    + Refactored getData from `getDataURI` in `SelfContained`.
    + Don't use data URIs for script or style (#3423).  Instead, just use
      script or style tags with the content inside.  The old method with
      data URIs prevents certain optimizations outside pandoc.  Exception:
      data URIs are still used when a script contains `</script>` or a
      style contains `</`.
    + SelfContained: Handle URL inside material retrieved from a URL
      (#3629).  This can happen e.g. with an @import of a google web font.
      (What is imported is some CSS which contains an url reference
      to the font itself.) Also, allow unescaped pipe (|) in URL.
    + Load resources from `data-src` (needed for lazy loading in
      reveal.js slide shows).
    + Handle `data-background-image` attribute on section (#3979).

  * `Text.Pandoc.Parsing`:

    + Added `indentWith` (Alexander Krotov, #3687).
    + Added `stateCitations` to `ParserState`.
    + Removed `stateChapters` from `ParserState`.
    + In `ParserState`, make `stateNotes'` a Map, add `stateNoteRefs`.
    + Added `gobbleSpaces` and `gobbleAtMostSpaces`.
    + Adjusted type of `insertIncludedFile` so it can be used with token
      parser.
    + Replace old texmath macro stuff from Parsing.  Use Macro from
      Text.Pandoc.Readers.LaTeX.Types instead.
    + Export `insertIncludedFile`.
    + Added `HasLogMessages`, `logMessage`, `reportLogMessages` (#3447).
    + Replace partial with total function (Albert Krewinkel).
    + Introduce `HasIncludeFiles` type class (Albert Krewinkel).  The
      `insertIncludeFile` function is generalized to work with all parser
      states which are instances of that class.
    + Add `insertIncludedFilesF` which returns F blocks (Albert Krewinkel).
      The `insertIncludeFiles` function was generalized and renamed
      to `insertIncludedFiles'`; the specialized versions are based on that.
    + `many1Till`: Check for the end condition before parsing (Herwig
      Stuetz).  By not checking for the end condition before the first
      parse, the parser was applied too often, consuming too much of the
      input. This only affects `many1Till p end` where `p` matches on a
      prefix of `end`.
    + Provide `parseFromString` (#3690).  This is a version of
      `parseFromString` specialied to ParserState, which resets
      `stateLastStrPos` at the end.  This is almost always what we want.
      This fixes a bug where `_hi_` wasn't treated as emphasis in the
      following, because pandoc got confused about the position of the
      last word: `- [o] _hi_`.
    + Added `takeP`, `takeWhileP` for efficient parsing of `[Char]`.
    + Fix `blanklines` documentation (Alexander Krotov, #3843).
    + Give less misleading line information with `parseWithString`.
      Previously positions would be reported past the end of the chunk.
      We now reset the source position within the chunk and report
      positions "in chunk."
    + Add `anyLineNewline` (Alexander Krotov).
    + Provide shared F monad functions for Markdown and Org readers
      (Albert Krewinkel).  The `F` monads used for delayed evaluation
      of certain values in the Markdown and Org readers are based on a
      shared data type capturing the common pattern of both `F` types.
    + Add `returnF` (Alexander Krotov).
    + Avoid parsing `Notes:**` as a bare URI (#3570).  This avoids parsing
      bare URIs that start with a scheme + colon + `*`, `_`, or `]`.
    + Added `readerAbbreviations` to `ParserState`.  Markdown reader
      now consults this to determine what is an abbreviation.
    + Combine grid table parsers (Albert Krewinkel, #3638).  The grid table
      parsers for markdown and rst was combined into one single
      parser `gridTable`, slightly changing parsing behavior of both
      parsers: (1) The markdown parser now compactifies block content
      cell-wise: pure text blocks in cells are now treated as paragraphs
      only if the cell contains multiple paragraphs, and as plain blocks
      otherwise. Before, this was true only for single-column tables. (2)
      The rst parser now accepts newlines and multiple blocks in header
      cells.
    + Generalize tableWith, gridTableWith (Albert Krewinkel).
      The parsing functions `tableWith` and `gridTableWith` are generalized
      to work with more parsers. The parser state only has to be an
      instance of the `HasOptions` class instead of requiring a concrete
      type. Block parsers are required to return blocks wrapped into a
      monad, as this makes it possible to use parsers returning results
      wrapped in `Future`s.

  * `Text.Pandoc.Shared`:

    + Simplify `toRomanNumeral` using guards (Alexander Krotov, #3445)
    + `stringify`: handle Quoted better (#3958).  Previously we were losing
      the quotation marks in Quoted elements.

  * `Text.Pandoc.Writers.Shared`:

    + Export `metaToJSON'`, `addVariablesToJSON` (#3439).
      This allows us to add the variables AFTER using the metadata
      to generate a YAML header (in the Markdown writer).
    + Added `unsmartify` (previously in RST writer).
      Undo literal double curly quotes.  Previously we left these.
    + Generalize type of `metaToJSON` so it can take a Text.  Previously a
      String was needed as argument; now any ToJSON instance will do.
    + Added `gridTable` (previously in Markdown writer).
    + `gridTable`: Refactored to use widths in chars.
    + `gridTable`:  remove unnecessary extra space in cells.
    + Fixed `addVariablesToJSON`.  It was previously not allowing multiple
      values to become lists.
    + Pipe tables: impose minimum cell size (see #3526).


### Default template changes

  * HTML templates (including EPUB and HTML slide show templates):

    + Make default.html5 polyglot markup conformant (John Luke Bentley,
      #3473).  Polyglot markup is HTML5 that is also valid XHTML. See
      <https://www.w3.org/TR/html-polyglot>.  With this change, pandoc's
      html5 writer creates HTML that is both valid HTML5 and valid XHTML.
    + Regularized CSS in html/epub/html slide templates (#3485).
      All templates now include `code{white-space: pre-wrap}`
      and CSS for `q` if `--html-q-tags` is used.  Previously some templates
      had `pre` and others `pre-wrap`; the `q` styles were only sometimes
      included.
    + CSS for `.smallcaps`, (Mauro Bieg, #1592)
    + `default.revealjs`: make `history` default to true.
    + `default.revealjs`: use lazy loading (#2283).
    + `default.revealjs`: add `mathjax` variable and some conditional code
      to use the MathJaX plugin.
    + `default.slidy` uses `https` instead of `http` (ickc, #3848).
    + `default.dzslides`: Load Google Font using HTTPS by default
      (Yoan Blanc).

  * DocBook5 template: Use `lang` and `subtitle` variables (Jens Getreu,
    #3855).

  * LaTeX/Beamer template:

    + Combine LaTeX/Beamer templates (Andrew Dunning, #3878).
      `default.beamer` has been removed; beamer now uses the
      `default.latex` template.  Beamer-specific parts are conditional
      on the `beamer` variable set by the writer. Note that
      `pandoc -D beamer` will return this (combined) template.
    + Use `xcolor` for `colorlinks` option (Andrew Dunning, #3877).
      Beamer loads `xcolor` rather than `color`, and thus the
      `dvipsnames` option doesn't take effect. This also provides a wider
      range of colour selections with the `svgnames` option.
    + Use starred versions of `xcolor` names (Andrew Dunning).
      Prevents changes to documents defined using the `dvipsnames` list (e.g.
      `Blue` gives a different result with svgnames enabled).
    + Load `polyglossia` after header-includes (#3898).  It needs to be
      loaded as late as possible.
    + Use `unicode-math` (Vaclav Haisman).  Use `mathspec` with only
      XeLaTeX on request.
    + Don't load `fontspec` before `unicode-math` (over there).
      The `unicode-math` package loads `fontspec` so explicit loading of
      `fontspec` before `unicode-math` is not necessary.
    + Use `unicode-math` by default in default.latex template.  mathspec will
      be used in xelatex if the `mathspec` variable is set; otherwise
      unicode-math will be used (Václav Haisman).
    + Use `dvipsnames` options when `colorlinks` specified (otherwise
      we get an error for `maroon`) (Thomas Hodgson).
    + Added beamer `titlegraphic` and `logo` variables (Thomas Hodgson).
    + Fix typo in fix for notes in tables (#2378, zeeMonkeez).
    + Fix `hyperref` options clash (Andrew Dunning, #3847) Avoids an options
      clash when loading a package (e.g. `tufte-latex`) that uses
      `hyperref` settings different from those in the template.
    + Add `natbiboptions` variable (#3768).
    + Fix links inside captions in LaTeX output with links-as-notes
      (Václav Haisman, #3651).  Declare our redefined `\href` robust.
    + Load `parskip` before `hyperref` (Václav Haisman, #3654).
    + Allow setting Japanese fonts when using LuaLaTeX (Václav Haisman,
      #3873).  by using the `luatexja-fontspec` and `luatexja-preset`
      packages. Use existing `CJKmainfont` and `CJKoptions` template
      variables. Add `luatexjafontspecoptions` for `luatexja-fontspec`
      and `luatexjapresetoptions` for `luatexja-preset`.
    + Added `aspectratio` variable to beamer template (Václav Haisman,
      #3723).
    + Modified template.latex to fix XeLaTex being used with tables
      (lwolfsonkin, #3661).  Reordered `lang` variable handling to
      immediately before `bidi`.

  * ConTeXt template: Improved font handling: `simplefonts` is now
    obsolete in ConTeXt (Pablo Rodríguez).


### Documentation improvements

  * MANUAL.txt:

    + Add URL for Prince HTML > PDF engine (Ian, #3919).
    + Document that content above slide-level will be omitted in
      slide shows.  See #3460, #2265.
    + Explain `--webtex` SVG url (Mauro Bieg, #3471)
    + Small clarification in YAML metadata section.
    + Document that html4 is technically XHTML 1.0 transitional.
    + Remove refs to highlighting-kate (#3672).
    + Document ibooks specific epub metadata.
    + Clarify that mathml is used for ODT math.
    + Mention limitations of Literate Haskell Support (#3410,
      Joachim Breitner).
    + Add documentation of limitations of grid tables (Stephen
      McDowell, #3864).
    + Clarify that meta-json contains transformed values (Jakob Voß,
      #3491) Make clear that template variable `meta-json` does not
      contain plain text values or JSON output format but field values
      transformed to the selected output format.

  * COPYRIGHT:

    + Clarify that templates are dual-licensed.
    + Clarify that pandoc-types is BSD3 licensed.
    + List new files not written by jgm (Albert Krewinkel).
    + Update dates in copyright notices (Albert Krewinkel).  This follows
      the suggestions given by the FSF for GPL licensed software.
      <https://www.gnu.org/prep/maintain/html_node/Copyright-Notices.html>

  * INSTALL.md:

    + Improved instructions for tests with patterns.
    + Put RPM-based distros on separate point (Mauro Bieg, #3449)

  * CONTRIBUTING.md:

    + Fixed typos (Wandmalfarbe, #3479).
    + Add "ask on pandoc-discuss" (Mauro Bieg).

  * Add lua filter documentation in `doc/lua-filters.md`.  Note that the
    end of this document is autogenerated from `data/pandoc.lua`
    using `make doc/lua-filters.md`, which uses `tools/ldoc.ltp`
    (Albert Krewinkel).

  * Add `doc/filters.md`. This is the old scripting tutorial from
    the website.

  * Add `doc/using-the-pandoc-api.md` (#3289).  This gives an introduction
    to using pandoc as a Haskell library.


### Build infrastructure improvements

  * Removed `data/templates` submodule.  Templates are now a subtree
    in `data/templates`.  This removes the need to do `git submodule
    update`.

  * Renamed `tests` -> `test`.

  * Remove `https` flag.  Always build with HTTPS support.

  * Use `file-embed` instead of `hsb2hs` to embed data files when
    `embed_data_files` flag is set.  `file-embed` gives us better dependency
    tracking:  if a data file changes, ghc/stack/cabal know to recompile
    the Data module.  This also removes `hsb2hs` as a build dependency.

  * Add `custom-setup` stanza to pandoc, lowercase field names.

  * Add `static` Cabal flag.

  * Name change OSX -> MacOS.  Add a -MacOS suffix to mac package rather
    than -OSX.  Changed local names from osx to macos.

  * make_macos_package.sh - Use strip to reduce executable size.

  * Revised binary linux package.  Now a completely static executable
    is created, using Docker and alpine.  We create both a deb and a
    tarball.  The old `deb` directory has been replaced with a `linux`
    directory.  Running `make` in the `linux` directory should
    perform the build, putting the binary packages in `artifacts/`.

  * `linux/control.in`: add `Replaces:`, so existing pandoc-citeproc and
    pandoc-data packages will be uninstalled; this package provides
    both (#3822).  Add latex packages as 'suggested', update
    description.

  * Remove cpphs build requirement -- it is no longer needed.

  * Replaced `{deb,macos,windows}/stack.yaml` with `stack.pkg.yaml`.

  * Name change OSX -> macOS (ickc, #3869).

  * Fix casing of Linux, UNIX, and Windows (ickc).

  * `.travis.yml`:  create a source dist and do cabal build and test there.
    That way we catch errors due to files missing from the data
    section of pandoc.cabal.

  * Makefile:

    + Split `make haddock` from `make full`.
    + Add BRANCH variable for winpkg.
    + Add `lint` target.
    + Improve `make full`. Disable optimizations.
      Build everything, inc. trypandoc and benchmarks.  Use parallel build.
    + Allow `make test` to take `TESTARGS`.

  * Added new command tests (`Tests.Command`), using small text files
    in `test/command/`.  Any files added in this directory will be treated
    as shell tests (see smart.md for an example).  This makes it very easy
    to add regression tests etc.

  * Test fixes so we can find data files.  In old tests & command tests,
    we now set the environment variable `pandoc_datadir`.  In lua tests,
    we set the datadir explicitly.

  * Refactored `compareOutput` in docx writer test.

  * Consolidated some common functions in `Tests.Helper`.

  * Small change to unbalanced bracket test to speed up test suite.

  * Speed up Native writer quickcheck tests.

  * Use tasty for tests rather than test-framework.

  * Add simple Emacs mode to help with Pandoc templates editing.
    (Václav Haisman, #3889). `tools/pandoc-template-mode.el`


## pandoc 1.19.2.4 (2017-09-10)

  * Add dependencies on texmath and skylighting to the executable.
    This is needed for dependency version numbers to be available,
    with Cabal > 2.

## pandoc 1.19.2.3 (2017-09-09)

  * Add CPP to Setup.hs so it works with Cabal >= 2 and < 2.

## pandoc 1.19.2.2 (2017-09-08)

  * Fix build with GHC 8.2.1 (#3876, Peter Simons).  Setup.hs does not
    compile with Cabal 2.x, so we require an earlier version via
    setup-depends.  The following packages need newer versions with
    GHC 8.2.1 and had their constraints relaxed accordingly:
    executable-path, process, syb, and time.

## pandoc 1.19.2.1 (2017-01-31)

  * Require skylighting >= 0.1.1.4.
  * Adjust test output for skylighting version.
  * Relax upper bounds on blaze-html and blaze-markup.

## pandoc 1.19.2 (2017-01-29)

  * Use skylighting library instead of highlighting-kate for syntax
    highlighting. Skylighting is faster and more accurate (#3363).
    Later we'll be able to add features like warning messages, dynamic
    loading of xml syntax definitions, and dynamic loading of themes.

  * Added a new highlight style, `breezeDark`.

  * Text.Pandoc.Highlighting: Update list of `listings` languages (#3374).
    This allows more languages to be used when using the `--listings`
    option.

  * OpenDocument writer:

    + Small refactoring.  Removed separate 'parent' parameter in paraStyle.
    + Don't profilerate text styles unnecessarily (#3371).
      This change makes the writer create only as many temporary
      text styles as are absolutely necessary. It also consolidates
      adjacent nodes with the same style.

  * Org reader (Albert Krewinkel):

    + Allow short hand for single-line raw blocks (Albert Krewinkel,
      #3366).  Single-line raw blocks can be given via `#+FORMAT: raw line`,
      where `FORMAT` must be one of `latex`, `beamer`, `html`, or `texinfo`.
    + Accept org-ref citations followed by commas (Albert Krewinkel).
      Bugfix for an issue which, whenever the citation was immediately
      followed by a comma, prevented correct parsing of org-ref citations.
    + Ensure emphasis markup can be nested.  Nested emphasis markup (e.g.
      `/*strong and emphasized*/`) was interpreted incorrectly in that the
      inner markup was not recognized.
    + Remove pipe char irking the haddock coverage tool (Albert Krewinkel).

  * Docx reader: Empty header should be list of lists (Jesse Rosenthal).
    In the past, the docx reader wrote an empty header as an empty list. It
    should have the same width as a row (and be filled with empty cells).

  * MediaWiki reader:

    + Improved handling of display math (#3362).  Sometimes display math is
      indented with more than one colon.  Previously we handled these cases
      badly, generating definition lists and missing the math.
    + Fix quotation mark parsing (#3336, tgkokk).  Change MediaWiki reader's
      behavior when the smart option is parsed to match other readers'
      behavior.

  * Markdown reader:

    + Fixed `-f markdown_github-hard_line_breaks+escaped_line_breaks`
      (#3341).  Previously this did not properly enable escaped line breaks.
    + Disallow space between inline code and attributes (#3326, #3323,
      Mauro Bieg).

  * DocBook5 writer: make id attribute xml:id, fixes #3329 (#3330, Mauro Bieg).

  * Added some test cases for ODT reader (#3306, #3308, Hubert Plociniczak).

  * LaTeX writer: allow tables with empty cells to count as "plain."
    This addresses a problem of too-wide tables when empty cells
    are used.  Thanks to Joost Kremers for reporting the issue.

  * Org writer: prefix footnote numbers with `fn:` (Albert Krewinkel).
    Unprefixed numbers where used by older org-mode versions, but are no
    longer supported.

  * HTML writer: don't process pars with empty RawInline, (#1040, #3327,
    Mauro Bieg).

  * Markdown writer: Fix display math with `--webtex` (#3298).

  * Fix sample.lua so it properly handles raw blocks/inlines (#3358,
    bumper314).

  * Templates:

    + default.latex: Moved geometry after hyperref (Václav Haisman).
      Otherwise PDF sizes can be wrong in some circumstances.
    + Copied a few changes from default.latex to default.beamer
      (Wandmalfarbe).
    + default.latex, default.beamer: Changed position of `\VerbatimNotes`
      and `fancyvrb`.  This fixes hyperlinks on footnotes in documents
      that contain verbatim in notes (#3361).  (Note: the beamer template
      was updated to match the LaTeX template, but at this point verbatim
      in notes seems not to work in beamer.)
    + default.latex: Allow passing `microtypeoptions` to microtype
      (Václav Haisman).
    + default.latex: Add hyphen option to url package.
    + default.docbook5: Fix namespace declarations (Mauro Bieg).

  * Moved `make_osx_package.sh` to `osx/` directory.

  * Travis continuous integration:

    + Fix false positives with dist build.
    + Speed improvements (Kolen Cheung, #3304, #3357).

  * MANUAL.txt:

    + Clarify that blank space is needed around footnotes (#3352).
    + Fixed typo (#3351, Alexey Rogechev).
    + Note that `--wrap=auto` does not work in HTML output.
    + Default `--columns` width is 72, not 80.
    + Fixed broken links (#3316, Kolen Cheung).
    + Document usage of `@*` in nocite section (#3333, John Muccigrosso).

  * INSTALL.md:

    + Indent code so it's properly formatted (#3335, Bheesham Persaud).
    + Added instructions for extracting binary from OSX, Windows packages.

  * CONTRIBUTING.md: Describe labels currently used in issue tracker
    (Albert Krewinkel).  The labels have changed over time, the list of
    labels is updated to reflect the current set of labels used in the
    issue tracker.

  * Rearrange and extend badges in README (Albert Krewinkel, #3354)

  * Bumped version bounds for dependencies.


## pandoc 1.19.1 (2016-12-10)

  * Set `PANDOC_VERSION` environment variable for filters (#2640).
    This allows filters to check the pandoc version that produced
    the JSON they are receiving.

  * Docx reader: Ensure one-row tables don't have header (#3285,
    Jesse Rosenthal).  Tables in MS Word are set by default to have
    special first-row formatting, which pandoc uses to determine whether
    or not they have a header. This means that one-row tables will, by
    default, have only a header -- which we imagine is not what people
    want. This change ensures that a one-row table is not understood to
    be a header only.  Note that this means that it is impossible to
    produce a header-only table from docx, even though it is legal
    pandoc. But we believe that in nearly all cases, it will be an
    accidental (and unwelcome) result

  * HTML reader:

    + Fixed some bad regressions in HTML table parser (#3280).
      This regression leads to the introduction of empty rows
      in some circumstances.
    + Understand `style=width:` as well as `width` in `col` (#3286).

  * RST reader:

    + Print warnings when keys, substitition, notes not found.
      Previously the parsers failed and we got raw text.  Now we get a
      link with an empty URL, or empty inlines in the case of a note or
      substitution.

    + Fix hyperlink aliases (#3283).

  * Man writer: Ensure that periods are escaped at beginning of line
    (#3270).

  * LaTeX writer: Fix unnumbered headers when used with `--top-level`
    (#3272, Albert Krewinkel). Fix interaction of top-level
    divisions `part` or `chapter` with unnumbered headers when
    emitting LaTeX. Headers are ensured to be written using
    stared commands (like `\subsection*{}`).

  * LaTeX template: use comma not semicolon to separate keywords for
    `pdfkeywords`.  Thanks to Wandmalfarbe.

  * Markdown writer: Fixed incorrect word wrapping (#3277).
    Previously pandoc would sometimes wrap lines too early due to
    this bug.

  * Text.Pandoc.Pretty:  Added `afterBreak` [API change].  This makes it
    possible to insert escape codes for content that needs escaping at the
    beginning of a line.

  * Removed old MathMLInHTML.js from 2004, which should no longer
    be needed for MathML with modern browsers.

  * Fixed tests with dynamic linking (#2709).

  * Makefile: Use stack instead of cabal for targets.  This is just
    a convenience for developers.

  * Fixed bash completion of filenames with space (#2749).

  * MANUAL: improved documentation on how to create a custom
    `reference.docx`.

  * Fix minor spelling typos in the manual (#3273, Anthony Geoghegan)

## pandoc 1.19 (2016-12-01)

  * Changed resolution of filter paths.

    + We now first treat the argument of `--filter` as a full (absolute
      or relative) path, looking for a program there. If it's found, we
      run it.
    + If not, and if it is a simple program name or a relative path, we
      try resolving it relative to `$DATADIR/filters`.
    + If this fails, then we treat it as a program name and look in the
      user's PATH.
    + Removed a hardcoded '/' that may have caused problems with
      Windows paths.

    Previously if you did `--filter foo` and you had `foo` in your path and
    also an executable `foo` in your working directory, the one in the path
    would be used. Now the one in the working directory is used.

    In addition, when you do `--filter foo/bar.hs`, pandoc will now find a
    filter `$DATADIR/filters/foo/bar.hs` -- assuming there isn't a
    `foo/bar.hs` relative to the working directory.

  * Allow `file://` URIs as arguments (#3196). Also improved default reader
    format detection. Previously with a URI ending in .md or .markdown,
    pandoc would assume HTML input. Now it treats these as markdown.

  * Allow to overwrite top-level division type heuristics (#3258,
    Albert Krewinkel). Pandoc uses heuristics to determine the most
    reasonable top-level division type when emitting LaTeX or
    Docbook markup. It is now possible to overwrite this implicitly set
    top-level division via the `top-level-division` command line parameter.

  * Text.Pandoc.Options \[API changes\]:

    + Removed `writerStandalone` field in `WriterOptions`, made
      `writerTemplate` a `Maybe` value. Previously setting
      `writerStandalone = True` did nothing unless a template was provided
      in writerTemplate. Now a fragment will be generated if
      `writerTemplate` is `Nothing`; otherwise, the specified template
      will be used and standalone output generated.
    + `Division` has been renamed `TopLevelDivision` (#3197). The
      `Section`, `Chapter`, and `Part` constructors were renamed to
      `TopLevelSection`, `TopLevelChapter`, and
      `TopLevelPart`, respectively. An additional `TopLevelDefault`
      constructor was added, which is now also the new default value of
      the `writerTopLevelDivision` field in `WriterOptions`.

  * Improved error if they give wrong arg to `--top-level-division`.

  * Use new module from texmath to lookup MS font codepoints in Docx reader.
    Removed unexported module Text.Pandoc.Readers.Docx.Fonts. Its code now
    lives in texmath (0.9).

  * DocBook reader: Fixed xref lookup (#3243). It previously only worked
    when the qnames lacked the docbook namespace URI.

  * HTML reader:

    + Improved table parsing (#3027). We now check explicitly for non-1
      rowspan or colspan attributes, and fail when we encounter them.
      Previously we checked that each row had the same number of cells,
      but that could be true even with rowspans/colspans. And there are
      cases where it isn't true in tables that we can handle fine -- e.g.
      when a tr element is empty. So now we just pad rows with empty cells
      when needed.
    + Treat `<math>` as MathML by default unless something else is
      explicitly specified in xmlns. Provided it parses as MathML,
      of course. Also fixed default which should be to inline math if no
      display attribute is used.
    + Only treat "a" element as link if it has href (#3226). Otherwise
      treat as span.

  * Docx reader (Jesse Rosenthal):

    + Add a placeholder value for CHART. We wrap `[CHART]` in a
      `<span class="chart">`. Note that it maps to inlines because, in
      docx, anything in a drawing tag can be part of a larger paragraph.
    + Be more specific in parsing images We not only want `w:drawing`,
      because that could also include charts. Now we specify
      `w:drawing/pic:pic`. This shouldn't change behavior at all, but it's
      a first step toward allowing other sorts of drawing data as well.
    + Abstract out function to avoid code repetition.
    + Update tests for img title and alt (#3204).
    + Handle Alt text and titles in images. We use the "description" field
      as alt text and the "title" field as title. These can be accessed
      through the "Format Picture" dialog in Word.
    + Docx reader utils: handle empty namespace in `elemName`. Previously,
      if given an empty namespace `(elemName ns "" "foo")` `elemName`
      would output a QName with a `Just ""` namespace. This is never what
      we want. Now we output a `Nothing`. If someone *does* want a
      `Just ""` in the namespace, they can enter the QName
      value explicitly.

  * ODT reader/writer:

    + Inline code when text has a special style (Hubert Plociniczak). When
      a piece of text has a text `Source_Text` then we assume that this is
      a piece of the document that represents a code that needs to
      be inlined. Adapted the writer to also reflect that change.
      Previously it was just writing a 'preformatted' text using a
      non-distinguishable font style. Code blocks are still not recognized
      by the ODT reader. That's a separate issue.
    + Infer table's caption from the paragraph (#3224,
      Hubert Plociniczak). ODT's reader always put empty captions for the
      parsed tables. This commit

        1.  checks paragraphs that follow the table definition
        2.  treats specially a paragraph with a style named 'Table'
        3.  does some postprocessing of the paragraphs that combines tables
            followed immediately by captions

      The ODT writer used the `TableCaption` style for the caption
      paragraph.  This commit follows the OpenOffice approach which allows
      for appending captions to table but uses a built-in style named
      `Table` instead of `TableCaption`. Users of a custom `reference.odt`
      should change the style's name from `TableCaption` to `Table`.

  * ODT reader: Infer tables' header props from rows (#3199,
    Hubert Plociniczak). ODT reader simply provided an empty header list
    which meant that the contents of the whole table, even if not empty, was
    simply ignored. While we still do not infer headers we at least have to
    provide default properties of columns.

  * Markdown reader:

    +   Allow reference link labels starting with `@...` if `citations`
        extension disabled (#3209). Example: in

            \[link text\]\[@a\]

        `link text` isn't hyperlinked because `[@a]` is parsed as
        a citation. Previously this happened whether or not the `citations`
        extension was enabled. Now it happens only if the `citations`
        extension is enabled.
    +   Allow alignments to be specified in Markdown grid tables. For
        example,

            +-------+---------------+--------------------+
            | Right    | Left                 | Centered |
            +=========:+:=================+:=============:+
            | Bananas | $1.34         | built-in wrapper |
            +-------+---------------+--------------------+

    +   Allow Small Caps elements to be created using bracketed spans (as
        they already can be using HTML-syntax spans) (#3191, Kolen Cheung).

  * LaTeX reader:

    + Don't treat `\vspace` and `\hspace` as block commands (#3256).
      Fixed an error which came up, for example, with `\vspace` inside
      a caption. (Captions expect inlines.)
    + Improved table handling. We can now parse all of the tables emitted
      by pandoc in our tests. The only thing we don't get yet are
      alignments and column widths in more complex tables. See #2669.
    + Limited support for minipage.
    + Allow for `[]`s inside LaTeX optional args. Fixes cases like:
    + Handle BVerbatim from fancyvrb (#3203).
    + Handle hungarumlaut (#3201).
    + Allow beamer-style `<...>` options in raw LaTeX (also in Markdown)
      (#3184). This allows use of things like `\only<2,3>{my content}` in
      Markdown that is going to be converted to beamer.

  * Use pre-wrap for code in dzslides template (Nicolas Porcel). Otherwise
    overly long code will appear on every slide.

  * Org reader (Albert Krewinkel):

    +   Respect column width settings (#3246). Table column properties can
        optionally specify a column's width with which it is displayed in
        the buffer. Some exporters, notably the ODT exporter in org-mode
        v9.0, use these values to calculate relative column widths. The org
        reader now implements the same behavior. Note that the org-mode
        LaTeX and HTML exporters in Emacs don't support this feature yet,
        which should be kept in mind by users who use the column
        widths parameters.
    +   Allow HTML attribs on non-figure images (#3222). Images which are
        the only element in a paragraph can still be given HTML attributes,
        even if the image does not have a caption and is hence not a figure.
        The following will add set the `width` attribute of the image to
        `50%`:

            +ATTR\_HTML: :width 50%
            =======================

            \[\[file:image.jpg\]\]

    +   Support `ATTR_HTML` for special blocks (#3182). Special
        blocks (i.e. blocks with unrecognized names) can be prefixed with an
        `ATTR_HTML` block attribute. The attributes defined in that
        meta-directive are added to the `Div` which is used to represent the
        special block.
    +   Support the `todo` export option. The `todo` export option allows to
        toggle the inclusion of TODO keywords in the output. Setting this to
        `nil` causes TODO keywords to be dropped from headlines. The default
        is to include the keywords.
    +   Add support for todo-markers. Headlines can have optional
        todo-markers which can be controlled via the `#+TODO`, `#+SEQ_TODO`,
        or `#+TYP_TODO` meta directive. Multiple such directives can be
        given, each adding a new set of recognized todo-markers. If no
        custom todo-markers are defined, the default `TODO` and `DONE`
        markers are used. Todo-markers are conceptually separate from
        headline text and are hence excluded when autogenerating
        headline IDs. The markers are rendered as spans and labelled with
        two classes: One class is the markers name, the other signals the
        todo-state of the marker (either `todo` or `done`).

  * LaTeX writer:

    + Use `\autocites*` when "suppress-author" citation used.
    + Ensure that simple tables have simple cells (#2666). If cells
      contain more than a single Plain or Para, then we need to set
      nonzero widths and put contents into minipages.
    + Remove invalid inlines in sections (#3218, Hubert Plociniczak).

  * Markdown writer:

    + Fix calculation of column widths for aligned multiline tables
      (#1911, Björn Peemöller). This also fixes excessive CPU and memory
      usage for tables when `--columns` is set in such a way that cells
      must be very tiny. Now cells are guaranteed to be big enough so that
      single words don't need to line break, even if this pushes the line
      length above the column width.
    + Use bracketed form for native spans when `bracketed_spans`
      enabled (#3229).
    + Fixed inconsistent spacing issue (#3232). Previously a tight bullet
      sublist got rendered with a blank line after, while a tight ordered
      sublist did not. Now we don't get the blank line in either case.
    + Fix escaping of spaces in super/subscript (#3225). Previously two
      backslashes were inserted, which gave a literal backslash.
    + Adjust widths in Markdown grid tables so that they match
      on round-trip.

  * Docx writer:

    + Give full detail when there are errors converting tex math.
    + Handle title text in images (Jesse Rosenthal). We already handled
      alt text. This just puts the image "title" into the docx
      "title" attr.
    + Fixed XML markup for empty cells (#3238). Previously the Compact
      style wasn't being applied properly to empty cells.

  * HTML writer:

    + Updated `renderHtml` import from blaze-html.

  * Text.Pandoc.Pretty:

    + Fixed some bugs that caused blank lines in tables (#3251). The bugs
      caused spurious blank lines in grid tables when we had things like
      `blankline $$ blankline`.
    + Add exported function `minOffet` \[API change\] (Björn Peemöller).
    + Added error message for illegal call to `block` (Björn Peemöller).

  * Text.Pandoc.Shared:

    + Put `warn` in MonadIO.
    + `fetchItem`: Better handling of protocol-relative URL (#2635). If
      URL starts with `//` and there is no "base URL" (as there would be
      if a URL were used on the command line), then default to http:.

  * Export Text.Pandoc.getDefaultExtensions \[API change\] (#3178).

  * In --version, trap error in `getAppUserDataDirectory` (#3241). This
    fixes a crash with `pandoc --version` on unusual systems with no real
    user (e.g. SQL Server 2016).

  * Added weigh-pandoc for memory usage diagnostics (#3169).

  * Use correct mime types for woff and woff2 (#3228).

  * Remove make\_travis\_yml.hs (#3235, Kolen Cheung).

  * changelog: Moved an item that was misplaced in the 1.17.2 section to the
    1.18 section where it belongs.

  * CONTRIBUTING.md: minor change in wording and punctuation (#3252,
    Kolen Cheung).

  * Further revisions to manual for `--version` changes (#3244).



## pandoc 1.18 (2016-10-26)

  * Added `--list-input-formats`, `--list-output-formats`,
    `--list-extensions`, `--list-highlight-languages`, and
    `--list-highlight-styles` (#3173).  Removed list of highlighting
    languages from `--version` output.  Removed list of input and output
    formats from default `--help` output.

  * Added `--reference-location=block|section|document` option
    (Jesse Rosenthal).  This determines whether Markdown link references
    and footnotes are placed at the end of the document, the end of the
    section, or the end of the top-level block.

  * Added `--top-level-division=section|chapter|part` (Albert Krewinkel).
    This determines what a level-1 header corresponds to in LaTeX,
    ConTeXt, DocBook, and TEI output.  The default is `section`.
    The `--chapters` option has been deprecated in favor of
    `--top-level-division=chapter`.

  * Added `LineBlock` constructor for `Block` (Albert Krewinkel).  This
    is now used in parsing RST and Markdown line blocks, DocBook
    `linegroup`/`line` combinations, and Org-mode `VERSE` blocks.
    Previously `Para` blocks with hard linebreaks were used.  `LineBlock`s
    are handled specially in the following output formats: AsciiDoc
    (as `[verse]` blocks), ConTeXt (`\startlines`/`\endlines`),
    HTML (`div` with a style), Markdown (line blocks if `line_blocks`
    is enabled), Org-mode (`VERSE` blocks), RST (line blocks). In
    other output formats, a paragraph with hard linebreaks is emitted.

  * Allow binary formats to be written to stdout (but not to tty) (#2677).
    Only works on posix, since we use the unix library to check whether
    output is to tty.  On Windows, pandoc works as before and always requires
    an output file parameter for binary formats.

  * Changed JSON output format (Jesse Rosenthal).  Previously we used
    generically generated JSON, but this was subject to change depending
    on the version of aeson pandoc was compiled with.  To ensure stability,
    we switched to using manually written ToJSON and FromJSON
    instances, and encoding the API version.  **Note:**  pandoc filter
    libraries will need to be revised to handle the format change.
    Here is a summary of the essential changes:

    + The toplevel JSON format is now `{"pandoc-api-version" :
      [MAJ, MIN, REV], "meta" : META, "blocks": BLOCKS}`
      instead of `[{"unMeta": META}, [BLOCKS]]`.
      Decoding fails if the major and minor version numbers don't
      match.
    + Leaf nodes no longer have an empty array for their "c" value.
      Thus, for example, a `Space` is encoded as `{"t":"Space"}`
      rather than `{"t":"Space","c":[]}` as before.

  * Removed `tests/Tests/Arbitrary.hs` and added a `Text.Pandoc.Arbitrary`
    module to pandoc-types (Jesse Rosenthal).  This makes it easier
    to use QuickCheck with pandoc types outside of pandoc itself.

  * Add `bracketed_spans` Markdown extension, enabled by default
    in pandoc `markdown`.  This allows you to create a native span
    using this syntax:  `[Here is my span]{#id .class key="val"}`.

  * Added `angle_brackets_escapable` Markdown extension (#2846).
    This is needed because github flavored Markdown has a slightly
    different set of escapable symbols than original Markdown;
    it includes angle brackets.

  * Export `Text.Pandoc.Error` in `Text.Pandoc` [API change].

  * Print highlighting-kate version in `--version`.

  * `Text.Pandoc.Options`:

    + `Extension` has new constructors `Ext_brackted_spans` and
      `Ext_angle_brackets_escapable` [API change].
    + Added `ReferenceLocation` type [API change] (Jesse Rosenthal).
    + Added `writerReferenceLocation` field to `WriterOptions` (Jesse
      Rosenthal).

  * `--filter`:  we now check `$DATADIR/filters` for filters before
    looking in the path (#3127, Jesse Rosenthal, thanks to Jakob
    Voß for the idea).  Filters placed in this directory need not
    be executable; if the extension is `.hs`, `.php`, `.pl`, `.js`,
    or `.rb`, pandoc will run the right interpreter.

  * For `--webtex`, replace deprecated Google Chart API by CodeCogs as
    default (Kolen Cheung).

  * Removed `raw_tex` extension from `markdown_mmd` defaults (Kolen Cheung).

  * Execute .js filters with node (Jakob Voß).

  * Textile reader:

    + Support `bc..` extended code blocks (#3037).  Also, remove trailing
      newline in code blocks (consistently with Markdown reader).
    + Improve table parsing.  We now handle cell and row attributes, mostly
      by skipping them.  However, alignments are now handled properly.
      Since in pandoc alignment is per-column, not per-cell, we
      try to devine column alignments from cell alignments.
      Table captions are also now parsed, and textile indicators
      for thead and tfoot no longer cause parse failure.  (However,
      a row designated as tfoot will just be a regular row in pandoc.)
    + Improve definition list parsing.  We now allow multiple terms
      (which we concatenate with linebreaks).  An exponential parsing
      bug (#3020) is also fixed.
    + Disallow empty URL in explicit link (#3036).

  * RST reader:

    + Use Div instead of BlockQuote for admonitions (#3031).
      The Div has class `admonition` and (if relevant) one of the
      following:  `attention`, `caution`, `danger`, `error`, `hint`,
      `important`, `note`, `tip`, `warning`.  **Note:** This will change
      the rendering of some RST documents!  The word ("Warning", "Attention",
      etc.) is no longer added; that must be done with CSS or a filter.
    + A Div is now used for `sidebar` as well.
    + Skip whitespace before note (Jesse Rosenthal, #3163).  RST requires a
      space before a footnote marker. We discard those spaces so that footnotes
      will be adjacent to the text that comes before it. This is in line with
      what rst2latex does.
    + Allow empty lines when parsing line blocks (Albert Krewinkel).

  * Markdown reader:

    + Allow empty lines when parsing line blocks (Albert Krewinkel).
    + Allow attributes on autolinks (#3183, Daniele D'Orazio).

  * LaTeX reader:

    + More robust parsing of unknown environments (#3026).
      We no longer fail on things like `^` inside options for tikz.
    + Be more forgiving of non-standard characters, e.g. `^` outside of math.
      Some custom environments give these a meaning, so we should try not to
      fall over when we encounter them.
    + Drop duplicate `*` in bibtexKeyChars (Albert Krewinkel)

  * MediaWiki reader:

    + Fix for unquoted attribute values in mediawiki tables (#3053).
      Previously an unquoted attribute value in a table row
      could cause parsing problems.
    + Improved treatment of verbatim constructions (#3055).
      Previously these yielded strings of alternating Code and Space
      elements; we now incorporate the spaces into the Code.  Emphasis
      etc. is still possible inside these.
    + Properly interpret XML tags in pre environments (#3042).  They are meant
      to be interpreted as literal text.

  * EPUB reader:  don't add root path to data: URIs (#3150).
    Thanks to @lep for the bug report and patch.

  * Org reader (Albert Krewinkel):

    + Preserve indentation of verse lines (#3064).  Leading spaces in verse
      lines are converted to non-breaking spaces, so indentation is preserved.
    + Ensure image sources are proper links.  Image sources as those in plain
      images, image links, or figures, must be proper URIs or relative file
      paths to be recognized as images.  This restriction is now enforced
      for all image sources.  This also fixes the reader's usage of uncleaned
      image sources, leading to `file:` prefixes not being deleted from
      figure images.  Thanks to @bsag for noticing this bug.
    + Trim verse lines properly (Albert Krewinkel).
    + Extract meta parsing code to module.  Parsing of meta-data is well
      separable from other block parsing tasks.  Moving into new module to
      get small files and clearly arranged code.
    + Read markup only for special meta keys.  Most meta-keys should be read
      as normal string values, only a few are interpreted as marked-up text.
    + Allow multiple, comma-separated authors.  Multiple authors can be
      specified in the `#+AUTHOR` meta line if they are given as a
      comma-separated list.
    + Give precedence to later meta lines.  The last meta-line of any given
      type is the significant line.  Previously the value of the first line
      was kept, even if more lines of the same type were encountered.
    + Read LaTeX_header as header-includes.  LaTeX-specific header commands
      can be defined in `#+LaTeX_header` lines.  They are parsed as
      format-specific inlines to ensure that they will only show up in LaTeX
      output.
    + Set documentclass meta from LaTeX_class.
    + Set classoption meta from LaTeX_class_options.
    + Read HTML_head as header-includes.  HTML-specific head content can be
      defined in `#+HTML_head` lines.  They are parsed as format-specific
      inlines to ensure that they will only show up in HTML output.
    + Respect `author` export option.  The `author` option controls whether
      the author should be included in the final markup.  Setting
      `#+OPTIONS: author:nil` will drop the author from the final meta-data
      output.
    + Respect `email` export option.  The `email` option controls whether the
      email meta-field should be included in the final markup. Setting
      `#+OPTIONS: email:nil` will drop the email field from the final
      meta-data output.
    + Respect `creator` export option.  The `creator` option controls whether
      the creator meta-field should be included in the final markup.  Setting
      `#+OPTIONS: creator:nil` will drop the creator field from the final
      meta-data output.  Org-mode recognizes the special value `comment` for
      this field, causing the creator to be included in a comment.  This is
      difficult to translate to Pandoc internals and is hence interpreted the
      same as other truish values (i.e. the meta field is kept if it's
      present).
    + Respect unnumbered header property (#3095).  Sections the `unnumbered`
      property should, as the name implies, be excluded from the automatic
      numbering of section provided by some output formats.  The Pandoc
      convention for this is to add an "unnumbered" class to the header.  The
      reader treats properties as key-value pairs per default, so a special
      case is added to translate the above property to a class instead.
    + Allow figure with empty caption (Albert Krewinkel, #3161).
      A `#+CAPTION` attribute before an image is enough to turn an image into
      a figure. This wasn't the case because the `parseFromString` function,
      which processes the caption value, would fail on empty values. Adding
      a newline character to the caption value fixes this.

  * Docx reader:

    + Use XML convenience functions (Jesse Rosenthal).
      The functions `isElem` and `elemName` (defined in Docx/Util.hs) make
      the code a lot cleaner than the original XML.Light functions, but they
      had been used inconsistently. This puts them in wherever applicable.
    + Handle anchor spans with content in headers.  Previously, we would only
      be able to figure out internal links to a header in a docx if the
      anchor span was empty. We change that to read the inlines out of the
      first anchor span in a header.
    + Let headers use existing id.  Previously we always generated an id for
      headers (since they wouldn't bring one from Docx). Now we let it use an
      existing one if possible. This should allow us to recurs through anchor
      spans.
    + Use all anchor spans for header ids.  Previously we only used the first
      anchor span to affect header ids. This allows us to use all the anchor
      spans in a header, whether they're nested or not (#3088).
    + Test for nested anchor spans in header.  This ensures that anchor spans
      in header with content (or with other anchor spans inside) will resolve
      to links to a header id properly.

  * ODT reader (Hubert Plociniczak)

    + Include list's starting value.  Previously the starting value of
      the lists' items has been hardcoded to 1. In reality ODT's list
      style definition can provide a new starting value in one of its
      attributes.
    + Infer caption from the text following the image.
      Frame can contain other frames with the text boxes.
    + Add `fig:` to title for Image with a caption (as expected
      by pandoc's writers).
    + Basic support for images in ODT documents.
    + Don't duplicate text for anchors (#3143).  When creating an anchor
      element we were adding its representation as well as the original
      content, leading to text duplication.

  * DocBook writer:

    + Include an anchor element when a div or span has an id (#3102).
      Note that DocBook does not have a class attribute, but at least this
      provides an anchor for internal links.

  * LaTeX writer:

    + Don't use * for unnumbered paragraph, subparagraph.  The starred
      variants don't exist.  This helps with part of #3058...it gets rid of
      the spurious `*`s.  But we still have numbers on the 4th and 5th level
      headers.
    + Properly escape backticks in verbatim (#3121, Jesse Rosenthal).
      Otherwise they can cause unintended ligatures like `` ?` ``.
    + Handle NARRAOW NO-BREAK SPACE into LaTeX (Vaclav Zeman) as `\,`.
    + Don't include `[htbp]` placement for figures (#3103, Václav Haisman).
      This allows figure placement defaults to be changed by the user
      in the template.

  * TEI writer: remove heuristic to detect book template (Albert Krewinkel).
    TEI doesn't have `<book>` elements but only generic `<divN>` division
    elements. Checking the template for a trailing `</book>` is nonsensical.

  * MediaWiki writer:  transform filename with underscores in images (#3052).
    `foo bar.jpg` becomes `foo_bar.jpg`. This was already done
    for internal links, but it also needs to happen for images.

  * ICML writer: replace partial function (!!) in table handling (#3175,
    Mauro Bieg).

  * Man writer: allow section numbers that are not a single digit (#3089).

  * AsciiDoc writer: avoid unnecessary use of "unconstrained" emphasis
    (#3068).  In AsciiDoc, you must use a special form of emphasis
    (double `__`) for intraword emphasis.  Pandoc was previously using
    this more than necessary.

  * EPUB writer:  use stringify instead of plain writer for metadata
    (#3066).  This means that underscores won't be used for emphasis,
    or CAPS for bold.  The metadata fields will just have unadorned
    text.

  * Docx Writer:

    + Implement user-defined styles (Jesse Rosenthal).  Divs and Spans
      with a `custom-style` key in the attributes will apply the corresponding
      key to the contained blocks or inlines.
    + Add ReaderT env to the docx writer (Jesse Rosenthal).
    + Clean up and streamline RTL behavior (Jesse Rosenthal, #3140).
      You can set `dir: rtl` in YAML metadata, or use `-M dir=rtl`
      on the command line.  For finer-grained control, you can set
      the `dir` attribute in Div or Span elements.

  * Org writer (Albert Krewinkel):

    + Remove blank line after figure caption.  Org-mode only treats an image
      as a figure if it is directly preceded by a caption.
    + Ensure blank line after figure.  An Org-mode figure should be surrounded
      by blank lines.  The figure would be recognized regardless, but images
      in the following line would unintentionally be treated as figures as
      well.
    + Ensure link targets are paths or URLs.  Org-mode treats links as
      document internal searches unless the link target looks like a URL or
      file path, either relative or absolute.  This change ensures that this
      is always the case.
    + Translate language identifiers.  Pandoc and Org-mode use different
      programming language identifiers.  An additional translation between
      those identifiers is added to avoid unexpected behavior.  This fixes a
      problem where language specific source code would sometimes be output
      as example code.
    + Drop space before footnote markers (Albert Krewinkel, #3162).
      The writer no longer adds an extra space before footnote markers.

  * Markdown writer:

    + Don't emit HTML for tables unless `raw_html` extension is set (#3154).
      Emit `[TABLE]` if no suitable table formats are enabled and raw HTML
      is disabled.
    + Check for the `raw_html` extension before emitting a raw HTML block.
    + Abstract out note/ref function (Jesse Rosenthal).
    + Add ReaderT monad for environment variables (Jesse Rosenthal).

  * HTML, EPUB, slidy, revealjs templates: Use `<p>` instead of `<h1>` for
    subtitle, author, date (#3119).  Note that, as a result of this change,
    authors may need to update CSS.

  * revealjs template:  Added `notes-server` option
    (jgm/pandoc-templates#212, Yoan Blanc).

  * Beamer template:

    + Restore whitespace between paragraphs. This was
      a regression in the last release (jgm/pandoc-templates#207).
    + Added `themeoptions` variable (Carsten Gips).
    + Added `beamerarticle` variable.  This causes the `beamerarticle`
      package to be loaded in beamer, to produce an article from beamer
      slides.  (Carsten Gips)
    + Added support for `fontfamilies` structured variable
      (Artem Klevtsov).
    + Added hypersetup options (Jake Zimmerman).

  * LaTeX template:

    + Added dummy definition for `\institute`.
      This isn't a standard command, and we want to avoid a crash when
      `institute` is used with the default template.
    + Define default figure placement (Václav Haisman), since pandoc
      no longer includes `[htbp]` for figures.  Users with custom templates
      will want to add this. See #3103.
    + Use footnote package to fix notes in tables (jgm/pandoc-templates#208,
      Václav Haisman).

  * Moved template compiling/rendering code to a separate library.
    `doctemplates`.  This allows the pandoc templating system to be
    used independently.

  * Text.Pandoc.Error: Fix out of index error in `handleError`
    (Matthew Pickering).  The fix is to not try to show the exact line when
    it would cause an out-of-bounds error as a result of included files.

  * Text.Pandoc.Shared: Add `linesToBlock` function (Albert Krewinkel).

  * Text.Pandoc.Parsing.emailAddress: tighten up parsing of email
    addresses.  Technically `**@user` is a valid email address, but if we
    allow things like this, we get bad results in markdown flavors
    that autolink raw email addresses (see #2940).  So we exclude a few
    valid email addresses in order to avoid these more common bad cases.

  * Text.Pandoc.PDF:  Don't crash with nonexistent image (#3100).  Instead,
    emit the alt text, emphasized.  This accords with what the ODT writer
    currently does.  The user will still get a warning about a nonexistent
    image.

  * Fix example in API documentation (#3176, Thomas Weißschuh).

  * Tell where to get tarball in INSTALL (#3062).

  * Rename README to MANUAL.txt and add GitHub-friendly README.md
    (Albert Krewinkel, Kolen Cheung).

  * Replace COPYING with Markdown version COPYING.md from GNU (Kolen Cheung).

  * MANUAL.txt:

    + Put note on structured vars in separate paragraph (#2148, Albert
      Krewinkel).  Make it clearer that structured author variables require a
      custom template
    + Note that `--katex` works best with `html5` (#3077).
    + Fix the LaTeX and EPUB links in manual (Morton Fox).
    + Document `biblio-title` variable.

  * Improve spacing of footnotes in `--help` output (Waldir Pimenta).

  * Update KaTeX to v0.6.0 (Kolen Cheung).

  * Allow latest dependencies.

  * Use texmath 0.8.6.6 (#3040).

  * Allow http-client 0.4.30, which is the version in stackage lts.
    Previously we required 0.5.
    Remove CPP conditionals for earlier versions.

  * Remove support for GHC < 7.8 (Jesse Rosenthal).

    + Remove Compat.Monoid.
    + Remove an inline monad compatibility macro.
    + Remove Text.Pandoc.Compat.Except.
    + Remove directory compat.
    + Change constraint on mtl.
    + Remove unnecessary CPP condition in UTF8.
    + Bump base lower bound to 4.7.
    + Remove 7.6 build from .travis.yaml.
    + Bump supported ghc version in CONTRIBUTING.md.
    + Add note about GHC version support to INSTALL.
    + Remove GHC 7.6 from list of tested versions (Albert Krewinkel).
    + Remove TagSoup compat.
    + Add EOL note to time compat module.  Because time 1.4 is a boot library
      for GHC 7.8, we will support the compatibility module as long as we
      support 7.8. But we should be clear about when we will no longer need
      it.
    + Remove blaze-html CPP conditional.
    + Remove unnecessary CPP in custom Prelude.

## pandoc 1.17.2 (2016-07-17)

  * Added Zim Wiki writer, template and tests. `zimwiki` is now
    a valid output format. (Alex Ivkin)

  * Changed email-obfuscation default to no obfuscation (#2988).
    + `writerEmailObfuscation` in `defaultWriterOptions` is now
      `NoObfuscation`.
    + the default for the command-line `--email-obfuscation` option is
      now `none`.

  * Docbook writer: Declare xlink namespace in Docbook5 output (Ivo Clarysse).

  * Org writer:

    + Support arbitrary raw inlines (Albert Krewinkel).
      Org mode allows arbitrary raw inlines ("export snippets" in Emacs
      parlance) to be included as `@@format:raw foreign format text@@`.
    + Improve Div handling (Albert Krewinkel).  Div blocks handling is
      changed to make the output look more like idiomatic org mode:
        - Div-wrapped content is output as-is if the div's attribute is the
          null attribute.
        - Div containers with an id but neither classes nor key-value pairs
          are unwrapped and the id is added as an anchor.
        - Divs with classes associated with greater block elements are
          wrapped in a `#+BEGIN`...`#+END` block.
        - The old behavior for Divs with more complex attributes is kept.

  * HTML writer:  Better support for raw LaTeX environments (#2758).
    Previously we just passed all raw TeX through when MathJax
    was used for HTML math.  This passed through too much.
    With this patch, only raw LaTeX environments that MathJax
    can handle get passed through.
    This patch also causes raw LaTeX environments to be treated
    as math, when possible, with MathML and WebTeX output.

  * Markdown writer:  use raw HTML for simple, pipe tables with linebreaks
    (#2993).  Markdown line breaks involve a newline, and simple and pipe
    tables can't contain one.

  * Make --webtex work with the Markdown writer (#1177).
    This is a convenient option for people using
    websites whose Markdown flavors don't provide for math.

  * Docx writer:

    + Set paragraph to FirstPara after display math (Jesse Rosenthal).
      We treat display math like block quotes, and apply FirstParagraph style
      to paragraphs that follow them. These can be styled as the user
      wishes. (But, when the user is using indentation, this allows for
      paragraphs to continue after display math without indentation.)
    + Use actual creation time as doc prop (Jesse Rosenthal).
      Previously, we had used the user-supplied date, if available, for Word's
      document creation metadata. This could lead to weird results, as in
      cases where the user post-dates a document (so the modification might be
      prior to the creation). Here we use the actual computer time to set the
      document creation.

  * LaTeX writer:

    + Don't URI-escape image source (#2825).  Usually this is a local file,
      and replacing spaces with `%20` ruins things.
    + Allow 'standout' as a beamer frame option (#3007).
      `## Slide title {.standout}`.

  * RST reader: Fixed links with no explicit link text.  The link
    `` `<foo>`_ `` should have `foo` as both its link text and its URL.
    See RST spec at <http://docutils.sourceforge.net/docs/ref/rst/restructuredtext.html#embedded-uris-and-aliases>
    Closes Debian #828167 -- reported by Christian Heller.

  * Textile reader:

    + Fixed attributes (#2984).  Attributes can't be followed by
      a space.  So, `_(class)emph_` but `_(noclass) emph_`.
    + Fixed exponential parsing bug (#3020).
    + Fix overly aggressive interpretation as images (#2998).
      Spaces are not allowed in the image URL in textile.

  * LaTeX reader:

    + Fix `\cite` so it is a NormalCitation not AuthorInText.
    + Strip off double quotes around image source if present (#2825).
      Avoids interpreting these as part of the literal filename.

  * Org reader:

    + Add semicolon to list of special chars (Albert Krewinkel)
      Semicolons are used as special characters in citations syntax.  This
      ensures the correct parsing of Pandoc-style citations: `[prefix; @key;
      suffix]`.  Previously, parsing would have failed unless there was a space
      or other special character as the last <prefix> character.
    + Add support for "Berkeley-style" cites (Albert Krewinkel, #1978).
      A specification for an official Org-mode citation syntax was drafted by
      Richard Lawrence and enhanced with the help of others on the orgmode
      mailing list.  Basic support for this citation style is added to the
      reader.
    + Support arbitrary raw inlines (Albert Krewinkel).
      Org mode allows arbitrary raw inlines ("export snippets" in Emacs
      parlance) to be included as `@@format:raw foreign format text@@`.
    + Remove partial functions (Albert Krewinkel, #2991).
      Partial functions like `head` lead to avoidable errors and should be
      avoided.  They are replaced with total functions.
    + Support figure labels (Albert Krewinkel, #2496, #2999).
      Figure labels given as `#+LABEL: thelabel` are used as the ID of the
      respective image.  This allows e.g. the LaTeX to add proper `\label`
      markup.
    + Improve tag and properties type safety (Albert Krewinkel).
      Specific newtype definitions are used to replace stringly typing of tags
      and properties.  Type safety is increased while readability is improved.
    + Parse as headlines, convert to blocks (Albert Krewinkel).
      Emacs org-mode is based on outline-mode, which treats documents as trees
      with headlines are nodes.  The reader is refactored to parse into a
      similar tree structure.  This simplifies transformations acting on
      document (sub-)trees.
    * Refactor comment tree handling (Albert Krewinkel).
      Comment trees were handled after parsing, as pattern matching on lists
      is easier than matching on sequences.  The new method of reading
      documents as trees allows for more elegant subtree removal.
    * Support archived trees export options (Albert Krewinkel).
      Handling of archived trees can be modified using the `arch` option.
      Archived trees are either dropped, exported completely, or collapsed to
      include just the header when the `arch` option is nil, non-nil, or
      `headline`, respectively.
    * Put export setting parser into module (Albert Krewinkel).
      Export option parsing is distinct enough from general block parsing to
      justify putting it into a separate module.
    * Support headline levels export setting (Albert Krewinkel).
      The depths of headlines can be modified using the `H` option.  Deeper
      headlines will be converted to lists.
    * Replace ugly code with view pattern (Albert Krewinkel).
      Some less-than-smart code required a pragma switching of overlapping
      pattern warnings in order to compile seamlessly.  Using view patterns
      makes the code easier to read and also doesn't require overlapping
      pattern checks to be disabled.
    * Fix parsing of verbatim inlines (Albert Krewinkel, #3016).
      Org rules for allowed characters before or after markup chars were not
      checked for verbatim text.  This resultet in wrong parsing outcomes of
      if the verbatim text contained e.g. space enclosed markup characters as
      part of the text (`=is_substr = True=`).  Forcing the parser to update
      the positions of allowed/forbidden markup border characters fixes this.

  * LaTeX template: fix for obscure hyperref/xelatex issue.
    Here's a minimal case:

        \documentclass[]{article}
        \usepackage{hyperref}
        \begin{document}
        \section{\%á}
        \end{document}

    Without this change, this fails on the second invocation of xelatex.
    This affects inputs this like `# %á` with pdf output via xelatex.

  * trypandoc:  call results 'html' instead of 'result'.
    This is for better compatibility with babelmark2.

  * Document MultiMarkdown as input/output format (Albert Krewinkel, #2973).
    MultiMarkdown was only mentioned as a supported Markdown dialect but not
    as a possible input or output format.  A brief mention is added
    everywhere the other supported markdown dialects are mentioned.

  * Document Org mode as a format containing raw HTML (Albert Krewinkel)
    Raw HTML is kept when the output format is Emacs Org mode.

  * Implement `RawInline` and `RawBlock` in sample lua custom writer (#2985).

  * Text.Pandoc.Shared:

    + Introduce blocksToInlines function (Jesse Rosenthal).
      This is a lossy function for converting `[Block] -> [Inline]`. Its main
      use, at the moment, is for docx comments, which can contain arbitrary
      blocks (except for footnotes), but which will be converted to spans.
      This is, at the moment, pretty useless for everything but the basic
      `Para` and `Plain` comments. It can be improved, but the docx reader
      should probably emit a warning if the comment contains more than this.
    + Add BlockQuote to blocksToInlines (Jesse Rosenthal).
    + Add further formats for `normalizeDate` (Jesse Rosenthal).
      We want to avoid illegal dates -- in particular years with greater than
      four digits. We attempt to parse series of digits first as `%Y%m%d`, then
      `%Y%m`, and finally `%Y`.
    + `normalizeDate` should reject illegal years (Jesse Rosenthal).
      We only allow years between 1601 and 9999, inclusive. The ISO 8601
      actually says that years are supposed to start with 1583, but MS Word
      only allows 1601-9999. This should stop corrupted word files if the date
      is out of that range, or is parsed incorrectly.
    + Improve year sanity check in normalizeDate (Jesse Rosenthal).
      Previously we parsed a list of dates, took the first one, and then
      tested its year range. That meant that if the first one failed, we
      returned nothing, regardless of what the others did. Now we test for
      sanity before running `msum` over the list of Maybe values. Anything
      failing the test will be Nothing, so will not be a candidate.

  * Docx reader:

    + Add simple comment functionality. (Jesse Rosenthal).
      This adds simple track-changes comment parsing to the docx reader. It is
      turned on with `--track-changes=all`. All comments are converted to
      inlines, which can list some information. In the future a warning will be
      added for comments with formatting that seems like it will be excessively
      denatured.  Note that comments can extend across blocks. For that reason
      there are two spans: `comment-start` and `comment-end`.  `comment-start`
      will contain the comment. `comment-end` will always be empty.  The two
      will be associated by a numeric id.
    + Enable warnings in top-level reader (Jesse Rosenthal).
      Previously we had only allowed for warnings in the parser. Now we allow
      for them in the `Docx.hs` as well. The warnings are simply concatenated.
    + Add warning for advanced comment formatting. (Jesse Rosenthal).
      We can't guarantee we'll convert every comment correctly, though we'll
      do the best we can. This warns if the comment includes something other
      than Para or Plain.
    + Add tests for warnings. (Jesse Rosenthal).
    + Add tests for comments (Jesse Rosenthal).
      We test for comments, using all track-changes options. Note that we
      should only output comments if `--track-changes=all`. We also test for
      emitting warnings if there is complicated formatting.

  * README: update to include track-changes comments. (Jesse Rosenthal)

  * Improved Windows installer - don't ignore properties set on command-line.
    See #2708.  Needs testing to see if this resolves the issue.
    Thanks to @nkalvi.

  * Process markdown extensions on command line in L->R order (#2995).
    Previously they were processed, very unintuitively, in R->L
    order, so that `markdown-tex_math_dollars+tex_math_dollars`
    had `tex_math_dollars` disabled.

  * Added `secnumdepth` variable to LaTeX template (#2920).

  * Include table of contents in README.html in Windows package.

  * Writers: treat SoftBreak as space for stripping (Jesse Rosenthal)
    In Writers.Shared, we strip leading and trailing spaces for display
    math. Since SoftBreak's are treated as spaces, we should strip those
    too.

  * beamer, latex templates:  pass biblatexoptions directly in package load.
    This allows runtime optinos to be used.  Fixes jgm/pandoc-citeproc#201

  * CPP workaround for deprecation of `parseUrl` in http-client.

  * Removed some redundant class constraints.

  * make_oxs_package.sh - use OSX env variable.

  * Added `winpkg` target to Makefile.  This downloads the windows package
    from appveyor and signs it using the key.

  * Document Org mode as a format containing raw TeX (Albert Krewinkel).
    Raw TeX is kept verbatim when the output format is Emacs Org mode.

  * Support math with haddock-library >= 1.4.

  * Removed `-rtsopts` from library stanza.  It has no effect, and Hackage
    wouldn't accept the package.

  * Update library dependency versions.

## pandoc 1.17.1 (2016-06-04)

  * New output format: `docbook5` (Ivo Clarysse).

  * `Text.Pandoc.Options`: Add `writerDocBook5` to `WriterOptions`
    (API change).

  * Org writer:

    + Add :PROPERTIES: drawer support (Albert Krewinkel, #1962).
      This allows header attributes to be added to org documents in the form
      of `:PROPERTIES:` drawers.  All available attributes are stored as
      key/value pairs.  This reflects the way the org reader handles
      `:PROPERTIES:` blocks.
    + Add drawer capability (Carlos Sosa).  For the implementation of the
      Drawer element in the Org Writer, we make use of a generic Block
      container with attributes.  The presence of a `drawer` class defines
      that the `Div` constructor is a drawer. The first class defines the
      drawer name to use.  The key-value list in the attributes defines
      the keys to add inside the Drawer.  Lastly, the list of Block elements
      contains miscellaneous blocks elements to add inside of the Drawer.
    + Use `CUSTOM_ID` in properties (Albert Krewinkel).  The `ID` property is
      reserved for internal use by Org-mode and should not be used.
      The `CUSTOM_ID` property is to be used instead, it is converted to the
      `ID` property for certain export format.

  * LaTeX writer:

    + Ignore `--incremental` unless output format is beamer (#2843).
    + Fix polyglossia to babel env mapping (Mauro Bieg, #2728).
      Allow for optional argument in square brackets.
    + Recognize `la-x-classic` as Classical Latin (Andrew Dunning).
      This allows one to access the hyphenation patterns in CTAN's
      hyph-utf8.
    + Add missing languages from hyph-utf8 (Andrew Dunning).
    + Improve use of `\strut` with `\minipage` inside tables
      (Jose Luis Duran).  This improves spacing in multiline
      tables.
    + Use `{}` around options containing special chars (#2892).
    + Avoid lazy `foldl`.
    + Don't escape underscore in labels (#2921).  Previously they were
      escaped as `ux5f`.
    + brazilian -> brazil for polyglossia (#2953).

  * HTML writer: Ensure mathjax link is added when math appears in footnote
    (#2881).  Previously if a document only had math in a footnote, the
    MathJax link would not be added.

  * EPUB writer: set `navpage` variable on nav page.
    This allows templates to treat it differently.

  * DocBook writer:

    + Use docbook5 if `writerDocbook5` is set (Ivo Clarysse).
    + Properly handle `ulink`/`link` (Ivo Clarysse).

  * EPUB reader:

    + Unescape URIs in spine (#2924).
    + EPUB reader:  normalise link id (Mauro Bieg).

  * Docx Reader:

    + Parse `moveTo` and `moveFrom` (Jesse Rosenthal).
      `moveTo` and `moveFrom` are track-changes tags that are used when a
      block of text is moved in the document. We now recognize these tags and
      treat them the same as `insert` and `delete`, respectively. So,
      `--track-changes=accept` will show the moved version, while
      `--track-changes=reject` will show the original version.
    + Tests for track-changes moving (Jesse Rosenthal).

  * ODT, EPUB, Docx readers: throw `PandocError` on unzip failure
    (Jesse Rosenthal) Previously, `readDocx`, `readEPUB`, and `readOdt`
    would error out if zip-archive failed. We change the archive extraction
    step from `toArchive` to `toArchiveOrFail`, which returns an Either value.

  * Markdown, HTML readers:  be more forgiving about unescaped `&` in
    HTML (#2410).  We are now more forgiving about parsing invalid HTML with
    unescaped `&` as raw HTML.  (Previously any unescaped `&`
    would cause pandoc not to recognize the string as raw HTML.)

  * Markdown reader:

    + Fix pandoc title blocks with lines ending in 2 spaces (#2799).
    + Added `-s` to markdown-reader-more test.

  * HTML reader: fixed bug in `pClose`.  This caused exponential parsing
    behavior in documnets with unclosed tags in `dl`, `dd`, `dt`.

  * MediaWiki reader: Allow spaces before `!` in MediaWiki table header
    (roblabla).

  * RST reader: Support `:class:` option for code block in RST reader
    (Sidharth Kapur).

  * Org reader (all Albert Krewinkel, except where noted otherwise):

    + Stop padding short table rows.
      Emacs Org-mode doesn't add any padding to table rows.  The first
      row (header or first body row) is used to determine the column count,
      no other magic is performed.
    + Refactor rows-to-table conversion.  This refactors
      the codes conversing a list table lines to an org table ADT.
      The old code was simplified and is now slightly less ugly.
    + Fix handling of empty table cells, rows (Albert Krewinkel, #2616).
      This fixes Org mode parsing of some corner cases regarding empty cells
      and rows.  Empty cells weren't parsed correctly, e.g. `|||` should be
      two empty cells, but would be parsed as a single cell containing a pipe
      character.  Empty rows where parsed as alignment rows and dropped from
      the output.
    + Fix spacing after LaTeX-style symbols.
      The org-reader was dropping space after unescaped LaTeX-style symbol
      commands: `\ForAll \Auml` resulted in `∀Ä` but should give `∀ Ä`
      instead.  This seems to be because the LaTeX-reader treats the
      command-terminating space as part of the command.  Dropping the trailing
      space from the symbol-command fixes this issue.
    + Print empty table rows.  Empty table rows should not
      be dropped from the output, so row-height is always set to be at least 1.
    + Move parser state into separate module.
      The org reader code has become large and confusing.  Extracting smaller
      parts into submodules should help to clean things up.
    + Add support for sub/superscript export options.
      Org-mode allows to specify export settings via `#+OPTIONS` lines.
      Disabling simple sub- and superscripts is one of these export options,
      this options is now supported.
    + Support special strings export option Parsing of special strings
      (like `...` as ellipsis or `--` as en dash) can be toggled using the `-`
      option.
    + Support emphasized text export option.  Parsing of emphasized text can
      be toggled using the `*` option.  This influences parsing of text marked
      as emphasized, strong, strikeout, and underline.  Parsing of inline math,
      code, and verbatim text is not affected by this option.
    + Support smart quotes export option.  Reading of smart quotes can be
      toggled using the `'` option.
    + Parse but ignore export options. All known export options are parsed
      but ignored.
    + Refactor block attribute handling.  A parser state attribute was used
      to keep track of block attributes defined in meta-lines.  Global state
      is undesirable, so block attributes are no longer saved as part of the
      parser state.  Old functions and the respective part of the parser state
      are removed.
    + Use custom `anyLine`.  Additional state changes need to be made after
      a newline is parsed, otherwise markup may not be recognized correctly.
      This fixes a bug where markup after certain block-types would not be
      recognized.
    + Add support for `ATTR_HTML` attributes (#1906).
      Arbitrary key-value pairs can be added to some block types using a
      `#+ATTR_HTML` line before the block.  Emacs Org-mode only includes these
      when exporting to HTML, but since we cannot make this distinction here,
      the attributes are always added.  The functionality is now supported
      for figures.
    + Add `:PROPERTIES:` drawer support (#1877).
      Headers can have optional `:PROPERTIES:` drawers associated with them.
      These drawers contain key/value pairs like the header's `id`.  The
      reader adds all listed pairs to the header's attributes; `id` and
      `class` attributes are handled specially to match the way `Attr` are
      defined.  This also changes behavior of how drawers of unknown type
      are handled.  Instead of including all unknown drawers, those are not
      read/exported, thereby matching current Emacs behavior.
    + Use `CUSTOM_ID` in properties.  See above on Org writer changes.
    + Respect drawer export setting.  The `d` export option can be used
      to control which drawers are exported and which are discarded.
      Basic support for this option is added here.
    + Ignore leading space in org code blocks (Emanuel Evans, #2862).
      Also fix up tab handling for leading whitespace in code blocks.
    + Support new syntax for export blocks.  Org-mode version 9
      uses a new syntax for export blocks.  Instead of `#+BEGIN_<FORMAT>`,
      where `<FORMAT>` is the format of the block's content, the new
      format uses `#+BEGIN_export <FORMAT>` instead.  Both types are
      supported.
    + Refactor `BEGIN...END` block parsing.
    + Fix handling of whitespace in blocks, allowing content to be indented
      less then the block header.
    + Support org-ref style citations.  The *org-ref* package is an
      org-mode extension commonly used to manage citations in org
      documents.  Basic support for the `cite:citeKey` and
      `[[cite:citeKey][prefix text::suffix text]]` syntax is added.
    + Split code into separate modules, making for cleaner code and
      better decoupling.

  * Added `docbook5` template.

  * `--mathjax` improvements:

    + Use new CommonHTML output for MathJax (updated default MathJax URL,
      #2858).
    + Change default mathjax setup to use `TeX-AMS_CHTML` configuration.
      This is designed for cases where the input is always TeX and maximal
      conformity with TeX is desired.  It seems to be smaller and load faster
      than what we used before.  See #2858.
    + Load the full MathJax config to maximize loading speed (KolenCheung).

  * Bumped upper version bounds to allow use of latest packages
    and compilation with ghc 8.

  * Require texmath 0.8.6.2.  Closes several texmath-related bugs (#2775,
    #2310, #2310, #2824).  This fixes behavior of roots, e.g.
    `\sqrt[3]{x}`, and issues with sub/superscript positioning
    and matrix column alignment in docx.

  * README:

    + Clarified documentation of `implicit_header_references` (#2904).
    + Improved documentation of `--columns` option.

  * Added appveyor setup, with artefacts (Jan Schulz).

  * stack.yaml versions: Use proper flags used for texmath, pandoc-citeproc.

  * LaTeX template: support for custom font families (vladipus).
    Needed for correct polyglossia operation with Cyrillic fonts and perhaps
    can find some other usages.  Example usage in YAML metadata:

          fontfamilies:
          - name: \cyrillicfont
            font: Liberation Serif
          - name: \cyrillicfonttt
            options: Scale=MatchLowercase
            font: Liberation

  * Create unsigned msi as build artifact in appveyor build.

  * On travis, test with ghc 8.0.1; drop testing for ghc 7.4.1.



## pandoc 1.17.0.3 (2016-03-24)

  * LaTeX writer: Fixed position of label in figures (#2813).
    Previously the label wasn't in the right place, and `\ref`
    wouldn't work properly.
  * Added .tei test files to pandoc.cabal so they'll be included
    in tarball (#2811).
  * Updated copyright dates.

## pandoc 1.17.0.2 (2016-03-23)

  * Fixed serious regression in `htmlInBalanced`, which caused
    newlines to be omitted in some raw HTML blocks in Markdown
    (#2804).

## pandoc 1.17.0.1 (2016-03-21)

  * File scope is no longer used when there are no input files (i.e.,
    when input comes from stdin).  Previously file scope was triggered
    when the `json` reader was specified and input came from `stdin`,
    and this caused no output to be produced.  (Fix due to Jesse Rosenthal;
    thanks to Fedor Sheremetyev for calling the bug to our attention.)
  * Improved documentation of templates (#2797).

## pandoc 1.17 (2016-03-20)

  * Added `--file-scope` option (Jesse Rosenthal).
    By default pandoc operates on multiple files by first concatenating
    them (around extra line breaks) and then processing the joined file. So
    it only parses a multi-file document at the document scope. This has the
    benefit that footnotes and links can be in different files, but for
    some purposes it is useful to parse the individual files first
    and then combine their outputs (e.g. when the files use footnotes
    or links with the same labels).  The `--file-scope` option causes
    pandoc to parse the files first, and then combine the parsed output,
    instead of combining before parsing. `--file-scope` is selected
    automatically for binary input files (which cannot be concatenated)
    and for pandoc json.

  * Add TEI Writer (Chris Forster) and `tei` output format.

  * Added a general `ByteStringReader` with warnings, used by the docx
    reader (API change, Jesse Rosenthal).

  * Add `readDocxWithWarnings` (API change, Jesse Rosenthal).

  * Changed type of `Shared.uniqueIdent` argument from
    `[String]` to `Set String`.  This avoids performance problems in documents
    with many identically named headers (API change, #2671).

  * Removed `tex_math_single_backslash` from `markdown_github` options
    (#2707).

  * Make language extensions as well as full language names
    trigger syntax highlighting.  For example, `py` will now work as
    well as `python` (jgm/highlighting-kate#83).

  * Added `institute` variable to latex, beamer templates (Fraser
    Tweedale, Josef Svenningsson).

  * Docx reader (Jesse Rosenthal):

    + Handle alternate content.  Some word functions (especially graphics)
      give various choices for content so there can be backwards compatibility.
    + Don't turn numbered headers into lists.
    + Docx Reader: Add state to the parser, for warnings
    + Update feature checklist in source code.
    + Get rid of `Modifiable` typeclass.
    + Add tests for adjacent hyperlinks.
    + Add a "Link" modifier to `Reducible`. We want to make sure that
      links have their spaces removed, and are appropriately smushed
      together (#2689).

  * HTML reader:

    + Fixed behavior of base tag (#2777).
      If the base path does not end with slash, the last component
      will be replaced.  E.g. base = `http://example.com/foo`
      combines with `bar.html` to give `http://example.com/bar.html`.
      If the href begins with a slash, the whole path of the base
      is replaced.  E.g. base = `http://example.com/foo/` combines
      with `/bar.html` to give `http://example.com/bar.html`.
    + Rewrote `htmlInBalanced`.  This version avoids an exponential
      performance problem with `<script>` tags, and it should be faster
      in general (#2730).
    + Properly handle an empty cell in a simple table (#2718).
    + Handle multiple `<meta>` tags with same name.  Put them in a list
      in the metadata so they are all preserved, rather than (as before)
      throwing out all but one..

  * Markdown reader:

    + Improved pipe table parsing (#2765).
    + Allow `+` separators in pipe table cells.  We already allowed
      them in the header, but not in the body rows, for some reason.
      This gives compatibility with org-mode tables.
    + Don't cross line boundary parsing pipe table row.
      Previously an Emph element could be parsed across the newline
      at the end of the pipe table row.
    + Use `htmlInBalanced` for `rawVerbatimBlock`, for better
      performance (#2730).
    + Fixed bug with smart quotes around tex math.

  * LaTeX reader:

    + Handle interior `$` characters in math (#2743).  For example,
      `$$\hbox{$i$}$$`.
    + `inlineCommand` now gobbles an empty `{}` after any command (#2687).
      This gives better results when people write e.g. `\TeX{}` in Markdown.
    + Properly handle LaTeX "math" environment as inline math (#2171).

  * Textile reader: Support `>`, `<`, `=`, `<>` text alignment attributes.
    Closes #2674.

  * Org reader (Albert Krewinkel):

    + Prefix even empty figure names with "fig:" (#2643).  The
      convention used by pandoc for figures is to mark them by prefixing
      the name with `fig:`.  The org reader failed to do this if a figure
      had no name.
    + Refactor link-target processing (#2684).

  * ConTeXt writer: Fix whitespace at line beginning in line blocks (#2744).
    Thanks to @c-foster.

  * HTML writer: Don't include alignment attribute for default table columns.
    Previously these were given "left" alignment.  Better to leave off
    alignment attributes altogether (#2694).

  * Markdown writer: Use hyphens for YAML metadata block bottom line, for
    better compatibility with other Markdown flavors (Henrik Tramberend).

  * LaTeX writer:

    + Use image identifier to create a label and hypertarget for
      figures (Mauro Bieg).
    + Avoid double toprule in headerless table with caption (#2742).
    + Clean up options parser (Jesse Rosenthal).
    + Treat `memoir` template with `article` option as article, instead
      of treating all `memoir` templates as books.
    + Allow more flexible table alignment (Henrik Tramberend, #2665).
      New default is not to include `[c]` option (which is the default
      anyway if no positioning is specified).  Now LaTeX emplates can
      control the overall table alignment in a document by setting the
      longtable length variables `LTleft` and `LTright`.  For example,
      `\setlength\LTleft\parindent\setlength\LTright\fill`
      will create left-aligned tables that respect paragraph indentation.

  * Docx writer: Handle image alt text (#2754, Mauro Bieg).

  * Org writer - pass through RawInline with format "org".

  * DokuWiki writer: use `$$` for display math.

  * Custom writer: Pass attributes parameter to CaptionedImage (#2697).

  * Make protocol-relative URIs work again (#2737).

  * make_osx_package.sh:  Use env variable for developer id certs.

  * Raise `tagsoup` lower bound to 0.13.7 to fix entity-related
    problems (#2734).

  * Allow `zip-archive` 0.3.

  * Allow `aeson` 0.11.

## pandoc 1.16.0.2 (2016-01-12)

  * Depend on deepseq rather than deepseq-generics (fpco/stackage#1096).

  * Fixed regression in latex smart quote parsing (#2645).
    In cases where a match was not found for a quote, everything
    from the open quote to the end of the paragraph was being dropped.

## pandoc 1.16.0.1 (2016-01-10)

  * Fixed regression with `--latex-engine` (#2618). In 1.16
    `--latex-engine` raises an error if a full path is given.

  * Org reader: Fix function dropping subtrees tagged `:noexport`
    (Albert Krewinkel, #2628):

  * Markdown reader: renormalize table column widths if they exceed 100%
    (#2626).

  * Textile reader:  don't allow block HTML tags in inline contexts.
    The reader previously did allow this, following redcloth,
    which happily parses

        Html blocks can be <div>inlined</div> as well.

    as

        <p>Html blocks can be <div>inlined</div> as well.</p>

    This is invalid HTML.  The above sample now produces;

        <p>Html blocks can be</p>
        <div>
        <p>inlined</p>
        </div>
        <p>as well.</p>

  * Improved default template lookup for custom lua scripts (#2625).
    Previously, if you tried to do `pandoc -s -t /path/to/lua/script.lua`,
    pandoc would look for the template in
    `~/.pandoc/templates/default./path/to/lua/script.lua`.
    With this change it will look in the more reasonable
    `~/.pandoc/templates/default.script.lua`.  This makes it possible to
    store default templates for custom writers.

  * RST, Markdown writers: Fixed rendering of grid tables with blank rows
    (#2615).

  * LaTeX writer: restore old treatment of Span (#2624).  A Span is
    now rendered with surrounding `{}`, as it was before 1.16.

  * Entity handling fixes: improved handling of entities like
    `&lang;` that require a trailing semicolon.  Allow uppercase
    `x` in numerical hexadecimal character references, working
    around a tagsoup bug.

  * `stack.yaml` - use lts-4.0, but with older aeson to avoid excessive
    memory use on compile.  With aeson 0.10 we were getting an out of
    memory error on a 2GB Ubuntu 64-bit VM.

  * Improved deb package creation script. Made `DPKGVER` work.
    Renamed `COMMIT` to `TREE`.  You should now be able to do
    `TREE=1.16.0.1 DPKGVER=2 make deb`.


## pandoc 1.16 (2016-01-02)

  * Added `Attr` field to `Link` and `Image` (Mauro Bieg, #261, API change).

    + Added syntax for link and image attributes to pandoc's Markdown.
    + Updated readers and writers to use link and image attributes
      when appropriate.
    + Support image attributes in Docx, Textile, RST readers.

  * Renamed link attribute extensions.  The old `link_attributes` is
    now `mmd_link_attributes`, and `link_attributes` now enables the
    new pandoc-style link and image attributes (API change).
    Note: this change could break some existing workflows.

  * Implemented `SoftBreak` and new `--wrap` option (#1701, API change).
    Added threefold wrapping option.

    + Command line option: deprecated `--no-wrap`, added
      `--wrap=[auto|none|preserve]`
    + Added `WrapOption`, exported from `Text.Pandoc.Options`
    + Changed type of `writerWrapText` in `WriterOptions` from
      `Bool` to `WrapOption`.
    + Modified `Text.Pandoc.Shared` functions to allow `SoftBreak`.
    + Supported `SoftBreak` in readers and writers.

  * Text.Pandoc.Options:  Added `writerDpi` to `WriterOptions` (API
    change, Mauro Bieg).

  * Added `--dpi` command-line option (Mauro Bieg).

  * Rationalized behavior of `--no-tex-ligatures` and `--smart` (#2541).
    This change makes `--no-tex-ligatures` affect the LaTeX reader
    as well as the LaTeX and ConTeXt writers.  If it is used,
    the LaTeX reader will parse characters `` ` ``, `'`, and `-`
    literally, rather than parsing ligatures for quotation marks
    and dashes.  And the LaTeX writer will print unicode quotation
    mark and dash characters literally, rather than converting
    them to the standard ASCII ligatures.  Note that `--smart` has
    no effect on the LaTeX reader.  `--smart` is still the default
    for all input formats when LaTeX or ConTeXt is the output format,
    *unless* `--no-tex-ligatures` is used.

    Some examples to illustrate the logic:

    ```
    % echo "'hi'" | pandoc -t latex
    `hi'
    % echo "'hi'" | pandoc -t latex --no-tex-ligatures
    'hi'
    % echo "'hi'" | pandoc -t latex --no-tex-ligatures --smart
    ‘hi’
    % echo "'hi'" | pandoc -f latex --no-tex-ligatures
    <p>'hi'</p>
    % echo "'hi'" | pandoc -f latex
    <p>’hi’</p>
    ```

  * Removed deprecated options `--offline` and `--html5`.

  * Fixed language code for Czech (`cs` not `cz`) (#2597).

  * Implemented `east_asian_line_breaks` extension (#2586).
    In `Text.Pandoc.Options`, added `Ext_east_asian_line_breaks` constructor
    to `Extension` (API change).  This extension is like
    `ignore_line_breaks`, but smarter -- it only ignores line breaks
    between two East Asian wide characters.  This makes it better suited
    for writing with a mix of East Asian and non-East Asian scripts.

  * Added support for PDF creation via `wkhtmltopdf`.
    To use this: `pandoc -t html5 -o result.pdf` (and add `--mathjax`
    if you have math.) Margins can be set using the variables
    `margin-top`, `margin-bottom`, `margin-left`, `margin-right`.
    Other styling can be done through CSS.

  * Fixed cite key parsing regression (jgm/pandoc-citeproc#201).
    We were capturing final colons as in `[@foo: bar]`; the citation id
    was being parsed as `@foo:`.

  * ICML writer:

    + Fixed image syntax for local files (#2589).
    + Changed type of `writeICML` (Mauro Bieg).
      API change:  It is now `WriterOptions -> Pandoc -> IO String`.
      Also handle new image attributes.
    + Intersperse line breaks instead of appending them to
      every `ParagraphStyleRange` (Mauro Bieg, #2501).
    + Add `Cite` style to citations (Mauro Bieg).
    + Added figure handling (#2590, Mauro Bieg).
    + Better handling of math.  Instead of just printing the raw tex,
      we now try to fake it with unicode characters.

  * HTML writer: Include `example` class for example lists (#2524).

  * ODT/OpenDocument writer: improved image attributes (Mauro Bieg).

    + Support for percentage widths/heights
    + Use `Attr` instead of title to get dimensions from ODT walker
      to `writeOpenDocument`.

  * AsciiDoc writer:

    + Support anchors in spans and divs with id elements
      (jgm/pandoc-citeproc#143).
    + Fixed code blocks (#1861).

  * Haddock writer:  omit formatting inside links, which isn't supported
    by Haddock (#2515).

  * MediaWiki writer:  Fixed spacing issues in table cells.

    + Start cell on new line unless it's a single Para or Plain
      (#2606).
    + For single Para or Plain, insert a space after the `|` to
      avoid problems when the text begins with a character like
      `-` (#2604).

  * Beamer writer: mark frame as fragile when it contains verbatim (#1613).

  * LaTeX writer:

    + Add support for GAP highlighting using listings (Raniere Silva).
    + Consider `header-includes` content as well as templates
      when determining whether to use csquotes (Andreas Lööw).
    + Create defaults for geometry using `margin-left` etc.
      If `geometry` has no value, but `margin-left`, `margin-right`,
      `margin-top`, and/or `-margin-bottom` are given, a default value
      for `geometry` is created from these.  Note that these variables
      already affect PDF production via HTML5 with `wkhtmltopdf`.

  * ConTeXt writer: set default layout based on `margin-left`, etc.
    This sets up `\setuplayout` based on the variables `margin-left`,
    `margin-right`, `margin-bottom`, and `margin-top`, if no layout
    is given.

  * Docx writer:  better handling of PDF images.  Previously we tried
    to get the image size from the image even if an explicit size was
    specified.  Since we still can't get image size for PDFs, this made
    it impossible to use PDF images in docx.  Now we don't try to get
    the image size when a size is already explicitly specified.

  * Markdown writer:  use raw HTML for link/image attributes when
    the `link_attributes` extension is unset and `raw_html` is set (#2554).

  * MediaWiki reader: interpret markup inside `<tt>`, `<code>` (#2607).

  * LaTeX reader:

    + Improved smart quote parsing (#2555). This fixes redering of
      unmatched quotes.
    + Use curly quotes for unmatched ` (#2555).
    + Allow blank space between braced arguments of commands (#2592).

  * Markdown reader:

    + Improved pipe table relative widths.  Previously pipe table
      columns got relative widths (based on the header underscore lines)
      when the source of one of the rows was greater in width than the
      column width.  This gave bad results in some cases where much of
      the width of the row was due to nonprinting material (e.g. link
      URLs).  Now pandoc only looks at printable width (the width of a
      plain string version of the source), which should give better results.
      Thanks to John Muccigrosso for bringing up the issue.
    + Fixed parsing bug with macros.  Previously macro definitions in
      indented code blocks were being parsed as macro definitions, not code.

  * Textile reader:  skip over attribute in image source (#2515).
    We don't have a place yet for styles or sizes on images, but
    we can skip the attributes rather than incorrectly taking them
    to be part of the filename.

  * Docx reader: Handle dummy list items (Jesse Rosenthal).
    These come up when people create a list item and then delete the
    bullet. It doesn't refer to any real list item, and we used to ignore
    it.

  * CommonMark reader/writer rewritten to use latest `cmark`.

  * Fixed Emoji character definitions (#2523).  There were many bugs in the
    definitions.

  * `Text.Pandoc.CSS`:

    + Added `pickStylesToKVs` function to extract multiple properties at
      once (API change, Mauro Bieg).
    + Parse CSS that doesn't contain the optional semicolon (Mauro Bieg).

  * `trypandoc`: sort drop-down lists.

  * Beamer template:

    + Made `\euro` conditional on presence of character.
      for xelatex and lualatex, as it is for pdflatex (Andrew Dunning).
    + Moved `header-includes` before setting of title (Thomas Hodgson),
      to match the LaTeX template (jgm/pandoc-templates#168).
    + Added `section-titles` variable (defaults to true)
      to enable/suppress section title pages in beamer
      slide shows (Thomas Hodgson).
    + Moved beamer themes after fonts, so that themes can
      change fonts.  (Previously the fonts set were being
      clobbered by lmodern.sty.) (Thomas Hodgson).

  * Beamer/LaTeX template changes (Thomas Hodgson):
    + Added `thanks` variable
    + Use `parskip.sty` when `indent` isn't set (fall back to using
      `setlength` as before if `parskip.sty` isn't available).
    + Use `biblio-style` with biblatex.
    + Added `biblatexoptions` variable.

  * LaTeX template changes:

    + Added `paper` after `$papersize$` variable in latex template.
      Thus you can say `papersize: a4` and the latex will contain
      `a4paper`.  This change may break some existing workflows; if
      you currently specify `a4paper`, you'll get `a4paperpaper` which
      is meaningless.  However, the change seems worth it, as it will
      make the `papersize` variable work uniformly across ConTeXt, LaTeX,
      and html->pdf via wkhtmltopdf.
    + Only pass options to color package if `colorlinks` is set
      (Andrew Dunning).
    + Make definition of `\euro` conditional in xelatex/lualatex,
      as it is already for pdflatex (Andrew Dunning).
    + Removed setting of `subject` in PDF metadata.
      This used to be set to the subtitle, but really the subtitle
      need not give the subject.  Also, `subtitle` can contain formatting,
      so we'd need, at least, a plain text version for this.
    + Moved `header-includes` before setting of `\title`, `\author`,
      etc.  This allows these macros to be redefined.
    + Use `\subtitle` command for `subtitle`, instead of tacking it
      on to the title as before.  We give a no-op fallback definition if it
      is not defined.  This change should produce much better results
      in classes that support `\subtitle`.  With the default article
      class, which does not define `\subtitle`, subtitles will no
      longer be printed unless the user defines `\subtitle` and
      redefines `\maketitle`.
    + Moved redefinitions of `\paragraph` and `\subparagraph` to
      before header-includes.

  * Context template:

    + Use `simplefonts` for font loading (Paolo Rodríguez).  This is
      needed for things to work on ConTeXt stable from TeXLive 2015.
    + Revert use of `\setuphead` in title block (Andrew Dunning,
      Rik Kabel).

  * Update LaTeX/ConTeXt link colour usage (Andrew Dunning).

  * Fixed man template so disabling hyphenation actually works.
    The command needs to come after .TH.

  * Added 'navigation' variable to beamer template (#2543).
    Valid values are `empty` (the default), `horizontal`, `vertical`,
    and `frame`.  Note that this changes the default behavior from
    `horizontal` to `empty`.  Closes #2543.

  * Added `toc` to HTML slide format templates (Andrew Dunning),
    so that `--toc` creates a contents slide.

  * Added `stack.full.yaml` to build `pandoc-citeproc` as well.

  * Allow pipe tables with no body rows (#2556).
    Previously this raised a runtime error.

  * Shared: Improved `fetchItem` so that `C:/Blah/Blah.jpg` isn't treated
    as URL.  The Haskell URI parsing routines will accept "C:" as a
    scheme, so we rule that out manually.  This helps with
    `--self-contained` and absolute Windows paths.

  * Define a `meta-json` variable for all writers (#2019).  This contains
    a JSON version of all the metadata, in the format selected for the
    writer.  So, for example, to get just the YAML metadata, you can run
    pandoc with the following custom template: `$meta-json$`.  The intent
    is to make it easier for static site generators and other tools to get
    at the metadata.

  * Document limitations of --self-contained (#2553).

  * Improved Citations section of README (#2551).  Added information
    about `link-citations` and a link to the pandoc-citeproc man page.

  * `ImageSize`: use `safeRead` instead of `readMaybe`, which isn't
    in base < 4.6.

  * Allow .adoc file extension for AsciiDoc (Andrew Dunning).

  * Improved implicit pandoc-citeproc inclusion.
    The filter pandoc-citeproc is automatically used when
    `--bibliography` is specified on the command line, unless
    `--natbib` or `--biblatex` is used.  However, previously this
    only worked if `--bibliography` was spelled out in full, and not
    if `--biblio` was used.

  * reveal.js: Interpret pauses correctly for all headers (#2530).
    Previously, when using headers below the slide level, pauses are left
    uninterpreted into pauses. In my opinion, unexpected behavior but
    intentional looking at the code.

  * Remove redundant `center` variable for reveal.js (Andrew Dunning).

  * Parsing: Add `extractIdClass`, modified type of `KeyTable` (Mauro
    Bieg, API change).

  * ImageSize:  Added functions for converting between image dimensions
    (Mauro Bieg).

  * Use lts-3.18 in stack.yaml.  This avoids Windows build
    issues with the HTTP library.

  * Bump version bounds for dependencies.

## pandoc 1.15.2.1 (2015-11-16)

  * Added two missing test files, and `stack.yaml`, to
    `extra-source-files` so they're included in the source tarball.

  * reveal.js template: Fixed parallaxBackground options.
    `parallaxBackgroundHorizontal` and `parallaxBackgroundVertical`
    need integer values, not strings.  (Vaughn Iverson)

## pandoc 1.15.2 (2015-11-15)

  * `pandoc my.md -t context -o my.pdf` will now create a PDF using
    ConTeXt rather than LaTeX (#2463).

  * Fixed omitted `url(...)` in CSS data-uri with `--self-contained` (#2489).

  * Added `emoji` Markdown extension, enabled by default in `markdown_github`
    (#2523).  Added `Ext_emoji` to `Extension` in `Text.Pandoc.Options`
    (API change).

  * `Text.Pandoc.Readers.HTML.parseTags`: Fixed over-eager raw HTML inline
    parsing (#2469).  Tightened up the inline HTML parser so it disallows
    TagWarnings.

  * Derive `Generic` instances for the types in `Text.Pandoc.Options`.

  * Org reader:

    + Fix paragraph/list interaction (Albert Krewinkel, #2464).
      Paragraphs can be followed by lists, even if there is no blank line
      between the two blocks.  However, this should only be true if the
      paragraph is not within a list, were the preceding block should be
      parsed as a plain instead of paragraph (to allow for compact lists).
      Thanks to @rgaiacs for bringing this up.
    + Allow toggling header args (Albert Krewinkel, #2269).
      Org-mode allows to skip the argument of a code block header argument if
      it's toggling a value.  Argument-less headers are now recognized,
      avoiding weird parsing errors.
    + Fix markup parsing in headers (Albert Krewinkel, #2504).
      Markup as the very first item in a header wasn't recognized.  This was
      caused by an incorrect parser state: positions at which inline markup
      can start need to be marked explicitly by changing the parser state.
      This wasn't done for headers.  The proper function to update the state
      is now called at the beginning of the header parser, fixing this issue.
    + Fix emphasis rules for smart parsing (Albert Krewinkel, #2513).
      Smart quotes, ellipses, and dashes should behave like normal quotes,
      single dashes, and dots with respect to text markup parsing.
    + Require whitespace around definition list markers (#2518).
      This rule was not checked before, resulting in bugs with footnotes
      and some link types.

  * Markdown reader:

    + Pipe tables with long lines now get relative cell widths (#2471).
      If a pipe table contains a line longer than the column width (as set by
      `--columns` or 80 by default), relative widths are computed based on the
      widths of the separator lines relative to the column width.  This should
      solve persistent problems with long pipe tables in LaTeX/PDF output, and
      give more flexibility for determining relative column widths in other
      formats, too.  For narrower pipe tables, column widths of 0 are used,
      telling pandoc not to specify widths explicitly in output formats that
      permit this.
    + Improved parser for `mmd_title_block`.  We now allow blank metadata
      fields.  These were explicitly disallowed before.
    + Citation keys can now contain `://`, so URLs and DOIs can be used
      as citation keys (jgm/pandoc-citeproc#166).

  * Beamer template:  fix incompatibility of section slides with natbib.
    Natbib (and presumably biblatex) bibliography commands create
    their own section.  Since these are in frame environments,
    we have an incompatibility with the `\AtBeginSection` macro
    which creates a special frame when a new section occurs.
    (We can't have a frame inside another frame.) This change disables
    `\AtBeginSection` inside bibliography slides.  Thinks to Yihui Xie for
    bringing the problem to my attention.  This supersedes #145.  See
    discussion there.

  * Textile reader:  don't do smart punctuation unless explicitly asked
    (#2480).  Note that although smart punctuation is part of the textile
    spec, it's not always wanted when converting from textile
    to, say, Markdown.  So it seems better to make this an option.

  * LaTeX reader: Handle `comment` environment (Arata Mizuki).
    The `comment` environment is handled in a similar way to the
    `verbatim` environment, except that its content is discarded.

  * Docx reader:  Follow relationships correctly in foot/endnotes (#2258,
    Jesse Rosenthal).  This fixes a problem with links in notes.

  * LaTeX and ConTeXt writers: support `lang` attribute on divs and spans
    (mb21).  For LaTeX, also collect `lang` and `dir` attributes on spans and
    divs to set the `lang`, `otherlangs` and `dir` variables if they aren’t set
    already.  See #895.

  * LaTeX writer:

    + Use proper command for `\textarabic` (mb21).
    + Added `de-CH-1901`, fixed `el-polyton` in `toPloyglossia` (Nick Bart).
    + Use `\hypertarget` and `\hyperlink` for links.  This works correctly
      to link to Div or Span elements.  We now don't bother defining `\label`
      for Div or Span elements.  Closes jgm/pandoc-citeproc#174.
    + Avoid footnotes in list of figures (#1506).
    + Properly handle footnotes in captions (#1506).
    + Add `\protect` to `\hyperlink` (#2490).  Thanks to Hadrien Mary.
    + Set `colorlinks` if `linkcolor`, `urlcolor`, `citecolor`, or
      `toccolor` is set (#2508).

  * Textile writer: support start number in ordered lists (#2465).

  * OpenDocument writer:  Allow customization of opendocument
    automatic styles.  Automatic styles can now be inserted in the
    template, which now provides the enclosing `<office:automatic-styles>`
    tags (#2520).

  * Docx writer:  insert space between footnote reference and note (#2527).
    This matches Word's default behavior.

  * EPUB writer:  don't download linked media when `data-external` attribute
    set (#2473).  By default pandoc downloads all linked media and includes it
    in the EPUB container.  This can be disabled by setting `data-external` on
    the tags linking to media that should not be downloaded.  Example:

        <audio controls="1">
         <source src="http://www.sixbarsjail.it/tmp/bach_toccata.mp3"
         type="audio/mpeg"></source>
        </audio>

  * HTML writer:  use width on whole table if col widths sum to < 100%.
    Otherwise some browsers display the table with the columns
    separated far apart.

  * AsciiDoc template:  Fix `author` and `date`; add `keywords`,
    `abstract` (Andrew Dunning).

  * HTML-based templates (Andrew Dunning):

    + Use en dash instead of hyphen between title prefix and title.
    + Add `keywords` to metadata.
    + Add `lang`, `dir`, `quotes` where missing.
    + Always make author and date display conditional.
    + Updated dzslides template from source.

  * Man template: make "generated by" comment conditional.

  * LaTeX, Beamer templates:

    + Add `babel-otherlangs` for language divs/spans; `babel-newcommands`,
      filled by commands that make babel understand the polyglossia-style
      language directives (mb21, #137).
    + Improved formatting of conditionals; `$for$` is always provided to allow
      multiple options (Andrew Dunning, #141).
    + Use `Ligatures=TeX` rather than `Mapping=tex-text` with `fontspec`
      to improve support for LuaTeX (Andrew Dunning, #135).
    + Revise `hyperref` usage (Andrew Dunning, #139, #141):
        - use same options for all LaTeX engines;
        - add `subtitle` and `keywords` to PDF metadata;
        - do not override `hyperref` link coloring without user input, effectively making
          the `hidelinks` option the default (removed as a separate variable);
        - link colors can be enabled (using a slightly darker version of the old
          defaults) using a new `colorlinks` variable, automatically used by
          the LaTeX writer when custom colors are specified;
        - `pdfborder={0 0 0}` is automatically set by `hyperref` with
          `colorlinks`, and is only applied if `colorlinks` is disabled.

  * ConTeXt template (Andrew Dunning):

    + New variables for controlling styles: `linkstyle`, `linkcolor`,
      `linkcontrastcolor`, `layout`, `pagenumbering`, `whitespace`, `indenting`,
      `interlinespace`, `headertext`, `footertext`, `mainfont`, `sansfont`,
      `monofont`, `mathfont`, `fontsize`.
    + Default template no longer supports MkII.
    + Improve writing of title block (suppressing numbering of first page).
    + Add `title` `subtitle`, `author`, `date`, `keywords` to PDF metadata.
    + Support `subtitle`, `abstract`.
    + Support list of figures (`lof`), list of tables (`lot`).
    + Disable link styling by default.
    + Define styles for all section types.
    + Enable microtype.
    + Improved formatting of conditionals.

  * Beamer template:  added code to prevent slide breaks inside paragraphs
    (#2422, thanks to Nick Bart).  This will matter, in practice, only when
    `allowframebreaks` is used.  It is especially helpful for bibliography
    slides.

  * OpenDocument template:  Add `<office:automatic-styles>` tag around
    automatic styles.  The writer now longer provides this (see #2520).

  * Restored Text.Pandoc.Compat.Monoid.

  * Do not export (<>) from custom Prelude.  The Prelude now matches
    base 4.8 Prelude's API.

  * Don't use custom prelude with ghc 7.10.  Use the custom prelude
    only for earlier versions.  This change makes `stack ghci` and
    `cabal repl` work (#2503), at least with ghc 7.10.

  * Changed § to % in operators from Odt.Arrows.Utils (#2457).
    This prevents problems building haddocks with "C" locale.

  * Change default for old-locale flag to False.

  * Use stack in deb, osx, and Windows package generators.

  * Added Vagrantfile for building deb in vm.
    This should help in automating binary package creation.  'make package'
    will make the package.  'make package COMMIT=blah' will make the package
    from commit blah.

  * README:

    + Consistent capitalization for pandoc and Markdown.
    + Fixed `auto_identifiers` examples (Benoit Schweblin).
    + Improved documentation of template variables (Andrew Dunning).

## pandoc 1.15.1 (2015-10-15)

  * `pandocVersion` is now defined in `Text.Pandoc.Shared`
    and reexported from `Text.Pandoc` (Alex Vong).  This allows
    writers to access it.  (Alex Vong) (API change)

  * For `markdown_mmd`, add: `implicit_figures`, `superscripts`,
    `subscripts` (#2401).

  * Added `odt` as input format (MarLinn).  Added new module
    `Text.Pandoc.Reader.ODT` (API change). Fully implemented features:
    Paragraphs, Headers, Basic styling, Unordered lists, Ordered lists,
    External Links, Internal Links, Footnotes, Endnotes, Blockquotes.
    Partly implemented features: Citations, Tables.

  * Markdown Reader:

    + Add basic tests for each header style (Ophir Lifshitz).
    + Add implicit header ref tests for headers with spaces (Ophir Lifshitz).
    + Skip spaces in headers (Ophir Lifshitz).
    + Handle 'id' and 'class' in parsing key/value attributes (#2396).
      `# Header {id="myid" class="foo bar"}`
      is now equivalent to `# Header {#myid .foo .bar}`.
    + Use '=' instead of '#' for atx-style headers in markdown+lhs.
      (Kristof Bastiaensen)
    + Pipe tables: allow indented columns.  Previously the left-hand column
      could not start with 4 or more spaces indent.  This was inconvenient
      for right-aligned left columns.  Note that the first (header column)
      must still have 3 or fewer spaces indentation, or the table will be
      treated as an indented code  block.
    + Fix regression:  allow HTML comments containing `--`.
      Technically this isn't allowed in an HTML comment, but
      we've always allowed it, and so do most other implementations.
      It is handy if e.g. you want to put command line arguments
      in HTML comments.

  * LaTeX reader:

    + Don't eat excess whitespace after macros with only optional
      arguments (#2446).
    + Support longtable (#2411).
    + Implement `\Cite` (#2335).
    + Support abstract environment.  The abstract populates an
      `abstract` metadata field.
    + Properly handle booktabs lines.  Lines aren't part of the
      pandoc table model, so we just ignore them (#2307).

  * HTML reader:

    + Handle type attribute on ol, e.g. `<ol type="i">` (#2313).
    + Updated for new automatic header attributes.
    + Add auto identifiers if not present on headers.  This makes
      TOC linking work properly.
    + Detect `font-variant` with `pickStyleAttrProps` (Ophir Lifshitz).
    + Test `<ol>` type, class, and inline list-style(-type) CSS
      (Ophir Lifshitz).
    + Better handling of "section" elements (#2438).  Previously
      `<section>` tags were just parsed as raw HTML blocks.  With
      this change, section elements are parsed as Div elements with
      the class "section".

  * MediaWiki reader:  handle unquoted table attributes (#2355).

  * DocBook reader:

    + Added proper support for DocBook `xref` elements (Frerich Raabe).
      Added `dbContent` field to reader state, so we can lookup
      cross refs.
    + Handle `informalexample` (#2319).

  * Docx Reader:

    + Create special punctuation test (Ophir Lifshitz).
    + Parse soft, no-break hyphen elements (Ophir Lifshitz).
    + Updated headers test (Ophir Lifshitz). Replaced `styles.xml`
      in `headers.docx` with pandoc's current `styles.xml`, which
      contains styles for Heading 1 through 6. Added Heading 4
      through 7 to the test document. Note that Heading 7 is not
      parsed as a Heading because there is no Heading 7 style.

  * RST reader:  better handling of indirect roles.
    Previously the parser failed on this kind of case

        .. role:: indirect(code)

        .. role:: py(indirect)
           :language: python

        :py:`hi`

    Now it correctly recognizes `:py:` as a code role.

  * Org reader:

    + Add auto identifiers if not present on headers
      (#2354, Juliusz Gonera).
    + Allow verse blocks to contain empty lines (#2402,
      Albert Krewinkel).

  * EPUB reader:  stop mangling external URLs (#2284).

  * RST writer:

    + Don't insert `\ ` when complex expression in matched pairs.
      E.g. `` [:sup:`3`] `` is okay; you don't need `` [:sup:`3`\ ] ``.
    + Ensure that `\ ` is inserted when needed before Cite and Span
      elements that begin with a "complex" element (jgm/pandoc-citeproc#157).
    + Normalize headers only in "standalone" mode (#2394).

  * Haddock writer: escape `*` and `^` (G. Bataille).

  * Markdown writer:

    + In TOC, add links to headers (#829).
    + Use unicode super/subscripts for digits in plain output
      (when the `superscripts` and `subscripts` extensions are
      not enabled).

  * Docx writer:

    + Moved invalid character stripping to `formattedString`.
      This avoids an inefficient generic traversal (#2356).
    + Use user data directory for `reference.docx` archive.
      This allows the test suite to work without installing pandoc first.
      It also brings the docx writer in line with the odt writer.
    + Tests:  docx writer tests now use `../data` for data directory.
      This allows tests to be run without installing first.
    + Tests: Use real jpg (not empty) for docx tests to avoid warning.

  * LaTeX writer:

    + Fixed detection of 'chapters' from template.
      If a documentclass isn't specified in metadata, but the
      template has a hardwired bookish documentclass, act as if
      `--chapters` was used.  This was the default in earlier
      versions, but it has been broken for a little while.
    + Correctly recognize book documentclass in metadata (#2395).
    + Set language-related variables automatically, depending
      on the value of the `lang` field, which is now always
      assumed to be in BCP47 format (mb21, #1614, #2437).
    + Add `\protect` to `\hyperdef` in inline context.  This way we
      don't get an error when this is used as a moveable argument (#2136).
    + Support all frame attributes in Beamer.
    + Percent-encode more special characters in URLs (#1640, #2377).
      The special characters are '<','>','|','"','{','}','[',']','^', '`'.

  * HTML writer:

    + Update KaTeX JS and CSS versions (Emily Eisenberg).
    + For dzslides, add `role="note"` for speaker notes (#1693).
    + Percent-encode more special characters in URLs (#1640, #2377).
      The special characters are '<','>','|','"','{','}','[',']','^', '`'.
    + Render Div with class `section` as `<section>` in HTML5.

  * EPUB writer:

    + In TOC, replace literal `<br/>` with space (#2105).
    + With `--webtex`, include image file rather than `data:` URI (#2363).

  * Native writer: format Div properly, with blocks separated.

  * Support bidirectional text output with XeLaTeX, ConTeXt and HTML
    (#2191, mb21).

  * Reference Docx:

    + Add missing Header 6 style (steel blue) (Ophir Lifshitz).
    + Correct `outlineLvl` for Header styles (Ophir Lifshitz).

  * Templates

    + Beamer:  Add `innertheme`, `outertheme` variables
      (Guilhem Bonnefille, #121). Add space after colon in figure caption.
      Integrate recent font and language updates from LaTeX template;
      allow use of `mainfont` variable for changing the slide text
      in XeTeX and LuaTeX (Andrew Dunning, #131).
    + LaTeX:  Add `mainfontoptions`, `sansfontoptions`,
      `monofontoptions`, `mathfontoptions`, `fontfamilyoptions`
      (Andrew Dunning, #122).  Support handling of bidirectional
      text (mb21, #120). Improve reliability of superscripts/subscripts
      under XeTeX and prevent letters and numbers from appearing on a
      different baseline by removing use of the `realscripts` package
      (via `xltxtra`).  To restore use of OpenType characters for these
      features under XeTeX or LuaTeX, add `\usepackage{realscripts}` to
      `header-includes` (Andrew Dunning, #130).  Remove redundant
      reference to `xunicode` (Andrew Dunning, #130).  Add `fontenc`,
      `indent`, `subparagraph` variables (Andrew Dunning).
      Allow use of `hidelinks` variable for `hyperref` package (Hugo Roy,
      #113).  Prevent package clash with `tufte-latex` and other classes that
      include `hyperref` or `color` (Xavier Olive, #115).
    + ConTeXt:  Support handling of bidirectional text (mb21, #120).
    + LaTeX and ConTeXt: Use more specific language variables.
      Instead of directly using `lang`, we now use `babel-lang` and
      `polyglossia-lang` and `context-lang`.  These variables are set by
      the writers to the necessary values, based on the `lang` variable
      (which now always takes a value in BCP47 format). (mb21, #114, #129).
    + HTML:  Support handling of bidirectional text (mb21, #120).
      Move HTML5 shiv after CSS and fix URL (Andrew Dunning).
      Add dir attribute in html5 (Andrew Dunning).
    + reveal.js: Add `controls`, `progress` variables (Grégoire Pineau, #127).
      Add `width`, `height` variables (Anrew Dunning).  Update template
      from 3.1 source (Andrew Dunning).  All configuration options are now
      available as variables, but are only be included if set (reveal.js
      uses defaults otherwise).
    + man: Added comment stating that the page is autogenerated by pandoc,
      giving version.  Added `adjusting` and `hyphenate` variables
      (Alex Vong, #123).

  * epub.css: added selectors for nested emphasis (Pablo Rodriguez).

  * MediaBag:  ensure that `/` is always used as path separator.

  * `sample.lua`: define `CaptionedImage`, add newline at end (#2393).

  * Added `--bash-completion` option.  This generates a bash completion
    script.  To use: `eval "$(pandoc --bash-completion)"`.

  * Text.Pandoc.Error: Define Typeable and Exception instances
    for PandocError (#2386).

  * Text.Pandoc.Parsing: `toKey`: strip off outer brackets.
    This makes keys with extra space at the beginning and end
    work:  e.g.

        [foo]: bar

        [ foo ]

    will now be a link to bar (it wasn't before).

  * Text.Pandoc: disable `auto_identifiers` for epub.
    The epub writer inserts its own auto identifiers;
    this is more complex due to splitting into "chapter" files.

  * Renamed Text.Pandoc.Compat.Locale -> Text.Pandoc.Compat.Time.
    It now reexports Data.Time.

  * Use custom Prelude to avoid compiler warnings.

    + The (non-exported) prelude is in prelude/Prelude.hs.
    + It exports Monoid and Applicative, like base 4.8 prelude,
      but works with older base versions.
    + It exports (<>) for mappend.
    + It hides 'catch' on older base versions.

  * Added a `stack.ymal` and stack install instructions to INSTALL.

  * Clarified what is "out of scope" in README and CONTRIBUTING.md.

  * Added note to CONTRIBUTING.md about ghc versions and travis.

  * Clarify docs on block quotes.  The space after `>` is optional (#2346).

  * Removed obsolete reference to default.csl (#2372).

  * List all styles in manual for `--reference-docx` (Chris Black)

  * Don't capitalize header links in man page.

  * Added section on repl to CONTRIBUTING.md.

  * README:  Added space after backslash in image example (#2329).

  * Document details of citation locator terms (Nick Bart).

  * Fixed some internal links in README (#2309).

  * Improve CSL documentation, variables documentations,
    links, and cross-references in README. (Andrew Dunning)

  * Fix build failure with `--flags=-https` (Sergei Trofimovich).

  * Use `newManager` instead of `withManager` in recent `http-client`.
    This avoids a deprecation warning.

  * Allow building with latest versions of http-types,
    HUnit, criterion, syb, aeson.

  * Updated benchmark program for new criterion API.

  * Setup.hs: rewrite so as not to use process, directory, filepath.
    Using anything outside base is dangerous, since older
    versions of ghc may link against two different versions.

  * Added appveyor (Windows continuous integration) builds.

  * New `.travis.yml`.  Autgenerated using `make_travis_yml.hs`.
    This script has been modified in a few ways, e.g. to add `GHCOPTS`.
    `make .travis.yml` regenerates it based on the tested-with
    field of the cabal file.

## pandoc 1.15.0.6 (2015-07-15)

  * `--self-contained`: Fixed overaggressive CSS minimization
    (#2301, 2286). Previously `--self-contained` wiped out all
    spaces in CSS, including semantically significant spaces.
    This was a regression from 1.14.x.

  * Markdown reader: don't allow bare URI links or autolinks in link
    label (#2300).  Added test cases.

  * `Text.Pandoc.Parsing`, `uri`: Improved bare autolink detection (#2299).
    Previously we disallowed `-` at the end of an autolink,
    and disallowed the combination `=-`.  This commit liberalizes the
    rules for allowing punctuation in a bare URI, and adds test cases.
    One potential drawback is that you can no longer put a bare
    URI in em dashes like this:
    `this uri---http://example.com---is an example.`
    But in this respect we now match github's treatment of bare URIs.

  * HTML writer:  support speaker notes in dzslides.
    With this change `<div class="notes">` and also `<div class="notes"
    role="note">` will be output if `-t dzslides` is used. So we can
    have speaker notes in dzslides too.  Thanks to maybegeek.

  * Updated dzslides template.

  * Improved documentation of options to print system default files (#2298).
    `--print-default-data-file` and `--print-default-template`.

  * DokuWiki writer: use `$..$` for Math instead of `<math>..</math>`
    (Tiziano Müller).  MathJax seems currently to be the only maintained
    math rendering extension for DokuWiki.

  * `Text.Pandoc.Shared`: Changed `hierarchicalize` so it treats references
    div as top-level header (#2294).  This fixes a bug with `--section-divs`,
    where the final references section added by pandoc-citeproc, enclosed in
    its own div, got nested in the div for the section previous to it.

  * Allow vector 0.11.

  * Require cmark > 0.4.

## pandoc 1.15.0.5 (2015-07-10)

  * HTML writer: Fixed email javascript obfuscation with `mailto:`
    URLs (#2280).  This fixes a potential security issue.  Because
    single quotes weren't being escaped in the link portion, a
    specially crafted email address could allow javascript code injection.

  * RST reader:  allow inline formatting in definition list field
    names (Lars-Dominik Braun).

  * PDF:  Make sure `--latex-engine-opt` goes before the filename
    on the command line.  LaTeX needs the argument to come after
    the options (#1779).

  * CommonMark writer: fixed tags used for super/subscript.

  * ConTeXt template:  activate hanging indent for definition lists
    (mb21).

  * Make cabal require `hsb2hs` >= 0.3.1 if `embed_data_files` specified.
    This is done by adding `hookedPrograms` in `Setup.hs`, which allows us
    to include `hsb2hs` in Build-Tools in cabal.

  * Improved Windows installer (thanks to nkalvi).

    + When per-machine installation is chosen, the system path
      is updated instead of the user's.
    + An appropriate default is used for per-machine installation
      directory.
    + Admin privileges are no longer required for a per-user install

  * Travis:  unpack sdist for build to catch packaging bugs.

  * Improved documentation on where user templates go (#2272).

## pandoc 1.15.0.4 (2015-07-03)

  * Added pandoc.1 man page to the repository.  It is no longer
    built as part of the cabal build process. (This proved too
    fragile.)  pandoc.1 can be regenerated (`make man/pandoc.1`)
    when `README` is changed.

  * Copying of the man page now respects `--destdir` (#2262).

  * Improved error messages for filters.  User is now informed if
    the filter requires an interpreter that isn't found in the path,
    or if the filter returns an error status.

## pandoc 1.15.0.3 (2015-07-02)

  * Ensure target directory is created when installing man page.

## pandoc 1.15.0.2 (2015-07-02)

  * Added files needed for building man page to Extra-Source-Files.

## pandoc 1.15.0.1 (2015-07-01)

  * Man page is now built and installed as part of the cabal build
    process. Removed Makefile target for man page.

## pandoc 1.15 (2015-07-01)

  * Man page changes:

    + Removed `--man1`, `--man5` options (breaking change).
    + Removed `Text.Pandoc.ManPages` module (breaking API change).
    + Makefile target for `man/man1/pandoc.1`.  This uses pandoc to
      create the man page from README using a custom template and filters.
    + Added `man/` directory with template and filters needed to build
      man page.
    + We no longer have two man pages: `pandoc.1` and `pandoc_markdown.5`.
      Now there is just pandoc.1, which has all the content from README.
      This change was needed because of the extensive cross-references
      between parts of the README.
    + Removed old `data/pandoc.1.template` and
      `data/pandoc_markdown.5.template`.

  * OpenDocument writer: Do not add a carriage return after a hard
    line break (Michael Chladek).

  * ConTeXt writer:

    + use `\goto` for internal links.
    + Added a `%` at end for `\reference` to avoid spurious space.

  * Ignore sandbox on 'make quick'

## pandoc 1.14.1 (2015-06-30)

  * Added `--man1` and `--man5` options to pandoc, allowing
    pandoc to generate its own man pages. Man pages are no longer
    automatically generated in the build process (the process for
    this was too complex and prone to failure, #2190). The
    `make-pandoc-man-pages` executable has been removed. The
    `man/` directory has been removed, and man page templates
    have been moved to `data/`. NOTE TO PACKAGERS: You will no
    longer find pandoc's man pages in `man/`, but you can
    generate them using `pandoc --man1 > pandoc.1` and `pandoc
    --man5 > pandoc_markdown.5`.

  * Added new unexported module:  `Text.Pandoc.ManPages`.

  * `README` now acts like a data file (even though it isn't in
    `data/`).  So, for example, `pandoc --print-default-data-file README`
    will produce the README.)  This change was required for the `--man1`
    and `--man5` options, since the man pages are produced from the
    README, but it may be useful for other purposes as well.

  * Allow `reference.docx` and `reference.odt` to be used with
    `--print-default-data-file` and to shadow defaults if placed in
    the user data directory.  Note that as of 1.14, we no longer
    include these files as data files; instead, we include their
    components.  This change causes pandoc to behave as if it has
    these data files; they are constructed on demand when needed
    using `getDefaultReferenceDocx` and `getDefaultReferenceODT`.

  * Fixed regression in CSS parsing with `--self-contained` (#2224).
    Pandoc 1.14.0.x used css-text to parse the CSS, but its parser
    silently drops big sections of CSS.  This commit replaces the
    use of css-text with a small but principled CSS preprocessor,
    which removes whitespace and comments and replaces `url()` with
    base 64 data when possible.

  * Use `https://` instead of `//` for MathJax and KaTeX CDN URLs (#1920).
    This will allow math to work when pages are being viewed locally.

  * `Text.Pandoc.Options`:  Export `plainExtensions`.
    These are the extensions used in `plain` output.

  * LaTeX reader: Don't parse `_` and `^` as sub/superscript outside of
    math mode; treat them as regular inline text.  Normally these will
    cause an error in LaTeX, but there are contexts (e.g. `alltt`
    environments) where they are allowed.

  * HTML reader:  allow `<body>` to close `<head>`.

  * DocBook reader: support `mediaobject`s and `figures` (#2184, mb21).

  * RST reader: Fix reference names with special characters
    (Lars-Dominik Braun).

  * Textile writer:  escape `+` and `-` as entities (#2225).

  * DokuWiki writer: Use proper `<code>` tags for code blocks (#2213).

  * Plain writer:  don't use symbols for super/subscript (#2237).
    Simplified code by using `plainExtensions`.

  * InDesign writer: Properly escape URLs containing more than one
    colon character (gohai).

  * Docx writer: Make sure we use dist version of `reference.docx`
    (and not the user's version) for certain settings.  Taking some
    settings values from a user-supplied reference.docx can lead to
    corruption.  This fixes a regression from the last release (#2249).

  * `Text.Pandoc.Shared`: exports `getDefaultReferenceDocx` and
    `getDefaultReferenceODT` (API change).  These functions have been
    removed from the Docx and ODT writers.

  * LaTeX template (Xavier Olive):
    + Added `CJKmainfont` and `CJKoptions` variables.
    + Allow dvipsnames (e.g. `MidnightBlue`) for colors (Xavier Olive).

  * Epub templates:  use `author.role`, not `author.type`.

  * Bump cmark version to >= 0.3.4.

  * Improved Windows installer (#2205, thanks to nkalvi).
    Users can now select a per-user or systemwide install, and can set
    the installation path.  At the end of installation, the install location
    is given.  The install location is also now given in the list of
    installed programs in Control Panel.  Cleaner WiX syntax is used for
    setting the path.

  * Added `download_stats` target to Makefile.

## pandoc 1.14.0.4 (2015-06-02)

  * Added missing commonmark template.

  * Improved try pandoc (moved button, show raw command).

## pandoc 1.14.0.3 (2015-06-01)

  * Allow compilation with syb 0.5.*.

  * Custom writer:  fixed some compiler warnings for ghc < 7.10.

## pandoc 1.14.0.2 (2015-05-31)

  * Allow building with hslua 0.4.

## pandoc 1.14.0.1 (2015-05-28)

  * Fixed problem with building of `reference.docx` and `reference.odt`
    when the `embed_data_files` flag is used.  Instead of having a phase
    of the build where `reference.docx` and `reference.odt` are created
    from their constituent data files, we now construct these archives
    from their constituents when a `docx` or `odt` is built.  The
    constituent files have been moved from `extra-source-files` to
    `data-files`, and `reference.docx` and `reference.odt` have been
    removed. Users can create their own `reference.docx` or
    `reference.odt` by using pandoc to create a simple `docx` or `odt`.
    `make-reference-files.hs` has been removed, simplifying the build
    process (#2187)

  * Don't include generated man pages in extra-source-files (#2189).

  * Bumped upper bound for aeson.

  * ConTeXt writer:  create internal link anchors for Div elements with
    identifiers.  (This is needed for linked citations to work.)

## pandoc 1.14 (2015-05-27)

### New features

  * Added `commonmark` as input and output format.

  * Added `--verbose` flag for debugging output in PDF production (#1840,
    #1653).

  * Allow wildcards in `--epub-embed-font` arguments (#1939).

  * Added `--latex-engine-opt` option (#969, #1779, Sumit Sahrawat).

  * Added `shortcut_reference_links` extension (Konstantin Zudov, #1977).
    This is enabled by default for those markdown flavors that
    support reading shortcut reference links, namely: `markdown`,
    `markdown_strict`, `markdown_github`, `markdown_php`.
    If the extension is enabled, the reader parses shortcut reference
    links like `[foo]`, and the writer creates such links unless doing
    so would cause problems.  Users of markdown flavors that support
    shortcut reference links should not notice a difference in reading
    markdown, but the markdown pandoc produces may differ.
    If shortcut links are not desired, the extension can be disabled
    in the normal way.

### Behavior changes

  * `--toc` is now supported for `docx` output (#458, Nikolay Yakimov).
    A "dirty" TOC is created at the beginning of document.
    It can be regenerated after the document has been opened.

  * An implicit `--filter pandoc-citeproc` is now triggered only when the
    `--bibliography` option is used, and not when the `bibliography`
    field in metadata is specified (#1849).

  * Markdown reader:

    + Reference links with `implicit_header_references` are no longer
      case-sensitive (#1606).
    + Definition lists no longer require indentation for first line (#2087).
      Previously the body of the definition (after the `:` or `~` marker)
      needed to be in column 4.  This commit relaxes that requirement,
      to better match the behavior of PHP Markdown Extra.  So, now
      this is a valid definition list:

            foo
            : bar
    + Resolve a potentially ambiguity with table captions:

            foo

              : bar

              -----
              table
              -----

      Is "bar" a definition, or the caption for the table?  We'll count
      it as a caption for the table.
    + Disallow headerless pipe tables (#1996), to conform to GFM and PHP
      Markdown Extra.  Note:  If you have been using headerless pipe tables,
      this change may cause existing tables to break.
    + Allow pipe tables with header but no body (#2017).
    + Allow a digit as first character of a citation key (Matthias Troffaes).
      See https://github.com/jgm/pandoc-citeproc/issues/97

  * LaTeX reader:

    + Don't limit includes to `.tex` extension (#1882).
      If the extension is not `.tex`, it must be given explicitly in
      the `\input` or `\include`.

  * Docx reader:

    + Allow numbering in the style file.  This allows inherited styles
      with numbering (lists) (Jesse Rosenthal).

  * Org reader:

    + Support smart punctuation (Craig Bosma).
    + Drop trees with a :noexport: tag (Albert Krewinkel). Trees having a
      `:noexport:` tag set are not exported.  This mirrors org-mode.
    + Put header tags into empty spans (Albert Krewinkel, #2160).
      Org mode allows headers to be tagged: `* Headline  :TAG1:TAG2`.
      Instead of being interpreted as part of the headline, the tags are now
      put into the attributes of empty spans.  Spans without textual content
      won't be visible by default, but they are detectable by filters.  They
      can also be styled using CSS when written as HTML.
    + Generalize code block result parsing (Albert Krewinkel).
      Previously, only code blocks were recognized as result blocks;
      now, any kind of block can be the result.

  * Append newline to the LineBreak in Dokuwiki, HTML, EPUB,
    LaTeX, MediaWiki, OpenDocument, Texinfo writers (#1924, Tim Lin).

  * HTML writer:

    + Add "inline" or "display" class to math spans (#1914).
      This allows inline and display math to be styled differently.
    + Include raw latex blocks if `--mathjax` specified (#1938).
    + Require highlighting-kate >= 0.5.14 (#1903).
      This ensures that all code blocks will be wrapped in a `div`
      with class `sourceCode`.  Also, the default highlighting CSS
      now adds `div.sourceCode { x-overflow: auto; }`, which means
      that code blocks (even with line numbers) will acquire a scroll
      bar on screens too small to display them (e.g. mobile phones).
      See also jgm/highlighting-kate#65.

  * LaTeX writer:

    + Use a declaration for tight lists (Jose Luis Duran, Joseph
      Harriott). Previously, pandoc hard-coded some commands to make
      tight lists in LaTeX.  Now we use a custom command instead,
      allowing the styling to be changed in a macro in the header.
      (Note:  existing templates may need to be modified to include
      the definition of this macro.  See the current template.)
    + Beamer output: if the header introducing a slide has the
      class `fragile`, add the `[fragile]` option to the slide (#2119).

  * MediaWiki writer:

    + Use `File:` instead of the deprecated `Image:` for images and
      other media files (Greg Rundlett).

  * DocBook writer:

    + Render a `Div (id,_,_) [Para _]` element as a `para` element
      with an `id` attribute.  This makes links to citations work in
      DocBook with pandoc-citeproc.

  * RST writer:

    + Normalize headings to sequential levels (Nikolay Yakimov).
      This is pretty much required by docutils.
    + Treat headings in block quotes, etc as rubrics (Nikolay Yakimov).
    + Better handling of raw latex inline (#1961).  We use
      `` :raw-latex:`...` `` and add a definition for this role to
      the template.

  * EPUB writer:

    + Remove `linear=no` from cover `itemref` (#1609).
    + Don't use `sup` element for epub footnotes (#1995).
      Instead, just use an a element with class `footnoteRef`.
      This allows more styling options, and provides better results
      in some readers (e.g. iBooks, where anything inside the a
      tag breaks popup footnotes).
    + Take TOC title from `toc-title` metadata field.

  * Docx writer:

    + Implemented `FirstParagraph` style (Jesse Rosenthal).
      Following the ODT writer, we add the `FirstParagraph` style to the
      first text paragraph following an image, blockquote, table, heading,
      or beginning of document.  This allows it to be styled differently.
      The default is for it to be the same as `Normal`.
    + Added `BodyText` style (Jesse Rosenthal).
      We apply a `BodyText` style to all unstyled paragraphs. This is,
      essentially, the same as `Normal`, except that since not everything
      inherits from `BodyText` (the metadata won't, for example, or
      the headers or footnote numbers), we can change the text in the body
      without having to make exceptions for everything.  If we do want to
      change *everything*, we can still do it through `Normal`.
    + Altered `Blockquote` style slightly (Jesse Rosenthal).
      Since `BlockQuote` derives from `BodyText`, we just want to specify
      by default that it won't indent, regardless of what `BodyText` does.
      Note that this will not produce any visible difference in the default
      configuration.
    + Take TOC title from `toc-title` metadata field (Nikolay Yakimov).
    + Added a style to figure images (Nikolay Yakimov).
      Figures with empty captions use style `Figure`.
      Figures with nonempty captions use style `Figure with Caption`, which
      is based on `Figure`, and additionally has `keepNext` set.

  * ODT writer:

    + Added figure captions (Nikolay Yakimov). The following styles are
      used for figures:
      `Figure` -- for figure with empty caption),
      `FigureWithCaption` (based on `Figure`) -- for figure with caption,
      `FigureCaption` (based on `Caption`) -- for figure captions.
      Also, `TableCaption` (based on `Caption`) is used for table captions.

### API changes

  * New `Text.Pandoc.Error` module with `PandocError` type
    (Matthew Pickering).

  * All readers now return `Either PandocError Pandoc` instead of `Pandoc`
    (Matthew Pickering).  This allows better handling of errors.

  * Added `Text.Pandoc.Writers.CommonMark`, exporting `writeCommonMark`.

  * Added `Text.Pandoc.Readers.CommonMark`, exporting `readCommonMark`.

  * Derive `Data` and `Typeable` instances for `MediaBag`, `Extension`,
    `ReaderOptions`, `EPUBVersion`, `CiteMethod`, `ObfuscationMethod`,
    `HTMLSlideVariant`, `TrackChanges`, `WriterOptions` (Shabbaz
    Youssefi).

  * New `Ext_shortcut_reference_links` constructor for `Extension`
    (Konstantin Zudov).

###  Bug fixes

  * Markdown reader:

    + Allow smart `'` after inline math (#1909, Nikolay Yakimov).
    + Check for tex macros after indented code (#1973).
    + Rewrote `charsInBalancedBrackets` for efficiency.
    + Make sure a closing `</div>` doesn't get included in a
      definition list item (#2127).
    + Don't parse bracketed text as citation if it might be a link,
      image, or footnote (Nikolay Yakimov).
    + Require space after key in mmd title block (#2026, Nikolay
      Yakimov).  Require space after key-value delimiter colon in mmd title
      block.
    + Require nonempty value in mmd title block (Nikolay Yakimov).
    + Disable all metadata block extensions when parsing
      metadata field values (#2026, Nikolay Yakimov).  Otherwise we
      could get a mmd title block inside YAML metadata, for example.

  * HTML reader:

    + Improve self-closing tag detection in `htmlInBalanced` (#2146).
    + Handle tables with `<th>` in body rows (#1859, mb21).
    + Fixed `htmlTag` (#1820).  If the tag parses as a comment, we check
      to see if the input starts with `<!--`. If not, it's bogus comment
      mode and we fail `htmlTag`.
    + Handle `base` tag; if it has an `href` value, this is added to
      all relative URLs in links and images.

  * DocBook reader:

    + Look inside "info" elements for section titles (#1931).

  * Docx reader:

    + Parse images in deprecated vml format (Jesse Rosenthal).
    + Allow sub/superscript verbatims (Jesse Rosenthal).
      Verbatim usually shuts off all other run styles, but we don't want it
      to shut off sub/superscript.

  * LaTeX reader:

    + Handle `tabular*` environment (#1850).
      Note that the table width is not actually parsed or taken into
      account, but pandoc no longer chokes on it.
    + Ignore options in `\lstinline` rather than raising error (#1997).
    + Add some test cases for simple tables (Mathias Schenner).
    + Handle valign argument in tables (Mathias Schenner) (currently
      we just ignore this).
    + Allow non-empty colsep in tables (Mathias Schenner).
      The `tabular` environment allows non-empty column separators
      with the "@{...}" syntax. Previously, pandoc would fail to
      parse tables if a non-empty colsep was present. With this
      commit, these separators are still ignored, but the table gets
      parsed. A test case is included.
    + Recognize `\newpage` as a block command.
    + Allow block content in `\title{}` (#2001).
    + Check for block-level newcommand aliases in blockCommand (Nikolay
      Yakimov).
    + Guard against paragraph starting with inline macro (Nikolay Yakimov).
    + Properly gobble spaces after `\\` (#2007).

  * Textile reader:

    +  Handle newlines in table cells, and empty cells (#1919).

  * Org reader:

    + Allow image links with non-image targets (Hans-Peter Deifel).
      This matches behavior of Org-Mode for links like
      `[[http://example.com][https://www.haskell.org/static/img/logo.png]]`.

  * Docbook writer:

    + Don't print empty id attributes (thanks to Steve Horne).

  * HTML writer:

    + Fixed list-style-type for numbered example lists.
      Should be "decimal," not "example" (#1902).
    + Do not omit missing `alt` attribute on `img` tag (#1131,
      Konstantin Zudov).
    + Allow multiple colgroups in table (#2122).
    + In revealjs, ensure that lists in speaker notes don't add "fragment"
      classes, which can cause additional keypresses to be needed to
      advance a slide (#1394).

  * LaTeX writer:

    + Don't escape `$` in URL (#1913).
    + Don't use listings in headers (Matthew Pickering, #1963).
    + Recognize book documentclass if set in metadata (#1971).
      This sets `--chapters` implicitly if the documentclass in metadata
      is a book documentclass.  Previously this was done only if a book
      documentclass was set in a variable.
    + Add a `\label` in `\hyperdef` for Div, Span (or links don't work).
    + Make `mainlang` work when `lang` is in metadata (#2174).

  * Texinfo writer:

    + Fix wrapping by using breakable spaces (Tim Lin).

  * RST writer:

    + Fixed toc depth in RST writer.  Previously the depth was being
      rendered as a floating point number with a decimal point.

  * Markdown writer:

    + Improved escaping (#2086).  `<` should not be escaped as `\<`, for
      compatibility with original Markdown.  We now escape `<` and `>`
      with entities.  Also, we now backslash-escape square brackets.
    + Avoid introducing spurious list items through wrapping (#1946).
    + Don't emit span tags if plain or raw HTML disabled.

  * MediaWiki writer:

    + Convert spaces to underscores in wikilink URL (#1982), like MediaWiki.

  * AsciiDoc writer:

    + Insert some needed blank lines (#1860).
    + Avoid wrapping after list marker (#1858).

  * EPUB writer:

    + Properly handle internal links to IDs in spans, divs (#1884).
    + Use plain writer for metadata dc: fields (#2121).
      This gives better results when we have, e.g. multiple paragraphs.
      Note that tags aren't allowed in these fields.
    + Properly handle image links without an extension (#1855).
    + Improved chapter splitting and internal link rewriting (#1887,
      #2162, #2163).  This will ensure that internal links work and
      that the references section produced by pandoc-citeproc is
      in its own chapter.
    + Fixed handling of svg images (#2183).

  * ICML writer:

    + Better handling of raw blocks and inlines (#1951).
      Previously these were always escaped and printed verbatim.
      Now they are ignored unless the format is `icml`, in which
      case they are passed through unescaped.
    + Fixed image URIs in ICML output (gohai).

  * Custom writer:

    + Raise error if loadstring returns an error status.
    + Raise `PandocLuaException` instead of using 'error'.
      Eventually we'll change the return type so that no exception
      is involved, but at least this can be trapped.
    + Use UTF-8 aware bytestring conversion.
    + Set foreign encoding to UTF-8 (Nikolay Yakimov, #2101, #1634).
      Also factored out ByteString, since it's only used as an intermediate
      representation.

  * Docx writer:

    + Copy hyphenation settings from reference.docx (Nikolay Yakimov).
    + Filter out illegal XML characters (#1992, Matthew Pickering).
    + Added `noProof` to docx syntax highlighting `SourceCode` style.
    + Added footnotes id -1 and 0 (Jesse Rosenthal).
      Word uses, by default, footnotes with id -1 and 0 for separators. If a
      user modifies `reference.docx`, they will end up with a `settings.xml`
      file that references these footnotes, but no such footnotes in the
      document. This will produce a corruption error. Here we add these to the
      document and `settings.xml` file, so future modifications won't break
      the file.
    + Handle lists correctly inside table cells (Jesse Rosenthal).
      Previously we didn't transform lists inside table cells.
    + Set firstRow information in tables (Nikolay Yakimov).
    + Don't replace `SourceCode` style in `reference.docx` if it is defined
      there (Nikolay Yakimov, #1872).  If `--no-highlight` specified, remove
      any `SourceCode` and `*Tok` styles in `reference.docx`.
    + Attempt to match international style names (#1607, Nikolay Yakimov).
    + Set these styles as custom (Nikolay Yakimov): `Author`, `Abstract`,
      `Compact`, `Image Caption`, `Table Caption`, `Definition Term`,
      `Definition`, `First Paragraph`.
    + Rename these styles to correspond with Word `Normal.dotm` (Nikolay
      Yakimov): `Block Quote -> Block Text`, `Link -> Hyperlink`,
      `Footnote Ref -> Footnote Reference`.
    + Added `Caption` style (Nikolay Yakimov).
    + Changed these styles' inheritance (Nikolay Yakimov):
      `Image Caption <- Caption`, `Table Caption <- Caption`.
    + Remove `SourceCode` style from `reference.docx` (#1872).
      This is added automatically by the docx writer.
    + Added toc heading style to `reference.docx` (Nikolay Yakimov).

  * `Text.Pandoc.PDF`

    + Don't suggest "Try xelatex" if xelatex already in use (mb21, #1832).
    + More comprehensible errors on image conversion (#2067).
      EPS can't be supported without shelling out to something like
      ImageMagick, but at least we can avoid mysterious error messages.

  * `Text.Pandoc.Shared`:

    + Make safeRead safe (#1801, Matthew Pickering).
    + Added `mapLeft`, `hush` (Matthew Pickering).

  * `Text.Pandoc.Pretty`:

    + Remove partial function (Matthew Pickering).

  * `Text.Pandoc.SelfContained`:

    + Add `;charset=utf-8` to script mime type if missing (#1842).
    + Improved building of data URIs (#1940).  Now base64 is used except
      for `text/*` mime types.
    + `cssURLs` no longer tries to fetch fragment URLs (#2121).
    + Properly handle data URIs in css urls (#2129).
      Use a proper CSS parser (adds dependency on `text-css`).

  * `Text.Pandoc.UTF8`:

    + Better handling of bare CRs in input files (#2132).
      Previously we just stripped them out; now we convert
      other line ending styles to LF line endings.

  * `Text.Pandoc.ImageSize`:

    + Fixed some exif header parsing bugs (#1834).
    + Make imageSize return an Either, not a Maybe (#1834).
      Use `runGetOrFail` (with `binary >= 0.7`) to return `Left` on
      parse failure (rather than `error`).
    + Improved warnings when image size can't be determined.
    + Removed error landmines (Matthew Pickering).

  * Added woff2 to MIME types (Alfred Wechselberger).

  * pandoc:  When a binary input format is used, warn that file
    arguments past the first one are being ignored (Matthew Pickering).

### Template changes

  * LaTeX template:

    + Degrade gracefully if `\paragraph` not defined.
    + Include `grffile` together with `graphicx` (#2074).
      This properly handles filenames containing spaces and dots.
    + Redefine `\paragraph`, `\subparagraph`...  to behave more
      like section headers (#1658).
    + Import hyperref before polyglossia to avoid an error with xelatex,
      "please load package hyperref before bidi package" (Nick Bart).
    + Added `toccolor` variable to control link color in toc (Kaixhin).

  * LaTeX, Beamer templates:

    + Provide `\tightlist`, which is now used by the LaTeX writer.
    + Use polyglossia in beamer (#85).
    + Use `bibliography` instead of `biblio-files`
      (#1661).  Also use `\addbibresource` instead of `\bibliography` for
      biblatex.
    + Added `setotherlanguages` in polyglossia. This uses an `otherlang`
      variable that is derived from a comma-separated list in `lang`;
      the last language is `mainlang` and the others are `otherlang`.

  * EPUB templates:

    + Use `div`, not `p`, for "rights" on title page.
    + Added header-includes, include-before, include-after (#1987).

  * OpenDocument template:

    + Use `text:p` instead of `text:h` for title.
      Using `text:h` causes problems with numbering.  Closes #2059.
      Thanks to @nkalvi for diagnosing this.

  * reveal.js template:

    + Link to non-minified css, js.  The minified versions no longer
      ship with the library.
    + Correctly include style CSS (#1949).
    + New configurable options options: `center`, `maxScale`, `slideNuber`
      (Dmitry Smirnov, pandoc-templates#89).
    + Moved custom CSS after theme.  This allows custom CSS to modify
      themes, instead of being replaced by them.
    + Allow `center` to be set to false.

### Under the hood improvements

  * Removed pre-built `reference.docx` and `reference.odt` (Nikolay
    Yakimov).  Instead the repository now includes the component text files,
    and the zipped binaries are built from these using a helper
    program, `make-reference-files`.  This should make maintenance of
    these components easier going forward.

  * `Text.Pandoc.Parsing`:

    + Added new `<+?>` combinator (Nikolay Yakimov).
    + Added `stateHeaderKeys` to `ParserState`.

  * `make_deb.sh` fixes:

    + Detect architecture.
    + Add Installed-Size to debian package control file (#1900).
    + Use `fakeroot` to get permissions right.
    + Use `mkdir` and `cp` instead of `install`.
    + Set permissions of directories to 755.
    + Install in `/usr` rather than `/usr/local`.
    + Compress man pages.
    + Combine copyright files for `pandoc`, `pandoc-citeproc`.

  * Added `Text.Pandoc.Compat.Locale` and `old-locale` flag
    to assist with transition to `time` 1.5.

  * Updated CONTRIBUTING.md with information about issue tags (Matthew
    Pickering).

  * Updated travis installs to the new sudo-less syntax (Tim Lin).

  * Updated dependency version bounds.

  * EPUB tests:  don't use `joinPath`, which varies across platforms.
    Instead, use a forward-slash to join paths, regardless of the
    platform. This matches the way `MediaBag` now works.

  * Clarify JSON input and output in usage message (Caleb McDaniel).

  * Improved INSTALL instructions.

  * Always build man pages.  Removed make-pandoc-man-pages flag.

  * Makefile:  removed man target, now that we generate man pages by default.

  * README:

    + Fixed typos (J. Lewis Muir).
    + Added documentation on backtick_code_blocks (#2135, Nikolay Yakimov).
    + Added note on in-field markup in biblio databases (Nick Bart).
    + Fixed misleading example of raw HTML block.
    + Various minor formatting and consistency fixes for the program
      options (Andreas Lööw).
    + Made definition lists for options all "loose" for consistency.
    + Added YAML biblio format to table, and note on `pandoc-citeproc`'s
      `--bib2json` and `--bib2yaml` options (Nick Bart).
    + Removed obsolete reference to `mods2yaml` (Nick Bart).
    + Added section on syntax highlighting.
    + Documented `toccolor` variable.

## pandoc 1.13.2.1 (2015-04-15)

  * Updated to build with ghc 7.10.1.

  * Bumped package upper bounds for filepath, blaze-html, blaze-markup.

## pandoc 1.13.2 (2014-12-20)

  * TWiki Reader: add new new twiki reader (API chaneg, Alexander Sulfrian).

  * Markdown reader:

    + Better handling of paragraph in div (#1591).
      Previously text that ended a div would be parsed as Plain
      unless there was a blank line before the closing div tag.
    + Don't treat a citation as a reference link label (#1763).
    + Fix autolinks with following punctuation (#1811).
      The price of this is that autolinked bare URIs can no longer
      contain `>` characters, but this is not a big issue.
    + Fix `Ext_lists_without_preceding_blankline` bug (#1636, Artyom).
    + Allow `startnum` to work without `fancy_lists`. Formerly
      `pandoc -f markdown-fancy_lists+startnum` did not work properly.

  * RST reader (all Daniel Bergey):

    + Parse quoted literal blocks (#65).  RST quoted literal blocks are
      the same as indented literal blocks (which pandoc already supports)
      except that the quote character is preserved in each line.
    + Parse RST class directives. The class directive accepts one or more
      class names, and creates a Div value with those classes.  If the
      directive has an indented body, the body is parsed as the children of
      the Div.  If not, the first block following the directive is made a
      child of the Div. This differs from the behavior of rst2xml, which
      does not create a Div element.  Instead, the specified classes are
      applied to each child of the directive.  However, most Pandoc Block
      constructors to not take an Attr argument, so we can't duplicate this
      behavior.
    + Warn about skipped directives.
    + Literal role now produces Code. Code role should have "code" class.
    + Improved support for custom roles

        - Added `sourceCode` to classes for `:code:` role, and anything
          inheriting from it.
        - Add the name of the custom role to classes if the Inline
          constructor supports Attr.
        - If the custom role directive does not specify a parent role,
          inherit from the `:span:` role.

      This differs somewhat from the `rst2xml.py` behavior.  If a custom
      role inherits from another custom role, Pandoc will attach both
      roles' names as classes.  `rst2xml.py` will only use the class of
      the directly invoked role (though in the case of inheriting from a
      `:code:` role with a `:language:` defined, it will also provide the
      inherited language as a class).
    + Warn about ignored fields in role directives.

  * LaTeX reader:

    + Parse label after caption into a span instead of
     inserting an additional paragraph of bracketed text (#1747).
    + Parse math environments as inline when possible (#1821).
    + Better handling of `\noindent` and `\greektext` (#1783).
    + Handle `\texorpdfstring` more gracefully.
    + Handle `\cref` and `\sep` (Wikiwide).
    + Support `\smartcite` and `\Smartcite` from biblatex.

  * HTML reader:

    + Retain display type of MathML output (#1719, Matthew Pickering).
    + Recognise `<br>` tags inside `<pre>` blocks (#1620, Matthew Pickering).
    + Make `embed` tag either block or inline (#1756).

  * DocBook reader:

    + Handle `keycombo`, `keycap` (#1815).
    + Get string content in inner tags for literal elements (#1816).
    + Handle `menuchoice` elements better, with a `>` between (#1817).
    + Include `id` on section headers (#1818).
    + Document/test "type" as implemented (Brian O'Sullivan).
    + Add support for calloutlist and callout (Brian O'Sullivan).
      We treat a calloutlist as a bulleted list. This works well in practice.
    + Add support for `classname` (Bryan O'Sullivan).

  * Docx reader:

    + Fix window path for image lookup (Jesse Rosenthal).
      Don't use os-sensitive "combine", since we always want the paths in our
      zip-archive to use forward-slashes.
    + Single-item headers in ordered lists are headers (Jesse Rosenthal).
      When users number their headers, Word understands that as a single item
      enumerated list. We make the assumption that such a list is, in fact,
      a header.
    + Rewrite rewriteLink to work with new headers (Jesse Rosenthal).
      There could be new top-level headers after making lists, so we have to
      rewrite links after that.
    + Use polyglot header list (Jesse Rosenthal).
      We're just keeping a list of header formats that different languages
      use as their default styles. At the moment, we have English, German,
      Danish, and French. We can continue to add to this.
      This is simpler than parsing the styles file, and perhaps less
      error-prone, since there seems to be some variations, even within a
      language, of how a style file will define headers.
    + Remove header class properly in other langs (Jesse Rosenthal).
      When we encounter one of the polyglot header styles, we want to remove
      that from the par styles after we convert to a header. To do that, we
      have to keep track of the style name, and remove it appropriately.
    + Account for external link URLs with anchors. Previously, if a URL
      had an anchor, the reader would incorrectly identify it as an
      internal link and return only the anchor as URL. (Caleb McDaniel)
    + Fix for Issue #1692 (i18n styles) (Nikolay Yakimov).

  * Org reader:

    + Added state changing blanklines (Jesse Rosenthal).
      This allows us to emphasize at the beginning of a new paragraph (or, in
      general, after blank lines).
    + Fixed bug with bulleted lists:

        - a
        - b
        * c

      was being parsed as a list, even though an unindented `*`
      should make a heading.  See
      <http://orgmode.org/manual/Plain-lists.html#fn-1>.
    + Org reader: absolute, relative paths in link (#1741, Albert
      Krewinkel). The org reader was too restrictive when parsing links;
      some relative links and links to files given as absolute paths
      were not recognized correctly.
    + Org reader:  allow empty links (jgm/gitit#471, Albert Krewinkel).
      This is important for use in gitit, which uses empty links
      for wikilinks.
    + Respect indent when parsing Org bullet lists (#1650, Timothy
      Humphries).  Fixes issue with top-level bullet list parsing.
    + Fix indent issue for definition lists (Timothy Humphries,
      see #1650, #1698, #1680).
    + Parse multi-inline terms correctly in definition list (#1649,
      Matthew Pickering).
    + Fix rules for emphasis recognition (Albert Krewinkel).
      Things like `/hello,/` or `/hi'/` were falsy recognized as emphasised
      strings.  This is wrong, as `,` and `'` are forbidden border chars and
      may not occur on the inner border of emphasized text.
    + Drop COMMENT document trees (Albert Krewinkel).
      Document trees under a header starting with the word `COMMENT` are
      comment trees and should not be exported.  Those trees are dropped
      silently (#1678).
    + Properly handle links to `file:target` (Albert Krewinkel).
      Org links like `[[file:target][title]]` were not handled correctly,
      parsing the link target verbatim.  The org reader is changed such that
      the leading `file:` is dropped from the link target (see #756, #1812).
    + Parse LaTeX-style MathML entities (#1657, Albert Krewinkel).
      Org supports special symbols which can be included using LaTeX syntax,
      but are actually MathML entities.  Examples for this are
      `\nbsp` (non-breaking space), `\Aacute` (the letter A with accent acute)
      or `\copy` (the copyright sign ©)

  * EPUB reader:

    + URI handling improvements. Now we outsource most of the work to
      `fetchItem'`. Also, do not include queries in file extensions (#1671).

  * LaTeX writer:

    + Use `\texorpdfstring` for section captions when needed (Vaclav Zeman).
    + Handle consecutive linebreaks (#1733).
    + Protect graphics in headers (Jesse Rosenthal).
      Graphics in `\section`/`\subsection` etc titles need to be `\protect`ed.
    + Put `~` before header in list item text (Jesse Rosenthal).
      Because of the built-in line skip, LaTeX can't handle a section header
      as the first element in a list item.
    + Avoid using reserved characters as `\lstinline` delimiters (#1595).
    + Better handling of display math in simple tables (#1754).
      We convert display math to inline math in simple tables,
      since LaTeX can't deal with display math in simple tables.
    + Escape spaces in code (#1694, Bjorn Buckwalter).

  * MediaWiki writer:

    + Fixed links with URL = text. Previously these were rendered as bare
      words, even if the URL was not an absolute URL (#1825).

  * ICML writer:

    + Don't force all citations into footnotes.

  * RTF writer:

    + Add blankline at end of output (#1732, Matthew Pickering).

  * RST writer:

    + Ensure blank line after figure.
    + Avoid excess whitespace after last list item (#1777).
    + Wrap line blocks with spaces before continuations (#1656).
    + Fixed double-rendering of footnotes in RST tables (#1769).

  * DokuWiki writer:

    + Better handling of block quotes. This change ensures that
      multiple paragraph blockquotes are rendered using native `>`
      rather than as HTML (#1738).
    + Fix external images (#1739). Preface relative links with ":",
      absolute URIs without. (Timothy Humphries)

  * HTML writer:

    + Use protocol-relative URL for mathjax.
    + Put newline btw img and caption paragraph.
    + MathML now outputted with tex annotation (#1635, Matthew Pickering).
    + Add support for KaTeX HTML math (#1626, Matthew Pickering).
      This adds `KaTeX` to `HTMLMathMethod` (API change).
    + Don't double render when `email-obfuscation=none` (#1625, Matthew
      Pickering).
    + Make header attributes work outside top level (#1711).
      Previously they only appeared on top level header elements.
      Now they work e.g. in blockquotes.

  * ODT writer:

    + Correctly handle images without extensions (#1729).
    + Strip querystring in ODT write (#1682, Todd Sifleet).

  * FB2 writer:

    + Add newline to output.

  * EPUB writer:

    + Don't add `sourceURL` to absolute URIs (#1669).
    + Don't use unsupported `opf:title-type` for epub2.
    + Include "landmarks" section in nav document for epub3 (#1757).
    + Removed playOrder from navpoint elements in ncx file (#1760).
      These aren't required, and they make manual modification of epubs
      difficult.
    + Extract title even from structured title.
    + Don't include nav node in spine unless `--toc` was requested.
      Previously we included it in the spine with `linear="no"`, leading
      to odd results in some readers (#1593).
    + Fixed absolute URI detection (#1672).
    + Correctly resolve relative URIs (#1671).
    + Use regular page template for `nav.xhtml`, including doctype (#1759).

  * Docx writer:

    + Put docx table captions above tables (#1641, Nikolay Yakimov).
    + Get the page width from the reference docx file, and use
      it to scale images that are too large to fit (Grégory Bataille).
    + Partial fix for #1607 (Nikolay Yakimov). International heading styles
      are inferred based on `<w:name val="heading #">` fallback, if there
      are no en-US "Heading#" styles
    + Look in user data dir for archive `reference.docx`.
    + Renumber header and footer relationships to avoid collisions (Jesse
      Rosenthal). We previously took the old relationship names of the
      headers and footer in secptr. That led to collisions. We now make
      a map of available names in the relationships file, and then rename
     in secptr.

  * ConTeXt writer:

    + Add function toLabel (Mark Szepieniec).
      This function can be used to sanitize reference labels so that
      they do not contain any of the illegal characters \#[]",{}%()|= .
      Currently only Links have their labels sanitized, because they
      are the only Elements that use passed labels.

  * `Text.Pandoc.Shared`:

    + Moved import of `toChunks` outside of CPP conditional (#1590).
    + Fix `inDirectory` to reset to the original directory in case
      an exception occurs (Freiric Barral).

  * Templates:

    + LaTeX template: load polyglossia before bibtex (jgm/pandoc-templates#70).
      Thanks to bluebirch.
    + LaTeX template: Added `\VerbatimFootnotes` if there is verbatim in notes
      (#1616).
    + LaTeX template:  Add shorthands=off to babel options (#1648).
    + EPUB, EPUB3 templates: Added `id="cover"` to body of cover page.
      This aids styling, making it possible for example to set 0 margins
      on the title page (#1758).
    + EPUB, EPUB3 templates:  Handle structured metadata on titlepage.
      Previously we just expected 'title', 'subtitle', 'author', 'date'.
      Now we still support those, but also support the format recommended
      for epub metadata in the pandoc README:

        ---
        title:
        - type: main
          text: My Book
        - type: subtitle
          text: An investigation of metadata
        creator:
        - role: author
          text: John Smith
        - role: editor
          text: Sarah Jones
        identifier:
        - scheme: DOI
          text: doi:10.234234.234/33
        publisher:  My Press
        rights:  (c) 2007 John Smith, CC BY-NC
        ...

  * `Text.Pandoc.Templates.getDefaultTemplate`:
    don't fail when called with "fb2" (#1660).

  * `Text.Pandoc.Parsing`:

    + Fixed `inlineMath` so it handles `\text{..}` containing `$`.
      For example: `$x = \text{the $n$th root of $y$}` (#1677).
    + Change `parseFromString` to fail if not all input is consumed.
      (Matthew Pickering)
    + Moved `addWarning` from Markdown reader to `Parsing`, so it can be
      used by more readers (API change, Daniel Bergey).

  * `Text.Pandoc.Pretty`:

    +  Improve performance of `realLength` (Matthew Pickering).
    +  Make CR + BLANKLINE = BLANKLINE. This fixes an extra blank line we
       were getting at the end of markdown fragments (as well as rst, org,
       etc.) (#1705).

  * `Text.Pandoc.MIME`:

    + Add mime type for WebVTT (Jason Ronallo).
    + Changed mime type for `otf` to `application/vnd.ms-opentype` (#1761).
      This is needed for epub3 validation.

  * `Text.Pandoc.MediaBag`:

    + Fix Windows specific path problems (#1597).

  * `Text.Pandoc.Shared`:

    + Make `collapseFilePath` OS-agnostic (Matthew Pickering).

  * Link the test suite using `-threaded`.
    This allows the test suite to be run using `+RTS -N`.

  * Added `network` dependency under `network-uri` flag in test section.

  * Give better error messages when someone tries to convert from
    pdf, doc, odt (#1683).

  * Added `track` to list of tags treated by `--self-contained` (#1664).


## pandoc 1.13.1 (2014-08-30)

  * Fixed `--self-contained` with Windows paths (#1558).
    Previously `C:\foo.js` was being wrongly interpreted as a URI.

  * HTML reader:  improved handling of tags that can be block or inline.
    Previously a section like this would be enclosed in a paragraph,
    with RawInline for the video tags (since video is a tag that can
    be either block or inline):

        <video controls="controls">
           <source src="../videos/test.mp4" type="video/mp4" />
           <source src="../videos/test.webm" type="video/webm" />
           <p>
              The videos can not be played back on your system.<br/>
              Try viewing on Youtube (requires Internet connection):
              <a href="http://youtu.be/etE5urBps_w">Relative Velocity on
        Youtube</a>.
           </p>
        </video>

    This change will cause the video and source tags to be parsed
    as RawBlock instead, giving better output.
    The general change is this:  when we're parsing a "plain" sequence
    of inlines, we don't parse anything that COULD be a block-level tag.

  * Docx reader:

    + Be sensitive to user styles.  Note that "Hyperlink" is
      "blacklisted," as we don't want the default underline styling to be
      inherited by all links by default (Jesse Rosenthal).
    + Read single paragraph in table cell as `Plain` (Jesse Rosenthal).
      This makes to docx reader's native output fit with the way the markdown
      reader understands its markdown output.

  * Txt2Tags reader:

    + Header is now parsed only if standalone flag is set (Matthew Pickering).
    + The header is now parsed as meta information. The first line is the
      `title`, the second is the `author` and third line is the `date`
      (Matthew Pickering).
    + Corrected formatting of `%%mtime` macro (Matthew Pickering).
    + Fixed crash when reading from stdin.

  * Textile writer:  Extended the range of cases where native textile
    tables will be used (as opposed to raw HTML):  we now handle any
    alignment type, but only for simple tables with no captions.

  * EPUB writer:  Don't use page-progression-direction in EPUB2, which
    doesn't support it.  Also, if page-progression-direction not specified
    in metadata, don't include the attribute even in EPUB3; not including it
    is the same as including it with the value "default", as we did before.
    (#1550)

  * Org writer: Accept example lines with indentation at the beginning
    (Calvin Beck).

  * DokuWiki writer:

    + Refactor to use Reader monad (Matthew Pickering).
    + Avoid using raw HTML in table cells; instead, use `\\`
      instead of newlines (Jesse Rosenthal).
    + Properly handle HTML table cell alignments, and use spacing
      to make the tables look prettier (#1566).

  * Docx writer:

    + Bibliography entries get `Bibliography` style (#1559).
    + Implement change tracking (Jesse Rosenthal).

  * LaTeX writer:

    + Fixed a bug that caused a table caption to repeat across all pages
      (Jose Luis Duran).
    + Improved vertical spacing in tables and made it customizable using
      standard lengths set by booktab.  See
      <https://groups.google.com/forum/#!msg/pandoc-discuss/qMu6_5lYy0o/ZAU7lzAIKw0J>
      (Jose Luis Duran).
    + Added `\strut` to fix spacing in multiline tables (Jose Luis Duran).
    + Use `\tabularnewline` instead of `\\` in table cells (Jose Luis Duran).
    + Made horizontal rules more flexible (Jose Luis Duran).

  * Text.Pandoc.MIME:

    + Added `MimeType` (type synonym for `String`) and `getMimeTypeDef`.
      Code cleanups (Artyom Kazak).

  * Templates:

    + LaTeX template: disable microtype protrusion for typewriter font (#1549,
      thanks lemzwerg).

  * Improved OSX build procedure.

  * Added `network-uri` flag, to deal with split of `network-uri` from
    `network`.

  * Fix build dependencies for the `trypandoc` flag, so that they are
    ignored if `trypandoc` flag is set to False (Gabor Pali).

  * Updated README to remove outdated claim that `--self-contained`
    looks in the user data directory for missing files.

## pandoc 1.13.0.1 (2014-08-17)

  * Docx writer:

    + Fixed regression which bungled list numbering (#1544), causing
      all lists to appear as basic ordered lists.
    + Include row width in table rows (Christoffer Ackelman, Viktor Kronvall).
      Added a property to all table rows where the sum of column widths
      is specified in pct (fraction of 5000).  This helps persuade Word
      to lay out the table with the widths we specify.

  * Fixed a bug in Windows 8 which caused pandoc not to find the
    `pandoc-citeproc` filter (#1542).

  * Docx reader: miscellaneous under-the-hood improvements (Jesse Rosenthal).
    Most significantly, the reader now uses Builder, leading to some
    performance improvements.

  * HTML reader:  Parse appropriately styled span as SmallCaps.

  * Markdown writer: don't escape `$`, `^`, `~` when `tex_math_dollars`,
    `superscript`, and `subscript` extensions, respectively, are
    deactivated (#1127).

  * Added `trypandoc` flag to build CGI executable used in the online
    demo.

  * Makefile:  Added 'quick', 'osxpkg' targets.

  * Updated README in templates to indicate templates license.
    The templates are dual-licensed, BSD3 and GPL2+.

## pandoc 1.13 (15 August 2014)

### New features

  * Added `docx` as an input format (Jesse Rosenthal).  The docx
    reader includes conversion of native Word equations to pandoc
    LaTeX `Math` elements.  Metadata is taken from paragraphs at the
    beginning of the document with styles `Author`, `Title`, `Subtitle`,
    `Date`, and `Abstract`.

  * Added `epub` as an input format (Matthew Pickering).  The epub
    reader includes conversion of MathML to pandoc LaTeX `Math`
    elements.

  * Added `t2t` (Txt2Tags) as an input format (Matthew Pickering).
    Txt2tags is a lightweight markup format described at
    <http://txt2tags.org/>.

  * Added `dokuwiki` as an output format (Clare Macrae).

  * Added `haddock` as an output format.

  * Added `--extract-media` option to extract media contained in a zip
    container (docx or epub) while adjusting image paths to point to the
    extracted images.

  * Added a new markdown extension, `compact_definition_lists`, that
    restores the syntax for definition lists of pandoc 1.12.x, allowing
    tight definition lists with no blank space between items, and
    disallowing lazy wrapping.  (See below under behavior changes.)

  * Added an extension `epub_html_exts` for parsing HTML in EPUBs.

  * Added extensions `native_spans` and `native_divs` to activate
    parsing of material in HTML span or div tags as Pandoc Span
    inlines or Div blocks.

  * `--trace` now works with the Markdown, HTML, Haddock, EPUB,
    Textile, and MediaWiki readers.  This is an option intended
    for debugging parsing problems; ordinary users should not need
    to use it.

### Behavior changes

  * Changed behavior of the `markdown_attribute` extension, to bring
    it in line with PHP markdown extra and multimarkdown.  Setting
    `markdown="1"` on an outer tag affects all contained tags,
    recursively, until it is reversed with `markdown="0"` (#1378).

  * Revised markdown definition list syntax (#1429).  Both the reader
    and writer are affected.  This change brings pandoc's definition list
    syntax into alignment with that used in PHP markdown extra and
    multimarkdown (with the exception that pandoc is more flexible about
    the definition markers, allowing tildes as well as colons).  Lazily
    wrapped definitions are now allowed.  Blank space is required
    between list items.  The space before a definition is used to determine
    whether it is a paragraph or a "plain" element.  **WARNING: This change
    may break existing documents!**  Either check your documents for
    definition lists without blank space between items, or use
    `markdown+compact_definition_lists` for the old behavior.

  * `.numberLines` now works in fenced code blocks even if no language
    is given (#1287, jgm/highlighting-kate#40).

  * Improvements to `--filter`:

    + Don't search PATH for a filter with an explicit path.
      This fixed a bug wherein `--filter ./caps.py` would run `caps.py` from
      the system path, even if there was a `caps.py` in the working directory.
    + Respect shebang if filter is executable (#1389).
    + Don't print misleading error message.
      Previously pandoc would say that a filter was not found,
      even in a case where the filter had a syntax error.

  * HTML reader:

    + Parse `div` and `span` elements even without `--parse-raw`,
      provided `native_divs` and `native_spans` extensions are set.
      Motivation:  these now generate native pandoc Div and Span
      elements, not raw HTML.
    + Parse EPUB-specific elements if the `epub_html_exts`
      extension is enabled.  These include `switch`, `footnote`,
      `rearnote`, `noteref`.

  * Org reader:

    + Support for inline LaTeX.  Inline LaTeX is now accepted and parsed by the
      org-mode reader.  Both math symbols (like `\tau`) and LaTeX commands (like
      `\cite{Coffee}`), can be used without any further escaping (Albert
      Krewinkel).

  * Textile reader and writer:

    + The `raw_tex` extension is no longer set by default.  You can
      enable it with `textile+raw_tex`.

  * DocBook reader:

    + Support `equation`, `informalequation`, `inlineequation` elements with
      `mml:math` content.  This is converted into LaTeX and put into a Pandoc
      Math inline.

  * Revised `plain` output, largely following the style of Project
    Gutenberg:

    + Emphasis is rendered with `_underscores_`, strong emphasis
      with ALL CAPS.
    + Headings are rendered differently, with space to set them off,
      not with setext style underlines. Level 1 headers are ALL CAPS.
    + Math is rendered using unicode when possible, but without the
      distracting emphasis markers around variables.
    + Footnotes use a regular `[n]` style.

  * Markdown writer:

    + Horizontal rules are now a line across the whole page.
    + Prettier pipe tables.  Columns are now aligned  (#1323).
    + Respect the `raw_html` extension.  `pandoc -t markdown-raw_html`
      no longer emits any raw HTML, including span and div tags
      generated by Span and Div elements.
    + Use span with style for `SmallCaps` (#1360).

  * HTML writer:

    + Autolinks now have class `uri`, and email autolinks have class
      `email`, so they can be styled.

  * Docx writer:

    + Document formatting is carried over from `reference.docx`.
      This includes margins, page size, page orientation, header,
      and footer, including images in headers and footers.
    + Include abstract (if present) with `Abstract` style (#1451).
    + Include subtitle (if present) with `Subtitle` style, rather
      than tacking it on to the title (#1451).

  * Org writer:

    + Write empty span elements with an id attribute as org anchors.
      For example `Span ("uid",[],[]) []` becomes `<<uid>>`.

  * LaTeX writer:

    + Put table captions above tables, to match the conventional
      standard.  (Previously they appeared below tables.)
    + Use `\(..\)` instead of `$..$` for inline math (#1464).
    + Use `\nolinkurl` in email autolinks.  This allows them to be styled
      using `\urlstyle{tt}`.  Thanks to Ulrike Fischer for the solution.
    + Use `\textquotesingle` for `'` in inline code.  Otherwise we get
      curly quotes in the PDF output (#1364).
    + Use `\footnote<.>{..}` for notes in beamer, so that footnotes
      do not appear before the overlays in which their markers appear
      (#1525).
    + Don't produce a `\label{..}` for a Div or Span element.  Do produce
      a `\hyperdef{..}` (#1519).

  * EPUB writer:

    + If the metadata includes `page-progression-direction` (which can be
      `ltr` or `rtl`, the `page-progression-direction` attribute will
      be set in the EPUB spine (#1455).

  * Custom lua writers:

    + Custom writers now work with `--template`.
    + Removed HTML header scaffolding from `sample.lua`.
    + Made citation information available in lua writers.

  * `--normalize` and `Text.Pandoc.Shared.normalize` now consolidate
    adjacent `RawBlock`s when possible.

### API changes

  * Added `Text.Pandoc.Readers.Docx`, exporting `readDocx` (Jesse Rosenthal).

  * Added `Text.Pandoc.Readers.EPUB`, exporting `readEPUB` (Matthew
    Pickering).

  * Added `Text.Pandoc.Readers.Txt2Tags`, exporting `readTxt2Tags` (Matthew
    Pickering).

  * Added `Text.Pandoc.Writers.DokuWiki`, exporting `writeDokuWiki`
    (Clare Macrae).

  * Added `Text.Pandoc.Writers.Haddock`, exporting `writeHaddock`.

  * Added `Text.Pandoc.MediaBag`, exporting `MediaBag`, `lookupMedia`,
    `insertMedia`, `mediaDirectory`, `extractMediaBag`.  The docx and epub
    readers return a pair of a `Pandoc` document and a `MediaBag` with
    the media resources they contain.  This can be extracted using
    `--extract-media`.  Writers that incorporate media (PDF, Docx,
    ODT, EPUB, RTF, or HTML formats with `--self-contained`) will look
    for resources in the `MediaBag` generated by the reader, in addition to
    the file system or web.

  * `Text.Pandoc.Readers.TexMath`: Removed deprecated `readTeXMath`.
    Renamed `readTeXMath'` to `texMathToInlines`.

  * `Text.Pandoc`: Added `Reader` data type (Matthew Pickering).
    `readers` now associates names of readers with `Reader`
     structures.  This allows inclusion of readers, like the docx
     reader, that take binary rather than textual input.

  * `Text.Pandoc.Shared`:

    + Added `capitalize` (Artyom Kazak), and replaced uses of
      `map toUpper` (which give bad results for many languages).
    + Added `collapseFilePath`, which removes intermediate `.` and
      `..` from a path (Matthew Pickering).
    + Added `fetchItem'`, which works like `fetchItem` but searches
      a `MediaBag` before looking on the net or file system.
    + Added `withTempDir`.
    + Added `removeFormatting`.
    + Added `extractSpaces` (from HTML reader) and generalized its type
      so that it can be used by the docx reader (Matthew Pickering).
    + Added `ordNub`.
    + Added `normalizeInlines`, `normalizeBlocks`.
    + `normalize` is now `Pandoc -> Pandoc` instead of
      `Data a :: a -> a`.  Some users may need to change their uses of
      `normalize` to the newly exported `normalizeInlines` or
      `normalizeBlocks`.

  * `Text.Pandoc.Options`:

    + Added `writerMediaBag` to `WriterOptions`.
    + Removed deprecated and no longer used `readerStrict` in
      `ReaderOptions`.  This is handled by `readerExtensions` now.
    + Added `Ext_compact_definition_lists`.
    + Added `Ext_epub_html_exts`.
    + Added `Ext_native_divs` and `Ext_native_spans`.
      This allows users to turn off the default pandoc behavior of
      parsing contents of div and span tags in markdown and HTML
      as native pandoc Div blocks and Span inlines.

  * `Text.Pandoc.Parsing`:

    + Generalized `readWith` to `readWithM` (Matthew Pickering).
    + Export `runParserT` and `Stream` (Matthew Pickering).
    + Added `HasQuoteContext` type class (Matthew Pickering).
    + Generalized types of `mathInline`, `smartPunctuation`, `quoted`,
      `singleQuoted`, `doubleQuoted`, `failIfInQuoteContext`,
      `applyMacros` (Matthew Pickering).
    + Added custom `token` (Matthew Pickering).
    + Added `stateInHtmlBlock` to `ParserState`.  This is used to keep
      track of the ending tag we're waiting for when we're parsing inside
      HTML block tags.
    + Added `stateMarkdownAttribute` to `ParserState`. This is used
      to keep track of whether the markdown attribute has been set in
      an enclosing tag.
    + Generalized type of `registerHeader`, using new type classes
      `HasReaderOptions`, `HasIdentifierList`, `HasHeaderMap` (Matthew
      Pickering).  These allow certain common functions to be reused
      even in parsers that use custom state (instead of `ParserState`),
      such as the MediaWiki reader.
    + Moved `inlineMath`, `displayMath` from Markdown reader to Parsing,
      and generalized their types (Matthew Pickering).

  * `Text.Pandoc.Pretty`:

    + Added `nestle`.
    + Added `blanklines`, which guarantees a certain number of blank lines
      (and no more).

### Bug fixes

  * Markdown reader:

    + Fixed parsing of indented code in list items.  Indented code
      at the beginning of a list item must be indented eight spaces
      from the margin (or edge of the container), or four spaces
      from the list marker, whichever is greater.
    + Fixed small bug in HTML parsing with `markdown_attribute`, which
      caused incorrect tag nesting for input like
      `<aside markdown="1">*hi*</aside>`.
    + Fixed regression with intraword underscores (#1121).
    + Improved parsing of inline links containing quote characters (#1534).
    + Slight rewrite of `enclosure`/`emphOrStrong` code.
    + Revamped raw HTML block parsing in markdown (#1330).
      We no longer include trailing spaces and newlines in the
      raw blocks.  We look for closing tags for elements (but without
      backtracking).  Each block-level tag is its own `RawBlock`;
      we no longer try to consolidate them (though `--normalize` will do so).
    + Combine consecutive latex environments.  This helps when you have
      two minipages which can't have blank lines between them (#690, #1196).
    + Support smallcaps through span.
      `<span style="font-variant:small-caps;">foo</span>` will be
      parsed as a `SmallCaps` inline, and will work in all output
      formats that support small caps (#1360).
    + Prevent spurious line breaks after list items (#1137).  When the
      `hard_line_breaks` option was specified, pandoc would formerly
      produce a spurious line break after a tight list item.
    + Fixed table parsing bug (#1333).
    + Handle `c++` and `objective-c` as language identifiers in
      github-style fenced blocks (#1318).
    + Inline math must have nonspace before final `$` (#1313).

  * LaTeX reader:

    + Handle comments at the end of tables.  This resolves the issue
      illustrated in <http://stackoverflow.com/questions/24009489>.
    + Correctly handle table rows with too few cells.  LaTeX seems to
      treat them as if they have empty cells at the end  (#241).
    + Handle leading/trailing spaces in `\emph` better.
      `\emph{ hi }` gets parsed as `[Space, Emph [Str "hi"], Space]`
      so that we don't get things like `* hi *` in markdown output.
      Also applies to `textbf` and some other constructions (#1146).
    + Don't assume preamble doesn't contain environments (#1338).
    + Allow (and discard) optional argument for `\caption` (James Aspnes).

  * HTML reader:

    + Fixed major parsing problem with HTML tables.  Table cells were
      being combined into one cell (#1341).
    + Fixed performance issue with malformed HTML tables.
      We let a `</table>` tag close an open `<tr>` or `<td>` (#1167).
    + Allow space between `<col>` and `</col>`.
    + Added `audio` and `source` in `eitherBlockOrInline`.
    + Moved `video`, `svg`, `progress`, `script`, `noscript`, `svg` from
      `blockTags` to `eitherBlockOrInline`.
    + `map` and `object` were mistakenly in both lists; they have been removed
      from `blockTags`.
    + Ignore `DOCTYPE` and `xml` declarations.

  * MediaWiki reader:

    + Don't parse backslash escapes inside `<source>` (#1445).
    + Tightened up template parsing.
      The opening `{{` must be followed by an alphanumeric or `:`.
      This prevents the exponential slowdown in #1033.
    + Support "Bild" for images.

  * DocBook reader:

    + Better handle elements inside code environments.  Pandoc's document
      model does not allow structure inside code blocks, but at least this way
      we preserve the text (#1449).
    + Support `<?asciidoc-br?>` (#1236).

  * Textile reader:

    + Fixed list parsing. Lists can now start without an intervening
      blank line (#1513).
    + HTML block-level tags that do not start a line are parsed as
      inline HTML and do not interrupt paragraphs (as in RedCloth).

  * Org reader:

    + Make tildes create inline code (#1345).  Also relabeled `code` and
      `verbatim` parsers to accord with the org-mode manual.
    + Respect `:exports` header argument in code blocks (Craig Bosma).
    + Fixed tight lists with sublists (#1437).

  * EPUB writer:

    + Avoid excess whitespace in `nav.xhtml`.  This should improve
      TOC view in iBooks (#1392).
    + Fixed regression on cover image.
      In 1.12.4 and 1.12.4.2, the cover image would not appear properly,
      because the metadata id was not correct.  Now we derive the id from the
      actual cover image filename, which we preserve rather than using
      "cover-image."
    + Keep newlines between block elements.  This allows
      easier diff-ability (#1424).
    + Use `stringify` instead of custom `plainify`.
    + Use `renderTags'` for all tag rendering.  This properly handles tags
      that should be self-closing.  Previously `<hr/>` would appear in EPUB
      output as `<hr></hr>` (#1420).
    + Better handle HTML media tags.
    + Handle multiple dates with OPF `event` attributes.  Note: in EPUB3 we
      can have only one dc:date, so only the first one is used.

  * LaTeX writer:

    + Correctly handle figures in notes.  Notes can't contain figures in
      LaTeX, so we fake it to avoid an error  (#1053).
    + Fixed strikeout + highlighted code (#1294).
      Previously strikeout highlighted code caused an error.

  * ConTeXt writer:

    + Improved detection of autolinks with URLs containing escapes.

  * RTF writer:

    + Improved image embedding: `fetchItem'` is now used to get the
      images, and calculated image sizes are indicated in the RTF.
    + Avoid extra paragraph tags in metadata (#1421).

  * HTML writer:

    + Deactivate "incremental" inside slide speaker notes (#1394).
    + Don't include empty items in the table of contents for
      slide shows.  (These would result from creating a slide
      using a horizontal rule.)

  * MediaWiki writer:

    + Minor renaming of `st` prefixed names.

  * AsciiDoc writer:

    + Double up emphasis and strong emphasis markers in intraword
      contexts, as required by asciidoc (#1441).

  * Markdown writer:

    + Avoid wrapping that might start a list, blockquote, or header (#1013).
    + Use Span instead of (hackish) `SmallCaps` in `plainify`.
    + Don't use braced attributes for fenced code (#1416).
      If `Ext_fenced_code_attributes` is not set, the first class
      attribute will be printed after the opening fence as a bare word.
    + Separate adjacent lists of the same kind with an HTML comment (#1458).

  * PDF writer:

    + Fixed treatment of data uris for images (#1062).

  * Docx writer:

    + Use Compact style for empty table cells (#1353).
      Otherwise we get overly tall lines when there are empty
      table cells and the other cells are compact.
    + Create overrides per-image for `media/` in reference docx.
      This should be somewhat more robust and cover more types of images.
    + Improved `entryFromArchive` to avoid an unneeded parse.
    + Section numbering carries over from reference.docx (#1305).
    + Simplified `abstractNumId` numbering.  Instead of sequential numbering,
      we assign numbers based on the list marker styles.

  * `Text.Pandoc.Options`:

    + Removed `Ext_fenced_code_attributes` from `markdown_github`
      extensions.

  * `Text.Pandoc.ImageSize`:

    + Use default instead of failing if image size not found
      in exif header (#1358).
    + ignore unknown exif header tag rather than crashing.
      Some images seem to have tag type of 256, which was causing
      a runtime error.

  * `Text.Pandoc.Shared`:

    + `fetchItem`:  unescape URI encoding before reading local file (#1427).
    + `fetchItem`:  strip a fragment like `?#iefix` from the extension before
      doing mime lookup, to improve mime type guessing.
    + Improved logic of `fetchItem`:  absolute URIs are fetched from the net;
      other things are treated as relative URIs if `sourceURL` is `Just _`,
      otherwise as file paths on the local file system.
    + `fetchItem` now properly handles links without a protocol (#1477).
    + `fetchItem` now escapes characters not allowed in URIs before trying
      to parse the URIs.
    + Fixed runtime error with `compactify'DL` on certain lists (#1452).

  * `pandoc.hs`: Don't strip path off of `writerSourceURL`: the path is
    needed to resolve relative URLs when we fetch resources (#750).

  * `Text.Pandoc.Parsing`

    + Simplified `dash` and `ellipsis` (#1419).
    + Removed `(>>~)` in favor of the equivalent `(<*)` (Matthew Pickering).
    + Generalized functions to use `ParsecT` (Matthew Pickering).
    + Added `isbn` and `pmid` to list of recognized schemes (Matthew
      Pickering).

### Template changes

  * Added haddock template.
  * EPUB3:  Added `type` attribute to `link` tags.  They are supposed to
    be "advisory" in HTML5, but kindlegen seems to require them.
  * EPUB3:  Put title page in section with `epub:type="titlepage"`.
  * LaTeX: Made `\subtitle` work properly (#1327).
  * LaTeX/Beamer: remove conditional around date (#1321).
  * LaTeX:  Added `lot` and `lof` variables, which can be set to
    get `\listoftables` and `\listoffigures` (#1407).  Note that
    these variables can be set at the command line with `-Vlot -Vlof`
    or in YAML metadata.

### Under the hood improvements

  * Rewrote normalize for efficiency (#1385).

  * Rewrote Haddock reader to use `haddock-library` (#1346).

    + This brings pandoc's rendering of haddock markup in line
      with the new haddock.
    + Fixed line breaks in `@` code blocks.
    + alex and happy are no longer build-depends.

  * Added `Text.Pandoc.Compat.Directory` to allow building against
    different versions of the `directory` library.

  + Added `Text.Pandoc.Compat.Except` to allow building against
    different versions of `mtl`.

  * Code cleanup in some writers, using Reader monad to avoid
    passing options parameter around (Matej Kollar).

  * Improved readability in `pandoc.hs`.

  * Miscellaneous code cleanups (Artyom Kazak).

  * Avoid `import Prelude hiding (catch)` (#1309, thanks to Michael
    Thompson).

  * Changed `http-conduit` flag to `https`.  Depend on `http-client`
    and `http-client-tls` instead of `http-conduit`.  (Note:  pandoc still
    depends on `conduit` via `yaml`.)

  * Require `highlighting-kate >= 0.5.8.5` (#1271, #1317, Debian #753299).
    This change to highlighting-kate means that PHP fragments no longer need
    to start with `<?php`.  It also fixes a serious bug causing failures with
    ocaml and fsharp.

  * Require latest `texmath`.  This fixes `\tilde{E}` and allows
    `\left` to be used with `]`, `)` etc. (#1319), among many other
    improvements.

  * Require latest `zip-archive`.  This has fixes for unicode path names.

  * Added tests for plain writer.

  * `Text.Pandoc.Templates`:

    + Fail informatively on template syntax errors.
      With the move from parsec to attoparsec, we lost good error
      reporting.  In fact, since we weren't testing for end of input,
      malformed templates would fail silently.  Here we revert back to
      Parsec for better error messages.
    + Use `ordNub` (#1022).

  * Benchmarks:

    + Made benchmarks compile again (Artyom Kazak).
    + Fixed so that the failure of one benchmark does not prevent others
      from running (Artyom Kazak).
    + Use `nfIO` instead of the `getLength` trick to force full evaluation.
    + Changed benchmark to use only the test suite, so that benchmarks
      run more quickly.

  * Windows build script:

    + Add `-windows` to file name.
    + Use one install command for pandoc, pandoc-citeproc.
    + Force install of pandoc-citeproc.

  * `make_osx_package`:  Call zip file `pandoc-VERSION-osx.zip`.
    The zip should not be named `SOMETHING.pkg.zip`, or OSX finder
    will extract it into a folder named `SOMETHING.pkg`, which it
    will interpret as a defective package (#1308).

  * `README`:

    + Made headers for all extensions so they have IDs and can be
      linked to (Beni Cherniavsky-Paskin).
    + Fixed typos (Phillip Alday).
    + Fixed documentation of attributes (#1315).
    + Clarified documentation on small caps (#1360).
    + Better documentation for `fenced_code_attributes` extension
      (Caleb McDaniel).
    + Documented fact that you can put YAML metadata in a separate file
      (#1412).


## pandoc 1.12.4.2 (2014-05-14)

  * Require highlighting-kate >= 0.5.8.  Fixes a performance regression.

  * Shared:  `addMetaValue` now behaves slightly differently:
    if both the new and old values are lists, it concatenates their
    contents to form a new list.

  * LaTeX reader:

    + Set `bibliography` in metadata from `\bibliography` or
      `\addbibresource` command.
    + Don't error on `%foo` with no trailing newline.

  * Org reader:

    + Support code block headers (`#+BEGIN_SRC ...`) (Albert Krewinkel).
    + Fix parsing of blank lines within blocks (Albert Krewinkel).
    + Support pandoc citation extension (Albert Krewinkel).  This can
      be turned off by specifying `org-citation` as the input format.

  * Markdown reader:

    + `citeKey` moved to `Text.Pandoc.Parsing` so it can be used by
      other readers (Albert Krewinkel).

  * `Text.Pandoc.Parsing`:

    + Added `citeKey` (see above).
    + Added `HasLastStrPosition` type class and `updateLastStrPos`
      and `notAfterString` functions.

  * Updated copyright notices (Albert Krewinkel).

  * Added default.icml to data files so it installs with the package.

  * OSX package:

    + The binary is now built with options to ensure that it can be
      used with OSX 10.6+.
    + Moved OSX package materials to osx directory.
    + Added OSX package uninstall script, included in the zip container
      (thanks to Daniel T. Staal).

## pandoc 1.12.4 (2014-05-07)

  * Made it possible to run filters that aren't executable
    (#1096). Pandoc first tries to find the executable (searching
    the path if path isn't given). If it fails, but the file
    exists and has a `.py`, `.pl`, `.rb`, `.hs`, or `.php`
    extension, pandoc runs the filter using the appropriate
    interpreter. This should make it easier to use filters on
    Windows, and make it more convenient for everyone.

  * Added Emacs org-mode reader (Albert Krewinkel).

  * Added InDesign ICML Writer (mb21).

  * MediaWiki reader:

    + Accept image links in more languages (Jaime Marquínez Ferrándiz).
    + Fixed bug in certain nested lists (#1213).  If a level 2 list was
      followed by a level 1 list, the first item of the level 1 list
      would be lost.
    + Handle table rows containing just an HTML comment (#1230).

  * LaTeX reader:

    + Give better location information on errors, pointing to line
      numbers within included files (#1274).
    + LaTeX reader:  Better handling of `table` environment (#1204).
      Positioning options no longer rendered verbatim.
    + Better handling of figure and table with caption (#1204).
    + Handle `@{}` and `p{length}` in tabular.  The length is not actually
      recorded, but at least we get a table (#1180).
    + Properly handle `\nocite`.  It now adds a `nocite` metadata
      field.  Citations there will appear in the bibliography but not
      in the text (unless you explicitly put a `$nocite$` variable
      in your template).

  * Markdown reader:

    + Ensure that whole numbers in YAML metadata are rendered without
      decimal points.  (This became necessary with changes to aeson
      and yaml libraries.  aeson >= 0.7 and yaml >= 0.8.8.2 are now required.)
    + Fixed regression on line breaks in strict mode (#1203).
    + Small efficiency improvements.
    + Improved parsing of nested `div`s.  Formerly a closing `div` tag
      would be missed if it came right after other block-level tags.
    + Avoid backtracking when closing `</div>` not found.
    + Fixed bug in reference link parsing in `markdown_mmd`.
    + Fixed a bug in list parsing (#1154).  When reading a raw list
      item, we now strip off up to 4 spaces.
    + Fixed parsing of empty reference link definitions (#1186).
    + Made one-column pipe tables work (#1218).

  * Textile reader:

    + Better support for attributes.  Instead of being ignored, attributes
      are now parsed and included in Span inlines.  The output will be a bit
      different from stock textile: e.g. for `*(foo)hi*`, we'll get
      `<em><span class="foo">hi</span></em>` instead of
      `<em class="foo">hi</em>`.  But at least the data is not lost.
    + Improved treatment of HTML spans (%) (#1115).
    + Improved link parsing.  In particular we now pick up on attributes.
      Since pandoc links can't have attributes, we enclose the whole link in
      a span if there are attributes (#1008).
    + Implemented correct parsing rules for inline markup (#1175, Matthew
      Pickering).
    + Use Builder (Matthew Pickering).

  * DocBook reader:

    + Better treatment of `formalpara`.  We now emit the title (if present)
      as a separate paragraph with boldface text (#1215).
    + Set metadata `author` not `authors`.
    + Added recognition of `authorgroup` and `releaseinfo` elements (#1214,
      Matthew Pickering).
    + Converted current meta information parsing in DocBook to a more
      extensible version which is aware of the more recent meta
      representation (Matthew Pickering).

  * HTML reader:

    + Require tagsoup 0.13.1, to fix a bug with parsing of script tags
      (#1248).
    + Treat processing instructions & declarations as block.  Previously
      these were treated as inline, and included in paragraph tags in HTML
      or DocBook output, which is generally not what is wanted (#1233).
    + Updated `closes` with rules from HTML5 spec.
    + Use Builder (Matthew Pickering, #1162).

  * RST reader:

    + Remove duplicate `http` in PEP links (Albert Krewinkel).
    + Make rst figures true figures (#1168, CasperVector)
    + Enhanced Pandoc's support for rST roles (Merijn Verstaaten).
      rST parser now supports: all built-in rST roles, new role definition,
      role inheritance, though with some limitations.
    + Use `author` rather than `authors` in metadata.
    + Better handling of directives.  We now correctly handle field
      lists that are indented more than three spaces.  We treat an
      `aafig` directive as a code block with attributes, so it can be
      processed in a filter (#1212).

  * LaTeX writer:

    + Mark span contents with label if span has an ID (Albert Krewinkel).
    + Made `--toc-depth` work well with books in latex/pdf output (#1210).
    + Handle line breaks in simple table cells (#1217).
    + Workaround for level 4-5 headers in quotes.  These previously produced
      invalid LaTeX: `\paragraph` or `\subparagraph` in a `quote` environment.
      This adds an `mbox{}` in these contexts to work around the problem.
      See <http://tex.stackexchange.com/a/169833/22451> (#1221).
    + Use `\/` to avoid en-dash ligature instead of `-{}-` (Vaclav Zeman).
      This is to fix LuaLaTeX output. The `-{}-` sequence does not avoid the
      ligature with LuaLaTeX but `\/` does.
    + Fixed string escaping in `hyperref` and `hyperdef` (#1130).

  * ConTeXt writer:  Improved autolinks (#1270).

  * DocBook writer:

    + Improve handling of hard line breaks in Docbook writer
      (Neil Mayhew).  Use a `<literallayout>` for the entire paragraph, not
      just for the newline character.
    + Don't let line breaks inside footnotes influence the enclosing
      paragraph (Neil Mayhew).
    + Distinguish tight and loose lists in DocBook output, using
      `spacing="compact"` (Neil Mayhew, #1250).

  * Docx writer:  When needed files are not present in the user's
    `reference.docx`, fall back on the versions in the `reference.docx`
    in pandoc's data files. This fixes a bug that occurs when a
    `reference.docx` saved by LibreOffice is used. (#1185)

  * EPUB writer:

    + Include extension in epub ids.  This fixes a problem with duplicate
      extensions for fonts and images with the same base name but different
      extensions (#1254).
    + Handle files linked in raw `img` tags (#1170).
    + Handle media in `audio` source tags (#1170).
      Note that we now use a `media` directory rather than `images`.
    + Incorporate files linked in `video` tags (#1170).  `src` and `poster`
      will both be incorporated into `content.opf` and the epub container.

  * HTML writer:

    + Add colgroup around col tags (#877).  Also affects EPUB writer.
    + Fixed bug with unnumbered section headings.  Unnumbered section
      headings (with class `unnumbered`) were getting numbers.
    + Improved detection of image links. Previously image links with
      queries were not recognized, causing `<embed>` to be used instead
      of `<img>`.

  * Man writer:  Ensure that terms in definition lists aren't line wrapped
    (#1195).

  * Markdown writer:

    + Use proper escapes to avoid unwanted lists (#980).  Previously we used
      0-width spaces, an ugly hack.
    + Use longer backtick fences if needed (#1206).  If the content contains a
      backtick fence and there are attributes, make sure longer fences are
      used to delimit the code.  Note:  This works well in pandoc, but github
      markdown is more limited, and will interpret the first string of three
      or more backticks as ending the code block.

  * RST writer:  Avoid stack overflow with certain tables (#1197).

  * RTF writer:  Fixed table cells containing paragraphs.

  * Custom writer:

    + Correctly handle UTF-8 in custom lua scripts (#1189).
    + Fix bugs with lua scripts with mixed-case filenames and
      paths containing `+` or `-` (#1267).  Note that `getWriter`
      in `Text.Pandoc` no longer returns a custom writer on input
      `foo.lua`.

  * AsciiDoc writer:  Handle multiblock and empty table cells
    (#1245, #1246).  Added tests.

  * `Text.Pandoc.Options`: Added `readerTrace` to `ReaderOptions`

  * `Text.Pandoc.Shared`:

    + Added `compactify'DL` (formerly in markdown reader) (Albert Krewinkel).
    + Fixed bug in `toRomanNumeral`:  numbers ending with '9' would
      be rendered as Roman numerals ending with 'IXIV' (#1249).  Thanks to
      Jesse Rosenthal.
    + `openURL`: set proxy with value of http_proxy env variable (#1211).
      Note:  proxies with non-root paths are not supported, due to
      limitations in `http-conduit`.

  * `Text.Pandoc.PDF`:

    + Ensure that temp directories deleted on Windows (#1192).  The PDF is
      now read as a strict bytestring, ensuring that process ownership will
      be terminated, so the temp directory can be deleted.
    + Use `/` as path separators in a few places, even on Windows.
      This seems to be necessary for texlive (#1151, thanks to Tim Lin).
    + Use `;` for `TEXINPUTS` separator on Windows (#1151).
    + Changes to error reporting, to handle non-UTF8 error output.

  * `Text.Pandoc.Templates`:

    + Removed unneeded datatype context (Merijn Verstraaten).

    + YAML objects resolve to "true" in conditionals (#1133).
      Note:  If `address` is a YAML object and you just have `$address$`
      in your template, the word `true` will appear, which may be
      unexpected.  (Previously nothing would appear.)

  * `Text.Pandoc.SelfContained`:  Handle `poster` attribute in `video`
    tags (#1188).

  * `Text.Pandoc.Parsing`:

    + Made `F` an instance of Applicative (#1138).
    + Added `stateCaption`.
    + Added `HasMacros`, simplified other typeclasses.
      Removed `updateHeaderMap`, `setHeaderMap`, `getHeaderMap`,
      `updateIdentifierList`, `setIdentifierList`, `getIdentifierList`.
    + Changed the smart punctuation parser to return `Inlines`
      rather than `Inline` (Matthew Pickering).
    + Changed `HasReaderOptions`, `HasHeaderMap`, `HasIdentifierList`
      from typeclasses of monads to typeclasses of states.  This simplifies
      the instance definitions and provides more flexibility.  Generalized
      type of `getOption` and added a default definition.  Removed
      `askReaderOption`.  Added `extractReaderOption`.  Added
      `extractHeaderMap` and `updateHeaderMap` in `HasHeaderMap`.
      Gave default definitions for `getHeaderMap`, `putHeaderMap`,
      `modifyHeaderMap`.  Added `extractIdentifierList` and
      `updateIdentifierList` in `HasIdentifierList`.  Gave defaults
      for `getIdentifierList`, `putIdentifierList`, and
      `modifyIdentifierList`.  The ultimate goal here is to allow different
      parsers to use their own, tailored parser states (instead of
      `ParserState`) while still using shared functions.

  * Template changes:

    + LaTeX template: Use `fontenc` package only with `pdflatex` (#1164).
    + LaTeX template:  Add `linestretch` and `fontfamily` variables.
    + LaTeX template:  Conditionalize author and date commands.
    + Beamer template: Consistent styles for figure and table captions
      (aaronwolen).
    + LaTeX and beamer template:  Adjust widths correctly for oversized
      images.  Use `\setkeys{Gin}{}` to set appropriate defaults for
      `\includegraphics` (Yihui Xie, Garrick Aden-Buie).  Load
      `upquote` only after `fontenc` (Yihui Xie).
    + Beamer template: Added caption package (#1200).
    + Beamer template:  changes for better unicode handling (KarolS).
    + DocBook template:  use `authorgroup` if there are authors.
    + revealjs template: Move `include-after` to end (certainlyakey).
    + revealjs template: Fixed PDF print function (#1220, kevinkenan).

  * Bumped version bounds of dependencies.

  * Added a `--trace` command line option, for debugging backtracking
    bugs.  So far this only works with the markdown reader.

  * MathMLinHTML:  Fixed deprecation warning (#362, gwern, Albert Krewinkel).

  * Updated travis script to test with multiple GHC versions.

  * Force failure of a Travis build if GHC produces warnings (Albert
    Krewinkel).

  * Add `.editorconfig` (Albert Krewinkel).
    See <http://editorconfig.org/> for details.

  * Give more useful error message if '-t pdf' is specified (#1155).

  * Added `Cite`, `SmallCaps` to `Arbitrary` instance (#1269).

  * Allow `html4` as a synonym of `html` as a reader (it already works
    as a writer).

  * README:

    + Added an explanation of how to use YAML metadata to
      force items to appear in the bibliography without citations in
      the text (like LaTeX `\nocite`).
    + Added note to `--bibtex/--natbib`: not for use in making PDF
      (#1194, thanks to nahoj).
    + Added explanatory notes about `--natbib` and `--biblatex`.
    + Added specification of legal syntax for citation keys.
    + Fixed variable defaults documentation (Albert Krewinkel).

  * Removed copyright statements for files that have been removed
    (Albert Krewinkel).

  * Moved some doc files from `data-files` to `extra-source-files` (#1123).
    They aren't needed at runtime.  We keep README and COPYRIGHT in data
    to ensure that they'll be available on all systems on which pandoc
    is installed.

  * Use cabal sandboxes in Windows build script.

## pandoc 1.12.3.3 (2014-02-03)

  * To changes to source; recompiled tarball with latest alex and
    happy, so they will work with GHC 7.8.

## pandoc 1.12.3.2 (2014-02-03)

  * Bumped version bounds for blaze-html, blaze-markup.

  * ImageSize:  Avoid use of lookAhead, which is not in binary >= 0.6
    (#1124).

  * Fixed mediawiki ordered list parsing (#1122).

  * HTML reader:  Fixed bug reading inline math with `$$` (#225).

  * Added support for LaTeX style literate Haskell code blocks in rST
    (Merijn Verstraaten).

## pandoc 1.12.3.1 (2014-01-14)

  * Relaxed version constraint on binary, allowing the use of binary 0.5.


## pandoc 1.12.3 (2014-01-10)

  * The `--bibliography` option now sets the `biblio-files` variable.
    So, if you're using `--natbib` or `--biblatex`, you can just use
    `--bibliography=foo.bib` instead of `-V bibliofiles=foo`.

  * Don't run pandoc-citeproc filter if `--bibliography` is
    used together with `--natbib` or `--biblatex` (Florian Eitel).

  * Template changes:

    + Updated beamer template to include booktabs.
    + Added `abstract` variable to LaTeX template.
    + Put `header-includes` after `title` in LaTeX template (#908).
    + Allow use of `\includegraphics[size]` in beamer.
      This just required porting a macro definition from the default
      LaTeX template to the default beamer template.

  * `reference.docx`:  Include `FootnoteText` style.
    Otherwise Word ignores the style, even when specified in the `pPr`.
    (#901)

  * `reference.odt`:  Tidied `styles.xml`.

  * Relaxed version bounds for dependencies.

  * Added `withSocketsDo` around http conduit code in `openURL`,
    so it works on Windows (#1080).

  * Added `Cite` function to `sample.lua`.

  * Markdown reader:

    + Fixed regression in title blocks (#1089).
      If author field was empty, date was being ignored.
    + Allow backslash-newline hard line breaks in grid and
      multiline table cells.
    + Citation keys may now start with underscores, and may contain
      underscores adjacent to internal punctuation.

  * LaTeX reader:

    + Add support for `Verb` macro (jrnold) (#1090).
    + Support babel-style quoting: `` "`..."' ``.

  * Properly handle script blocks in strict mode.  (That is,
    `markdown-markdown_in_html_blocks`.) Previously a spurious
    `<p>` tag was being added (#1093).

  * Docbook reader: Avoid failure if `tbody` contains no `tr` or `row`
    elements.

  * LaTeX writer:

    + Factored out function for table cell creation.
    + Better treatment of footnotes in tables.
      Notes now appear in the regular sequence, rather than in the
      table cell.  (This was a regression in 1.10.)

  * HTML reader: Parse name/content pairs from meta tags as metadata.
    Closes #1106.

  * Moved `fixDisplayMath` from Docx writer to `Writer.Shared`.

  * OpenDocument writer:  Fixed `RawInline`, `RawBlock` so they don't escape.

  * ODT writer:  Use mathml for proper rendering of formulas.
    Note:  LibreOffice's support for this seems a bit buggy.  But
    it should be better than what we had before.

  * RST writer: Ensure no blank line after def in definition list (#992).

  * Markdown writer: Don't use tilde code blocks with braced attributes in
    `markdown_github` output.  A consequence of this change is that the
    backtick form will be preferred in general if both are enabled.  That
    is good, as it is much more widespread than the tilde form.  (#1084)

  * Docx writer:  Fixed problem with some modified reference docx files.
    Include `word/_rels/settings.xml.rels` if it exists, as well as other
    `rels` files besides the ones pandoc generates explicitly.

  * HTML writer:

    + With `--toc`, headers no longer link to themselves (#1081).
    + Omit footnotes from TOC entries.  Otherwise we get doubled
      footnotes when headers have notes!

  * EPUB writer:

    + Avoid duplicate notes when headings contain notes.
      This arose because the headings are copied into the metadata
      "title" field, and the note gets rendered twice.  We strip the
      note now before putting the heading in "title".
    + Strip out footnotes from toc entries.
    + Fixed bug with `--epub-stylesheet`.  Now the contents of
      `writerEpubStylesheet` (set by `--epub-stylesheet`)
      should again work, and take precedence over a stylesheet specified
      in the metadata.

  * `Text.Pandoc.Pretty`:  Added `nestle`.  API change.

  * `Text.Pandoc.MIME`: Added `wmf`, `emf`.

  * `Text.Pandoc.Shared`:  `fetchItem` now handles image URLs beginning
    with `//`.

  * `Text.Pandoc.ImageSize`:  Parse EXIF format JPEGs.  Previously
    we could only get size information for JFIF format, which led
    to squished images in Word documents. Closes #976.

  * Removed old `MarkdownTest_1.0.3` directory (#1104).


## pandoc 1.12.2.1 (2013-12-08)

  * Markdown reader:  Fixed regression in list parser, involving
    continuation lines containing raw HTML (or even verbatim raw HTML).

## pandoc 1.12.2 (2013-12-07)

  * Metadata may now be included in YAML blocks in a markdown document.
    For example,

        ---
        title:
        - type: main
          text: My Book
        - type: subtitle
          text: An investigation of metadata
        creator:
        - role: author
          text: John Smith
        - role: editor
          text: Sarah Jones
        identifier:
        - scheme: DOI
          text: doi:10.234234.234/33
        publisher:  My Press
        rights:  (c) 2007 John Smith, CC BY-NC
        cover-image: img/mypic.jpg
        stylesheet: style.css
        ...

    Metadata may still be provided using `--epub-metadata`; it will
    be merged with the metadata in YAML blocks.

  * EPUB writer:

    + `meta` tags are now used instead of `opf` attributes for EPUB3.
    + Insert "svg" property as needed in opf (EPUB 3).
    + Simplify `imageTypeOf` using `getMimeType`.
    + Add properties attribute to `cover-image` item for EPUB 3.
    + Don't include node for `cover.xhtml` if no cover!
    + Ensure that same identifier is used throughout (#1044).
      If an identifier is given in metadata, we use that; otherwise
      we generate a random uuid.
    + Add cover reference to guide element (EPUB 2) (Shaun Attfield).
      Fixes an issue with Calibre putting the cover at the end of the book
      if the spine has `linear="no"`.  Apparently this is best practice
      for other converters as well:
      <http://www.idpf.org/epub/20/spec/OPF_2.0.1_draft.htm#Section2.6>.
    + Allow `stylesheet` in metadata.  The value is a path to the stylesheet.
    + Allow partial dates:  `YYYY`, `YYYY-MM`.

  * Markdown writer:  Fix rendering of tight sublists (#1050).
    Previously a spurious blank line was included after a tight sublist.

  * ODT writer:  Add `draw:name` attribute to `draw:frame` elements (#1069).
    This is reported to be necessary to avoid an error from recent
    versions of Libre Office when files contain more than one image
    Thanks to wmanley for reporting and diagnosing the problem.

  * ConTeXt writer:  Don't hardcode figure/table placement and numbering.
    Instead, let this be set in the template, using `\setupfloat`.
    Thanks to on4aa and Aditya Mahajan for the suggestion (#1067).

  * Implemented CSL flipflopping spans in DOCX, LaTeX, and HTML writers.

  * Fixed bug with markdown intraword emphasis.  Closes #1066.

  * Docbook writer:  Hierarchicalize block content in metadata.
    Previously headers just disappeared from block-level metadata
    when it was used in templates.  Now we apply the 'hierarchicalize'
    transformation.  Note that a block headed by a level-2 header will
    turn into a `<sect1>` element.

  * OpenDocument writer:  Skip raw HTML (#1035).
    Previously it was erroneously included as verbatim text.

  * HTML/EPUB writer, footnotes:  Put `<sup>` tag inside `<a>` tags.
    This allows better control of formatting, since the `<a>`
    tags have a distinguishing class (#1049).

  * Docx writer:

    + Use mime type info returned by fetchItem.
    + Fixed core metadata (#1046).
      Don't create empty date nodes if no date given.
      Don't create multiple `dc:creator` nodes; instead separate by
      semicolons.
    + Fix URL for core-properties in `_rels/.rels` (#1046).

  * Plain writer: don't print `<span>` tags.

  * LaTeX writer:

    + Fix definition lists with internal links in terms (#1032).
      This fix puts braces around a term that contains an internal
      link, to avoid problems with square brackets.
    + Properly escape pdftitle, pdfauthor (#1059).
    + Use booktabs package for tables (thanks to Jose Luis Duran).

  * Updated beamer template.  Now references should work properly
    (in a slide) when `--biblatex` or `--natbib` is used.

  * LaTeX reader:

    + Parse contents of curly quotes or matched `"` as quotes.
    + Support `\textnormal` as span with class `nodecor`.
      This is needed for pandoc-citeproc.
    + Improved citation parsing.  This fixes a run-time error that occurred
      with `\citet{}` (empty list of keys).  It also ensures that empty keys
      don't get produced.

  * MediaWiki reader:  Add automatic header identifiers.

  * HTML reader:

    + Use pandoc `Div` and `Span` for raw `<div>`, `<span>` when
      `--parse-raw`.
    + Recognize `svg` tags as block level content (thanks to MinRK).
    + Parse LaTeX math if appropriate options are set.

  * Markdown reader:

    + Yaml block must start immediately after `---`.  If there's a blank
      line after `---`, we interpreted it as a horizontal rule.
    + Correctly handle empty bullet list items.
    + Stop parsing "list lines" when we hit a block tag.
      This fixes exponential slowdown in certain input, e.g.
      a series of lists followed by `</div>`.

   * Slides:  Preserve `<div class="references">` in references slide.

  * `Text.Pandoc.Writer.Shared`:

    + Fixed bug in `tagWithAttrs`.  A space was omitted before key-value
      attributes, leading to invalid HTML.
    + `normalizeDate`: Allow dates with year only (thanks to Shaun Attfield).
    + Fixed bug in `openURL` with `data:` URIs.  Previously the base-64
      encoded bytestring was returned.  We now decode it so it's a proper
      image!

  * DocBook reader:  Handle numerical attributes starting with decimal.
    Also use `safeRead` instead of `read`.

  * `Text.Pandoc.Parsing`:

    + Generalized type of `registerHeader`, using new type classes
      `HasReadeOptions`, `HasIdentifierList`, `HasHeaderMap`.
      These allow certain common functions to be reused
      even in parsers that use custom state (instead of `ParserState`),
      such as the MediaWiki reader.
    + Moved inlineMath, displayMath from Markdown reader to Parsing.
      Generalize their types and export them from Parsing.  (API change.)

  * `Text.Pandoc.Readers.TexMath`: Export `readTeXMath'`, which attends
    to display/inline.  Deprecate `readTeXMath`, and use `readTeXMath'`
    in all the writers.  Require `texmath >= 0.6.5.2`.

  * `Text.Pandoc.MIME`:

    + Add entry for `jfif`.
    + In looking up extensions, drop the encoding info.
      E.g. for 'image/jpg;base64' we should lookup 'image/jpg'.

  * Templates:  Changed how array variables are resolved.  Previously if
    `foo` is an array (which might be because multiple values were set on
    the command line), `$foo$` would resolve to the concatenation of the
    elements of foo.  This is rarely useful behavior.  It has been changed
    so that the first value is rendered.  Of course, you can still iterate
    over the values using `$for(foo)$`.  This has the result that you can
    override earlier settings using `-V` by putting new values later on the
    command line, which is useful for many purposes.

  * `Text.Pandoc`:  Don't default to `pandocExtensions` for all writers.

  * Allow "epub2" as synonym for "epub", "html4" for "html".

  * Don't look for slidy files in data files with `--self-contained`.

  * Allow `https:` command line arguments to be downloaded.

  * Fixed `make_osx_package.sh` so data files embedded in `pandoc-citeproc`.

## pandoc 1.12.1 (2013-10-20)

  * `Text.Pandoc.Definition`:  Changed default JSON serialization format.
    Instead of `{"Str": "foo"}`, for example, we now have `{"t": "Str",
    "c": "foo"}`.  This new format is easier to work with outside of Haskell.
    Incidentally, "t" stands for "tag", "c" for "contents".

  * MediaWiki reader: Trim contents of `<math>` tags, to avoid problems
    when converting to markdown (#1027).

  * LaTeX reader:

    + Ensure that preamble doesn't contribute to the text of
      the document.
    + Fixed character escaping in `\url{}`.  Previously `\~` wasn't handled
      properly, among others.
    + Parse `{groups}` as `Span`.  This is needed for accurate conversion of
      bibtex titles, since we need to know what was protected from
      titlecase conversions.

  * LaTeX writer:

    + Specially escape non-ascii characters in labels.
      Otherwise we can get compile errors and other bugs when
      compiled with pdflatex (#1007).  Thanks to begemotv2718 for the fix.
    + Add link anchors for code blocks with identifiers (#1025).

  * Throughout the code, use `isURI` instead of `isAbsoluteURI`.
    It allows fragments identifiers.

  * Slide formats:

    + A Div element with class "notes" is treated as speaker
      notes.  Currently beamer goes to `\note{}`, revealjs to
      `<aside class="notes">`, and the notes are simply suppressed in
      other formats  (#925).
    + Fixed `. . .` (pause) on HTML slide formats.  Closes #1029.
      The old version caused a pause to be inserted before the first
      material on a slide. This has been fixed.
    + Removed data files for s5, slideous, slidy.
      Users of s5 and slideous will have to download the needed
      files, as has been documented for some time in the README.
      By default, slidy code will be sought on the web, as before.

  * HTML writer: Insert command to typeset mathjax only in slideous output
    (#966, #1012).

  * RST writer:  Skip spaces after display math.  Otherwise we get indentation
    problems, and part of the next paragraph may be rendered as part of the
    math.

  * OpenDocument writer:  Fix formatting of strikeout code (#995),
    thanks to wilx.  don't use `font-face-decls` variable.

  * Fixed test suite so it works with cabal sandboxes.

## pandoc 1.12.0.2 (2013-09-20)

  * Removed an unused dependency (`stringable`) from pandoc.cabal.
    This will help packagers, but users should not need to upgrade.

## pandoc 1.12.0.1 (2013-09-20)

  * Allow `--metadata` to be repeated for the same key to form a list.
    This also has the effect that `--bibliography` can be repeated,
    as before.

  * Handle boolean values in `--metadata