/*
 * Copyright (c) 2011-2016 Benjamin Fleischer
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of osxfuse nor the names of its contributors may be used
 *    to endorse or promote products derived from this software without specific
 *    prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <errno.h>
#include <stdlib.h>
#include <string.h>
#include <sys/sysctl.h>
#include <sys/types.h>

#include <fuse_param.h>

#include "fuse_kext.h"

#if OSXFUSE_ENABLE_MACFUSE_MODE
    #define OSXFUSE_MACFUSE_MODE_ENV "OSXFUSE_MACFUSE_MODE"
#endif

int
main(__unused int argc, __unused const char *argv[])
{
    int ret = 0;

    ret = fuse_kext_check_version();
    if (ret == 0) {
        // Kernel extension loaded
        goto kext_configure;
    } else if (ret == ENOENT) {
        // Kernel extension not loaded
        goto kext_load;
    } else if (ret == EINVAL) {
        // Kernel extension loaded, but version unsupported
        goto kext_unload;
    }
    return ret;

kext_unload:
    ret = fuse_kext_unload();
    if (ret) {
        return ret;
    }

kext_load:
    ret = fuse_kext_load();
    if (ret) {
        return ret;
    }

kext_configure:
#if OSXFUSE_ENABLE_MACFUSE_MODE
    {
        char *env_value = getenv(OSXFUSE_MACFUSE_MODE_ENV);
        if (env_value != NULL && strcmp(env_value, "1") == 0) {
            // Enable MacFUSE mode
            int32_t enabled = 1;
            (void)sysctlbyname(OSXFUSE_SYSCTL_MACFUSE_MODE, NULL, 0, &enabled,
                               sizeof(enabled));
        }
    }
#endif /* OSXFUSE_ENABLE_MACFUSE_MODE */

    return ret;
}
