/*****************************************************************************
 * Copyright (c) 2014-2020 OpenRCT2 developers
 *
 * For a complete list of all authors, please refer to contributors.md
 * Interested in contributing? Visit https://github.com/OpenRCT2/OpenRCT2
 *
 * OpenRCT2 is licensed under the GNU General Public License version 3.
 *****************************************************************************/

#include "VehiclePaint.h"

#include "../Game.h"
#include "../drawing/Drawing.h"
#include "../drawing/LightFX.h"
#include "../interface/Viewport.h"
#include "../paint/Paint.h"
#include "../ride/RideData.h"
#include "../world/Sprite.h"
#include "Track.h"

#include <iterator>

// clang-format off
// 0x0098E52C:
const vehicle_boundbox VehicleBoundboxes[16][224] = {
    { // 0x0099123C:
    {  -5,  -2, -22, 10,  4, 14 }, {  -3,  -3, -22,  6,  6, 14 }, {  -3,  -3, -22,  6,  6, 14 }, {  -3,  -3, -22,  6,  6, 14 },
    {  -2,  -5, -22,  4, 10, 14 }, {  -3,  -3, -22,  6,  6, 14 }, {  -3,  -3, -22,  6,  6, 14 }, {  -3,  -3, -22,  6,  6, 14 },
    {  -5,  -2, -22, 10,  4, 14 }, {  -3,  -3, -22,  6,  6, 14 }, {  -3,  -3, -22,  6,  6, 14 }, {  -3,  -3, -22,  6,  6, 14 },
    {  -2,  -5, -22,  4, 10, 14 }, {  -3,  -3, -22,  6,  6, 14 }, {  -3,  -3, -22,  6,  6, 14 }, {  -3,  -3, -22,  6,  6, 14 },
    {  -5,  -2, -22, 10,  4, 14 }, {  -3,  -3, -22,  6,  6, 14 }, {  -3,  -3, -22,  6,  6, 14 }, {  -3,  -3, -22,  6,  6, 14 },
    {  -2,  -5, -22,  4, 10, 14 }, {  -3,  -3, -22,  6,  6, 14 }, {  -3,  -3, -22,  6,  6, 14 }, {  -3,  -3, -22,  6,  6, 14 },
    {  -5,  -2, -22, 10,  4, 14 }, {  -3,  -3, -22,  6,  6, 14 }, {  -3,  -3, -22,  6,  6, 14 }, {  -3,  -3, -22,  6,  6, 14 },
    {  -2,  -5, -22,  4, 10, 14 }, {  -3,  -3, -22,  6,  6, 14 }, {  -3,  -3, -22,  6,  6, 14 }, {  -3,  -3, -22,  6,  6, 14 },
    { -10,  -6, -22, 16, 12, 14 }, {  -8,  -8, -22, 16, 16, 14 }, {  -6, -11, -27,  3, 16, 19 }, {  -8,  -8, -22, 16, 16, 14 },
    { -11,  -6, -27, 16,  5, 19 }, {  -8,  -8, -22, 16, 16, 14 }, {  -6, -10, -22, 12, 16, 14 }, {  -8,  -8, -22, 16, 16, 14 },
    { -10,  -6, -22, 16, 12, 14 }, {  -6,  -6, -22, 12, 12, 14 }, {  -6,  -6, -22, 12, 12, 14 }, {  -6,  -6, -22, 12, 12, 14 },
    {  -3, -10, -33,  3, 16, 27 }, {  -6,  -6, -22, 12, 12, 14 }, {  -6,  -6, -22, 12, 12, 14 }, {  -6,  -6, -22, 12, 12, 14 },
    { -13,  -6, -33, 16,  5, 24 }, {  -6,  -6, -22, 12, 12, 14 }, {  -6,  -6, -22, 12, 12, 14 }, {  -6,  -6, -22, 12, 12, 14 },
    {  -6, -10, -22, 12, 16, 14 }, {  -6,  -6, -22, 12, 12, 14 }, {  -6,  -6, -22, 12, 12, 14 }, {  -6,  -6, -22, 12, 12, 14 },
    { -10,  -6, -33, 20, 12, 24 }, {  -2,  -3, -33,  3, 10, 29 }, { -13,  -6, -33, 20,  5, 24 }, {  -6, -10, -22, 12, 20, 14 },
    { -10,  -6, -43,  5, 12, 34 }, { -10,  -6, -43,  5, 12, 34 }, { -10,  -6, -43,  5, 12, 34 }, { -10,  -6, -43,  5, 12, 34 },
    {  -2,   4, -33,  3, 10, 29 }, {  -2,   4, -33,  3, 10, 29 }, {  -2,   4, -33,  3, 10, 29 }, {  -2,   4, -33,  3, 10, 29 },
    { -13,  -6, -33, 20,  5, 24 }, { -13,  -6, -33, 20,  5, 24 }, { -13,  -6, -33, 20,  5, 24 }, { -13,  -6, -33, 20,  5, 24 },
    {  -6, -15, -22, 12, 10, 14 }, {  -6, -15, -22, 12, 10, 14 }, {  -6, -15, -22, 12, 10, 14 }, {  -6, -15, -22, 12, 10, 14 },
    { -10,  -6, -33,  4, 12, 24 }, {  -2,   4, -10,  3, 10, 24 }, {  -3,  -6, -33, 10,  5, 24 }, {  -6, -15, -10, 12, 10, 14 },
    { -10,  -6, -22,  3, 12, 14 }, {  -6,   0, -10,  3, 10, 24 }, {  -3,  -6, -22, 10,  5, 14 }, {  -6, -15, -10, 12, 10, 14 },
    { -10,  -6, -38, 20, 12,  7 }, {  -6,   0,  -5, 12, 10,  7 }, {   0,  -6, -28, 10, 12,  7 }, {  -6, -15,  -5, 12, 10,  7 },
    { -10,  -6,   5, 20, 12,  7 }, {  -6,   0,   5, 12, 10,  7 }, {   0,  -6,   5, 10, 12,  7 }, {  -6, -10,   5, 12, 10,  7 },
    { -10,  -6,   5, 20, 12,  7 }, {  -6, -10,   5, 12, 20,  7 }, { -10,  -6,   5, 20, 12,  7 }, {  -6, -10,   5, 12, 20,  7 },
    { -10,  -6,   5, 20, 12,  7 }, {  -6, -10,   5, 12, 20,  7 }, { -10,  -6,   5, 20, 12,  7 }, {  -6, -10,   5, 12, 20,  7 },
    {  -8,  -8, -22, 16, 16, 14 }, {  -8,  -8, -22, 16, 16, 14 }, {  -8,  -8, -22, 16, 16, 14 }, {  -8,  -8, -22, 16, 16, 14 },
    {  -8,  -8, -22, 16, 16, 14 }, {  -8,  -8, -22, 16, 16, 14 }, {  -8,  -8, -22, 16, 16, 14 }, {  -8,  -8, -22, 16, 16, 14 },
    {  -8,  -6,  11, 16, 12,  4 }, {  -8,  -6,  11, 16, 12,  4 }, {  -8,  -8,  11, 16, 16,  4 }, {  -6,  -8,  11, 12, 16,  4 },
    {  -6,  -8,  11, 12, 16,  4 }, {  -6,  -8, -22, 12, 16, 14 }, {  -8,  -8, -22, 16, 16, 14 }, {  -8,  -6, -22, 16, 12, 14 },
    {  -8,  -6, -22, 16, 12, 14 }, {  -8,  -6, -22, 16, 12, 14 }, {  -8,  -8, -22, 16, 16, 14 }, {  -6,  -8, -22, 12, 16, 14 },
    {  -6,  -8, -22, 12, 16, 14 }, {  -6,  -8, -22, 12, 16, 14 }, {  -8,  -8, -22, 16, 16, 14 }, {  -8,  -6, -22, 16, 12, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6, -22, 20, 12, 14 }, {  -6, -10, -22, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6, -22, 20, 12, 14 }, {  -6, -10, -22, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6, -22, 20, 12, 14 }, {  -6, -10, -22, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6, -22, 20, 12, 14 }, {  -6, -10, -22, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 },
    { -10,  -6, -22, 20, 12, 14 }, {  -6, -10, -22, 12, 20, 14 }, { -10,  -6, -22, 20, 12, 14 }, {  -6, -10, -22, 12, 20, 14 },
    { -10,  -6, -22, 20, 12, 14 }, {  -6, -10, -22, 12, 20, 14 }, { -10,  -6,  11, 20, 12, 14 }, {  -6, -10, -22, 12, 20, 14 },
    { -10,  -6, -22, 20, 12, 14 }, {  -6, -10, -22, 12, 20, 14 }, { -10,  -6,  11, 20, 12, 14 }, {  -6, -10, -22, 12, 20, 14 },
    { -10,  -6, -22, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 },
    { -10,  -6, -22, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 },
    { -10,  -6, -22, 20, 12, 14 }, {  -6, -10, -22, 12, 20, 14 }, { -10,  -6, -22, 20, 12, 14 }, {  -6, -10, -22, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10, -22, 12, 20, 14 }, { -10,  -6, -22, 20, 12, 14 }, {  -6, -10, -22, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10, -22, 12, 20, 14 }, { -10,  -6, -22, 20, 12, 14 }, {  -6, -10, -22, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6, -22, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6, -22, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 },
    { -10,  -6, -22, 20, 12, 14 }, {  -6, -10, -22, 12, 20, 14 }, { -10,  -6, -22, 20, 12, 14 }, {  -6, -10, -22, 12, 20, 14 },
    { -10,  -6, -22, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6, -22, 20, 12, 14 }, {  -6, -10, -22, 12, 20, 14 },
    { -10,  -6, -22, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6, -22, 20, 12, 14 }, {  -6, -10, -22, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6,  11, 20, 12, 14 }, {  -6, -10, -22, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6,  11, 20, 12, 14 }, {  -6, -10, -22, 12, 20, 14 },
    { -10,  -6, -22, 20, 12, 14 }, {  -6, -10, -22, 12, 20, 14 }, { -10,  -6, -22, 20, 12, 14 }, {  -6, -10, -22, 12, 20, 14 },
    { -10,  -6, -22, 20, 12, 14 }, {  -6, -10, -22, 12, 20, 14 }, { -10,  -6, -22, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 },
    { -10,  -6, -22, 20, 12, 14 }, {  -6, -10, -22, 12, 20, 14 }, { -10,  -6, -22, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10, -22, 12, 20, 14 }, { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10, -22, 12, 20, 14 }, { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 },
    },{ // 0x0099027C:
    {  -8,  -6, -28, 16, 12, 14 }, {  -8,  -6, -28, 16, 12, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -6,  -8, -28, 12, 16, 14 },
    {  -6,  -8, -28, 12, 16, 14 }, {  -6,  -8, -28, 12, 16, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -8,  -6, -28, 16, 12, 14 },
    {  -8,  -6, -28, 16, 12, 14 }, {  -8,  -6, -28, 16, 12, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -6,  -8, -28, 12, 16, 14 },
    {  -6,  -8, -28, 12, 16, 14 }, {  -6,  -8, -28, 12, 16, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -8,  -6, -28, 16, 12, 14 },
    {  -6,  -6, -28, 12, 12, 14 }, {  -9,  -6, -28, 18, 12, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -6,  -9, -28, 12, 18, 14 },
    {  -6,  -6, -28, 12, 12, 14 }, {  -6,  -9, -28, 12, 18, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -9,  -6, -28, 18, 12, 14 },
    {  -6,  -6, -28, 12, 12, 14 }, {  -9,  -6, -28, 18, 12, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -6,  -9, -28, 12, 18, 14 },
    {  -6,  -6, -28, 12, 12, 14 }, {  -6,  -9, -28, 12, 18, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -9,  -6, -28, 18, 12, 14 },
    { -10,  -6, -28, 16, 12, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -6, -11, -33,  3, 16, 19 }, {  -8,  -8, -28, 16, 16, 14 },
    { -11,  -6, -33, 16,  5, 19 }, {  -8,  -8, -28, 16, 16, 14 }, {  -6, -10, -28, 12, 16, 14 }, {  -8,  -8, -28, 16, 16, 14 },
    { -10,  -6, -28, 16, 12, 14 }, {  -6,  -6, -28, 12, 12, 14 }, {  -6,  -6, -28, 12, 12, 14 }, {  -6,  -6, -28, 12, 12, 14 },
    {  -3, -10, -39,  3, 16, 27 }, {  -6,  -6, -28, 12, 12, 14 }, {  -6,  -6, -28, 12, 12, 14 }, {  -6,  -6, -28, 12, 12, 14 },
    { -10,  -6, -39, 16,  3, 27 }, {  -6,  -6, -28, 12, 12, 14 }, {  -6,  -6, -28, 12, 12, 14 }, {  -6,  -6, -28, 12, 12, 14 },
    {  -6, -10, -28, 12, 16, 14 }, {  -6,  -6, -28, 12, 12, 14 }, {  -6,  -6, -28, 12, 12, 14 }, {  -6,  -6, -28, 12, 12, 14 },
    { -10,  -6, -28, 20, 12, 14 }, {  -2,  -3, -39,  3, 10, 29 }, {  -3,  -2, -39, 10,  3, 29 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6, -49,  5, 12, 34 }, { -10,  -6, -49,  5, 12, 34 }, { -10,  -6, -49,  5, 12, 34 }, { -10,  -6, -49,  5, 12, 34 },
    {  -2,   4, -39,  3, 10, 29 }, {  -2,   4, -39,  3, 10, 29 }, {  -2,   4, -39,  3, 10, 29 }, {  -2,   4, -39,  3, 10, 29 },
    { -13,  -6, -39, 20,  5, 24 }, { -13,  -6, -39, 20,  5, 24 }, { -13,  -6, -39, 20,  5, 24 }, { -13,  -6, -39, 20,  5, 24 },
    {  -6, -15, -28, 12, 10, 14 }, {  -6, -15, -28, 12, 10, 14 }, {  -6, -15, -28, 12, 10, 14 }, {  -6, -15, -28, 12, 10, 14 },
    { -10,  -6, -39,  4, 12, 24 }, {  -2,   4, -10,  3, 10, 24 }, {  -3,  -6, -39, 10,  5, 24 }, {  -6, -15, -10, 12, 10, 14 },
    { -10,  -6, -28,  3, 12, 14 }, {  -6,   0, -10,  3, 10, 24 }, {  -3,  -6, -28, 10,  5, 14 }, {  -6, -15, -10, 12, 10, 14 },
    { -10,  -6, -44, 20, 12,  7 }, {  -6,   0,  -5, 12, 10,  7 }, {   0,  -6, -34, 10, 12,  7 }, {  -6, -15,  -5, 12, 10,  7 },
    { -10,  -6,   5, 20, 12,  7 }, {  -6,   0,   5, 12, 10,  7 }, {   0,  -6,   5, 10, 12,  7 }, {  -6, -10,   5, 12, 10,  7 },
    { -10,  -6,   5, 20, 12,  7 }, {  -6, -10,   5, 12, 20,  7 }, { -10,  -6,   5, 20, 12,  7 }, {  -6, -10,   5, 12, 20,  7 },
    { -10,  -6,   5, 20, 12,  7 }, {  -6, -10,   5, 12, 20,  7 }, { -10,  -6,   5, 20, 12,  7 }, {  -6, -10,   5, 12, 20,  7 },
    {  -8,  -8, -28, 16, 16, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -8,  -8, -28, 16, 16, 14 },
    {  -8,  -8, -28, 16, 16, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -8,  -8, -28, 16, 16, 14 },
    {  -8,  -6,  11, 16, 12,  4 }, {  -8,  -6,  11, 16, 12,  4 }, {  -8,  -8,  11, 16, 16,  4 }, {  -6,  -8,  11, 12, 16,  4 },
    {  -6,  -8,  11, 12, 16,  4 }, {  -6,  -8, -28, 12, 16, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -8,  -6, -28, 16, 12, 14 },
    {  -8,  -6, -28, 16, 12, 14 }, {  -8,  -6, -28, 16, 12, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -6,  -8, -28, 12, 16, 14 },
    {  -6,  -8, -28, 12, 16, 14 }, {  -6,  -8, -28, 12, 16, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -8,  -6, -28, 16, 12, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 },
    { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 }, { -10,  -6,  11, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 }, { -10,  -6,  11, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6, -28, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 },
    { -10,  -6, -28, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 },
    { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 },
    { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6, -28, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6, -28, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6,  11, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6,  11, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 },
    { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 }, { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 }, { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 },
    },{ // 0x009907BC:
    {  -8,  -6, -23, 16, 12, 14 }, {  -8,  -6, -23, 16, 12, 14 }, {  -8,  -8, -23, 16, 16, 14 }, {  -6,  -8, -23, 12, 16, 14 },
    {  -6,  -8, -23, 12, 16, 14 }, {  -6,  -8, -23, 12, 16, 14 }, {  -8,  -8, -23, 16, 16, 14 }, {  -8,  -6, -23, 16, 12, 14 },
    {  -8,  -6, -23, 16, 12, 14 }, {  -8,  -6, -23, 16, 12, 14 }, {  -8,  -8, -23, 16, 16, 14 }, {  -6,  -8, -23, 12, 16, 14 },
    {  -6,  -8, -23, 12, 16, 14 }, {  -6,  -8, -23, 12, 16, 14 }, {  -8,  -8, -23, 16, 16, 14 }, {  -8,  -6, -23, 16, 12, 14 },
    {  -6,  -6, -23, 12, 12, 14 }, {  -9,  -6, -23, 18, 12, 14 }, {  -8,  -8, -23, 16, 16, 14 }, {  -6,  -9, -23, 12, 18, 14 },
    {  -6,  -6, -23, 12, 12, 14 }, {  -6,  -9, -23, 12, 18, 14 }, {  -8,  -8, -23, 16, 16, 14 }, {  -9,  -6, -23, 18, 12, 14 },
    {  -6,  -6, -23, 12, 12, 14 }, {  -9,  -6, -23, 18, 12, 14 }, {  -8,  -8, -23, 16, 16, 14 }, {  -6,  -9, -23, 12, 18, 14 },
    {  -6,  -6, -23, 12, 12, 14 }, {  -6,  -9, -23, 12, 18, 14 }, {  -8,  -8, -23, 16, 16, 14 }, {  -9,  -6, -23, 18, 12, 14 },
    { -10,  -6, -23, 16, 12, 14 }, {  -8,  -8, -23, 16, 16, 14 }, {  -6, -11, -28,  3, 16, 19 }, {  -8,  -8, -23, 16, 16, 14 },
    { -11,  -6, -28, 16,  5, 19 }, {  -8,  -8, -23, 16, 16, 14 }, {  -6, -10, -23, 12, 16, 14 }, {  -8,  -8, -23, 16, 16, 14 },
    { -10,  -6, -23, 16, 12, 14 }, {  -6,  -6, -23, 12, 12, 14 }, {  -6,  -6, -23, 12, 12, 14 }, {  -6,  -6, -23, 12, 12, 14 },
    {  -3, -10, -34,  3, 16, 27 }, {  -6,  -6, -23, 12, 12, 14 }, {  -6,  -6, -23, 12, 12, 14 }, {  -6,  -6, -23, 12, 12, 14 },
    { -13,  -6, -34, 16,  5, 24 }, {  -6,  -6, -23, 12, 12, 14 }, {  -6,  -6, -23, 12, 12, 14 }, {  -6,  -6, -23, 12, 12, 14 },
    {  -6, -10, -23, 12, 16, 14 }, {  -6,  -6, -23, 12, 12, 14 }, {  -6,  -6, -23, 12, 12, 14 }, {  -6,  -6, -23, 12, 12, 14 },
    { -10,  -6, -34, 20, 12, 24 }, {  -2,  -3, -34,  3, 10, 29 }, { -13,  -6, -34, 20,  5, 24 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6, -44,  5, 12, 34 }, { -10,  -6, -44,  5, 12, 34 }, { -10,  -6, -44,  5, 12, 34 }, { -10,  -6, -44,  5, 12, 34 },
    {  -2,   4, -34,  3, 10, 29 }, {  -2,   4, -34,  3, 10, 29 }, {  -2,   4, -34,  3, 10, 29 }, {  -2,   4, -34,  3, 10, 29 },
    { -13,  -6, -34, 20,  5, 24 }, { -13,  -6, -34, 20,  5, 24 }, { -13,  -6, -34, 20,  5, 24 }, { -13,  -6, -34, 20,  5, 24 },
    {  -6, -15, -23, 12, 10, 14 }, {  -6, -15, -23, 12, 10, 14 }, {  -6, -15, -23, 12, 10, 14 }, {  -6, -15, -23, 12, 10, 14 },
    { -10,  -6, -34,  4, 12, 24 }, {  -2,   4, -10,  3, 10, 24 }, {  -3,  -6, -34, 10,  5, 24 }, {  -6, -15, -10, 12, 10, 14 },
    { -10,  -6, -23,  3, 12, 14 }, {  -6,   0, -10,  3, 10, 24 }, {  -3,  -6, -23, 10,  5, 14 }, {  -6, -15, -10, 12, 10, 14 },
    { -10,  -6, -39, 20, 12,  7 }, {  -6,   0,  -5, 12, 10,  7 }, {   0,  -6, -29, 10, 12,  7 }, {  -6, -15,  -5, 12, 10,  7 },
    { -10,  -6,   5, 20, 12,  7 }, {  -6,   0,   5, 12, 10,  7 }, {   0,  -6,   5, 10, 12,  7 }, {  -6, -10,   5, 12, 10,  7 },
    { -10,  -6,   5, 20, 12,  7 }, {  -6, -10,   5, 12, 20,  7 }, { -10,  -6,   5, 20, 12,  7 }, {  -6, -10,   5, 12, 20,  7 },
    { -10,  -6,   5, 20, 12,  7 }, {  -6, -10,   5, 12, 20,  7 }, { -10,  -6,   5, 20, 12,  7 }, {  -6, -10,   5, 12, 20,  7 },
    {  -8,  -8, -23, 16, 16, 14 }, {  -8,  -8, -23, 16, 16, 14 }, {  -8,  -8, -23, 16, 16, 14 }, {  -8,  -8, -23, 16, 16, 14 },
    {  -8,  -8, -23, 16, 16, 14 }, {  -8,  -8, -23, 16, 16, 14 }, {  -8,  -8, -23, 16, 16, 14 }, {  -8,  -8, -23, 16, 16, 14 },
    {  -8,  -6,  11, 16, 12,  4 }, {  -8,  -6,  11, 16, 12,  4 }, {  -8,  -8,  11, 16, 16,  4 }, {  -6,  -8,  11, 12, 16,  4 },
    {  -6,  -8,  11, 12, 16,  4 }, {  -6,  -8, -23, 12, 16, 14 }, {  -8,  -8, -23, 16, 16, 14 }, {  -8,  -6, -23, 16, 12, 14 },
    {  -8,  -6, -23, 16, 12, 14 }, {  -8,  -6, -23, 16, 12, 14 }, {  -8,  -8, -23, 16, 16, 14 }, {  -6,  -8, -23, 12, 16, 14 },
    {  -6,  -8, -23, 12, 16, 14 }, {  -6,  -8, -23, 12, 16, 14 }, {  -8,  -8, -23, 16, 16, 14 }, {  -8,  -6, -23, 16, 12, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6,  11, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6,  11, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6,  11, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6,  11, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 },
    },{ // 0x009921FC:
    { -19,  -6, -28, 38, 12, 14 }, { -11,  -6, -28, 22, 12, 14 }, { -11, -11, -28, 22, 22, 14 }, {  -6, -11, -28, 12, 22, 14 },
    {  -6, -19, -28, 12, 38, 14 }, {  -6, -11, -28, 12, 22, 14 }, { -11, -11, -28, 22, 22, 14 }, { -11,  -6, -28, 22, 12, 14 },
    { -19,  -6, -28, 38, 12, 14 }, { -11,  -6, -28, 22, 12, 14 }, { -11, -11, -28, 22, 22, 14 }, {  -6, -11, -28, 12, 22, 14 },
    {  -6, -19, -28, 12, 38, 14 }, {  -6, -11, -28, 12, 22, 14 }, { -11, -11, -28, 22, 22, 14 }, { -11,  -6, -28, 22, 12, 14 },
    { -15,  -6, -28, 18, 12, 14 }, {  -9,  -6, -28, 18, 12, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -6,  -9, -28, 12, 18, 14 },
    {  -6,  -6, -28, 12, 28, 14 }, {  -6,  -9, -28, 12, 18, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -9,  -6, -28, 18, 12, 14 },
    {  -6,  -6, -28, 28, 12, 14 }, {  -9,  -6, -28, 18, 12, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -6,  -9, -28, 12, 18, 14 },
    {  -6, -15, -28, 12, 18, 14 }, {  -6,  -9, -28, 12, 18, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -9,  -6, -28, 18, 12, 14 },
    { -10,  -6, -28, 16, 12, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -6, -11, -33,  3, 16, 19 }, {  -8,  -8, -28, 16, 16, 14 },
    { -11,  -6, -33, 16,  5, 19 }, {  -8,  -8, -28, 16, 16, 14 }, {  -6, -10, -28, 12, 16, 14 }, {  -8,  -8, -28, 16, 16, 14 },
    { -10,  -6, -28, 16, 12, 14 }, {  -6,  -6, -28, 12, 12, 14 }, {  -6,  -6, -28, 12, 12, 14 }, {  -6,  -6, -28, 12, 12, 14 },
    {  -3, -10, -39,  3, 16, 27 }, {  -6,  -6, -28, 12, 12, 14 }, {  -6,  -6, -28, 12, 12, 14 }, {  -6,  -6, -28, 12, 12, 14 },
    { -13,  -6, -39, 16,  5, 24 }, {  -6,  -6, -28, 12, 12, 14 }, {  -6,  -6, -28, 12, 12, 14 }, {  -6,  -6, -28, 12, 12, 14 },
    {  -6, -10, -28, 12, 16, 14 }, {  -6,  -6, -28, 12, 12, 14 }, {  -6,  -6, -28, 12, 12, 14 }, {  -6,  -6, -28, 12, 12, 14 },
    { -10,  -6, -39, 20, 12, 24 }, {  -2,  -3, -39,  3, 10, 29 }, { -13,  -6, -39, 20,  5, 24 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6, -49,  5, 12, 34 }, { -10,  -6, -49,  5, 12, 34 }, { -10,  -6, -49,  5, 12, 34 }, { -10,  -6, -49,  5, 12, 34 },
    {  -2,   4, -39,  3, 10, 29 }, {  -2,   4, -39,  3, 10, 29 }, {  -2,   4, -39,  3, 10, 29 }, {  -2,   4, -39,  3, 10, 29 },
    { -13,  -6, -39, 20,  5, 24 }, { -13,  -6, -39, 20,  5, 24 }, { -13,  -6, -39, 20,  5, 24 }, { -13,  -6, -39, 20,  5, 24 },
    {  -6, -15, -28, 12, 10, 14 }, {  -6, -15, -28, 12, 10, 14 }, {  -6, -15, -28, 12, 10, 14 }, {  -6, -15, -28, 12, 10, 14 },
    { -10,  -6, -39,  4, 12, 24 }, {  -2,   4, -10,  3, 10, 24 }, {  -3,  -6, -39, 10,  5, 24 }, {  -6, -15, -10, 12, 10, 14 },
    { -10,  -6, -28,  3, 12, 14 }, {  -6,   0, -10,  3, 10, 24 }, {  -3,  -6, -28, 10,  5, 14 }, {  -6, -15, -10, 12, 10, 14 },
    { -10,  -6, -44, 20, 12,  7 }, {  -6,   0,  -5, 12, 10,  7 }, {   0,  -6, -34, 10, 12,  7 }, {  -6, -15,  -5, 12, 10,  7 },
    { -10,  -6,   5, 20, 12,  7 }, {  -6,   0,   5, 12, 10,  7 }, {   0,  -6,   5, 10, 12,  7 }, {  -6, -10,   5, 12, 10,  7 },
    { -10,  -6,   5, 20, 12,  7 }, {  -6, -10,   5, 12, 20,  7 }, { -10,  -6,   5, 20, 12,  7 }, {  -6, -10,   5, 12, 20,  7 },
    { -10,  -6,   5, 20, 12,  7 }, {  -6, -10,   5, 12, 20,  7 }, { -10,  -6,   5, 20, 12,  7 }, {  -6, -10,   5, 12, 20,  7 },
    {  -8,  -8, -28, 16, 16, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -8,  -8, -28, 16, 16, 14 },
    {  -8,  -8, -28, 16, 16, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -8,  -8, -28, 16, 16, 14 },
    {  -8,  -6,  11, 16, 12,  4 }, {  -8,  -6,  11, 16, 12,  4 }, {  -8,  -8,  11, 16, 16,  4 }, {  -6,  -8,  11, 12, 16,  4 },
    {  -6,  -8,  11, 12, 16,  4 }, {  -6,  -8, -28, 12, 16, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -8,  -6, -28, 16, 12, 14 },
    {  -8,  -6, -28, 16, 12, 14 }, {  -8,  -6, -28, 16, 12, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -6,  -8, -28, 12, 16, 14 },
    {  -6,  -8, -28, 12, 16, 14 }, {  -6,  -8, -28, 12, 16, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -8,  -6, -28, 16, 12, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 },
    { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 }, { -10,  -6,  11, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 }, { -10,  -6,  11, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6, -28, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 },
    { -10,  -6, -28, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 },
    { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 },
    { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6, -28, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6, -28, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6,  11, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6,  11, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 },
    { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 }, { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 }, { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 },
    },{ // 0x00991CBC:
    { -24,  -6, -28, 32, 12, 14 }, { -11,  -6, -28, 22, 12, 14 }, { -11, -11, -28, 22, 22, 14 }, {  -6, -11, -28, 12, 22, 14 },
    {  -6, -11, -28, 12, 32, 14 }, {  -6, -11, -28, 12, 22, 14 }, { -11, -11, -28, 22, 22, 14 }, { -11,  -6, -28, 22, 12, 14 },
    { -11,  -6, -28, 32, 12, 14 }, { -11,  -6, -28, 22, 12, 14 }, { -11, -11, -28, 22, 22, 14 }, {  -6, -11, -28, 12, 22, 14 },
    {  -6, -24, -28, 12, 32, 14 }, {  -6, -11, -28, 12, 22, 14 }, { -11, -11, -28, 22, 22, 14 }, { -11,  -6, -28, 22, 12, 14 },
    { -15,  -6, -28, 18, 12, 14 }, {  -9,  -6, -28, 18, 12, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -6,  -9, -28, 12, 18, 14 },
    {  -6,  -6, -28, 12, 28, 14 }, {  -6,  -9, -28, 12, 18, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -9,  -6, -28, 18, 12, 14 },
    {  -6,  -6, -28, 28, 12, 14 }, {  -9,  -6, -28, 18, 12, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -6,  -9, -28, 12, 18, 14 },
    {  -6, -15, -28, 12, 18, 14 }, {  -6,  -9, -28, 12, 18, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -9,  -6, -28, 18, 12, 14 },
    { -10,  -6, -28, 16, 12, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -6, -11, -33,  3, 16, 19 }, {  -8,  -8, -28, 16, 16, 14 },
    { -11,  -6, -33, 16,  5, 19 }, {  -8,  -8, -28, 16, 16, 14 }, {  -6, -10, -28, 12, 16, 14 }, {  -8,  -8, -28, 16, 16, 14 },
    { -10,  -6, -28, 16, 12, 14 }, {  -6,  -6, -28, 12, 12, 14 }, {  -6,  -6, -28, 12, 12, 14 }, {  -6,  -6, -28, 12, 12, 14 },
    {  -3, -10, -39,  3, 16, 27 }, {  -6,  -6, -28, 12, 12, 14 }, {  -6,  -6, -28, 12, 12, 14 }, {  -6,  -6, -28, 12, 12, 14 },
    { -13,  -6, -39, 16,  5, 24 }, {  -6,  -6, -28, 12, 12, 14 }, {  -6,  -6, -28, 12, 12, 14 }, {  -6,  -6, -28, 12, 12, 14 },
    {  -6, -10, -28, 12, 16, 14 }, {  -6,  -6, -28, 12, 12, 14 }, {  -6,  -6, -28, 12, 12, 14 }, {  -6,  -6, -28, 12, 12, 14 },
    { -10,  -6, -39, 20, 12, 24 }, {  -2,  -3, -39,  3, 10, 29 }, { -13,  -6, -39, 20,  5, 24 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6, -49,  5, 12, 34 }, { -10,  -6, -49,  5, 12, 34 }, { -10,  -6, -49,  5, 12, 34 }, { -10,  -6, -49,  5, 12, 34 },
    {  -2,   4, -39,  3, 10, 29 }, {  -2,   4, -39,  3, 10, 29 }, {  -2,   4, -39,  3, 10, 29 }, {  -2,   4, -39,  3, 10, 29 },
    { -13,  -6, -39, 20,  5, 24 }, { -13,  -6, -39, 20,  5, 24 }, { -13,  -6, -39, 20,  5, 24 }, { -13,  -6, -39, 20,  5, 24 },
    {  -6, -15, -28, 12, 10, 14 }, {  -6, -15, -28, 12, 10, 14 }, {  -6, -15, -28, 12, 10, 14 }, {  -6, -15, -28, 12, 10, 14 },
    { -10,  -6, -39,  4, 12, 24 }, {  -2,   4, -10,  3, 10, 24 }, {  -3,  -6, -39, 10,  5, 24 }, {  -6, -15, -10, 12, 10, 14 },
    { -10,  -6, -28,  3, 12, 14 }, {  -6,   0, -10,  3, 10, 24 }, {  -3,  -6, -28, 10,  5, 14 }, {  -6, -15, -10, 12, 10, 14 },
    { -10,  -6, -44, 20, 12,  7 }, {  -6,   0,  -5, 12, 10,  7 }, {   0,  -6, -34, 10, 12,  7 }, {  -6, -15,  -5, 12, 10,  7 },
    { -10,  -6,   5, 20, 12,  7 }, {  -6,   0,   5, 12, 10,  7 }, {   0,  -6,   5, 10, 12,  7 }, {  -6, -10,   5, 12, 10,  7 },
    { -10,  -6,   5, 20, 12,  7 }, {  -6, -10,   5, 12, 20,  7 }, { -10,  -6,   5, 20, 12,  7 }, {  -6, -10,   5, 12, 20,  7 },
    { -10,  -6,   5, 20, 12,  7 }, {  -6, -10,   5, 12, 20,  7 }, { -10,  -6,   5, 20, 12,  7 }, {  -6, -10,   5, 12, 20,  7 },
    {  -8,  -8, -28, 16, 16, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -8,  -8, -28, 16, 16, 14 },
    {  -8,  -8, -28, 16, 16, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -8,  -8, -28, 16, 16, 14 },
    {  -8,  -6,  11, 16, 12,  4 }, {  -8,  -6,  11, 16, 12,  4 }, {  -8,  -8,  11, 16, 16,  4 }, {  -6,  -8,  11, 12, 16,  4 },
    {  -6,  -8,  11, 12, 16,  4 }, {  -6,  -8, -28, 12, 16, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -8,  -6, -28, 16, 12, 14 },
    {  -8,  -6, -28, 16, 12, 14 }, {  -8,  -6, -28, 16, 12, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -6,  -8, -28, 12, 16, 14 },
    {  -6,  -8, -28, 12, 16, 14 }, {  -6,  -8, -28, 12, 16, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -8,  -6, -28, 16, 12, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 },
    { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 }, { -10,  -6,  11, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 }, { -10,  -6,  11, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6, -28, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 },
    { -10,  -6, -28, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 },
    { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 },
    { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6, -28, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6, -28, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6,  11, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6,  11, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 },
    { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 }, { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 }, { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 },
    },{ // 0x0098F52C
    { -14,  -6,   1, 28, 12, 14 }, { -12,  -6,   1, 24, 12, 14 }, { -10, -10,   1, 20, 20, 14 }, {  -6, -12,   1, 12, 24, 14 },
    {  -6, -14,   1, 12, 28, 14 }, {  -6, -12,   1, 12, 24, 14 }, { -10, -10,   1, 20, 20, 14 }, { -12,  -6,   1, 24, 12, 14 },
    { -14,  -6,   1, 28, 12, 14 }, { -12,  -6,   1, 24, 12, 14 }, { -10, -10,   1, 20, 20, 14 }, {  -6, -12,   1, 12, 24, 14 },
    {  -6, -14,   1, 12, 28, 14 }, {  -6, -12,   1, 12, 24, 14 }, { -10, -10,   1, 20, 20, 14 }, { -12,  -6,   1, 24, 12, 14 },
    { -13,  -6,   1, 26, 12, 14 }, { -11,  -6,   1, 22, 12, 14 }, {  -8,  -8,   1, 16, 16, 14 }, {  -6, -11,   1, 12, 22, 14 },
    {  -6, -13,   3, 12, 26, 14 }, {  -6, -11,   1, 12, 22, 14 }, {  -8,  -8,   1, 16, 16, 14 }, { -11,  -6,   1, 22, 12, 14 },
    { -13,  -6,   3, 26, 12, 14 }, { -11,  -6,   1, 22, 12, 14 }, {  -8,  -8,   1, 16, 16, 14 }, {  -6, -11,   1, 12, 22, 14 },
    {  -6, -13,   1, 12, 26, 14 }, {  -6, -11,   1, 12, 22, 14 }, {  -8,  -8,   1, 16, 16, 14 }, { -11,  -6,   1, 22, 12, 14 },
    { -14,  -6,   1, 28, 12, 14 }, {  -8,  -8,   1, 16, 16, 14 }, {  -6, -14,   1, 12, 28, 14 }, {  -8,  -8,   1, 16, 16, 14 },
    { -18,  -6,   1, 28, 12, 14 }, {  -8,  -8,   1, 16, 16, 14 }, {  -6, -14,   1, 12, 28, 14 }, {   0,   0,   1,  8,  8, 14 },
    {  -3,  -6,   5,  6, 12,  7 }, {  -8,  -6,   1, 16, 12,  7 }, {  -8,  -8,   1, 16, 16,  7 }, {  -6,  -8,   1, 12, 16,  7 },
    {  -6,  -8,   5, 12,  6,  7 }, {  -6,  -8,   1, 12, 16,  7 }, {  -8,  -8,   1, 16, 16,  7 }, {  -8,  -6,   1, 16, 12,  7 },
    {  -8,  -6,   5,  6, 12,  7 }, {  -8,  -6,   1, 16, 12,  7 }, {  -8,  -8,   1, 16, 16,  7 }, {  -6,  -8,   1, 12, 16,  7 },
    {  -6,  -3,   5, 12,  6,  7 }, {  -6,  -8,   1, 12, 16,  7 }, {  -8,  -8,   1, 16, 16,  7 }, {  -8,  -6,   1, 16, 12,  7 },
    {   0,  -6,   5,  3, 12,  5 }, {  -6, -13,   5,  3, 12,  5 }, { -13,  -6,   5, 12,  5,  5 }, {  -6,   0,   5, 12,  3,  5 },
    {   0,  -6,  -8, 10, 12, 15 }, {   0,  -6,  -8, 10, 12, 15 }, {   0,  -6,  -8, 10, 12, 15 }, {  -6, -12,  -8, 12, 10, 15 },
    {  -6, -12,  -8, 12, 10, 15 }, {  -6, -12,  -8, 12, 10, 15 }, {  -6, -12,  -8, 12, 10, 15 }, {  -6, -12,  -8, 12, 10, 15 },
    { -12,  -6,  -8, 10, 12, 15 }, { -12,  -6,  -8, 10, 12, 15 }, { -12,  -6,  -8, 10, 12, 15 }, {  -6,   0,  -8, 12, 10, 15 },
    {  -6,   0,  -8, 12, 10, 15 }, {  -6,   0,  -8, 12, 10, 15 }, {  -6,   0,  -8, 12, 10, 15 }, {  -6,   0,  -8, 12, 10, 15 },
    {  -3,  -6,  -4,  6, 12,  5 }, {  -6, -13,  -4,  3, 20,  5 }, { -13,  -6,  -4,  6,  5,  5 }, {  -6,  -3,  -4, 12, 20,  5 },
    {  -3,  -6,   1,  6, 12,  6 }, {  -6, -13, -10,  3,  6,  6 }, { -13,  -6, -10,  6,  5,  6 }, {  -6,  -3,   1, 12,  6,  6 },
    { -14,  -6, -15, 28, 12,  7 }, {  -6, -14, -15, 12, 28,  7 }, { -14,  -6, -15, 28, 12,  7 }, {  -6, -14, -15, 12, 28,  7 },
    { -14,  -6, -15, 28, 12,  7 }, {  -6, -14, -15, 12, 28,  7 }, { -14,  -6, -15, 28, 12,  7 }, {  -6, -14, -15, 12, 28,  7 },
    { -14,  -6, -15, 28, 12,  7 }, {  -6, -14, -15, 12, 28,  7 }, { -14,  -6, -15, 28, 12,  7 }, {  -6, -14, -15, 12, 28,  7 },
    { -14,  -6, -15, 28, 12,  7 }, {  -6, -14, -15, 12, 28,  7 }, { -14,  -6, -15, 28, 12,  7 }, {  -6, -14, -15, 12, 28,  7 },
    { -10, -10,   1, 20, 20, 14 }, { -10, -10,   1, 20, 20, 14 }, { -10, -10,   1, 20, 20, 14 }, { -10, -10,   1, 20, 20, 14 },
    {  -8,  -8,   1, 16, 16, 14 }, { -32, -32,  24,  4,  4, 14 }, {  -8,  -8,   1, 16, 16, 14 }, {   8,   8,   1,  8,  8, 14 },
    { -14,  -6,   1, 28, 12, 14 }, { -12,  -6,   1, 24, 12, 14 }, { -10, -10,   1, 20, 20, 14 }, {  -6, -12,   1, 12, 24, 14 },
    {  -6, -14,   1, 12, 28, 14 }, {  -6, -12,   1, 12, 24, 14 }, { -10, -10,   1, 20, 20, 14 }, { -12,  -6,   1, 24, 12, 14 },
    { -14,  -6,   1, 28, 12, 14 }, { -12,  -6,   1, 24, 12, 14 }, { -10, -10,   1, 20, 20, 14 }, {  -6, -12,   1, 12, 24, 14 },
    {  -6, -14,   1, 12, 28, 14 }, {  -6, -12,   1, 12, 24, 14 }, { -10, -10,   1, 20, 20, 14 }, { -12,  -6,   1, 24, 12, 14 },
    {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6,  10, 12, 12, 14 }, {  -6,  -6,  10, 12, 12, 14 },
    {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6,  10, 12, 12, 14 }, {  -6,  -6,  10, 12, 12, 14 },
    {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6,  10, 12, 12, 14 }, {  -6,  -6,  10, 12, 12, 14 },
    {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6,  10, 12, 12, 14 }, {  -6,  -6,  10, 12, 12, 14 },
    {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6, -12, 12, 12,  2 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    },{ // 0x0098EFEC:
    { -10,  -6,   1, 20, 12, 14 }, {  -9,  -6,   1, 18, 12, 14 }, {  -8,  -8,   1, 16, 16, 14 }, {  -6,  -9,   1, 12, 18, 14 },
    {  -6, -10,   1, 12, 20, 14 }, {  -6,  -9,   1, 12, 18, 14 }, {  -8,  -8,   1, 16, 16, 14 }, {  -9,  -6,   1, 18, 12, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -9,  -6,   1, 18, 12, 14 }, {  -8,  -8,   1, 16, 16, 14 }, {  -6,  -9,   1, 12, 18, 14 },
    {  -6, -10,   1, 12, 20, 14 }, {  -6,  -9,   1, 12, 18, 14 }, {  -8,  -8,   1, 16, 16, 14 }, {  -9,  -6,   1, 18, 12, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -8,  -6,   1, 16, 12, 14 }, {  -8,  -8,   1, 16, 16, 14 }, {  -6,  -8,   1, 12, 16, 14 },
    {  -6, -10,   2, 12, 20, 14 }, {  -6,  -8,   1, 12, 16, 14 }, {  -8,  -8,   1, 16, 16, 14 }, {  -8,  -6,   1, 16, 12, 14 },
    { -10,  -6,   2, 20, 12, 14 }, {  -8,  -6,   1, 16, 12, 14 }, {  -8,  -8,   1, 16, 16, 14 }, {  -6,  -8,   1, 12, 16, 14 },
    {  -6, -10,   1, 12, 20, 14 }, {  -6,  -8,   1, 12, 16, 14 }, {  -8,  -8,   1, 16, 16, 14 }, {  -8,  -6,   1, 16, 12, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -8,  -8,   1, 16, 16, 14 }, {  -6, -10,   1, 12, 20, 14 }, {  -8,  -8,   1, 16, 16, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -8,  -8,   1, 16, 16, 14 }, {  -6, -10,   1, 12, 20, 14 }, {   0,   0,   1,  8,  8, 14 },
    {  -3,  -6,   5,  6, 12,  7 }, {  -8,  -6,   1, 16, 12,  7 }, {  -8,  -8,   1, 16, 16,  7 }, {  -6,  -8,   1, 12, 16,  7 },
    {  -6,  -8,   5, 12,  6,  7 }, {  -6,  -8,   1, 12, 16,  7 }, {  -8,  -8,   1, 16, 16,  7 }, {  -8,  -6,   1, 16, 12,  7 },
    {  -8,  -6,   5,  6, 12,  7 }, {  -8,  -6,   1, 16, 12,  7 }, {  -8,  -8,   1, 16, 16,  7 }, {  -6,  -8,   1, 12, 16,  7 },
    {  -6,  -3,   5, 12,  6,  7 }, {  -6,  -8,   1, 12, 16,  7 }, {  -8,  -8,   1, 16, 16,  7 }, {  -8,  -6,   1, 16, 12,  7 },
    {   0,  -6,   5,  3, 12,  5 }, {  -6, -13,   5,  3, 12,  5 }, { -13,  -6,   5, 12,  5,  5 }, {  -6,   0,   5, 12,  3,  5 },
    {   0,  -6,  -8, 10, 12, 15 }, {   0,  -6,  -8, 10, 12, 15 }, {   0,  -6,  -8, 10, 12, 15 }, {  -6, -12,  -8, 12, 10, 15 },
    {  -6, -12,  -8, 12, 10, 15 }, {  -6, -12,  -8, 12, 10, 15 }, {  -6, -12,  -8, 12, 10, 15 }, {  -6, -12,  -8, 12, 10, 15 },
    { -12,  -6,  -8, 10, 12, 15 }, { -12,  -6,  -8, 10, 12, 15 }, { -12,  -6,  -8, 10, 12, 15 }, {  -6,   0,  -8, 12, 10, 15 },
    {  -6,   0,  -8, 12, 10, 15 }, {  -6,   0,  -8, 12, 10, 15 }, {  -6,   0,  -8, 12, 10, 15 }, {  -6,   0,  -8, 12, 10, 15 },
    {  -3,  -6,  -4,  6, 12,  5 }, {  -6, -13,  -4,  3, 20,  5 }, { -13,  -6,  -4,  6,  5,  5 }, {  -6,  -3,  -4, 12, 20,  5 },
    {  -3,  -6,   1,  6, 12,  6 }, {  -6, -13, -10,  3,  6,  6 }, { -13,  -6, -10,  6,  5,  6 }, {  -6,  -3,   1, 12,  6,  6 },
    { -10,  -6, -15, 20, 12,  7 }, {  -6, -10, -15, 12, 20,  7 }, { -10,  -6, -15, 20, 12,  7 }, {  -6, -10, -15, 12, 20,  7 },
    { -10,  -6, -15, 20, 12,  7 }, {  -6, -10, -15, 12, 20,  7 }, { -10,  -6, -15, 20, 12,  7 }, {  -6, -10, -15, 12, 20,  7 },
    { -10,  -6, -15, 20, 12,  7 }, {  -6, -10, -15, 12, 20,  7 }, { -10,  -6, -15, 20, 12,  7 }, {  -6, -10, -15, 12, 20,  7 },
    { -10,  -6, -15, 20, 12,  7 }, {  -6, -10, -15, 12, 20,  7 }, { -10,  -6, -15, 20, 12,  7 }, {  -6, -10, -15, 12, 20,  7 },
    {  -8,  -8,   1, 16, 16, 14 }, {  -8,  -8,   1, 16, 16, 14 }, {  -8,  -8,   1, 16, 16, 14 }, {  -8,  -8,   1, 16, 16, 14 },
    {  -8,  -8,   1, 16, 16, 14 }, { -32, -32,  24,  4,  4, 14 }, {  -8,  -8,   1, 16, 16, 14 }, {   8,   8,   1,  8,  8, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -9,  -6,   1, 18, 12, 14 }, {  -8,  -8,   1, 16, 16, 14 }, {  -6,  -9,   1, 12, 18, 14 },
    {  -6, -10,   1, 12, 20, 14 }, {  -6,  -9,   1, 12, 18, 14 }, {  -8,  -8,   1, 16, 16, 14 }, {  -9,  -6,   1, 18, 12, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -9,  -6,   1, 18, 12, 14 }, {  -8,  -8,   1, 16, 16, 14 }, {  -6,  -9,   1, 12, 18, 14 },
    {  -6, -10,   1, 12, 20, 14 }, {  -6,  -9,   1, 12, 18, 14 }, {  -8,  -8,   1, 16, 16, 14 }, {  -9,  -6,   1, 18, 12, 14 },
    {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6,  10, 12, 12, 14 }, {  -6,  -6,  10, 12, 12, 14 },
    {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6,  10, 12, 12, 14 }, {  -6,  -6,  10, 12, 12, 14 },
    {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6,  10, 12, 12, 14 }, {  -6,  -6,  10, 12, 12, 14 },
    {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6,  10, 12, 12, 14 }, {  -6,  -6,  10, 12, 12, 14 },
    {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6, -12, 12, 12,  2 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    },{ // 0x0098EAAC:
    {  -8,  -6,   1, 16, 12, 14 }, {  -7,  -6,   1, 14, 12, 14 }, {  -6,  -6,   1, 12, 12, 14 }, {  -6,  -7,   1, 12, 14, 14 },
    {  -6,  -8,   1, 12, 16, 14 }, {  -6,  -7,   1, 12, 14, 14 }, {  -6,  -6,   1, 12, 12, 14 }, {  -7,  -6,   1, 14, 12, 14 },
    {  -8,  -6,   1, 16, 12, 14 }, {  -7,  -6,   1, 14, 12, 14 }, {  -6,  -6,   1, 12, 12, 14 }, {  -6,  -7,   1, 12, 14, 14 },
    {  -6,  -8,   1, 12, 16, 14 }, {  -6,  -7,   1, 12, 14, 14 }, {  -6,  -6,   1, 12, 12, 14 }, {  -7,  -6,   1, 14, 12, 14 },
    {  -8,  -6,   1, 16, 12, 14 }, {  -7,  -6,   1, 14, 12, 14 }, {  -8,  -8,   1, 16, 16, 14 }, {  -6,  -7,   1, 12, 14, 14 },
    {  -6,  -8,   2, 12, 16, 14 }, {  -6,  -7,   1, 12, 14, 14 }, {  -8,  -8,   1, 16, 16, 14 }, {  -7,  -6,   1, 14, 12, 14 },
    {  -8,  -6,   2, 16, 12, 14 }, {  -7,  -6,   1, 14, 12, 14 }, {  -8,  -8,   1, 16, 16, 14 }, {  -6,  -7,   1, 12, 14, 14 },
    {  -6,  -8,   1, 12, 16, 14 }, {  -6,  -7,   1, 12, 14, 14 }, {  -8,  -8,   1, 16, 16, 14 }, {  -7,  -6,   1, 14, 12, 14 },
    {  -8,  -6,   1, 16, 12, 14 }, {  -8,  -8,   1, 16, 16, 14 }, {  -6,  -8,   1, 12, 16, 14 }, {  -8,  -8,   1, 16, 16, 14 },
    {  -8,  -6,   1, 16, 12, 14 }, {  -8,  -8,   1, 16, 16, 14 }, {  -6,  -8,   1, 12, 16, 14 }, {   0,   0,   1,  8,  8, 14 },
    {  -3,  -6,   5,  6, 12,  7 }, {  -8,  -6,   1, 16, 12,  7 }, {  -8,  -8,   1, 16, 16,  7 }, {  -6,  -8,   1, 12, 16,  7 },
    {  -6,  -8,   5, 12,  6,  7 }, {  -6,  -8,   1, 12, 16,  7 }, {  -8,  -8,   1, 16, 16,  7 }, {  -8,  -6,   1, 16, 12,  7 },
    {  -8,  -6,   5,  6, 12,  7 }, {  -8,  -6,   1, 16, 12,  7 }, {  -8,  -8,   1, 16, 16,  7 }, {  -6,  -8,   1, 12, 16,  7 },
    {  -6,  -3,   5, 12,  6,  7 }, {  -6,  -8,   1, 12, 16,  7 }, {  -8,  -8,   1, 16, 16,  7 }, {  -8,  -6,   1, 16, 12,  7 },
    {   0,  -6,   5,  3, 12,  5 }, {  -6, -13,   5,  3, 12,  5 }, { -13,  -6,   5, 12,  5,  5 }, {  -6,   0,   5, 12,  3,  5 },
    {   0,  -6,  -8, 10, 12, 15 }, {   0,  -6,  -8, 10, 12, 15 }, {   0,  -6,  -8, 10, 12, 15 }, {  -6, -12,  -8,  6,  6, 15 },
    { -12, -12,  -8,  6,  6, 15 }, { -12, -12,  -8,  6,  6, 15 }, { -12, -12,  -8,  6,  6, 15 }, { -12, -12,  -8,  6,  6, 15 },
    { -12, -12,  -8,  6,  6, 15 }, { -12,  -6,  -8,  6,  6, 15 }, { -12,  -6,  -8, 10, 12, 15 }, {  -6,   0,  -8, 12, 10, 15 },
    {  -6,   0,  -8, 12, 10, 15 }, {  -6,   0,  -8, 12, 10, 15 }, {  -6,   0,  -8, 12, 10, 15 }, {  -6,   0,  -8, 12, 10, 15 },
    {  -3,  -6,  -4,  6, 12,  5 }, {  -6, -13,  -4,  3, 20,  5 }, { -13,  -6,  -4,  6,  5,  5 }, {  -6,  -3,  -4, 12, 20,  5 },
    {  -3,  -6,   1,  6, 12,  6 }, {  -6, -13, -10,  3,  6,  6 }, { -13,  -6, -10,  6,  5,  6 }, {  -6,  -3,   1, 12,  6,  6 },
    { -10,  -6, -15, 20, 12,  7 }, {  -6, -10, -15, 12, 20,  7 }, { -10,  -6, -15, 20, 12,  7 }, {  -6, -10, -15, 12, 20,  7 },
    { -10,  -6, -15, 20, 12,  7 }, {  -6, -10, -15, 12, 20,  7 }, { -10,  -6, -15, 20, 12,  7 }, {  -6, -10, -15, 12, 20,  7 },
    { -10,  -6, -15, 20, 12,  7 }, {  -6, -10, -15, 12, 20,  7 }, { -10,  -6, -15, 20, 12,  7 }, {  -6, -10, -15, 12, 20,  7 },
    { -10,  -6, -15, 20, 12,  7 }, {  -6, -10, -15, 12, 20,  7 }, { -10,  -6, -15, 20, 12,  7 }, {  -6, -10, -15, 12, 20,  7 },
    {  -8,  -8,   1, 16, 16, 14 }, {  -8,  -8,   1, 16, 16, 14 }, {  -8,  -8,   1, 16, 16, 14 }, {  -8,  -8,   1, 16, 16, 14 },
    {  -8,  -8,   1, 16, 16, 14 }, { -32, -32,  24,  4,  4, 14 }, {  -8,  -8,   1, 16, 16, 14 }, {   8,   8,   1,  8,  8, 14 },
    {  -8,  -6,   1, 16, 12, 14 }, {  -7,  -6,   1, 14, 12, 14 }, {  -6,  -6,   1, 12, 12, 14 }, {  -6,  -7,   1, 12, 14, 14 },
    {  -6,  -8,   1, 12, 16, 14 }, {  -6,  -7,   1, 12, 14, 14 }, {  -6,  -6,   1, 12, 12, 14 }, {  -7,  -6,   1, 14, 12, 14 },
    {  -8,  -6,   1, 16, 12, 14 }, {  -7,  -6,   1, 14, 12, 14 }, {  -6,  -6,   1, 12, 12, 14 }, {  -6,  -7,   1, 12, 14, 14 },
    {  -6,  -8,   1, 12, 16, 14 }, {  -6,  -7,   1, 12, 14, 14 }, {  -6,  -6,   1, 12, 12, 14 }, {  -7,  -6,   1, 14, 12, 14 },
    {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6,  10, 12, 12, 14 }, {  -6,  -6,  10, 12, 12, 14 },
    {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6,  10, 12, 12, 14 }, {  -6,  -6,  10, 12, 12, 14 },
    {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6,  10, 12, 12, 14 }, {  -6,  -6,  10, 12, 12, 14 },
    {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6,  10, 12, 12, 14 }, {  -6,  -6,  10, 12, 12, 14 },
    {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6, -12, 12, 12,  2 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    },{ // 0x0098E56C:
    {  -3,  -6,   1,  6, 12, 14 }, {  -3,  -5,   1,  6, 10, 14 }, {  -5,  -5,   1, 10, 10, 14 }, {  -5,  -3,   1, 10,  6, 14 },
    {  -6,  -3,   1, 12,  6, 14 }, {  -5,  -3,   1, 10,  6, 14 }, {  -5,  -5,   1, 10, 10, 14 }, {  -3,  -5,   1,  6, 10, 14 },
    {  -3,  -6,   1,  6, 12, 14 }, {  -3,  -5,   1,  6, 10, 14 }, {  -5,  -5,   1, 10, 10, 14 }, {  -5,  -3,   1, 10,  6, 14 },
    {  -6,  -3,   1, 12,  6, 14 }, {  -5,  -3,   1, 10,  6, 14 }, {  -5,  -5,   1, 10, 10, 14 }, {  -3,  -5,   1,  6, 10, 14 },
    {  -3,  -6,   1,  6, 12, 14 }, {  -3,  -6,   1,  6, 12, 14 }, {  -8,  -8,   1, 16, 16, 14 }, {  -6,  -3,   1, 12,  6, 14 },
    {  -6,  -3,   2, 12,  6, 14 }, {  -6,  -3,   1, 12,  6, 14 }, {  -8,  -8,   1, 16, 16, 14 }, {  -3,  -6,   1,  6, 12, 14 },
    {  -3,  -6,   2,  6, 12, 14 }, {  -3,  -6,   1,  6, 12, 14 }, {  -8,  -8,   1, 16, 16, 14 }, {  -6,  -3,   1, 12,  6, 14 },
    {  -6,  -3,   1, 12,  6, 14 }, {  -6,  -3,   1, 12,  6, 14 }, {  -8,  -8,   1, 16, 16, 14 }, {  -3,  -6,   1,  6, 12, 14 },
    {  -3,  -6,   1,  6, 12,  7 }, {  -8,  -8,   1, 16, 16,  7 }, {  -6,  -3,   1, 12,  6,  7 }, {  -8,  -8,   1, 16, 16,  7 },
    {  -3,  -6,   1,  6, 12,  7 }, {  -8,  -8,   1, 16, 16,  7 }, {  -6,  -3,   1, 12,  6,  7 }, {   0,   0,   1,  8,  8,  7 },
    {  -3,  -6,   5,  6, 12,  7 }, {  -8,  -6,   1, 16, 12,  7 }, {  -8,  -8,   1, 16, 16,  7 }, {  -6,  -8,   1, 12, 16,  7 },
    {  -6,  -3,   5, 12,  6,  7 }, {  -6,  -8,   1, 12, 16,  7 }, {  -8,  -8,   1, 16, 16,  7 }, {  -8,  -6,   1, 16, 12,  7 },
    {  -3,  -6,   5,  6, 12,  7 }, {  -8,  -6,   1, 16, 12,  7 }, {  -8,  -8,   1, 16, 16,  7 }, {  -6,  -8,   1, 12, 16,  7 },
    {  -6,  -3,   5, 12,  6,  7 }, {  -6,  -8,   1, 12, 16,  7 }, {  -8,  -8,   1, 16, 16,  7 }, {  -8,  -6,   1, 16, 12,  7 },
    {   0,  -6,   5,  3, 12,  5 }, {  -6, -13,   5,  3, 12,  5 }, { -13,  -6,   5, 12,  5,  5 }, {  -6,   0,   5, 12,  3,  5 },
    {   0,  -6,  -4, 10, 12,  7 }, {   0,  -6,  -4, 10, 12,  7 }, {   0,  -6,  -4, 10, 12,  7 }, {  -6, -12,  -4, 12, 10,  7 },
    {  -6, -12,  -4, 12, 10,  7 }, {  -6, -12,  -4, 12, 10,  7 }, {  -6, -12,  -4, 12, 10,  7 }, {  -6, -12,  -4, 12, 10,  7 },
    { -12,  -6,  -4, 10, 12,  7 }, { -12,  -6,  -4, 10, 12,  7 }, { -12,  -6,  -4, 10, 12,  7 }, {  -6,   0,  -4, 12, 10,  7 },
    {  -6,   0,  -4, 12, 10,  7 }, {  -6,   0,  -4, 12, 10,  7 }, {  -6,   0,  -4, 12, 10,  7 }, {  -6,   0,  -4, 12, 10,  7 },
    {  -3,  -6,  -4,  6, 12,  5 }, {  -6, -13,  -4,  3, 20,  5 }, { -13,  -6,  -4,  6,  5,  5 }, {  -6,  -3,  -4, 12, 20,  5 },
    {  -3,  -6,   1,  6, 12,  6 }, {  -6, -13, -10,  3,  6,  6 }, { -13,  -6, -10,  6,  5,  6 }, {  -6,  -3,   1, 12,  6,  6 },
    {  -3,  -6, -15,  6, 12,  6 }, {  -6,  -3, -15, 12,  6,  6 }, {  -3,  -6, -15,  6, 12,  6 }, {  -6,  -3, -15, 12,  6,  6 },
    {  -3,  -6, -15,  6, 12,  6 }, {  -6,  -3, -15, 12,  6,  6 }, {  -3,  -6, -15,  6, 12,  6 }, {  -6,  -3, -15, 12,  6,  6 },
    {  -3,  -6, -15,  6, 12,  6 }, {  -6,  -3, -15, 12,  6,  6 }, {  -3,  -6, -15,  6, 12,  6 }, {  -6,  -3, -15, 12,  6,  6 },
    {  -3,  -6, -15,  6, 12,  6 }, {  -6,  -3, -15, 12,  6,  6 }, {  -3,  -6, -15,  6, 12,  6 }, {  -6,  -3, -15, 12,  6,  6 },
    {  -8,  -8,   1, 16, 16, 14 }, {  -8,  -8,   1, 16, 16, 14 }, {  -8,  -8,   1, 16, 16, 14 }, {  -8,  -8,   1, 16, 16, 14 },
    {  -8,  -8,   1, 16, 16, 14 }, { -32, -32,  24,  4,  4, 14 }, {  -8,  -8,   1, 16, 16, 14 }, {   8,   8,   1,  8,  8, 14 },
    {  -3,  -6,   1,  6, 12, 14 }, {  -3,  -5,   1,  6, 10, 14 }, {  -5,  -5,   1, 10, 10, 14 }, {  -5,  -3,   1, 10,  6, 14 },
    {  -6,  -3,   1, 12,  6, 14 }, {  -5,  -3,   1, 10,  6, 14 }, {  -5,  -5,   1, 10, 10, 14 }, {  -3,  -5,   1,  6, 10, 14 },
    {  -3,  -6,   1,  6, 12, 14 }, {  -3,  -5,   1,  6, 10, 14 }, {  -5,  -5,   1, 10, 10, 14 }, {  -5,  -3,   1, 10,  6, 14 },
    {  -6,  -3,   1, 12,  6, 14 }, {  -5,  -3,   1, 10,  6, 14 }, {  -5,  -5,   1, 10, 10, 14 }, {  -3,  -5,   1,  6, 10, 14 },
    {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6,  10, 12, 12, 14 }, {  -6,  -6,  10, 12, 12, 14 },
    {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6,  10, 12, 12, 14 }, {  -6,  -6,  10, 12, 12, 14 },
    {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6,  10, 12, 12, 14 }, {  -6,  -6,  10, 12, 12, 14 },
    {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6,  10, 12, 12, 14 }, {  -6,  -6,  10, 12, 12, 14 },
    {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6, -12, 12, 12,  2 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    },{ // 0x00990CFC:
    { -12,  -6,   1, 24, 12, 14 }, { -11,  -6,   1, 22, 12, 14 }, { -10, -10,   1, 20, 20, 14 }, {  -6, -11,   1, 12, 22, 14 },
    {  -6, -12,   1, 12, 24, 14 }, {  -6, -11,   1, 12, 22, 14 }, { -10, -10,   1, 20, 20, 14 }, { -11,  -6,   1, 22, 12, 14 },
    { -12,  -6,   1, 24, 12, 14 }, { -11,  -6,   1, 22, 12, 14 }, { -10, -10,   1, 20, 20, 14 }, {  -6, -11,   1, 12, 22, 14 },
    {  -6, -12,   1, 12, 24, 14 }, {  -6, -11,   1, 12, 22, 14 }, { -10, -10,   1, 20, 20, 14 }, { -11,  -6,   1, 22, 12, 14 },
    { -11,  -6,   1, 22, 12, 14 }, { -11,  -6,   1, 22, 12, 14 }, {  -8,  -8,   1, 16, 16, 14 }, {  -6, -11,   1, 12, 22, 14 },
    {  -6, -11,   3, 12, 22, 14 }, {  -6, -11,   1, 12, 22, 14 }, {  -8,  -8,   1, 16, 16, 14 }, { -11,  -6,   1, 22, 12, 14 },
    { -11,  -6,   3, 22, 12, 14 }, { -11,  -6,   1, 22, 12, 14 }, {  -8,  -8,   1, 16, 16, 14 }, {  -6, -11,   1, 12, 22, 14 },
    {  -6, -11,   1, 12, 22, 14 }, {  -6, -11,   1, 12, 22, 14 }, {  -8,  -8,   1, 16, 16, 14 }, { -11,  -6,   1, 22, 12, 14 },
    { -12,  -6,   1, 24, 12, 14 }, {  -8,  -8,   1, 16, 16, 14 }, {  -6, -12,   1, 12, 24, 14 }, {  -8,  -8,   1, 16, 16, 14 },
    { -18,  -6,   1, 24, 12, 14 }, {  -8,  -8,   1, 16, 16, 14 }, {  -6, -14,   1, 12, 24, 14 }, {   0,   0,   1,  8,  8, 14 },
    { -12,  -6,   5, 24, 12, 14 }, { -11,  -6,   1, 22, 12, 14 }, {  -8,  -8,   1, 16, 16, 14 }, {  -6, -11,   1, 12, 22, 14 },
    {  -6, -12,   5, 12, 24, 14 }, {  -6, -11,   1, 12, 22, 14 }, {  -8,  -8,   1, 16, 16, 14 }, { -11,  -6,   1, 22, 12, 14 },
    { -18,  -6,   5, 24, 12, 14 }, { -11,  -6,   1, 22, 12, 14 }, {  -8,  -8,   1, 16, 16, 14 }, {  -6, -11,   1, 12, 22, 14 },
    {  -6, -14,   5, 12, 24, 14 }, {  -6, -11,   1, 12, 22, 14 }, {  -8,  -8,   1, 16, 16, 14 }, { -11,  -6,   1, 22, 12, 14 },
    {   0,  -6, -10, 14, 12, 24 }, {  -6, -17, -10,  3, 14, 24 }, { -17,  -6, -10, 14,  5, 24 }, {  -6,   0, -10, 12, 14, 24 },
    {   0,  -6,  -7, 10, 12, 14 }, {   0,  -6,  -7, 10, 12, 14 }, {   0,  -6,  -7, 10, 12, 14 }, {   0,  -6,  -7, 10, 12, 14 },
    {  -6, -12,  -7, 12, 10, 14 }, {  -6, -12,  -7, 12, 10, 14 }, {  -6, -12,  -7, 12, 10, 14 }, {  -6, -12,  -7, 12, 10, 14 },
    { -12,  -6,  -7, 10, 12, 14 }, { -12,  -6,  -7, 10, 12, 14 }, { -12,  -6,  -7, 10, 12, 14 }, { -12,  -6,  -7, 10, 12, 14 },
    {  -6,   0,  -7, 12, 10, 14 }, {  -6,   0,  -7, 12, 10, 14 }, {  -6,   0,  -7, 12, 10, 14 }, {  -6,   0,  -7, 12, 10, 14 },
    { -14,  -6, -10, 28, 12, 24 }, {  -6, -17, -10,  3, 28, 24 }, { -17,  -6, -10, 28,  5, 24 }, {  -6, -14, -10, 12, 28, 24 },
    { -14,  -6,   1, 28, 12, 14 }, {  -6, -17, -10,  3, 28, 24 }, { -17,  -6, -10, 28,  5, 24 }, {  -6, -14,   1, 12, 28, 14 },
    { -14,  -6, -15, 28, 12,  7 }, {  -6, -14, -15, 12, 28,  7 }, { -14,  -6, -15, 28, 12,  7 }, {  -6, -14, -15, 12, 28,  7 },
    { -14,  -6, -15, 28, 12,  7 }, {  -6, -14, -15, 12, 28,  7 }, { -14,  -6, -15, 28, 12,  7 }, {  -6, -14, -15, 12, 28,  7 },
    { -14,  -6, -15, 28, 12,  7 }, {  -6, -14, -15, 12, 28,  7 }, { -14,  -6, -15, 28, 12,  7 }, {  -6, -14, -15, 12, 28,  7 },
    { -14,  -6, -15, 28, 12,  7 }, {  -6, -14, -15, 12, 28,  7 }, { -14,  -6, -15, 28, 12,  7 }, {  -6, -14, -15, 12, 28,  7 },
    { -10, -10,   1, 20, 20, 14 }, { -10, -10,   1, 20, 20, 14 }, { -10, -10,   1, 20, 20, 14 }, { -10, -10,   1, 20, 20, 14 },
    {  -8,  -8,   1, 16, 16, 14 }, {  -8,  -8,   1, 16, 16, 14 }, {  -8,  -8,   1, 16, 16, 14 }, {   8,   8,   1,  8,  8, 14 },
    { -12,  -6,   1, 24, 12, 14 }, { -11,  -6,   1, 22, 12, 14 }, { -10, -10,   1, 20, 20, 14 }, {  -6, -11,   1, 12, 22, 14 },
    {  -6, -12,   1, 12, 24, 14 }, {  -6, -11,   1, 12, 22, 14 }, { -10, -10,   1, 20, 20, 14 }, { -11,  -6,   1, 22, 12, 14 },
    { -12,  -6,   1, 24, 12, 14 }, { -11,  -6,   1, 22, 12, 14 }, { -10, -10,   1, 20, 20, 14 }, {  -6, -11,   1, 12, 22, 14 },
    {  -6, -12,   1, 12, 24, 14 }, {  -6, -11,   1, 12, 22, 14 }, { -10, -10,   1, 20, 20, 14 }, { -11,  -6,   1, 22, 12, 14 },
    {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6,  10, 12, 12, 14 }, {  -6,  -6,  10, 12, 12, 14 },
    {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6,  10, 12, 12, 14 }, {  -6,  -6,  10, 12, 12, 14 },
    {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6,  10, 12, 12, 14 }, {  -6,  -6,  10, 12, 12, 14 },
    {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6,  10, 12, 12, 14 }, {  -6,  -6,  10, 12, 12, 14 },
    {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6, -12, 12, 12,  2 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    },{ // 0x0098FA6C:
    { -18,  -6,   1, 36, 12, 11 }, { -17,  -6,   1, 34, 12, 11 }, { -15, -15,   1, 30, 30, 11 }, {  -6, -17,   1, 12, 34, 11 },
    {  -6, -18,   1, 12, 36, 11 }, {  -6, -17,   1, 12, 34, 11 }, { -15, -15,   1, 30, 30, 11 }, { -17,  -6,   1, 34, 12, 11 },
    { -18,  -6,   1, 36, 12, 11 }, { -17,  -6,   1, 34, 12, 11 }, { -15, -15,   1, 30, 30, 11 }, {  -6, -17,   1, 12, 34, 11 },
    {  -6, -18,   1, 12, 36, 11 }, {  -6, -17,   1, 12, 34, 11 }, { -15, -15,   1, 30, 30, 11 }, { -17,  -6,   1, 34, 12, 11 },
    { -14,  -6,   1, 28, 12, 14 }, { -11,  -6,   1, 22, 12, 14 }, {  -8,  -8,   1, 16, 16, 14 }, {  -6, -11,   1, 12, 22, 14 },
    {  -6, -14,   3, 12, 28, 14 }, {  -6, -11,   1, 12, 22, 14 }, {  -8,  -8,   1, 16, 16, 14 }, { -11,  -6,   1, 22, 12, 14 },
    { -14,  -6,   3, 28, 12, 14 }, { -11,  -6,   1, 22, 12, 14 }, {  -8,  -8,   1, 16, 16, 14 }, {  -6, -11,   1, 12, 22, 14 },
    {  -6, -14,   1, 12, 28, 14 }, {  -6, -11,   1, 12, 22, 14 }, {  -8,  -8,   1, 16, 16, 14 }, { -11,  -6,   1, 22, 12, 14 },
    { -14,  -6,   1, 28, 12, 14 }, {  -8,  -8,   1, 16, 16, 14 }, {  -6, -14,   1, 12, 28, 14 }, {  -8,  -8,   1, 16, 16, 14 },
    { -14,  -6,   1, 28, 12, 14 }, {  -8,  -8,   1, 16, 16, 14 }, {  -6, -14,   1, 12, 28, 14 }, {   0,   0,   1,  8,  8, 14 },
    {  -3,  -6,   5,  6, 12,  7 }, {  -8,  -6,   1, 16, 12,  7 }, {  -8,  -8,   1, 16, 16,  7 }, {  -6,  -8,   1, 12, 16,  7 },
    {  -6,  -8,   5, 12,  6,  7 }, {  -6,  -8,   1, 12, 16,  7 }, {  -8,  -8,   1, 16, 16,  7 }, {  -8,  -6,   1, 16, 12,  7 },
    {  -8,  -6,   5,  6, 12,  7 }, {  -8,  -6,   1, 16, 12,  7 }, {  -8,  -8,   1, 16, 16,  7 }, {  -6,  -8,   1, 12, 16,  7 },
    {  -6,  -3,   5, 12,  6,  7 }, {  -6,  -8,   1, 12, 16,  7 }, {  -8,  -8,   1, 16, 16,  7 }, {  -8,  -6,   1, 16, 12,  7 },
    {   0,  -6,   5,  3, 12,  5 }, {  -6, -13,   5,  3, 12,  5 }, { -13,  -6,   5, 12,  5,  5 }, {  -6,   0,   5, 12,  3,  5 },
    {   0,  -6,  -8, 10, 12, 15 }, {   0,  -6,  -8, 10, 12, 15 }, {   0,  -6,  -8, 10, 12, 15 }, {  -6, -12,  -8, 12, 10, 15 },
    {  -6, -12,  -8, 12, 10, 15 }, {  -6, -12,  -8, 12, 10, 15 }, {  -6, -12,  -8, 12, 10, 15 }, {  -6, -12,  -8, 12, 10, 15 },
    { -12,  -6,  -8, 10, 12, 15 }, { -12,  -6,  -8, 10, 12, 15 }, { -12,  -6,  -8, 10, 12, 15 }, {  -6,   0,  -8, 12, 10, 15 },
    {  -6,   0,  -8, 12, 10, 15 }, {  -6,   0,  -8, 12, 10, 15 }, {  -6,   0,  -8, 12, 10, 15 }, {  -6,   0,  -8, 12, 10, 15 },
    {  -3,  -6,  -4,  6, 12,  5 }, {  -6, -13,  -4,  3, 20,  5 }, { -13,  -6,  -4,  6,  5,  5 }, {  -6,  -3,  -4, 12, 20,  5 },
    {  -3,  -6,   1,  6, 12,  6 }, {  -6, -13, -10,  3,  6,  6 }, { -13,  -6, -10,  6,  5,  6 }, {  -6,  -3,   1, 12,  6,  6 },
    { -14,  -6, -15, 28, 12,  7 }, {  -6, -14, -15, 12, 28,  7 }, { -14,  -6, -15, 28, 12,  7 }, {  -6, -14, -15, 12, 28,  7 },
    { -14,  -6, -15, 28, 12,  7 }, {  -6, -14, -15, 12, 28,  7 }, { -14,  -6, -15, 28, 12,  7 }, {  -6, -14, -15, 12, 28,  7 },
    { -14,  -6, -15, 28, 12,  7 }, {  -6, -14, -15, 12, 28,  7 }, { -14,  -6, -15, 28, 12,  7 }, {  -6, -14, -15, 12, 28,  7 },
    { -14,  -6, -15, 28, 12,  7 }, {  -6, -14, -15, 12, 28,  7 }, { -14,  -6, -15, 28, 12,  7 }, {  -6, -14, -15, 12, 28,  7 },
    { -10, -10,   1, 20, 20, 14 }, { -10, -10,   1, 20, 20, 14 }, { -10, -10,   1, 20, 20, 14 }, { -10, -10,   1, 20, 20, 14 },
    {  -8,  -8,   1, 16, 16, 14 }, { -32, -32,  24,  4,  4, 14 }, {  -8,  -8,   1, 16, 16, 14 }, {   8,   8,   1,  8,  8, 14 },
    { -14,  -6,   1, 28, 12, 14 }, { -12,  -6,   1, 24, 12, 14 }, { -10, -10,   1, 20, 20, 14 }, {  -6, -12,   1, 12, 24, 14 },
    {  -6, -14,   1, 12, 28, 14 }, {  -6, -12,   1, 12, 24, 14 }, { -10, -10,   1, 20, 20, 14 }, { -12,  -6,   1, 24, 12, 14 },
    { -14,  -6,   1, 28, 12, 14 }, { -12,  -6,   1, 24, 12, 14 }, { -10, -10,   1, 20, 20, 14 }, {  -6, -12,   1, 12, 24, 14 },
    {  -6, -14,   1, 12, 28, 14 }, {  -6, -12,   1, 12, 24, 14 }, { -10, -10,   1, 20, 20, 14 }, { -12,  -6,   1, 24, 12, 14 },
    {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6,  10, 12, 12, 14 }, {  -6,  -6,  10, 12, 12, 14 },
    {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6,  10, 12, 12, 14 }, {  -6,  -6,  10, 12, 12, 14 },
    {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6,  10, 12, 12, 14 }, {  -6,  -6,  10, 12, 12, 14 },
    {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6,  10, 12, 12, 14 }, {  -6,  -6,  10, 12, 12, 14 },
    {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6, -12, 12, 12,  2 }, {  -6,  -6, -12, 12, 12,  2 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    },{ // 0x0099177C:
    { -16,  -6,   1, 32, 12,  8 }, {  -5,  -5,   1, 10, 10,  8 }, {  -4,  -4,   1,  8,  8,  8 }, {  -5,  -5,   1, 10, 10,  8 },
    {  -6, -16,   1, 12, 32,  8 }, {  -5,  -5,   1, 10, 10,  8 }, {  -4,  -4,   1,  8,  8,  8 }, {  -5,  -5,   1, 10, 10,  8 },
    { -16,  -6,   1, 32, 12,  8 }, {  -5,  -5,   1, 10, 10,  8 }, {  -4,  -4,   1,  8,  8,  8 }, {  -5,  -5,   1, 10, 10,  8 },
    {  -6, -16,   1, 12, 32,  8 }, {  -5,  -5,   1, 10, 10,  8 }, {  -4,  -4,   1,  8,  8,  8 }, {  -5,  -5,   1, 10, 10,  8 },
    { -13,  -6,   1, 26, 12, 14 }, { -11,  -6,   1, 22, 12, 14 }, {  -8,  -8,   1, 16, 16, 14 }, {  -6, -11,   1, 12, 22, 14 },
    {  -6, -13,   3, 12, 26, 14 }, {  -6, -11,   1, 12, 22, 14 }, {  -8,  -8,   1, 16, 16, 14 }, { -11,  -6,   1, 22, 12, 14 },
    { -13,  -6,   3, 26, 12, 14 }, { -11,  -6,   1, 22, 12, 14 }, {  -8,  -8,   1, 16, 16, 14 }, {  -6, -11,   1, 12, 22, 14 },
    {  -6, -13,   1, 12, 26, 14 }, {  -6, -11,   1, 12, 22, 14 }, {  -8,  -8,   1, 16, 16, 14 }, { -11,  -6,   1, 22, 12, 14 },
    { -14,  -6,   1, 28, 12, 14 }, {  -8,  -8,   1, 16, 16, 14 }, {  -6, -14,   1, 12, 28, 14 }, {  -8,  -8,   1, 16, 16, 14 },
    { -18,  -6,   1, 28, 12, 14 }, {  -8,  -8,   1, 16, 16, 14 }, {  -6, -14,   1, 12, 28, 14 }, {   0,   0,   1,  8,  8, 14 },
    { -14,  -6,   5, 28, 12, 14 }, { -11,  -6,   1, 22, 12, 14 }, {  -8,  -8,   1, 16, 16, 14 }, {  -6, -11,   1, 12, 22, 14 },
    {  -6, -14,   5, 12, 28, 14 }, {  -6, -11,   1, 12, 22, 14 }, {  -8,  -8,   1, 16, 16, 14 }, { -11,  -6,   1, 22, 12, 14 },
    { -18,  -6,   5, 28, 12, 14 }, { -11,  -6,   1, 22, 12, 14 }, {  -8,  -8,   1, 16, 16, 14 }, {  -6, -11,   1, 12, 22, 14 },
    {  -6, -14,   5, 12, 28, 14 }, {  -6, -11,   1, 12, 22, 14 }, {  -8,  -8,   1, 16, 16, 14 }, { -11,  -6,   1, 22, 12, 14 },
    { -14,  -6, -10, 28, 12, 24 }, {  -6, -17, -10,  3, 28, 24 }, { -17,  -6, -10, 28,  5, 24 }, {  -6, -14, -10, 12, 28, 24 },
    {   0,  -6,  -7, 10, 12, 14 }, {   0,  -6,  -7, 10, 12, 14 }, {   0,  -6,  -7, 10, 12, 14 }, {   0,  -6,  -7, 10, 12, 14 },
    {  -6, -12,  -7, 12, 10, 14 }, {  -6, -12,  -7, 12, 10, 14 }, {  -6, -12,  -7, 12, 10, 14 }, {  -6, -12,  -7, 12, 10, 14 },
    { -12,  -6,  -7, 10, 12, 14 }, { -12,  -6,  -7, 10, 12, 14 }, { -12,  -6,  -7, 10, 12, 14 }, { -12,  -6,  -7, 10, 12, 14 },
    {  -6,   0,  -7, 12, 10, 14 }, {  -6,   0,  -7, 12, 10, 14 }, {  -6,   0,  -7, 12, 10, 14 }, {  -6,   0,  -7, 12, 10, 14 },
    { -14,  -6, -10, 28, 12, 24 }, {  -6, -17, -10,  3, 28, 24 }, { -17,  -6, -10, 28,  5, 24 }, {  -6, -14, -10, 12, 28, 24 },
    { -14,  -6,   1, 28, 12, 14 }, {  -6, -17, -10,  3, 28, 24 }, { -17,  -6, -10, 28,  5, 24 }, {  -6, -14,   1, 12, 28, 14 },
    { -14,  -6, -15, 28, 12,  7 }, {  -6, -14, -15, 12, 28,  7 }, { -14,  -6, -15, 28, 12,  7 }, {  -6, -14, -15, 12, 28,  7 },
    { -14,  -6, -15, 28, 12,  7 }, {  -6, -14, -15, 12, 28,  7 }, { -14,  -6, -15, 28, 12,  7 }, {  -6, -14, -15, 12, 28,  7 },
    { -14,  -6, -15, 28, 12,  7 }, {  -6, -14, -15, 12, 28,  7 }, { -14,  -6, -15, 28, 12,  7 }, {  -6, -14, -15, 12, 28,  7 },
    { -16,  -6,   1, 32, 12,  8 }, {  -6, -16,   1, 12, 32,  8 }, { -16,  -6,   1, 32, 12,  8 }, {  -6, -16,   1, 12, 32,  8 },
    { -10, -10,   1, 20, 20, 14 }, { -10, -10,   1, 20, 20, 14 }, { -10, -10,   1, 20, 20, 14 }, { -10, -10,   1, 20, 20, 14 },
    {  -8,  -8,   1, 16, 16, 14 }, {  -8,  -8,   1, 16, 16, 14 }, {  -8,  -8,   1, 16, 16, 14 }, {   8,   8,   1,  8,  8, 14 },
    { -16,  -6,   1, 32, 12,  8 }, {  -5,  -5,   1, 10, 10,  8 }, {  -4,  -4,   1,  8,  8,  8 }, {  -5,  -5,   1, 10, 10,  8 },
    {  -6, -16,   1, 12, 32,  8 }, {  -5,  -5,   1, 10, 10,  8 }, {  -4,  -4,   1,  8,  8,  8 }, {  -5,  -5,   1, 10, 10,  8 },
    { -16,  -6,   1, 32, 12,  8 }, {  -5,  -5,   1, 10, 10,  8 }, {  -4,  -4,   1,  8,  8,  8 }, {  -5,  -5,   1, 10, 10,  8 },
    {  -6, -16,   1, 12, 32,  8 }, {  -5,  -5,   1, 10, 10,  8 }, {  -4,  -4,   1,  8,  8,  8 }, {  -5,  -5,   1, 10, 10,  8 },
    { -16,  -6,   1, 32, 12,  8 }, {  -6, -16,   1, 12, 32,  8 }, { -16,  -6,   1, 32, 12,  8 }, {  -6, -16,   1, 12, 32,  8 },
    { -16,  -6,   1, 32, 12,  8 }, {  -6, -16,   1, 12, 32,  8 }, { -16,  -6,   1, 32, 12,  8 }, {  -6, -16,   1, 12, 32,  8 },
    { -16,  -6,   1, 32, 12,  8 }, {  -6, -16,   1, 12, 32,  8 }, { -16,  -6,   1, 32, 12,  8 }, {  -6, -16,   1, 12, 32,  8 },
    { -16,  -6,   1, 32, 12,  8 }, {  -6, -16,   1, 12, 32,  8 }, { -16,  -6,   1, 32, 12,  8 }, {  -6, -16,   1, 12, 32,  8 },
    { -16,  -6,   1, 32, 12,  8 }, {  -6, -16,   1, 12, 32,  8 }, { -16,  -6,   1, 32, 12,  8 }, {  -6, -16,   1, 12, 32,  8 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6,   1, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6,   1, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    { -10,  -6, -23, 20, 12, 14 }, {  -6, -10,   1, 12, 20, 14 }, { -10,  -6, -23, 20, 12, 14 }, {  -6, -10, -23, 12, 20, 14 },
    },{ // 0x009900FC:
    { -16,  -6,   1, 32, 12, 14 }, { -12,  -6,   1, 24, 12, 14 }, { -10, -10,   1, 20, 20, 14 }, {  -6, -12,   1, 12, 24, 14 },
    {  -6, -16,   1, 12, 32, 14 }, {  -6, -12,   1, 12, 24, 14 }, { -10, -10,   1, 20, 20, 14 }, { -12,  -6,   1, 24, 12, 14 },
    { -16,  -6,   1, 32, 12, 14 }, { -12,  -6,   1, 24, 12, 14 }, { -10, -10,   1, 20, 20, 14 }, {  -6, -12,   1, 12, 24, 14 },
    {  -6, -16,   1, 12, 32, 14 }, {  -6, -12,   1, 12, 24, 14 }, { -10, -10,   1, 20, 20, 14 }, { -12,  -6,   1, 24, 12, 14 },
    { -14,  -6,   5, 28, 12,  9 }, { -11,  -6,   1, 22, 12, 14 }, {  -8,  -8,   1, 16, 16, 14 }, {  -6, -11,   1, 12, 22, 14 },
    {  -6, -14,   5, 12, 28,  9 }, {  -6, -11,   1, 12, 22, 14 }, {  -8,  -8,   1, 16, 16, 14 }, { -11,  -6,   1, 22, 12, 14 },
    { -14,  -6,   5, 28, 12,  9 }, { -11,  -6,   1, 22, 12, 14 }, {  -8,  -8,   1, 16, 16, 14 }, {  -6, -11,   1, 12, 22, 14 },
    {  -6, -14,   5, 12, 28,  9 }, {  -6, -11,   1, 12, 22, 14 }, {  -8,  -8,   1, 16, 16, 14 }, { -11,  -6,   1, 22, 12, 14 },
    {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 },
    {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 },
    {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 },
    {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 },
    {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 },
    {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 },
    {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 },
    {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 },
    {  -8,  -6, -28, 16, 12, 14 }, {  -8,  -6, -28, 16, 12, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -6,  -8, -28, 12, 16, 14 },
    {  -6,  -8, -28, 12, 16, 14 }, {  -6,  -8, -28, 12, 16, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -8,  -6, -28, 16, 12, 14 },
    {  -8,  -6, -28, 16, 12, 14 }, {  -8,  -6, -28, 16, 12, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -6,  -8, -28, 12, 16, 14 },
    {  -6,  -8, -28, 12, 16, 14 }, {  -6,  -8, -28, 12, 16, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -8,  -6, -28, 16, 12, 14 },
    {  -6,  -6, -28, 12, 12, 14 }, {  -9,  -6, -28, 18, 12, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -6,  -9, -28, 12, 18, 14 },
    {  -6,  -6, -28, 12, 12, 14 }, {  -6,  -9, -28, 12, 18, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -9,  -6, -28, 18, 12, 14 },
    {  -6,  -6, -28, 12, 12, 14 }, {  -9,  -6, -28, 18, 12, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -6,  -9, -28, 12, 18, 14 },
    {  -6,  -6, -28, 12, 12, 14 }, {  -6,  -9, -28, 12, 18, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -9,  -6, -28, 18, 12, 14 },
    { -10,  -6, -28, 16, 12, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -6, -11, -33,  3, 16, 19 }, {  -8,  -8, -28, 16, 16, 14 },
    { -11,  -6, -33, 16,  5, 19 }, {  -8,  -8, -28, 16, 16, 14 }, {  -6, -10, -28, 12, 16, 14 }, {  -8,  -8, -28, 16, 16, 14 },
    { -10,  -6, -28, 16, 12, 14 }, {  -6,  -6, -28, 12, 12, 14 }, {  -6,  -6, -28, 12, 12, 14 }, {  -6,  -6, -28, 12, 12, 14 },
    {  -3, -10, -39,  3, 16, 27 }, {  -6,  -6, -28, 12, 12, 14 }, {  -6,  -6, -28, 12, 12, 14 }, {  -6,  -6, -28, 12, 12, 14 },
    { -10,  -6, -39, 16,  3, 27 }, {  -6,  -6, -28, 12, 12, 14 }, {  -6,  -6, -28, 12, 12, 14 }, {  -6,  -6, -28, 12, 12, 14 },
    {  -6, -10, -28, 12, 16, 14 }, {  -6,  -6, -28, 12, 12, 14 }, {  -6,  -6, -28, 12, 12, 14 }, {  -6,  -6, -28, 12, 12, 14 },
    { -10,  -6, -28, 20, 12, 14 }, {  -2,  -3, -39,  3, 10, 29 }, {  -3,  -2, -39, 10,  3, 29 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6, -49,  5, 12, 34 }, { -10,  -6, -49,  5, 12, 34 }, { -10,  -6, -49,  5, 12, 34 }, { -10,  -6, -49,  5, 12, 34 },
    {  -2,   4, -39,  3, 10, 29 }, {  -2,   4, -39,  3, 10, 29 }, {  -2,   4, -39,  3, 10, 29 }, {  -2,   4, -39,  3, 10, 29 },
    { -13,  -6, -39, 20,  5, 24 }, { -13,  -6, -39, 20,  5, 24 }, { -13,  -6, -39, 20,  5, 24 }, { -13,  -6, -39, 20,  5, 24 },
    {  -6, -15, -28, 12, 10, 14 }, {  -6, -15, -28, 12, 10, 14 }, {  -6, -15, -28, 12, 10, 14 }, {  -6, -15, -28, 12, 10, 14 },
    { -10,  -6, -39,  4, 12, 24 }, {  -2,   4, -10,  3, 10, 24 }, {  -3,  -6, -39, 10,  5, 24 }, {  -6, -15, -10, 12, 10, 14 },
    { -10,  -6, -28,  3, 12, 14 }, {  -6,   0, -10,  3, 10, 24 }, {  -3,  -6, -28, 10,  5, 14 }, {  -6, -15, -10, 12, 10, 14 },
    { -10,  -6, -44, 20, 12,  7 }, {  -6,   0,  -5, 12, 10,  7 }, {   0,  -6, -34, 10, 12,  7 }, {  -6, -15,  -5, 12, 10,  7 },
    { -10,  -6,   5, 20, 12,  7 }, {  -6,   0,   5, 12, 10,  7 }, {   0,  -6,   5, 10, 12,  7 }, {  -6, -10,   5, 12, 10,  7 },
    { -10,  -6,   5, 20, 12,  7 }, {  -6, -10,   5, 12, 20,  7 }, { -10,  -6,   5, 20, 12,  7 }, {  -6, -10,   5, 12, 20,  7 },
    { -10,  -6,   5, 20, 12,  7 }, {  -6, -10,   5, 12, 20,  7 }, { -10,  -6,   5, 20, 12,  7 }, {  -6, -10,   5, 12, 20,  7 },
    {  -8,  -8, -28, 16, 16, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -8,  -8, -28, 16, 16, 14 },
    {  -8,  -8, -28, 16, 16, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -8,  -8, -28, 16, 16, 14 },
    {  -8,  -6,  11, 16, 12,  4 }, {  -8,  -6,  11, 16, 12,  4 }, {  -8,  -8,  11, 16, 16,  4 }, {  -6,  -8,  11, 12, 16,  4 },
    {  -6,  -8,  11, 12, 16,  4 }, {  -6,  -8, -28, 12, 16, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -8,  -6, -28, 16, 12, 14 },
    {  -8,  -6, -28, 16, 12, 14 }, {  -8,  -6, -28, 16, 12, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -6,  -8, -28, 12, 16, 14 },
    {  -6,  -8, -28, 12, 16, 14 }, {  -6,  -8, -28, 12, 16, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -8,  -6, -28, 16, 12, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 },
    { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 }, { -10,  -6,  11, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 }, { -10,  -6,  11, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6, -28, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 },
    },{ // 0x009901BC:
    {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 },
    {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 },
    {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 },
    {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 },
    {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 },
    {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 },
    {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 },
    {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 },
    {  -8,  -6, -28, 16, 12, 14 }, {  -8,  -6, -28, 16, 12, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -6,  -8, -28, 12, 16, 14 },
    {  -6,  -8, -28, 12, 16, 14 }, {  -6,  -8, -28, 12, 16, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -8,  -6, -28, 16, 12, 14 },
    {  -8,  -6, -28, 16, 12, 14 }, {  -8,  -6, -28, 16, 12, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -6,  -8, -28, 12, 16, 14 },
    {  -6,  -8, -28, 12, 16, 14 }, {  -6,  -8, -28, 12, 16, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -8,  -6, -28, 16, 12, 14 },
    {  -6,  -6, -28, 12, 12, 14 }, {  -9,  -6, -28, 18, 12, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -6,  -9, -28, 12, 18, 14 },
    {  -6,  -6, -28, 12, 12, 14 }, {  -6,  -9, -28, 12, 18, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -9,  -6, -28, 18, 12, 14 },
    {  -6,  -6, -28, 12, 12, 14 }, {  -9,  -6, -28, 18, 12, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -6,  -9, -28, 12, 18, 14 },
    {  -6,  -6, -28, 12, 12, 14 }, {  -6,  -9, -28, 12, 18, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -9,  -6, -28, 18, 12, 14 },
    { -10,  -6, -28, 16, 12, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -6, -11, -33,  3, 16, 19 }, {  -8,  -8, -28, 16, 16, 14 },
    { -11,  -6, -33, 16,  5, 19 }, {  -8,  -8, -28, 16, 16, 14 }, {  -6, -10, -28, 12, 16, 14 }, {  -8,  -8, -28, 16, 16, 14 },
    { -10,  -6, -28, 16, 12, 14 }, {  -6,  -6, -28, 12, 12, 14 }, {  -6,  -6, -28, 12, 12, 14 }, {  -6,  -6, -28, 12, 12, 14 },
    {  -3, -10, -39,  3, 16, 27 }, {  -6,  -6, -28, 12, 12, 14 }, {  -6,  -6, -28, 12, 12, 14 }, {  -6,  -6, -28, 12, 12, 14 },
    { -10,  -6, -39, 16,  3, 27 }, {  -6,  -6, -28, 12, 12, 14 }, {  -6,  -6, -28, 12, 12, 14 }, {  -6,  -6, -28, 12, 12, 14 },
    {  -6, -10, -28, 12, 16, 14 }, {  -6,  -6, -28, 12, 12, 14 }, {  -6,  -6, -28, 12, 12, 14 }, {  -6,  -6, -28, 12, 12, 14 },
    { -10,  -6, -28, 20, 12, 14 }, {  -2,  -3, -39,  3, 10, 29 }, {  -3,  -2, -39, 10,  3, 29 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6, -49,  5, 12, 34 }, { -10,  -6, -49,  5, 12, 34 }, { -10,  -6, -49,  5, 12, 34 }, { -10,  -6, -49,  5, 12, 34 },
    {  -2,   4, -39,  3, 10, 29 }, {  -2,   4, -39,  3, 10, 29 }, {  -2,   4, -39,  3, 10, 29 }, {  -2,   4, -39,  3, 10, 29 },
    { -13,  -6, -39, 20,  5, 24 }, { -13,  -6, -39, 20,  5, 24 }, { -13,  -6, -39, 20,  5, 24 }, { -13,  -6, -39, 20,  5, 24 },
    {  -6, -15, -28, 12, 10, 14 }, {  -6, -15, -28, 12, 10, 14 }, {  -6, -15, -28, 12, 10, 14 }, {  -6, -15, -28, 12, 10, 14 },
    { -10,  -6, -39,  4, 12, 24 }, {  -2,   4, -10,  3, 10, 24 }, {  -3,  -6, -39, 10,  5, 24 }, {  -6, -15, -10, 12, 10, 14 },
    { -10,  -6, -28,  3, 12, 14 }, {  -6,   0, -10,  3, 10, 24 }, {  -3,  -6, -28, 10,  5, 14 }, {  -6, -15, -10, 12, 10, 14 },
    { -10,  -6, -44, 20, 12,  7 }, {  -6,   0,  -5, 12, 10,  7 }, {   0,  -6, -34, 10, 12,  7 }, {  -6, -15,  -5, 12, 10,  7 },
    { -10,  -6,   5, 20, 12,  7 }, {  -6,   0,   5, 12, 10,  7 }, {   0,  -6,   5, 10, 12,  7 }, {  -6, -10,   5, 12, 10,  7 },
    { -10,  -6,   5, 20, 12,  7 }, {  -6, -10,   5, 12, 20,  7 }, { -10,  -6,   5, 20, 12,  7 }, {  -6, -10,   5, 12, 20,  7 },
    { -10,  -6,   5, 20, 12,  7 }, {  -6, -10,   5, 12, 20,  7 }, { -10,  -6,   5, 20, 12,  7 }, {  -6, -10,   5, 12, 20,  7 },
    {  -8,  -8, -28, 16, 16, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -8,  -8, -28, 16, 16, 14 },
    {  -8,  -8, -28, 16, 16, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -8,  -8, -28, 16, 16, 14 },
    {  -8,  -6,  11, 16, 12,  4 }, {  -8,  -6,  11, 16, 12,  4 }, {  -8,  -8,  11, 16, 16,  4 }, {  -6,  -8,  11, 12, 16,  4 },
    {  -6,  -8,  11, 12, 16,  4 }, {  -6,  -8, -28, 12, 16, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -8,  -6, -28, 16, 12, 14 },
    {  -8,  -6, -28, 16, 12, 14 }, {  -8,  -6, -28, 16, 12, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -6,  -8, -28, 12, 16, 14 },
    {  -6,  -8, -28, 12, 16, 14 }, {  -6,  -8, -28, 12, 16, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -8,  -6, -28, 16, 12, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 },
    { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 }, { -10,  -6,  11, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 }, { -10,  -6,  11, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6, -28, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 },
    { -10,  -6, -28, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 },
    { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 },
    { -10,  -6,  11, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 },
    { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6, -28, 20, 12, 14 }, {  -6, -10,  11, 12, 20, 14 }, { -10,  -6, -28, 20, 12, 14 }, {  -6, -10, -28, 12, 20, 14 },
    },{ // 0x0098FFAC:
    {  -3,  -6,  -1,  6, 12,  1 }, {  -3,  -5,  -1,  6, 10,  1 }, {  -5,  -5,  -1, 10, 10,  1 }, {  -5,  -3,  -1, 10,  6,  1 },
    {  -6,  -3,  -1, 12,  6,  1 }, {  -5,  -3,  -1, 10,  6,  1 }, {  -5,  -5,  -1, 10, 10,  1 }, {  -3,  -5,  -1,  6, 10,  1 },
    {  -3,  -6,  -1,  6, 12,  1 }, {  -3,  -5,  -1,  6, 10,  1 }, {  -5,  -5,  -1, 10, 10,  1 }, {  -5,  -3,  -1, 10,  6,  1 },
    {  -6,  -3,  -1, 12,  6,  1 }, {  -5,  -3,  -1, 10,  6,  1 }, {  -5,  -5,  -1, 10, 10,  1 }, {  -3,  -5,  -1,  6, 10,  1 },
    {  -3,  -6,  -8,  6, 12,  1 }, {  -3,  -6,  -1,  6, 12,  1 }, {  -8,  -8,  -1, 16, 16,  1 }, {  -6,  -3,  -1, 12,  6,  1 },
    {  -6,  -3,   0, 12,  6,  1 }, {  -6,  -3,  -1, 12,  6,  1 }, {  -8,  -8,  -1, 16, 16,  1 }, {  -3,  -6,  -1,  6, 12,  1 },
    {  -3,  -6,   0,  6, 12,  1 }, {  -3,  -6,  -1,  6, 12,  1 }, {  -8,  -8,  -1, 16, 16,  1 }, {  -6,  -3,  -1, 12,  6,  1 },
    {  -6,  -3,  -8, 12,  6,  1 }, {  -6,  -3,  -1, 12,  6,  1 }, {  -8,  -8,  -1, 16, 16,  1 }, {  -3,  -6,  -1,  6, 12,  1 },
    {  -3,  -6, -10,  6, 12,  1 }, {  -8,  -8,  -2, 16, 16,  1 }, {  -6,  -3,  -2, 12,  6,  1 }, {  -8,  -8,  -2, 16, 16,  1 },
    {  -3,  -6,  -2,  6, 12,  1 }, {  -8,  -8,  -2, 16, 16,  1 }, {  -6,  -3, -10, 12,  6,  1 }, {   0,   0,  -2,  8,  8,  1 },
    {  -3,  -6, -12,  6, 12,  1 }, {  -8,  -6,  -6, 16, 12,  1 }, {  -8,  -8,  -6, 16, 16,  1 }, {  -6,  -8,  -6, 12, 16,  1 },
    {  -6,  -3,  -2, 12,  6,  1 }, {  -6,  -8,  -6, 12, 16,  1 }, {  -8,  -8,  -6, 16, 16,  1 }, {  -8,  -6,  -6, 16, 12,  1 },
    {  -3,  -6,  -2,  6, 12,  1 }, {  -8,  -6,  -6, 16, 12,  1 }, {  -8,  -8,  -6, 16, 16,  1 }, {  -6,  -8,  -6, 12, 16,  1 },
    {  -6,  -3, -12, 12,  6,  1 }, {  -6,  -8,  -6, 12, 16,  1 }, {  -8,  -8,  -6, 16, 16,  1 }, {  -8,  -6,  -6, 16, 12,  1 },
    { -16,  -6,   1, 32, 12, 14 }, { -12,  -6,   1, 24, 12, 14 }, { -10, -10,   1, 20, 20, 14 }, {  -6, -12,   1, 12, 24, 14 },
    {  -6, -16,   1, 12, 32, 14 }, {  -6, -12,   1, 12, 24, 14 }, { -10, -10,   1, 20, 20, 14 }, { -12,  -6,   1, 24, 12, 14 },
    { -16,  -6,   1, 32, 12, 14 }, { -12,  -6,   1, 24, 12, 14 }, { -10, -10,   1, 20, 20, 14 }, {  -6, -12,   1, 12, 24, 14 },
    {  -6, -16,   1, 12, 32, 14 }, {  -6, -12,   1, 12, 24, 14 }, { -10, -10,   1, 20, 20, 14 }, { -12,  -6,   1, 24, 12, 14 },
    { -14,  -6,   5, 28, 12,  9 }, { -11,  -6,   1, 22, 12, 14 }, {  -8,  -8,   1, 16, 16, 14 }, {  -6, -11,   1, 12, 22, 14 },
    {  -6, -14,   5, 12, 28,  9 }, {  -6, -11,   1, 12, 22, 14 }, {  -8,  -8,   1, 16, 16, 14 }, { -11,  -6,   1, 22, 12, 14 },
    { -14,  -6,   5, 28, 12,  9 }, { -11,  -6,   1, 22, 12, 14 }, {  -8,  -8,   1, 16, 16, 14 }, {  -6, -11,   1, 12, 22, 14 },
    {  -6, -14,   5, 12, 28,  9 }, {  -6, -11,   1, 12, 22, 14 }, {  -8,  -8,   1, 16, 16, 14 }, { -11,  -6,   1, 22, 12, 14 },
    {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 },
    {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 },
    {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 },
    {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 },
    {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 },
    {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 },
    {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 },
    {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 }, {  -6,  -6,  -4, 12, 12,  1 },
    {  -8,  -6, -28, 16, 12, 14 }, {  -8,  -6, -28, 16, 12, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -6,  -8, -28, 12, 16, 14 },
    {  -6,  -8, -28, 12, 16, 14 }, {  -6,  -8, -28, 12, 16, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -8,  -6, -28, 16, 12, 14 },
    {  -8,  -6, -28, 16, 12, 14 }, {  -8,  -6, -28, 16, 12, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -6,  -8, -28, 12, 16, 14 },
    {  -6,  -8, -28, 12, 16, 14 }, {  -6,  -8, -28, 12, 16, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -8,  -6, -28, 16, 12, 14 },
    {  -6,  -6, -28, 12, 12, 14 }, {  -9,  -6, -28, 18, 12, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -6,  -9, -28, 12, 18, 14 },
    {  -6,  -6, -28, 12, 12, 14 }, {  -6,  -9, -28, 12, 18, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -9,  -6, -28, 18, 12, 14 },
    {  -6,  -6, -28, 12, 12, 14 }, {  -9,  -6, -28, 18, 12, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -6,  -9, -28, 12, 18, 14 },
    {  -6,  -6, -28, 12, 12, 14 }, {  -6,  -9, -28, 12, 18, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -9,  -6, -28, 18, 12, 14 },
    { -10,  -6, -28, 16, 12, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -6, -11, -33,  3, 16, 19 }, {  -8,  -8, -28, 16, 16, 14 },
    { -11,  -6, -33, 16,  5, 19 }, {  -8,  -8, -28, 16, 16, 14 }, {  -6, -10, -28, 12, 16, 14 }, {  -8,  -8, -28, 16, 16, 14 },
    { -10,  -6, -28, 16, 12, 14 }, {  -6,  -6, -28, 12, 12, 14 }, {  -6,  -6, -28, 12, 12, 14 }, {  -6,  -6, -28, 12, 12, 14 },
    {  -3, -10, -39,  3, 16, 27 }, {  -6,  -6, -28, 12, 12, 14 }, {  -6,  -6, -28, 12, 12, 14 }, {  -6,  -6, -28, 12, 12, 14 },
    { -10,  -6, -39, 16,  3, 27 }, {  -6,  -6, -28, 12, 12, 14 }, {  -6,  -6, -28, 12, 12, 14 }, {  -6,  -6, -28, 12, 12, 14 },
    {  -6, -10, -28, 12, 16, 14 }, {  -6,  -6, -28, 12, 12, 14 }, {  -6,  -6, -28, 12, 12, 14 }, {  -6,  -6, -28, 12, 12, 14 },
    { -10,  -6, -28, 20, 12, 14 }, {  -2,  -3, -39,  3, 10, 29 }, {  -3,  -2, -39, 10,  3, 29 }, {  -6, -10, -28, 12, 20, 14 },
    { -10,  -6, -49,  5, 12, 34 }, { -10,  -6, -49,  5, 12, 34 }, { -10,  -6, -49,  5, 12, 34 }, { -10,  -6, -49,  5, 12, 34 },
    {  -2,   4, -39,  3, 10, 29 }, {  -2,   4, -39,  3, 10, 29 }, {  -2,   4, -39,  3, 10, 29 }, {  -2,   4, -39,  3, 10, 29 },
    { -13,  -6, -39, 20,  5, 24 }, { -13,  -6, -39, 20,  5, 24 }, { -13,  -6, -39, 20,  5, 24 }, { -13,  -6, -39, 20,  5, 24 },
    {  -6, -15, -28, 12, 10, 14 }, {  -6, -15, -28, 12, 10, 14 }, {  -6, -15, -28, 12, 10, 14 }, {  -6, -15, -28, 12, 10, 14 },
    { -10,  -6, -39,  4, 12, 24 }, {  -2,   4, -10,  3, 10, 24 }, {  -3,  -6, -39, 10,  5, 24 }, {  -6, -15, -10, 12, 10, 14 },
    { -10,  -6, -28,  3, 12, 14 }, {  -6,   0, -10,  3, 10, 24 }, {  -3,  -6, -28, 10,  5, 14 }, {  -6, -15, -10, 12, 10, 14 },
    { -10,  -6, -44, 20, 12,  7 }, {  -6,   0,  -5, 12, 10,  7 }, {   0,  -6, -34, 10, 12,  7 }, {  -6, -15,  -5, 12, 10,  7 },
    { -10,  -6,   5, 20, 12,  7 }, {  -6,   0,   5, 12, 10,  7 }, {   0,  -6,   5, 10, 12,  7 }, {  -6, -10,   5, 12, 10,  7 },
    { -10,  -6,   5, 20, 12,  7 }, {  -6, -10,   5, 12, 20,  7 }, { -10,  -6,   5, 20, 12,  7 }, {  -6, -10,   5, 12, 20,  7 },
    { -10,  -6,   5, 20, 12,  7 }, {  -6, -10,   5, 12, 20,  7 }, { -10,  -6,   5, 20, 12,  7 }, {  -6, -10,   5, 12, 20,  7 },
    {  -8,  -8, -28, 16, 16, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -8,  -8, -28, 16, 16, 14 }, {  -8,  -8, -28, 16, 16, 14 },
    },{ // 0x0099273C:
    {  -6,  -6,   0, 12, 12, 31 }, {  -6,  -6,   0, 12, 12, 31 }, {  -6,  -6,   0, 12, 12, 31 }, {  -6,  -6,   0, 12, 12, 31 },
    {  -6,  -6,   0, 12, 12, 31 }, {  -6,  -6,   0, 12, 12, 31 }, {  -6,  -6,   0, 12, 12, 31 }, {  -6,  -6,   0, 12, 12, 31 },
    {  -6,  -6,   0, 12, 12, 31 }, {  -6,  -6,   0, 12, 12, 31 }, {  -6,  -6,   0, 12, 12, 31 }, {  -6,  -6,   0, 12, 12, 31 },
    {  -6,  -6,   0, 12, 12, 31 }, {  -6,  -6,   0, 12, 12, 31 }, {  -6,  -6,   0, 12, 12, 31 }, {  -6,  -6,   0, 12, 12, 31 },
    }
};
// clang-format on

// 6D5214
static void vehicle_sprite_paint(
    paint_session* session, const Vehicle* vehicle, int32_t ebx, int32_t ecx, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    int32_t baseImage_id = ebx;
    if (vehicleEntry->draw_order >= std::size(VehicleBoundboxes))
    {
        return;
    }
    vehicle_boundbox bb = VehicleBoundboxes[vehicleEntry->draw_order][ecx];

    if (vehicleEntry->flags & VEHICLE_ENTRY_FLAG_SPINNING_ADDITIONAL_FRAMES)
    {
        baseImage_id += (vehicle->spin_sprite / 8) & 31;
    }
    if (vehicleEntry->flags & VEHICLE_ENTRY_FLAG_VEHICLE_ANIMATION)
    {
        baseImage_id += vehicle->animation_frame;
    }
    int32_t image_id = baseImage_id | (vehicle->colours.body_colour << 19) | (vehicle->colours.trim_colour << 24)
        | IMAGE_TYPE_REMAP_2_PLUS;

    if (vehicle->IsGhost())
    {
        image_id &= 0x7FFFF;
        image_id |= CONSTRUCTION_MARKER;
    }
    paint_struct* ps = PaintAddImageAsParent(
        session, image_id, 0, 0, bb.length_x, bb.length_y, bb.length_z, z, bb.offset_x, bb.offset_y, bb.offset_z + z);
    if (ps != nullptr)
    {
        ps->tertiary_colour = vehicle->colours_extended;
    }
    rct_drawpixelinfo* dpi = &session->DPI;
    if (dpi->zoom_level < 2 && vehicle->num_peeps > 0 && vehicleEntry->no_seating_rows > 0)
    {
        baseImage_id += vehicleEntry->no_vehicle_images;
        for (int32_t i = 0; i < 8; i++)
        {
            if (vehicle->num_peeps > (i * 2) && vehicleEntry->no_seating_rows > i)
            {
                image_id = baseImage_id
                    | SPRITE_ID_PALETTE_COLOUR_2(
                               vehicle->peep_tshirt_colours[i * 2], vehicle->peep_tshirt_colours[(i * 2) + 1]);
                if (i == 0 && vehicleEntry->flags & VEHICLE_ENTRY_FLAG_RIDER_ANIMATION)
                {
                    image_id += (vehicleEntry->no_vehicle_images * vehicle->animation_frame);
                }

                if (vehicle->IsGhost())
                {
                    image_id &= 0x7FFFF;
                    image_id |= CONSTRUCTION_MARKER;
                }

                PaintAddImageAsChild(
                    session, image_id, 0, 0, bb.length_x, bb.length_y, bb.length_z, z, bb.offset_x, bb.offset_y,
                    bb.offset_z + z);
                baseImage_id += vehicleEntry->no_vehicle_images;
            }
        }
    }
    vehicle_visual_splash_effect(session, z, vehicle, vehicleEntry);
}

// 6D520E
static void vehicle_sprite_paint_6D520E(
    paint_session* session, const Vehicle* vehicle, int32_t ebx, int32_t ecx, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    vehicle_sprite_paint(session, vehicle, ebx + vehicle->SwingSprite, ecx, z, vehicleEntry);
}

// 6D51EB
static void vehicle_sprite_paint_6D51EB(
    paint_session* session, const Vehicle* vehicle, int32_t ebx, int32_t z, const rct_ride_entry_vehicle* vehicleEntry)
{
    int32_t ecx = ebx / 2;
    if (vehicleEntry->flags & VEHICLE_ENTRY_FLAG_11)
    {
        ebx = ebx / 2;
    }
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_15)
    {
        ebx = ebx / 8;
    }
    ebx = (ebx * vehicleEntry->base_num_frames) + vehicle->SwingSprite + vehicleEntry->base_image_id;
    vehicle_sprite_paint(session, vehicle, ebx, ecx, z, vehicleEntry);
}

// 6D51DE
static void vehicle_sprite_paint_6D51DE(
    paint_session* session, const Vehicle* vehicle, int32_t ebx, int32_t z, const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicle->restraints_position < 64)
    {
        vehicle_sprite_paint_6D51EB(session, vehicle, ebx, z, vehicleEntry);
        return;
    }
    if (!(vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_RESTRAINT_ANIMATION))
    {
        vehicle_sprite_paint_6D51EB(session, vehicle, ebx, z, vehicleEntry);
        return;
    }
    if (ebx & 7)
    {
        vehicle_sprite_paint_6D51EB(session, vehicle, ebx, z, vehicleEntry);
        return;
    }
    int32_t ecx = ebx / 2;
    ebx = ebx / 8;
    ebx += ((vehicle->restraints_position - 64) / 64) * 4;
    ebx *= vehicleEntry->base_num_frames;
    ebx += vehicleEntry->restraint_image_id;
    vehicle_sprite_paint(session, vehicle, ebx, ecx, z, vehicleEntry);
}

// 6D51DE
static void vehicle_sprite_0_0(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    vehicle_sprite_paint_6D51DE(session, vehicle, imageDirection, z, vehicleEntry);
}

// 6D4EE7
static void vehicle_sprite_0_1(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_FLAT_BANKED)
    {
        int32_t ecx = imageDirection / 2;
        int32_t ebx = ((imageDirection / 4) * vehicleEntry->base_num_frames) + vehicleEntry->banked_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
    else
    {
        vehicle_sprite_paint_6D51DE(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D4F34
static void vehicle_sprite_0_2(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_FLAT_BANKED)
    {
        int32_t ecx = (imageDirection / 2) + 108;
        int32_t ebx = ((imageDirection + 16) * vehicleEntry->base_num_frames) + vehicleEntry->banked_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
    else
    {
        vehicle_sprite_paint_6D51DE(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D4F0C
static void vehicle_sprite_0_3(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_FLAT_BANKED)
    {
        int32_t ecx = imageDirection / 2;
        int32_t ebx = (((imageDirection / 4) + 8) * vehicleEntry->base_num_frames) + vehicleEntry->banked_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
    else
    {
        vehicle_sprite_paint_6D51DE(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D4F5C
static void vehicle_sprite_0_4(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_FLAT_BANKED)
    {
        int32_t ecx = ((imageDirection / 2) ^ 8) + 108;
        int32_t ebx = ((imageDirection + 48) * vehicleEntry->base_num_frames) + vehicleEntry->banked_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
    else
    {
        vehicle_sprite_paint_6D51DE(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D4F84
static void vehicle_sprite_0_5(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicle->HasUpdateFlag(VEHICLE_UPDATE_FLAG_USE_INVERTED_SPRITES))
    {
        vehicleEntry--;
    }
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_INLINE_TWISTS)
    {
        int32_t ecx = (imageDirection / 8) + 124;
        int32_t ebx = ((imageDirection / 8) * vehicleEntry->base_num_frames) + vehicleEntry->inline_twist_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
    else
    {
        vehicle_sprite_0_2(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D4FE4
static void vehicle_sprite_0_6(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicle->HasUpdateFlag(VEHICLE_UPDATE_FLAG_USE_INVERTED_SPRITES))
    {
        vehicleEntry--;
    }
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_INLINE_TWISTS)
    {
        int32_t ecx = (imageDirection / 8) + 128;
        int32_t ebx = (((imageDirection / 8) + 8) * vehicleEntry->base_num_frames) + vehicleEntry->inline_twist_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
    else
    {
        vehicle_sprite_0_2(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D5055
static void vehicle_sprite_0_7(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicle->HasUpdateFlag(VEHICLE_UPDATE_FLAG_USE_INVERTED_SPRITES))
    {
        vehicleEntry--;
    }
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_INLINE_TWISTS)
    {
        int32_t ecx = (imageDirection / 8) + 132;
        int32_t ebx = (((imageDirection / 8) + 16) * vehicleEntry->base_num_frames) + vehicleEntry->inline_twist_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
    else
    {
        vehicle_sprite_0_2(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D50C6
static void vehicle_sprite_0_8(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicle->HasUpdateFlag(VEHICLE_UPDATE_FLAG_USE_INVERTED_SPRITES))
    {
        vehicleEntry--;
    }
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_INLINE_TWISTS)
    {
        int32_t ecx = (imageDirection / 8) + 136;
        int32_t ebx = (((imageDirection / 8) + 24) * vehicleEntry->base_num_frames) + vehicleEntry->inline_twist_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
    else
    {
        vehicle_sprite_0_2(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D5137
static void vehicle_sprite_0_9(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicle->HasUpdateFlag(VEHICLE_UPDATE_FLAG_USE_INVERTED_SPRITES))
    {
        vehicleEntry--;
    }
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_INLINE_TWISTS)
    {
        int32_t ecx = (imageDirection / 8) + 140;
        int32_t ebx = (((imageDirection / 8) + 32) * vehicleEntry->base_num_frames) + vehicleEntry->inline_twist_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
    else
    {
        vehicle_sprite_0_2(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D4FB1
static void vehicle_sprite_0_10(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicle->HasUpdateFlag(VEHICLE_UPDATE_FLAG_USE_INVERTED_SPRITES))
    {
        vehicleEntry--;
    }
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_INLINE_TWISTS)
    {
        int32_t ecx = ((imageDirection / 8) ^ 2) + 124;
        int32_t ebx = (((imageDirection / 8) + 4) * vehicleEntry->base_num_frames) + vehicleEntry->inline_twist_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
    else
    {
        vehicle_sprite_0_4(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D501B
static void vehicle_sprite_0_11(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicle->HasUpdateFlag(VEHICLE_UPDATE_FLAG_USE_INVERTED_SPRITES))
    {
        vehicleEntry--;
    }
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_INLINE_TWISTS)
    {
        int32_t ecx = ((imageDirection / 8) ^ 2) + 128;
        int32_t ebx = (((imageDirection / 8) + 12) * vehicleEntry->base_num_frames) + vehicleEntry->inline_twist_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
    else
    {
        vehicle_sprite_0_4(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D508C
static void vehicle_sprite_0_12(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicle->HasUpdateFlag(VEHICLE_UPDATE_FLAG_USE_INVERTED_SPRITES))
    {
        vehicleEntry--;
    }
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_INLINE_TWISTS)
    {
        int32_t ecx = ((imageDirection / 8) ^ 2) + 132;
        int32_t ebx = (((imageDirection / 8) + 20) * vehicleEntry->base_num_frames) + vehicleEntry->inline_twist_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
    else
    {
        vehicle_sprite_0_4(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D50FD
static void vehicle_sprite_0_13(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicle->HasUpdateFlag(VEHICLE_UPDATE_FLAG_USE_INVERTED_SPRITES))
    {
        vehicleEntry--;
    }
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_INLINE_TWISTS)
    {
        int32_t ecx = ((imageDirection / 8) ^ 2) + 136;
        int32_t ebx = (((imageDirection / 8) + 28) * vehicleEntry->base_num_frames) + vehicleEntry->inline_twist_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
    else
    {
        vehicle_sprite_0_4(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D516E
static void vehicle_sprite_0_14(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicle->HasUpdateFlag(VEHICLE_UPDATE_FLAG_USE_INVERTED_SPRITES))
    {
        vehicleEntry--;
    }
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_INLINE_TWISTS)
    {
        int32_t ecx = ((imageDirection / 8) ^ 2) + 140;
        int32_t ebx = (((imageDirection / 8) + 36) * vehicleEntry->base_num_frames) + vehicleEntry->inline_twist_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
    else
    {
        vehicle_sprite_0_2(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D4EE4
static void vehicle_sprite_0_16(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    vehicleEntry--;
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_FLAT_BANKED)
    {
        int32_t ecx = imageDirection / 2;
        int32_t ebx = ((imageDirection / 4) * vehicleEntry->base_num_frames) + vehicleEntry->banked_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
    else
    {
        vehicle_sprite_paint_6D51DE(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D4F31
static void vehicle_sprite_0_17(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    vehicleEntry--;
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_FLAT_BANKED)
    {
        int32_t ecx = (imageDirection / 2) + 108;
        int32_t ebx = ((imageDirection + 16) * vehicleEntry->base_num_frames) + vehicleEntry->banked_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
    else
    {
        vehicle_sprite_paint_6D51DE(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D4F09
static void vehicle_sprite_0_18(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    vehicleEntry--;
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_FLAT_BANKED)
    {
        int32_t ecx = imageDirection / 2;
        int32_t ebx = (((imageDirection / 4) + 8) * vehicleEntry->base_num_frames) + vehicleEntry->banked_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
    else
    {
        vehicle_sprite_paint_6D51DE(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D4F59
static void vehicle_sprite_0_19(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    vehicleEntry--;
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_FLAT_BANKED)
    {
        int32_t ecx = ((imageDirection / 2) ^ 8) + 108;
        int32_t ebx = ((imageDirection + 48) * vehicleEntry->base_num_frames) + vehicleEntry->banked_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
    else
    {
        vehicle_sprite_paint_6D51DE(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D51D7
static void vehicle_sprite_0(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    // 0x009A3DE4:
    switch (vehicle->bank_rotation)
    {
        case 0:
            vehicle_sprite_0_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 1:
            vehicle_sprite_0_1(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 2:
            vehicle_sprite_0_2(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 3:
            vehicle_sprite_0_3(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 4:
            vehicle_sprite_0_4(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 5:
            vehicle_sprite_0_5(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 6:
            vehicle_sprite_0_6(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 7:
            vehicle_sprite_0_7(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 8:
            vehicle_sprite_0_8(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 9:
            vehicle_sprite_0_9(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 10:
            vehicle_sprite_0_10(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 11:
            vehicle_sprite_0_11(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 12:
            vehicle_sprite_0_12(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 13:
            vehicle_sprite_0_13(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 14:
            vehicle_sprite_0_14(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 15:
            vehicle_sprite_0_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 16:
            vehicle_sprite_0_16(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 17:
            vehicle_sprite_0_17(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 18:
            vehicle_sprite_0_18(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 19:
            vehicle_sprite_0_19(session, vehicle, imageDirection, z, vehicleEntry);
            break;
    }
}

// 6D4614
static void vehicle_sprite_1_0(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_GENTLE_SLOPES)
    {
        int32_t ecx = imageDirection / 2;
        int32_t ebx = ((imageDirection / 8) * vehicleEntry->base_num_frames) + vehicleEntry->gentle_slope_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
    else
    {
        vehicle_sprite_0(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D4662
static void vehicle_sprite_1_1(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_FLAT_TO_GENTLE_SLOPE_BANKED_TRANSITIONS)
    {
        int32_t ecx = imageDirection / 2;
        int32_t ebx = (imageDirection * vehicleEntry->base_num_frames) + vehicleEntry->flat_to_gentle_bank_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
    else
    {
        vehicle_sprite_1_0(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D46DB
static void vehicle_sprite_1_2(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_FLAT_TO_GENTLE_SLOPE_WHILE_BANKED_TRANSITIONS)
    {
        int32_t ecx = imageDirection / 2;
        int32_t ebx = ((imageDirection / 8) * vehicleEntry->base_num_frames) + vehicleEntry->flat_bank_to_gentle_slope_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
    else
    {
        vehicle_sprite_1_1(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D467D
static void vehicle_sprite_1_3(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_FLAT_TO_GENTLE_SLOPE_BANKED_TRANSITIONS)
    {
        int32_t ecx = imageDirection / 2;
        int32_t ebx = ((imageDirection + 32) * vehicleEntry->base_num_frames) + vehicleEntry->flat_to_gentle_bank_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
    else
    {
        vehicle_sprite_1_0(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D46FD
static void vehicle_sprite_1_4(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_FLAT_TO_GENTLE_SLOPE_WHILE_BANKED_TRANSITIONS)
    {
        int32_t ecx = imageDirection / 2;
        int32_t ebx = (((imageDirection / 8) + 4) * vehicleEntry->base_num_frames)
            + vehicleEntry->flat_bank_to_gentle_slope_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
    else
    {
        vehicle_sprite_1_3(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D460D
static void vehicle_sprite_1(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    // 0x009A3C04:
    switch (vehicle->bank_rotation)
    {
        case 0:
            vehicle_sprite_1_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 1:
            vehicle_sprite_1_1(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 2:
            vehicle_sprite_1_2(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 3:
            vehicle_sprite_1_3(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 4:
            vehicle_sprite_1_4(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 5:
            vehicle_sprite_1_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 6:
            vehicle_sprite_1_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 7:
            vehicle_sprite_1_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 8:
            vehicle_sprite_1_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 9:
            vehicle_sprite_1_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 10:
            vehicle_sprite_1_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 11:
            vehicle_sprite_1_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 12:
            vehicle_sprite_1_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 13:
            vehicle_sprite_1_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 14:
            vehicle_sprite_1_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 15:
            vehicle_sprite_1_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 16:
            vehicle_sprite_1_1(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 17:
            vehicle_sprite_1_2(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 18:
            vehicle_sprite_1_3(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 19:
            vehicle_sprite_1_4(session, vehicle, imageDirection, z, vehicleEntry);
            break;
    }
}

// 6D4791
static void vehicle_sprite_2_0(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_GENTLE_SLOPES)
    {
        if (vehicleEntry->flags & VEHICLE_ENTRY_FLAG_SPINNING_ADDITIONAL_FRAMES)
        {
            int32_t ecx = (imageDirection / 2) + 16;
            int32_t ebx = (((imageDirection / 8) + 8) * vehicleEntry->base_num_frames) + vehicleEntry->gentle_slope_image_id;
            vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
        }
        else
        {
            int32_t ecx = (imageDirection / 2) + 16;
            int32_t ebx = ((imageDirection + 8) * vehicleEntry->base_num_frames) + vehicleEntry->gentle_slope_image_id;
            vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
        }
    }
    else
    {
        vehicle_sprite_0(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D4833
static void vehicle_sprite_2_1(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_GENTLE_SLOPE_BANKED_TRANSITIONS)
    {
        int32_t ecx = (imageDirection / 2) + 16;
        int32_t ebx = ((imageDirection / 8) * vehicleEntry->base_num_frames) + vehicleEntry->gentle_slope_to_bank_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
    else
    {
        vehicle_sprite_2_0(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D48D6
static void vehicle_sprite_2_2(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_GENTLE_SLOPE_BANKED_TURNS)
    {
        int32_t ecx = imageDirection / 2;
        if (vehicleEntry->draw_order < 5)
        {
            ecx += 108;
            int32_t ebx = (imageDirection * vehicleEntry->base_num_frames) + vehicleEntry->gentle_slope_bank_turn_image_id;
            vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
        }
        else
        {
            ecx += 16;
            int32_t ebx = (imageDirection * vehicleEntry->base_num_frames) + vehicleEntry->gentle_slope_bank_turn_image_id;
            vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
        }
    }
    else
    {
        vehicle_sprite_2_0(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D4858
static void vehicle_sprite_2_3(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_GENTLE_SLOPE_BANKED_TRANSITIONS)
    {
        int32_t ecx = (imageDirection / 2) + 16;
        int32_t ebx = (((imageDirection / 8) + 4) * vehicleEntry->base_num_frames)
            + vehicleEntry->gentle_slope_to_bank_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
    else
    {
        vehicle_sprite_2_0(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D4910
static void vehicle_sprite_2_4(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_GENTLE_SLOPE_BANKED_TURNS)
    {
        int32_t ecx = imageDirection / 2;
        if (vehicleEntry->draw_order < 5)
        {
            ecx = (ecx ^ 8) + 108;
            int32_t ebx = ((imageDirection + 32) * vehicleEntry->base_num_frames)
                + vehicleEntry->gentle_slope_bank_turn_image_id;
            vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
        }
        else
        {
            ecx += 16;
            int32_t ebx = ((imageDirection + 32) * vehicleEntry->base_num_frames)
                + vehicleEntry->gentle_slope_bank_turn_image_id;
            vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
        }
    }
    else
    {
        vehicle_sprite_2_0(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D476C
static void vehicle_sprite_2(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    // 0x009A3CA4:
    switch (vehicle->bank_rotation)
    {
        case 0:
            vehicle_sprite_2_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 1:
            vehicle_sprite_2_1(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 2:
            vehicle_sprite_2_2(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 3:
            vehicle_sprite_2_3(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 4:
            vehicle_sprite_2_4(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 5:
            vehicle_sprite_2_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 6:
            vehicle_sprite_2_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 7:
            vehicle_sprite_2_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 8:
            vehicle_sprite_2_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 9:
            vehicle_sprite_2_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 10:
            vehicle_sprite_2_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 11:
            vehicle_sprite_2_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 12:
            vehicle_sprite_2_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 13:
            vehicle_sprite_2_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 14:
            vehicle_sprite_2_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 15:
            vehicle_sprite_2_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 16:
            vehicle_sprite_2_1(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 17:
            vehicle_sprite_2_2(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 18:
            vehicle_sprite_2_3(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 19:
            vehicle_sprite_2_4(session, vehicle, imageDirection, z, vehicleEntry);
            break;
    }
}

// 6D49DC
static void vehicle_sprite_3(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (!(vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_STEEP_SLOPES))
    {
        vehicle_sprite_2(session, vehicle, imageDirection, z, vehicleEntry);
    }
    else
    {
        int32_t ecx = (imageDirection / 4) + 32;
        int32_t ebx = ((imageDirection / 4) * vehicleEntry->base_num_frames) + vehicleEntry->steep_slope_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
}

// 6D4A31
static void vehicle_sprite_4(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (!(vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_STEEP_SLOPES))
    {
        vehicle_sprite_2(session, vehicle, imageDirection, z, vehicleEntry);
    }
    else
    {
        int32_t ecx = (imageDirection / 2) + 40;
        int32_t ebx = ((imageDirection + 16) * vehicleEntry->base_num_frames) + vehicleEntry->steep_slope_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
}

// 6D463D
static void vehicle_sprite_5_0(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_GENTLE_SLOPES)
    {
        int32_t ecx = imageDirection / 2;
        int32_t ebx = (((imageDirection / 8) + 4) * vehicleEntry->base_num_frames) + vehicleEntry->gentle_slope_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
    else
    {
        vehicle_sprite_0(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D469B
static void vehicle_sprite_5_1(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_FLAT_TO_GENTLE_SLOPE_BANKED_TRANSITIONS)
    {
        int32_t ecx = imageDirection / 2;
        int32_t ebx = ((imageDirection + 64) * vehicleEntry->base_num_frames) + vehicleEntry->flat_to_gentle_bank_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
    else
    {
        vehicle_sprite_5_0(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D4722
static void vehicle_sprite_5_2(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_FLAT_TO_GENTLE_SLOPE_WHILE_BANKED_TRANSITIONS)
    {
        int32_t ecx = imageDirection / 2;
        int32_t ebx = (((imageDirection / 8) + 8) * vehicleEntry->base_num_frames)
            + vehicleEntry->flat_bank_to_gentle_slope_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
    else
    {
        vehicle_sprite_5_1(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D46B9
static void vehicle_sprite_5_3(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_FLAT_TO_GENTLE_SLOPE_BANKED_TRANSITIONS)
    {
        int32_t ecx = imageDirection / 2;
        int32_t ebx = ((imageDirection + 96) * vehicleEntry->base_num_frames) + vehicleEntry->flat_to_gentle_bank_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
    else
    {
        vehicle_sprite_5_0(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D4747
static void vehicle_sprite_5_4(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_FLAT_TO_GENTLE_SLOPE_WHILE_BANKED_TRANSITIONS)
    {
        int32_t ecx = imageDirection / 2;
        int32_t ebx = (((imageDirection / 8) + 12) * vehicleEntry->base_num_frames)
            + vehicleEntry->flat_bank_to_gentle_slope_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
    else
    {
        vehicle_sprite_5_3(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D4636
static void vehicle_sprite_5(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    // 0x009A3C54:
    switch (vehicle->bank_rotation)
    {
        case 0:
            vehicle_sprite_5_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 1:
            vehicle_sprite_5_1(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 2:
            vehicle_sprite_5_2(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 3:
            vehicle_sprite_5_3(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 4:
            vehicle_sprite_5_4(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 5:
            vehicle_sprite_5_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 6:
            vehicle_sprite_5_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 7:
            vehicle_sprite_5_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 8:
            vehicle_sprite_5_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 9:
            vehicle_sprite_5_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 10:
            vehicle_sprite_5_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 11:
            vehicle_sprite_5_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 12:
            vehicle_sprite_5_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 13:
            vehicle_sprite_5_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 14:
            vehicle_sprite_5_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 15:
            vehicle_sprite_5_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 16:
            vehicle_sprite_5_1(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 17:
            vehicle_sprite_5_2(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 18:
            vehicle_sprite_5_3(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 19:
            vehicle_sprite_5_4(session, vehicle, imageDirection, z, vehicleEntry);
            break;
    }
}

// 6D47E4
static void vehicle_sprite_6_0(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_GENTLE_SLOPES)
    {
        if (vehicleEntry->flags & VEHICLE_ENTRY_FLAG_SPINNING_ADDITIONAL_FRAMES)
        {
            int32_t ecx = ((imageDirection / 2) ^ 8) + 16;
            int32_t ebx = (((imageDirection / 8) + 12) * vehicleEntry->base_num_frames) + vehicleEntry->gentle_slope_image_id;
            vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
        }
        else
        {
            int32_t ecx = ((imageDirection / 2) ^ 8) + 16;
            int32_t ebx = ((imageDirection + 40) * vehicleEntry->base_num_frames) + vehicleEntry->gentle_slope_image_id;
            vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
        }
    }
    else
    {
        vehicle_sprite_0(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D4880
static void vehicle_sprite_6_1(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_GENTLE_SLOPE_BANKED_TRANSITIONS)
    {
        int32_t ecx = ((imageDirection / 2) ^ 8) + 16;
        int32_t ebx = (((imageDirection / 8) + 8) * vehicleEntry->base_num_frames)
            + vehicleEntry->gentle_slope_to_bank_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
    else
    {
        vehicle_sprite_6_0(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D4953
static void vehicle_sprite_6_2(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_GENTLE_SLOPE_BANKED_TURNS)
    {
        int32_t ecx = imageDirection / 2;
        if (vehicleEntry->draw_order < 5)
        {
            ecx += 108;
            int32_t ebx = ((imageDirection + 64) * vehicleEntry->base_num_frames)
                + vehicleEntry->gentle_slope_bank_turn_image_id;
            vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
        }
        else
        {
            ecx = (ecx ^ 8) + 16;
            int32_t ebx = ((imageDirection + 64) * vehicleEntry->base_num_frames)
                + vehicleEntry->gentle_slope_bank_turn_image_id;
            vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
        }
    }
    else
    {
        vehicle_sprite_6_0(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D48AB
static void vehicle_sprite_6_3(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_GENTLE_SLOPE_BANKED_TRANSITIONS)
    {
        int32_t ecx = ((imageDirection / 2) ^ 8) + 16;
        int32_t ebx = (((imageDirection / 8) + 12) * vehicleEntry->base_num_frames)
            + vehicleEntry->gentle_slope_to_bank_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
    else
    {
        vehicle_sprite_6_0(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D4996
static void vehicle_sprite_6_4(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_GENTLE_SLOPE_BANKED_TURNS)
    {
        int32_t ecx = imageDirection / 2;
        if (vehicleEntry->draw_order < 5)
        {
            ecx = (ecx ^ 8) + 108;
            int32_t ebx = ((imageDirection + 96) * vehicleEntry->base_num_frames)
                + vehicleEntry->gentle_slope_bank_turn_image_id;
            vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
        }
        else
        {
            ecx = (ecx ^ 8) + 16;
            int32_t ebx = ((imageDirection + 96) * vehicleEntry->base_num_frames)
                + vehicleEntry->gentle_slope_bank_turn_image_id;
            vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
        }
    }
    else
    {
        vehicle_sprite_6_0(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D47DD
static void vehicle_sprite_6(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    // 0x009A3CF4:
    switch (vehicle->bank_rotation)
    {
        case 0:
            vehicle_sprite_6_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 1:
            vehicle_sprite_6_1(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 2:
            vehicle_sprite_6_2(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 3:
            vehicle_sprite_6_3(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 4:
            vehicle_sprite_6_4(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 5:
            vehicle_sprite_6_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 6:
            vehicle_sprite_6_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 7:
            vehicle_sprite_6_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 8:
            vehicle_sprite_6_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 9:
            vehicle_sprite_6_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 10:
            vehicle_sprite_6_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 11:
            vehicle_sprite_6_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 12:
            vehicle_sprite_6_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 13:
            vehicle_sprite_6_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 14:
            vehicle_sprite_6_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 15:
            vehicle_sprite_6_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 16:
            vehicle_sprite_6_1(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 17:
            vehicle_sprite_6_2(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 18:
            vehicle_sprite_6_3(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 19:
            vehicle_sprite_6_4(session, vehicle, imageDirection, z, vehicleEntry);
            break;
    }
}

// 6D4A05
static void vehicle_sprite_7(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_STEEP_SLOPES)
    {
        int32_t ecx = ((imageDirection / 4) ^ 4) + 32;
        int32_t ebx = (((imageDirection / 4) + 8) * vehicleEntry->base_num_frames) + vehicleEntry->steep_slope_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
    else
    {
        vehicle_sprite_6(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D4A59
static void vehicle_sprite_8(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_STEEP_SLOPES)
    {
        int32_t ecx = ((imageDirection / 2) ^ 8) + 40;
        int32_t ebx = ((imageDirection + 48) * vehicleEntry->base_num_frames) + vehicleEntry->steep_slope_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
    else
    {
        vehicle_sprite_6(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D4A81
static void vehicle_sprite_9(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_VERTICAL_SLOPES)
    {
        int32_t ecx = (imageDirection / 8) + 56;
        int32_t ebx = ((imageDirection / 8) * vehicleEntry->base_num_frames) + vehicleEntry->vertical_slope_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
    else
    {
        vehicle_sprite_4(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D4AE8
static void vehicle_sprite_10(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_VERTICAL_SLOPES)
    {
        int32_t ecx = (imageDirection / 2) + 60;
        int32_t ebx = ((imageDirection + 8) * vehicleEntry->base_num_frames) + vehicleEntry->vertical_slope_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
    else
    {
        vehicle_sprite_4(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D4B57
static void vehicle_sprite_11(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_VERTICAL_SLOPES)
    {
        int32_t ecx = (imageDirection / 8) + 76;
        int32_t ebx = (((imageDirection / 8) + 72) * vehicleEntry->base_num_frames) + vehicleEntry->vertical_slope_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
    else
    {
        vehicle_sprite_4(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D4BB7
static void vehicle_sprite_12(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_VERTICAL_SLOPES)
    {
        int32_t ecx = (imageDirection / 8) + 80;
        int32_t ebx = (((imageDirection / 8) + 80) * vehicleEntry->base_num_frames) + vehicleEntry->vertical_slope_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
    else
    {
        vehicle_sprite_4(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D4C17
static void vehicle_sprite_13(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_VERTICAL_SLOPES)
    {
        int32_t ecx = (imageDirection / 8) + 84;
        int32_t ebx = (((imageDirection / 8) + 88) * vehicleEntry->base_num_frames) + vehicleEntry->vertical_slope_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
    else
    {
        vehicle_sprite_4(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D4C77
static void vehicle_sprite_14(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_VERTICAL_SLOPES)
    {
        int32_t ecx = (imageDirection / 8) + 88;
        int32_t ebx = (((imageDirection / 8) + 96) * vehicleEntry->base_num_frames) + vehicleEntry->vertical_slope_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
    else
    {
        vehicle_sprite_4(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D4CD7
static void vehicle_sprite_15(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_VERTICAL_SLOPES)
    {
        int32_t ecx = (imageDirection / 8) + 92;
        int32_t ebx = (((imageDirection / 8) + 104) * vehicleEntry->base_num_frames) + vehicleEntry->vertical_slope_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
    else
    {
        vehicle_sprite_4(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D4D37
static void vehicle_sprite_16(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_VERTICAL_SLOPES)
    {
        int32_t ecx = (imageDirection / 8) + 96;
        int32_t ebx = (((imageDirection / 8) + 112) * vehicleEntry->base_num_frames) + vehicleEntry->vertical_slope_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
    else
    {
        vehicle_sprite_4(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D4AA3
static void vehicle_sprite_17(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicle->HasUpdateFlag(VEHICLE_UPDATE_FLAG_USE_INVERTED_SPRITES))
    {
        if (vehicle->GetTrackType() != TrackElemType::Down90ToDown60
            && (vehicle->GetTrackType()) != TrackElemType::Down60ToDown90)
        {
            vehicleEntry--;
        }
    }
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_VERTICAL_SLOPES)
    {
        int32_t ecx = ((imageDirection / 8) ^ 2) + 56;
        int32_t ebx = (((imageDirection / 8) + 4) * vehicleEntry->base_num_frames) + vehicleEntry->vertical_slope_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
    else
    {
        vehicle_sprite_8(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D4B0D
static void vehicle_sprite_18(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicle->HasUpdateFlag(VEHICLE_UPDATE_FLAG_USE_INVERTED_SPRITES))
    {
        if (vehicle->GetTrackType() != TrackElemType::Down90 && (vehicle->GetTrackType()) != TrackElemType::Down90ToDown60
            && (vehicle->GetTrackType()) != TrackElemType::Down60ToDown90)
        {
            vehicleEntry--;
        }
    }
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_VERTICAL_SLOPES)
    {
        int32_t ecx = ((imageDirection / 2) ^ 8) + 60;
        int32_t ebx = ((imageDirection + 40) * vehicleEntry->base_num_frames) + vehicleEntry->vertical_slope_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
    else
    {
        vehicle_sprite_8(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D4B80
static void vehicle_sprite_19(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicle->HasUpdateFlag(VEHICLE_UPDATE_FLAG_USE_INVERTED_SPRITES))
    {
        vehicleEntry--;
    }
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_VERTICAL_SLOPES)
    {
        int32_t ecx = ((imageDirection / 8) ^ 2) + 76;
        int32_t ebx = (((imageDirection / 8) + 76) * vehicleEntry->base_num_frames) + vehicleEntry->vertical_slope_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
    else
    {
        vehicle_sprite_8(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D4BE0
static void vehicle_sprite_20(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicle->HasUpdateFlag(VEHICLE_UPDATE_FLAG_USE_INVERTED_SPRITES))
    {
        vehicleEntry--;
    }
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_VERTICAL_SLOPES)
    {
        int32_t ecx = ((imageDirection / 8) ^ 2) + 80;
        int32_t ebx = (((imageDirection / 8) + 84) * vehicleEntry->base_num_frames) + vehicleEntry->vertical_slope_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
    else
    {
        vehicle_sprite_8(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D4C40
static void vehicle_sprite_21(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicle->HasUpdateFlag(VEHICLE_UPDATE_FLAG_USE_INVERTED_SPRITES))
    {
        vehicleEntry--;
    }
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_VERTICAL_SLOPES)
    {
        int32_t ecx = ((imageDirection / 8) ^ 2) + 84;
        int32_t ebx = (((imageDirection / 8) + 92) * vehicleEntry->base_num_frames) + vehicleEntry->vertical_slope_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
    else
    {
        vehicle_sprite_8(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D4CA0
static void vehicle_sprite_22(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicle->HasUpdateFlag(VEHICLE_UPDATE_FLAG_USE_INVERTED_SPRITES))
    {
        vehicleEntry--;
    }
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_VERTICAL_SLOPES)
    {
        int32_t ecx = ((imageDirection / 8) ^ 2) + 88;
        int32_t ebx = (((imageDirection / 8) + 100) * vehicleEntry->base_num_frames) + vehicleEntry->vertical_slope_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
    else
    {
        vehicle_sprite_8(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D4D00
static void vehicle_sprite_23(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicle->HasUpdateFlag(VEHICLE_UPDATE_FLAG_USE_INVERTED_SPRITES))
    {
        vehicleEntry--;
    }
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_VERTICAL_SLOPES)
    {
        int32_t ecx = ((imageDirection / 8) ^ 2) + 92;
        int32_t ebx = (((imageDirection / 8) + 108) * vehicleEntry->base_num_frames) + vehicleEntry->vertical_slope_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
    else
    {
        vehicle_sprite_8(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D51A5
static void vehicle_sprite_24(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicle->HasUpdateFlag(VEHICLE_UPDATE_FLAG_USE_INVERTED_SPRITES))
    {
        vehicleEntry--;
    }
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_CORKSCREWS)
    {
        int32_t eax = ((vehicle->vehicle_sprite_type - 24) * 4);
        int32_t ecx = (imageDirection / 8) + eax + 144;
        int32_t ebx = (((imageDirection / 8) + eax) * vehicleEntry->base_num_frames) + vehicleEntry->corkscrew_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
    else
    {
        vehicle_sprite_paint_6D51DE(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D4D67
static void vehicle_sprite_50_0(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_DIAGONAL_SLOPES)
    {
        int32_t ecx = imageDirection / 2;
        int32_t ebx = ((imageDirection / 8) * vehicleEntry->base_num_frames) + vehicleEntry->diagonal_slope_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
    else
    {
        vehicle_sprite_0(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D4DB5
static void vehicle_sprite_50_1(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_DIAGONAL_GENTLE_SLOPE_BANKED_TRANSITIONS)
    {
        int32_t ecx = imageDirection / 2;
        int32_t ebx = ((imageDirection / 8) * vehicleEntry->base_num_frames)
            + vehicleEntry->diagonal_to_gentle_slope_bank_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
    else
    {
        vehicle_sprite_50_0(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D4DD3
static void vehicle_sprite_50_3(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_DIAGONAL_GENTLE_SLOPE_BANKED_TRANSITIONS)
    {
        int32_t ecx = imageDirection / 2;
        int32_t ebx = (((imageDirection / 8) + 4) * vehicleEntry->base_num_frames)
            + vehicleEntry->diagonal_to_gentle_slope_bank_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
    else
    {
        vehicle_sprite_50_0(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D4D60
static void vehicle_sprite_50(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    // 0x009A3D44:
    switch (vehicle->bank_rotation)
    {
        case 0:
            vehicle_sprite_50_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 1:
            vehicle_sprite_50_1(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 2:
            vehicle_sprite_50_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 3:
            vehicle_sprite_50_3(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 4:
            vehicle_sprite_50_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 5:
            vehicle_sprite_50_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 6:
            vehicle_sprite_50_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 7:
            vehicle_sprite_50_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 8:
            vehicle_sprite_50_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 9:
            vehicle_sprite_50_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 10:
            vehicle_sprite_50_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 11:
            vehicle_sprite_50_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 12:
            vehicle_sprite_50_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 13:
            vehicle_sprite_50_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 14:
            vehicle_sprite_50_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 15:
            vehicle_sprite_50_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 16:
            vehicle_sprite_50_1(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 17:
            vehicle_sprite_50_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 18:
            vehicle_sprite_50_3(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 19:
            vehicle_sprite_50_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
    }
}

// 6D4E3A
static void vehicle_sprite_51(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_DIAGONAL_SLOPES)
    {
        int32_t ecx = (imageDirection / 8) + 100;
        int32_t ebx = (((imageDirection / 8) + 8) * vehicleEntry->base_num_frames) + vehicleEntry->diagonal_slope_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
    else
    {
        vehicle_sprite_0(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D4E8F
static void vehicle_sprite_52(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_DIAGONAL_SLOPES)
    {
        int32_t ecx = (imageDirection / 8) + 104;
        int32_t ebx = (((imageDirection / 8) + 16) * vehicleEntry->base_num_frames) + vehicleEntry->diagonal_slope_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
    else
    {
        vehicle_sprite_0(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D4D90
static void vehicle_sprite_53_0(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_DIAGONAL_SLOPES)
    {
        int32_t ecx = imageDirection / 2;
        int32_t ebx = (((imageDirection / 8) + 4) * vehicleEntry->base_num_frames) + vehicleEntry->diagonal_slope_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
    else
    {
        vehicle_sprite_0(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D4DF4
static void vehicle_sprite_53_1(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_DIAGONAL_GENTLE_SLOPE_BANKED_TRANSITIONS)
    {
        int32_t ecx = imageDirection / 2;
        int32_t ebx = (((imageDirection / 8) + 8) * vehicleEntry->base_num_frames)
            + vehicleEntry->diagonal_to_gentle_slope_bank_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
    else
    {
        vehicle_sprite_53_0(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D4E15
static void vehicle_sprite_53_3(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_DIAGONAL_GENTLE_SLOPE_BANKED_TRANSITIONS)
    {
        int32_t ecx = imageDirection / 2;
        int32_t ebx = (((imageDirection / 8) + 12) * vehicleEntry->base_num_frames)
            + vehicleEntry->diagonal_to_gentle_slope_bank_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
    else
    {
        vehicle_sprite_53_0(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D4D89
static void vehicle_sprite_53(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    // 0x009A3D94:
    switch (vehicle->bank_rotation)
    {
        case 0:
            vehicle_sprite_53_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 1:
            vehicle_sprite_53_1(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 2:
            vehicle_sprite_53_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 3:
            vehicle_sprite_53_3(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 4:
            vehicle_sprite_53_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 5:
            vehicle_sprite_53_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 6:
            vehicle_sprite_53_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 7:
            vehicle_sprite_53_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 8:
            vehicle_sprite_53_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 9:
            vehicle_sprite_53_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 10:
            vehicle_sprite_53_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 11:
            vehicle_sprite_53_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 12:
            vehicle_sprite_53_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 13:
            vehicle_sprite_53_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 14:
            vehicle_sprite_53_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 15:
            vehicle_sprite_53_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 16:
            vehicle_sprite_53_1(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 17:
            vehicle_sprite_53_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 18:
            vehicle_sprite_53_3(session, vehicle, imageDirection, z, vehicleEntry);
            break;
        case 19:
            vehicle_sprite_53_0(session, vehicle, imageDirection, z, vehicleEntry);
            break;
    }
}

// 6D4E63
static void vehicle_sprite_54(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_DIAGONAL_SLOPES)
    {
        int32_t ecx = ((imageDirection / 8) ^ 2) + 100;
        int32_t ebx = (((imageDirection / 8) + 12) * vehicleEntry->base_num_frames) + vehicleEntry->diagonal_slope_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
    else
    {
        vehicle_sprite_0(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D4EB8
static void vehicle_sprite_55(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_DIAGONAL_SLOPES)
    {
        int32_t ecx = ((imageDirection / 8) ^ 2) + 104;
        int32_t ebx = (((imageDirection / 8) + 20) * vehicleEntry->base_num_frames) + vehicleEntry->diagonal_slope_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
    else
    {
        vehicle_sprite_0(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D47DA
static void vehicle_sprite_56(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    vehicleEntry--;
    vehicle_sprite_6(session, vehicle, imageDirection, z, vehicleEntry);
}

// 6D4A02
static void vehicle_sprite_57(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    vehicleEntry--;
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_STEEP_SLOPES)
    {
        int32_t ecx = ((imageDirection / 4) ^ 4) + 32;
        int32_t ebx = (((imageDirection / 4) + 8) * vehicleEntry->base_num_frames) + vehicleEntry->steep_slope_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
    else
    {
        vehicle_sprite_6(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D4A56
static void vehicle_sprite_58(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    vehicleEntry--;
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_STEEP_SLOPES)
    {
        int32_t ecx = ((imageDirection / 2) ^ 8) + 40;
        int32_t ebx = ((imageDirection + 48) * vehicleEntry->base_num_frames) + vehicleEntry->steep_slope_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
    else
    {
        vehicle_sprite_6(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 6D4773
static void vehicle_sprite_59(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicleEntry->sprite_flags & VEHICLE_SPRITE_FLAG_CURVED_LIFT_HILL)
    {
        int32_t ecx = (imageDirection / 2) + 16;
        int32_t ebx = (imageDirection * vehicleEntry->base_num_frames) + vehicleEntry->curved_lift_hill_image_id;
        vehicle_sprite_paint_6D520E(session, vehicle, ebx, ecx, z, vehicleEntry);
    }
    else
    {
        vehicle_sprite_2(session, vehicle, imageDirection, z, vehicleEntry);
    }
}

// 0x009A3B14:
using vehicle_sprite_func = void (*)(
    paint_session* session, const Vehicle* vehicle, int32_t imageDirection, int32_t z,
    const rct_ride_entry_vehicle* vehicleEntry);

// clang-format off
static constexpr const vehicle_sprite_func vehicle_sprite_funcs[] = {
    vehicle_sprite_0,
    vehicle_sprite_1,
    vehicle_sprite_2,
    vehicle_sprite_3,
    vehicle_sprite_4,
    vehicle_sprite_5,
    vehicle_sprite_6,
    vehicle_sprite_7,
    vehicle_sprite_8,
    vehicle_sprite_9,
    vehicle_sprite_10,
    vehicle_sprite_11,
    vehicle_sprite_12,
    vehicle_sprite_13,
    vehicle_sprite_14,
    vehicle_sprite_15,
    vehicle_sprite_16,
    vehicle_sprite_17,
    vehicle_sprite_18,
    vehicle_sprite_19,
    vehicle_sprite_20,
    vehicle_sprite_21,
    vehicle_sprite_22,
    vehicle_sprite_23,
    vehicle_sprite_24,
    vehicle_sprite_24,
    vehicle_sprite_24,
    vehicle_sprite_24,
    vehicle_sprite_24,
    vehicle_sprite_24,
    vehicle_sprite_24,
    vehicle_sprite_24,
    vehicle_sprite_24,
    vehicle_sprite_24,
    vehicle_sprite_24,
    vehicle_sprite_24,
    vehicle_sprite_24,
    vehicle_sprite_24,
    vehicle_sprite_24,
    vehicle_sprite_24,
    vehicle_sprite_24,
    vehicle_sprite_24,
    vehicle_sprite_24,
    vehicle_sprite_24,
    vehicle_sprite_0,
    vehicle_sprite_0,
    vehicle_sprite_0,
    vehicle_sprite_0,
    vehicle_sprite_0,
    vehicle_sprite_0,
    vehicle_sprite_50,
    vehicle_sprite_51,
    vehicle_sprite_52,
    vehicle_sprite_53,
    vehicle_sprite_54,
    vehicle_sprite_55,
    vehicle_sprite_56,
    vehicle_sprite_57,
    vehicle_sprite_58,
    vehicle_sprite_59,
};
// clang-format on

/**
 *
 *  rct2: 0x006D5600
 */
static void vehicle_visual_splash1_effect(paint_session* session, int32_t z, const Vehicle* vehicle)
{
    if (vehicle->GetTrackType() != TrackElemType::Watersplash)
    {
        return;
    }
    if (vehicle->track_progress < 48)
    {
        return;
    }
    if (vehicle->track_progress >= 112)
    {
        return;
    }
    if (vehicle->TrainHead()->velocity <= 0x50000)
    {
        return;
    }
    int32_t image_id = 29014 + ((((vehicle->sprite_direction / 8) + session->CurrentRotation) & 3) * 8)
        + ((gCurrentTicks / 2) & 7);
    PaintAddImageAsChild(session, image_id, 0, 0, 0, 0, 0, z, 0, 0, z);
}

/**
 *
 *  rct2: 0x006D5696
 */
static void vehicle_visual_splash2_effect(paint_session* session, int32_t z, const Vehicle* vehicle)
{
    if (vehicle->sprite_direction & 7)
    {
        return;
    }
    if (vehicle->vehicle_sprite_type != 0)
    {
        return;
    }
    if (vehicle->velocity <= 0x50000)
    {
        return;
    }
    int32_t image_id = 29046 + ((((vehicle->sprite_direction / 8) + session->CurrentRotation) & 3) * 8)
        + ((gCurrentTicks / 2) & 7);
    PaintAddImageAsChild(session, image_id, 0, 0, 0, 0, 0, z, 0, 0, z);
}

/**
 *
 *  rct2: 0x006D57EE
 */
static void vehicle_visual_splash3_effect(paint_session* session, int32_t z, const Vehicle* vehicle)
{
    if (vehicle->sprite_direction & 7)
    {
        return;
    }
    if (vehicle->vehicle_sprite_type != 0)
    {
        return;
    }
    if (vehicle->velocity <= 0x50000)
    {
        return;
    }
    int32_t image_id = 29014 + ((((vehicle->sprite_direction / 8) + session->CurrentRotation) & 3) * 8)
        + ((gCurrentTicks / 2) & 7);
    PaintAddImageAsChild(session, image_id, 0, 0, 0, 0, 0, z, 0, 0, z);
}

/**
 *
 *  rct2: 0x006D5783
 */
static void vehicle_visual_splash4_effect(paint_session* session, int32_t z, const Vehicle* vehicle)
{
    Vehicle* vehicle2 = GetEntity<Vehicle>(vehicle->prev_vehicle_on_ride);
    if (vehicle2 == nullptr)
    {
        return;
    }
    if (vehicle2->velocity <= 0x50000)
    {
        return;
    }
    if (vehicle->sprite_direction & 7)
    {
        return;
    }
    if (vehicle->vehicle_sprite_type != 0)
    {
        return;
    }
    int32_t image_id = 29078 + ((((vehicle->sprite_direction / 8) + session->CurrentRotation) & 3) * 8)
        + ((gCurrentTicks / 2) & 7);
    PaintAddImageAsChild(session, image_id, 0, 0, 1, 1, 0, z, 0, 0, z);
}

/**
 *
 *  rct2: 0x006D5701
 */
static void vehicle_visual_splash5_effect(paint_session* session, int32_t z, const Vehicle* vehicle)
{
    Vehicle* vehicle2 = GetEntity<Vehicle>(vehicle->prev_vehicle_on_ride);
    if (vehicle2 == nullptr)
    {
        return;
    }
    if (vehicle2->velocity <= 0x50000)
    {
        return;
    }
    if (vehicle->sprite_direction & 7)
    {
        return;
    }
    if (vehicle->vehicle_sprite_type != 0)
    {
        return;
    }
    if (!track_element_is_covered(vehicle->GetTrackType()))
    {
        return;
    }
    int32_t image_id = 29078 + ((((vehicle->sprite_direction / 8) + session->CurrentRotation) & 3) * 8)
        + ((gCurrentTicks / 2) & 7);
    PaintAddImageAsChild(session, image_id, 0, 0, 1, 1, 0, z, 0, 0, z);
}

void vehicle_visual_splash_effect(
    paint_session* session, int32_t z, const Vehicle* vehicle, const rct_ride_entry_vehicle* vehicleEntry)
{
    switch (vehicleEntry->effect_visual)
    {
        case VEHICLE_VISUAL_SPLASH1_EFFECT:
            vehicle_visual_splash1_effect(session, z, vehicle);
            break;
        case VEHICLE_VISUAL_SPLASH2_EFFECT:
            vehicle_visual_splash2_effect(session, z, vehicle);
            break;
        case VEHICLE_VISUAL_SPLASH3_EFFECT:
            vehicle_visual_splash3_effect(session, z, vehicle);
            break;
        case VEHICLE_VISUAL_SPLASH4_EFFECT:
            vehicle_visual_splash4_effect(session, z, vehicle);
            break;
        case VEHICLE_VISUAL_SPLASH5_EFFECT:
            vehicle_visual_splash5_effect(session, z, vehicle);
            break;
    }
}

/**
 *
 *  rct2: 0x006D45F8
 */
void vehicle_visual_default(
    paint_session* session, int32_t imageDirection, int32_t z, const Vehicle* vehicle,
    const rct_ride_entry_vehicle* vehicleEntry)
{
    if (vehicle->vehicle_sprite_type < std::size(vehicle_sprite_funcs))
    {
        vehicle_sprite_funcs[vehicle->vehicle_sprite_type](session, vehicle, imageDirection, z, vehicleEntry);
    }
}

/**
 *
 *  rct2: 0x006D4244
 */
void vehicle_paint(paint_session* session, const Vehicle* vehicle, int32_t imageDirection)
{
    const rct_ride_entry_vehicle* vehicleEntry;

    int32_t x = vehicle->x;
    int32_t y = vehicle->y;
    int32_t z = vehicle->z;

    if (vehicle->flags & SPRITE_FLAGS_IS_CRASHED_VEHICLE_SPRITE)
    {
        uint32_t ebx = 22965 + vehicle->animation_frame;
        PaintAddImageAsParent(session, ebx, 0, 0, 1, 1, 0, z, 0, 0, z + 2);
        return;
    }

    if (vehicle->ride_subtype == RIDE_ENTRY_INDEX_NULL)
    {
        vehicleEntry = &CableLiftVehicle;
    }
    else
    {
        auto rideEntry = vehicle->GetRideEntry();
        if (rideEntry == nullptr)
        {
            return;
        }

        auto vehicleEntryIndex = vehicle->vehicle_type;
        if (vehicle->HasUpdateFlag(VEHICLE_UPDATE_FLAG_USE_INVERTED_SPRITES))
        {
            vehicleEntryIndex++;
            z += 16;
        }

        if (vehicleEntryIndex >= std::size(rideEntry->vehicles))
        {
            return;
        }
        vehicleEntry = &rideEntry->vehicles[vehicleEntryIndex];
    }

    switch (vehicleEntry->car_visual)
    {
        case VEHICLE_VISUAL_DEFAULT:
            vehicle_visual_default(session, imageDirection, z, vehicle, vehicleEntry);
            break;
        case VEHICLE_VISUAL_LAUNCHED_FREEFALL:
            vehicle_visual_launched_freefall(session, x, imageDirection, y, z, vehicle, vehicleEntry);
            break;
        case VEHICLE_VISUAL_OBSERVATION_TOWER:
            vehicle_visual_observation_tower(session, x, imageDirection, y, z, vehicle, vehicleEntry);
            break;
        case VEHICLE_VISUAL_RIVER_RAPIDS:
            vehicle_visual_river_rapids(session, x, imageDirection, y, z, vehicle, vehicleEntry);
            break;
        case VEHICLE_VISUAL_MINI_GOLF_PLAYER:
            vehicle_visual_mini_golf_player(session, x, imageDirection, y, z, vehicle);
            break;
        case VEHICLE_VISUAL_MINI_GOLF_BALL:
            vehicle_visual_mini_golf_ball(session, x, imageDirection, y, z, vehicle);
            break;
        case VEHICLE_VISUAL_REVERSER:
            vehicle_visual_reverser(session, x, imageDirection, y, z, vehicle, vehicleEntry);
            break;
        case VEHICLE_VISUAL_SPLASH_BOATS_OR_WATER_COASTER:
            vehicle_visual_splash_boats_or_water_coaster(session, x, imageDirection, y, z, vehicle, vehicleEntry);
            break;
        case VEHICLE_VISUAL_ROTO_DROP:
            vehicle_visual_roto_drop(session, x, imageDirection, y, z, vehicle, vehicleEntry);
            break;
        case VEHICLE_VISUAL_VIRGINIA_REEL:
            vehicle_visual_virginia_reel(session, x, imageDirection, y, z, vehicle, vehicleEntry);
            break;
        case VEHICLE_VISUAL_SUBMARINE:
            vehicle_visual_submarine(session, x, imageDirection, y, z, vehicle, vehicleEntry);
            break;
    }
}
