/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.utils.plugins.impl;

import com.ibm.java.diagnostics.utils.plugins.Annotation;
import com.ibm.java.diagnostics.utils.plugins.ClassInfo;
import com.ibm.java.diagnostics.utils.plugins.ClassListener;
import java.net.URL;
import java.util.Set;
import jdk.internal.org.objectweb.asm.AnnotationVisitor;
import jdk.internal.org.objectweb.asm.Attribute;
import jdk.internal.org.objectweb.asm.ClassVisitor;
import jdk.internal.org.objectweb.asm.FieldVisitor;
import jdk.internal.org.objectweb.asm.MethodVisitor;

public class ClassScanner
extends ClassVisitor {
    private ClassInfo info;
    private Annotation currentAnnotation = null;
    private final URL url;
    private final Set<ClassListener> listeners;

    public ClassScanner(URL uRL, Set<ClassListener> set) {
        super(262144, null);
        this.url = uRL;
        this.listeners = set;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String string, boolean bl) {
        this.currentAnnotation = this.info.addAnnotation(string);
        for (ClassListener classListener : this.listeners) {
            classListener.visitAnnotation(string, bl);
        }
        return new ClassScannerAnnotation(262144);
    }

    @Override
    public void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
        String string4 = string.replace('/', '.');
        String string5 = string3.replace('/', '.');
        this.info = new ClassInfo(string4, this.url);
        for (String string6 : stringArray) {
            this.info.addInterface(string6);
        }
        for (ClassListener classListener : this.listeners) {
            classListener.visit(n, n2, string4, string2, string5, stringArray);
        }
    }

    @Override
    public void visitAttribute(Attribute attribute) {
    }

    @Override
    public void visitEnd() {
    }

    @Override
    public FieldVisitor visitField(int n, String string, String string2, String string3, Object object) {
        return null;
    }

    @Override
    public void visitInnerClass(String string, String string2, String string3, int n) {
    }

    @Override
    public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
        return null;
    }

    @Override
    public void visitOuterClass(String string, String string2, String string3) {
    }

    @Override
    public void visitSource(String string, String string2) {
    }

    public ClassInfo getClassInfo() {
        return this.info;
    }

    class ClassScannerAnnotation
    extends AnnotationVisitor {
        public ClassScannerAnnotation(int n) {
            super(n);
        }

        @Override
        public AnnotationVisitor visitAnnotation(String string, String string2) {
            return null;
        }

        @Override
        public AnnotationVisitor visitArray(String string) {
            return null;
        }

        @Override
        public void visitEnum(String string, String string2, String string3) {
        }

        @Override
        public void visit(String string, Object object) {
            ClassScanner.this.currentAnnotation.addEntry(string, object);
            for (ClassListener classListener : ClassScanner.this.listeners) {
                classListener.visitAnnotationValue(string, object);
            }
        }
    }
}

