/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.utils.commands;

import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.BaseCommand;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.java.diagnostics.utils.plugins.PluginConfig;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class PluginCommand
extends BaseCommand {
    private static final String COMMAND_NAME = "plugins";
    private static final String SUBCOMMAND_LIST = "list";
    private static final String SUBCOMMAND_RELOAD = "reload";
    private static final String SUBCOMMAND_SHOWPATH = "showpath";
    private static final String SUBCOMMAND_SETPATH = "setpath";
    private final Map<String, Method> commands = new HashMap<String, Method>();

    public PluginCommand() {
        try {
            this.commands.put(SUBCOMMAND_LIST, this.getClass().getDeclaredMethod("commandListPlugins", String[].class, IContext.class, PrintStream.class));
            this.commands.put(SUBCOMMAND_RELOAD, this.getClass().getDeclaredMethod("commandReload", String[].class, IContext.class, PrintStream.class));
            this.commands.put(SUBCOMMAND_SHOWPATH, this.getClass().getDeclaredMethod("commandShowPath", String[].class, IContext.class, PrintStream.class));
            this.commands.put(SUBCOMMAND_SETPATH, this.getClass().getDeclaredMethod("commandSetPath", String[].class, IContext.class, PrintStream.class));
        }
        catch (Exception exception) {
            System.err.println("Error creating command list : " + exception.getMessage());
        }
        this.addCommand(COMMAND_NAME, "", "Plugin management commands");
        this.addSubCommand(COMMAND_NAME, SUBCOMMAND_LIST, "", "Show the list of loaded plugins for the current context");
        this.addSubCommand(COMMAND_NAME, SUBCOMMAND_RELOAD, "", "Reload plugins for the current context");
        this.addSubCommand(COMMAND_NAME, SUBCOMMAND_SHOWPATH, "", "Show the DTFJ View plugin search path for the current context");
        this.addSubCommand(COMMAND_NAME, SUBCOMMAND_SETPATH, "", "Set the DTFJ View plugin search path for the current context");
    }

    @Override
    public void run(String string, String[] stringArray, IContext iContext, PrintStream printStream) throws CommandException {
        if (stringArray.length == 0) {
            printStream.println("Error, all plugin commands require one or more parameters");
            return;
        }
        if (stringArray[0].equalsIgnoreCase("help") || stringArray[0].equalsIgnoreCase("?")) {
            printStream.println("The 'plugins' command can show or set the DTFJ View plugin search path, list the currently loaded plugins and reload them.");
            return;
        }
        if (this.commands.containsKey(stringArray[0])) {
            try {
                this.commands.get(stringArray[0]).invoke((Object)this, stringArray, iContext, printStream);
            }
            catch (Exception exception) {
                printStream.println("Error executing command " + exception.getMessage());
            }
        } else {
            printStream.println("plugins " + string + " was not recognised, run " + COMMAND_NAME + " " + SUBCOMMAND_LIST + " to see all available options");
        }
    }

    private void commandListPlugins(String[] stringArray, IContext iContext, PrintStream printStream) throws CommandException {
        boolean bl = false;
        if (stringArray.length >= 2) {
            bl = stringArray[1].equalsIgnoreCase("csv");
            printStream.println("id,vmversion,enabled,path,modified,exception");
        }
        if (iContext.getPluginClassloader() == null) {
            printStream.println("No plugins are currently loaded");
            return;
        }
        ArrayList<PluginConfig> arrayList = iContext.getPluginClassloader().getPlugins();
        ArrayList<PluginConfig> arrayList2 = iContext.getPluginClassloader().getPluginFailures();
        if (arrayList.size() == 0 && arrayList2.size() == 0 && !bl) {
            printStream.println("No plugins are currently loaded");
            return;
        }
        this.printPlugins("Loaded plugins", arrayList, printStream, bl);
        this.printPlugins("Failed plugins", arrayList2, printStream, bl);
    }

    private void printPlugins(String string, ArrayList<PluginConfig> arrayList, PrintStream printStream, boolean bl) {
        if (!bl) {
            printStream.println(string);
        }
        if (arrayList.size() == 0 && !bl) {
            printStream.println("\t<none>");
            return;
        }
        for (PluginConfig pluginConfig : arrayList) {
            if (bl) {
                printStream.println(pluginConfig.toCSV());
                continue;
            }
            printStream.println("\t" + pluginConfig.getId());
        }
    }

    private void commandShowPath(String[] stringArray, IContext iContext, PrintStream printStream) {
        String string = System.getProperty("com.ibm.java.diagnostics.plugins");
        string = null == string ? "<<warning : no dtfj plugin path has been defined>>" : string + String.format(" (set from system property %s)", "com.ibm.java.diagnostics.plugins");
        printStream.println("DTFJ View Plugin search path : " + string);
    }

    private void commandSetPath(String[] stringArray, IContext iContext, PrintStream printStream) {
        if (stringArray.length != 2) {
            printStream.println("The setpath option only takes a single parameter of the search path");
            return;
        }
        System.getProperties().setProperty("com.ibm.java.diagnostics.plugins", stringArray[1]);
        printStream.println("DTFJ View Plugin search path set to : " + stringArray[1]);
        printStream.println("Execute plugins reload to scan this path for plugins");
    }

    private void commandReload(String[] stringArray, IContext iContext, PrintStream printStream) {
        iContext.refresh();
        printStream.println("Plugins reloaded");
    }
}

