/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.phd;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.image.ImageThread;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaStackFrame;
import com.ibm.dtfj.java.JavaThread;
import com.ibm.dtfj.phd.PHDCorruptData;
import com.ibm.dtfj.phd.PHDCorruptJavaStackFrame;
import com.ibm.dtfj.phd.PHDImageProcess;
import com.ibm.dtfj.phd.PHDJavaRuntime;
import com.ibm.dtfj.phd.PHDJavaStackFrame;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class PHDJavaThread
implements JavaThread {
    private ImagePointer env;
    private CorruptData env_cd;
    private String name;
    private CorruptData name_cd;
    private int priority;
    private CorruptData priority_cd;
    private int state;
    private CorruptData state_cd;
    private List<JavaStackFrame> frames = new ArrayList<JavaStackFrame>();
    private JavaObject object;
    private CorruptData object_cd;
    private ImageThread imageThread;
    private CorruptData imageThread_cd;

    PHDJavaThread(ImageAddressSpace imageAddressSpace, PHDImageProcess pHDImageProcess, PHDJavaRuntime pHDJavaRuntime, JavaThread javaThread) {
        try {
            this.env = imageAddressSpace.getPointer(javaThread.getJNIEnv().getAddress());
        }
        catch (CorruptDataException corruptDataException) {
            this.env_cd = new PHDCorruptData(imageAddressSpace, corruptDataException);
        }
        try {
            this.name = javaThread.getName();
        }
        catch (CorruptDataException corruptDataException) {
            this.name_cd = new PHDCorruptData(imageAddressSpace, corruptDataException);
        }
        try {
            this.priority = javaThread.getPriority();
        }
        catch (CorruptDataException corruptDataException) {
            this.priority_cd = new PHDCorruptData(imageAddressSpace, corruptDataException);
        }
        try {
            this.state = javaThread.getState();
        }
        catch (CorruptDataException corruptDataException) {
            this.state_cd = new PHDCorruptData(imageAddressSpace, corruptDataException);
        }
        Object object = javaThread.getStackFrames();
        while (object.hasNext()) {
            Object e = object.next();
            if (e instanceof CorruptData) {
                this.frames.add(new PHDCorruptJavaStackFrame(imageAddressSpace, (CorruptData)e));
                continue;
            }
            this.frames.add(new PHDJavaStackFrame(imageAddressSpace, pHDJavaRuntime, (JavaStackFrame)e));
        }
        try {
            object = javaThread.getObject();
            if (object != null) {
                try {
                    this.object = pHDJavaRuntime.getObjectAtAddress(imageAddressSpace.getPointer(object.getID().getAddress()));
                }
                catch (CorruptDataException corruptDataException) {
                    this.object_cd = corruptDataException.getCorruptData();
                }
                catch (DataUnavailable dataUnavailable) {
                }
                catch (MemoryAccessException memoryAccessException) {}
            }
        }
        catch (CorruptDataException corruptDataException) {
            this.object_cd = new PHDCorruptData(imageAddressSpace, corruptDataException);
        }
        try {
            object = javaThread.getImageThread();
            this.imageThread = pHDImageProcess.getThread(imageAddressSpace, (ImageThread)object);
        }
        catch (DataUnavailable dataUnavailable) {
        }
        catch (CorruptDataException corruptDataException) {
            this.imageThread_cd = new PHDCorruptData(imageAddressSpace, corruptDataException);
        }
    }

    @Override
    public ImageThread getImageThread() throws CorruptDataException, DataUnavailable {
        if (this.imageThread_cd != null) {
            throw new CorruptDataException(this.imageThread_cd);
        }
        if (this.imageThread == null) {
            throw new DataUnavailable();
        }
        return this.imageThread;
    }

    @Override
    public ImagePointer getJNIEnv() throws CorruptDataException {
        this.checkCD(this.env_cd);
        return this.env;
    }

    @Override
    public String getName() throws CorruptDataException {
        this.checkCD(this.name_cd);
        return this.name;
    }

    @Override
    public JavaObject getObject() throws CorruptDataException {
        this.checkCD(this.object_cd);
        return this.object;
    }

    @Override
    public int getPriority() throws CorruptDataException {
        this.checkCD(this.priority_cd);
        return this.priority;
    }

    @Override
    public Iterator<JavaStackFrame> getStackFrames() {
        return this.frames.iterator();
    }

    @Override
    public Iterator<ImageSection> getStackSections() {
        return Collections.emptyList().iterator();
    }

    @Override
    public int getState() throws CorruptDataException {
        this.checkCD(this.state_cd);
        return this.state;
    }

    private void checkCD(CorruptData corruptData) throws CorruptDataException {
        if (corruptData != null) {
            throw new CorruptDataException(corruptData);
        }
    }

    @Override
    public JavaObject getBlockingObject() throws CorruptDataException, DataUnavailable {
        throw new DataUnavailable("Not Available.");
    }
}

