/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.phd;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaClassLoader;
import com.ibm.dtfj.java.JavaField;
import com.ibm.dtfj.java.JavaMethod;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaReference;
import com.ibm.dtfj.phd.PHDCorruptData;
import com.ibm.dtfj.phd.PHDCorruptJavaClass;
import com.ibm.dtfj.phd.PHDJavaHeap;
import com.ibm.dtfj.phd.PHDJavaMethod;
import com.ibm.dtfj.phd.PHDJavaObject;
import com.ibm.dtfj.phd.PHDJavaReference;
import com.ibm.dtfj.phd.PHDJavaRuntime;
import com.ibm.dtfj.phd.util.LongEnumeration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

class PHDJavaClass
implements JavaClass {
    private JavaClassLoader loader;
    private String name;
    private final long addr;
    private final long superAddress;
    private final ImageAddressSpace space;
    private final PHDJavaRuntime runtime;
    private Object refs;
    private final int flags;
    private final int hashCode;
    private int size;
    private JavaClass componentType;
    private List<JavaMethod> methods = new ArrayList<JavaMethod>();
    private JavaObject classObject;
    private static final int UNKNOWN_SIZE = Integer.MIN_VALUE;
    static final int UNKNOWN_SUPERCLASS = -1;
    static final String UNKNOWN_ARRAY = "[";
    static final String UNKNOWN_NONARRAY = "]";

    public PHDJavaClass(Builder builder) {
        this.space = builder.space;
        this.runtime = builder.runtime;
        this.loader = builder.loader;
        this.addr = builder.addr;
        this.superAddress = builder.superAddress;
        this.name = builder.name;
        this.size = builder.size;
        this.flags = builder.flags;
        this.hashCode = builder.hashCode;
        this.refs = builder.refs;
        this.componentType = builder.componentType;
    }

    @Override
    public JavaClassLoader getClassLoader() throws CorruptDataException {
        return this.loader;
    }

    JavaClassLoader setClassLoader(JavaClassLoader javaClassLoader) {
        JavaClassLoader javaClassLoader2 = this.loader;
        this.loader = javaClassLoader;
        return javaClassLoader2;
    }

    @Override
    public JavaClass getComponentType() throws CorruptDataException {
        if (!this.isArray()) {
            throw new IllegalArgumentException(this.getName() + " is not an array");
        }
        if (this.componentType == null) {
            String string = this.getName();
            String string2 = string.startsWith("[[") ? string.substring(1) : (string.startsWith("[L") ? string.substring(2, string.length() - 1) : (string.equals("[B") ? "byte" : (string.equals("[C") ? "char" : (string.equals("[S") ? "short" : (string.equals("[I") ? "int" : (string.equals("[J") ? "long" : (string.equals("[F") ? "float" : (string.equals("[D") ? "double" : (string.equals("[Z") ? "boolean" : "java/lang/Object")))))))));
            this.componentType = this.loader.findClass(string2);
            if (this.componentType == null) {
                this.componentType = new PHDCorruptJavaClass("component type for " + string + " is " + string2 + " which is not found from " + this.loader, this.getID(), null);
            }
        }
        if (this.componentType instanceof CorruptData) {
            throw new CorruptDataException((CorruptData)((Object)this.componentType));
        }
        return this.componentType;
    }

    JavaClass setComponentType(JavaClass javaClass) {
        JavaClass javaClass2 = this.componentType;
        if (javaClass2 == null) {
            this.componentType = javaClass;
        }
        return javaClass2;
    }

    @Override
    public Iterator<JavaObject> getConstantPoolReferences() {
        return Collections.emptyList().iterator();
    }

    @Override
    public Iterator<JavaField> getDeclaredFields() {
        return Collections.emptyList().iterator();
    }

    @Override
    public Iterator<JavaMethod> getDeclaredMethods() {
        return this.methods.iterator();
    }

    @Override
    public ImagePointer getID() {
        return this.addr != 0L ? this.space.getPointer(this.addr) : null;
    }

    @Override
    public Iterator<String> getInterfaces() {
        return Collections.emptyList().iterator();
    }

    @Override
    public int getModifiers() throws CorruptDataException {
        return -16777216;
    }

    @Override
    public String getName() throws CorruptDataException {
        if (this.name == null) {
            throw new CorruptDataException(new PHDCorruptData("No class name available (null)", this.getID()));
        }
        if (this.name.equals(UNKNOWN_ARRAY)) {
            throw new CorruptDataException(new PHDCorruptData("No class name available (unknown array)", this.getID()));
        }
        if (this.name.equals(UNKNOWN_NONARRAY)) {
            throw new CorruptDataException(new PHDCorruptData("No class name available (unknown non-array)", this.getID()));
        }
        return this.name;
    }

    @Override
    public JavaObject getObject() throws CorruptDataException {
        if (this.addr == 0L) {
            return null;
        }
        if (this.classObject != null) {
            return this.classObject;
        }
        JavaClass javaClass = this.runtime.findClass("java/lang/Class");
        if (javaClass == null) {
            javaClass = this.loader.findClass("java/lang/Class");
        }
        this.classObject = new PHDJavaObject.Builder((PHDJavaHeap)this.runtime.getHeaps().next(), this.addr, javaClass, this.flags, this.hashCode).refsAsArray(new long[0], 0).length(-1).build();
        return this.classObject;
    }

    @Override
    public JavaClass getSuperclass() throws CorruptDataException {
        if (this.superAddress == 0L) {
            return null;
        }
        if (this.superAddress == -1L) {
            throw new CorruptDataException(new PHDCorruptJavaClass("No superclass available", null, null));
        }
        JavaClass javaClass = this.runtime.findClass(this.superAddress);
        try {
            if (javaClass != null && "java/lang/Class".equals(javaClass.getName())) {
                javaClass = null;
            }
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
        if (javaClass == null) {
            throw new CorruptDataException(new PHDCorruptJavaClass("Superclass not found", this.space.getPointer(this.superAddress), null));
        }
        return javaClass;
    }

    @Override
    public boolean isArray() throws CorruptDataException {
        return this.componentType != null || this.name != null && this.name.startsWith(UNKNOWN_ARRAY) || !UNKNOWN_NONARRAY.equals(this.name) && this.getName().startsWith(UNKNOWN_ARRAY);
    }

    @Override
    public Iterator<JavaReference> getReferences() {
        final PHDJavaClass pHDJavaClass = this;
        return new Iterator<JavaReference>(){
            int count;
            JavaClass sup;
            JavaObject load;
            {
                try {
                    this.sup = PHDJavaClass.this.getSuperclass();
                    if (this.sup != null) {
                        this.count = -1;
                    }
                }
                catch (CorruptDataException corruptDataException) {
                    // empty catch block
                }
                try {
                    this.load = PHDJavaClass.this.loader.getObject();
                    if (this.load != null) {
                        this.count = -2;
                    }
                }
                catch (CorruptDataException corruptDataException) {
                    // empty catch block
                }
            }

            @Override
            public boolean hasNext() {
                if (this.count < 0) {
                    return true;
                }
                if (PHDJavaClass.this.refs instanceof LongEnumeration) {
                    LongEnumeration longEnumeration = (LongEnumeration)PHDJavaClass.this.refs;
                    return longEnumeration.hasMoreElements();
                }
                if (PHDJavaClass.this.refs instanceof long[]) {
                    long[] lArray = (long[])PHDJavaClass.this.refs;
                    return this.count < lArray.length;
                }
                if (PHDJavaClass.this.refs instanceof int[]) {
                    int[] nArray = (int[])PHDJavaClass.this.refs;
                    return this.count < nArray.length;
                }
                return false;
            }

            @Override
            public JavaReference next() {
                long l;
                if (!this.hasNext()) {
                    throw new NoSuchElementException("" + this.count++);
                }
                int n = 0;
                Object object = null;
                if (this.count == -2) {
                    object = this.load;
                    ++this.count;
                    if (this.sup == null) {
                        ++this.count;
                    }
                    l = 0L;
                    n = 4;
                } else if (this.count == -1) {
                    object = this.sup;
                    ++this.count;
                    l = 0L;
                    n = 10;
                } else {
                    if (PHDJavaClass.this.refs instanceof LongEnumeration) {
                        LongEnumeration longEnumeration = (LongEnumeration)PHDJavaClass.this.refs;
                        l = longEnumeration.nextLong();
                        ++this.count;
                    } else if (PHDJavaClass.this.refs instanceof int[]) {
                        int[] nArray = (int[])PHDJavaClass.this.refs;
                        l = PHDJavaClass.this.runtime.expandAddress(nArray[this.count++]);
                    } else {
                        long[] lArray = (long[])PHDJavaClass.this.refs;
                        l = lArray[this.count++];
                    }
                    object = PHDJavaClass.this.runtime.findClass(l);
                }
                if (object != null) {
                    return new PHDJavaReference(object, pHDJavaClass, 1, n, 0, "?");
                }
                return new PHDJavaReference(new PHDJavaObject.Builder((PHDJavaHeap)PHDJavaClass.this.runtime.getHeaps().next(), l, null, 4, -1).build(), pHDJavaClass, 1, n, 0, "?");
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String toString() {
        return "PHDJavaClass " + this.name + "@" + Long.toHexString(this.addr);
    }

    @Override
    public int hashCode() {
        return (int)this.addr ^ (int)(this.addr >>> 32);
    }

    @Override
    public long getInstanceSize() throws CorruptDataException {
        if (this.size == Integer.MIN_VALUE) {
            throw new CorruptDataException(new PHDCorruptData("No class size available", this.getID()));
        }
        int n = this.runtime.minInstanceSize == 0 && this.size >= 0 ? (this.runtime.is64Bit() ? 24 : 12) : 0;
        return n + Math.abs(this.size);
    }

    long getArraySize(int n) throws CorruptDataException {
        if (!this.isArray()) {
            throw new IllegalArgumentException(this.getName() + " is not an array");
        }
        int n2 = 0;
        if (this.name != null) {
            if (this.name.equals("[B") || this.name.equals("[Z")) {
                n2 = 1;
            } else if (this.name.equals("[S") || this.name.equals("[C")) {
                n2 = 2;
            } else if (this.name.equals("[I") || this.name.equals("[F")) {
                n2 = 4;
            } else if (this.name.equals("[D") || this.name.equals("[J")) {
                n2 = 8;
            }
        }
        int n3 = this.runtime.pointerSize() * 2 + (this.runtime.minInstanceSize == 0 && n2 != 0 ? 4 : 8);
        if (n2 == 0) {
            n2 = this.runtime.pointerSize();
        }
        return (long)n3 + (long)n * (long)n2;
    }

    static boolean referencesClass(JavaClass javaClass, JavaClass javaClass2) {
        Iterator iterator = javaClass.getReferences();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof CorruptData) continue;
            JavaReference javaReference = (JavaReference)e;
            try {
                if (javaReference.isClassReference() && javaReference.getTarget().equals(javaClass2)) {
                    return true;
                }
                if (!javaReference.isObjectReference() || !javaReference.getTarget().equals(javaClass2.getObject())) continue;
                return true;
            }
            catch (DataUnavailable dataUnavailable) {
            }
            catch (CorruptDataException corruptDataException) {
            }
        }
        return false;
    }

    void addMethod(PHDJavaMethod pHDJavaMethod) {
        this.methods.add(pHDJavaMethod);
    }

    void setJavaObject(JavaObject javaObject) {
        this.classObject = javaObject;
    }

    void setName(String string) {
        this.name = string;
    }

    void updateSize(long l, long l2) {
        long l3 = l2 - l;
        if (this.size < 0 && l3 > 0L && l3 < 65536L && -l3 > (long)this.size) {
            this.size = -((int)l3);
        }
    }

    @Override
    public JavaObject getProtectionDomain() throws DataUnavailable, CorruptDataException {
        throw new DataUnavailable("This implementation of DTFJ does not support getProtectionDomain");
    }

    public static class Builder {
        private final ImageAddressSpace space;
        private final PHDJavaRuntime runtime;
        private final JavaClassLoader loader;
        private final long addr;
        private final long superAddress;
        private final String name;
        private int size = Integer.MIN_VALUE;
        private int flags = 4;
        private int hashCode = -1;
        private Object refs = null;
        private JavaClass componentType = null;

        public Builder(ImageAddressSpace imageAddressSpace, PHDJavaRuntime pHDJavaRuntime, JavaClassLoader javaClassLoader, long l, long l2, String string) {
            this.space = imageAddressSpace;
            this.runtime = pHDJavaRuntime;
            this.loader = javaClassLoader;
            this.addr = l;
            this.name = string;
            if ("byte".equals(string) || "short".equals(string) || "int".equals(string) || "long".equals(string) || "float".equals(string) || "double".equals(string) || "boolean".equals(string) || "char".equals(string) || "void".equals(string)) {
                l2 = 0L;
            }
            this.superAddress = l2;
        }

        public Builder size(int n) {
            this.size = n;
            return this;
        }

        public Builder flags(int n) {
            this.flags = n;
            return this;
        }

        public Builder hashCode(int n) {
            this.hashCode = n;
            return this;
        }

        public Builder refs(LongEnumeration longEnumeration) {
            this.refs = this.runtime.convertRefs(longEnumeration, 0);
            return this;
        }

        public Builder componentType(JavaClass javaClass) {
            this.componentType = javaClass;
            return this;
        }

        public PHDJavaClass build() {
            return new PHDJavaClass(this);
        }
    }
}

