/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.javacore;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.javacore.JCCorruptData;
import com.ibm.dtfj.java.JavaMonitor;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaThread;
import com.ibm.dtfj.java.javacore.JCInvalidArgumentsException;
import com.ibm.dtfj.java.javacore.JCJavaRuntime;
import com.ibm.dtfj.java.javacore.JCJavaThread;
import java.util.Iterator;
import java.util.Vector;

public class JCJavaMonitor
implements JavaMonitor {
    private Vector fEnterWaiters;
    private Vector fNotifyWaiters;
    private String fName;
    private JavaObject fEncompassingObject;
    private final ImagePointer fMonitorPointer;
    private final JCJavaRuntime fRuntime;
    private long fOwner;

    public JCJavaMonitor(JCJavaRuntime jCJavaRuntime, ImagePointer imagePointer, String string) throws JCInvalidArgumentsException {
        if (imagePointer == null) {
            throw new JCInvalidArgumentsException("A monitor must have a valid pointer identifier");
        }
        if (jCJavaRuntime == null) {
            throw new JCInvalidArgumentsException("A monitor must be associated with a valid runtime");
        }
        this.fRuntime = jCJavaRuntime;
        this.fMonitorPointer = imagePointer;
        this.fName = string;
        this.fEncompassingObject = null;
        this.fOwner = -1L;
        this.fEnterWaiters = new Vector();
        this.fNotifyWaiters = new Vector();
        this.fRuntime.addMonitor(this);
    }

    @Override
    public ImagePointer getID() {
        return this.fMonitorPointer;
    }

    @Override
    public String getName() throws CorruptDataException {
        if (this.fName == null) {
            String string = Long.toHexString(this.fMonitorPointer.getAddress());
            this.fName = this.fEncompassingObject == null ? "(un-named monitor @0x" + string + ")" : "(un-named monitor @0x" + string + " for object @0x" + Long.toHexString(this.fEncompassingObject.getID().getAddress()) + ")";
        }
        return this.fName;
    }

    @Override
    public Iterator getEnterWaiters() {
        return this.getThreads(this.fEnterWaiters);
    }

    @Override
    public Iterator getNotifyWaiters() {
        return this.getThreads(this.fNotifyWaiters);
    }

    private Iterator getThreads(Vector vector) {
        Vector<Object> vector2 = new Vector<Object>();
        for (ImagePointer imagePointer : vector) {
            JCJavaThread jCJavaThread = this.fRuntime.findJavaThread(imagePointer.getAddress());
            if (jCJavaThread != null) {
                vector2.add(jCJavaThread);
                continue;
            }
            vector2.add(new JCCorruptData("Unknown thread", imagePointer));
        }
        return vector2.iterator();
    }

    @Override
    public JavaObject getObject() {
        return this.fEncompassingObject;
    }

    @Override
    public JavaThread getOwner() throws CorruptDataException {
        if (this.fOwner != -1L) {
            Object object;
            if (this.fOwner < 65536L && this.fEncompassingObject != null && (object = this.fRuntime.findMonitor(this.fEncompassingObject.getID().getAddress())) != null) {
                try {
                    JavaThread javaThread = ((JCJavaMonitor)object).getOwner();
                    return javaThread;
                }
                catch (CorruptDataException corruptDataException) {
                    // empty catch block
                }
            }
            if ((object = this.fRuntime.findJavaThread(this.fOwner)) != null) {
                return object;
            }
            throw new CorruptDataException(new JCCorruptData("No owner for this monitor", this.fMonitorPointer.getAddressSpace().getPointer(this.fOwner)));
        }
        return null;
    }

    public void addEnterWaiter(ImagePointer imagePointer) {
        if (imagePointer != null) {
            this.fEnterWaiters.add(imagePointer);
        }
    }

    public void addNotifyWaiter(ImagePointer imagePointer) {
        if (imagePointer != null) {
            this.fNotifyWaiters.add(imagePointer);
        }
    }

    public void setObject(JavaObject javaObject) {
        this.fEncompassingObject = javaObject;
    }

    public void setOwner(long l) {
        this.fOwner = l;
    }
}

