/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.image.j9;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.MemoryAccessException;
import java.util.Properties;

public class ImagePointer
implements com.ibm.dtfj.image.ImagePointer {
    private long _underlyingAddress;
    private com.ibm.dtfj.image.j9.ImageAddressSpace _residentDomain;

    public ImagePointer(com.ibm.dtfj.image.j9.ImageAddressSpace imageAddressSpace, long l) {
        if (null == imageAddressSpace) {
            throw new IllegalArgumentException("Pointer cannot exist in null address space");
        }
        this._residentDomain = imageAddressSpace;
        this._underlyingAddress = l;
    }

    @Override
    public long getAddress() {
        return this._underlyingAddress;
    }

    @Override
    public ImageAddressSpace getAddressSpace() {
        return this._residentDomain;
    }

    @Override
    public com.ibm.dtfj.image.ImagePointer add(long l) {
        return this._residentDomain.getPointer(this.getAddress() + l);
    }

    @Override
    public boolean isExecutable() throws DataUnavailable {
        return this._residentDomain.isExecutableAt(this._underlyingAddress);
    }

    @Override
    public boolean isReadOnly() throws DataUnavailable {
        return this._residentDomain.isReadOnly(this._underlyingAddress);
    }

    @Override
    public boolean isShared() throws DataUnavailable {
        return this._residentDomain.isShared(this._underlyingAddress);
    }

    @Override
    public Properties getProperties() {
        return new Properties();
    }

    @Override
    public com.ibm.dtfj.image.ImagePointer getPointerAt(long l) throws MemoryAccessException, CorruptDataException {
        return this._residentDomain.readPointerAtIndex(this.getAddress() + l);
    }

    @Override
    public long getLongAt(long l) throws MemoryAccessException, CorruptDataException {
        return this._residentDomain.readLongAtIndex(this.getAddress() + l);
    }

    @Override
    public int getIntAt(long l) throws MemoryAccessException, CorruptDataException {
        return this._residentDomain.readIntAtIndex(this.getAddress() + l);
    }

    @Override
    public short getShortAt(long l) throws MemoryAccessException, CorruptDataException {
        return this._residentDomain.readShortAtIndex(this.getAddress() + l);
    }

    @Override
    public byte getByteAt(long l) throws MemoryAccessException, CorruptDataException {
        return this._residentDomain.readByteAtIndex(this.getAddress() + l);
    }

    @Override
    public float getFloatAt(long l) throws MemoryAccessException, CorruptDataException {
        return Float.intBitsToFloat(this.getIntAt(l));
    }

    @Override
    public double getDoubleAt(long l) throws MemoryAccessException, CorruptDataException {
        return Double.longBitsToDouble(this.getLongAt(l));
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof ImagePointer) {
            ImagePointer imagePointer = (ImagePointer)object;
            bl = this._residentDomain.equals(imagePointer._residentDomain) && this._underlyingAddress == imagePointer._underlyingAddress;
        }
        return bl;
    }

    @Override
    public int hashCode() {
        return this._residentDomain.hashCode() ^ ((int)this._underlyingAddress ^ (int)(this._underlyingAddress >> 32));
    }

    public String toString() {
        return Long.toHexString(this._underlyingAddress);
    }
}

