/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.image.j9;

import com.ibm.dtfj.corereaders.ClosingFileReader;
import com.ibm.dtfj.corereaders.DumpFactory;
import com.ibm.dtfj.corereaders.ICoreFileReader;
import com.ibm.dtfj.corereaders.ResourceReleaser;
import com.ibm.dtfj.image.j9.DefaultFileLocationResolver;
import com.ibm.dtfj.image.j9.IFileLocationResolver;
import com.ibm.dtfj.image.j9.Image;
import com.ibm.dtfj.image.j9.ImageFactory;
import com.ibm.dtfj.image.j9.ReleasingImage;
import com.ibm.dtfj.image.j9.ZipExtractionResolver;
import com.ibm.dtfj.utils.file.FileManager;
import com.ibm.jvm.j9.dump.indexsupport.XMLIndexReader;
import com.ibm.jvm.j9.dump.indexsupport.XMLInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteOrder;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.imageio.stream.ImageInputStream;

public class DTFJImageFactory
implements com.ibm.dtfj.image.ImageFactory {
    @Override
    public com.ibm.dtfj.image.Image[] getImagesFromArchive(File file, boolean bl) throws IOException {
        throw new IOException("Not supported for legacy DTFJ");
    }

    @Override
    public com.ibm.dtfj.image.Image getImage(File file) throws IOException {
        ReleasingImage releasingImage = null;
        try {
            ZipFile zipFile = new ZipFile(file);
            ZipExtractionResolver zipExtractionResolver = new ZipExtractionResolver(zipFile);
            File file2 = zipExtractionResolver.decompressCoreFile();
            InputStream inputStream = zipExtractionResolver.decompressMetaDataStream();
            releasingImage = this.getImage(file2, inputStream, zipExtractionResolver);
            releasingImage.addReleasable(zipExtractionResolver);
        }
        catch (ZipException zipException) {
            return this.getImage(file, new File(file.toString() + ".xml"));
        }
        return releasingImage;
    }

    @Override
    public com.ibm.dtfj.image.Image getImage(ImageInputStream imageInputStream, URI uRI) throws IOException {
        throw new IOException("Legacy DTFJ requires an XML file to be supplied when creating an image from a stream.");
    }

    @Override
    public com.ibm.dtfj.image.Image getImage(ImageInputStream imageInputStream, final ImageInputStream imageInputStream2, URI uRI) throws IOException {
        Object object;
        imageInputStream.setByteOrder(ByteOrder.BIG_ENDIAN);
        ICoreFileReader iCoreFileReader = DumpFactory.createDumpForCore(imageInputStream);
        XMLIndexReader xMLIndexReader = new XMLIndexReader();
        InputStream inputStream = new InputStream(){

            @Override
            public int read() throws IOException {
                return imageInputStream2.read();
            }
        };
        XMLInputStream xMLInputStream = new XMLInputStream(inputStream);
        IFileLocationResolver iFileLocationResolver = null;
        File file = null;
        if (uRI.getFragment() != null && uRI.getFragment().length() != 0) {
            try {
                object = new URI(uRI.getScheme() + "://" + uRI.getPath());
                file = new File((URI)object);
            }
            catch (URISyntaxException uRISyntaxException) {}
        } else {
            file = new File(uRI);
        }
        if (file.exists()) {
            if (FileManager.isArchive(file)) {
                object = new ZipFile(file);
                iFileLocationResolver = new ZipExtractionResolver((ZipFile)object);
            } else {
                iFileLocationResolver = new DefaultFileLocationResolver(file.getParentFile());
            }
        }
        object = xMLIndexReader.parseIndexWithDump((InputStream)xMLInputStream, iCoreFileReader, imageInputStream, iFileLocationResolver);
        imageInputStream2.close();
        object.addReleasable(iCoreFileReader);
        if (object instanceof Image) {
            ((Image)object).SetSource(uRI);
        }
        return object;
    }

    @Override
    public com.ibm.dtfj.image.Image getImage(File file, File file2) throws IOException {
        Object object;
        FileInputStream fileInputStream = null;
        IFileLocationResolver iFileLocationResolver = null;
        if (FileManager.isArchive(file2)) {
            object = new File(file.getParentFile(), file.getName() + ".xml");
            fileInputStream = new FileInputStream((File)object);
            ZipFile zipFile = new ZipFile(file2);
            iFileLocationResolver = new ZipExtractionResolver(zipFile);
        } else {
            fileInputStream = new FileInputStream(file2);
            iFileLocationResolver = new DefaultFileLocationResolver(file.getParentFile());
        }
        object = this.getImage(file, fileInputStream, iFileLocationResolver);
        fileInputStream.close();
        return object;
    }

    private ReleasingImage getImage(File file, InputStream inputStream, IFileLocationResolver iFileLocationResolver) throws IOException {
        ClosingFileReader closingFileReader = new ClosingFileReader(file);
        ICoreFileReader iCoreFileReader = DumpFactory.createDumpForCore(closingFileReader);
        XMLIndexReader xMLIndexReader = new XMLIndexReader();
        XMLInputStream xMLInputStream = new XMLInputStream(inputStream);
        Image image = xMLIndexReader.parseIndexWithDump((InputStream)xMLInputStream, iCoreFileReader, closingFileReader, iFileLocationResolver);
        image.addReleasable(xMLInputStream);
        image.addReleasable(closingFileReader);
        image.addReleasable(iCoreFileReader);
        if (iFileLocationResolver instanceof ResourceReleaser) {
            image.addReleasable((ResourceReleaser)((Object)iFileLocationResolver));
        }
        return image;
    }

    @Override
    public int getDTFJMajorVersion() {
        return 1;
    }

    @Override
    public int getDTFJMinorVersion() {
        return 12;
    }

    @Override
    public int getDTFJModificationLevel() {
        int n = 0;
        try {
            n = Integer.parseInt(ImageFactory.class.getPackage().getImplementationVersion());
        }
        catch (NumberFormatException numberFormatException) {
            n = -1;
        }
        return n;
    }
}

