/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.corereaders;

import com.ibm.dtfj.corereaders.ResourceReleaser;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;

public class DumpReader
implements ResourceReleaser {
    private ImageInputStream _file;
    private boolean _is64Bit;

    public DumpReader(ImageInputStream imageInputStream, boolean bl) {
        this._file = imageInputStream;
        this._is64Bit = bl;
    }

    public byte[] readBytes(int n) throws IOException {
        byte[] byArray = new byte[n];
        this._file.readFully(byArray);
        return byArray;
    }

    public int readInt() throws IOException {
        return this._file.readInt();
    }

    public void seek(long l) throws IOException {
        this._file.seek(l);
    }

    public long readLong() throws IOException {
        return this._file.readLong();
    }

    public short readShort() throws IOException {
        return this._file.readShort();
    }

    public byte readByte() throws IOException {
        return this._file.readByte();
    }

    public long readAddress() throws IOException {
        long l = 0L;
        l = this._is64Bit ? this.readLong() : 0xFFFFFFFFL & (long)this.readInt();
        return l;
    }

    public long getPosition() throws IOException {
        return this._file.getStreamPosition();
    }

    @Override
    public void releaseResources() throws IOException {
        this._file.close();
    }
}

