/*
 * Decompiled with CFR 0.152.
 */
package sun.text;

public final class UCompactIntArray
implements Cloneable {
    private static final int PLANEMASK = 196608;
    private static final int PLANESHIFT = 16;
    private static final int PLANECOUNT = 16;
    private static final int CODEPOINTMASK = 65535;
    private static final int UNICODECOUNT = 65536;
    private static final int BLOCKSHIFT = 7;
    private static final int BLOCKCOUNT = 128;
    private static final int INDEXSHIFT = 9;
    private static final int INDEXCOUNT = 512;
    private static final int BLOCKMASK = 127;
    private int defaultValue;
    private int[][] values = new int[16][];
    private short[][] indices = new short[16][];
    private boolean isCompact;
    private boolean[][] blockTouched = new boolean[16][];
    private boolean[] planeTouched = new boolean[16];

    public UCompactIntArray() {
    }

    public UCompactIntArray(int n) {
        this();
        this.defaultValue = n;
    }

    public int elementAt(int n) {
        int n2 = (n & 0x30000) >> 16;
        if (!this.planeTouched[n2]) {
            return this.defaultValue;
        }
        return this.values[n2][(this.indices[n2][(n &= 0xFFFF) >> 7] & 0xFFFF) + (n & 0x7F)];
    }

    public void setElementAt(int n, int n2) {
        int n3;
        if (this.isCompact) {
            this.expand();
        }
        if (!this.planeTouched[n3 = (n & 0x30000) >> 16]) {
            this.initPlane(n3);
        }
        this.values[n3][n &= 0xFFFF] = n2;
        this.blockTouched[n3][n >> 7] = true;
    }

    public void compact() {
        if (this.isCompact) {
            return;
        }
        for (int i = 0; i < 16; ++i) {
            if (!this.planeTouched[i]) continue;
            int n = 0;
            int n2 = 0;
            int n3 = -1;
            int n4 = 0;
            while (n4 < this.indices[i].length) {
                this.indices[i][n4] = -1;
                if (!this.blockTouched[i][n4] && n3 != -1) {
                    this.indices[i][n4] = n3;
                } else {
                    int n5 = n * 128;
                    if (n4 > n) {
                        System.arraycopy((Object)this.values[i], n2, (Object)this.values[i], n5, 128);
                    }
                    if (!this.blockTouched[i][n4]) {
                        n3 = (short)n5;
                    }
                    this.indices[i][n4] = (short)n5;
                    ++n;
                }
                ++n4;
                n2 += 128;
            }
            n4 = n * 128;
            int[] nArray = new int[n4];
            System.arraycopy((Object)this.values[i], 0, (Object)nArray, 0, n4);
            this.values[i] = nArray;
            this.blockTouched[i] = null;
        }
        this.isCompact = true;
    }

    private void expand() {
        if (this.isCompact) {
            for (int i = 0; i < 16; ++i) {
                int n;
                if (!this.planeTouched[i]) continue;
                this.blockTouched[i] = new boolean[512];
                int[] nArray = new int[65536];
                for (n = 0; n < 65536; ++n) {
                    nArray[n] = this.values[i][this.indices[i][n >> 7] & 65535 + (n & 0x7F)];
                    this.blockTouched[i][n >> 7] = true;
                }
                for (n = 0; n < 512; ++n) {
                    this.indices[i][n] = (short)(n << 7);
                }
                this.values[i] = nArray;
            }
            this.isCompact = false;
        }
    }

    private void initPlane(int n) {
        int n2;
        this.values[n] = new int[65536];
        this.indices[n] = new short[512];
        this.blockTouched[n] = new boolean[512];
        this.planeTouched[n] = true;
        if (this.planeTouched[0] && n != 0) {
            System.arraycopy((Object)this.indices[0], 0, (Object)this.indices[n], 0, 512);
        } else {
            for (n2 = 0; n2 < 512; ++n2) {
                this.indices[n][n2] = (short)(n2 << 7);
            }
        }
        for (n2 = 0; n2 < 65536; ++n2) {
            this.values[n][n2] = this.defaultValue;
        }
    }

    public int getKSize() {
        int n = 0;
        for (int i = 0; i < 16; ++i) {
            if (!this.planeTouched[i]) continue;
            n += this.values[i].length * 4 + this.indices[i].length * 2;
        }
        return n / 1024;
    }
}

