/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import java.math.BigInteger;
import java.security.KeyException;
import java.security.PublicKey;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.KeyName;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.keyinfo.PGPData;
import javax.xml.crypto.dsig.keyinfo.RetrievalMethod;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.keyinfo.X509IssuerSerial;
import org.jcp.xml.dsig.internal.dom.DOMKeyInfo;
import org.jcp.xml.dsig.internal.dom.DOMKeyName;
import org.jcp.xml.dsig.internal.dom.DOMKeyValue;
import org.jcp.xml.dsig.internal.dom.DOMPGPData;
import org.jcp.xml.dsig.internal.dom.DOMRetrievalMethod;
import org.jcp.xml.dsig.internal.dom.DOMURIDereferencer;
import org.jcp.xml.dsig.internal.dom.DOMX509Data;
import org.jcp.xml.dsig.internal.dom.DOMX509IssuerSerial;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DOMKeyInfoFactory
extends KeyInfoFactory {
    @Override
    public KeyInfo newKeyInfo(List list) {
        return this.newKeyInfo(list, null);
    }

    @Override
    public KeyInfo newKeyInfo(List list, String string) {
        return new DOMKeyInfo(list, string);
    }

    @Override
    public KeyName newKeyName(String string) {
        return new DOMKeyName(string);
    }

    @Override
    public KeyValue newKeyValue(PublicKey publicKey) throws KeyException {
        String string = publicKey.getAlgorithm();
        if (string.equals("DSA")) {
            return new DOMKeyValue.DSA(publicKey);
        }
        if (string.equals("RSA")) {
            return new DOMKeyValue.RSA(publicKey);
        }
        if (string.equals("EC")) {
            return new DOMKeyValue.EC(publicKey);
        }
        throw new KeyException("unsupported key algorithm: " + string);
    }

    @Override
    public PGPData newPGPData(byte[] byArray) {
        return this.newPGPData(byArray, null, null);
    }

    @Override
    public PGPData newPGPData(byte[] byArray, byte[] byArray2, List list) {
        return new DOMPGPData(byArray, byArray2, list);
    }

    @Override
    public PGPData newPGPData(byte[] byArray, List list) {
        return new DOMPGPData(byArray, list);
    }

    @Override
    public RetrievalMethod newRetrievalMethod(String string) {
        return this.newRetrievalMethod(string, null, null);
    }

    @Override
    public RetrievalMethod newRetrievalMethod(String string, String string2, List list) {
        if (string == null) {
            throw new NullPointerException("uri must not be null");
        }
        return new DOMRetrievalMethod(string, string2, list);
    }

    @Override
    public X509Data newX509Data(List list) {
        return new DOMX509Data(list);
    }

    @Override
    public X509IssuerSerial newX509IssuerSerial(String string, BigInteger bigInteger) {
        return new DOMX509IssuerSerial(string, bigInteger);
    }

    @Override
    public boolean isFeatureSupported(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        return false;
    }

    @Override
    public URIDereferencer getURIDereferencer() {
        return DOMURIDereferencer.INSTANCE;
    }

    @Override
    public KeyInfo unmarshalKeyInfo(XMLStructure xMLStructure) throws MarshalException {
        if (xMLStructure == null) {
            throw new NullPointerException("xmlStructure cannot be null");
        }
        if (!(xMLStructure instanceof DOMStructure)) {
            throw new ClassCastException("xmlStructure must be of type DOMStructure");
        }
        Node node = ((DOMStructure)xMLStructure).getNode();
        node.normalize();
        Element element = null;
        if (node.getNodeType() == 9) {
            element = ((Document)node).getDocumentElement();
        } else if (node.getNodeType() == 1) {
            element = (Element)node;
        } else {
            throw new MarshalException("xmlStructure does not contain a proper Node");
        }
        String string = element.getLocalName();
        if (string == null) {
            throw new MarshalException("Document implementation must support DOM Level 2 and be namespace aware");
        }
        if (string.equals("KeyInfo")) {
            try {
                return new DOMKeyInfo(element, new UnmarshalContext(), this.getProvider());
            }
            catch (MarshalException marshalException) {
                throw marshalException;
            }
            catch (Exception exception) {
                throw new MarshalException(exception);
            }
        }
        throw new MarshalException("Invalid KeyInfo tag: " + string);
    }

    private static class UnmarshalContext
    extends DOMCryptoContext {
        UnmarshalContext() {
        }
    }
}

