/*
 * Decompiled with CFR 0.152.
 */
package openj9.internal.tools.attach.target;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessController;
import java.util.Comparator;
import java.util.Properties;

public class DiagnosticProperties {
    private final Properties baseProperties;
    public static final String OPENJ9_DIAGNOSTICS_PREFIX = "openj9_diagnostics.";
    public static final String DIAGNOSTICS_STRING_RESULT = "openj9_diagnostics.string_result";
    private static final String JAVA_LANG_STRING = "java.lang.String";
    public static final String DEBUG_PROPERTY = "openj9.tools.attach.diagnostics.debug";
    public static boolean isDebug;

    public DiagnosticProperties(Properties properties) {
        this.baseProperties = properties;
    }

    public DiagnosticProperties() {
        this.baseProperties = new Properties();
    }

    public void put(String string, int n) {
        this.baseProperties.setProperty(string, Integer.toString(n));
    }

    public void put(String string, String string2) {
        this.baseProperties.setProperty(string, string2);
    }

    public void put(String string, long l) {
        this.baseProperties.setProperty(string, Long.toString(l));
    }

    public void put(String string, boolean bl) {
        this.baseProperties.setProperty(string, Boolean.toString(bl));
    }

    private void checkExists(String string) throws IOException {
        if (!this.containsField(string)) {
            throw new IOException("key " + string + " not found");
        }
    }

    public boolean containsField(String string) {
        return this.baseProperties.containsKey(string);
    }

    public int getInt(String string) throws NumberFormatException, IOException {
        this.checkExists(string);
        return Integer.parseInt(this.baseProperties.getProperty(string));
    }

    public long getLong(String string) throws NumberFormatException, IOException {
        this.checkExists(string);
        return Long.parseLong(this.baseProperties.getProperty(string));
    }

    public boolean getBoolean(String string) throws IOException {
        this.checkExists(string);
        return Boolean.parseBoolean(this.baseProperties.getProperty(string));
    }

    public String getString(String string) throws IOException {
        this.checkExists(string);
        return this.baseProperties.getProperty(string);
    }

    public String getPropertyOrNull(String string) {
        return this.baseProperties.getProperty(string);
    }

    public Object getSimple(String string, String string2) throws NumberFormatException {
        Object object = null;
        String string3 = this.baseProperties.getProperty(string2);
        if (null != string3 && (JAVA_LANG_STRING.equals(string) || !string3.isEmpty())) {
            switch (string) {
                case "java.lang.Boolean": {
                    object = Boolean.valueOf(string3);
                    break;
                }
                case "java.lang.Character": {
                    object = Character.valueOf(string3.charAt(0));
                    break;
                }
                case "java.lang.Byte": {
                    object = Byte.valueOf(string3);
                    break;
                }
                case "java.lang.Short": {
                    object = Short.valueOf(string3);
                    break;
                }
                case "java.lang.Integer": {
                    object = Integer.valueOf(string3);
                    break;
                }
                case "java.lang.Long": {
                    object = Long.valueOf(string3);
                    break;
                }
                case "java.lang.Float": {
                    object = Float.valueOf(string3);
                    break;
                }
                case "java.lang.Double": {
                    object = Double.valueOf(string3);
                    break;
                }
                case "java.lang.String": {
                    object = string3;
                    break;
                }
            }
        }
        return object;
    }

    public static void dumpPropertiesIfDebug(String string, DiagnosticProperties diagnosticProperties) {
        DiagnosticProperties.dumpPropertiesIfDebug(string, diagnosticProperties.baseProperties);
    }

    public static void dumpPropertiesIfDebug(String string, Properties properties) {
        if (isDebug) {
            if (null != string) {
                System.err.println(string);
            }
            if (null != properties) {
                String string2 = DiagnosticProperties.printProperties(properties);
                System.err.print(string2);
            }
        }
    }

    public static String printProperties(Properties properties) {
        StringWriter stringWriter = new StringWriter(1000);
        try (PrintWriter printWriter = new PrintWriter(stringWriter);){
            properties.entrySet().stream().sorted(Comparator.comparing(entry -> entry.getKey().toString())).forEach(entry -> {
                printWriter.print(entry.getKey());
                printWriter.print("=");
                printWriter.println((String)entry.getValue());
            });
        }
        return stringWriter.toString();
    }

    public String printStringResult() {
        StringWriter stringWriter = new StringWriter(1000);
        try (PrintWriter printWriter = new PrintWriter(stringWriter);){
            if (Boolean.parseBoolean(this.getPropertyOrNull("openj9_diagnostics.error"))) {
                String string = this.getPropertyOrNull("openj9_diagnostics.errortype");
                if (null == string) {
                    string = "No error type available";
                }
                printWriter.printf("Error: %s%n", string);
                String string2 = this.getPropertyOrNull("openj9_diagnostics.errormsg");
                if (null != string2) {
                    printWriter.println(string2);
                }
            } else {
                printWriter.println(this.getString(DIAGNOSTICS_STRING_RESULT));
            }
        }
        catch (IOException iOException) {
            stringWriter = new StringWriter();
            stringWriter.append("Error parsing properties: ");
            stringWriter.append(iOException.toString());
            stringWriter.append(System.lineSeparator());
        }
        return stringWriter.toString();
    }

    public static DiagnosticProperties makeStringResult(String string) {
        DiagnosticProperties diagnosticProperties = DiagnosticProperties.makeCommandSucceeded();
        diagnosticProperties.put(DIAGNOSTICS_STRING_RESULT, string);
        return diagnosticProperties;
    }

    public Properties toProperties() {
        return this.baseProperties;
    }

    public static DiagnosticProperties makeCommandSucceeded() {
        DiagnosticProperties diagnosticProperties = DiagnosticProperties.makeStatusProperties(false, null);
        diagnosticProperties.put(DIAGNOSTICS_STRING_RESULT, "Command succeeded");
        return diagnosticProperties;
    }

    public static DiagnosticProperties makeErrorProperties(String string) {
        return DiagnosticProperties.makeStatusProperties(true, string);
    }

    public static Properties makeExceptionProperties(Exception exception) {
        Properties properties = new Properties();
        properties.put("openj9_diagnostics.error", Boolean.toString(true));
        properties.put("openj9_diagnostics.errortype", exception.getClass().getName());
        String string = exception.getMessage();
        if (null == string) {
            string = String.format("Error at %s", exception.getStackTrace()[0].toString());
        }
        properties.put("openj9_diagnostics.errormsg", string);
        return properties;
    }

    public static DiagnosticProperties makeStatusProperties(boolean bl, String string) {
        DiagnosticProperties diagnosticProperties = new DiagnosticProperties();
        diagnosticProperties.put("openj9_diagnostics.error", Boolean.toString(bl));
        diagnosticProperties.put("openj9_diagnostics.errortype", "Error in command");
        if (null != string) {
            diagnosticProperties.put("openj9_diagnostics.errormsg", string);
        }
        return diagnosticProperties;
    }

    static {
        AccessController.doPrivileged(() -> {
            isDebug = Boolean.getBoolean(DEBUG_PROPERTY);
            return null;
        });
    }
}

