/*
 * Decompiled with CFR 0.152.
 */
package java.util.stream;

import java.util.Comparator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import java.util.stream.BaseStream;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.SpinedBuffer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

final class Streams {
    static final Object NONE = new Object();

    private Streams() {
        throw new Error("no instances");
    }

    static Runnable composeWithExceptions(final Runnable runnable, final Runnable runnable2) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    runnable.run();
                }
                catch (Throwable throwable) {
                    try {
                        runnable2.run();
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable.addSuppressed(throwable2);
                        }
                        catch (Throwable throwable3) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                runnable2.run();
            }
        };
    }

    static Runnable composedClose(final BaseStream<?, ?> baseStream, final BaseStream<?, ?> baseStream2) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    baseStream.close();
                }
                catch (Throwable throwable) {
                    try {
                        baseStream2.close();
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable.addSuppressed(throwable2);
                        }
                        catch (Throwable throwable3) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                baseStream2.close();
            }
        };
    }

    static abstract class ConcatSpliterator<T, T_SPLITR extends Spliterator<T>>
    implements Spliterator<T> {
        protected final T_SPLITR aSpliterator;
        protected final T_SPLITR bSpliterator;
        boolean beforeSplit;
        final boolean unsized;

        public ConcatSpliterator(T_SPLITR T_SPLITR, T_SPLITR T_SPLITR2) {
            this.aSpliterator = T_SPLITR;
            this.bSpliterator = T_SPLITR2;
            this.beforeSplit = true;
            this.unsized = T_SPLITR.estimateSize() + T_SPLITR2.estimateSize() < 0L;
        }

        public T_SPLITR trySplit() {
            Object object = this.beforeSplit ? this.aSpliterator : this.bSpliterator.trySplit();
            this.beforeSplit = false;
            return object;
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> consumer) {
            boolean bl;
            if (this.beforeSplit) {
                bl = this.aSpliterator.tryAdvance(consumer);
                if (!bl) {
                    this.beforeSplit = false;
                    bl = this.bSpliterator.tryAdvance(consumer);
                }
            } else {
                bl = this.bSpliterator.tryAdvance(consumer);
            }
            return bl;
        }

        @Override
        public void forEachRemaining(Consumer<? super T> consumer) {
            if (this.beforeSplit) {
                this.aSpliterator.forEachRemaining(consumer);
            }
            this.bSpliterator.forEachRemaining(consumer);
        }

        @Override
        public long estimateSize() {
            if (this.beforeSplit) {
                long l = this.aSpliterator.estimateSize() + this.bSpliterator.estimateSize();
                return l >= 0L ? l : Long.MAX_VALUE;
            }
            return this.bSpliterator.estimateSize();
        }

        @Override
        public int characteristics() {
            if (this.beforeSplit) {
                return this.aSpliterator.characteristics() & this.bSpliterator.characteristics() & ~(5 | (this.unsized ? 16448 : 0));
            }
            return this.bSpliterator.characteristics();
        }

        @Override
        public Comparator<? super T> getComparator() {
            if (this.beforeSplit) {
                throw new IllegalStateException();
            }
            return this.bSpliterator.getComparator();
        }

        static class OfDouble
        extends OfPrimitive<Double, DoubleConsumer, Spliterator.OfDouble>
        implements Spliterator.OfDouble {
            OfDouble(Spliterator.OfDouble ofDouble, Spliterator.OfDouble ofDouble2) {
                super(ofDouble, ofDouble2, null);
            }
        }

        static class OfLong
        extends OfPrimitive<Long, LongConsumer, Spliterator.OfLong>
        implements Spliterator.OfLong {
            OfLong(Spliterator.OfLong ofLong, Spliterator.OfLong ofLong2) {
                super(ofLong, ofLong2, null);
            }
        }

        static class OfInt
        extends OfPrimitive<Integer, IntConsumer, Spliterator.OfInt>
        implements Spliterator.OfInt {
            OfInt(Spliterator.OfInt ofInt, Spliterator.OfInt ofInt2) {
                super(ofInt, ofInt2, null);
            }
        }

        private static abstract class OfPrimitive<T, T_CONS, T_SPLITR extends Spliterator.OfPrimitive<T, T_CONS, T_SPLITR>>
        extends ConcatSpliterator<T, T_SPLITR>
        implements Spliterator.OfPrimitive<T, T_CONS, T_SPLITR> {
            private OfPrimitive(T_SPLITR T_SPLITR, T_SPLITR T_SPLITR2) {
                super(T_SPLITR, T_SPLITR2);
            }

            @Override
            public boolean tryAdvance(T_CONS T_CONS) {
                boolean bl;
                if (this.beforeSplit) {
                    bl = ((Spliterator.OfPrimitive)this.aSpliterator).tryAdvance(T_CONS);
                    if (!bl) {
                        this.beforeSplit = false;
                        bl = ((Spliterator.OfPrimitive)this.bSpliterator).tryAdvance(T_CONS);
                    }
                } else {
                    bl = ((Spliterator.OfPrimitive)this.bSpliterator).tryAdvance(T_CONS);
                }
                return bl;
            }

            @Override
            public void forEachRemaining(T_CONS T_CONS) {
                if (this.beforeSplit) {
                    ((Spliterator.OfPrimitive)this.aSpliterator).forEachRemaining(T_CONS);
                }
                ((Spliterator.OfPrimitive)this.bSpliterator).forEachRemaining(T_CONS);
            }

            /* synthetic */ OfPrimitive(Spliterator.OfPrimitive ofPrimitive, Spliterator.OfPrimitive ofPrimitive2, 1 var3_3) {
                this(ofPrimitive, ofPrimitive2);
            }
        }

        static class OfRef<T>
        extends ConcatSpliterator<T, Spliterator<T>> {
            OfRef(Spliterator<T> spliterator, Spliterator<T> spliterator2) {
                super(spliterator, spliterator2);
            }
        }
    }

    static final class DoubleStreamBuilderImpl
    extends AbstractStreamBuilderImpl<Double, Spliterator.OfDouble>
    implements DoubleStream.Builder,
    Spliterator.OfDouble {
        double first;
        SpinedBuffer.OfDouble buffer;

        DoubleStreamBuilderImpl() {
        }

        DoubleStreamBuilderImpl(double d) {
            this.first = d;
            this.count = -2;
        }

        @Override
        public void accept(double d) {
            if (this.count == 0) {
                this.first = d;
                ++this.count;
            } else if (this.count > 0) {
                if (this.buffer == null) {
                    this.buffer = new SpinedBuffer.OfDouble();
                    this.buffer.accept(this.first);
                    ++this.count;
                }
                this.buffer.accept(d);
            } else {
                throw new IllegalStateException();
            }
        }

        @Override
        public DoubleStream build() {
            int n = this.count;
            if (n >= 0) {
                this.count = -this.count - 1;
                return n < 2 ? StreamSupport.doubleStream(this, false) : StreamSupport.doubleStream(this.buffer.spliterator(), false);
            }
            throw new IllegalStateException();
        }

        @Override
        public boolean tryAdvance(DoubleConsumer doubleConsumer) {
            Objects.requireNonNull(doubleConsumer);
            if (this.count == -2) {
                doubleConsumer.accept(this.first);
                this.count = -1;
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(DoubleConsumer doubleConsumer) {
            Objects.requireNonNull(doubleConsumer);
            if (this.count == -2) {
                doubleConsumer.accept(this.first);
                this.count = -1;
            }
        }
    }

    static final class LongStreamBuilderImpl
    extends AbstractStreamBuilderImpl<Long, Spliterator.OfLong>
    implements LongStream.Builder,
    Spliterator.OfLong {
        long first;
        SpinedBuffer.OfLong buffer;

        LongStreamBuilderImpl() {
        }

        LongStreamBuilderImpl(long l) {
            this.first = l;
            this.count = -2;
        }

        @Override
        public void accept(long l) {
            if (this.count == 0) {
                this.first = l;
                ++this.count;
            } else if (this.count > 0) {
                if (this.buffer == null) {
                    this.buffer = new SpinedBuffer.OfLong();
                    this.buffer.accept(this.first);
                    ++this.count;
                }
                this.buffer.accept(l);
            } else {
                throw new IllegalStateException();
            }
        }

        @Override
        public LongStream build() {
            int n = this.count;
            if (n >= 0) {
                this.count = -this.count - 1;
                return n < 2 ? StreamSupport.longStream(this, false) : StreamSupport.longStream(this.buffer.spliterator(), false);
            }
            throw new IllegalStateException();
        }

        @Override
        public boolean tryAdvance(LongConsumer longConsumer) {
            Objects.requireNonNull(longConsumer);
            if (this.count == -2) {
                longConsumer.accept(this.first);
                this.count = -1;
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(LongConsumer longConsumer) {
            Objects.requireNonNull(longConsumer);
            if (this.count == -2) {
                longConsumer.accept(this.first);
                this.count = -1;
            }
        }
    }

    static final class IntStreamBuilderImpl
    extends AbstractStreamBuilderImpl<Integer, Spliterator.OfInt>
    implements IntStream.Builder,
    Spliterator.OfInt {
        int first;
        SpinedBuffer.OfInt buffer;

        IntStreamBuilderImpl() {
        }

        IntStreamBuilderImpl(int n) {
            this.first = n;
            this.count = -2;
        }

        @Override
        public void accept(int n) {
            if (this.count == 0) {
                this.first = n;
                ++this.count;
            } else if (this.count > 0) {
                if (this.buffer == null) {
                    this.buffer = new SpinedBuffer.OfInt();
                    this.buffer.accept(this.first);
                    ++this.count;
                }
                this.buffer.accept(n);
            } else {
                throw new IllegalStateException();
            }
        }

        @Override
        public IntStream build() {
            int n = this.count;
            if (n >= 0) {
                this.count = -this.count - 1;
                return n < 2 ? StreamSupport.intStream(this, false) : StreamSupport.intStream(this.buffer.spliterator(), false);
            }
            throw new IllegalStateException();
        }

        @Override
        public boolean tryAdvance(IntConsumer intConsumer) {
            Objects.requireNonNull(intConsumer);
            if (this.count == -2) {
                intConsumer.accept(this.first);
                this.count = -1;
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(IntConsumer intConsumer) {
            Objects.requireNonNull(intConsumer);
            if (this.count == -2) {
                intConsumer.accept(this.first);
                this.count = -1;
            }
        }
    }

    static final class StreamBuilderImpl<T>
    extends AbstractStreamBuilderImpl<T, Spliterator<T>>
    implements Stream.Builder<T> {
        T first;
        SpinedBuffer<T> buffer;

        StreamBuilderImpl() {
        }

        StreamBuilderImpl(T t) {
            this.first = t;
            this.count = -2;
        }

        @Override
        public void accept(T t) {
            if (this.count == 0) {
                this.first = t;
                ++this.count;
            } else if (this.count > 0) {
                if (this.buffer == null) {
                    this.buffer = new SpinedBuffer();
                    this.buffer.accept(this.first);
                    ++this.count;
                }
                this.buffer.accept(t);
            } else {
                throw new IllegalStateException();
            }
        }

        @Override
        public Stream.Builder<T> add(T t) {
            this.accept(t);
            return this;
        }

        @Override
        public Stream<T> build() {
            int n = this.count;
            if (n >= 0) {
                this.count = -this.count - 1;
                return n < 2 ? StreamSupport.stream(this, false) : StreamSupport.stream(this.buffer.spliterator(), false);
            }
            throw new IllegalStateException();
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> consumer) {
            Objects.requireNonNull(consumer);
            if (this.count == -2) {
                consumer.accept(this.first);
                this.count = -1;
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(Consumer<? super T> consumer) {
            Objects.requireNonNull(consumer);
            if (this.count == -2) {
                consumer.accept(this.first);
                this.count = -1;
            }
        }
    }

    private static abstract class AbstractStreamBuilderImpl<T, S extends Spliterator<T>>
    implements Spliterator<T> {
        int count;

        private AbstractStreamBuilderImpl() {
        }

        public S trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return -this.count - 1;
        }

        @Override
        public int characteristics() {
            return 17488;
        }
    }

    static final class RangeLongSpliterator
    implements Spliterator.OfLong {
        private long from;
        private final long upTo;
        private int last;
        private static final long BALANCED_SPLIT_THRESHOLD = 0x1000000L;
        private static final long RIGHT_BALANCED_SPLIT_RATIO = 8L;

        RangeLongSpliterator(long l, long l2, boolean bl) {
            this(l, l2, bl ? 1 : 0);
        }

        private RangeLongSpliterator(long l, long l2, int n) {
            assert (l2 - l + (long)n > 0L);
            this.from = l;
            this.upTo = l2;
            this.last = n;
        }

        @Override
        public boolean tryAdvance(LongConsumer longConsumer) {
            Objects.requireNonNull(longConsumer);
            long l = this.from++;
            if (l < this.upTo) {
                longConsumer.accept(l);
                return true;
            }
            if (this.last > 0) {
                this.last = 0;
                longConsumer.accept(l);
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(LongConsumer longConsumer) {
            Objects.requireNonNull(longConsumer);
            long l = this.from;
            long l2 = this.upTo;
            int n = this.last;
            this.from = this.upTo;
            this.last = 0;
            while (l < l2) {
                longConsumer.accept(l++);
            }
            if (n > 0) {
                longConsumer.accept(l);
            }
        }

        @Override
        public long estimateSize() {
            return this.upTo - this.from + (long)this.last;
        }

        @Override
        public int characteristics() {
            return 17749;
        }

        @Override
        public Comparator<? super Long> getComparator() {
            return null;
        }

        @Override
        public Spliterator.OfLong trySplit() {
            long l = this.estimateSize();
            return l <= 1L ? null : new RangeLongSpliterator(this.from, this.from += this.splitPoint(l), 0);
        }

        private long splitPoint(long l) {
            long l2 = l < 0x1000000L ? 2L : 8L;
            return l / l2;
        }
    }

    static final class RangeIntSpliterator
    implements Spliterator.OfInt {
        int from;
        final int upTo;
        int last;
        private static final int BALANCED_SPLIT_THRESHOLD = 0x1000000;
        private static final int RIGHT_BALANCED_SPLIT_RATIO = 8;

        RangeIntSpliterator(int n, int n2, boolean bl) {
            this(n, n2, bl ? 1 : 0);
        }

        private RangeIntSpliterator(int n, int n2, int n3) {
            this.from = n;
            this.upTo = n2;
            this.last = n3;
        }

        @Override
        public boolean tryAdvance(IntConsumer intConsumer) {
            Objects.requireNonNull(intConsumer);
            int n = this.from++;
            if (n < this.upTo) {
                intConsumer.accept(n);
                return true;
            }
            if (this.last > 0) {
                this.last = 0;
                intConsumer.accept(n);
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(IntConsumer intConsumer) {
            Objects.requireNonNull(intConsumer);
            int n = this.from;
            int n2 = this.upTo;
            int n3 = this.last;
            this.from = this.upTo;
            this.last = 0;
            while (n < n2) {
                intConsumer.accept(n++);
            }
            if (n3 > 0) {
                intConsumer.accept(n);
            }
        }

        @Override
        public long estimateSize() {
            return (long)this.upTo - (long)this.from + (long)this.last;
        }

        @Override
        public int characteristics() {
            return 17749;
        }

        @Override
        public Comparator<? super Integer> getComparator() {
            return null;
        }

        @Override
        public Spliterator.OfInt trySplit() {
            long l = this.estimateSize();
            return l <= 1L ? null : new RangeIntSpliterator(this.from, this.from += this.splitPoint(l), 0);
        }

        private int splitPoint(long l) {
            int n = l < 0x1000000L ? 2 : 8;
            return (int)(l / (long)n);
        }
    }
}

