/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.security.AccessController;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IllformedLocaleException;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyPermission;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.spi.LocaleNameProvider;
import sun.security.action.GetPropertyAction;
import sun.util.locale.BaseLocale;
import sun.util.locale.InternalLocaleBuilder;
import sun.util.locale.LanguageTag;
import sun.util.locale.LocaleExtensions;
import sun.util.locale.LocaleMatcher;
import sun.util.locale.LocaleObjectCache;
import sun.util.locale.LocaleSyntaxException;
import sun.util.locale.LocaleUtils;
import sun.util.locale.ParseStatus;
import sun.util.locale.provider.LocaleProviderAdapter;
import sun.util.locale.provider.LocaleResources;
import sun.util.locale.provider.LocaleServiceProviderPool;

public final class Locale
implements Cloneable,
Serializable {
    private static final Cache LOCALECACHE = new Cache();
    public static final Locale ENGLISH = Locale.createConstant("en", "");
    public static final Locale FRENCH = Locale.createConstant("fr", "");
    public static final Locale GERMAN = Locale.createConstant("de", "");
    public static final Locale ITALIAN = Locale.createConstant("it", "");
    public static final Locale JAPANESE = Locale.createConstant("ja", "");
    public static final Locale KOREAN = Locale.createConstant("ko", "");
    public static final Locale CHINESE = Locale.createConstant("zh", "");
    public static final Locale SIMPLIFIED_CHINESE = Locale.createConstant("zh", "CN");
    public static final Locale TRADITIONAL_CHINESE = Locale.createConstant("zh", "TW");
    public static final Locale FRANCE = Locale.createConstant("fr", "FR");
    public static final Locale GERMANY = Locale.createConstant("de", "DE");
    public static final Locale ITALY = Locale.createConstant("it", "IT");
    public static final Locale JAPAN = Locale.createConstant("ja", "JP");
    public static final Locale KOREA = Locale.createConstant("ko", "KR");
    public static final Locale CHINA = SIMPLIFIED_CHINESE;
    public static final Locale PRC = SIMPLIFIED_CHINESE;
    public static final Locale TAIWAN = TRADITIONAL_CHINESE;
    public static final Locale UK = Locale.createConstant("en", "GB");
    public static final Locale US = Locale.createConstant("en", "US");
    public static final Locale CANADA = Locale.createConstant("en", "CA");
    public static final Locale CANADA_FRENCH = Locale.createConstant("fr", "CA");
    public static final Locale ROOT = Locale.createConstant("", "");
    public static final char PRIVATE_USE_EXTENSION = 'x';
    public static final char UNICODE_LOCALE_EXTENSION = 'u';
    static final long serialVersionUID = 9149081749638150636L;
    private static final int DISPLAY_LANGUAGE = 0;
    private static final int DISPLAY_COUNTRY = 1;
    private static final int DISPLAY_VARIANT = 2;
    private static final int DISPLAY_SCRIPT = 3;
    private transient BaseLocale baseLocale;
    private transient LocaleExtensions localeExtensions;
    private volatile transient int hashCodeValue = 0;
    private static volatile Locale defaultLocale = Locale.initDefault();
    private static volatile Locale defaultDisplayLocale = null;
    private static volatile Locale defaultFormatLocale = null;
    private volatile transient String languageTag;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("language", String.class), new ObjectStreamField("country", String.class), new ObjectStreamField("variant", String.class), new ObjectStreamField("hashcode", Integer.TYPE), new ObjectStreamField("script", String.class), new ObjectStreamField("extensions", String.class)};
    private static volatile String[] isoLanguages = null;
    private static volatile String[] isoCountries = null;

    private Locale(BaseLocale baseLocale, LocaleExtensions localeExtensions) {
        this.baseLocale = baseLocale;
        this.localeExtensions = localeExtensions;
    }

    public Locale(String string, String string2, String string3) {
        if (string == null || string2 == null || string3 == null) {
            throw new NullPointerException();
        }
        this.baseLocale = BaseLocale.getInstance(Locale.convertOldISOCodes(string), "", string2, string3);
        this.localeExtensions = Locale.getCompatibilityExtensions(string, "", string2, string3);
    }

    public Locale(String string, String string2) {
        this(string, string2, "");
    }

    public Locale(String string) {
        this(string, "", "");
    }

    private static Locale createConstant(String string, String string2) {
        BaseLocale baseLocale = BaseLocale.createInstance(string, string2);
        return Locale.getInstance(baseLocale, null);
    }

    static Locale getInstance(String string, String string2, String string3) {
        return Locale.getInstance(string, "", string2, string3, null);
    }

    static Locale getInstance(String string, String string2, String string3, String string4, LocaleExtensions localeExtensions) {
        if (string == null || string2 == null || string3 == null || string4 == null) {
            throw new NullPointerException();
        }
        if (localeExtensions == null) {
            localeExtensions = Locale.getCompatibilityExtensions(string, string2, string3, string4);
        }
        BaseLocale baseLocale = BaseLocale.getInstance(string, string2, string3, string4);
        return Locale.getInstance(baseLocale, localeExtensions);
    }

    static Locale getInstance(BaseLocale baseLocale, LocaleExtensions localeExtensions) {
        LocaleKey localeKey = new LocaleKey(baseLocale, localeExtensions);
        return (Locale)LOCALECACHE.get(localeKey);
    }

    public static Locale getDefault() {
        return defaultLocale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Locale getDefault(Category category) {
        switch (category) {
            case DISPLAY: {
                if (defaultDisplayLocale != null) return defaultDisplayLocale;
                Class<Locale> clazz = Locale.class;
                synchronized (Locale.class) {
                    if (defaultDisplayLocale != null) return defaultDisplayLocale;
                    defaultDisplayLocale = Locale.initDefault(category);
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return defaultDisplayLocale;
                }
            }
            case FORMAT: {
                if (defaultFormatLocale != null) return defaultFormatLocale;
                Class<Locale> clazz = Locale.class;
                synchronized (Locale.class) {
                    if (defaultFormatLocale != null) return defaultFormatLocale;
                    defaultFormatLocale = Locale.initDefault(category);
                    // ** MonitorExit[var1_2] (shouldn't be in output)
                    return defaultFormatLocale;
                }
            }
        }
        assert (false) : "Unknown Category";
        return Locale.getDefault();
    }

    private static Locale initDefault() {
        String string;
        String string2;
        String string3;
        String string4 = AccessController.doPrivileged(new GetPropertyAction("user.language", "en"));
        String string5 = AccessController.doPrivileged(new GetPropertyAction("user.region"));
        if (string5 != null) {
            int n = string5.indexOf(95);
            if (n >= 0) {
                string3 = string5.substring(0, n);
                string2 = string5.substring(n + 1);
            } else {
                string3 = string5;
                string2 = "";
            }
            string = "";
        } else {
            string = AccessController.doPrivileged(new GetPropertyAction("user.script", ""));
            string3 = AccessController.doPrivileged(new GetPropertyAction("user.country", ""));
            string2 = AccessController.doPrivileged(new GetPropertyAction("user.variant", ""));
        }
        return Locale.getInstance(string4, string, string3, string2, null);
    }

    private static Locale initDefault(Category category) {
        return Locale.getInstance(AccessController.doPrivileged(new GetPropertyAction(category.languageKey, defaultLocale.getLanguage())), AccessController.doPrivileged(new GetPropertyAction(category.scriptKey, defaultLocale.getScript())), AccessController.doPrivileged(new GetPropertyAction(category.countryKey, defaultLocale.getCountry())), AccessController.doPrivileged(new GetPropertyAction(category.variantKey, defaultLocale.getVariant())), null);
    }

    public static synchronized void setDefault(Locale locale) {
        Locale.setDefault(Category.DISPLAY, locale);
        Locale.setDefault(Category.FORMAT, locale);
        defaultLocale = locale;
    }

    public static synchronized void setDefault(Category category, Locale locale) {
        if (category == null) {
            throw new NullPointerException("Category cannot be NULL");
        }
        if (locale == null) {
            throw new NullPointerException("Can't set default locale to NULL");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new PropertyPermission("user.language", "write"));
        }
        switch (category) {
            case DISPLAY: {
                defaultDisplayLocale = locale;
                break;
            }
            case FORMAT: {
                defaultFormatLocale = locale;
                break;
            }
            default: {
                assert (false) : "Unknown Category";
                break;
            }
        }
    }

    public static Locale[] getAvailableLocales() {
        return LocaleServiceProviderPool.getAllAvailableLocales();
    }

    public static String[] getISOCountries() {
        if (isoCountries == null) {
            isoCountries = Locale.getISO2Table("ADANDAEAREAFAFGAGATGAIAIAALALBAMARMANANTAOAGOAQATAARARGASASMATAUTAUAUSAWABWAXALAAZAZEBABIHBBBRBBDBGDBEBELBFBFABGBGRBHBHRBIBDIBJBENBLBLMBMBMUBNBRNBOBOLBQBESBRBRABSBHSBTBTNBVBVTBWBWABYBLRBZBLZCACANCCCCKCDCODCFCAFCGCOGCHCHECICIVCKCOKCLCHLCMCMRCNCHNCOCOLCRCRICUCUBCVCPVCWCUWCXCXRCYCYPCZCZEDEDEUDJDJIDKDNKDMDMADODOMDZDZAECECUEEESTEGEGYEHESHERERIESESPETETHFIFINFJFJIFKFLKFMFSMFOFROFRFRAGAGABGBGBRGDGRDGEGEOGFGUFGGGGYGHGHAGIGIBGLGRLGMGMBGNGINGPGLPGQGNQGRGRCGSSGSGTGTMGUGUMGWGNBGYGUYHKHKGHMHMDHNHNDHRHRVHTHTIHUHUNIDIDNIEIRLILISRIMIMNININDIOIOTIQIRQIRIRNISISLITITAJEJEYJMJAMJOJORJPJPNKEKENKGKGZKHKHMKIKIRKMCOMKNKNAKPPRKKRKORKWKWTKYCYMKZKAZLALAOLBLBNLCLCALILIELKLKALRLBRLSLSOLTLTULULUXLVLVALYLBYMAMARMCMCOMDMDAMEMNEMFMAFMGMDGMHMHLMKMKDMLMLIMMMMRMNMNGMOMACMPMNPMQMTQMRMRTMSMSRMTMLTMUMUSMVMDVMWMWIMXMEXMYMYSMZMOZNANAMNCNCLNENERNFNFKNGNGANINICNLNLDNONORNPNPLNRNRUNUNIUNZNZLOMOMNPAPANPEPERPFPYFPGPNGPHPHLPKPAKPLPOLPMSPMPNPCNPRPRIPSPSEPTPRTPWPLWPYPRYQAQATREREUROROURSSRBRURUSRWRWASASAUSBSLBSCSYCSDSDNSESWESGSGPSHSHNSISVNSJSJMSKSVKSLSLESMSMRSNSENSOSOMSRSURSSSSDSTSTPSVSLVSXSXMSYSYRSZSWZTCTCATDTCDTFATFTGTGOTHTHATJTJKTKTKLTLTLSTMTKMTNTUNTOTONTRTURTTTTOTVTUVTWTWNTZTZAUAUKRUGUGAUMUMIUSUSAUYURYUZUZBVAVATVCVCTVEVENVGVGBVIVIRVNVNMVUVUTWFWLFWSWSMYEYEMYTMYTZAZAFZMZMBZWZWE");
        }
        String[] stringArray = new String[isoCountries.length];
        System.arraycopy((Object)isoCountries, 0, (Object)stringArray, 0, isoCountries.length);
        return stringArray;
    }

    public static String[] getISOLanguages() {
        if (isoLanguages == null) {
            isoLanguages = Locale.getISO2Table("aaaarababkaeaveafafrakakaamamhanargararaasasmavavaayaymazazebabakbebelbgbulbhbihbibisbmbambnbenbobodbrbrebsboscacatcechechchacocoscrcrecscescuchucvchvcycymdadandedeudvdivdzdzoeeeweelellenengeoepoesspaetesteueusfafasfffulfifinfjfijfofaofrfrafyfrygaglegdglaglglggngrngugujgvglvhahauhehebhihinhohmohrhrvhthathuhunhyhyehzheriainaidindieileigiboiiiiiikipkinindioidoisislititaiuikuiwhebjajpnjiyidjvjavkakatkgkonkikikkjkuakkkazklkalkmkhmknkankokorkrkaukskaskukurkvkomkwcorkykirlalatlbltzlgluglilimlnlinlolaoltlitlulublvlavmgmlgmhmahmimrimkmkdmlmalmnmonmomolmrmarmsmsamtmltmymyananaunbnobndndenenepngndonlnldnnnnononornrnblnvnavnynyaocociojojiomormororiososspapanpipliplpolpspusptporququermrohrnrunroronrurusrwkinsasanscsrdsdsndsesmesgsagsisinskslkslslvsmsmosnsnasosomsqsqisrsrpsssswstsotsusunsvsweswswatatamteteltgtgkththatitirtktuktltgltntsntotontrturtstsotttattwtwitytahuguigukukrururduzuzbvevenvivievovolwawlnwowolxhxhoyiyidyoyorzazhazhzhozuzul");
        }
        String[] stringArray = new String[isoLanguages.length];
        System.arraycopy((Object)isoLanguages, 0, (Object)stringArray, 0, isoLanguages.length);
        return stringArray;
    }

    private static String[] getISO2Table(String string) {
        int n = string.length() / 5;
        String[] stringArray = new String[n];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            stringArray[n2] = string.substring(n3, n3 + 2);
            ++n2;
            n3 += 5;
        }
        return stringArray;
    }

    public String getLanguage() {
        return this.baseLocale.getLanguage();
    }

    public String getScript() {
        return this.baseLocale.getScript();
    }

    public String getCountry() {
        return this.baseLocale.getRegion();
    }

    public String getVariant() {
        return this.baseLocale.getVariant();
    }

    public boolean hasExtensions() {
        return this.localeExtensions != null;
    }

    public Locale stripExtensions() {
        return this.hasExtensions() ? Locale.getInstance(this.baseLocale, null) : this;
    }

    public String getExtension(char c) {
        if (!LocaleExtensions.isValidKey(c)) {
            throw new IllegalArgumentException("Ill-formed extension key: " + c);
        }
        return this.hasExtensions() ? this.localeExtensions.getExtensionValue(Character.valueOf(c)) : null;
    }

    public Set<Character> getExtensionKeys() {
        if (!this.hasExtensions()) {
            return Collections.emptySet();
        }
        return this.localeExtensions.getKeys();
    }

    public Set<String> getUnicodeLocaleAttributes() {
        if (!this.hasExtensions()) {
            return Collections.emptySet();
        }
        return this.localeExtensions.getUnicodeLocaleAttributes();
    }

    public String getUnicodeLocaleType(String string) {
        if (!Locale.isUnicodeExtensionKey(string)) {
            throw new IllegalArgumentException("Ill-formed Unicode locale key: " + string);
        }
        return this.hasExtensions() ? this.localeExtensions.getUnicodeLocaleType(string) : null;
    }

    public Set<String> getUnicodeLocaleKeys() {
        if (this.localeExtensions == null) {
            return Collections.emptySet();
        }
        return this.localeExtensions.getUnicodeLocaleKeys();
    }

    BaseLocale getBaseLocale() {
        return this.baseLocale;
    }

    LocaleExtensions getLocaleExtensions() {
        return this.localeExtensions;
    }

    public final String toString() {
        boolean bl = this.baseLocale.getLanguage().length() != 0;
        boolean bl2 = this.baseLocale.getScript().length() != 0;
        boolean bl3 = this.baseLocale.getRegion().length() != 0;
        boolean bl4 = this.baseLocale.getVariant().length() != 0;
        boolean bl5 = this.localeExtensions != null && this.localeExtensions.getID().length() != 0;
        StringBuilder stringBuilder = new StringBuilder(this.baseLocale.getLanguage());
        if (bl3 || bl && (bl4 || bl2 || bl5)) {
            stringBuilder.append('_').append(this.baseLocale.getRegion());
        }
        if (bl4 && (bl || bl3)) {
            stringBuilder.append('_').append(this.baseLocale.getVariant());
        }
        if (bl2 && (bl || bl3)) {
            stringBuilder.append("_#").append(this.baseLocale.getScript());
        }
        if (bl5 && (bl || bl3)) {
            stringBuilder.append('_');
            if (!bl2) {
                stringBuilder.append('#');
            }
            stringBuilder.append(this.localeExtensions.getID());
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toLanguageTag() {
        if (this.languageTag != null) {
            return this.languageTag;
        }
        LanguageTag languageTag = LanguageTag.parseLocale(this.baseLocale, this.localeExtensions);
        StringBuilder stringBuilder = new StringBuilder();
        String string = languageTag.getLanguage();
        if (string.length() > 0) {
            stringBuilder.append(LanguageTag.canonicalizeLanguage(string));
        }
        if ((string = languageTag.getScript()).length() > 0) {
            stringBuilder.append("-");
            stringBuilder.append(LanguageTag.canonicalizeScript(string));
        }
        if ((string = languageTag.getRegion()).length() > 0) {
            stringBuilder.append("-");
            stringBuilder.append(LanguageTag.canonicalizeRegion(string));
        }
        List<String> list = languageTag.getVariants();
        for (String object2 : list) {
            stringBuilder.append("-");
            stringBuilder.append(object2);
        }
        list = languageTag.getExtensions();
        for (String string2 : list) {
            stringBuilder.append("-");
            stringBuilder.append(LanguageTag.canonicalizeExtension(string2));
        }
        string = languageTag.getPrivateuse();
        if (string.length() > 0) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("-");
            }
            stringBuilder.append("x").append("-");
            stringBuilder.append(string);
        }
        String string2 = stringBuilder.toString();
        Locale locale = this;
        synchronized (locale) {
            if (this.languageTag == null) {
                this.languageTag = string2;
            }
        }
        return this.languageTag;
    }

    public static Locale forLanguageTag(String string) {
        LanguageTag languageTag = LanguageTag.parse(string, null);
        InternalLocaleBuilder internalLocaleBuilder = new InternalLocaleBuilder();
        internalLocaleBuilder.setLanguageTag(languageTag);
        BaseLocale baseLocale = internalLocaleBuilder.getBaseLocale();
        LocaleExtensions localeExtensions = internalLocaleBuilder.getLocaleExtensions();
        if (localeExtensions == null && baseLocale.getVariant().length() > 0) {
            localeExtensions = Locale.getCompatibilityExtensions(baseLocale.getLanguage(), baseLocale.getScript(), baseLocale.getRegion(), baseLocale.getVariant());
        }
        return Locale.getInstance(baseLocale, localeExtensions);
    }

    public String getISO3Language() throws MissingResourceException {
        String string = this.baseLocale.getLanguage();
        if (string.length() == 3) {
            return string;
        }
        String string2 = Locale.getISO3Code(string, "aaaarababkaeaveafafrakakaamamhanargararaasasmavavaayaymazazebabakbebelbgbulbhbihbibisbmbambnbenbobodbrbrebsboscacatcechechchacocoscrcrecscescuchucvchvcycymdadandedeudvdivdzdzoeeeweelellenengeoepoesspaetesteueusfafasfffulfifinfjfijfofaofrfrafyfrygaglegdglaglglggngrngugujgvglvhahauhehebhihinhohmohrhrvhthathuhunhyhyehzheriainaidindieileigiboiiiiiikipkinindioidoisislititaiuikuiwhebjajpnjiyidjvjavkakatkgkonkikikkjkuakkkazklkalkmkhmknkankokorkrkaukskaskukurkvkomkwcorkykirlalatlbltzlgluglilimlnlinlolaoltlitlulublvlavmgmlgmhmahmimrimkmkdmlmalmnmonmomolmrmarmsmsamtmltmymyananaunbnobndndenenepngndonlnldnnnnononornrnblnvnavnynyaocociojojiomormororiososspapanpipliplpolpspusptporququermrohrnrunroronrurusrwkinsasanscsrdsdsndsesmesgsagsisinskslkslslvsmsmosnsnasosomsqsqisrsrpsssswstsotsusunsvsweswswatatamteteltgtgkththatitirtktuktltgltntsntotontrturtstsotttattwtwitytahuguigukukrururduzuzbvevenvivievovolwawlnwowolxhxhoyiyidyoyorzazhazhzhozuzul");
        if (string2 == null) {
            throw new MissingResourceException("Couldn't find 3-letter language code for " + string, "FormatData_" + this.toString(), "ShortLanguage");
        }
        return string2;
    }

    public String getISO3Country() throws MissingResourceException {
        String string = Locale.getISO3Code(this.baseLocale.getRegion(), "ADANDAEAREAFAFGAGATGAIAIAALALBAMARMANANTAOAGOAQATAARARGASASMATAUTAUAUSAWABWAXALAAZAZEBABIHBBBRBBDBGDBEBELBFBFABGBGRBHBHRBIBDIBJBENBLBLMBMBMUBNBRNBOBOLBQBESBRBRABSBHSBTBTNBVBVTBWBWABYBLRBZBLZCACANCCCCKCDCODCFCAFCGCOGCHCHECICIVCKCOKCLCHLCMCMRCNCHNCOCOLCRCRICUCUBCVCPVCWCUWCXCXRCYCYPCZCZEDEDEUDJDJIDKDNKDMDMADODOMDZDZAECECUEEESTEGEGYEHESHERERIESESPETETHFIFINFJFJIFKFLKFMFSMFOFROFRFRAGAGABGBGBRGDGRDGEGEOGFGUFGGGGYGHGHAGIGIBGLGRLGMGMBGNGINGPGLPGQGNQGRGRCGSSGSGTGTMGUGUMGWGNBGYGUYHKHKGHMHMDHNHNDHRHRVHTHTIHUHUNIDIDNIEIRLILISRIMIMNININDIOIOTIQIRQIRIRNISISLITITAJEJEYJMJAMJOJORJPJPNKEKENKGKGZKHKHMKIKIRKMCOMKNKNAKPPRKKRKORKWKWTKYCYMKZKAZLALAOLBLBNLCLCALILIELKLKALRLBRLSLSOLTLTULULUXLVLVALYLBYMAMARMCMCOMDMDAMEMNEMFMAFMGMDGMHMHLMKMKDMLMLIMMMMRMNMNGMOMACMPMNPMQMTQMRMRTMSMSRMTMLTMUMUSMVMDVMWMWIMXMEXMYMYSMZMOZNANAMNCNCLNENERNFNFKNGNGANINICNLNLDNONORNPNPLNRNRUNUNIUNZNZLOMOMNPAPANPEPERPFPYFPGPNGPHPHLPKPAKPLPOLPMSPMPNPCNPRPRIPSPSEPTPRTPWPLWPYPRYQAQATREREUROROURSSRBRURUSRWRWASASAUSBSLBSCSYCSDSDNSESWESGSGPSHSHNSISVNSJSJMSKSVKSLSLESMSMRSNSENSOSOMSRSURSSSSDSTSTPSVSLVSXSXMSYSYRSZSWZTCTCATDTCDTFATFTGTGOTHTHATJTJKTKTKLTLTLSTMTKMTNTUNTOTONTRTURTTTTOTVTUVTWTWNTZTZAUAUKRUGUGAUMUMIUSUSAUYURYUZUZBVAVATVCVCTVEVENVGVGBVIVIRVNVNMVUVUTWFWLFWSWSMYEYEMYTMYTZAZAFZMZMBZWZWE");
        if (string == null) {
            throw new MissingResourceException("Couldn't find 3-letter country code for " + this.baseLocale.getRegion(), "FormatData_" + this.toString(), "ShortCountry");
        }
        return string;
    }

    private static String getISO3Code(String string, String string2) {
        int n;
        int n2 = string.length();
        if (n2 == 0) {
            return "";
        }
        int n3 = n = string2.length();
        if (n2 == 2) {
            char c = string.charAt(0);
            char c2 = string.charAt(1);
            for (n3 = 0; n3 < n && (string2.charAt(n3) != c || string2.charAt(n3 + 1) != c2); n3 += 5) {
            }
        }
        return n3 < n ? string2.substring(n3 + 2, n3 + 5) : null;
    }

    public final String getDisplayLanguage() {
        return this.getDisplayLanguage(Locale.getDefault(Category.DISPLAY));
    }

    public String getDisplayLanguage(Locale locale) {
        return this.getDisplayString(this.baseLocale.getLanguage(), locale, 0);
    }

    public String getDisplayScript() {
        return this.getDisplayScript(Locale.getDefault(Category.DISPLAY));
    }

    public String getDisplayScript(Locale locale) {
        return this.getDisplayString(this.baseLocale.getScript(), locale, 3);
    }

    public final String getDisplayCountry() {
        return this.getDisplayCountry(Locale.getDefault(Category.DISPLAY));
    }

    public String getDisplayCountry(Locale locale) {
        return this.getDisplayString(this.baseLocale.getRegion(), locale, 1);
    }

    private String getDisplayString(String string, Locale locale, int n) {
        if (string.length() == 0) {
            return "";
        }
        if (locale == null) {
            throw new NullPointerException();
        }
        LocaleServiceProviderPool localeServiceProviderPool = LocaleServiceProviderPool.getPool(LocaleNameProvider.class);
        String string2 = n == 2 ? "%%" + string : string;
        String string3 = localeServiceProviderPool.getLocalizedObject(LocaleNameGetter.INSTANCE, locale, string2, n, string);
        if (string3 != null) {
            return string3;
        }
        return string;
    }

    public final String getDisplayVariant() {
        return this.getDisplayVariant(Locale.getDefault(Category.DISPLAY));
    }

    public String getDisplayVariant(Locale locale) {
        if (this.baseLocale.getVariant().length() == 0) {
            return "";
        }
        LocaleResources localeResources = LocaleProviderAdapter.forJRE().getLocaleResources(locale);
        String[] stringArray = this.getDisplayVariantArray(locale);
        return Locale.formatList(stringArray, localeResources.getLocaleName("ListPattern"), localeResources.getLocaleName("ListCompositionPattern"));
    }

    public final String getDisplayName() {
        return this.getDisplayName(Locale.getDefault(Category.DISPLAY));
    }

    public String getDisplayName(Locale locale) {
        LocaleResources localeResources = LocaleProviderAdapter.forJRE().getLocaleResources(locale);
        String string = this.getDisplayLanguage(locale);
        String string2 = this.getDisplayScript(locale);
        String string3 = this.getDisplayCountry(locale);
        String[] stringArray = this.getDisplayVariantArray(locale);
        String string4 = localeResources.getLocaleName("DisplayNamePattern");
        String string5 = localeResources.getLocaleName("ListPattern");
        String string6 = localeResources.getLocaleName("ListCompositionPattern");
        String string7 = null;
        String[] stringArray2 = null;
        if (string.length() == 0 && string2.length() == 0 && string3.length() == 0) {
            if (stringArray.length == 0) {
                return "";
            }
            return Locale.formatList(stringArray, string5, string6);
        }
        ArrayList<String> arrayList = new ArrayList<String>(4);
        if (string.length() != 0) {
            arrayList.add(string);
        }
        if (string2.length() != 0) {
            arrayList.add(string2);
        }
        if (string3.length() != 0) {
            arrayList.add(string3);
        }
        if (stringArray.length != 0) {
            arrayList.addAll(Arrays.asList(stringArray));
        }
        string7 = (String)arrayList.get(0);
        int n = arrayList.size();
        stringArray2 = n > 1 ? arrayList.subList(1, n).toArray(new String[n - 1]) : new String[]{};
        Object[] objectArray = new Object[]{new Integer(stringArray2.length != 0 ? 2 : 1), string7, stringArray2.length != 0 ? Locale.formatList(stringArray2, string5, string6) : null};
        if (string4 != null) {
            return new MessageFormat(string4).format(objectArray);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((String)objectArray[1]);
        if (objectArray.length > 2) {
            stringBuilder.append(" (");
            stringBuilder.append((String)objectArray[2]);
            stringBuilder.append(')');
        }
        return stringBuilder.toString();
    }

    public Object clone() {
        try {
            Locale locale = (Locale)super.clone();
            return locale;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException);
        }
    }

    public int hashCode() {
        int n = this.hashCodeValue;
        if (n == 0) {
            n = this.baseLocale.hashCode();
            if (this.localeExtensions != null) {
                n ^= this.localeExtensions.hashCode();
            }
            this.hashCodeValue = n;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Locale)) {
            return false;
        }
        BaseLocale baseLocale = ((Locale)object).baseLocale;
        if (!this.baseLocale.equals(baseLocale)) {
            return false;
        }
        if (this.localeExtensions == null) {
            return ((Locale)object).localeExtensions == null;
        }
        return this.localeExtensions.equals(((Locale)object).localeExtensions);
    }

    private String[] getDisplayVariantArray(Locale locale) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.baseLocale.getVariant(), "_");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.getDisplayString(stringTokenizer.nextToken(), locale, 2);
        }
        return stringArray;
    }

    private static String formatList(String[] stringArray, String string, String string2) {
        Object[] objectArray;
        if (string == null || string2 == null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(stringArray[i]);
            }
            return stringBuilder.toString();
        }
        if (stringArray.length > 3) {
            objectArray = new MessageFormat(string2);
            stringArray = Locale.composeList((MessageFormat)objectArray, stringArray);
        }
        objectArray = new Object[stringArray.length + 1];
        System.arraycopy((Object)stringArray, 0, (Object)objectArray, 1, stringArray.length);
        objectArray[0] = new Integer(stringArray.length);
        MessageFormat messageFormat = new MessageFormat(string);
        return messageFormat.format(objectArray);
    }

    private static String[] composeList(MessageFormat messageFormat, String[] stringArray) {
        if (stringArray.length <= 3) {
            return stringArray;
        }
        String[] stringArray2 = new String[]{stringArray[0], stringArray[1]};
        String string = messageFormat.format(stringArray2);
        String[] stringArray3 = new String[stringArray.length - 1];
        System.arraycopy((Object)stringArray, 2, (Object)stringArray3, 1, stringArray3.length - 1);
        stringArray3[0] = string;
        return Locale.composeList(messageFormat, stringArray3);
    }

    private static boolean isUnicodeExtensionKey(String string) {
        return string.length() == 2 && LocaleUtils.isAlphaNumericString(string);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("language", this.baseLocale.getLanguage());
        putField.put("script", this.baseLocale.getScript());
        putField.put("country", this.baseLocale.getRegion());
        putField.put("variant", this.baseLocale.getVariant());
        putField.put("extensions", this.localeExtensions == null ? "" : this.localeExtensions.getID());
        putField.put("hashcode", -1);
        objectOutputStream.writeFields();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        String string = (String)getField.get("language", "");
        String string2 = (String)getField.get("script", "");
        String string3 = (String)getField.get("country", "");
        String string4 = (String)getField.get("variant", "");
        String string5 = (String)getField.get("extensions", "");
        this.baseLocale = BaseLocale.getInstance(Locale.convertOldISOCodes(string), string2, string3, string4);
        if (string5.length() > 0) {
            try {
                InternalLocaleBuilder internalLocaleBuilder = new InternalLocaleBuilder();
                internalLocaleBuilder.setExtensions(string5);
                this.localeExtensions = internalLocaleBuilder.getLocaleExtensions();
            }
            catch (LocaleSyntaxException localeSyntaxException) {
                throw new IllformedLocaleException(localeSyntaxException.getMessage());
            }
        } else {
            this.localeExtensions = null;
        }
    }

    private Object readResolve() throws ObjectStreamException {
        return Locale.getInstance(this.baseLocale.getLanguage(), this.baseLocale.getScript(), this.baseLocale.getRegion(), this.baseLocale.getVariant(), this.localeExtensions);
    }

    private static String convertOldISOCodes(String string) {
        if ((string = LocaleUtils.toLowerString(string).intern()) == "he") {
            return "iw";
        }
        if (string == "yi") {
            return "ji";
        }
        if (string == "id") {
            return "in";
        }
        return string;
    }

    private static LocaleExtensions getCompatibilityExtensions(String string, String string2, String string3, String string4) {
        LocaleExtensions localeExtensions = null;
        if (LocaleUtils.caseIgnoreMatch(string, "ja") && string2.length() == 0 && LocaleUtils.caseIgnoreMatch(string3, "jp") && "JP".equals(string4)) {
            localeExtensions = LocaleExtensions.CALENDAR_JAPANESE;
        } else if (LocaleUtils.caseIgnoreMatch(string, "th") && string2.length() == 0 && LocaleUtils.caseIgnoreMatch(string3, "th") && "TH".equals(string4)) {
            localeExtensions = LocaleExtensions.NUMBER_THAI;
        }
        return localeExtensions;
    }

    public static List<Locale> filter(List<LanguageRange> list, Collection<Locale> collection, FilteringMode filteringMode) {
        return LocaleMatcher.filter(list, collection, filteringMode);
    }

    public static List<Locale> filter(List<LanguageRange> list, Collection<Locale> collection) {
        return Locale.filter(list, collection, FilteringMode.AUTOSELECT_FILTERING);
    }

    public static List<String> filterTags(List<LanguageRange> list, Collection<String> collection, FilteringMode filteringMode) {
        return LocaleMatcher.filterTags(list, collection, filteringMode);
    }

    public static List<String> filterTags(List<LanguageRange> list, Collection<String> collection) {
        return Locale.filterTags(list, collection, FilteringMode.AUTOSELECT_FILTERING);
    }

    public static Locale lookup(List<LanguageRange> list, Collection<Locale> collection) {
        return LocaleMatcher.lookup(list, collection);
    }

    public static String lookupTag(List<LanguageRange> list, Collection<String> collection) {
        return LocaleMatcher.lookupTag(list, collection);
    }

    public static final class LanguageRange {
        public static final double MAX_WEIGHT = 1.0;
        public static final double MIN_WEIGHT = 0.0;
        private final String range;
        private final double weight;
        private volatile int hash = 0;

        public LanguageRange(String string) {
            this(string, 1.0);
        }

        public LanguageRange(String string, double d) {
            if (string == null) {
                throw new NullPointerException();
            }
            if (d < 0.0 || d > 1.0) {
                throw new IllegalArgumentException("weight=" + d);
            }
            string = string.toLowerCase();
            boolean bl = false;
            String[] stringArray = string.split("-");
            if (LanguageRange.isSubtagIllFormed(stringArray[0], true) || string.endsWith("-")) {
                bl = true;
            } else {
                for (int i = 1; i < stringArray.length; ++i) {
                    if (!LanguageRange.isSubtagIllFormed(stringArray[i], false)) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) {
                throw new IllegalArgumentException("range=" + string);
            }
            this.range = string;
            this.weight = d;
        }

        private static boolean isSubtagIllFormed(String string, boolean bl) {
            if (string.equals("") || string.length() > 8) {
                return true;
            }
            if (string.equals("*")) {
                return false;
            }
            char[] cArray = string.toCharArray();
            if (bl) {
                for (char c : cArray) {
                    if (c >= 'a' && c <= 'z') continue;
                    return true;
                }
            } else {
                for (char c : cArray) {
                    if (c >= '0' && (c <= '9' || c >= 'a') && c <= 'z') continue;
                    return true;
                }
            }
            return false;
        }

        public String getRange() {
            return this.range;
        }

        public double getWeight() {
            return this.weight;
        }

        public static List<LanguageRange> parse(String string) {
            return LocaleMatcher.parse(string);
        }

        public static List<LanguageRange> parse(String string, Map<String, List<String>> map) {
            return LanguageRange.mapEquivalents(LanguageRange.parse(string), map);
        }

        public static List<LanguageRange> mapEquivalents(List<LanguageRange> list, Map<String, List<String>> map) {
            return LocaleMatcher.mapEquivalents(list, map);
        }

        public int hashCode() {
            if (this.hash == 0) {
                int n = 17;
                n = 37 * n + this.range.hashCode();
                long l = Double.doubleToLongBits(this.weight);
                this.hash = n = 37 * n + (int)(l ^ l >>> 32);
            }
            return this.hash;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof LanguageRange)) {
                return false;
            }
            LanguageRange languageRange = (LanguageRange)object;
            return this.hash == languageRange.hash && this.range.equals(languageRange.range) && this.weight == languageRange.weight;
        }
    }

    public static enum FilteringMode {
        AUTOSELECT_FILTERING,
        EXTENDED_FILTERING,
        IGNORE_EXTENDED_RANGES,
        MAP_EXTENDED_RANGES,
        REJECT_EXTENDED_RANGES;

    }

    public static final class Builder {
        private final InternalLocaleBuilder localeBuilder = new InternalLocaleBuilder();

        public Builder setLocale(Locale locale) {
            try {
                this.localeBuilder.setLocale(locale.baseLocale, locale.localeExtensions);
            }
            catch (LocaleSyntaxException localeSyntaxException) {
                throw new IllformedLocaleException(localeSyntaxException.getMessage(), localeSyntaxException.getErrorIndex());
            }
            return this;
        }

        public Builder setLanguageTag(String string) {
            ParseStatus parseStatus = new ParseStatus();
            LanguageTag languageTag = LanguageTag.parse(string, parseStatus);
            if (parseStatus.isError()) {
                throw new IllformedLocaleException(parseStatus.getErrorMessage(), parseStatus.getErrorIndex());
            }
            this.localeBuilder.setLanguageTag(languageTag);
            return this;
        }

        public Builder setLanguage(String string) {
            try {
                this.localeBuilder.setLanguage(string);
            }
            catch (LocaleSyntaxException localeSyntaxException) {
                throw new IllformedLocaleException(localeSyntaxException.getMessage(), localeSyntaxException.getErrorIndex());
            }
            return this;
        }

        public Builder setScript(String string) {
            try {
                this.localeBuilder.setScript(string);
            }
            catch (LocaleSyntaxException localeSyntaxException) {
                throw new IllformedLocaleException(localeSyntaxException.getMessage(), localeSyntaxException.getErrorIndex());
            }
            return this;
        }

        public Builder setRegion(String string) {
            try {
                this.localeBuilder.setRegion(string);
            }
            catch (LocaleSyntaxException localeSyntaxException) {
                throw new IllformedLocaleException(localeSyntaxException.getMessage(), localeSyntaxException.getErrorIndex());
            }
            return this;
        }

        public Builder setVariant(String string) {
            try {
                this.localeBuilder.setVariant(string);
            }
            catch (LocaleSyntaxException localeSyntaxException) {
                throw new IllformedLocaleException(localeSyntaxException.getMessage(), localeSyntaxException.getErrorIndex());
            }
            return this;
        }

        public Builder setExtension(char c, String string) {
            try {
                this.localeBuilder.setExtension(c, string);
            }
            catch (LocaleSyntaxException localeSyntaxException) {
                throw new IllformedLocaleException(localeSyntaxException.getMessage(), localeSyntaxException.getErrorIndex());
            }
            return this;
        }

        public Builder setUnicodeLocaleKeyword(String string, String string2) {
            try {
                this.localeBuilder.setUnicodeLocaleKeyword(string, string2);
            }
            catch (LocaleSyntaxException localeSyntaxException) {
                throw new IllformedLocaleException(localeSyntaxException.getMessage(), localeSyntaxException.getErrorIndex());
            }
            return this;
        }

        public Builder addUnicodeLocaleAttribute(String string) {
            try {
                this.localeBuilder.addUnicodeLocaleAttribute(string);
            }
            catch (LocaleSyntaxException localeSyntaxException) {
                throw new IllformedLocaleException(localeSyntaxException.getMessage(), localeSyntaxException.getErrorIndex());
            }
            return this;
        }

        public Builder removeUnicodeLocaleAttribute(String string) {
            try {
                this.localeBuilder.removeUnicodeLocaleAttribute(string);
            }
            catch (LocaleSyntaxException localeSyntaxException) {
                throw new IllformedLocaleException(localeSyntaxException.getMessage(), localeSyntaxException.getErrorIndex());
            }
            return this;
        }

        public Builder clear() {
            this.localeBuilder.clear();
            return this;
        }

        public Builder clearExtensions() {
            this.localeBuilder.clearExtensions();
            return this;
        }

        public Locale build() {
            BaseLocale baseLocale = this.localeBuilder.getBaseLocale();
            LocaleExtensions localeExtensions = this.localeBuilder.getLocaleExtensions();
            if (localeExtensions == null && baseLocale.getVariant().length() > 0) {
                localeExtensions = Locale.getCompatibilityExtensions(baseLocale.getLanguage(), baseLocale.getScript(), baseLocale.getRegion(), baseLocale.getVariant());
            }
            return Locale.getInstance(baseLocale, localeExtensions);
        }
    }

    public static enum Category {
        DISPLAY("user.language.display", "user.script.display", "user.country.display", "user.variant.display"),
        FORMAT("user.language.format", "user.script.format", "user.country.format", "user.variant.format");

        final String languageKey;
        final String scriptKey;
        final String countryKey;
        final String variantKey;

        private Category(String string2, String string3, String string4, String string5) {
            this.languageKey = string2;
            this.scriptKey = string3;
            this.countryKey = string4;
            this.variantKey = string5;
        }
    }

    private static class LocaleNameGetter
    implements LocaleServiceProviderPool.LocalizedObjectGetter<LocaleNameProvider, String> {
        private static final LocaleNameGetter INSTANCE = new LocaleNameGetter();

        private LocaleNameGetter() {
        }

        @Override
        public String getObject(LocaleNameProvider localeNameProvider, Locale locale, String string, Object ... objectArray) {
            assert (objectArray.length == 2);
            int n = (Integer)objectArray[0];
            String string2 = (String)objectArray[1];
            switch (n) {
                case 0: {
                    return localeNameProvider.getDisplayLanguage(string2, locale);
                }
                case 1: {
                    return localeNameProvider.getDisplayCountry(string2, locale);
                }
                case 2: {
                    return localeNameProvider.getDisplayVariant(string2, locale);
                }
                case 3: {
                    return localeNameProvider.getDisplayScript(string2, locale);
                }
            }
            assert (false);
            return null;
        }
    }

    private static final class LocaleKey {
        private final BaseLocale base;
        private final LocaleExtensions exts;
        private final int hash;

        private LocaleKey(BaseLocale baseLocale, LocaleExtensions localeExtensions) {
            this.base = baseLocale;
            this.exts = localeExtensions;
            int n = this.base.hashCode();
            if (this.exts != null) {
                n ^= this.exts.hashCode();
            }
            this.hash = n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof LocaleKey)) {
                return false;
            }
            LocaleKey localeKey = (LocaleKey)object;
            if (this.hash != localeKey.hash || !this.base.equals(localeKey.base)) {
                return false;
            }
            if (this.exts == null) {
                return localeKey.exts == null;
            }
            return this.exts.equals(localeKey.exts);
        }

        public int hashCode() {
            return this.hash;
        }
    }

    private static class Cache
    extends LocaleObjectCache<LocaleKey, Locale> {
        private Cache() {
        }

        @Override
        protected Locale createObject(LocaleKey localeKey) {
            return new Locale(localeKey.base, localeKey.exts);
        }
    }
}

