/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.HeapShortBufferR;
import java.nio.ShortBuffer;

class HeapShortBuffer
extends ShortBuffer {
    HeapShortBuffer(int n, int n2) {
        super(-1, 0, n2, n, new short[n], 0);
    }

    HeapShortBuffer(short[] sArray, int n, int n2) {
        super(-1, n, n + n2, sArray.length, sArray, 0);
    }

    protected HeapShortBuffer(short[] sArray, int n, int n2, int n3, int n4, int n5) {
        super(n, n2, n3, n4, sArray, n5);
    }

    @Override
    public ShortBuffer slice() {
        int n;
        int n2 = this.position();
        int n3 = n2 <= (n = this.limit()) ? n - n2 : 0;
        return new HeapShortBuffer(this.hb, -1, 0, n3, n3, n2 + this.offset);
    }

    @Override
    public ShortBuffer duplicate() {
        return new HeapShortBuffer(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    @Override
    public ShortBuffer asReadOnlyBuffer() {
        return new HeapShortBufferR(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    protected int ix(int n) {
        return n + this.offset;
    }

    @Override
    public short get() {
        return this.hb[this.ix(this.nextGetIndex())];
    }

    @Override
    public short get(int n) {
        return this.hb[this.ix(this.checkIndex(n))];
    }

    @Override
    public ShortBuffer get(short[] sArray, int n, int n2) {
        HeapShortBuffer.checkBounds(n, n2, sArray.length);
        int n3 = this.position();
        if (n2 > this.limit() - n3) {
            throw new BufferUnderflowException();
        }
        System.arraycopy((Object)this.hb, this.ix(n3), (Object)sArray, n, n2);
        this.position(n3 + n2);
        return this;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ShortBuffer put(short s) {
        this.hb[this.ix((int)this.nextPutIndex())] = s;
        return this;
    }

    @Override
    public ShortBuffer put(int n, short s) {
        this.hb[this.ix((int)this.checkIndex((int)n))] = s;
        return this;
    }

    @Override
    public ShortBuffer put(short[] sArray, int n, int n2) {
        HeapShortBuffer.checkBounds(n, n2, sArray.length);
        int n3 = this.position();
        if (n2 > this.limit() - n3) {
            throw new BufferOverflowException();
        }
        System.arraycopy((Object)sArray, n, (Object)this.hb, this.ix(n3), n2);
        this.position(n3 + n2);
        return this;
    }

    @Override
    public ShortBuffer put(ShortBuffer shortBuffer) {
        if (shortBuffer instanceof HeapShortBuffer) {
            if (shortBuffer == this) {
                throw new IllegalArgumentException();
            }
            HeapShortBuffer heapShortBuffer = (HeapShortBuffer)shortBuffer;
            int n = this.position();
            int n2 = heapShortBuffer.position();
            int n3 = heapShortBuffer.limit() - n2;
            if (n3 > this.limit() - n) {
                throw new BufferOverflowException();
            }
            System.arraycopy((Object)heapShortBuffer.hb, heapShortBuffer.ix(n2), (Object)this.hb, this.ix(n), n3);
            heapShortBuffer.position(n2 + n3);
            this.position(n + n3);
        } else if (shortBuffer.isDirect()) {
            int n = shortBuffer.remaining();
            int n4 = this.position();
            if (n > this.limit() - n4) {
                throw new BufferOverflowException();
            }
            shortBuffer.get(this.hb, this.ix(n4), n);
            this.position(n4 + n);
        } else {
            super.put(shortBuffer);
        }
        return this;
    }

    @Override
    public ShortBuffer compact() {
        int n = this.position();
        int n2 = this.limit() - n;
        System.arraycopy((Object)this.hb, this.ix(n), (Object)this.hb, this.ix(0), n2);
        this.position(n2);
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.nativeOrder();
    }
}

