/*
 * Decompiled with CFR 0.152.
 */
package java.lang.management;

import com.ibm.java.lang.management.internal.ManagementUtils;
import java.lang.management.MemoryUsage;
import javax.management.openmbean.CompositeData;

public class MemoryNotificationInfo {
    public static final String MEMORY_THRESHOLD_EXCEEDED = "java.management.memory.threshold.exceeded";
    public static final String MEMORY_COLLECTION_THRESHOLD_EXCEEDED = "java.management.memory.collection.threshold.exceeded";
    private String poolName;
    private MemoryUsage usage;
    private long count;

    public MemoryNotificationInfo(String string, MemoryUsage memoryUsage, long l) {
        this.poolName = string;
        this.usage = memoryUsage;
        this.count = l;
    }

    public long getCount() {
        return this.count;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public MemoryUsage getUsage() {
        return this.usage;
    }

    public static MemoryNotificationInfo from(CompositeData compositeData) {
        MemoryNotificationInfo memoryNotificationInfo = null;
        if (compositeData != null) {
            ManagementUtils.verifyFieldNumber(compositeData, 3);
            String[] stringArray = new String[]{"poolName", "usage", "count"};
            ManagementUtils.verifyFieldNames(compositeData, stringArray);
            String[] stringArray2 = new String[]{"java.lang.String", CompositeData.class.getName(), "java.lang.Long"};
            ManagementUtils.verifyFieldTypes(compositeData, stringArray, stringArray2);
            Object[] objectArray = compositeData.getAll(stringArray);
            String string = (String)objectArray[0];
            MemoryUsage memoryUsage = MemoryUsage.from((CompositeData)objectArray[1]);
            long l = (Long)objectArray[2];
            memoryNotificationInfo = new MemoryNotificationInfo(string, memoryUsage, l);
        }
        return memoryNotificationInfo;
    }
}

