/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.Comparator;
import java.lang.invoke.ComputedCalls;
import java.lang.invoke.DirectHandle;
import java.lang.invoke.ILGenMacros;
import java.lang.invoke.IndirectHandle;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.ThunkTable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

final class VirtualHandle
extends IndirectHandle {
    private static final ThunkTable _thunkTable = new ThunkTable();

    VirtualHandle(Method method) throws IllegalAccessException {
        super(VirtualHandle.indirectMethodType(method), method.getDeclaringClass(), method.getName(), (byte)5, method.getModifiers());
        if (Modifier.isStatic(method.getModifiers())) {
            throw new IllegalArgumentException();
        }
        boolean bl = VirtualHandle.setVMSlotAndRawModifiersFromMethod(this, this.referenceClass, method, this.kind, null);
        if (!bl) {
            throw new IllegalAccessException();
        }
    }

    VirtualHandle(DirectHandle directHandle) throws IllegalAccessException {
        super(directHandle.type(), directHandle.referenceClass, directHandle.name, (byte)5, directHandle.rawModifiers);
        this.defc = directHandle.defc;
        boolean bl = VirtualHandle.setVMSlotAndRawModifiersFromSpecialHandle(this, directHandle);
        if (!bl) {
            throw new IllegalAccessException();
        }
    }

    VirtualHandle(VirtualHandle virtualHandle, MethodType methodType) {
        super(virtualHandle, methodType);
    }

    @Override
    protected final long vtableOffset(Object object) {
        return this.vmSlot - INTRP_VTABLE_OFFSET;
    }

    @Override
    protected final ThunkTable thunkTable() {
        return _thunkTable;
    }

    protected static native void virtualCall_V(Object var0, int var1);

    protected static native int virtualCall_I(Object var0, int var1);

    protected static native long virtualCall_J(Object var0, int var1);

    protected static native float virtualCall_F(Object var0, int var1);

    protected static native double virtualCall_D(Object var0, int var1);

    protected static native Object virtualCall_L(Object var0, int var1);

    @MethodHandle.FrameIteratorSkip
    private final void invokeExact_thunkArchetype_V(Object object, int n) {
        if (ILGenMacros.isCustomThunk()) {
            VirtualHandle.virtualCall_V(object, n);
        } else {
            ComputedCalls.dispatchVirtual_V(this.jittedMethodAddress(object), this.vtableIndexArgument(object), object, n);
        }
    }

    @MethodHandle.FrameIteratorSkip
    private final int invokeExact_thunkArchetype_I(Object object, int n) {
        if (ILGenMacros.isCustomThunk()) {
            return VirtualHandle.virtualCall_I(object, n);
        }
        return ComputedCalls.dispatchVirtual_I(this.jittedMethodAddress(object), this.vtableIndexArgument(object), object, n);
    }

    @MethodHandle.FrameIteratorSkip
    private final long invokeExact_thunkArchetype_J(Object object, int n) {
        if (ILGenMacros.isCustomThunk()) {
            return VirtualHandle.virtualCall_J(object, n);
        }
        return ComputedCalls.dispatchVirtual_J(this.jittedMethodAddress(object), this.vtableIndexArgument(object), object, n);
    }

    @MethodHandle.FrameIteratorSkip
    private final float invokeExact_thunkArchetype_F(Object object, int n) {
        if (ILGenMacros.isCustomThunk()) {
            return VirtualHandle.virtualCall_F(object, n);
        }
        return ComputedCalls.dispatchVirtual_F(this.jittedMethodAddress(object), this.vtableIndexArgument(object), object, n);
    }

    @MethodHandle.FrameIteratorSkip
    private final double invokeExact_thunkArchetype_D(Object object, int n) {
        if (ILGenMacros.isCustomThunk()) {
            return VirtualHandle.virtualCall_D(object, n);
        }
        return ComputedCalls.dispatchVirtual_D(this.jittedMethodAddress(object), this.vtableIndexArgument(object), object, n);
    }

    @MethodHandle.FrameIteratorSkip
    private final Object invokeExact_thunkArchetype_L(Object object, int n) {
        if (ILGenMacros.isCustomThunk()) {
            return VirtualHandle.virtualCall_L(object, n);
        }
        return ComputedCalls.dispatchVirtual_L(this.jittedMethodAddress(object), this.vtableIndexArgument(object), object, n);
    }

    @Override
    MethodHandle cloneWithNewType(MethodType methodType) {
        return new VirtualHandle(this, methodType);
    }

    @Override
    final void compareWith(MethodHandle methodHandle, Comparator comparator) {
        if (methodHandle instanceof VirtualHandle) {
            ((VirtualHandle)methodHandle).compareWithVirtual(this, comparator);
        } else {
            comparator.fail();
        }
    }

    final void compareWithVirtual(VirtualHandle virtualHandle, Comparator comparator) {
        super.compareWithIndirect(virtualHandle, comparator);
    }
}

