/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.auth.module;

import com.sun.security.auth.UnixNumericGroupPrincipal;
import com.sun.security.auth.UnixNumericUserPrincipal;
import com.sun.security.auth.UnixPrincipal;
import com.sun.security.auth.module.Crypt;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.LinkedList;
import java.util.Map;
import java.util.ResourceBundle;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import jdk.Exported;

@Exported
public class JndiLoginModule
implements LoginModule {
    private static final ResourceBundle rb = AccessController.doPrivileged(new PrivilegedAction<ResourceBundle>(){

        @Override
        public ResourceBundle run() {
            return ResourceBundle.getBundle("sun.security.util.AuthResources");
        }
    });
    public final String USER_PROVIDER = "user.provider.url";
    public final String GROUP_PROVIDER = "group.provider.url";
    private boolean debug = false;
    private boolean strongDebug = false;
    private String userProvider;
    private String groupProvider;
    private boolean useFirstPass = false;
    private boolean tryFirstPass = false;
    private boolean storePass = false;
    private boolean clearPass = false;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private String username;
    private char[] password;
    DirContext ctx;
    private UnixPrincipal userPrincipal;
    private UnixNumericUserPrincipal UIDPrincipal;
    private UnixNumericGroupPrincipal GIDPrincipal;
    private LinkedList<UnixNumericGroupPrincipal> supplementaryGroups = new LinkedList();
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map<String, Object> sharedState;
    private Map<String, ?> options;
    private static final String CRYPT = "{crypt}";
    private static final String USER_PWD = "userPassword";
    private static final String USER_UID = "uidNumber";
    private static final String USER_GID = "gidNumber";
    private static final String GROUP_ID = "gidNumber";
    private static final String NAME = "javax.security.auth.login.name";
    private static final String PWD = "javax.security.auth.login.password";

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> map, Map<String, ?> map2) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = map;
        this.options = map2;
        this.debug = "true".equalsIgnoreCase((String)map2.get("debug"));
        this.strongDebug = "true".equalsIgnoreCase((String)map2.get("strongDebug"));
        this.userProvider = (String)map2.get("user.provider.url");
        this.groupProvider = (String)map2.get("group.provider.url");
        this.tryFirstPass = "true".equalsIgnoreCase((String)map2.get("tryFirstPass"));
        this.useFirstPass = "true".equalsIgnoreCase((String)map2.get("useFirstPass"));
        this.storePass = "true".equalsIgnoreCase((String)map2.get("storePass"));
        this.clearPass = "true".equalsIgnoreCase((String)map2.get("clearPass"));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean login() throws LoginException {
        if (this.userProvider == null) {
            throw new LoginException("Error: Unable to locate JNDI user provider");
        }
        if (this.groupProvider == null) {
            throw new LoginException("Error: Unable to locate JNDI group provider");
        }
        if (this.debug) {
            System.out.println("\t\t[JndiLoginModule] user provider: " + this.userProvider);
            System.out.println("\t\t[JndiLoginModule] group provider: " + this.groupProvider);
        }
        if (this.tryFirstPass) {
            try {
                this.attemptAuthentication(true);
                this.succeeded = true;
                if (this.debug) {
                    System.out.println("\t\t[JndiLoginModule] tryFirstPass succeeded");
                }
                return true;
            }
            catch (LoginException var1_1) {
                this.cleanState();
                if (!this.debug) ** GOTO lbl32
                System.out.println("\t\t[JndiLoginModule] tryFirstPass failed with:" + var1_1.toString());
            }
        } else if (this.useFirstPass) {
            try {
                this.attemptAuthentication(true);
                this.succeeded = true;
                if (this.debug) {
                    System.out.println("\t\t[JndiLoginModule] useFirstPass succeeded");
                }
                return true;
            }
            catch (LoginException var1_2) {
                this.cleanState();
                if (this.debug) {
                    System.out.println("\t\t[JndiLoginModule] useFirstPass failed");
                }
                throw var1_2;
            }
        }
lbl32:
        // 4 sources

        try {
            this.attemptAuthentication(false);
            this.succeeded = true;
            if (this.debug) {
                System.out.println("\t\t[JndiLoginModule] regular authentication succeeded");
            }
            return true;
        }
        catch (LoginException var1_3) {
            this.cleanState();
            if (this.debug) {
                System.out.println("\t\t[JndiLoginModule] regular authentication failed");
            }
            throw var1_3;
        }
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (this.subject.isReadOnly()) {
            this.cleanState();
            throw new LoginException("Subject is Readonly");
        }
        if (!this.subject.getPrincipals().contains(this.userPrincipal)) {
            this.subject.getPrincipals().add(this.userPrincipal);
        }
        if (!this.subject.getPrincipals().contains(this.UIDPrincipal)) {
            this.subject.getPrincipals().add(this.UIDPrincipal);
        }
        if (!this.subject.getPrincipals().contains(this.GIDPrincipal)) {
            this.subject.getPrincipals().add(this.GIDPrincipal);
        }
        for (int i = 0; i < this.supplementaryGroups.size(); ++i) {
            if (this.subject.getPrincipals().contains(this.supplementaryGroups.get(i))) continue;
            this.subject.getPrincipals().add(this.supplementaryGroups.get(i));
        }
        if (this.debug) {
            System.out.println("\t\t[JndiLoginModule]: added UnixPrincipal,");
            System.out.println("\t\t\t\tUnixNumericUserPrincipal,");
            System.out.println("\t\t\t\tUnixNumericGroupPrincipal(s),");
            System.out.println("\t\t\t to Subject");
        }
        this.cleanState();
        this.commitSucceeded = true;
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (this.debug) {
            System.out.println("\t\t[JndiLoginModule]: aborted authentication failed");
        }
        if (!this.succeeded) {
            return false;
        }
        if (this.succeeded && !this.commitSucceeded) {
            this.succeeded = false;
            this.cleanState();
            this.userPrincipal = null;
            this.UIDPrincipal = null;
            this.GIDPrincipal = null;
            this.supplementaryGroups = new LinkedList();
        } else {
            this.logout();
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        if (this.subject.isReadOnly()) {
            this.cleanState();
            throw new LoginException("Subject is Readonly");
        }
        this.subject.getPrincipals().remove(this.userPrincipal);
        this.subject.getPrincipals().remove(this.UIDPrincipal);
        this.subject.getPrincipals().remove(this.GIDPrincipal);
        for (int i = 0; i < this.supplementaryGroups.size(); ++i) {
            this.subject.getPrincipals().remove(this.supplementaryGroups.get(i));
        }
        this.cleanState();
        this.succeeded = false;
        this.commitSucceeded = false;
        this.userPrincipal = null;
        this.UIDPrincipal = null;
        this.GIDPrincipal = null;
        this.supplementaryGroups = new LinkedList();
        if (this.debug) {
            System.out.println("\t\t[JndiLoginModule]: logged out Subject");
        }
        return true;
    }

    private void attemptAuthentication(boolean bl) throws LoginException {
        block15: {
            String string = null;
            this.getUsernamePassword(bl);
            try {
                InitialContext initialContext = new InitialContext();
                this.ctx = (DirContext)initialContext.lookup(this.userProvider);
                SearchControls searchControls = new SearchControls();
                NamingEnumeration<SearchResult> namingEnumeration = this.ctx.search("", "(uid=" + this.username + ")", searchControls);
                if (namingEnumeration.hasMore()) {
                    SearchResult searchResult = namingEnumeration.next();
                    Attributes attributes = searchResult.getAttributes();
                    Attribute attribute = attributes.get(USER_PWD);
                    String string2 = new String((byte[])attribute.get(), "UTF8");
                    string = string2.substring(CRYPT.length());
                    if (this.verifyPassword(string, new String(this.password))) {
                        if (this.debug) {
                            System.out.println("\t\t[JndiLoginModule] attemptAuthentication() succeeded");
                        }
                    } else {
                        if (this.debug) {
                            System.out.println("\t\t[JndiLoginModule] attemptAuthentication() failed");
                        }
                        throw new FailedLoginException("Login incorrect");
                    }
                    if (this.storePass && !this.sharedState.containsKey(NAME) && !this.sharedState.containsKey(PWD)) {
                        this.sharedState.put(NAME, this.username);
                        this.sharedState.put(PWD, this.password);
                    }
                    this.userPrincipal = new UnixPrincipal(this.username);
                    Attribute attribute2 = attributes.get(USER_UID);
                    String string3 = (String)attribute2.get();
                    this.UIDPrincipal = new UnixNumericUserPrincipal(string3);
                    if (this.debug && string3 != null) {
                        System.out.println("\t\t[JndiLoginModule] user: '" + this.username + "' has UID: " + string3);
                    }
                    Attribute attribute3 = attributes.get("gidNumber");
                    String string4 = (String)attribute3.get();
                    this.GIDPrincipal = new UnixNumericGroupPrincipal(string4, true);
                    if (this.debug && string4 != null) {
                        System.out.println("\t\t[JndiLoginModule] user: '" + this.username + "' has GID: " + string4);
                    }
                    this.ctx = (DirContext)initialContext.lookup(this.groupProvider);
                    namingEnumeration = this.ctx.search("", (Attributes)new BasicAttributes("memberUid", this.username));
                    while (namingEnumeration.hasMore()) {
                        searchResult = namingEnumeration.next();
                        attributes = searchResult.getAttributes();
                        attribute3 = attributes.get("gidNumber");
                        String string5 = (String)attribute3.get();
                        if (string4.equals(string5)) continue;
                        UnixNumericGroupPrincipal unixNumericGroupPrincipal = new UnixNumericGroupPrincipal(string5, false);
                        this.supplementaryGroups.add(unixNumericGroupPrincipal);
                        if (!this.debug || string5 == null) continue;
                        System.out.println("\t\t[JndiLoginModule] user: '" + this.username + "' has Supplementary Group: " + string5);
                    }
                    break block15;
                }
                if (this.debug) {
                    System.out.println("\t\t[JndiLoginModule]: User not found");
                }
                throw new FailedLoginException("User not found");
            }
            catch (NamingException namingException) {
                if (this.debug) {
                    System.out.println("\t\t[JndiLoginModule]:  User not found");
                    namingException.printStackTrace();
                }
                throw new FailedLoginException("User not found");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (this.debug) {
                    System.out.println("\t\t[JndiLoginModule]:  password incorrectly encoded");
                    unsupportedEncodingException.printStackTrace();
                }
                throw new LoginException("Login failure due to incorrect password encoding in the password database");
            }
        }
    }

    private void getUsernamePassword(boolean bl) throws LoginException {
        if (bl) {
            this.username = (String)this.sharedState.get(NAME);
            this.password = (char[])this.sharedState.get(PWD);
            return;
        }
        if (this.callbackHandler == null) {
            throw new LoginException("Error: no CallbackHandler available to garner authentication information from the user");
        }
        String string = this.userProvider.substring(0, this.userProvider.indexOf(":"));
        Callback[] callbackArray = new Callback[]{new NameCallback(string + " " + rb.getString("username.")), new PasswordCallback(string + " " + rb.getString("password."), false)};
        try {
            this.callbackHandler.handle(callbackArray);
            this.username = ((NameCallback)callbackArray[0]).getName();
            char[] cArray = ((PasswordCallback)callbackArray[1]).getPassword();
            this.password = new char[cArray.length];
            System.arraycopy((Object)cArray, 0, (Object)this.password, 0, cArray.length);
            ((PasswordCallback)callbackArray[1]).clearPassword();
        }
        catch (IOException iOException) {
            throw new LoginException(iOException.toString());
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            throw new LoginException("Error: " + unsupportedCallbackException.getCallback().toString() + " not available to garner authentication information from the user");
        }
        if (this.strongDebug) {
            System.out.println("\t\t[JndiLoginModule] user entered username: " + this.username);
            System.out.print("\t\t[JndiLoginModule] user entered password: ");
            for (int i = 0; i < this.password.length; ++i) {
                System.out.print(this.password[i]);
            }
            System.out.println();
        }
    }

    private boolean verifyPassword(String string, String string2) {
        if (string == null) {
            return false;
        }
        Crypt crypt = new Crypt();
        try {
            byte[] byArray = string.getBytes("UTF8");
            byte[] byArray2 = crypt.crypt(string2.getBytes("UTF8"), byArray);
            if (byArray2.length != byArray.length) {
                return false;
            }
            for (int i = 0; i < byArray2.length; ++i) {
                if (byArray[i] == byArray2[i]) continue;
                return false;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return false;
        }
        return true;
    }

    private void cleanState() {
        this.username = null;
        if (this.password != null) {
            for (int i = 0; i < this.password.length; ++i) {
                this.password[i] = 32;
            }
            this.password = null;
        }
        this.ctx = null;
        if (this.clearPass) {
            this.sharedState.remove(NAME);
            this.sharedState.remove(PWD);
        }
    }
}

