/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.shared;

import com.ibm.oti.shared.SharedAbstractHelper;
import com.ibm.oti.shared.SharedClassFilter;
import com.ibm.oti.shared.SharedClassHelper;
import com.ibm.oti.util.Msg;
import com.ibm.oti.util.Util;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;

public abstract class SharedClassAbstractHelper
extends SharedAbstractHelper
implements SharedClassHelper {
    int ROMCLASS_COOKIE_SIZE;
    private static final int URI_EXCEPTION = 1;
    private static final int FILE_EXIST = 2;
    private static final int FILE_NOT_EXIST = 3;
    private SharedClassFilter sharedClassFilter;
    static byte[] nativeFlags = new byte[1];
    static final int CACHE_FULL_FLAG = 0;

    public boolean isSharedClassCookie(byte[] byArray) {
        return byArray.length == this.ROMCLASS_COOKIE_SIZE;
    }

    private native int initializeShareableClassloaderImpl(ClassLoader var1);

    void initializeShareableClassloader(ClassLoader classLoader) {
        this.ROMCLASS_COOKIE_SIZE = this.initializeShareableClassloaderImpl(classLoader);
    }

    URL convertJarURL(URL uRL) {
        if (uRL == null) {
            return null;
        }
        if (!uRL.getProtocol().equals("jar")) {
            return uRL;
        }
        String string = this.recursiveJarTrim(uRL.getPath());
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            return uRL;
        }
    }

    private String recursiveJarTrim(String string) {
        int n;
        if (string == null) {
            return null;
        }
        boolean bl = string.startsWith("jar:");
        boolean bl2 = string.endsWith("!/");
        int n2 = bl ? 4 : 0;
        int n3 = string.length();
        int n4 = n = bl2 ? n3 - 2 : n3;
        if (!bl && !bl2) {
            return string;
        }
        return this.recursiveJarTrim(string.substring(n2, n));
    }

    private static URL getURLToCheck(URL uRL) {
        String string = uRL.toString();
        int n = string.indexOf("!/");
        if (-1 != n) {
            string = string.substring(0, n);
            try {
                return new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                return uRL;
            }
        }
        return uRL;
    }

    boolean validateClassLoader(ClassLoader classLoader, Class<?> clazz) {
        if (classLoader == null) {
            this.printVerboseError(Msg.getString("K0595", clazz.getName()));
            return false;
        }
        if (!classLoader.equals(clazz.getClassLoader())) {
            this.printVerboseError(Msg.getString("K0596", clazz.getName()));
            return false;
        }
        return true;
    }

    boolean validateURL(URL uRL, boolean bl) {
        if (null == uRL) {
            return true;
        }
        String string = uRL.getProtocol();
        if (!string.equals("file") && !string.equals("jar")) {
            this.printVerboseInfo(Msg.getString("K0597", uRL.toString()));
            return false;
        }
        if (bl) {
            final URL uRL2 = SharedClassAbstractHelper.getURLToCheck(uRL);
            Integer n = AccessController.doPrivileged(new PrivilegedAction<Integer>(){

                @Override
                public Integer run() {
                    File file;
                    try {
                        file = new File(uRL2.toURI());
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        try {
                            file = new File(new URI(Util.urlEncode(uRL2.toExternalForm())));
                        }
                        catch (URISyntaxException uRISyntaxException2) {
                            file = new File(uRL2.getPath());
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            file = new File(uRL2.getPath());
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        file = new File(uRL2.getPath());
                    }
                    return file.exists() ? 2 : 3;
                }
            });
            if (n == 3) {
                this.printVerboseError(Msg.getString("K0598", uRL.toString()));
                return false;
            }
            if (n == 1) {
                this.printVerboseError(Msg.getString("K0599", uRL.toString()));
                return false;
            }
        }
        return true;
    }

    @Override
    public synchronized void setSharingFilter(SharedClassFilter sharedClassFilter) {
        if (System.getSecurityManager() != null) {
            ClassLoader classLoader = this.getClassLoader();
            if (classLoader == null) {
                this.printVerboseInfo(Msg.getString("K059a"));
                return;
            }
            if (!SharedClassAbstractHelper.checkReadPermission(classLoader)) {
                this.printVerboseError(Msg.getString("K059b"));
                return;
            }
            if (!SharedClassAbstractHelper.checkWritePermission(classLoader)) {
                this.printVerboseError(Msg.getString("K059c"));
                return;
            }
        }
        this.sharedClassFilter = sharedClassFilter;
    }

    @Override
    public synchronized SharedClassFilter getSharingFilter() {
        return this.sharedClassFilter;
    }

    static {
        SharedClassAbstractHelper.nativeFlags[0] = 0;
    }
}

