/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gpu;

import com.ibm.cuda.Cuda;
import com.ibm.cuda.CudaDevice;
import com.ibm.gpu.CUDADevice;
import com.ibm.gpu.GPUConfigurationException;
import com.ibm.gpu.GPUPermission;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import sun.misc.Unsafe;

public final class CUDAManager {
    private static final Lock lock = new Lock();
    private final BitSet busyDevices = new BitSet();
    private int defaultDeviceId = 0;
    private final int defaultDoubleThreshold;
    private final int defaultFloatThreshold;
    private final int defaultIntThreshold;
    private final int defaultLongThreshold;
    private CUDADevice[] devices = null;
    private final long devicesOffset;
    private final Unsafe unsafe;
    private boolean doSortOnGPU = false;
    private boolean enforceGPUSort = false;
    private boolean verboseOutput = CUDAManager.getProperty("com.ibm.gpu.verbose") != null;

    @Deprecated
    public static CUDAManager getInstance() throws GPUConfigurationException, SecurityException {
        return CUDAManager.instance();
    }

    public static CUDAManager instance() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(GPUPermission.Access);
        }
        return CUDAManager.instanceInternal();
    }

    static CUDAManager instanceInternal() {
        return Singleton.INSTANCE;
    }

    public static String getOutputHeader() {
        return "[IBM GPU]:";
    }

    static String getProperty(String string) {
        PrivilegedAction<String> privilegedAction = () -> System.getProperty(string);
        return AccessController.doPrivileged(privilegedAction);
    }

    public static String getVersion() {
        return "0.95";
    }

    @Deprecated
    public static void tearDown() {
    }

    CUDAManager() {
        try {
            this.unsafe = Unsafe.getUnsafe();
            this.devicesOffset = this.unsafe.objectFieldOffset(CUDAManager.class.getDeclaredField("devices"));
        }
        catch (NoSuchFieldException noSuchFieldException) {
            InternalError internalError = new InternalError(noSuchFieldException.toString());
            internalError.initCause(noSuchFieldException);
            throw internalError;
        }
        Configuration configuration = new Configuration(this);
        this.defaultDoubleThreshold = configuration.getDoubleThreshold();
        this.defaultFloatThreshold = configuration.getFloatThreshold();
        this.defaultIntThreshold = configuration.getIntThreshold();
        this.defaultLongThreshold = configuration.getLongThreshold();
        if (configuration.checkSortProperty("com.ibm.gpu.enforce")) {
            this.doSortOnGPU = true;
            this.enforceGPUSort = true;
        } else if (configuration.checkSortProperty("com.ibm.gpu.enable")) {
            this.doSortOnGPU = true;
        }
        if (configuration.checkSortProperty("com.ibm.gpu.disable")) {
            this.doSortOnGPU = false;
            this.enforceGPUSort = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int acquireFreeDevice() {
        Lock lock = CUDAManager.lock;
        synchronized (lock) {
            int n = this.busyDevices.nextClearBit(0);
            if (n < this.getDeviceCount()) {
                this.outputIfVerbose("Acquired device: " + n);
                this.busyDevices.set(n);
            } else {
                this.outputIfVerbose("No available devices found");
                n = -1;
            }
            return n;
        }
    }

    private CUDADevice[] findDevices() {
        int n = 0;
        try {
            n = Cuda.getDeviceCount();
        }
        catch (Exception exception) {
            this.outputIfVerbose("Couldn't count devices due to: " + exception.getLocalizedMessage());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            this.outputIfVerbose("Unsupported platform detected");
        }
        CUDADevice[] cUDADeviceArray = new CUDADevice[n];
        if (n != 0) {
            Configuration configuration = new Configuration(this);
            for (int i = 0; i < n; ++i) {
                String string = "";
                try {
                    string = new CudaDevice(i).getName();
                }
                catch (Exception exception) {
                    this.outputIfVerbose("Warning: couldn't get the GPU model name for device " + i);
                }
                cUDADeviceArray[i] = new CUDADevice(i, string, configuration.getDoubleThreshold(string), configuration.getFloatThreshold(string), configuration.getIntThreshold(string), configuration.getLongThreshold(string));
            }
            this.outputIfVerbose("Discovered " + n + " device(s)");
        }
        return cUDADeviceArray;
    }

    public ArrayList<CUDADevice> getCUDADevices() {
        return new ArrayList<CUDADevice>(Arrays.asList(this.getDevices()));
    }

    public int getDefaultDevice() {
        return this.defaultDeviceId;
    }

    public CUDADevice getDevice(int n) throws GPUConfigurationException {
        CUDADevice[] cUDADeviceArray = this.getDevices();
        if (0 <= n && n < cUDADeviceArray.length) {
            return cUDADeviceArray[n];
        }
        throw this.newGPUConfigurationException("Invalid device");
    }

    public int getDeviceCount() {
        return this.getDevices().length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CUDADevice[] getDevices() {
        CUDADevice[] cUDADeviceArray = this.devices;
        if (cUDADeviceArray == null) {
            Lock lock = CUDAManager.lock;
            synchronized (lock) {
                cUDADeviceArray = this.devices;
                if (cUDADeviceArray == null) {
                    cUDADeviceArray = this.findDevices();
                    this.unsafe.putOrderedObject(this, this.devicesOffset, cUDADeviceArray);
                }
            }
        }
        return cUDADeviceArray;
    }

    public CUDADevice getDeviceWithMostAvailableMemory() throws GPUConfigurationException {
        CUDADevice[] cUDADeviceArray = this.getDevices();
        CUDADevice cUDADevice = null;
        int n = cUDADeviceArray.length;
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            try {
                long l2 = new CudaDevice(i).getFreeMemory();
                if (l >= l2 && i != 0) continue;
                cUDADevice = cUDADeviceArray[i];
                l = l2;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return cUDADevice;
    }

    public int getDoubleThreshold() {
        return this.defaultDoubleThreshold;
    }

    public CUDADevice[] getEnabledCUDADevices() {
        return (CUDADevice[])this.getDevices().clone();
    }

    public int getFloatThreshold() {
        return this.defaultFloatThreshold;
    }

    public long getFreeMemoryForDevice(int n) throws GPUConfigurationException {
        if (0 <= n && n < this.getDeviceCount()) {
            try {
                CudaDevice cudaDevice = new CudaDevice(n);
                return cudaDevice.getFreeMemory();
            }
            catch (Exception exception) {
                throw new GPUConfigurationException(exception.getLocalizedMessage(), exception);
            }
        }
        throw this.newGPUConfigurationException("Invalid device");
    }

    public int getIntThreshold() {
        return this.defaultIntThreshold;
    }

    public int getLongThreshold() {
        return this.defaultLongThreshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextAvailableDevice() {
        Lock lock = CUDAManager.lock;
        synchronized (lock) {
            int n = this.busyDevices.nextClearBit(0);
            if (n < this.getDeviceCount()) {
                this.outputIfVerbose("Device " + n + " was free");
            } else {
                this.outputIfVerbose("No free devices!");
                n = -1;
            }
            return n;
        }
    }

    public boolean getVerboseGPUOutput() {
        return this.verboseOutput;
    }

    public boolean hasCUDASupport() {
        return this.getDeviceCount() != 0;
    }

    public boolean isSortEnabledOnGPU() {
        return this.doSortOnGPU;
    }

    public boolean isSortEnforcedOnGPU() {
        return this.enforceGPUSort;
    }

    private GPUConfigurationException newGPUConfigurationException(String string) {
        this.outputIfVerbose(string);
        return new GPUConfigurationException(CUDAManager.getOutputHeader() + ' ' + string);
    }

    void outputIfVerbose(String string) {
        if (this.verboseOutput) {
            System.out.printf("%s [time.ms=%d]: %s\n", CUDAManager.getOutputHeader(), System.currentTimeMillis(), string);
        }
    }

    public void printAllDeviceInfo() {
        CUDADevice[] cUDADeviceArray = this.getDevices();
        System.out.println("Number of devices: " + cUDADeviceArray.length);
        for (CUDADevice cUDADevice : cUDADeviceArray) {
            System.out.println(cUDADevice);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseDevice(int n) {
        Lock lock = CUDAManager.lock;
        synchronized (lock) {
            if (0 <= n && n < this.getDeviceCount()) {
                this.busyDevices.clear(n);
                this.outputIfVerbose("Released device: " + n);
            }
        }
    }

    public void setDefaultDevice(int n) {
        this.defaultDeviceId = n;
    }

    public void setDevice(int n) throws GPUConfigurationException {
        if (0 > n || n >= this.getDeviceCount()) {
            throw this.newGPUConfigurationException("Invalid device");
        }
        this.setDefaultDevice(n);
    }

    public void setVerboseGPU(boolean bl) {
        this.verboseOutput = bl;
    }

    private static enum Type {
        DOUBLE,
        FLOAT,
        INT,
        LONG;

        final String propertyPrefix = "com.ibm.gpu." + this.name() + "sortThreshold.";
    }

    private static final class Singleton {
        static final CUDAManager INSTANCE = new CUDAManager();

        private Singleton() {
        }
    }

    private static final class Lock {
        Lock() {
        }
    }

    private static final class Configuration {
        private static final String DEFAULT_MODEL_NAME = "DEFAULT";
        private static final int DEFAULT_THRESHOLD = 30000;
        private final CUDAManager manager;
        private final Map<String, Map<Type, Integer>> thresholds;

        private static void loadProperties(Properties properties, String string) throws IOException {
            PrivilegedAction<InputStream> privilegedAction = () -> CUDAManager.class.getResourceAsStream(string);
            try (InputStream inputStream = AccessController.doPrivileged(privilegedAction);){
                if (inputStream != null) {
                    properties.load(inputStream);
                }
            }
        }

        private static boolean startsWithIgnoreCase(String string, String string2) {
            int n = string2.length();
            if (string.length() >= n) {
                return string.regionMatches(true, 0, string2, 0, n);
            }
            return true;
        }

        Configuration(CUDAManager cUDAManager) {
            this.manager = cUDAManager;
            this.thresholds = new TreeMap<String, Map<Type, Integer>>(String.CASE_INSENSITIVE_ORDER);
            this.readThresholds();
        }

        boolean checkSortProperty(String string) {
            String string2 = CUDAManager.getProperty(string);
            if (string2 != null) {
                if (string2.isEmpty() || string2.equalsIgnoreCase("all") || string2.equalsIgnoreCase("sort")) {
                    return true;
                }
                this.manager.outputIfVerbose(String.format("Invalid value \"%s\" given on system property %s", string2, string));
            }
            return false;
        }

        private int getDefaultThreshold(Type type) {
            Integer n;
            Map<Type, Integer> map = this.thresholds.get(DEFAULT_MODEL_NAME);
            if (map != null && (n = map.get((Object)type)) != null) {
                return n;
            }
            return 30000;
        }

        int getDoubleThreshold() {
            return this.getDefaultThreshold(Type.DOUBLE);
        }

        int getDoubleThreshold(String string) {
            return this.getThreshold(string, Type.DOUBLE);
        }

        int getFloatThreshold() {
            return this.getDefaultThreshold(Type.FLOAT);
        }

        int getFloatThreshold(String string) {
            return this.getThreshold(string, Type.FLOAT);
        }

        int getIntThreshold() {
            return this.getDefaultThreshold(Type.INT);
        }

        int getIntThreshold(String string) {
            return this.getThreshold(string, Type.INT);
        }

        int getLongThreshold() {
            return this.getDefaultThreshold(Type.LONG);
        }

        int getLongThreshold(String string) {
            return this.getThreshold(string, Type.LONG);
        }

        private int getThreshold(String string, Type type) {
            Integer n;
            Map<Type, Integer> map = this.thresholds.get(string);
            if (map != null && (n = map.get((Object)type)) != null) {
                return n;
            }
            return this.getDefaultThreshold(type);
        }

        private void readThresholds() {
            Properties properties = new Properties();
            try {
                Configuration.loadProperties(properties, "ibm_gpu_thresholds.properties");
            }
            catch (IOException iOException) {
                this.manager.outputIfVerbose("Warning: couldn't load threshold properties file: " + iOException.getLocalizedMessage());
            }
            block4: for (Map.Entry entry : properties.entrySet()) {
                String string = String.valueOf(entry.getKey());
                for (Type type : Type.values()) {
                    String string2 = type.propertyPrefix;
                    if (!Configuration.startsWithIgnoreCase(string, string2)) continue;
                    String string3 = String.valueOf(entry.getValue());
                    try {
                        int n = Integer.parseInt(string3);
                        if (0 >= n || n >= Integer.MAX_VALUE) continue block4;
                        String string4 = string.substring(string2.length()).replace('_', ' ');
                        Map<Type, Integer> map = this.thresholds.get(string4);
                        if (map == null) {
                            map = new HashMap<Type, Integer>();
                            this.thresholds.put(string4, map);
                        }
                        map.put(type, n);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.manager.outputIfVerbose(String.format("Warning: ignoring non-numeric threshold: %s = %s", string, string3));
                    }
                    continue block4;
                }
            }
        }
    }
}

