/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cuda;

import com.ibm.cuda.CudaStream;
import com.ibm.cuda.Dim3;

public final class CudaGrid {
    public final int blockDimX;
    public final int blockDimY;
    public final int blockDimZ;
    public final int gridDimX;
    public final int gridDimY;
    public final int gridDimZ;
    public final int sharedMemBytes;
    public final CudaStream stream;

    public CudaGrid(Dim3 dim3, Dim3 dim32) {
        this(dim3, dim32, 0, null);
    }

    public CudaGrid(Dim3 dim3, Dim3 dim32, CudaStream cudaStream) {
        this(dim3, dim32, 0, cudaStream);
    }

    public CudaGrid(Dim3 dim3, Dim3 dim32, int n) {
        this(dim3, dim32, n, null);
    }

    public CudaGrid(Dim3 dim3, Dim3 dim32, int n, CudaStream cudaStream) {
        this.blockDimX = dim32.x;
        this.blockDimY = dim32.y;
        this.blockDimZ = dim32.z;
        this.gridDimX = dim3.x;
        this.gridDimY = dim3.y;
        this.gridDimZ = dim3.z;
        this.sharedMemBytes = n;
        this.stream = cudaStream;
    }

    public CudaGrid(int n, int n2) {
        this(n, n2, 0, null);
    }

    public CudaGrid(int n, int n2, CudaStream cudaStream) {
        this(n, n2, 0, cudaStream);
    }

    public CudaGrid(int n, int n2, int n3) {
        this(n, n2, n3, null);
    }

    public CudaGrid(int n, int n2, int n3, CudaStream cudaStream) {
        this.blockDimX = n2;
        this.blockDimY = 1;
        this.blockDimZ = 1;
        this.gridDimX = n;
        this.gridDimY = 1;
        this.gridDimZ = 1;
        this.sharedMemBytes = n3;
        this.stream = cudaStream;
    }
}

