/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.view.dtfj.java;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaClassLoader;
import com.ibm.dtfj.java.JavaField;
import com.ibm.dtfj.java.JavaHeap;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.view.dtfj.J9DDRDTFJUtils;
import com.ibm.j9ddr.view.dtfj.image.J9DDRCorruptData;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImageSection;
import com.ibm.j9ddr.view.dtfj.java.helper.DTFJJavaRuntimeHelper;
import com.ibm.j9ddr.vm29.j9.ConstantPoolHelpers;
import com.ibm.j9ddr.vm29.j9.ObjectAccessBarrier;
import com.ibm.j9ddr.vm29.j9.ObjectModel;
import com.ibm.j9ddr.vm29.pointer.generated.J9ArrayClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9IndexableObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9IndexableObjectHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm29.structure.J9Object;
import com.ibm.j9ddr.vm29.view.dtfj.DTFJContext;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJJavaClass;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJJavaHeap;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJJavaReference;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJJavaRuntime;
import com.ibm.j9ddr.vm29.view.dtfj.java.corrupt.CorruptJavaObject;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class DTFJJavaObject
implements JavaObject {
    private static final Class<?>[] whitelist = new Class[]{NullPointerException.class, ArrayIndexOutOfBoundsException.class, IllegalArgumentException.class};
    protected final J9ObjectPointer object;
    protected DTFJJavaHeap heap;
    protected J9ArrayClassPointer arrayptr = null;
    private boolean hasDeferredData = true;
    private com.ibm.dtfj.image.CorruptDataException corruptException = null;
    private long size = 0L;
    boolean objectIsArray = false;
    private int arraySize = 0;
    private String label = null;
    private List<Object> references;

    public DTFJJavaObject(DTFJJavaHeap dTFJJavaHeap, J9ObjectPointer j9ObjectPointer) {
        this.object = j9ObjectPointer;
        this.heap = dTFJJavaHeap;
    }

    public DTFJJavaObject(J9ObjectPointer j9ObjectPointer) {
        this(null, j9ObjectPointer);
    }

    J9ObjectPointer getJ9ObjectPointer() {
        return this.object;
    }

    public void arraycopy(int n, Object object, int n2, int n3) throws com.ibm.dtfj.image.CorruptDataException, MemoryAccessException {
        this.fetchDeferredData();
        if (!this.objectIsArray) {
            throw new IllegalArgumentException("Object is not an array");
        }
        J9IndexableObjectPointer j9IndexableObjectPointer = J9IndexableObjectPointer.cast(this.object);
        try {
            DTFJJavaObject.validateArrayCopyParameters(j9IndexableObjectPointer, n, object, n2, n3);
            String string = J9IndexableObjectHelper.getClassName(j9IndexableObjectPointer);
            if (null == string || string.length() < 2) {
                J9DDRCorruptData j9DDRCorruptData = new J9DDRCorruptData(DTFJContext.getProcess(), "The class name for this object could not be determined", this.object.getAddress());
                throw new com.ibm.dtfj.image.CorruptDataException((CorruptData)j9DDRCorruptData);
            }
            if (string.charAt(1) == 'L' || string.charAt(1) == '[') {
                if (!object.getClass().equals(Object[].class) && !(object instanceof JavaObject[])) {
                    throw new IllegalArgumentException("Type of dst object (" + object.getClass().getName() + ") incompatible with Object array. Should be JavaObject[] or Object[]");
                }
                J9ObjectPointer[] j9ObjectPointerArray = new J9ObjectPointer[n3];
                Object[] objectArray = (Object[])object;
                if ((long)n2 + (long)n3 > (long)objectArray.length) {
                    throw new ArrayIndexOutOfBoundsException("Supplied destination array too small. Requires: " + ((long)n2 + (long)n3) + ", was " + objectArray.length);
                }
                J9IndexableObjectHelper.getData(j9IndexableObjectPointer, j9ObjectPointerArray, n, n3, 0);
                for (int i = 0; i < n3; ++i) {
                    objectArray[n2 + i] = j9ObjectPointerArray[i].isNull() ? null : new DTFJJavaObject(j9ObjectPointerArray[i]);
                }
            } else {
                J9IndexableObjectHelper.getData(j9IndexableObjectPointer, object, n, n3, n2);
            }
        }
        catch (Throwable throwable) {
            throw J9DDRDTFJUtils.handleAllButMemAccExAsCorruptDataException(DTFJContext.getProcess(), throwable, whitelist);
        }
    }

    private static void validateArrayCopyParameters(J9IndexableObjectPointer j9IndexableObjectPointer, int n, Object object, int n2, int n3) throws CorruptDataException {
        if (object == null) {
            throw new NullPointerException("Destination array is null");
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("Source copy start is out of range: " + n);
        }
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException("Destination copy start is out of range: " + n2);
        }
        if (n3 < 0) {
            throw new ArrayIndexOutOfBoundsException("Copy length is out of range: " + n3);
        }
        long l = J9IndexableObjectHelper.size(j9IndexableObjectPointer).longValue();
        if ((long)n + (long)n3 > l) {
            throw new ArrayIndexOutOfBoundsException("source array index out of range: " + ((long)n + (long)n3));
        }
        if (!object.getClass().isArray()) {
            throw new IllegalArgumentException("Destination object of type " + object.getClass().getName() + " is not an array");
        }
    }

    public int getArraySize() throws com.ibm.dtfj.image.CorruptDataException {
        this.fetchDeferredData();
        if (this.objectIsArray) {
            return this.arraySize;
        }
        throw new IllegalArgumentException("This object is not an array");
    }

    public long getHashcode() throws DataUnavailable, com.ibm.dtfj.image.CorruptDataException {
        try {
            return ObjectAccessBarrier.getObjectHashCode(this.object).longValue();
        }
        catch (Throwable throwable) {
            throw J9DDRDTFJUtils.handleAllButDataUnavailAsCorruptDataException(DTFJContext.getProcess(), throwable);
        }
    }

    public JavaHeap getHeap() throws com.ibm.dtfj.image.CorruptDataException, DataUnavailable {
        try {
            if (this.heap == null) {
                DTFJJavaRuntime dTFJJavaRuntime = DTFJContext.getRuntime();
                this.heap = dTFJJavaRuntime.getHeapFromAddress(DTFJContext.getImagePointer(this.object.getAddress()));
                if (this.heap == null) {
                    throw new com.ibm.dtfj.image.CorruptDataException((CorruptData)new CorruptJavaObject(null, this.object));
                }
            }
            return this.heap;
        }
        catch (Throwable throwable) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), throwable);
        }
    }

    public ImagePointer getID() {
        return DTFJContext.getImagePointer(this.object.getAddress());
    }

    public JavaClass getJavaClass() throws com.ibm.dtfj.image.CorruptDataException {
        try {
            J9ClassPointer j9ClassPointer = J9ObjectHelper.clazz(this.object);
            return new DTFJJavaClass(j9ClassPointer);
        }
        catch (Throwable throwable) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), throwable);
        }
    }

    public long getPersistentHashcode() throws DataUnavailable, com.ibm.dtfj.image.CorruptDataException {
        try {
            if (ObjectModel.hasBeenHashed(this.object)) {
                return this.getHashcode();
            }
            throw new DataUnavailable("Object has never been hashed and therefore has no persistent hash code");
        }
        catch (Throwable throwable) {
            throw J9DDRDTFJUtils.handleAllButDataUnavailAsCorruptDataException(DTFJContext.getProcess(), throwable);
        }
    }

    public Iterator getReferences() {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        if (null == this.references) {
            Object object;
            JavaClass javaClass;
            Object object2;
            JavaClass javaClass2;
            this.references = new LinkedList<Object>();
            try {
                javaClass2 = this.getJavaClass();
                if (null != javaClass2) {
                    object2 = new DTFJJavaReference(this, javaClass2, "Class", 1, 0, 1);
                    this.references.add(object2);
                }
                if (this.isArray()) {
                    if (this.isObjectArray()) {
                        this.addObjectArrayReferences();
                    }
                } else {
                    bl = javaClass2 != null && javaClass2.getName().equals("java/lang/Class");
                    object2 = new LinkedList();
                    while (javaClass2 != null) {
                        String string = javaClass2.getName();
                        bl2 |= string.equals("java/lang/ClassLoader");
                        bl3 |= string.equals("java/lang/ref/WeakReference");
                        bl4 |= string.equals("java/lang/ref/SoftReference");
                        bl5 |= string.equals("java/lang/ref/PhantomReference");
                        object2.add(javaClass2);
                        javaClass2 = javaClass2.getSuperclass();
                    }
                    int n = bl3 ? 3 : (bl4 ? 2 : (bl5 ? 4 : 1));
                    javaClass = object2.iterator();
                    while (javaClass.hasNext()) {
                        object = (JavaClass)javaClass.next();
                        this.addFieldReferences((JavaClass)object, n);
                    }
                }
            }
            catch (com.ibm.dtfj.image.CorruptDataException corruptDataException) {
                this.references.add(corruptDataException.getCorruptData());
            }
            catch (Throwable throwable) {
                object2 = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
                this.references.add(object2);
            }
            if (bl2) {
                try {
                    javaClass2 = this.getAssociatedClassLoader();
                    if (javaClass2 != null) {
                        object2 = javaClass2.getDefinedClasses();
                        while (object2.hasNext()) {
                            Object e = object2.next();
                            if (!(e instanceof JavaClass)) continue;
                            javaClass = (JavaClass)e;
                            object = new DTFJJavaReference(this, javaClass, "Loaded class", 11, 0, 1);
                            this.references.add(object);
                        }
                    } else {
                        this.references.add(J9DDRDTFJUtils.newCorruptData(DTFJContext.getProcess(), "Couldn't find associated JavaClassLoader for classloader object " + this));
                    }
                }
                catch (Throwable throwable) {
                    object2 = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
                    this.references.add(object2);
                }
            }
            if (bl) {
                try {
                    javaClass2 = this.getAssociatedClass();
                    if (javaClass2 != null) {
                        object2 = new DTFJJavaReference(this, javaClass2, "Associated class", 13, 0, 1);
                        this.references.add(object2);
                    } else {
                        object2 = ConstantPoolHelpers.J9VM_J9CLASS_FROM_HEAPCLASS(this.object);
                        if (!J9ClassHelper.isAnonymousClass((J9ClassPointer)object2)) {
                            this.references.add(J9DDRDTFJUtils.newCorruptData(DTFJContext.getProcess(), "Couldn't find associated JavaClass for Class object " + this));
                        }
                    }
                }
                catch (Throwable throwable) {
                    object2 = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
                    this.references.add(object2);
                }
            }
        }
        return this.references.iterator();
    }

    private JavaClassLoader getAssociatedClassLoader() {
        Iterator iterator = DTFJContext.getRuntime().getJavaClassLoaders();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof JavaClassLoader)) continue;
            JavaClassLoader javaClassLoader = (JavaClassLoader)e;
            try {
                if (!javaClassLoader.getObject().equals((Object)this)) continue;
                return javaClassLoader;
            }
            catch (com.ibm.dtfj.image.CorruptDataException corruptDataException) {
            }
        }
        return null;
    }

    private JavaClass getAssociatedClass() {
        JavaObject javaObject = null;
        try {
            JavaClass javaClass = this.getJavaClass();
            Iterator iterator = javaClass.getDeclaredFields();
            while (iterator.hasNext()) {
                JavaField javaField;
                Object e = iterator.next();
                if (!(e instanceof JavaField) || !"classLoader".equals((javaField = (JavaField)e).getName())) continue;
                javaObject = (JavaObject)javaField.get((JavaObject)this);
                break;
            }
        }
        catch (com.ibm.dtfj.image.CorruptDataException corruptDataException) {
        }
        catch (MemoryAccessException memoryAccessException) {
            // empty catch block
        }
        return this.getAssociatedClass(javaObject);
    }

    private JavaClass getAssociatedClass(JavaObject javaObject) {
        Iterator iterator = DTFJContext.getRuntime().getJavaClassLoaders();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof JavaClassLoader)) continue;
            JavaClassLoader javaClassLoader = (JavaClassLoader)e;
            try {
                if (javaObject != null && !javaClassLoader.getObject().equals((Object)javaObject)) {
                    continue;
                }
            }
            catch (com.ibm.dtfj.image.CorruptDataException corruptDataException) {
                // empty catch block
            }
            Iterator iterator2 = javaClassLoader.getDefinedClasses();
            while (iterator2.hasNext()) {
                Object e2 = iterator2.next();
                if (!(e2 instanceof JavaClass)) continue;
                JavaClass javaClass = (JavaClass)e2;
                try {
                    if (!javaClass.getObject().equals((Object)this)) continue;
                    return javaClass;
                }
                catch (com.ibm.dtfj.image.CorruptDataException corruptDataException) {
                }
            }
        }
        return null;
    }

    private void addFieldReferences(JavaClass javaClass, int n) throws com.ibm.dtfj.image.CorruptDataException, MemoryAccessException {
        Iterator iterator = javaClass.getDeclaredFields();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof JavaField) {
                Object object;
                String string;
                JavaField javaField = (JavaField)e;
                if ((javaField.getModifiers() & 8) != 0 || !(string = javaField.getSignature()).startsWith("L") && !string.startsWith("[") || (object = javaField.get((JavaObject)this)) == null) continue;
                if (object instanceof JavaObject) {
                    String string2 = javaField.getName();
                    String string3 = null;
                    try {
                        string3 = javaField.getDeclaringClass().getName();
                    }
                    catch (DataUnavailable dataUnavailable) {
                        // empty catch block
                    }
                    String string4 = "Object Reference [field name:" + string2 + "]";
                    if (string2.equals("referent") && "java/lang/ref/Reference".equals(string3)) {
                        this.references.add(new DTFJJavaReference(this, object, string4, 2, 0, n));
                        continue;
                    }
                    this.references.add(new DTFJJavaReference(this, object, string4, 2, 0, 1));
                    continue;
                }
                if (object instanceof CorruptData) {
                    this.references.add(object);
                    continue;
                }
                this.references.add(J9DDRDTFJUtils.newCorruptData(DTFJContext.getProcess(), "Unexpected type from field get: " + object + ", class=" + object.getClass().getName()));
                continue;
            }
            if (e instanceof CorruptData) {
                this.references.add(e);
                continue;
            }
            this.references.add(J9DDRDTFJUtils.newCorruptData(DTFJContext.getProcess(), "Unexpected type from field iteration: " + e + ", class=" + e.getClass().getName()));
        }
    }

    private void addObjectArrayReferences() throws com.ibm.dtfj.image.CorruptDataException, MemoryAccessException {
        int n = this.getArraySize();
        long l = (long)n * J9Object.SIZEOF;
        if (l > DTFJJavaRuntimeHelper.getTotalHeapSize(DTFJContext.getRuntime(), DTFJContext.getProcess()) || l < 0L) {
            throw new com.ibm.dtfj.image.CorruptDataException((CorruptData)J9DDRDTFJUtils.newCorruptData(DTFJContext.getProcess(), "Array longer than available heap"));
        }
        if (n > 1000000) {
            this.addObjectArrayReferencesWithLimitCheck(1000000);
        } else {
            this.addAllObjectArrayReferences();
        }
    }

    private void addObjectArrayReferencesWithLimitCheck(int n) throws com.ibm.dtfj.image.CorruptDataException, MemoryAccessException {
        JavaObject javaObject;
        int n2;
        JavaObject[] javaObjectArray = new JavaObject[this.arraySize];
        JavaObject[] javaObjectArray2 = new JavaObject[n];
        this.arraycopy(0, javaObjectArray2, 0, n);
        javaObjectArray = new JavaObject[this.getArraySize() - n];
        this.arraycopy(n, javaObjectArray, 0, this.getArraySize() - n);
        for (n2 = 0; n2 != javaObjectArray2.length; ++n2) {
            javaObject = javaObjectArray2[n2];
            if (javaObject == null) continue;
            this.references.add(new DTFJJavaReference(this, javaObject, "Array Reference [" + n2 + "]", 3, 0, 1));
        }
        for (n2 = 0; n2 != javaObjectArray.length; ++n2) {
            javaObject = javaObjectArray[n2];
            if (javaObject == null) continue;
            this.references.add(new DTFJJavaReference(this, javaObject, "Array Reference [" + n2 + "]", 3, 0, 1));
        }
    }

    private void addAllObjectArrayReferences() throws com.ibm.dtfj.image.CorruptDataException, MemoryAccessException {
        this.getReferences();
        JavaObject[] javaObjectArray = new JavaObject[this.arraySize];
        this.arraycopy(0, javaObjectArray, 0, this.arraySize);
        for (int i = 0; i != javaObjectArray.length; ++i) {
            JavaObject javaObject = javaObjectArray[i];
            if (javaObject == null) continue;
            this.references.add(new DTFJJavaReference(this, javaObject, "Array Reference [" + i + "]", 3, 0, 1));
        }
    }

    private boolean isObjectArray() throws com.ibm.dtfj.image.CorruptDataException, CorruptDataException {
        return ((DTFJJavaClass)this.getJavaClass()).isObjectArray();
    }

    public Iterator getSections() {
        try {
            this.fetchDeferredData();
            LinkedList<J9DDRImageSection> linkedList = new LinkedList<J9DDRImageSection>();
            long l = ObjectModel.getConsumedSizeInBytesWithHeader(this.object).longValue();
            String string = this.getSectionName(l);
            J9DDRImageSection j9DDRImageSection = DTFJContext.getImageSection(this.object.getAddress(), string);
            j9DDRImageSection.setSize(l);
            linkedList.add(j9DDRImageSection);
            return linkedList.iterator();
        }
        catch (com.ibm.dtfj.image.CorruptDataException corruptDataException) {
            return J9DDRDTFJUtils.corruptIterator(corruptDataException.getCorruptData());
        }
        catch (Throwable throwable) {
            CorruptData corruptData = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
            return J9DDRDTFJUtils.corruptIterator(corruptData);
        }
    }

    private String getSectionName(long l) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("In-memory Object section at 0x");
        stringBuilder.append(Long.toHexString(this.object.getAddress()));
        stringBuilder.append(" (0x");
        stringBuilder.append(Long.toHexString(l));
        stringBuilder.append(" bytes)");
        return stringBuilder.toString();
    }

    public long getSize() throws com.ibm.dtfj.image.CorruptDataException {
        try {
            this.fetchDeferredData();
            return this.size;
        }
        catch (Throwable throwable) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), throwable);
        }
    }

    public boolean isArray() throws com.ibm.dtfj.image.CorruptDataException {
        try {
            this.fetchDeferredData();
            return this.objectIsArray;
        }
        catch (Throwable throwable) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), throwable);
        }
    }

    private void fetchDeferredData() throws com.ibm.dtfj.image.CorruptDataException {
        if (this.corruptException != null) {
            throw this.corruptException;
        }
        if (this.hasDeferredData) {
            this.hasDeferredData = false;
            try {
                this.objectIsArray = ObjectModel.isIndexable(this.object);
                if (this.objectIsArray) {
                    this.arrayptr = J9ArrayClassPointer.cast(this.object.clazz());
                    this.arraySize = ObjectModel.getSizeInElements(this.object).intValue();
                }
                this.size = ObjectModel.getTotalFootprintInBytesWithHeader(this.object).longValue();
            }
            catch (Throwable throwable) {
                throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), throwable);
            }
        }
    }

    public String toString() {
        if (this.label == null) {
            try {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Instance of ");
                String string = J9ObjectHelper.getClassName(this.object);
                stringBuilder.append(string);
                if (this.objectIsArray && string.endsWith("L")) {
                    stringBuilder.append(J9ClassHelper.getName(this.arrayptr.leafComponentType())).append(";");
                }
                stringBuilder.append(" @ 0x");
                stringBuilder.append(Long.toHexString(this.object.getAddress()));
                this.label = stringBuilder.toString();
            }
            catch (Throwable throwable) {
                J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), throwable);
                this.label = super.toString();
            }
        }
        return this.label;
    }

    public boolean equals(Object object) {
        try {
            if (object instanceof DTFJJavaObject) {
                DTFJJavaObject dTFJJavaObject = (DTFJJavaObject)object;
                return this.object.equals(dTFJJavaObject.object);
            }
        }
        catch (Throwable throwable) {
            J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), throwable);
        }
        return false;
    }

    public int hashCode() {
        return this.object.hashCode();
    }

    public boolean isPacked() {
        return false;
    }

    public boolean isNativePacked() {
        return false;
    }

    public long getNativePackedDataPointer() {
        return 0L;
    }

    public boolean isDerivedObject() {
        return false;
    }

    public JavaObject getTargetJavaObject() {
        return null;
    }

    public long getTargetOffset() {
        return 0L;
    }

    public boolean isNestedPacked() {
        return false;
    }
}

