/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.view.dtfj.java;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaClassLoader;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.events.IEventListener;
import com.ibm.j9ddr.view.dtfj.J9DDRDTFJUtils;
import com.ibm.j9ddr.view.dtfj.image.J9DDRCorruptData;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.walkers.ClassIterator;
import com.ibm.j9ddr.vm29.j9.walkers.ClassSegmentIterator;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassLoaderPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.view.dtfj.DTFJContext;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJJavaClass;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJJavaObject;
import com.ibm.j9ddr.vm29.view.dtfj.java.j9.SlidingIterator;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DTFJJavaClassloader
implements JavaClassLoader {
    private J9ClassLoaderPointer j9ClassLoader;
    private SoftReference<ClassCache> softReferenceToClassCache = new SoftReference<Object>(null);
    private Logger log = DTFJContext.getLogger();

    public DTFJJavaClassloader(J9ClassLoaderPointer j9ClassLoaderPointer) {
        this.j9ClassLoader = j9ClassLoaderPointer;
        this.log.fine(String.format("Created JavaClassloader for 0x%016x", j9ClassLoaderPointer.getAddress()));
    }

    public JavaClass findClass(String string) throws com.ibm.dtfj.image.CorruptDataException {
        ClassCache classCache = this.getPopulatedClassCache();
        return classCache.findClass(string);
    }

    public Iterator getCachedClasses() {
        ClassCache classCache = this.getPopulatedClassCache();
        return classCache.getCachedClasses();
    }

    public Iterator getDefinedClasses() {
        ClassCache classCache = this.getPopulatedClassCache();
        return classCache.getDefinedClasses();
    }

    public JavaObject getObject() throws com.ibm.dtfj.image.CorruptDataException {
        try {
            return new DTFJJavaObject(this.j9ClassLoader.classLoaderObject());
        }
        catch (Throwable throwable) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), throwable);
        }
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof DTFJJavaClassloader) {
            DTFJJavaClassloader dTFJJavaClassloader = (DTFJJavaClassloader)object;
            return this.j9ClassLoader.getAddress() == dTFJJavaClassloader.j9ClassLoader.getAddress();
        }
        return false;
    }

    public int hashCode() {
        return (int)this.j9ClassLoader.getAddress();
    }

    private ClassCache getPopulatedClassCache() {
        ClassCache classCache = this.softReferenceToClassCache.get();
        if (classCache == null) {
            classCache = new ClassCache();
            classCache.populateCache();
            this.log.fine(String.format("Populated class cache for JavaClassLoader 0x%016x", this.j9ClassLoader.getAddress()));
            this.softReferenceToClassCache = new SoftReference<ClassCache>(classCache);
        }
        return classCache;
    }

    private class ClassCache
    implements IEventListener {
        private ArrayList<Object> cache = new ArrayList();
        private HashMap<String, Integer> names = new HashMap();
        private Iterator corruptCache;
        private int definedClassCount = 0;

        private ClassCache() {
        }

        void populateCache() {
            Iterator<J9ClassPointer> iterator;
            try {
                iterator = ClassIterator.fromJ9Classloader(DTFJJavaClassloader.this.j9ClassLoader);
            }
            catch (Throwable throwable) {
                CorruptData corruptData = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
                this.corruptCache = J9DDRDTFJUtils.corruptIterator(corruptData);
                return;
            }
            int n = 0;
            n += this.storeClasses(iterator, n);
            try {
                ClassSegmentIterator classSegmentIterator = new ClassSegmentIterator(DTFJJavaClassloader.this.j9ClassLoader.classSegments());
                this.definedClassCount = this.storeClasses(classSegmentIterator, n);
                n += this.definedClassCount;
            }
            catch (Throwable throwable) {
                CorruptData corruptData = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
                this.cache.add(corruptData);
            }
            if (DTFJJavaClassloader.this.log.isLoggable(Level.FINE)) {
                if (this.corruptCache == null) {
                    DTFJJavaClassloader.this.log.fine(String.format("The class loader cache for 0x%016x is not corrupt", DTFJJavaClassloader.this.j9ClassLoader.getAddress()));
                    DTFJJavaClassloader.this.log.fine(String.format("Stored %d classes", this.cache.size()));
                    DTFJJavaClassloader.this.log.fine(String.format("Found %d defined classes", this.definedClassCount));
                } else {
                    DTFJJavaClassloader.this.log.fine("The class loader cache is corrupt");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int storeClasses(Iterator iterator, int n) {
            int n2 = this.cache.size();
            try {
                EventManager.register(this);
                while (iterator.hasNext()) {
                    J9ClassPointer j9ClassPointer = (J9ClassPointer)iterator.next();
                    DTFJJavaClassloader.this.log.fine(String.format("Found JavaClass at 0x%016x", j9ClassPointer.getAddress()));
                    DTFJJavaClass dTFJJavaClass = new DTFJJavaClass(j9ClassPointer);
                    try {
                        this.names.put(dTFJJavaClass.getName(), n + (this.cache.size() - n2));
                        this.cache.add(dTFJJavaClass);
                    }
                    catch (com.ibm.dtfj.image.CorruptDataException corruptDataException) {
                        this.cache.add(corruptDataException.getCorruptData());
                    }
                }
            }
            finally {
                EventManager.unregister(this);
            }
            return this.cache.size() - n2;
        }

        @Override
        public void corruptData(String string, CorruptDataException corruptDataException, boolean bl) {
            J9DDRCorruptData j9DDRCorruptData = J9DDRDTFJUtils.newCorruptData(DTFJContext.getProcess(), corruptDataException);
            this.cache.add(j9DDRCorruptData);
        }

        Iterator getCachedClasses() {
            if (this.corruptCache == null) {
                return new SlidingIterator(this.cache, 0, this.cache.size() - this.definedClassCount);
            }
            return this.corruptCache;
        }

        Iterator getDefinedClasses() {
            if (this.corruptCache == null) {
                if (this.definedClassCount == 0) {
                    return J9DDRDTFJUtils.emptyIterator();
                }
                return new SlidingIterator(this.cache, this.cache.size() - this.definedClassCount, this.cache.size());
            }
            return this.corruptCache;
        }

        JavaClass findClass(String string) {
            Integer n = this.names.get(string);
            if (n == null) {
                return null;
            }
            if (n instanceof Integer) {
                return (JavaClass)this.cache.get(n);
            }
            throw new IllegalArgumentException(String.format("The name lookup cache contained an instance of %s", n.getClass().getName()));
        }
    }
}

