/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.view.dtfj;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImagePointer;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImageProcess;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImageSection;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.J9VMThreadPointerUtil;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JITDataCacheHeaderPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JITExceptionTablePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MemorySegmentListPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MemorySegmentPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MethodPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.structure.J9JITDataCacheHeader;
import com.ibm.j9ddr.vm29.types.UDATA;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJJavaRuntime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DTFJContext {
    public static final long J9DataTypeExceptionInfo = 1L;
    public static final long J9DataTypeHashTable = 32L;
    public static final long J9DataTypeRelocationData = 4L;
    public static final long J9DataTypeStackAtlas = 2L;
    public static final long J9DataTypeThunkMappingData = 16L;
    public static final long J9DataTypeThunkMappingList = 8L;
    private static final IProcess process;
    private static final J9JavaVMPointer vm;
    private static List<J9VMThreadPointerUtil.ThreadInfo> threadInfoCache;
    private static DTFJJavaRuntime runtime;
    private static J9DDRImageProcess imageProcess;
    private static Map<J9MethodPointer, List<J9JITExceptionTablePointer>> jitMethodCache;

    public static IProcess getProcess() {
        return process;
    }

    public static J9JavaVMPointer getVm() {
        return vm;
    }

    public static J9DDRImagePointer getImagePointer(long l) {
        return new J9DDRImagePointer(process, l);
    }

    public static J9DDRImageSection getImageSection(long l, String string) {
        return new J9DDRImageSection(process, l, string);
    }

    public static Logger getLogger() {
        return Logger.getLogger("j9ddr.view.dtfj");
    }

    public static List<J9VMThreadPointerUtil.ThreadInfo> getThreadInfoCache() throws CorruptDataException {
        if (threadInfoCache == null) {
            J9VMThreadPointer j9VMThreadPointer;
            ArrayList<J9VMThreadPointerUtil.ThreadInfo> arrayList = new ArrayList<J9VMThreadPointerUtil.ThreadInfo>();
            J9VMThreadPointer j9VMThreadPointer2 = j9VMThreadPointer = DTFJContext.getVm().mainThread();
            do {
                J9VMThreadPointerUtil.ThreadInfo threadInfo = J9VMThreadPointerUtil.getJ9State(j9VMThreadPointer);
                arrayList.add(threadInfo);
            } while (!(j9VMThreadPointer = j9VMThreadPointer.linkNext()).eq(j9VMThreadPointer2));
            threadInfoCache = arrayList;
        }
        return threadInfoCache;
    }

    public static void setRuntime(DTFJJavaRuntime dTFJJavaRuntime) {
        runtime = dTFJJavaRuntime;
    }

    public static DTFJJavaRuntime getRuntime() {
        return runtime;
    }

    public static List<J9JITExceptionTablePointer> getJITMetaData(J9MethodPointer j9MethodPointer) {
        if (jitMethodCache == null) {
            DTFJContext.cacheJITMethodAddresses();
        }
        return jitMethodCache.get(j9MethodPointer);
    }

    private static void cacheJITMethodAddresses() {
        jitMethodCache = new HashMap<J9MethodPointer, List<J9JITExceptionTablePointer>>();
        try {
            J9MemorySegmentListPointer j9MemorySegmentListPointer = DTFJContext.getVm().jitConfig().dataCacheList();
            J9MemorySegmentPointer j9MemorySegmentPointer = j9MemorySegmentListPointer.nextSegment();
            while (j9MemorySegmentPointer.notNull()) {
                UDATA uDATA = UDATA.cast(j9MemorySegmentPointer.heapBase());
                UDATA uDATA2 = UDATA.cast(j9MemorySegmentPointer.heapAlloc());
                while (uDATA.lt(uDATA2)) {
                    J9JITDataCacheHeaderPointer j9JITDataCacheHeaderPointer = J9JITDataCacheHeaderPointer.cast(uDATA);
                    if (j9JITDataCacheHeaderPointer.type().longValue() == 1L) {
                        J9JITExceptionTablePointer j9JITExceptionTablePointer = J9JITExceptionTablePointer.cast(uDATA.add(J9JITDataCacheHeader.SIZEOF));
                        DTFJContext.addMetaData(j9JITExceptionTablePointer);
                    }
                    uDATA = uDATA.add(j9JITDataCacheHeaderPointer.size());
                }
                j9MemorySegmentPointer = j9MemorySegmentPointer.nextSegment();
            }
        }
        catch (CorruptDataException corruptDataException) {
            return;
        }
    }

    private static void addMetaData(J9JITExceptionTablePointer j9JITExceptionTablePointer) throws CorruptDataException {
        if (j9JITExceptionTablePointer.constantPool().isNull()) {
            return;
        }
        List<J9JITExceptionTablePointer> list = jitMethodCache.get(j9JITExceptionTablePointer.ramMethod());
        if (list == null) {
            list = new ArrayList<J9JITExceptionTablePointer>();
            jitMethodCache.put(j9JITExceptionTablePointer.ramMethod(), list);
        }
        list.add(j9JITExceptionTablePointer);
    }

    public static void setImageProcess(J9DDRImageProcess j9DDRImageProcess) {
        imageProcess = j9DDRImageProcess;
    }

    public static J9DDRImageProcess getImageProcess() {
        return imageProcess;
    }

    static {
        threadInfoCache = null;
        jitMethodCache = null;
        process = AbstractPointer.getProcess();
        J9JavaVMPointer j9JavaVMPointer = null;
        try {
            j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
        }
        catch (CorruptDataException corruptDataException) {
            DTFJContext.getLogger().log(Level.FINE, "", corruptDataException);
        }
        vm = j9JavaVMPointer;
    }
}

