/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.gc.GCClassHeapIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCSegmentIterator;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MemorySegmentPointer;
import com.ibm.j9ddr.vm29.structure.J9MemorySegment;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.Check;

class CheckClassHeap
extends Check {
    CheckClassHeap() {
    }

    @Override
    public void check() {
        try {
            GCSegmentIterator gCSegmentIterator = GCSegmentIterator.fromJ9MemorySegmentList(this._javaVM.classMemorySegments(), J9MemorySegment.MEMORY_TYPE_RAM_CLASS);
            while (gCSegmentIterator.hasNext()) {
                J9MemorySegmentPointer j9MemorySegmentPointer = gCSegmentIterator.next();
                this._engine.clearPreviousObjects();
                GCClassHeapIterator gCClassHeapIterator = GCClassHeapIterator.fromJ9MemorySegment(j9MemorySegmentPointer);
                while (gCClassHeapIterator.hasNext()) {
                    J9ClassPointer j9ClassPointer = gCClassHeapIterator.next();
                    if (this._engine.checkClassHeap(j9ClassPointer, j9MemorySegmentPointer) != 0) {
                        return;
                    }
                    this._engine.pushPreviousClass(j9ClassPointer);
                }
            }
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
    }

    @Override
    public String getCheckName() {
        return "CLASS HEAP";
    }

    @Override
    public void print() {
        this.getReporter().println("Printing of class heap not currently supported");
    }
}

