/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.walkers.MemorySegmentIterator;
import com.ibm.j9ddr.vm29.pointer.UDATAPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MemorySegmentListPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MemorySegmentPointer;
import com.ibm.j9ddr.vm29.structure.J9MemorySegment;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

public class SegmentsUtil {
    private static final String nl = System.getProperty("line.separator");

    public static void dbgDumpSegmentList(PrintStream printStream, J9MemorySegmentListPointer j9MemorySegmentListPointer) throws CorruptDataException {
        String string = null;
        if (J9BuildFlags.env_data64) {
            printStream.append("+----------------+----------------+----------------+----------------+--------+--------+\n");
            printStream.append("|    segment     |     start      |     alloc      |      end       |  type  |  size  |\n");
            printStream.append("+----------------+----------------+----------------+----------------+--------+--------+\n");
            string = " %016x %016x %016x %016x %08x %8x";
        } else {
            printStream.append("+--------+--------+--------+--------+--------+--------+\n");
            printStream.append("|segment | start  | alloc  |  end   |  type  |  size  |\n");
            printStream.append("+--------+--------+--------+--------+--------+--------+\n");
            string = " %08x %08x %08x %08x %08x %8x";
        }
        MemorySegmentIterator memorySegmentIterator = new MemorySegmentIterator(j9MemorySegmentListPointer, -1, false);
        long l = 0L;
        long l2 = 0L;
        while (memorySegmentIterator.hasNext()) {
            J9MemorySegmentPointer j9MemorySegmentPointer = (J9MemorySegmentPointer)memorySegmentIterator.next();
            l += j9MemorySegmentPointer.size().longValue();
            l2 += j9MemorySegmentPointer.heapAlloc().sub(j9MemorySegmentPointer.heapBase()).longValue();
            String string2 = String.format(string, j9MemorySegmentPointer.getAddress(), j9MemorySegmentPointer.heapBase().getAddress(), j9MemorySegmentPointer.heapAlloc().getAddress(), j9MemorySegmentPointer.heapTop().getAddress(), j9MemorySegmentPointer.type().longValue(), j9MemorySegmentPointer.size().longValue());
            printStream.append(string2);
            printStream.append(nl);
            j9MemorySegmentPointer = j9MemorySegmentListPointer.nextSegment();
        }
        if (J9BuildFlags.env_data64) {
            printStream.append("+----------------+----------------+----------------+----------------+--------+--------+\n");
        } else {
            printStream.append("+--------+--------+--------+--------+--------+--------+\n");
        }
        SegmentsUtil.printMemoryUsed(printStream, l, l2);
        printStream.append(nl);
    }

    public static void dbgDumpJITCodeSegmentList(PrintStream printStream, J9MemorySegmentListPointer j9MemorySegmentListPointer) throws CorruptDataException {
        String string = null;
        if (J9BuildFlags.env_data64) {
            printStream.append("+----------------+----------------+----------------+----------------+----------------+--------+\n");
            printStream.append("|    segment     |     start      |    warmAlloc   |    coldAlloc   |      end       |  size  |\n");
            printStream.append("+----------------+----------------+----------------+----------------+----------------+--------+\n");
            string = " %016x %016x %016x %016x %016x %8x";
        } else {
            printStream.append("+--------+--------+--------+--------+--------+--------+\n");
            printStream.append("|segment | start  |  warm  |  cold  |  end   |  size  |\n");
            printStream.append("+--------+--------+--------+--------+--------+--------+\n");
            string = " %08x %08x %08x %08x %08x %8x";
        }
        MemorySegmentIterator memorySegmentIterator = new MemorySegmentIterator(j9MemorySegmentListPointer, -1, false);
        long l = 0L;
        long l2 = 0L;
        while (memorySegmentIterator.hasNext()) {
            J9MemorySegmentPointer j9MemorySegmentPointer = (J9MemorySegmentPointer)memorySegmentIterator.next();
            UDATA uDATA = UDATAPointer.cast(j9MemorySegmentPointer.heapBase()).at(0L);
            long l3 = UDATAPointer.cast(uDATA).at(0L).longValue();
            long l4 = UDATAPointer.cast(uDATA.add(UDATA.SIZEOF)).at(0L).longValue();
            l += j9MemorySegmentPointer.size().longValue();
            l2 += l3 - j9MemorySegmentPointer.heapBase().longValue() + (j9MemorySegmentPointer.heapTop().longValue() - l4);
            String string2 = String.format(string, j9MemorySegmentPointer.getAddress(), j9MemorySegmentPointer.heapBase().getAddress(), l3, l4, j9MemorySegmentPointer.heapTop().getAddress(), j9MemorySegmentPointer.size().longValue());
            printStream.append(string2);
            printStream.append(nl);
            j9MemorySegmentPointer = j9MemorySegmentListPointer.nextSegment();
        }
        if (J9BuildFlags.env_data64) {
            printStream.append("+----------------+----------------+----------------+----------------+----------------+--------+\n");
        } else {
            printStream.append("+--------+--------+--------+--------+--------+--------+\n");
        }
        SegmentsUtil.printMemoryUsed(printStream, l, l2);
        printStream.append(nl);
    }

    private static void printMemoryUsed(PrintStream printStream, long l, long l2) {
        long l3 = l - l2;
        printStream.println(String.format("Total memory:           %016d (%016x)", l, l));
        printStream.println(String.format("Total memory in use:    %016d (%016x)", l2, l2));
        printStream.println(String.format("Total memory free:      %016d (%016x)", l3, l3));
    }

    private static void addSegmentsToArrayList(J9MemorySegmentListPointer j9MemorySegmentListPointer, ArrayList<J9MemorySegmentPointer> arrayList, int n) throws CorruptDataException {
        MemorySegmentIterator memorySegmentIterator = new MemorySegmentIterator(j9MemorySegmentListPointer, n, false);
        while (memorySegmentIterator.hasNext()) {
            J9MemorySegmentPointer j9MemorySegmentPointer = (J9MemorySegmentPointer)memorySegmentIterator.next();
            arrayList.add(j9MemorySegmentPointer);
        }
    }

    private static J9MemorySegmentPointer[] getSortedSegments(J9JavaVMPointer j9JavaVMPointer, int n) throws CorruptDataException {
        ArrayList<J9MemorySegmentPointer> arrayList = new ArrayList<J9MemorySegmentPointer>();
        try {
            SegmentsUtil.addSegmentsToArrayList(j9JavaVMPointer.memorySegments(), arrayList, n);
            SegmentsUtil.addSegmentsToArrayList(j9JavaVMPointer.classMemorySegments(), arrayList, n);
            if (J9BuildFlags.interp_nativeSupport && !j9JavaVMPointer.jitConfig().isNull()) {
                SegmentsUtil.addSegmentsToArrayList(j9JavaVMPointer.jitConfig().codeCacheList(), arrayList, n);
                SegmentsUtil.addSegmentsToArrayList(j9JavaVMPointer.jitConfig().dataCacheList(), arrayList, n);
            }
        }
        catch (SegmentSortException segmentSortException) {
            throw segmentSortException.getCause();
        }
        J9MemorySegmentPointer[] j9MemorySegmentPointerArray = arrayList.toArray(new J9MemorySegmentPointer[arrayList.size()]);
        Arrays.sort(j9MemorySegmentPointerArray, new SegmentComparator());
        return j9MemorySegmentPointerArray;
    }

    private static boolean findOverlappingSegments(J9MemorySegmentPointer[] j9MemorySegmentPointerArray, boolean[] blArray) throws CorruptDataException {
        if (j9MemorySegmentPointerArray.length > 1) {
            boolean bl = false;
            long l = j9MemorySegmentPointerArray[0].heapTop().getAddress();
            blArray[0] = false;
            for (int i = 1; i < j9MemorySegmentPointerArray.length; ++i) {
                if (j9MemorySegmentPointerArray[i].heapBase().getAddress() >= l) {
                    l = j9MemorySegmentPointerArray[i].heapTop().getAddress();
                    blArray[i] = false;
                    continue;
                }
                bl = true;
                blArray[i - 1] = true;
                blArray[i] = true;
                if (j9MemorySegmentPointerArray[i].heapTop().getAddress() <= l) continue;
                l = j9MemorySegmentPointerArray[i].heapTop().getAddress();
            }
            return bl;
        }
        return false;
    }

    private static String fmtSegment(String string, J9MemorySegmentPointer j9MemorySegmentPointer) throws CorruptDataException {
        String string2 = String.format(string, j9MemorySegmentPointer.getAddress(), j9MemorySegmentPointer.heapBase().getAddress(), j9MemorySegmentPointer.heapAlloc().getAddress(), j9MemorySegmentPointer.heapTop().getAddress(), j9MemorySegmentPointer.type().longValue(), j9MemorySegmentPointer.size().longValue());
        return string2;
    }

    private static void printOverlappingSegments(PrintStream printStream, J9MemorySegmentPointer[] j9MemorySegmentPointerArray, boolean[] blArray) throws CorruptDataException {
        String string;
        printStream.append("Overlapping segments:");
        printStream.append(nl);
        if (J9BuildFlags.env_data64) {
            printStream.append("+----------------+----------------+----------------+----------------+--------+--------+\n");
            printStream.append("|    segment     |     start      |     alloc      |      end       |  type  |  size  |\n");
            printStream.append("+----------------+----------------+----------------+----------------+--------+--------+\n");
            string = " %016x %016x %016x %016x %08x %8x";
        } else {
            printStream.append("+--------+--------+--------+--------+--------+--------+\n");
            printStream.append("|segment | start  | alloc  |  end   |  type  |  size  |\n");
            printStream.append("+--------+--------+--------+--------+--------+--------+\n");
            string = " %08x %08x %08x %08x %08x %8x";
        }
        printStream.append(nl);
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            printStream.append(SegmentsUtil.fmtSegment(string, j9MemorySegmentPointerArray[i]));
            printStream.append(nl);
        }
    }

    public static void checkSegmentsForOverlap(PrintStream printStream, J9JavaVMPointer j9JavaVMPointer, int n) throws CorruptDataException {
        boolean[] blArray;
        boolean bl = false;
        J9MemorySegmentPointer[] j9MemorySegmentPointerArray = SegmentsUtil.getSortedSegments(j9JavaVMPointer, n);
        if (j9MemorySegmentPointerArray != null && j9MemorySegmentPointerArray.length > 1 && SegmentsUtil.findOverlappingSegments(j9MemorySegmentPointerArray, blArray = new boolean[j9MemorySegmentPointerArray.length])) {
            SegmentsUtil.printOverlappingSegments(printStream, j9MemorySegmentPointerArray, blArray);
            if (0L != ((long)n & J9MemorySegment.MEMORY_TYPE_SHARED_META)) {
                printStream.append(nl);
                String string = String.format("**NOTE** If -Xshareclasses is enabled, then the shared cache's metadata segment (type %08x)" + nl + "is expected to overlap with ROM class segments (type %08x) in the cache.", J9MemorySegment.MEMORY_TYPE_SHARED_META, J9MemorySegment.MEMORY_TYPE_ROM_CLASS);
                printStream.append(string);
                printStream.append(nl);
            }
            bl = true;
        }
        if (!bl) {
            printStream.append("No overlaps found" + nl);
        }
    }

    private static class SegmentComparator
    implements Comparator<J9MemorySegmentPointer> {
        private SegmentComparator() {
        }

        @Override
        public int compare(J9MemorySegmentPointer j9MemorySegmentPointer, J9MemorySegmentPointer j9MemorySegmentPointer2) {
            try {
                if (j9MemorySegmentPointer.getAddress() == j9MemorySegmentPointer2.getAddress()) {
                    return 0;
                }
                if (j9MemorySegmentPointer.heapBase().getAddress() < j9MemorySegmentPointer2.heapBase().getAddress()) {
                    return -1;
                }
                if (j9MemorySegmentPointer.heapBase().getAddress() > j9MemorySegmentPointer2.heapBase().getAddress()) {
                    return 1;
                }
                if (j9MemorySegmentPointer.heapTop().getAddress() < j9MemorySegmentPointer2.heapTop().getAddress()) {
                    return -1;
                }
                if (j9MemorySegmentPointer.heapTop().getAddress() > j9MemorySegmentPointer2.heapTop().getAddress()) {
                    return 1;
                }
                return 0;
            }
            catch (CorruptDataException corruptDataException) {
                throw new SegmentSortException("Failed to sort memory segments", corruptDataException);
            }
        }
    }

    private static class SegmentSortException
    extends RuntimeException {
        SegmentSortException(String string, CorruptDataException corruptDataException) {
            super(string, corruptDataException);
        }

        @Override
        public CorruptDataException getCause() {
            return this.getCause();
        }
    }
}

