/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.gc.GCClassLoaderIterator;
import com.ibm.j9ddr.vm29.j9.walkers.ClassIterator;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassLoaderPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MethodPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMMethodPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMNameAndSignaturePointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9MethodHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.commands.WildCard;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Iterator;

public class MethodForNameCommand
extends Command {
    public MethodForNameCommand() {
        this.addCommand("methodforname", "<name>", "find the method corresponding to name (with wildcards)");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        try {
            if (stringArray.length != 1) {
                throw new DDRInteractiveCommandException(string + ": too " + (stringArray.length < 1 ? "few" : "many") + " arguments. Expected 1");
            }
            String string2 = stringArray[0];
            CommandUtils.dbgPrint(printStream, String.format("Searching for methods named '%s' in VM=%s...\n", string2, J9RASHelper.getVM(DataType.getJ9RASPointer()).getHexAddress()));
            int n = this.dbgGetMethodsForName(printStream, string2);
            CommandUtils.dbgPrint(printStream, String.format("Found %d method(s) named %s\n", n, string2));
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }

    int dbgGetMethodsForName(PrintStream printStream, String string) throws CorruptDataException {
        String string2;
        String string3;
        int n = 0;
        if (string.indexOf(46) != -1) {
            string3 = string.substring(string.indexOf(46) + 1);
            string2 = string.substring(0, string.indexOf(46));
        } else {
            string2 = "*";
            string3 = string;
        }
        String string4 = string.indexOf(40) != -1 ? string.substring(string.indexOf(40)) : "*";
        StringBuffer stringBuffer = new StringBuffer();
        long l = WildCard.parseWildcard(string2, stringBuffer);
        String string5 = stringBuffer.toString();
        if (l == -1L) {
            CommandUtils.dbgError(printStream, "Invalid wildcards in class name\n");
            return 0;
        }
        stringBuffer = new StringBuffer();
        long l2 = WildCard.parseWildcard(string3, stringBuffer);
        String string6 = stringBuffer.toString();
        if (l2 == -1L) {
            CommandUtils.dbgError(printStream, "Invalid wildcards in method name\n");
            return 0;
        }
        stringBuffer = new StringBuffer();
        long l3 = WildCard.parseWildcard(string4, stringBuffer);
        String string7 = stringBuffer.toString();
        if (l2 == -1L) {
            CommandUtils.dbgError(printStream, "Invalid wildcards in method name\n");
            return 0;
        }
        Hashtable<String, J9ClassPointer> hashtable = new Hashtable<String, J9ClassPointer>();
        GCClassLoaderIterator gCClassLoaderIterator = GCClassLoaderIterator.from();
        while (gCClassLoaderIterator.hasNext()) {
            J9ClassLoaderPointer j9ClassLoaderPointer = gCClassLoaderIterator.next();
            Iterator<J9ClassPointer> iterator = ClassIterator.fromJ9Classloader(j9ClassLoaderPointer);
            while (iterator.hasNext()) {
                J9ClassPointer j9ClassPointer = iterator.next();
                J9ROMClassPointer j9ROMClassPointer = j9ClassPointer.romClass();
                String string8 = J9UTF8Helper.stringValue(j9ROMClassPointer.className());
                if (hashtable.containsValue(j9ClassPointer)) continue;
                hashtable.put(j9ClassPointer.toString(), j9ClassPointer);
                if (!WildCard.wildcardMatch(l, string5, string8)) continue;
                J9MethodPointer j9MethodPointer = j9ClassPointer.ramMethods();
                long l4 = j9ROMClassPointer.romMethodCount().longValue();
                while (l4 > 0L) {
                    String string9;
                    J9ROMMethodPointer j9ROMMethodPointer = J9MethodHelper.romMethod(j9MethodPointer);
                    J9ROMNameAndSignaturePointer j9ROMNameAndSignaturePointer = j9ROMMethodPointer.nameAndSignature();
                    String string10 = J9UTF8Helper.stringValue(j9ROMNameAndSignaturePointer.name());
                    if (WildCard.wildcardMatch(l2, string6, string10) && WildCard.wildcardMatch(l3, string7, string9 = J9UTF8Helper.stringValue(j9ROMNameAndSignaturePointer.signature()))) {
                        ++n;
                        CommandUtils.dbgPrint(printStream, String.format("!j9method %s --> %s.%s%s\n", j9MethodPointer.getHexAddress(), string8, string10, string9));
                    }
                    --l4;
                    j9MethodPointer = j9MethodPointer.add(1L);
                }
            }
        }
        return n;
    }
}

