/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.walkers.ClassSegmentIterator;
import com.ibm.j9ddr.vm29.j9.walkers.ROMClassesIterator;
import com.ibm.j9ddr.vm29.j9.walkers.ROMClassesRangeIterator;
import com.ibm.j9ddr.vm29.pointer.StructurePointer;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MemorySegmentPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9UTF8Helper;
import java.io.PrintStream;
import java.util.Iterator;

public class AllClassesCommand
extends Command {
    private static final String nl = System.getProperty("line.separator");
    private static final String rangeDelim = "..";
    private boolean dumpROMClasses;
    private boolean dumpRAMClasses;
    private U8Pointer rangeStart;
    private U8Pointer rangeEnd;

    public AllClassesCommand() {
        this.addCommand("allclasses", "[help|rom|ram [startAddr..endAddr]]", "Dump a list of loaded ROM/RAM classes. Use 'help' to see more details about the usage.");
    }

    private void init() {
        this.dumpRAMClasses = false;
        this.dumpROMClasses = false;
        this.rangeEnd = null;
        this.rangeStart = null;
    }

    private void printHelp(PrintStream printStream) {
        CommandUtils.dbgPrint(printStream, "!allclasses rom [startAddr..endAddr]   -- Dump a list of J9ROMClasses in the given range. If no range is given, all J9ROMClasses are displayed.\n");
        CommandUtils.dbgPrint(printStream, "                                          Note that 'startAddr' in the range should point to valid J9ROMClass.\n");
        CommandUtils.dbgPrint(printStream, "!allclasses ram [startAddr..endAddr]   -- Dump a list of J9Classes in the given range. If no range is given, all J9Classes are displayed.\n");
        CommandUtils.dbgPrint(printStream, "User may specify both 'rom' and 'ram' to dump J9ROMClasses and J9Classes\n");
        CommandUtils.dbgPrint(printStream, "Note: if no argument is specified, then all J9ROMClasses and J9Classes will be displayed\n");
    }

    private boolean getRange(PrintStream printStream, String string) throws DDRInteractiveCommandException {
        String string2 = string.substring(0, string.indexOf(rangeDelim));
        this.rangeStart = U8Pointer.cast(CommandUtils.parsePointer(string2, J9BuildFlags.env_data64));
        string2 = string.substring(string.indexOf(rangeDelim) + rangeDelim.length());
        this.rangeEnd = U8Pointer.cast(CommandUtils.parsePointer(string2, J9BuildFlags.env_data64));
        if (this.rangeStart.getAddress() >= this.rangeEnd.getAddress()) {
            printStream.append("Invalid range specified. Ensure 'startAddr' < 'endAddr'" + nl);
            return false;
        }
        return true;
    }

    private boolean parseROMRAMRange(PrintStream printStream, String string) throws DDRInteractiveCommandException {
        if (string.equals("rom")) {
            if (this.dumpROMClasses) {
                printStream.append("Argument '" + string + "' is specified twice" + nl);
                return false;
            }
            this.dumpROMClasses = true;
        } else if (string.equals("ram")) {
            if (this.dumpRAMClasses) {
                printStream.append("Argument '" + string + "' is specified twice" + nl);
                return false;
            }
            this.dumpRAMClasses = true;
        } else {
            if (string.indexOf(rangeDelim) != -1) {
                return this.getRange(printStream, string);
            }
            printStream.append("Unrecognized argument: " + string + nl);
            return false;
        }
        return true;
    }

    private boolean parseROMRAM(PrintStream printStream, String string) throws DDRInteractiveCommandException {
        if (string.equals("rom")) {
            if (this.dumpROMClasses) {
                printStream.append("Argument '" + string + "' is specified twice" + nl);
                return false;
            }
            this.dumpROMClasses = true;
        } else if (string.equals("ram")) {
            if (this.dumpRAMClasses) {
                printStream.append("Argument '" + string + "' is specified twice" + nl);
                return false;
            }
            this.dumpRAMClasses = true;
        } else {
            printStream.append("Invalid argument: " + string + nl);
            return false;
        }
        return true;
    }

    private boolean parseRange(PrintStream printStream, String string) throws DDRInteractiveCommandException {
        if (string.indexOf(rangeDelim) != -1) {
            return this.getRange(printStream, string);
        }
        printStream.append("Invalid argument: " + string);
        return false;
    }

    private boolean parseArgs(PrintStream printStream, String[] stringArray) throws DDRInteractiveCommandException {
        if (stringArray.length > 3) {
            printStream.append("Invalid number of arguments" + nl);
            return false;
        }
        switch (stringArray.length) {
            case 1: {
                if (stringArray[0].equals("help")) {
                    this.printHelp(printStream);
                    return false;
                }
                if (this.parseROMRAM(printStream, stringArray[0])) break;
                return false;
            }
            case 2: {
                if (!this.parseROMRAM(printStream, stringArray[0])) {
                    return false;
                }
                if (this.parseROMRAMRange(printStream, stringArray[1])) break;
                return false;
            }
            case 3: {
                if (!this.parseROMRAM(printStream, stringArray[0])) {
                    return false;
                }
                if (!this.parseROMRAM(printStream, stringArray[1])) {
                    return false;
                }
                if (this.parseRange(printStream, stringArray[2])) break;
                return false;
            }
        }
        return true;
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        boolean bl;
        this.init();
        if (stringArray != null && !this.parseArgs(printStream, stringArray)) {
            return;
        }
        boolean bl2 = bl = this.rangeStart != null && this.rangeEnd != null;
        if (!this.dumpROMClasses && !this.dumpRAMClasses) {
            this.dumpRAMClasses = true;
            this.dumpROMClasses = true;
        }
        try {
            StructurePointer structurePointer;
            Iterator<J9ROMClassPointer> iterator;
            J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
            if (this.dumpRAMClasses) {
                printStream.append("RAM classes (ram size loader rom replacement name)" + nl);
                printStream.append("Class addr\tsize\t\tClassLoader\tROM class addr\tArray\tClass name" + nl);
                printStream.append(nl);
                iterator = new ClassSegmentIterator(j9JavaVMPointer.classMemorySegments());
                while (((ClassSegmentIterator)iterator).hasNext()) {
                    structurePointer = J9ClassPointer.NULL;
                    try {
                        structurePointer = (J9ClassPointer)((ClassSegmentIterator)iterator).next();
                        if (bl && (structurePointer.getAddress() < this.rangeStart.getAddress() || structurePointer.getAddress() >= this.rangeEnd.getAddress())) continue;
                        printStream.append(structurePointer.getHexAddress());
                        printStream.append('\t');
                        printStream.append(J9ClassHelper.size((J9ClassPointer)structurePointer, j9JavaVMPointer).getHexValue());
                        printStream.append('\t');
                        printStream.append(((J9ClassPointer)structurePointer).classLoader().getHexAddress());
                        printStream.append('\t');
                        printStream.append(((J9ClassPointer)structurePointer).romClass().getHexAddress());
                        printStream.append('\t');
                        if (J9ClassHelper.isSwappedOut((J9ClassPointer)structurePointer)) {
                            printStream.append(((J9ClassPointer)structurePointer).arrayClass().getHexAddress());
                        } else {
                            printStream.append('0');
                        }
                        printStream.append('\t');
                        printStream.append(J9ClassHelper.getJavaName((J9ClassPointer)structurePointer));
                        printStream.append(nl);
                    }
                    catch (CorruptDataException corruptDataException) {
                        if (bl && structurePointer.getAddress() >= this.rangeStart.getAddress() && structurePointer.getAddress() < this.rangeEnd.getAddress()) continue;
                    }
                }
            }
            if (this.dumpROMClasses) {
                iterator = null;
                printStream.append(nl);
                if (bl) {
                    iterator = new ROMClassesRangeIterator(printStream, this.rangeStart, this.rangeEnd);
                    printStream.append("ROM classes (rom size modifiers name)" + nl);
                    printStream.append("Class addr\tROM size\tModifiers\tExtra\t\tClass name" + nl);
                } else {
                    iterator = new ROMClassesIterator(printStream, j9JavaVMPointer.classMemorySegments());
                    printStream.append("ROM classes (rom size loader modifiers name)" + nl);
                    printStream.append("Class addr\tROM size\tClassLoader\tModifiers\tExtra\t\tClass name" + nl);
                }
                printStream.append(nl);
                while (((ROMClassesIterator)iterator).hasNext()) {
                    structurePointer = ((ROMClassesIterator)iterator).next();
                    printStream.append(structurePointer.getHexAddress());
                    printStream.append('\t');
                    printStream.append(((J9ROMClassPointer)structurePointer).romSize().getHexValue());
                    if (((ROMClassesIterator)iterator).getMemorySegmentPointer() != J9MemorySegmentPointer.NULL) {
                        printStream.append('\t');
                        printStream.append(((ROMClassesIterator)iterator).getMemorySegmentPointer().classLoader().getHexAddress());
                    }
                    printStream.append('\t');
                    printStream.append(((J9ROMClassPointer)structurePointer).modifiers().getHexValue());
                    printStream.append('\t');
                    printStream.append(((J9ROMClassPointer)structurePointer).extraModifiers().getHexValue());
                    printStream.append('\t');
                    printStream.append(J9UTF8Helper.stringValue(((J9ROMClassPointer)structurePointer).className()));
                    printStream.append(nl);
                }
                printStream.append(nl);
            }
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }
}

