/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.UDATAPointer;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.U32;
import com.ibm.j9ddr.vm29.types.UDATA;

public class U32Pointer
extends UDATAPointer {
    public static final int SIZEOF = 4;
    public static final U32Pointer NULL = new U32Pointer(0L);

    protected U32Pointer(long l) {
        super(l);
    }

    public static U32Pointer cast(AbstractPointer abstractPointer) {
        return U32Pointer.cast(abstractPointer.getAddress());
    }

    public static U32Pointer cast(UDATA uDATA) {
        return U32Pointer.cast(uDATA.longValue());
    }

    public static U32Pointer cast(long l) {
        if (l == 0L) {
            return NULL;
        }
        return new U32Pointer(l);
    }

    @Override
    public U32 at(long l) throws CorruptDataException {
        return new U32(this.getIntAtOffset(l * 4L));
    }

    @Override
    public U32 at(Scalar scalar) throws CorruptDataException {
        return this.at(scalar.longValue());
    }

    @Override
    public U32Pointer untag() {
        return this.untag(3L);
    }

    @Override
    public U32Pointer untag(long l) {
        return new U32Pointer(this.address & (l ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public U32Pointer add(long l) {
        return new U32Pointer(this.address + 4L * l);
    }

    @Override
    public U32Pointer add(Scalar scalar) {
        return this.add(scalar.longValue());
    }

    @Override
    public U32Pointer addOffset(long l) {
        return new U32Pointer(this.address + l);
    }

    @Override
    public U32Pointer addOffset(Scalar scalar) {
        return this.addOffset(scalar.longValue());
    }

    @Override
    public U32Pointer sub(long l) {
        return new U32Pointer(this.address - 4L * l);
    }

    @Override
    public U32Pointer sub(Scalar scalar) {
        return this.sub(scalar.longValue());
    }

    @Override
    public U32Pointer subOffset(long l) {
        return new U32Pointer(this.address - l);
    }

    @Override
    public U32Pointer subOffset(Scalar scalar) {
        return this.subOffset(scalar.longValue());
    }

    @Override
    protected long sizeOfBaseType() {
        return 4L;
    }
}

