/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.Pointer;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.UDATA;

public class DoublePointer
extends Pointer {
    public static final int SIZEOF = 8;
    public static final DoublePointer NULL = new DoublePointer(0L);

    protected DoublePointer(long l) {
        super(l);
    }

    public static DoublePointer cast(AbstractPointer abstractPointer) {
        return DoublePointer.cast(abstractPointer.getAddress());
    }

    public static DoublePointer cast(UDATA uDATA) {
        return DoublePointer.cast(uDATA.longValue());
    }

    public static DoublePointer cast(long l) {
        if (l == 0L) {
            return NULL;
        }
        return new DoublePointer(l);
    }

    @Override
    public DoublePointer at(long l) throws CorruptDataException {
        throw new UnsupportedOperationException("Use doubleAt(long index)");
    }

    @Override
    public DoublePointer at(Scalar scalar) throws CorruptDataException {
        return this.at(scalar.longValue());
    }

    @Override
    public long longAt(long l) throws CorruptDataException {
        return (long)this.doubleAt(l);
    }

    @Override
    public double doubleAt(long l) throws CorruptDataException {
        return this.getDoubleAtOffset(l * 8L);
    }

    @Override
    public float floatAt(long l) throws CorruptDataException {
        return (float)this.doubleAt(l);
    }

    @Override
    public DoublePointer add(long l) {
        return new DoublePointer(this.address + 8L * l);
    }

    @Override
    public DoublePointer add(Scalar scalar) {
        return this.add(scalar.longValue());
    }

    @Override
    public DoublePointer addOffset(long l) {
        return new DoublePointer(this.address + l);
    }

    @Override
    public DoublePointer addOffset(Scalar scalar) {
        return this.addOffset(scalar.longValue());
    }

    @Override
    public DoublePointer sub(long l) {
        return new DoublePointer(this.address - 8L * l);
    }

    @Override
    public DoublePointer sub(Scalar scalar) {
        return this.sub(scalar.longValue());
    }

    @Override
    public DoublePointer subOffset(long l) {
        return new DoublePointer(this.address - l);
    }

    @Override
    public DoublePointer subOffset(Scalar scalar) {
        return this.subOffset(scalar.longValue());
    }

    @Override
    public DoublePointer untag() {
        return this.untag(7L);
    }

    @Override
    public DoublePointer untag(long l) {
        return new DoublePointer(this.address & (l ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    protected long sizeOfBaseType() {
        return 8L;
    }
}

