/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.walkers;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.walkers.ROMClassesIterator;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassPointer;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ROMClassesRangeIterator
extends ROMClassesIterator
implements Iterator<J9ROMClassPointer> {
    private long startAddr;
    private long endAddr;

    public ROMClassesRangeIterator(PrintStream printStream, U8Pointer u8Pointer, U8Pointer u8Pointer2) throws CorruptDataException {
        super(printStream, null);
        this.startAddr = u8Pointer.longValue();
        this.endAddr = u8Pointer2.longValue();
    }

    @Override
    public boolean hasNext() {
        return J9ROMClassPointer.NULL != this.getNextClass();
    }

    @Override
    public J9ROMClassPointer next() {
        J9ROMClassPointer j9ROMClassPointer = this.getNextClass();
        if (j9ROMClassPointer == J9ROMClassPointer.NULL) {
            throw new NoSuchElementException();
        }
        this.nextClass = j9ROMClassPointer;
        return this.nextClass;
    }

    private J9ROMClassPointer getNextClass() {
        long l = 0L;
        J9ROMClassPointer j9ROMClassPointer = J9ROMClassPointer.NULL;
        if (this.nextClass == J9ROMClassPointer.NULL) {
            l = this.startAddr;
        } else {
            try {
                l = this.nextClass.getAddress() + this.nextClass.romSize().longValue();
            }
            catch (CorruptDataException corruptDataException) {
                this.out.append("Unabled to read size of ROMClass at " + this.nextClass.getHexAddress() + ".\n");
                j9ROMClassPointer = J9ROMClassPointer.NULL;
            }
        }
        if (l != 0L && l < this.endAddr) {
            j9ROMClassPointer = J9ROMClassPointer.cast(l);
            try {
                if (j9ROMClassPointer.romSize().eq(0L)) {
                    this.out.append("Size of ROMClass at " + j9ROMClassPointer.getHexAddress() + "is invalid.\n");
                    j9ROMClassPointer = J9ROMClassPointer.NULL;
                }
            }
            catch (CorruptDataException corruptDataException) {
                this.out.append("Unable to read size of ROMClass at " + j9ROMClassPointer.getHexAddress() + ".\n");
                j9ROMClassPointer = J9ROMClassPointer.NULL;
            }
        }
        return j9ROMClassPointer;
    }
}

