/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.ObjectModel;
import com.ibm.j9ddr.vm29.j9.gc.GCObjectIterator;
import com.ibm.j9ddr.vm29.pointer.ObjectReferencePointer;
import com.ibm.j9ddr.vm29.pointer.UDATAPointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.util.HashMap;
import java.util.NoSuchElementException;

class GCMixedObjectIterator_V1
extends GCObjectIterator {
    protected static final HashMap<J9ClassPointer, boolean[]> descriptionCache = new HashMap();
    protected ObjectReferencePointer data;
    protected boolean[] descriptionArray;
    protected int scanIndex;
    protected int scanLimit;
    protected int bytesInObjectSlot;
    protected int objectsInDescriptionSlot;

    protected static void setCache(J9ClassPointer j9ClassPointer, boolean[] blArray) {
        descriptionCache.put(j9ClassPointer, blArray);
    }

    protected static boolean[] checkCache(J9ClassPointer j9ClassPointer) {
        return descriptionCache.get(j9ClassPointer);
    }

    protected GCMixedObjectIterator_V1(J9ObjectPointer j9ObjectPointer, boolean bl) throws CorruptDataException {
        super(j9ObjectPointer, bl);
        J9ClassPointer j9ClassPointer = J9ObjectHelper.clazz(j9ObjectPointer);
        this.bytesInObjectSlot = (int)ObjectReferencePointer.SIZEOF;
        this.objectsInDescriptionSlot = UDATA.SIZEOF * 8;
        VoidPointer voidPointer = VoidPointer.cast(j9ObjectPointer.addOffset(ObjectModel.getHeaderSize(j9ObjectPointer)));
        this.initialize(j9ClassPointer, voidPointer);
    }

    protected GCMixedObjectIterator_V1(J9ClassPointer j9ClassPointer, VoidPointer voidPointer) throws CorruptDataException {
        super(null, false);
        this.bytesInObjectSlot = (int)ObjectReferencePointer.SIZEOF;
        this.objectsInDescriptionSlot = UDATA.SIZEOF * 8;
        this.initialize(j9ClassPointer, voidPointer);
    }

    private void initialize(J9ClassPointer j9ClassPointer, VoidPointer voidPointer) throws CorruptDataException {
        this.data = ObjectReferencePointer.cast(voidPointer);
        this.scanIndex = 0;
        this.scanLimit = j9ClassPointer.totalInstanceSize().intValue() / this.bytesInObjectSlot;
        this.descriptionArray = GCMixedObjectIterator_V1.checkCache(j9ClassPointer);
        if (null == this.descriptionArray) {
            this.descriptionArray = new boolean[(j9ClassPointer.totalInstanceSize().intValue() + this.bytesInObjectSlot - 1) / this.bytesInObjectSlot];
            if (this.scanLimit > 0 && j9ClassPointer.instanceDescription().notNull()) {
                this.initializeDescriptionArray(j9ClassPointer);
                GCMixedObjectIterator_V1.setCache(j9ClassPointer, this.descriptionArray);
            }
        }
    }

    protected void initializeDescriptionArray(J9ClassPointer j9ClassPointer) throws CorruptDataException {
        UDATAPointer uDATAPointer = j9ClassPointer.instanceDescription();
        if (uDATAPointer.anyBitsIn(1L)) {
            long l = uDATAPointer.getAddress() >>> 1;
            this.initializeDescriptionArray(l, 0);
        } else {
            int n = 0;
            for (int i = 0; i < this.scanLimit; i += this.objectsInDescriptionSlot) {
                long l = uDATAPointer.at(n++).longValue();
                this.initializeDescriptionArray(l, i);
            }
        }
    }

    private void initializeDescriptionArray(long l, int n) {
        for (int i = 0; i < this.objectsInDescriptionSlot; ++i) {
            if (1L == (l & 1L)) {
                this.descriptionArray[n + i] = true;
            }
            l >>>= 1;
        }
    }

    @Override
    public boolean hasNext() {
        if (this.object != null && this.includeClassSlot) {
            return true;
        }
        while (this.scanIndex < this.scanLimit) {
            if (this.descriptionArray[this.scanIndex]) {
                return true;
            }
            ++this.scanIndex;
        }
        return false;
    }

    @Override
    public J9ObjectPointer next() {
        try {
            if (this.hasNext()) {
                if (this.object != null && this.includeClassSlot) {
                    this.includeClassSlot = false;
                    return J9ObjectHelper.clazz(this.object).classObject();
                }
                J9ObjectPointer j9ObjectPointer = J9ObjectPointer.cast(this.data.at(this.scanIndex));
                ++this.scanIndex;
                return j9ObjectPointer;
            }
            throw new NoSuchElementException("There are no more items available through this iterator");
        }
        catch (CorruptDataException corruptDataException) {
            EventManager.raiseCorruptDataEvent("Error getting next item", corruptDataException, false);
            return null;
        }
    }

    @Override
    public VoidPointer nextAddress() {
        try {
            if (this.hasNext()) {
                if (this.object != null && this.includeClassSlot) {
                    this.includeClassSlot = false;
                    return VoidPointer.cast(J9ObjectHelper.clazz(this.object).classObjectEA());
                }
                VoidPointer voidPointer = VoidPointer.cast(this.data.add(this.scanIndex));
                ++this.scanIndex;
                return voidPointer;
            }
            throw new NoSuchElementException("There are no more items available through this iterator");
        }
        catch (CorruptDataException corruptDataException) {
            EventManager.raiseCorruptDataEvent("Error getting next item", corruptDataException, false);
            return null;
        }
    }
}

