/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.gc.GCCardCleaner;
import com.ibm.j9ddr.vm29.j9.gc.GCExtensions;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapRegionDescriptor;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_CardTablePointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_GCExtensionsPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.structure.J9ModroncoreConstants;
import com.ibm.j9ddr.vm29.types.U8;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.util.Iterator;

public class GCCardTable {
    private MM_CardTablePointer _cardTable;
    private U8Pointer _cardTableVirtualStart;
    private VoidPointer _heapBase;
    private U8Pointer _cardTableStart;
    static UDATA CARD_SIZE_SHIFT = new UDATA(J9ModroncoreConstants.CARD_SIZE_SHIFT);

    public GCCardTable(MM_CardTablePointer mM_CardTablePointer) throws CorruptDataException {
        this._cardTable = mM_CardTablePointer;
        this._cardTableVirtualStart = mM_CardTablePointer._cardTableVirtualStart();
        this._heapBase = mM_CardTablePointer._heapBase();
        this._cardTableStart = mM_CardTablePointer._cardTableStart();
    }

    public static GCCardTable from() throws CorruptDataException {
        J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
        MM_GCExtensionsPointer mM_GCExtensionsPointer = GCExtensions.getGCExtensionsPointer();
        MM_CardTablePointer mM_CardTablePointer = mM_GCExtensionsPointer.cardTable();
        return new GCCardTable(mM_CardTablePointer);
    }

    public U8Pointer heapAddrToCardAddr(VoidPointer voidPointer) {
        UDATA uDATA = UDATA.cast(voidPointer).rightShift(CARD_SIZE_SHIFT);
        return this._cardTableVirtualStart.add(uDATA);
    }

    public VoidPointer cardAddrToHeapAddr(U8Pointer u8Pointer) {
        UDATA uDATA = UDATA.cast(u8Pointer).sub(UDATA.cast(this._cardTableStart));
        UDATA uDATA2 = uDATA.leftShift(CARD_SIZE_SHIFT);
        return this._heapBase.addOffset(uDATA2);
    }

    public void cleanRange(U8Pointer u8Pointer, U8Pointer u8Pointer2, GCCardCleaner gCCardCleaner) throws CorruptDataException {
        U8Pointer u8Pointer3 = u8Pointer;
        U8Pointer u8Pointer4 = u8Pointer2;
        while (u8Pointer3.lt(u8Pointer4)) {
            try {
                U8 u8 = u8Pointer3.at(0L);
                if (!u8.eq(J9ModroncoreConstants.CARD_CLEAN)) {
                    VoidPointer voidPointer = this.cardAddrToHeapAddr(u8Pointer3);
                    VoidPointer voidPointer2 = voidPointer.addOffset(J9ModroncoreConstants.CARD_SIZE);
                    gCCardCleaner.clean(voidPointer, voidPointer2, u8Pointer3);
                }
            }
            catch (CorruptDataException corruptDataException) {
                EventManager.raiseCorruptDataEvent("Corrupt Card", corruptDataException, false);
            }
            u8Pointer3 = u8Pointer3.add(1L);
        }
    }

    public void cleanCardsInRegion(GCHeapRegionDescriptor gCHeapRegionDescriptor, GCCardCleaner gCCardCleaner) throws CorruptDataException {
        U8Pointer u8Pointer = this.heapAddrToCardAddr(gCHeapRegionDescriptor.getLowAddress());
        U8Pointer u8Pointer2 = this.heapAddrToCardAddr(gCHeapRegionDescriptor.getHighAddress());
        this.cleanRange(u8Pointer, u8Pointer2, gCCardCleaner);
    }

    public void cleanCardsInRegions(Iterator<GCHeapRegionDescriptor> iterator, GCCardCleaner gCCardCleaner) throws CorruptDataException {
        while (iterator.hasNext()) {
            GCHeapRegionDescriptor gCHeapRegionDescriptor = iterator.next();
            this.cleanCardsInRegion(gCHeapRegionDescriptor, gCCardCleaner);
        }
    }
}

