/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.view.dtfj.image;

import com.ibm.dtfj.image.Image;
import com.ibm.dtfj.image.ImageFactory;
import com.ibm.dtfj.utils.file.FileManager;
import com.ibm.dtfj.utils.file.ImageSourceType;
import com.ibm.dtfj.utils.file.J9FileImageInputStream;
import com.ibm.dtfj.utils.file.ManagedImageSource;
import com.ibm.j9ddr.corereaders.CoreReader;
import com.ibm.j9ddr.corereaders.ICore;
import com.ibm.j9ddr.util.WeakValueMap;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImage;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.stream.ImageInputStream;

public class J9DDRImageFactory
implements ImageFactory {
    public static final int DTFJ_MAJOR_VERSION = 1;
    public static final int DTFJ_MINOR_VERSION = 11;
    public static final int DTFJ_MODIFICATION_LEVEL = 28001;
    private static WeakValueMap<File, J9DDRImage> imageMap = new WeakValueMap();

    public int getDTFJMajorVersion() {
        return 1;
    }

    public int getDTFJMinorVersion() {
        return 11;
    }

    public int getDTFJModificationLevel() {
        return 28001;
    }

    public Image[] getImagesFromArchive(File file, boolean bl) throws IOException {
        return new Image[0];
    }

    public Image getImage(ImageInputStream imageInputStream, ImageInputStream imageInputStream2, URI uRI) throws IOException {
        ICore iCore;
        Logger logger = Logger.getLogger("j9ddr.core_readers");
        Logger logger2 = Logger.getLogger("j9ddr.view.dtfj");
        logger.setParent(logger2);
        if (logger2.getLevel() == null && logger.getLevel() == null) {
            logger.setLevel(Level.SEVERE);
        }
        if ((iCore = CoreReader.readCoreFile(imageInputStream)) == null) {
            return null;
        }
        return new J9DDRImage(uRI, iCore, imageInputStream2);
    }

    public Image getImage(File file) throws IOException {
        ICore iCore;
        J9DDRImage j9DDRImage = imageMap.get(file.getAbsoluteFile());
        if (j9DDRImage != null && !j9DDRImage.isClosed()) {
            return j9DDRImage;
        }
        Logger logger = Logger.getLogger("j9ddr.core_readers");
        Logger logger2 = Logger.getLogger("j9ddr.view.dtfj");
        logger.setParent(logger2);
        if (logger2.getLevel() == null && logger.getLevel() == null) {
            logger.setLevel(Level.SEVERE);
        }
        if ((iCore = CoreReader.readCoreFile(file.getPath())) == null) {
            return null;
        }
        j9DDRImage = new J9DDRImage(file.toURI(), iCore, null);
        imageMap.put(file.getAbsoluteFile(), j9DDRImage);
        return j9DDRImage;
    }

    public Image getImage(ImageInputStream imageInputStream, URI uRI) throws IOException {
        return this.getImage(imageInputStream, null, uRI);
    }

    public Image getImage(File file, File file2) throws IOException {
        if (FileManager.isArchive((File)file2)) {
            ManagedImageSource managedImageSource = new ManagedImageSource(file.getName(), ImageSourceType.CORE);
            managedImageSource.setArchive(file2);
            managedImageSource.setExtractedTo(file);
            managedImageSource.setPath(file.getAbsolutePath());
            J9FileImageInputStream j9FileImageInputStream = new J9FileImageInputStream(file, managedImageSource);
            return this.getImage((ImageInputStream)j9FileImageInputStream, null, managedImageSource.getURIOfExtractedFile());
        }
        return this.getImage(file);
    }
}

