/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class IteratorHelpers {
    public static <T> Iterator<T> combineIterators(final Iterator<T> ... iteratorArray) {
        return new Iterator<T>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                while (this.index < iteratorArray.length) {
                    if (iteratorArray[this.index].hasNext()) {
                        return true;
                    }
                    ++this.index;
                }
                return false;
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    return iteratorArray[this.index].next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <T> List<T> toList(Iterator<T> iterator) {
        ArrayList<T> arrayList = new ArrayList<T>();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    public static <T> Iterator<T> filterIterator(final Iterator<T> iterator, final IteratorFilter<T> iteratorFilter) {
        return new Iterator<T>(){
            private T current;

            @Override
            public boolean hasNext() {
                if (this.current != null) {
                    return true;
                }
                while (this.current == null && iterator.hasNext()) {
                    Object e = iterator.next();
                    if (!iteratorFilter.accept(e)) continue;
                    this.current = e;
                    return true;
                }
                return false;
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    Object t = this.current;
                    this.current = null;
                    return t;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static interface IteratorFilter<T> {
        public boolean accept(T var1);
    }
}

