/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.ddrinteractive;

import com.ibm.j9ddr.StructureReader;
import com.ibm.j9ddr.StructureTypeManager;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import java.util.HashMap;
import java.util.Map;

public class StructureCommandUtil {
    public static Context cachedContext;
    public static Map<String, StructureReader.StructureDescriptor> structureMap;
    public static StructureTypeManager typeManager;
    private static String pointerFormatString;

    public static Map<String, StructureReader.StructureDescriptor> getStructureMap(Context context) {
        StructureCommandUtil.checkContextCache(context);
        return structureMap;
    }

    public static StructureReader.StructureDescriptor getStructureDescriptor(String string, Context context) {
        StructureCommandUtil.checkContextCache(context);
        return structureMap.get(string.toLowerCase());
    }

    public static int getTypeCode(String string, Context context) {
        StructureCommandUtil.checkContextCache(context);
        return typeManager.getType(string);
    }

    public static String typeToCommand(String string) {
        string = string.replace("struct", "");
        string = string.replace("class", "");
        string = string.replace("*", "");
        string = string.trim();
        return "!" + string.toLowerCase();
    }

    private static void checkContextCache(Context context) {
        if (context != cachedContext) {
            cachedContext = context;
            StructureCommandUtil.loadStructureMap();
        }
    }

    private static void loadStructureMap() {
        structureMap = new HashMap<String, StructureReader.StructureDescriptor>();
        for (StructureReader.StructureDescriptor structureDescriptor : StructureCommandUtil.cachedContext.vmData.getStructures()) {
            structureMap.put(structureDescriptor.getName().toLowerCase(), structureDescriptor);
        }
        typeManager = new StructureTypeManager(StructureCommandUtil.cachedContext.vmData.getStructures());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("0x%0");
        stringBuilder.append(2 * StructureCommandUtil.cachedContext.process.bytesPerPointer());
        stringBuilder.append("X");
        pointerFormatString = stringBuilder.toString();
    }

    public static String formatPointer(long l, Context context) {
        StructureCommandUtil.checkContextCache(context);
        return String.format(pointerFormatString, l);
    }
}

