/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.ddrinteractive;

import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class ExtractMemoryCommand
extends Command {
    public ExtractMemoryCommand() {
        this.addCommand("extractmemory", "<hexAddress> <hexLength> <filename>", "Dump the specified memory range to a binary file");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        FileOutputStream fileOutputStream;
        if (stringArray.length != 3) {
            printStream.println("Unexpected number of arguments.");
            this.printUsage(printStream);
            return;
        }
        long l = 0L;
        l = stringArray[0].startsWith("0x") ? Long.parseLong(stringArray[0].substring(2), 16) : Long.parseLong(stringArray[0], 16);
        int n = 0;
        n = stringArray[1].startsWith("0x") ? Integer.parseInt(stringArray[1].substring(2), 16) : Integer.parseInt(stringArray[1], 16);
        String string2 = stringArray[2];
        try {
            fileOutputStream = new FileOutputStream(string2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new DDRInteractiveCommandException("Failed to open output file " + string2, fileNotFoundException);
        }
        try {
            byte[] byArray = new byte[n];
            context.process.getBytesAt(l, byArray);
            try {
                fileOutputStream.write(byArray, 0, n);
            }
            catch (IOException iOException) {
                throw new DDRInteractiveCommandException("Failed to write data to file " + string2, iOException);
            }
            finally {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (MemoryFault memoryFault) {
            throw new DDRInteractiveCommandException("Unable to read memory range", memoryFault);
        }
    }

    private void printUsage(PrintStream printStream) {
        printStream.println("Usage:\n  !extractmemory <hexAddress> <hexLength> <filename>");
    }
}

