/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.libraries;

import com.ibm.j9ddr.corereaders.ILibraryResolver;
import com.ibm.j9ddr.corereaders.LibraryDataSource;
import com.ibm.j9ddr.libraries.Footer;
import com.ibm.j9ddr.libraries.FooterLibraryEntry;
import com.ibm.j9ddr.libraries.SlidingFileInputStream;
import com.ibm.j9ddr.libraries.SlidingImageInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.nio.ByteOrder;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;

public class CoreFileResolver
implements ILibraryResolver {
    public static final int FOOTER_MAGIC = 514789549;
    public static final byte[] FOOTER_MAGIC_BYTES = new byte[]{30, -81, 16, -83};
    private static final Logger logger = Logger.getLogger("com.ibm.j9ddr.libraries");
    protected final File coreFile;
    protected ImageInputStream stream;
    protected boolean validFile = false;
    protected Footer footer = null;

    public static void main(String[] stringArray) {
        CoreFileResolver coreFileResolver = new CoreFileResolver(stringArray[0]);
    }

    public CoreFileResolver(String string) {
        this.coreFile = new File(string);
        this.validateCoreFile();
    }

    public CoreFileResolver(File file) {
        this.coreFile = file;
        this.validateCoreFile();
    }

    public CoreFileResolver(ImageInputStream imageInputStream) {
        this.coreFile = null;
        this.stream = imageInputStream;
        this.validateContents();
    }

    private void validateCoreFile() {
        if (this.coreFile.exists()) {
            try {
                if (this.stream == null) {
                    this.stream = new FileImageInputStream(this.coreFile);
                }
                this.validateContents();
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new IllegalArgumentException("The core file specified at " + this.coreFile.getAbsolutePath() + " does not exist");
            }
            catch (IOException iOException) {
                logger.log(Level.WARNING, "Could not validate core file " + this.coreFile.getAbsolutePath(), iOException);
                return;
            }
        } else {
            throw new IllegalArgumentException("The core file specified at " + this.coreFile.getAbsolutePath() + " does not exist");
        }
    }

    private void validateContents() {
        this.validFile = this.isValidFile();
        if (!this.validFile) {
            try {
                if (this.coreFile != null) {
                    this.stream.close();
                }
            }
            catch (IOException iOException) {
                logger.log(Level.WARNING, "Could not close core file", iOException);
                return;
            }
        }
    }

    public void extractLibrariesToDir(String string) throws IOException {
        File file = new File(string);
        if (!file.exists()) {
            throw new IllegalArgumentException("");
        }
        for (FooterLibraryEntry footerLibraryEntry : this.footer.getEntries()) {
            File file2 = new File(file, footerLibraryEntry.getName());
            this.extractLibrary(footerLibraryEntry.getPath(), file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extractLibrary(String string, File file) throws IOException {
        FooterLibraryEntry footerLibraryEntry = this.footer.findEntry(string);
        FileOutputStream fileOutputStream = null;
        InputStream inputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            byte[] byArray = new byte[4096];
            inputStream = new SlidingFileInputStream(this.coreFile, footerLibraryEntry.getStart(), (long)footerLibraryEntry.getSize());
            int n = inputStream.read(byArray);
            while (n != -1) {
                fileOutputStream.write(byArray, 0, n);
                n = inputStream.read(byArray);
            }
        }
        finally {
            inputStream.close();
            fileOutputStream.close();
        }
    }

    public boolean hasLibraries() {
        return this.validFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFooter() throws IOException {
        ByteOrder byteOrder = this.stream.getByteOrder();
        try {
            this.stream.setByteOrder(ByteOrder.BIG_ENDIAN);
            long l = this.stream.length();
            this.stream.seek(l - 8L);
            int n = this.stream.readInt();
            SlidingFileInputStream slidingFileInputStream = new SlidingFileInputStream(this.stream, l - (long)n - 8L, (long)n);
            ObjectInputStream objectInputStream = new ObjectInputStream(slidingFileInputStream);
            try {
                this.footer = (Footer)objectInputStream.readObject();
                logger.fine(this.footer.toString());
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.log(Level.WARNING, "Could find footer class", classNotFoundException);
            }
            objectInputStream.close();
        }
        finally {
            this.stream.setByteOrder(byteOrder);
        }
    }

    private boolean isValidFile() {
        try {
            byte[] byArray = new byte[FOOTER_MAGIC_BYTES.length];
            this.stream.seek(this.stream.length() - (long)byArray.length);
            this.stream.readFully(byArray);
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] == FOOTER_MAGIC_BYTES[i]) continue;
                return false;
            }
            this.readFooter();
            return true;
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "Could not check core file library validity", iOException);
            return false;
        }
    }

    @Override
    public LibraryDataSource getLibrary(String string, boolean bl) throws FileNotFoundException {
        LibraryDataSource libraryDataSource;
        if (!this.validFile) {
            throw new FileNotFoundException("Cannot find " + string + " as the required libraries are missing from the core file");
        }
        FooterLibraryEntry footerLibraryEntry = this.footer.findEntry(string);
        if (footerLibraryEntry == null) {
            if (!bl) {
                logger.fine(String.format("Cannot find %s", string));
            }
            throw new FileNotFoundException("Cannot find " + string);
        }
        try {
            SlidingImageInputStream slidingImageInputStream = new SlidingImageInputStream(this.stream, footerLibraryEntry.getStart(), (long)footerLibraryEntry.getSize());
            libraryDataSource = new LibraryDataSource(string, slidingImageInputStream);
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "Error setting sliding input window", iOException);
            libraryDataSource = new LibraryDataSource(string);
        }
        return libraryDataSource;
    }

    @Override
    public LibraryDataSource getLibrary(String string) throws FileNotFoundException {
        if (!this.validFile) {
            throw new FileNotFoundException("Cannot find " + string + " as the required libraries are missing from the core file");
        }
        return this.getLibrary(string, true);
    }

    @Override
    public void dispose() {
        try {
            if (this.validFile) {
                this.stream.close();
            }
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "Failed to dispose of underlying file stream", iOException);
        }
    }
}

