/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.memory;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.DataUnavailableException;
import com.ibm.j9ddr.corereaders.memory.Addresses;
import com.ibm.j9ddr.corereaders.memory.IMemoryRange;
import com.ibm.j9ddr.corereaders.memory.IModule;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.corereaders.memory.ISymbol;
import com.ibm.j9ddr.corereaders.memory.Symbol;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.WeakHashMap;

public class SymbolUtil {
    private static WeakHashMap<IModule, List<ISymbol>> extraSymbolsMap = new WeakHashMap();

    protected static String getProcedureNameForAddress(IProcess iProcess, long l, boolean bl) throws DataUnavailableException, CorruptDataException {
        String string = SymbolUtil.getNameExactMatch(iProcess, l, bl);
        if (string == null) {
            string = SymbolUtil.getNameBestMatch(iProcess, l, bl);
        }
        if (string == null) {
            return "<unknown location>";
        }
        return string;
    }

    private static String getNameExactMatch(IProcess iProcess, long l, boolean bl) throws DataUnavailableException, CorruptDataException {
        Collection<? extends IModule> collection = iProcess.getModules();
        IModule object2 = null;
        block0: for (IModule object3 : collection) {
            for (IMemoryRange iMemoryRange : object3.getMemoryRanges()) {
                if (!iMemoryRange.contains(l)) continue;
                object2 = object3;
                break block0;
            }
        }
        if (object2 == null) {
            return null;
        }
        List<ISymbol> list = SymbolUtil.getSymbols(object2);
        ISymbol iSymbol = SymbolUtil.findClosestSymbol(l, (List<? extends ISymbol>)list);
        if (iSymbol != null) {
            long l3 = l - iSymbol.getAddress();
            if (l3 < 0x100000L) {
                return object2.getName() + "::" + SymbolUtil.getSymbolName(iSymbol, bl) + "+0x" + Long.toHexString(l3);
            }
            return null;
        }
        long l2 = SymbolUtil.getDelta(l, object2, null);
        return object2.getName() + "+0x" + Long.toHexString(l2);
    }

    private static String getNameBestMatch(IProcess iProcess, long l, boolean bl) {
        Object object;
        Object object2;
        Object object3 = null;
        Object object4 = null;
        long l2 = Long.MAX_VALUE;
        String string = null;
        try {
            long l3;
            object2 = iProcess.getExecutable();
            ArrayList<ISymbol> object5 = new ArrayList<ISymbol>();
            if (object2 != null) {
                object5.addAll(SymbolUtil.getSymbols((IModule)object2));
            }
            if ((l3 = SymbolUtil.getDelta(l, (IModule)object2, (ISymbol)(object = SymbolUtil.findClosestSymbol(l, object5)))) >= 0L && l3 < l2) {
                object3 = object2;
                string = object2.getName();
                object4 = object;
                l2 = l3;
            }
        }
        catch (CorruptDataException corruptDataException) {
        }
        catch (DataUnavailableException dataUnavailableException) {
            // empty catch block
        }
        try {
            for (IModule iModule : iProcess.getModules()) {
                ISymbol iSymbol;
                long l4 = SymbolUtil.getDelta(l, iModule, iSymbol = SymbolUtil.findClosestSymbol(l, (List<? extends ISymbol>)(object = new ArrayList<ISymbol>(SymbolUtil.getSymbols(iModule)))));
                if (l4 < 0L || l4 >= l2) continue;
                object3 = iModule;
                string = iModule.getName();
                object4 = iSymbol;
                l2 = l4;
            }
        }
        catch (DataUnavailableException dataUnavailableException) {
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
        if (null != object3) {
            object2 = "";
            object2 = l2 == Long.MAX_VALUE ? "<offset not available>" : (l2 >= 0L ? "+0x" + Long.toHexString(l2) : "-0x" + Long.toHexString(l2));
            if (null != object4) {
                return string + "::" + SymbolUtil.getSymbolName(object4, bl) + (String)object2;
            }
            return string + (String)object2;
        }
        return null;
    }

    private static long getDelta(long l, IModule iModule, ISymbol iSymbol) throws CorruptDataException {
        long l2 = 0L;
        l2 = iSymbol != null ? l - iSymbol.getAddress() : l - iModule.getLoadAddress();
        return l2;
    }

    private static ISymbol findClosestSymbol(long l, List<? extends ISymbol> list) {
        Collections.sort(list, new SymbolComparator());
        ISymbol iSymbol = null;
        for (ISymbol iSymbol2 : list) {
            if (!Addresses.lessThanOrEqual(iSymbol2.getAddress(), l)) break;
            if (iSymbol != null && iSymbol.getAddress() == iSymbol2.getAddress()) continue;
            iSymbol = iSymbol2;
        }
        return iSymbol;
    }

    private static List<ISymbol> getSymbols(IModule iModule) throws DataUnavailableException {
        if (!extraSymbolsMap.containsKey(iModule)) {
            return new ArrayList<ISymbol>(iModule.getSymbols());
        }
        Collection<? extends ISymbol> collection = iModule.getSymbols();
        List<ISymbol> list = extraSymbolsMap.get(iModule);
        ArrayList<ISymbol> arrayList = new ArrayList<ISymbol>(collection.size() + list.size());
        arrayList.addAll(collection);
        arrayList.addAll(list);
        Collections.sort(arrayList, new SymbolComparator());
        return arrayList;
    }

    private static String getSymbolName(ISymbol iSymbol, boolean bl) {
        if (!bl && iSymbol instanceof DDRSymbol) {
            return ((DDRSymbol)iSymbol).getddrName();
        }
        return iSymbol.getName();
    }

    public static void addDDRSymbolToModule(IModule iModule, String string, String string2, long l) {
        List<ISymbol> list = extraSymbolsMap.get(iModule);
        DDRSymbol dDRSymbol = new DDRSymbol(string, string2, l);
        if (list == null) {
            list = new LinkedList<ISymbol>();
            list.add(dDRSymbol);
            extraSymbolsMap.put(iModule, list);
        } else {
            list = extraSymbolsMap.get(iModule);
            list.add(dDRSymbol);
        }
        Collections.sort(list, new SymbolComparator());
    }

    private static class DDRSymbol
    extends Symbol {
        private String ddrName;

        public DDRSymbol(String string, String string2, long l) {
            super(string, l);
            this.ddrName = string2;
        }

        public String getddrName() {
            return this.ddrName;
        }
    }

    private static final class SymbolComparator
    implements Comparator<ISymbol> {
        private SymbolComparator() {
        }

        @Override
        public int compare(ISymbol iSymbol, ISymbol iSymbol2) {
            if (iSymbol.getAddress() > iSymbol2.getAddress()) {
                return 1;
            }
            if (iSymbol.getAddress() < iSymbol2.getAddress()) {
                return -1;
            }
            return 0;
        }
    }
}

