/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.aix;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.corereaders.osthread.IOSStackFrame;
import com.ibm.j9ddr.corereaders.osthread.IOSThread;
import com.ibm.j9ddr.corereaders.osthread.OSStackFrame;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class BaseAIXOSThread
implements IOSThread {
    private static final Logger logger = Logger.getLogger("j9ddr.core_readers");
    protected final IProcess process;
    private List<IOSStackFrame> frames;

    protected BaseAIXOSThread(IProcess iProcess) {
        this.process = iProcess;
    }

    @Override
    public List<? extends IOSStackFrame> getStackFrames() {
        if (this.frames == null) {
            this.walkStack();
        }
        return Collections.unmodifiableList(this.frames);
    }

    private void walkStack() {
        this.frames = new LinkedList<IOSStackFrame>();
        long l = this.getStackPointer();
        long l2 = this.getInstructionPointer();
        if (0L == l2 || !this.isValidAddress(l2)) {
            l2 = this.getBasePointer();
        }
        try {
            if (0L != l2 && 0L != l && this.isValidAddress(l2) && this.isValidAddress(l)) {
                this.frames.add(new OSStackFrame(l, l2));
                long l3 = -1L;
                long l4 = this.process.bytesPerPointer();
                int n = 0;
                while (l3 != l && n++ < 256) {
                    l3 = l;
                    l = this.process.getPointerAt(l);
                    long l5 = l + l4;
                    l2 = this.process.getPointerAt(l5 += l4);
                    this.frames.add(new OSStackFrame(l, l2));
                }
            } else {
                logger.logp(Level.WARNING, "com.ibm.j9ddr.corereaders.aix.BaseAIXOSThread", "walkStack", "MISSED");
            }
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
    }

    private boolean isValidAddress(long l) {
        try {
            this.process.getByteAt(l);
            return true;
        }
        catch (MemoryFault memoryFault) {
            return false;
        }
    }

    @Override
    public abstract long getStackPointer();

    @Override
    public abstract long getInstructionPointer();

    @Override
    public abstract long getBasePointer();
}

