/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CTypeParser {
    private static final Pattern arrayPattern = Pattern.compile("(.*?)\\s*((?:\\[[^\\]]*\\]\\s*)+)$");
    private static final Pattern pointerPattern = Pattern.compile("(.*?)\\s*((?:[*]\\s*)+)$");
    private static final Pattern bitfieldPattern = Pattern.compile("(.*?)\\s*(:\\s*\\d+)$");
    private static final Pattern trailingConstPattern = Pattern.compile("(.*?)(?<=[\\s*])const$");
    private static final Pattern trailingVolatilePattern = Pattern.compile("(.*?)(?<=[\\s*])volatile$");
    private String suffix;
    private String prefix;
    private String coreType;

    public CTypeParser(String string) {
        this.coreType = string.trim();
        this.prefix = "";
        this.coreType = this.coreType.replace("::", "$");
        if (this.coreType.startsWith("const ")) {
            this.prefix = "const ";
            this.coreType = this.coreType.substring("const".length()).trim();
        }
        if (this.coreType.startsWith("volatile ")) {
            this.prefix = "volatile ";
            this.coreType = this.coreType.substring("volatile".length()).trim();
        }
        StringBuilder stringBuilder = new StringBuilder();
        while (true) {
            Matcher matcher;
            if ((matcher = arrayPattern.matcher(this.coreType)).find()) {
                this.coreType = matcher.group(1);
                stringBuilder.insert(0, this.stripSpaces(matcher.group(2)));
            } else {
                matcher = pointerPattern.matcher(this.coreType);
                if (matcher.find()) {
                    this.coreType = matcher.group(1);
                    stringBuilder.insert(0, this.stripSpaces(matcher.group(2)));
                } else {
                    matcher = bitfieldPattern.matcher(this.coreType);
                    if (matcher.find()) {
                        this.coreType = matcher.group(1);
                        stringBuilder.insert(0, this.stripSpaces(matcher.group(2)));
                    } else {
                        matcher = trailingConstPattern.matcher(this.coreType);
                        if (matcher.find()) {
                            this.coreType = matcher.group(1);
                            stringBuilder.insert(0, " const ");
                        } else {
                            matcher = trailingVolatilePattern.matcher(this.coreType);
                            if (!matcher.find()) break;
                            this.coreType = matcher.group(1);
                            stringBuilder.insert(0, " volatile ");
                        }
                    }
                }
            }
            this.coreType = this.coreType.trim();
        }
        this.suffix = stringBuilder.toString().trim();
    }

    private String stripSpaces(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (char c : string.toCharArray()) {
            if (Character.isWhitespace(c)) continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getCoreType() {
        return this.coreType;
    }

    public String getSuffix() {
        return this.suffix;
    }
}

