/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.tools.impl;

import com.ibm.jvm.dtfjview.tools.CommandException;
import com.ibm.jvm.dtfjview.tools.IPipe;
import com.ibm.jvm.dtfjview.tools.Tool;
import com.ibm.jvm.dtfjview.tools.ToolsRegistry;
import com.ibm.jvm.dtfjview.tools.utils.BlockPostmatchHandle;
import com.ibm.jvm.dtfjview.tools.utils.BlockPrematchHandle;
import com.ibm.jvm.dtfjview.tools.utils.IMatchHandle;
import com.ibm.jvm.dtfjview.tools.utils.IPostmatchHandle;
import com.ibm.jvm.dtfjview.tools.utils.IPrematchHandle;
import com.ibm.jvm.dtfjview.tools.utils.MatchHandle;
import com.ibm.jvm.dtfjview.tools.utils.MaxLinesPostmatchHandle;
import com.ibm.jvm.dtfjview.tools.utils.MaxLinesPrematchHandle;
import com.ibm.jvm.dtfjview.tools.utils.OutputStreamModifier;
import com.ibm.jvm.dtfjview.tools.utils.RegExprMatchHandle;
import com.ibm.jvm.dtfjview.tools.utils.StringModifier;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class GrepTool
extends Tool
implements IPipe {
    public static final String COMMAND = "grep";
    public static final String COMMAND_NEGATE = "grep-";
    public static final String ARGUMENT_DESCRIPTION = "[options] <pattern>";
    public static final String HELP_DESCRIPTION = "to be used after the pipeline to show lines which match a pattern.";
    public static final String USAGE = "grep\t[options] <pattern>\tto be used after the pipeline to show lines which match a pattern.\n     Options :\n          -i : Ignore case.\n          -r, -G, --regex : Use regular expression as defined in the Java documentation of class java.utils.regex.Pattern.\n          -b, --block : show the block of lines when at least one of the lines matches the pattern.  Block of lines are separated by empty lines.\n          -A <NUM>, +<NUM> : Show at most <NUM> lines after the matching line.\n          -B <NUM>, -<NUM> : show at most <NUM> lines after the matching line.\n          -C <NUM>, +-<NUM> : show at most <NUM> lines before and after the matching line.\n          -v, --invert-match : to be used with command grep to show the lines which does not match the pattern, equivalent to using command grep-.\n          -F, --fixed-strings : to treat character '*' not as a wide card. This option can not be used together with -r, -G or --regex.\n     Pattern : \n           Character '*' in a pattern will be treated as a wild card unless option -F or --fixed-strings is used.\n           If a pattern contains any spaces, enclose the pattern in a pair of double quotation marks.\n           If a pattern contains any double quotation marks, enclose the pattern in a pair of single quotation marks.\n           The pattern can be in the following format to show lines which match any of the sub-patterns:\n                    \"[<pattern1>|<pattern2>|...|<patternN>]\"\n               This format has to start with \"[ and ends with ]\" and use character '|' as the sub-pattern separator.\n               No quotation marks and character '|' are allowed in any sub-patterns.\n               Spaces are allowed in the middle of a sub-patterns, but leading and trailing spaces will be trimmed.\n               This format only works when option -r, -G, and --regex are not used.\n     Use command grep- to show lines which do not match the pattern.";

    @Override
    public boolean accept(String string, String[] stringArray) {
        return string.equalsIgnoreCase(COMMAND) || string.equalsIgnoreCase(COMMAND_NEGATE);
    }

    @Override
    public void process(String string, String[] stringArray, PrintStream printStream) throws CommandException {
        Attributes attributes = null;
        try {
            attributes = this.readAttributes(string, stringArray, string.equalsIgnoreCase(COMMAND_NEGATE), printStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (attributes == null) {
            printStream.println(USAGE);
            return;
        }
        IPrematchHandle iPrematchHandle = null;
        iPrematchHandle = attributes.matchBlock ? new BlockPrematchHandle() : new MaxLinesPrematchHandle(attributes.maxPreviousLines);
        IMatchHandle iMatchHandle = null;
        iMatchHandle = attributes.useRegularExpression ? new RegExprMatchHandle(attributes.normalStringsToGrep, attributes.caseInsensitive, attributes.negate) : new MatchHandle(attributes.normalStringsToGrep, attributes.caseInsensitive, attributes.negate, attributes.isFixedString);
        IPostmatchHandle iPostmatchHandle = null;
        iPostmatchHandle = attributes.matchBlock ? new BlockPostmatchHandle() : new MaxLinesPostmatchHandle(attributes.maxNextLines);
        ToolsRegistry.process(attributes.nextCommand, attributes.nextCommandArgs, new PrintStream(new OutputStreamModifier(printStream, new StringModifier(iPrematchHandle, iMatchHandle, iPostmatchHandle))));
    }

    @Override
    public void printDetailedHelp(PrintStream printStream) {
        printStream.println(USAGE);
    }

    @Override
    public String getCommandName() {
        return COMMAND;
    }

    @Override
    public String getArgumentDescription() {
        return ARGUMENT_DESCRIPTION;
    }

    @Override
    public String getHelpDescription() {
        return HELP_DESCRIPTION;
    }

    private Attributes readAttributes(String string, String[] stringArray, boolean bl, PrintStream printStream) {
        if (2 > stringArray.length) {
            return null;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        String string2 = null;
        String string3 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        int n2 = 0;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!bl7 && stringArray[i].equals("-i")) {
                bl3 = true;
                continue;
            }
            if (!bl7 && (stringArray[i].equals("-b") || stringArray[i].equals("--block"))) {
                bl4 = true;
                continue;
            }
            if (!bl7 && (stringArray[i].equals("-r") || stringArray[i].equals("-G") || stringArray[i].equals("--regex"))) {
                bl2 = true;
                continue;
            }
            if (!bl7 && (stringArray[i].equals("-F") || stringArray[i].equals("--fixed-strings"))) {
                bl6 = true;
                continue;
            }
            if (!bl7 && stringArray[i].equals("-C")) {
                if (i < stringArray.length - 1) {
                    ++i;
                    try {
                        n2 = n = Integer.parseInt(stringArray[i]);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        printStream.println("Option -C is not followed by a number; instead it is followed by token " + stringArray[i]);
                        return null;
                    }
                }
                printStream.println("Option -C is not followed by a number.");
                return null;
            }
            if (!bl7 && (stringArray[i].startsWith("-+") || stringArray[i].startsWith("+-"))) {
                try {
                    n2 = n = Integer.parseInt(stringArray[i].substring(2));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (!bl7 && stringArray[i].equals("-A")) {
                if (i < stringArray.length - 1) {
                    ++i;
                    try {
                        n2 = Integer.parseInt(stringArray[i]);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        printStream.println("Option -A is not followed by a number; instead it is followed by token " + stringArray[i]);
                        return null;
                    }
                }
                printStream.println("Option -A is not followed by a number.");
                return null;
            }
            if (!bl7 && stringArray[i].startsWith("+")) {
                try {
                    n2 = Integer.parseInt(stringArray[i].substring(1));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (!bl7 && (stringArray[i].equals("-v") || stringArray[i].equalsIgnoreCase("--invert-match"))) {
                bl5 = true;
                continue;
            }
            if (!bl7 && stringArray[i].equals("-B")) {
                if (i < stringArray.length - 1) {
                    ++i;
                    try {
                        n = Integer.parseInt(stringArray[i]);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        printStream.println("Option -B is not followed by a number; instead it is followed by token " + stringArray[i]);
                        return null;
                    }
                }
                printStream.println("Option -B is not followed by a number.");
                return null;
            }
            if (!bl7 && stringArray[i].startsWith("-")) {
                try {
                    n = Integer.parseInt(stringArray[i].substring(1));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            bl7 = true;
            if (string2 == null) {
                string2 = stringArray[i];
                continue;
            }
            if (string3 == null) {
                string3 = stringArray[i];
                continue;
            }
            arrayList.add(stringArray[i]);
        }
        if (null == string2 || null == string3) {
            printStream.println("The grep/grep- command can only be used after the pipeline.");
            return null;
        }
        if (bl5) {
            if (string.equalsIgnoreCase(COMMAND_NEGATE)) {
                printStream.println("Option -v can not be used with command grep-.");
                return null;
            }
            if (!bl) {
                bl = true;
            }
        }
        if (bl6 && bl2) {
            printStream.println("Option -F and --fixed-strings can not be used with option -r, -G, or --regex.");
            return null;
        }
        return new Attributes(bl, bl2, bl3, string2, string3, arrayList.toArray(new String[arrayList.size()]), n, n2, bl4, bl6);
    }

    private class Attributes {
        public boolean negate = false;
        public boolean useRegularExpression = false;
        public boolean caseInsensitive = false;
        public String nextCommand = null;
        public String[] nextCommandArgs = null;
        public int maxPreviousLines = 0;
        public int maxNextLines = 0;
        public boolean matchBlock = false;
        public boolean isFixedString = false;
        public String[] normalStringsToGrep = null;

        public Attributes(boolean bl, boolean bl2, boolean bl3, String string, String string2, String[] stringArray, int n, int n2, boolean bl4, boolean bl5) {
            this.negate = bl;
            this.useRegularExpression = bl2;
            this.caseInsensitive = bl3;
            this.nextCommand = string2;
            this.nextCommandArgs = stringArray;
            this.maxPreviousLines = n;
            this.maxNextLines = n2;
            this.matchBlock = bl4;
            this.isFixedString = bl5;
            this.normalStringsToGrep = this.extractNormalStringsToGrep(string);
        }

        private String[] extractNormalStringsToGrep(String string) {
            if (this.useRegularExpression || !string.startsWith("[") || !string.endsWith("]")) {
                return new String[]{string};
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string.substring(1, string.length() - 1), "|");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2.trim().length() <= 0) continue;
                arrayList.add(string2.trim());
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }
    }
}

